#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSError.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSSet.h>
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>

@class THHAction, THHActionCompanion, THHActionJob, THHAppInformation, THHAppModule, THHBRIPaymentMethod, THHBRIPaymentMethodCompanion, THHBRITerminalAction, THHBRITerminalActionCompanion, THHBaseDatabaseHandler, THHBaseFakeResponseGenerator, THHBaseSecurity, THHBaseTerminal, THHBaseTerminalBRI, THHBaseTerminalCashup, THHBaseTerminalGateway, THHBaseTerminalNTT, THHBaseTerminalOperation, THHBaseTerminalSHC, THHBluetoothData<T>, THHBriEDCWebSocketService, THHBriStatus, THHBriStatusCompanion, THHCashupAction, THHCashupPaymentMethod, THHCashupPaymentMethodCompanion, THHCashupTerminalResult, THHCashupTerminalResultCompanion, THHCheckVersionRequest, THHCheckVersionRequestCompanion, THHCommand, THHCommandCompanion, THHCommandConstants, THHCommandType, THHCommandTypeCompanion, THHConnectionState, THHConnectionType, THHDatabaseCompanion, THHDatabaseHandler, THHDriverFactory, THHEppDetails, THHEppDetailsCompanion, THHError, THHErrorCode, THHErrorCodeCompanion, THHErrorCompanion, THHErrorData, THHErrorDataCompanion, THHFakeResponseGenerator, THHFakeResponseGenerator_, THHFakeResponseGenerator__, THHGenericPaymentMethod, THHGenericPaymentMethodCompanion, THHInternalNetworkService, THHInternalNetworkServiceCompanion, THHKermitLogger, THHKermitLoggerCompanion, THHKermit_coreBaseLogger, THHKermit_coreLogWriter, THHKermit_coreSeverity, THHKermit_ioRollingFileLogWriter, THHKermit_ioRollingFileLogWriterConfig, THHKotlinAbstractCoroutineContextElement, THHKotlinAbstractCoroutineContextKey<B, E>, THHKotlinArray<T>, THHKotlinByteArray, THHKotlinByteIterator, THHKotlinCancellationException, THHKotlinEnum<E>, THHKotlinEnumCompanion, THHKotlinException, THHKotlinIllegalStateException, THHKotlinInstant, THHKotlinInstantCompanion, THHKotlinKTypeProjection, THHKotlinKTypeProjectionCompanion, THHKotlinKVariance, THHKotlinNothing, THHKotlinPair<__covariant A, __covariant B>, THHKotlinRuntimeException, THHKotlinThrowable, THHKotlinUnit, THHKotlinx_coroutines_coreCoroutineDispatcher, THHKotlinx_coroutines_coreCoroutineDispatcherKey, THHKotlinx_datetimeDayOfWeek, THHKotlinx_datetimeDayOfWeekNames, THHKotlinx_datetimeDayOfWeekNamesCompanion, THHKotlinx_datetimeFixedOffsetTimeZone, THHKotlinx_datetimeFixedOffsetTimeZoneCompanion, THHKotlinx_datetimeLocalDate, THHKotlinx_datetimeLocalDateCompanion, THHKotlinx_datetimeLocalDateProgression, THHKotlinx_datetimeLocalDateProgressionCompanion, THHKotlinx_datetimeLocalDateRange, THHKotlinx_datetimeLocalDateRangeCompanion, THHKotlinx_datetimeLocalDateTime, THHKotlinx_datetimeLocalDateTimeCompanion, THHKotlinx_datetimeLocalTime, THHKotlinx_datetimeLocalTimeCompanion, THHKotlinx_datetimeMonth, THHKotlinx_datetimeMonthNames, THHKotlinx_datetimeMonthNamesCompanion, THHKotlinx_datetimeOverloadMarker, THHKotlinx_datetimePadding, THHKotlinx_datetimeTimeZone, THHKotlinx_datetimeTimeZoneCompanion, THHKotlinx_datetimeUtcOffset, THHKotlinx_datetimeUtcOffsetCompanion, THHKotlinx_io_coreBuffer, THHKotlinx_io_coreFileMetadata, THHKotlinx_io_corePath, THHKotlinx_serialization_coreSerialKind, THHKotlinx_serialization_coreSerializersModule, THHKotlinx_serialization_jsonClassDiscriminatorMode, THHKotlinx_serialization_jsonJson, THHKotlinx_serialization_jsonJsonConfiguration, THHKotlinx_serialization_jsonJsonDefault, THHKotlinx_serialization_jsonJsonElement, THHKotlinx_serialization_jsonJsonElementCompanion, THHKotlinx_serialization_jsonJsonPrimitive, THHKotlinx_serialization_jsonJsonPrimitiveCompanion, THHKtor_client_coreHttpClient, THHKtor_client_coreHttpClientCall, THHKtor_client_coreHttpClientCallCompanion, THHKtor_client_coreHttpClientConfig<T>, THHKtor_client_coreHttpClientEngineConfig, THHKtor_client_coreHttpReceivePipeline, THHKtor_client_coreHttpReceivePipelinePhases, THHKtor_client_coreHttpRequestBuilder, THHKtor_client_coreHttpRequestBuilderCompanion, THHKtor_client_coreHttpRequestData, THHKtor_client_coreHttpRequestPipeline, THHKtor_client_coreHttpRequestPipelinePhases, THHKtor_client_coreHttpResponse, THHKtor_client_coreHttpResponseContainer, THHKtor_client_coreHttpResponseData, THHKtor_client_coreHttpResponsePipeline, THHKtor_client_coreHttpResponsePipelinePhases, THHKtor_client_coreHttpSendPipeline, THHKtor_client_coreHttpSendPipelinePhases, THHKtor_client_coreProxyConfig, THHKtor_client_coreWebSocketsConfig, THHKtor_eventsEventDefinition<T>, THHKtor_eventsEvents, THHKtor_httpContentType, THHKtor_httpContentTypeCompanion, THHKtor_httpHeaderValueParam, THHKtor_httpHeaderValueWithParameters, THHKtor_httpHeaderValueWithParametersCompanion, THHKtor_httpHeadersBuilder, THHKtor_httpHttpMethod, THHKtor_httpHttpMethodCompanion, THHKtor_httpHttpProtocolVersion, THHKtor_httpHttpProtocolVersionCompanion, THHKtor_httpHttpStatusCode, THHKtor_httpHttpStatusCodeCompanion, THHKtor_httpOutgoingContent, THHKtor_httpURLBuilder, THHKtor_httpURLBuilderCompanion, THHKtor_httpURLProtocol, THHKtor_httpURLProtocolCompanion, THHKtor_httpUrl, THHKtor_httpUrlCompanion, THHKtor_ioByteChannel, THHKtor_ioCharset, THHKtor_ioCharsetCompanion, THHKtor_ioCharsetDecoder, THHKtor_ioCharsetEncoder, THHKtor_ioReaderJob, THHKtor_ioWriterJob, THHKtor_networkSocketAddress, THHKtor_utilsAttributeKey<T>, THHKtor_utilsGMTDate, THHKtor_utilsGMTDateCompanion, THHKtor_utilsMonth, THHKtor_utilsMonthCompanion, THHKtor_utilsPipeline<TSubject, TContext>, THHKtor_utilsPipelinePhase, THHKtor_utilsStringValuesBuilderImpl, THHKtor_utilsTypeInfo, THHKtor_utilsWeekDay, THHKtor_utilsWeekDayCompanion, THHKtor_websocketsFrame, THHKtor_websocketsFrameCompanion, THHKtor_websocketsFrameType, THHKtor_websocketsFrameTypeCompanion, THHKtor_websocketsWebSocketExtensionHeader, THHKtor_websocketsWebSocketExtensionsConfig, THHLatestVersion, THHLatestVersionCompanion, THHLocalStorage, THHLogLevel, THHLogsRequest, THHLogsRequestCompanion, THHMultiTerminalOperation, THHNTTAction, THHNTTActionCompanion, THHNTTPaymentMethod, THHNTTPaymentMethodCompanion, THHNTTTerminalAction, THHNTTTerminalResult, THHNTTTerminalResultCompanion, THHNTTTransactionType, THHNTTTransactionTypeCompanion, THHNTTWebSocketService, THHNetInterface, THHPayPayload, THHPayPayloadCompanion, THHPaymentMethodCompanion, THHPaymentMethodSerializer, THHPrintReceiptPayload, THHPrintReceiptPayloadCompanion, THHRawTransactionsRequest, THHRawTransactionsRequestCompanion, THHRefundPayload, THHRefundPayloadCompanion, THHResult<T>, THHRuntimeAfterVersion, THHRuntimeBaseTransacterImpl, THHRuntimeExecutableQuery<__covariant RowType>, THHRuntimeQuery<__covariant RowType>, THHRuntimeTransacterImpl, THHRuntimeTransacterTransaction, THHSHCAction, THHSHCActionCompanion, THHSHCPaymentMethod, THHSHCPaymentMethodCategory, THHSHCPaymentMethodCategoryCompanion, THHSHCPaymentMethodCompanion, THHSHCTerminalAction, THHSHCTerminalResult, THHSHCTerminalResultCompanion, THHSHCTransactionType, THHSHCTransactionTypeCompanion, THHService, THHServiceCapabilities, THHServicePaymentMethod, THHServicePaymentMethodCompanion, THHServiceQueries, THHServiceType, THHSettlementPayload, THHSettlementPayloadCompanion, THHSimulationRequest, THHSimulationRequestCompanion, THHSimulationResponse, THHSimulationResponseCompanion, THHStatus, THHStatusCompanion, THHTerminal, THHTerminalApp, THHTerminalBRI, THHTerminalCashup, THHTerminalCommunicationService, THHTerminalCore<T>, THHTerminalDevice, THHTerminalDeviceCompanion, THHTerminalGHL, THHTerminalH2H, THHTerminalMode, THHTerminalNTT, THHTerminalOperation, THHTerminalProvider, THHTerminalQueries, THHTerminalResult, THHTerminalResultCompanion, THHTimeoutType, THHTimeoutTypeCompanion, THHTransactionFakeCode, THHTransactionQueries, THHTransactionResponse, THHTransactionResponseCompanion, THHTransactionType, THHTransactionTypeCompanion, THHTransactions, THHTransactionsRequest<T>, THHTransactionsRequestCompanion, THHTransactionsRequestPayload, THHTransactionsRequestPayloadCompanion, THHVerifyRequest, THHVerifyRequestCompanion, THHVersionStatus, THHVoidPayload, THHVoidPayloadCompanion, THHWebSocketService, THHXLoggerCompanion;

@protocol THHBaseProviderAppLauncher, THHBluetoothService, THHCommandPayload, THHDatabase, THHKermit_coreLoggerConfig, THHKermit_coreMessageStringFormatter, THHKermit_coreMutableLoggerConfig, THHKotlinAnnotation, THHKotlinAppendable, THHKotlinAutoCloseable, THHKotlinClock, THHKotlinClosedRange, THHKotlinCollection, THHKotlinComparable, THHKotlinContinuation, THHKotlinContinuationInterceptor, THHKotlinCoroutineContext, THHKotlinCoroutineContextElement, THHKotlinCoroutineContextKey, THHKotlinFunction, THHKotlinIterable, THHKotlinIterator, THHKotlinKAnnotatedElement, THHKotlinKClass, THHKotlinKClassifier, THHKotlinKDeclarationContainer, THHKotlinKType, THHKotlinMapEntry, THHKotlinOpenEndRange, THHKotlinSequence, THHKotlinSuspendFunction0, THHKotlinSuspendFunction1, THHKotlinSuspendFunction2, THHKotlinx_coroutines_coreChildHandle, THHKotlinx_coroutines_coreChildJob, THHKotlinx_coroutines_coreCoroutineScope, THHKotlinx_coroutines_coreDisposableHandle, THHKotlinx_coroutines_coreFlow, THHKotlinx_coroutines_coreFlowCollector, THHKotlinx_coroutines_coreJob, THHKotlinx_coroutines_coreMutableSharedFlow, THHKotlinx_coroutines_coreMutableStateFlow, THHKotlinx_coroutines_coreMutex, THHKotlinx_coroutines_coreParentJob, THHKotlinx_coroutines_coreRunnable, THHKotlinx_coroutines_coreSelectClause, THHKotlinx_coroutines_coreSelectClause0, THHKotlinx_coroutines_coreSelectClause2, THHKotlinx_coroutines_coreSelectInstance, THHKotlinx_coroutines_coreSharedFlow, THHKotlinx_coroutines_coreStateFlow, THHKotlinx_datetimeDateTimeFormat, THHKotlinx_datetimeDateTimeFormatBuilder, THHKotlinx_datetimeDateTimeFormatBuilderWithDate, THHKotlinx_datetimeDateTimeFormatBuilderWithDateTime, THHKotlinx_datetimeDateTimeFormatBuilderWithTime, THHKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset, THHKotlinx_datetimeDateTimeFormatBuilderWithYearMonth, THHKotlinx_io_coreFileSystem, THHKotlinx_io_coreRawSink, THHKotlinx_io_coreRawSource, THHKotlinx_io_coreSink, THHKotlinx_io_coreSource, THHKotlinx_serialization_coreCompositeDecoder, THHKotlinx_serialization_coreCompositeEncoder, THHKotlinx_serialization_coreDecoder, THHKotlinx_serialization_coreDeserializationStrategy, THHKotlinx_serialization_coreEncoder, THHKotlinx_serialization_coreKSerializer, THHKotlinx_serialization_coreSerialDescriptor, THHKotlinx_serialization_coreSerialFormat, THHKotlinx_serialization_coreSerializationStrategy, THHKotlinx_serialization_coreSerializersModuleCollector, THHKotlinx_serialization_coreStringFormat, THHKotlinx_serialization_jsonJsonNamingStrategy, THHKtor_client_coreHttpClientEngine, THHKtor_client_coreHttpClientEngineCapability, THHKtor_client_coreHttpClientPlugin, THHKtor_client_coreHttpRequest, THHKtor_httpHeaders, THHKtor_httpHttpMessage, THHKtor_httpHttpMessageBuilder, THHKtor_httpParameters, THHKtor_httpParametersBuilder, THHKtor_ioBufferedByteWriteChannel, THHKtor_ioByteReadChannel, THHKtor_ioByteWriteChannel, THHKtor_ioChannelJob, THHKtor_ioCloseable, THHKtor_ioJvmSerializable, THHKtor_networkABoundSocket, THHKtor_networkAConnectedSocket, THHKtor_networkAReadable, THHKtor_networkASocket, THHKtor_networkAWritable, THHKtor_networkReadWriteSocket, THHKtor_networkSocket, THHKtor_serializationWebsocketContentConverter, THHKtor_utilsAttributes, THHKtor_utilsStringValues, THHKtor_utilsStringValuesBuilder, THHKtor_websocketsWebSocketExtension, THHKtor_websocketsWebSocketExtensionFactory, THHLoggingLogLevelController, THHLoggingLogger, THHLoggingLoggerApi, THHPaymentMethod, THHPlatform, THHRuntimeCloseable, THHRuntimeQueryListener, THHRuntimeQueryResult, THHRuntimeSqlCursor, THHRuntimeSqlDriver, THHRuntimeSqlPreparedStatement, THHRuntimeSqlSchema, THHRuntimeTransacter, THHRuntimeTransacterBase, THHRuntimeTransactionCallbacks, THHRuntimeTransactionWithReturn, THHRuntimeTransactionWithoutReturn, THHTerminalAction;

NS_ASSUME_NONNULL_BEGIN
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunknown-warning-option"
#pragma clang diagnostic ignored "-Wincompatible-property-type"
#pragma clang diagnostic ignored "-Wnullability"

#pragma push_macro("_Nullable_result")
#if !__has_feature(nullability_nullable_result)
#undef _Nullable_result
#define _Nullable_result _Nullable
#endif

__attribute__((swift_name("KotlinBase")))
@interface THHBase : NSObject
- (instancetype)init __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (void)initialize __attribute__((objc_requires_super));
@end

@interface THHBase (THHBaseCopying) <NSCopying>
@end

__attribute__((swift_name("KotlinMutableSet")))
@interface THHMutableSet<ObjectType> : NSMutableSet<ObjectType>
@end

__attribute__((swift_name("KotlinMutableDictionary")))
@interface THHMutableDictionary<KeyType, ObjectType> : NSMutableDictionary<KeyType, ObjectType>
@end

@interface NSError (NSErrorTHHKotlinException)
@property (readonly) id _Nullable kotlinException;
@end

__attribute__((swift_name("KotlinNumber")))
@interface THHNumber : NSNumber
- (instancetype)initWithChar:(char)value __attribute__((unavailable));
- (instancetype)initWithUnsignedChar:(unsigned char)value __attribute__((unavailable));
- (instancetype)initWithShort:(short)value __attribute__((unavailable));
- (instancetype)initWithUnsignedShort:(unsigned short)value __attribute__((unavailable));
- (instancetype)initWithInt:(int)value __attribute__((unavailable));
- (instancetype)initWithUnsignedInt:(unsigned int)value __attribute__((unavailable));
- (instancetype)initWithLong:(long)value __attribute__((unavailable));
- (instancetype)initWithUnsignedLong:(unsigned long)value __attribute__((unavailable));
- (instancetype)initWithLongLong:(long long)value __attribute__((unavailable));
- (instancetype)initWithUnsignedLongLong:(unsigned long long)value __attribute__((unavailable));
- (instancetype)initWithFloat:(float)value __attribute__((unavailable));
- (instancetype)initWithDouble:(double)value __attribute__((unavailable));
- (instancetype)initWithBool:(BOOL)value __attribute__((unavailable));
- (instancetype)initWithInteger:(NSInteger)value __attribute__((unavailable));
- (instancetype)initWithUnsignedInteger:(NSUInteger)value __attribute__((unavailable));
+ (instancetype)numberWithChar:(char)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedChar:(unsigned char)value __attribute__((unavailable));
+ (instancetype)numberWithShort:(short)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedShort:(unsigned short)value __attribute__((unavailable));
+ (instancetype)numberWithInt:(int)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedInt:(unsigned int)value __attribute__((unavailable));
+ (instancetype)numberWithLong:(long)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedLong:(unsigned long)value __attribute__((unavailable));
+ (instancetype)numberWithLongLong:(long long)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedLongLong:(unsigned long long)value __attribute__((unavailable));
+ (instancetype)numberWithFloat:(float)value __attribute__((unavailable));
+ (instancetype)numberWithDouble:(double)value __attribute__((unavailable));
+ (instancetype)numberWithBool:(BOOL)value __attribute__((unavailable));
+ (instancetype)numberWithInteger:(NSInteger)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedInteger:(NSUInteger)value __attribute__((unavailable));
@end

__attribute__((swift_name("KotlinByte")))
@interface THHByte : THHNumber
- (instancetype)initWithChar:(char)value;
+ (instancetype)numberWithChar:(char)value;
@end

__attribute__((swift_name("KotlinUByte")))
@interface THHUByte : THHNumber
- (instancetype)initWithUnsignedChar:(unsigned char)value;
+ (instancetype)numberWithUnsignedChar:(unsigned char)value;
@end

__attribute__((swift_name("KotlinShort")))
@interface THHShort : THHNumber
- (instancetype)initWithShort:(short)value;
+ (instancetype)numberWithShort:(short)value;
@end

__attribute__((swift_name("KotlinUShort")))
@interface THHUShort : THHNumber
- (instancetype)initWithUnsignedShort:(unsigned short)value;
+ (instancetype)numberWithUnsignedShort:(unsigned short)value;
@end

__attribute__((swift_name("KotlinInt")))
@interface THHInt : THHNumber
- (instancetype)initWithInt:(int)value;
+ (instancetype)numberWithInt:(int)value;
@end

__attribute__((swift_name("KotlinUInt")))
@interface THHUInt : THHNumber
- (instancetype)initWithUnsignedInt:(unsigned int)value;
+ (instancetype)numberWithUnsignedInt:(unsigned int)value;
@end

__attribute__((swift_name("KotlinLong")))
@interface THHLong : THHNumber
- (instancetype)initWithLongLong:(long long)value;
+ (instancetype)numberWithLongLong:(long long)value;
@end

__attribute__((swift_name("KotlinULong")))
@interface THHULong : THHNumber
- (instancetype)initWithUnsignedLongLong:(unsigned long long)value;
+ (instancetype)numberWithUnsignedLongLong:(unsigned long long)value;
@end

__attribute__((swift_name("KotlinFloat")))
@interface THHFloat : THHNumber
- (instancetype)initWithFloat:(float)value;
+ (instancetype)numberWithFloat:(float)value;
@end

__attribute__((swift_name("KotlinDouble")))
@interface THHDouble : THHNumber
- (instancetype)initWithDouble:(double)value;
+ (instancetype)numberWithDouble:(double)value;
@end

__attribute__((swift_name("KotlinBoolean")))
@interface THHBoolean : THHNumber
- (instancetype)initWithBool:(BOOL)value;
+ (instancetype)numberWithBool:(BOOL)value;
@end

__attribute__((swift_name("BaseTerminalOperation")))
@interface THHBaseTerminalOperation : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandsTids:(NSArray<NSString *> *)tids completionHandler:(void (^)(THHResult<NSArray<THHCommand *> *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commands(tids:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(THHActionJob *)actionJob payload:(THHAction *)payload device:(THHTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));
- (id<THHKotlinx_coroutines_coreJob>)observePayloadScope:(id<THHKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable))onResult __attribute__((swift_name("observePayload(scope:onResult:)")));
@end

__attribute__((swift_name("TerminalOperation")))
@interface THHTerminalOperation : THHBaseTerminalOperation
- (instancetype)initWithTerminalProvider:(THHTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));

/**
 * Cancel an intent
 */
- (void)cancelDevice:(THHTerminalDevice *)device key:(THHAction *)key __attribute__((swift_name("cancel(device:key:)")));

/**
 * Cancel all the intents
 */
- (void)cancelAllDevice:(THHTerminalDevice *)device __attribute__((swift_name("cancelAll(device:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)cancelSessionPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelSession(payload:device:isSimulation:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkStatusPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkStatus(payload:device:paymentRequestId:isSimulation:completionHandler:)")));
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectDevice:(THHTerminalDevice * _Nullable)device __attribute__((swift_name("disconnect(device:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(THHActionJob *)actionJob payload:(THHAction *)payload device:(THHTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeAction:(THHAction * _Nullable)action command:(THHCommand *)command device:(THHTerminalDevice *)device isSimulation:(BOOL)isSimulation completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(action:command:device:isSimulation:completionHandler:)")));
- (THHTimeoutType * _Nullable)getTimeoutTypeAction:(THHAction *)action __attribute__((swift_name("getTimeoutType(action:)")));
- (BOOL)isLockedDevice:(THHTerminalDevice *)device __attribute__((swift_name("isLocked(device:)")));
- (BOOL)isSupported __attribute__((swift_name("isSupported()")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<THHKotlinx_coroutines_coreJob>)observeResultOnResult:(void (^)(THHResult<THHTerminalResult *> *))onResult __attribute__((swift_name("observeResult(onResult:)")));

/**
 * Observes the Terminal connection state on [Dispatchers.IO] and
 * delivers updates via the [onResult] callback.
 *
 * This is a convenience function that launches the observation in a default [CoroutineScope]
 * on the [Dispatchers.IO] dispatcher.
 *
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine. Cancelling this job will stop the observation.
 */
- (id<THHKotlinx_coroutines_coreJob>)observeTerminalConnectionOnResult:(void (^)(THHConnectionState *))onResult __attribute__((swift_name("observeTerminalConnection(onResult:)")));

/**
 * Observes the Terminal connection state within a given [scope] and
 * delivers updates via the [onResult] callback.
 *
 * This function collects the [ConnectionState] emitted by [connectionState] and
 * invokes the [onResult] callback with the latest state. The observation will continue
 * as long as the provided [scope] is active.
 *
 * @param scope The [CoroutineScope] in which the observation coroutine will be launched.
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine. Cancelling this job will stop the observation.
 */
- (id<THHKotlinx_coroutines_coreJob>)observeTerminalConnectionScope:(id<THHKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(THHConnectionState *))onResult __attribute__((swift_name("observeTerminalConnection(scope:onResult:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onPayCommand:(THHCommand *)command data:(THHPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onPrintReceiptCommand:(THHCommand *)command data:(THHPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onSettlementCommand:(THHCommand *)command data:(THHSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onVoidCommand:(THHCommand *)command data:(THHVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(THHTerminalDevice *)device completionHandler:(void (^)(THHBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));
- (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(THHAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));
- (THHBoolean * _Nullable)releaseDevice:(THHTerminalDevice * _Nullable)device __attribute__((swift_name("release(device:)")));
- (BOOL)releaseTerminalID:(NSString *)terminalID __attribute__((swift_name("release(terminalID:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHActionJob *)runActionIt:(THHAction *)it device:(THHTerminalDevice * _Nullable)device isSimulation:(THHBoolean * _Nullable)isSimulation callback:(void (^)(THHTerminalResult * _Nullable, THHErrorData * _Nullable))callback __attribute__((swift_name("runAction(it:device:isSimulation:callback:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHActionJob *)runActionIt:(THHAction *)it device:(THHTerminalDevice * _Nullable)device isSimulation:(THHBoolean * _Nullable)isSimulation onCancel:(id<THHKotlinSuspendFunction0>)onCancel callback:(void (^)(THHTerminalResult * _Nullable, THHErrorData * _Nullable))callback __attribute__((swift_name("runAction(it:device:isSimulation:onCancel:callback:)")));
- (void)setConnectionTypeConnectionType:(THHConnectionType *)connectionType __attribute__((swift_name("setConnectionType(connectionType:)")));
- (NSString * _Nullable)terminalIDData:(THHKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)testDeviceConnectionTerminalOperation:(THHTerminalOperation *)terminalOperation device:(THHTerminalDevice *)device completionHandler:(void (^)(THHTerminalDevice * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("testDeviceConnection(terminalOperation:device:completionHandler:)")));
- (THHAction * _Nullable)toActionPayloadCommand:(THHCommand *)command data:(id<THHCommandPayload> _Nullable)data __attribute__((swift_name("toActionPayload(command:data:)")));
- (NSArray<id<THHTerminalAction>> *)toActionsCommandType:(THHCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (int64_t)toMillis:(NSString *)receiver __attribute__((swift_name("toMillis(_:)")));
- (THHGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (THHResult<THHTerminalResult *> * _Nullable)toResultTerminalDevice:(THHTerminalDevice *)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));
- (THHKotlinPair<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(THHKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)json transactions:(THHTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (THHTerminalResult * _Nullable)toTerminalResultTerminalDevice:(THHTerminalDevice * _Nullable)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));
- (NSArray<THHTerminalResult *> * _Nullable)transactionRecordsActions:(NSArray<id<THHTerminalAction>> *)actions statuses:(NSArray<THHStatus *> *)statuses from:(NSString * _Nullable)from to:(NSString * _Nullable)to __attribute__((swift_name("transactionRecords(actions:statuses:from:to:)")));
- (NSArray<THHTerminalResult *> * _Nullable)transactionRecordsActions:(NSArray<NSString *> *)actions statuses:(NSArray<THHStatus *> *)statuses fromTimestamp:(THHLong * _Nullable)fromTimestamp toTimestamp:(THHLong * _Nullable)toTimestamp __attribute__((swift_name("transactionRecords(actions:statuses:fromTimestamp:toTimestamp:)")));
- (THHTerminalResult *)transformJsonToResultJson:(THHKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));
- (void)useWifi __attribute__((swift_name("useWifi()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<THHBluetoothService> _Nullable bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHTerminalCommunicationService * _Nullable communicationService __attribute__((swift_name("communicationService")));
@property (readonly) id<THHKotlinx_coroutines_coreFlow> connectionState __attribute__((swift_name("connectionState")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property THHTerminalDevice * _Nullable device __attribute__((swift_name("device")));
@property BOOL isSimulation __attribute__((swift_name("isSimulation")));
@property (readonly) BOOL needVerify __attribute__((swift_name("needVerify")));

/**
 * Get the result flow
 * @return the result flow
 */
@property (readonly) id<THHKotlinx_coroutines_coreStateFlow> result __attribute__((swift_name("result")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<THHKotlinx_coroutines_coreMutableStateFlow> resultFlow __attribute__((swift_name("resultFlow")));
@property (readonly) THHConnectionType *sdkConnectionType __attribute__((swift_name("sdkConnectionType")));
@property (readonly) THHTerminalProvider *terminalProvider __attribute__((swift_name("terminalProvider")));
@end


/**
 * Implementation of [TerminalOperation] for BRI (Bank Rakyat Indonesia) terminals.
 * This class handles communication with BRI EDCs via WebSocket or Bluetooth, maps
 * generic terminal actions to BRI-specific protocols, and manages transaction lifecycles
 * including payments, settlements, voids, and refunds.
 */
__attribute__((swift_name("BaseTerminalBRI")))
@interface THHBaseTerminalBRI : THHTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(THHTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Checks the status of a specific transaction on the terminal device.
 * This is typically used to verify if a previous operation (like a sale or verification)
 * was successful when the initial response was ambiguous or lost.
 *
 * @param payload The action payload.
 * @param device The target terminal device.
 * @param paymentRequestId The ID of the payment request.
 * @param isSimulation Flag to indicate if this is a simulation.
 * @return A [Result] containing the [TerminalResult], or [ErrorCode.DATA_NOT_FOUND] if no Order ID exists.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkStatusPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkStatus(payload:device:paymentRequestId:isSimulation:completionHandler:)")));
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Executes a terminal action. If the action is a payment, it verifies the consistency
 * of the Order ID between the request and the result. If they mismatch, it attempts
 * to fetch the correct status from the device.
 *
 * @param actionJob The job context for the action.
 * @param payload The action payload.
 * @param device The target terminal device.
 * @param orderId The order identifier.
 * @param paymentRequestId The payment request identifier.
 * @param isSimulation Flag for simulation mode.
 * @param isSynchronize Flag for synchronous execution.
 * @return The result of the terminal operation.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(THHActionJob *)actionJob payload:(THHAction *)payload device:(THHTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));
- (THHTimeoutType * _Nullable)getTimeoutTypeAction:(THHAction *)action __attribute__((swift_name("getTimeoutType(action:)")));

/**
 * Maps a generic [Command.PAY] command to a specific BRI payment action.
 * Handles various payment methods like Insert Card, Contactless, BRIZZI, and QRIS.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onPayCommand:(THHCommand *)command data:(THHPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * Maps a generic [Command.PRINT_RECEIPT] command to a BRI Reprint or CheckStatus action.
 * For QRIS, it uses CheckStatus to fetch and print the latest status.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction *)onPrintReceiptCommand:(THHCommand *)command data:(THHPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the status of a transaction. If a valid Order ID is associated with the payload,
 * it triggers a status check on the device.
 *
 * @param payload The action payload containing transaction details.
 * @param device The target terminal device.
 * @param paymentRequestId The ID of the payment request.
 * @param isSimulation Flag to indicate if this is a simulation.
 * @return A [Result] containing the [TerminalResult] of the status check.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * Maps a generic [Command.SETTLE] command to a BRI Settlement action.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onSettlementCommand:(THHCommand *)command data:(THHSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Maps a generic [Command.VOID] command to a BRI Void or Refund action.
 * Uses [RefundQris] for QRIS methods and standard [Void] for others.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onVoidCommand:(THHCommand *)command data:(THHVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Pings the terminal device via WebSocket to check for reachability.
 * Returns true if connection is successful or if specific error codes (like DECLINED_BY_READER) indicate presence.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(THHTerminalDevice *)device completionHandler:(void (^)(THHBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));
- (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(THHAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));
- (NSString * _Nullable)terminalIDData:(THHKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));
- (NSArray<id<THHTerminalAction>> *)toActionsCommandType:(THHCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (THHGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (THHResult<THHTerminalResult *> * _Nullable)toResultTerminalDevice:(THHTerminalDevice *)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));

/**
 * Converts the raw JSON response from the terminal into a format suitable for backend synchronization.
 * It handles different transaction types (payment, void, callback) and filters based on status.
 *
 * @param request The original request JSON.
 * @param json The response JSON from the terminal.
 * @param transactions The transaction context.
 * @return A pair of the transaction type name and the synchronized JSON payload.
 */
- (THHKotlinPair<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(THHKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)json transactions:(THHTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (THHTerminalResult * _Nullable)toTerminalResultTerminalDevice:(THHTerminalDevice * _Nullable)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));
- (THHTerminalResult *)transformJsonToResultJson:(THHKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));
- (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)updateJsonObjectValueJsonObject:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)jsonObject key:(NSString *)key newValue:(THHKotlinx_serialization_jsonJsonElement *)newValue __attribute__((swift_name("updateJsonObjectValue(jsonObject:key:newValue:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<THHBluetoothService> bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHBriEDCWebSocketService *communicationService __attribute__((swift_name("communicationService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalBRI")))
@interface THHTerminalBRI : THHBaseTerminalBRI
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalBRI __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTerminalBRI *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("KotlinComparable")))
@protocol THHKotlinComparable
@required
- (int32_t)compareToOther:(id _Nullable)other __attribute__((swift_name("compareTo(other:)")));
@end

__attribute__((swift_name("KotlinEnum")))
@interface THHKotlinEnum<E> : THHBase <THHKotlinComparable>
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinEnumCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(E)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) int32_t ordinal __attribute__((swift_name("ordinal")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/PaymentMethodSerializer))
*/
__attribute__((swift_name("PaymentMethod")))
@protocol THHPaymentMethod
@required
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Enumeration of supported sale methods in the BRI terminal protocol.
 * Maps keys like "purchase", "qris", "brizzi" to internal types.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/BRIPaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPaymentMethod")))
@interface THHBRIPaymentMethod : THHKotlinEnum<THHBRIPaymentMethod *> <THHPaymentMethod>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enumeration of supported sale methods in the BRI terminal protocol.
 * Maps keys like "purchase", "qris", "brizzi" to internal types.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHBRIPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHBRIPaymentMethod *qris __attribute__((swift_name("qris")));
@property (class, readonly) THHBRIPaymentMethod *brizzi __attribute__((swift_name("brizzi")));
@property (class, readonly) THHBRIPaymentMethod *insertCard __attribute__((swift_name("insertCard")));
@property (class, readonly) THHBRIPaymentMethod *contactless __attribute__((swift_name("contactless")));
@property (class, readonly) THHBRIPaymentMethod *none __attribute__((swift_name("none")));
+ (THHKotlinArray<THHBRIPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHBRIPaymentMethod *> *entries __attribute__((swift_name("entries")));
- (THHGenericPaymentMethod * _Nullable)toPaymentMethod __attribute__((swift_name("toPaymentMethod()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerializationStrategy")))
@protocol THHKotlinx_serialization_coreSerializationStrategy
@required
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(id _Nullable)value __attribute__((swift_name("serialize(encoder:value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreDeserializationStrategy")))
@protocol THHKotlinx_serialization_coreDeserializationStrategy
@required
- (id _Nullable)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreKSerializer")))
@protocol THHKotlinx_serialization_coreKSerializer <THHKotlinx_serialization_coreSerializationStrategy, THHKotlinx_serialization_coreDeserializationStrategy>
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPaymentMethod.Companion")))
@interface THHBRIPaymentMethodCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHBRIPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (THHBRIPaymentMethod *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (THHBRIPaymentMethod *)fromPaymentMethodMethodName:(NSString * _Nullable)methodName __attribute__((swift_name("fromPaymentMethod(methodName:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHBRIPaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHBRIPaymentMethod *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * Marker interface for specific terminal actions (e.g., Payment, Void).
 *
 * Implementations of this interface typically represent concrete operations
 * supported by a terminal.
 */
__attribute__((swift_name("TerminalAction")))
@protocol THHTerminalAction
@required
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/BRITerminalAction.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRITerminalAction")))
@interface THHBRITerminalAction : THHKotlinEnum<THHBRITerminalAction *> <THHTerminalAction>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHBRITerminalActionCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHBRITerminalAction *contactless __attribute__((swift_name("contactless")));
@property (class, readonly) THHBRITerminalAction *sale __attribute__((swift_name("sale")));
@property (class, readonly) THHBRITerminalAction *settlement __attribute__((swift_name("settlement")));
@property (class, readonly) THHBRITerminalAction *void_ __attribute__((swift_name("void_")));
@property (class, readonly) THHBRITerminalAction *reprintAny __attribute__((swift_name("reprintAny")));
@property (class, readonly) THHBRITerminalAction *reprintLast __attribute__((swift_name("reprintLast")));
@property (class, readonly) THHBRITerminalAction *cardVerification __attribute__((swift_name("cardVerification")));
@property (class, readonly) THHBRITerminalAction *saleCompletion __attribute__((swift_name("saleCompletion")));
@property (class, readonly) THHBRITerminalAction *installment __attribute__((swift_name("installment")));
@property (class, readonly) THHBRITerminalAction *checkStatus __attribute__((swift_name("checkStatus")));
@property (class, readonly) THHBRITerminalAction *checkTrx __attribute__((swift_name("checkTrx")));
@property (class, readonly) THHBRITerminalAction *refundQris __attribute__((swift_name("refundQris")));
@property (class, readonly) THHBRITerminalAction *unknown __attribute__((swift_name("unknown")));
+ (THHKotlinArray<THHBRITerminalAction *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHBRITerminalAction *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRITerminalAction.Companion")))
@interface THHBRITerminalActionCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHBRITerminalActionCompanion *shared __attribute__((swift_name("shared")));
- (THHBRITerminalAction *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHBRITerminalAction *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHBRITerminalAction *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/BriStatus.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriStatus")))
@interface THHBriStatus : THHKotlinEnum<THHBriStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHBriStatusCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHBriStatus *success __attribute__((swift_name("success")));
@property (class, readonly) THHBriStatus *failed __attribute__((swift_name("failed")));
@property (class, readonly) THHBriStatus *paid __attribute__((swift_name("paid")));
@property (class, readonly) THHBriStatus *unpaid __attribute__((swift_name("unpaid")));
@property (class, readonly) THHBriStatus *refund __attribute__((swift_name("refund")));
@property (class, readonly) THHBriStatus *notFound __attribute__((swift_name("notFound")));
@property (class, readonly) THHBriStatus *unknown __attribute__((swift_name("unknown")));
+ (THHKotlinArray<THHBriStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHBriStatus *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriStatus.Companion")))
@interface THHBriStatusCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHBriStatusCompanion *shared __attribute__((swift_name("shared")));
- (THHBriStatus *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHBriStatus *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHBriStatus *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@property (readonly) NSArray<THHBriStatus *> *successStatusList __attribute__((swift_name("successStatusList")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/ServicePaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServicePaymentMethod")))
@interface THHServicePaymentMethod : THHKotlinEnum<THHServicePaymentMethod *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHServicePaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHServicePaymentMethod *idInsertCard __attribute__((swift_name("idInsertCard")));
@property (class, readonly) THHServicePaymentMethod *idContactless __attribute__((swift_name("idContactless")));
@property (class, readonly) THHServicePaymentMethod *idBrizzi __attribute__((swift_name("idBrizzi")));
@property (class, readonly) THHServicePaymentMethod *idQris __attribute__((swift_name("idQris")));
@property (class, readonly) THHServicePaymentMethod *unknown __attribute__((swift_name("unknown")));
+ (THHKotlinArray<THHServicePaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHServicePaymentMethod *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServicePaymentMethod.Companion")))
@interface THHServicePaymentMethodCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHServicePaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (THHServicePaymentMethod *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHServicePaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHServicePaymentMethod *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("TerminalCommunicationService")))
@interface THHTerminalCommunicationService : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)clearMutexTerminalID:(NSString *)terminalID payload:(id _Nullable)payload __attribute__((swift_name("clearMutex(terminalID:payload:)")));
- (void)closeDevice:(THHTerminalDevice *)device __attribute__((swift_name("close(device:)")));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(THHTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)connectWithMutexDevice:(THHTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connectWithMutex(device:port:payload:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updatePriorityDevice:(THHTerminalDevice *)device priority:(int32_t)priority __attribute__((swift_name("updatePriority(device:priority:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updateStateDevice:(THHTerminalDevice *)device state:(THHConnectionState *)state __attribute__((swift_name("updateState(device:state:)")));
@property (readonly) THHMutableDictionary<NSString *, id<THHKotlinx_coroutines_coreMutex>> *mutex __attribute__((swift_name("mutex")));
@end

__attribute__((swift_name("WebSocketService")))
@interface THHWebSocketService : THHTerminalCommunicationService
- (instancetype)initWithBuilder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriEDCWebSocketService")))
@interface THHBriEDCWebSocketService : THHWebSocketService
- (instancetype)initWithResultFlow:(id<THHKotlinx_coroutines_coreMutableStateFlow>)resultFlow shouldRetry:(THHBoolean *(^)(THHKotlinException *))shouldRetry builder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:shouldRetry:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * Connect to the EDC
 * @param device the Terminal Device data
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(THHTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
- (THHKtor_client_coreHttpClient *)createClientDevice:(THHTerminalDevice *)device __attribute__((swift_name("createClient(device:)")));
@property (readonly) THHKtor_client_coreHttpClient *(^builder)(void) __attribute__((swift_name("builder")));
@end


/**
 * Base implementation for Cashup Terminal operations.
 *
 * This class handles the core logic for communicating with a Cashup terminal, including
 * parsing responses, handling payments, and managing void transactions.
 */
__attribute__((swift_name("BaseTerminalCashup")))
@interface THHBaseTerminalCashup : THHTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(THHTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Generates a new unique Order ID using ULID.
 *
 * @return A string representation of a ULID.
 */
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Constructs the Payment action payload.
 *
 * @param command The base command containing context like order ID.
 * @param data The specific payment payload data.
 * @return A [CashupAction.Payment] action if valid, or null.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHCashupAction * _Nullable)onPayCommand:(THHCommand *)command data:(THHPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onPrintReceiptCommand:(THHCommand *)command data:(THHPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the terminal status. Currently implemented to return null for Cashup.
 *
 * @param payload The action payload.
 * @param device The target device.
 * @param paymentRequestId The ID of the payment request.
 * @param isSimulation Whether this is a simulation.
 * @return Null as refresh is not implemented.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHKotlinNothing * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onSettlementCommand:(THHCommand *)command data:(THHSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Constructs the Void action payload.
 *
 * @param command The base command containing context like order ID.
 * @param data The specific void payload data.
 * @return A [CashupAction.Void] action if valid, [UnsupportedAction] if QRIS, or null if invalid.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onVoidCommand:(THHCommand *)command data:(THHVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Pings the device to check connectivity.
 *
 * @param device The device to ping.
 * @return False (Not implemented for Cashup).
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(THHTerminalDevice *)device completionHandler:(void (^)(THHBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));

/**
 * Prepares the request payload for transmission.
 *
 * @param payload The action payload.
 * @return A map representing the JSON data to be sent.
 */
- (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(THHAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));

/**
 * Extracts the terminal ID from the provided JSON data.
 *
 * @param data The JSON element containing terminal information.
 * @return The terminal ID string, or null if not present.
 */
- (NSString * _Nullable)terminalIDData:(THHKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));

/**
 * Maps a command type to a list of supported terminal actions.
 *
 * @param commandType The command type to map.
 * @return A list of [TerminalAction]s supported for that command.
 */
- (NSArray<id<THHTerminalAction>> *)toActionsCommandType:(THHCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));

/**
 * Determines the payment method from a string value.
 *
 * @param value The string representation of the payment method.
 * @return The corresponding [GenericPaymentMethod], or null if not found.
 */
- (THHGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));

/**
 * Converts a JSON response into a [Result] containing a [TerminalResult].
 *
 * Checks for error codes in the response and wraps the result in either Success or Failure.
 *
 * @param terminalDevice The device associated with the result.
 * @param json The JSON response.
 * @return A Result containing the TerminalResult, or null if JSON is null.
 */
- (THHResult<THHTerminalResult *> * _Nullable)toResultTerminalDevice:(THHTerminalDevice *)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));

/**
 * Converts a raw request and response into a service payload for callback processing.
 *
 * @param request The original request JSON.
 * @param json The response JSON object.
 * @param transactions The transaction details.
 * @return A pair containing the transaction type name and the processed JSON element.
 */
- (THHKotlinPair<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(THHKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)json transactions:(THHTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));

/**
 * Converts a JSON response directly to a [TerminalResult].
 *
 * @param terminalDevice The device associated with the result.
 * @param json The JSON response.
 * @return The parsed TerminalResult, or null if JSON is null.
 */
- (THHTerminalResult * _Nullable)toTerminalResultTerminalDevice:(THHTerminalDevice * _Nullable)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));

/**
 * deserializes a JSON element into a [TerminalResult].
 *
 * @param json The JSON element to transform.
 * @return A [TerminalResult] derived from the JSON.
 */
- (THHTerminalResult *)transformJsonToResultJson:(THHKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHKotlinNothing * _Nullable bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHTerminalCommunicationService *communicationService __attribute__((swift_name("communicationService")));
@property (readonly) BOOL needVerify __attribute__((swift_name("needVerify")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalCashup")))
@interface THHTerminalCashup : THHBaseTerminalCashup
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalCashup __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTerminalCashup *shared __attribute__((swift_name("shared")));
@end


/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((swift_name("Action")))
@interface THHAction : THHBase
- (instancetype)initWithData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHActionCompanion *companion __attribute__((swift_name("companion")));

/**
 * Convenience method to get payment method using the instance's [data].
 *
 * @return The payment method, or null.
 */
- (NSString * _Nullable)getPaymentMethod __attribute__((swift_name("getPaymentMethod()")));

/**
 * Retrieves the payment method identifier from the data map.
 *
 * @param data The map containing transaction data.
 * @return The payment method string, or null if not present.
 */
- (NSString * _Nullable)getPaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));

/**
 * Convenience method to get service payment method using the instance's [data].
 *
 * @return The service payment method.
 */
- (NSString *)getServicePaymentMethod __attribute__((swift_name("getServicePaymentMethod()")));

/**
 * Retrieves the service-specific payment method from the data map.
 *
 * @param data The map containing transaction data.
 * @return The service payment method string.
 */
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));

/**
 * Convenience method to get terminal action using the instance's [data].
 *
 * @return The terminal action, or null.
 */
- (id<THHTerminalAction> _Nullable)getTerminalAction __attribute__((swift_name("getTerminalAction()")));

/**
 * Derives the specific [TerminalAction] from the data map.
 *
 * @param data The map containing transaction data.
 * @return The corresponding [TerminalAction], or null if it cannot be determined.
 */
- (id<THHTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));

/**
 * Convenience method to get transaction amount using the instance's [data].
 *
 * @return The transaction amount.
 */
- (double)getTransactionAmount __attribute__((swift_name("getTransactionAmount()")));

/**
 * Retrieves the transaction amount from the data map.
 *
 * @param data The map containing transaction data.
 * @return The transaction amount as a Double.
 */
- (double)getTransactionAmountData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));

/**
 * Convenience method to get transaction order ID using the instance's [data].
 *
 * @return The order ID, or null.
 */
- (NSString * _Nullable)getTransactionOrderID __attribute__((swift_name("getTransactionOrderID()")));

/**
 * Retrieves the transaction order ID from the data map.
 *
 * @param data The map containing transaction data.
 * @return The order ID string, or null if not present.
 */
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));

/**
 * Determines if this action requires verification.
 *
 * @return True if verification is needed, false otherwise. Defaults to true.
 */
- (BOOL)isNeedVerified __attribute__((swift_name("isNeedVerified()")));
@property (readonly) NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *data __attribute__((swift_name("data")));
@end


/**
 * Represents a fundamental action unit to be transmitted to the Cashup Terminal.
 *
 * This sealed class serves as a wrapper for various terminal operations such as
 * [Payment], [Void], and status checks. It abstracts the transformation
 * of high-level data models into the generic JSON map structure (`Map<String, JsonElement>`)
 * required by the underlying IPC or network layer.
 *
 * @param data The backing map containing raw JSON elements for the action payload.
 */
__attribute__((swift_name("CashupAction")))
@interface THHCashupAction : THHAction
- (instancetype)initWithData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Determines the broad [GenericPaymentMethod] category (e.g., QR or CARD) based on the
 * transaction type found in the data.
 *
 * @param data The raw data map.
 * @return A string representation of the [GenericPaymentMethod].
 */
- (NSString *)getPaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));

/**
 * Identifies the specific service payment method name.
 *
 * Unlike [getPaymentMethod] which returns the broad category, this may return specific
 * scheme names or subtypes if available, though currently defaults to mapping
 * [CashupTerminalAction.QRIS] to [GenericPaymentMethod.QR] and others to [GenericPaymentMethod.CARD].
 *
 * @param data The raw data map.
 * @return The name of the payment method.
 */
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));

/**
 * Resolves the raw transaction type code from the data map into a concrete [TerminalAction].
 *
 * @param data The raw data map.
 * @return The corresponding [CashupTerminalAction] enum entry, or `null` if the type is unrecognized.
 */
- (id<THHTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));

/**
 * Retrieves the transaction amount from the action's data map.
 *
 * @param data The raw data map.
 * @return The transaction amount as a [Double]. Returns `0.0` if the key is missing or parsing fails.
 */
- (double)getTransactionAmountData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));

/**
 * Retrieves the Merchant Transaction ID (Order ID) from the action's data map.
 *
 * @param data The raw data map.
 * @return The Order ID as a [String], or `null` if not present.
 */
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/cashup/data/CashupPaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupPaymentMethod")))
@interface THHCashupPaymentMethod : THHKotlinEnum<THHCashupPaymentMethod *> <THHPaymentMethod>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHCashupPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHCashupPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) THHCashupPaymentMethod *qris __attribute__((swift_name("qris")));
+ (THHKotlinArray<THHCashupPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHCashupPaymentMethod *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupPaymentMethod.Companion")))
@interface THHCashupPaymentMethodCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHCashupPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (THHCashupPaymentMethod *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHCashupPaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHCashupPaymentMethod *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * Represents the top-level API response structure.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupTerminalResult")))
@interface THHCashupTerminalResult : THHBase
- (instancetype)initWithStatus:(NSString * _Nullable)status message:(NSString * _Nullable)message responseCode:(NSString * _Nullable)responseCode approvalCode:(NSString * _Nullable)approvalCode baseAmount:(THHDouble * _Nullable)baseAmount tipAmount:(THHDouble * _Nullable)tipAmount invoiceNum:(NSString * _Nullable)invoiceNum batchNum:(NSString * _Nullable)batchNum rrn:(NSString * _Nullable)rrn midwareTimestamp:(NSString * _Nullable)midwareTimestamp merchantTrxId:(NSString * _Nullable)merchantTrxId deviceId:(NSString * _Nullable)deviceId deviceUser:(NSString * _Nullable)deviceUser additionalParam:(NSString * _Nullable)additionalParam acquirerName:(NSString * _Nullable)acquirerName aid:(NSString * _Nullable)aid applicationLabel:(NSString * _Nullable)applicationLabel batchGroup:(NSString * _Nullable)batchGroup binResult:(NSString * _Nullable)binResult cardExpired:(NSString * _Nullable)cardExpired emvResLen:(THHInt * _Nullable)emvResLen entryMode:(NSString * _Nullable)entryMode hostDate:(NSString * _Nullable)hostDate hostTime:(NSString * _Nullable)hostTime isDebitFlag:(THHBoolean * _Nullable)isDebitFlag maskedPan:(NSString * _Nullable)maskedPan mid:(NSString * _Nullable)mid tid:(NSString * _Nullable)tid tc:(NSString * _Nullable)tc tsi:(NSString * _Nullable)tsi tvr:(NSString * _Nullable)tvr printReceiptAddressLine1:(NSString * _Nullable)printReceiptAddressLine1 printReceiptAddressLine2:(NSString * _Nullable)printReceiptAddressLine2 printReceiptMerchantName:(NSString * _Nullable)printReceiptMerchantName merchantId:(NSString * _Nullable)merchantId merchantName:(NSString * _Nullable)merchantName merchantAddress1:(NSString * _Nullable)merchantAddress1 merchantAddress2:(NSString * _Nullable)merchantAddress2 issuerName:(NSString * _Nullable)issuerName batchGroupId:(THHInt * _Nullable)batchGroupId batchGroupName:(NSString * _Nullable)batchGroupName createAt:(NSString * _Nullable)createAt qrGeneratedAt:(NSString * _Nullable)qrGeneratedAt qrPayAppId:(NSString * _Nullable)qrPayAppId qrPayAppName:(NSString * _Nullable)qrPayAppName __attribute__((swift_name("init(status:message:responseCode:approvalCode:baseAmount:tipAmount:invoiceNum:batchNum:rrn:midwareTimestamp:merchantTrxId:deviceId:deviceUser:additionalParam:acquirerName:aid:applicationLabel:batchGroup:binResult:cardExpired:emvResLen:entryMode:hostDate:hostTime:isDebitFlag:maskedPan:mid:tid:tc:tsi:tvr:printReceiptAddressLine1:printReceiptAddressLine2:printReceiptMerchantName:merchantId:merchantName:merchantAddress1:merchantAddress2:issuerName:batchGroupId:batchGroupName:createAt:qrGeneratedAt:qrPayAppId:qrPayAppName:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHCashupTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (THHCashupTerminalResult *)doCopyStatus:(NSString * _Nullable)status message:(NSString * _Nullable)message responseCode:(NSString * _Nullable)responseCode approvalCode:(NSString * _Nullable)approvalCode baseAmount:(THHDouble * _Nullable)baseAmount tipAmount:(THHDouble * _Nullable)tipAmount invoiceNum:(NSString * _Nullable)invoiceNum batchNum:(NSString * _Nullable)batchNum rrn:(NSString * _Nullable)rrn midwareTimestamp:(NSString * _Nullable)midwareTimestamp merchantTrxId:(NSString * _Nullable)merchantTrxId deviceId:(NSString * _Nullable)deviceId deviceUser:(NSString * _Nullable)deviceUser additionalParam:(NSString * _Nullable)additionalParam acquirerName:(NSString * _Nullable)acquirerName aid:(NSString * _Nullable)aid applicationLabel:(NSString * _Nullable)applicationLabel batchGroup:(NSString * _Nullable)batchGroup binResult:(NSString * _Nullable)binResult cardExpired:(NSString * _Nullable)cardExpired emvResLen:(THHInt * _Nullable)emvResLen entryMode:(NSString * _Nullable)entryMode hostDate:(NSString * _Nullable)hostDate hostTime:(NSString * _Nullable)hostTime isDebitFlag:(THHBoolean * _Nullable)isDebitFlag maskedPan:(NSString * _Nullable)maskedPan mid:(NSString * _Nullable)mid tid:(NSString * _Nullable)tid tc:(NSString * _Nullable)tc tsi:(NSString * _Nullable)tsi tvr:(NSString * _Nullable)tvr printReceiptAddressLine1:(NSString * _Nullable)printReceiptAddressLine1 printReceiptAddressLine2:(NSString * _Nullable)printReceiptAddressLine2 printReceiptMerchantName:(NSString * _Nullable)printReceiptMerchantName merchantId:(NSString * _Nullable)merchantId merchantName:(NSString * _Nullable)merchantName merchantAddress1:(NSString * _Nullable)merchantAddress1 merchantAddress2:(NSString * _Nullable)merchantAddress2 issuerName:(NSString * _Nullable)issuerName batchGroupId:(THHInt * _Nullable)batchGroupId batchGroupName:(NSString * _Nullable)batchGroupName createAt:(NSString * _Nullable)createAt qrGeneratedAt:(NSString * _Nullable)qrGeneratedAt qrPayAppId:(NSString * _Nullable)qrPayAppId qrPayAppName:(NSString * _Nullable)qrPayAppName __attribute__((swift_name("doCopy(status:message:responseCode:approvalCode:baseAmount:tipAmount:invoiceNum:batchNum:rrn:midwareTimestamp:merchantTrxId:deviceId:deviceUser:additionalParam:acquirerName:aid:applicationLabel:batchGroup:binResult:cardExpired:emvResLen:entryMode:hostDate:hostTime:isDebitFlag:maskedPan:mid:tid:tc:tsi:tvr:printReceiptAddressLine1:printReceiptAddressLine2:printReceiptMerchantName:merchantId:merchantName:merchantAddress1:merchantAddress2:issuerName:batchGroupId:batchGroupName:createAt:qrGeneratedAt:qrPayAppId:qrPayAppName:)")));

/**
 * Represents the top-level API response structure.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents the top-level API response structure.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Parses a string in the format "{key=value, key2=value2}" into a Kotlinx JsonElement.
 * * Note: The input string provided is NOT valid JSON (it uses '=' instead of ':' and lacks quotes).
 * This function manually parses that specific format.
 */
- (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)parseStringMapToJsonInput:(NSString *)input __attribute__((swift_name("parseStringMapToJson(input:)")));
- (THHErrorCode * _Nullable)toErrorCode __attribute__((swift_name("toErrorCode()")));

/**
 * Represents the top-level API response structure.
 */
- (NSString *)description __attribute__((swift_name("description()")));
- (THHTerminalResult *)toTerminalResultTerminalDevice:(THHTerminalDevice * _Nullable)terminalDevice __attribute__((swift_name("toTerminalResult(terminalDevice:)")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="acquirer_name")
*/
@property (readonly) NSString * _Nullable acquirerName __attribute__((swift_name("acquirerName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="additional_param")
*/
@property (readonly) NSString * _Nullable additionalParam __attribute__((swift_name("additionalParam")));
@property (readonly) NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable additionalParamObject __attribute__((swift_name("additionalParamObject")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="aid")
*/
@property (readonly) NSString * _Nullable aid __attribute__((swift_name("aid")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="application_label")
*/
@property (readonly) NSString * _Nullable applicationLabel __attribute__((swift_name("applicationLabel")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="approval_code")
*/
@property (readonly) NSString * _Nullable approvalCode __attribute__((swift_name("approvalCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="base_amount")
*/
@property (readonly) THHDouble * _Nullable baseAmount __attribute__((swift_name("baseAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_group")
*/
@property (readonly) NSString * _Nullable batchGroup __attribute__((swift_name("batchGroup")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_group_id")
*/
@property (readonly) THHInt * _Nullable batchGroupId __attribute__((swift_name("batchGroupId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_group_name")
*/
@property (readonly) NSString * _Nullable batchGroupName __attribute__((swift_name("batchGroupName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_num")
*/
@property (readonly) NSString * _Nullable batchNum __attribute__((swift_name("batchNum")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="bin_result")
*/
@property (readonly) NSString * _Nullable binResult __attribute__((swift_name("binResult")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_expired")
*/
@property (readonly) NSString * _Nullable cardExpired __attribute__((swift_name("cardExpired")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="create_at")
*/
@property (readonly) NSString * _Nullable createAt __attribute__((swift_name("createAt")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="device_id")
*/
@property (readonly) NSString * _Nullable deviceId __attribute__((swift_name("deviceId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="device_user")
*/
@property (readonly) NSString * _Nullable deviceUser __attribute__((swift_name("deviceUser")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="emv_res_len")
*/
@property (readonly) THHInt * _Nullable emvResLen __attribute__((swift_name("emvResLen")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="entry_mode")
*/
@property (readonly) NSString * _Nullable entryMode __attribute__((swift_name("entryMode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="host_date")
*/
@property (readonly) NSString * _Nullable hostDate __attribute__((swift_name("hostDate")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="host_time")
*/
@property (readonly) NSString * _Nullable hostTime __attribute__((swift_name("hostTime")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="invoice_num")
*/
@property (readonly) NSString * _Nullable invoiceNum __attribute__((swift_name("invoiceNum")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="is_debit_flag")
*/
@property (readonly) THHBoolean * _Nullable isDebitFlag __attribute__((swift_name("isDebitFlag")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="issuer_name")
*/
@property (readonly) NSString * _Nullable issuerName __attribute__((swift_name("issuerName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="masked_pan")
*/
@property (readonly) NSString * _Nullable maskedPan __attribute__((swift_name("maskedPan")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_address1")
*/
@property (readonly) NSString * _Nullable merchantAddress1 __attribute__((swift_name("merchantAddress1")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_address2")
*/
@property (readonly) NSString * _Nullable merchantAddress2 __attribute__((swift_name("merchantAddress2")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_id")
*/
@property (readonly) NSString * _Nullable merchantId __attribute__((swift_name("merchantId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_name")
*/
@property (readonly) NSString * _Nullable merchantName __attribute__((swift_name("merchantName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_trx_id")
*/
@property (readonly) NSString * _Nullable merchantTrxId __attribute__((swift_name("merchantTrxId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="mid")
*/
@property (readonly) NSString * _Nullable mid __attribute__((swift_name("mid")));
@property (readonly) NSString * _Nullable midwareTimestamp __attribute__((swift_name("midwareTimestamp")));
@property (readonly) THHGenericPaymentMethod *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="print_receipt_address_line_1")
*/
@property (readonly) NSString * _Nullable printReceiptAddressLine1 __attribute__((swift_name("printReceiptAddressLine1")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="print_receipt_address_line_2")
*/
@property (readonly) NSString * _Nullable printReceiptAddressLine2 __attribute__((swift_name("printReceiptAddressLine2")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="print_receipt_merchant_name")
*/
@property (readonly) NSString * _Nullable printReceiptMerchantName __attribute__((swift_name("printReceiptMerchantName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="qr_generated_at")
*/
@property (readonly) NSString * _Nullable qrGeneratedAt __attribute__((swift_name("qrGeneratedAt")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="qr_pay_app_id")
*/
@property (readonly) NSString * _Nullable qrPayAppId __attribute__((swift_name("qrPayAppId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="qr_pay_app_name")
*/
@property (readonly) NSString * _Nullable qrPayAppName __attribute__((swift_name("qrPayAppName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="response_code")
*/
@property (readonly) NSString * _Nullable responseCode __attribute__((swift_name("responseCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="rrn")
*/
@property (readonly) NSString * _Nullable rrn __attribute__((swift_name("rrn")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property (readonly) NSString * _Nullable status __attribute__((swift_name("status")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tc")
*/
@property (readonly) NSString * _Nullable tc __attribute__((swift_name("tc")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tid")
*/
@property (readonly) NSString * _Nullable tid __attribute__((swift_name("tid")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tip_amount")
*/
@property (readonly) THHDouble * _Nullable tipAmount __attribute__((swift_name("tipAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tsi")
*/
@property (readonly) NSString * _Nullable tsi __attribute__((swift_name("tsi")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tvr")
*/
@property (readonly) NSString * _Nullable tvr __attribute__((swift_name("tvr")));
@end


/**
 * Represents the top-level API response structure.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupTerminalResult.Companion")))
@interface THHCashupTerminalResultCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents the top-level API response structure.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHCashupTerminalResultCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents the top-level API response structure.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("BaseFakeResponseGenerator")))
@interface THHBaseFakeResponseGenerator : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FakeResponseGenerator")))
@interface THHFakeResponseGenerator : THHBaseFakeResponseGenerator
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)fakeResponseGenerator __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHFakeResponseGenerator *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupWebSocketService")))
@interface THHCashupWebSocketService : THHWebSocketService
- (instancetype)initWithResultFlow:(id<THHKotlinx_coroutines_coreMutableStateFlow>)resultFlow builder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeDevice:(THHTerminalDevice *)device __attribute__((swift_name("close(device:)")));

/**
 * Connect to the EDC
 * @param device the Terminal Device
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(THHTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
@property (readonly) id<THHKotlinx_coroutines_coreMutableStateFlow> resultFlow __attribute__((swift_name("resultFlow")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppInformation")))
@interface THHAppInformation : THHBase
- (instancetype)initWithAppId:(NSString *)appId appName:(NSString *)appName version:(NSString *)version __attribute__((swift_name("init(appId:appName:version:)"))) __attribute__((objc_designated_initializer));
- (THHAppInformation *)doCopyAppId:(NSString *)appId appName:(NSString *)appName version:(NSString *)version __attribute__((swift_name("doCopy(appId:appName:version:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *appId __attribute__((swift_name("appId")));
@property (readonly) NSString *appName __attribute__((swift_name("appName")));
@property (readonly) NSString *version __attribute__((swift_name("version")));
@end

__attribute__((swift_name("TerminalCore")))
@interface THHTerminalCore<T> : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)addOperationTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("addOperation(terminalOperation:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkVersionWithCompletionHandler:(void (^)(THHLatestVersion * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkVersion(completionHandler:)")));

/**
 * Get the connection state
 * @return the connection state
 */
- (id<THHKotlinx_coroutines_coreFlow>)connectionStateTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("connectionState(terminalOperation:)")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("disconnect(terminalOperation:)")));

/**
 * Send the payload to the EDC
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)doActionActionJob:(THHActionJob *)actionJob terminalOperation:(THHTerminalOperation *)terminalOperation payload:(THHAction *)payload device:(THHTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:terminalOperation:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<THHKotlinx_coroutines_coreJob>)observeConnectionTerminalOperation:(THHTerminalOperation *)terminalOperation onResult:(void (^)(THHConnectionState *))onResult __attribute__((swift_name("observeConnection(terminalOperation:onResult:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<THHKotlinx_coroutines_coreJob>)observeConnectionScope:(id<THHKotlinx_coroutines_coreCoroutineScope>)scope terminalOperation:(THHTerminalOperation *)terminalOperation onResult:(void (^)(THHConnectionState *))onResult __attribute__((swift_name("observeConnection(scope:terminalOperation:onResult:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<THHKotlinx_coroutines_coreJob>)observePayloadScope:(id<THHKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable))onResult __attribute__((swift_name("observePayload(scope:onResult:)")));

/**
 * Set device IP address
 */
- (void)setDeviceIpAddressDeviceIpAddress:(NSString *)deviceIpAddress __attribute__((swift_name("setDeviceIpAddress(deviceIpAddress:)")));

/**
 * Set the log level
 */
- (void)setLogLevelLevel:(THHLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));

/**
 * to enable test environment
 */
- (void)setTerminalModeMode:(THHTerminalMode *)mode __attribute__((swift_name("setTerminalMode(mode:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (T)transformValueJson:(NSString * _Nullable)json __attribute__((swift_name("transformValue(json:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (T)transformValueJson_:(THHKotlinx_serialization_jsonJsonPrimitive * _Nullable)json __attribute__((swift_name("transformValue(json_:)")));

/**
 * Use the WIFI connection
 */
- (void)useWifiTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("useWifi(terminalOperation:)")));

/**
 * Get the WIFI state
 * @return the WIFI state
 */
- (id<THHKotlinx_coroutines_coreFlow>)wifiStateTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("wifiState(terminalOperation:)")));
@property THHDatabaseHandler *database __attribute__((swift_name("database")));
@property THHTerminalMode *mode __attribute__((swift_name("mode")));
@property (readonly) THHInternalNetworkService *networkService __attribute__((swift_name("networkService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppTerminal")))
@interface THHAppTerminal : THHTerminalCore<THHLong *>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (id<THHKotlinx_coroutines_coreFlow>)connectionStateTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("connectionState(terminalOperation:)")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("disconnect(terminalOperation:)")));

/**
 * Send the payload to the EDC
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)doActionActionJob:(THHActionJob *)actionJob terminalOperation:(THHTerminalOperation *)terminalOperation payload:(THHAction *)payload device:(THHTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:terminalOperation:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));
- (void)initializeDriver:(THHDriverFactory *)driver clientKey:(NSString *)clientKey appInfo:(THHAppInformation *)appInfo mode:(THHTerminalMode *)mode __attribute__((swift_name("initialize(driver:clientKey:appInfo:mode:)")));

/**
 * Set device IP address
 */
- (void)setDeviceIpAddressDeviceIpAddress:(NSString *)deviceIpAddress __attribute__((swift_name("setDeviceIpAddress(deviceIpAddress:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHLong *)transformValueJson:(NSString * _Nullable)json __attribute__((swift_name("transformValue(json:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHLong *)transformValueJson_:(THHKotlinx_serialization_jsonJsonPrimitive * _Nullable)json __attribute__((swift_name("transformValue(json_:)")));

/**
 * Use the WIFI connection
 */
- (void)useWifiTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("useWifi(terminalOperation:)")));
- (id<THHKotlinx_coroutines_coreFlow>)wifiStateTerminalOperation:(THHTerminalOperation *)terminalOperation __attribute__((swift_name("wifiState(terminalOperation:)")));
@end

__attribute__((swift_name("BaseTerminal")))
@interface THHBaseTerminal : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)healthCheckWithCompletionHandler:(void (^)(THHBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("healthCheck(completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)initialize __attribute__((swift_name("initialize()")));

/**
 * Sets the global logging verbosity level for the XenTerminal SDK.
 *
 * Log messages with a level lower than the set [level] will typically be suppressed.
 * For instance, if [LogLevel.INFO] is set, [LogLevel.DEBUG] and [LogLevel.VERBOSE] messages
 * will not be displayed.
 *
 * @param level The desired [LogLevel] to set for the SDK's logging output.
 * Use [LogLevel.OFF] to disable all logging, or [LogLevel.VERBOSE]
 * for the most detailed output.
 */
- (void)setLogLevelLevel:(THHLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)versionCheckWithCompletionHandler:(void (^)(THHLatestVersion * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("versionCheck(completionHandler:)")));
@property (readonly) NSString *clientKey __attribute__((swift_name("clientKey")));
@property void (^ _Nullable onInitialize)(void) __attribute__((swift_name("onInitialize")));
@end

__attribute__((swift_name("RuntimeTransacterBase")))
@protocol THHRuntimeTransacterBase
@required
@end


/**
 * A transaction-aware [SqlDriver] wrapper which can begin a [Transaction] on the current connection.
 */
__attribute__((swift_name("RuntimeTransacter")))
@protocol THHRuntimeTransacter <THHRuntimeTransacterBase>
@required

/**
 * Starts a [Transaction] and runs [body] in that transaction.
 *
 * @throws IllegalStateException if [noEnclosing] is true and there is already an active
 *   [Transaction] on this thread.
 */
- (void)transactionNoEnclosing:(BOOL)noEnclosing body:(void (^)(id<THHRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(noEnclosing:body:)")));

/**
 * Starts a [Transaction] and runs [bodyWithReturn] in that transaction.
 *
 * @throws IllegalStateException if [noEnclosing] is true and there is already an active
 *   [Transaction] on this thread.
 */
- (id _Nullable)transactionWithResultNoEnclosing:(BOOL)noEnclosing bodyWithReturn:(id _Nullable (^)(id<THHRuntimeTransactionWithReturn>))bodyWithReturn __attribute__((swift_name("transactionWithResult(noEnclosing:bodyWithReturn:)")));
@end

__attribute__((swift_name("Database")))
@protocol THHDatabase <THHRuntimeTransacter>
@required
@property (readonly) THHServiceQueries *serviceQueries __attribute__((swift_name("serviceQueries")));
@property (readonly) THHTerminalQueries *terminalQueries __attribute__((swift_name("terminalQueries")));
@property (readonly) THHTransactionQueries *transactionQueries __attribute__((swift_name("transactionQueries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseCompanion")))
@interface THHDatabaseCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHDatabaseCompanion *shared __attribute__((swift_name("shared")));
- (id<THHDatabase>)invokeDriver:(id<THHRuntimeSqlDriver>)driver __attribute__((swift_name("invoke(driver:)")));
@property (readonly) id<THHRuntimeSqlSchema> Schema __attribute__((swift_name("Schema")));
@end

__attribute__((swift_name("MultiTerminalOperation")))
@interface THHMultiTerminalOperation : THHBaseTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Adds a terminal provider (e.g., for a specific hardware brand like Verifone or Ingenico)
 * to the map of supported operations.
 *
 * @param provider The [TerminalOperation] implementation for the provider.
 */
- (void)addProviderProvider:(THHTerminalOperation *)provider __attribute__((swift_name("addProvider(provider:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(THHActionJob *)actionJob payload:(THHAction *)payload device:(THHTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Extension function for [Command] that orchestrates its execution on a physical device.
 *
 * Workflow:
 * 1. Finds the device and the appropriate provider for the command.
 * 2. Cleans up previous sessions/connections using [release].
 * 3. Prepares the action payload and cancels any existing sessions on the device.
 * 4. For `PayPayload`, optionally checks transaction status before execution to prevent double charges.
 * 5. Executes the command with a timeout ([withTimeout]) based on the action type.
 * 6. Updates the device state and priority based on the result.
 *
 * @param isSimulation If true, the command is executed in simulation mode.
 * @param completer A callback to report errors encountered during execution.
 * @return A [Result] containing the [TerminalResult] or an error (e.g., TIMEOUT, FAILED_TO_CONNECT).
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)execute:(THHCommand *)receiver devices:(NSArray<THHTerminalDevice *> *)devices isSimulation:(BOOL)isSimulation completer:(void (^)(THHErrorData * _Nullable))completer completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(_:devices:isSimulation:completer:completionHandler:)")));

/**
 * Retrieves a registered terminal provider by its name.
 *
 * @param provider The name of the provider.
 * @return The corresponding [TerminalOperation] or null if not found.
 */
- (THHTerminalOperation * _Nullable)getProviderProvider:(NSString *)provider __attribute__((swift_name("getProvider(provider:)")));
- (BOOL)releaseTerminalID:(NSString *)terminalID __attribute__((swift_name("release(terminalID:)")));

/**
 * Sets the global maximum allowed time in minutes for any operation to complete before timing out.
 * This updates the timeout settings for all [TimeoutType]s.
 *
 * @param minutes The timeout duration in minutes (must be 1 or greater).
 */
- (void)setOperationTimeoutMinutes:(int32_t)minutes __attribute__((swift_name("setOperationTimeout(minutes:)")));

/**
 * Sets the maximum allowed time in minutes for a specific [TimeoutType] operation.
 *
 * @param type The type of operation (e.g., CARD, QR).
 * @param minutes The timeout duration in minutes (must be 1 or greater).
 */
- (void)setOperationTimeoutType:(THHTimeoutType *)type minutes:(int32_t)minutes __attribute__((swift_name("setOperationTimeout(type:minutes:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updateErrorDevice:(THHTerminalDevice *)device state:(THHErrorData * _Nullable)state __attribute__((swift_name("updateError(device:state:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updatePriorityDevice:(THHTerminalDevice *)device state:(int32_t)state __attribute__((swift_name("updatePriority(device:state:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updateStateDevice:(THHTerminalDevice *)device state:(THHConnectionState *)state __attribute__((swift_name("updateState(device:state:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property id<THHKotlinx_coroutines_coreMutableSharedFlow> errorFlow __attribute__((swift_name("errorFlow")));
@property (readonly) THHMutableDictionary<NSString *, THHTerminalOperation *> *terminalOperations __attribute__((swift_name("terminalOperations")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NetInterface")))
@interface THHNetInterface : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)netInterface __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHNetInterface *shared __attribute__((swift_name("shared")));
- (NSSet<NSString *> *)getAddresses __attribute__((swift_name("getAddresses()")));
- (NSString *)getLocalAddress __attribute__((swift_name("getLocalAddress()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalApp")))
@interface THHTerminalApp : THHBaseTerminal
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalApp __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTerminalApp *shared __attribute__((swift_name("shared")));
- (void)initializeClientKey:(NSString *)clientKey mode:(THHTerminalMode *)mode __attribute__((swift_name("initialize(clientKey:mode:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TimeoutType")))
@interface THHTimeoutType : THHKotlinEnum<THHTimeoutType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHTimeoutTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHTimeoutType *card __attribute__((swift_name("card")));
@property (class, readonly) THHTimeoutType *qr __attribute__((swift_name("qr")));
+ (THHKotlinArray<THHTimeoutType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHTimeoutType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TimeoutType.Companion")))
@interface THHTimeoutTypeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTimeoutTypeCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("WifiScannerService")))
@interface THHWifiScannerService : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)scan __attribute__((swift_name("scan()")));
@end

__attribute__((swift_name("ResultListener")))
@protocol THHResultListener
@required
- (void)invokeData:(THHTerminalResult * _Nullable)data error:(THHErrorData * _Nullable)error __attribute__((swift_name("invoke(data:error:)")));
@end


/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Action.Companion")))
@interface THHActionCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHActionCompanion *shared __attribute__((swift_name("shared")));

/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BluetoothData")))
@interface THHBluetoothData<T> : THHBase
- (instancetype)initWithName:(NSString *)name address:(NSString *)address uuids:(THHKotlinArray<NSString *> * _Nullable)uuids alias:(NSString * _Nullable)alias connected:(BOOL)connected data:(T _Nullable)data __attribute__((swift_name("init(name:address:uuids:alias:connected:data:)"))) __attribute__((objc_designated_initializer));
- (THHBluetoothData<T> *)doCopyName:(NSString *)name address:(NSString *)address uuids:(THHKotlinArray<NSString *> * _Nullable)uuids alias:(NSString * _Nullable)alias connected:(BOOL)connected data:(T _Nullable)data __attribute__((swift_name("doCopy(name:address:uuids:alias:connected:data:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *address __attribute__((swift_name("address")));
@property (readonly) NSString * _Nullable alias __attribute__((swift_name("alias")));
@property (readonly) BOOL connected __attribute__((swift_name("connected")));
@property (readonly) T _Nullable data __attribute__((swift_name("data")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) THHKotlinArray<NSString *> * _Nullable uuids __attribute__((swift_name("uuids")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ConnectionState")))
@interface THHConnectionState : THHKotlinEnum<THHConnectionState *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHConnectionState *connected __attribute__((swift_name("connected")));
@property (class, readonly) THHConnectionState *disconnected __attribute__((swift_name("disconnected")));
@property (class, readonly) THHConnectionState *unknown __attribute__((swift_name("unknown")));
@property (class, readonly) THHConnectionState *connecting __attribute__((swift_name("connecting")));
@property (class, readonly) THHConnectionState *connectingFailed __attribute__((swift_name("connectingFailed")));
@property (class, readonly) THHConnectionState *unsupported __attribute__((swift_name("unsupported")));
@property (class, readonly) THHConnectionState *unreachable __attribute__((swift_name("unreachable")));
+ (THHKotlinArray<THHConnectionState *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHConnectionState *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ConnectionType")))
@interface THHConnectionType : THHKotlinEnum<THHConnectionType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHConnectionType *usb __attribute__((swift_name("usb")));
@property (class, readonly) THHConnectionType *bluetooth __attribute__((swift_name("bluetooth")));
@property (class, readonly) THHConnectionType *wifi __attribute__((swift_name("wifi")));
+ (THHKotlinArray<THHConnectionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHConnectionType *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/ErrorCode.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorCode")))
@interface THHErrorCode : THHKotlinEnum<THHErrorCode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHErrorCodeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHErrorCode *invalidCredential __attribute__((swift_name("invalidCredential")));
@property (class, readonly) THHErrorCode *invalidRequest __attribute__((swift_name("invalidRequest")));
@property (class, readonly) THHErrorCode *internalServerError __attribute__((swift_name("internalServerError")));
@property (class, readonly) THHErrorCode *unknownError __attribute__((swift_name("unknownError")));
@property (class, readonly) THHErrorCode *keyInvalid __attribute__((swift_name("keyInvalid")));
@property (class, readonly) THHErrorCode *sendFailed __attribute__((swift_name("sendFailed")));
@property (class, readonly) THHErrorCode *notConnected __attribute__((swift_name("notConnected")));
@property (class, readonly) THHErrorCode *failedToConnect __attribute__((swift_name("failedToConnect")));
@property (class, readonly) THHErrorCode *unsupported __attribute__((swift_name("unsupported")));
@property (class, readonly) THHErrorCode *terminalBusy __attribute__((swift_name("terminalBusy")));
@property (class, readonly) THHErrorCode *encryptionFailed __attribute__((swift_name("encryptionFailed")));
@property (class, readonly) THHErrorCode *declinedByReader __attribute__((swift_name("declinedByReader")));
@property (class, readonly) THHErrorCode *paymentUnpaid __attribute__((swift_name("paymentUnpaid")));
@property (class, readonly) THHErrorCode *duplicated __attribute__((swift_name("duplicated")));
@property (class, readonly) THHErrorCode *cancelled __attribute__((swift_name("cancelled")));
@property (class, readonly) THHErrorCode *timeout __attribute__((swift_name("timeout")));
@property (class, readonly) THHErrorCode *noDataFound __attribute__((swift_name("noDataFound")));
@property (class, readonly) THHErrorCode *voidFailed __attribute__((swift_name("voidFailed")));
@property (class, readonly) THHErrorCode *refunded __attribute__((swift_name("refunded")));
@property (class, readonly) THHErrorCode *needDoSettlement __attribute__((swift_name("needDoSettlement")));
@property (class, readonly) THHErrorCode *chipCardDetected __attribute__((swift_name("chipCardDetected")));
@property (class, readonly) THHErrorCode *transactionFailed __attribute__((swift_name("transactionFailed")));
@property (class, readonly) THHErrorCode *tidNotSet __attribute__((swift_name("tidNotSet")));
@property (class, readonly) THHErrorCode *tidNotMatch __attribute__((swift_name("tidNotMatch")));
@property (class, readonly) THHErrorCode *authenticationFailed __attribute__((swift_name("authenticationFailed")));
@property (class, readonly) THHErrorCode *wrongPin __attribute__((swift_name("wrongPin")));
@property (class, readonly) THHErrorCode *dataNotFound __attribute__((swift_name("dataNotFound")));
@property (class, readonly) THHErrorCode *tidNotFound __attribute__((swift_name("tidNotFound")));
@property (class, readonly) THHErrorCode *cardExpired __attribute__((swift_name("cardExpired")));
@property (class, readonly) THHErrorCode *insufficientFunds __attribute__((swift_name("insufficientFunds")));
@property (class, readonly) THHErrorCode *declinedByIssuer __attribute__((swift_name("declinedByIssuer")));
@property (class, readonly) THHErrorCode *invalidCard __attribute__((swift_name("invalidCard")));
@property (class, readonly) THHErrorCode *stolenCard __attribute__((swift_name("stolenCard")));
@property (class, readonly) THHErrorCode *pinTriesExceeded __attribute__((swift_name("pinTriesExceeded")));
@property (class, readonly) THHErrorCode *badBatchNumber __attribute__((swift_name("badBatchNumber")));
@property (class, readonly) THHErrorCode *originalTransactionNotFound __attribute__((swift_name("originalTransactionNotFound")));
@property (class, readonly) THHErrorCode *issuerInoperative __attribute__((swift_name("issuerInoperative")));
@property (class, readonly) THHErrorCode *unableToRoute __attribute__((swift_name("unableToRoute")));
@property (class, readonly) THHErrorCode *actionCannotBeCompleted __attribute__((swift_name("actionCannotBeCompleted")));
@property (class, readonly) THHErrorCode *serviceUnavailable __attribute__((swift_name("serviceUnavailable")));
@property (class, readonly) THHErrorCode *illegalParameter __attribute__((swift_name("illegalParameter")));
@property (class, readonly) THHErrorCode *reconcileError __attribute__((swift_name("reconcileError")));
@property (class, readonly) THHErrorCode *transactionNotAllowed __attribute__((swift_name("transactionNotAllowed")));
+ (THHKotlinArray<THHErrorCode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHErrorCode *> *entries __attribute__((swift_name("entries")));
- (THHErrorData *)toErrorMessage:(NSString * _Nullable)message __attribute__((swift_name("toError(message:)")));
- (THHResult<id> *)toResultMessage:(NSString * _Nullable)message data:(id _Nullable)data __attribute__((swift_name("toResult(message:data:)")));
@property (readonly) int32_t code __attribute__((swift_name("code")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorCode.Companion")))
@interface THHErrorCodeCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHErrorCodeCompanion *shared __attribute__((swift_name("shared")));
- (THHErrorCode *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHErrorCode *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorData")))
@interface THHErrorData : THHBase
- (instancetype)initWithCode:(THHErrorCode *)code message:(NSString * _Nullable)message __attribute__((swift_name("init(code:message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHErrorDataCompanion *companion __attribute__((swift_name("companion")));
- (THHErrorData *)doCopyCode:(THHErrorCode *)code message:(NSString * _Nullable)message __attribute__((swift_name("doCopy(code:message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
- (THHResult<id> *)transform __attribute__((swift_name("transform()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) THHErrorCode *code __attribute__((swift_name("code")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorData.Companion")))
@interface THHErrorDataCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHErrorDataCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("GenericPaymentMethod")))
@interface THHGenericPaymentMethod : THHKotlinEnum<THHGenericPaymentMethod *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHGenericPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHGenericPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) THHGenericPaymentMethod *qr __attribute__((swift_name("qr")));
@property (class, readonly) THHGenericPaymentMethod *brizzi __attribute__((swift_name("brizzi")));
+ (THHKotlinArray<THHGenericPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHGenericPaymentMethod *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("GenericPaymentMethod.Companion")))
@interface THHGenericPaymentMethodCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHGenericPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PaymentMethodCompanion")))
@interface THHPaymentMethodCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (id<THHPaymentMethod>)fromValueValue:(NSString *)value __attribute__((swift_name("fromValue(value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end


/**
 * Custom KSerializer to handle PaymentMethod serialization using the `value` property.
 * Equivalent to a Gson TypeAdapter.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PaymentMethodSerializer")))
@interface THHPaymentMethodSerializer : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Custom KSerializer to handle PaymentMethod serialization using the `value` property.
 * Equivalent to a Gson TypeAdapter.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)paymentMethodSerializer __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHPaymentMethodSerializer *shared __attribute__((swift_name("shared")));
- (id<THHPaymentMethod>)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(id<THHPaymentMethod>)value __attribute__((swift_name("serialize(encoder:value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Result")))
@interface THHResult<T> : THHBase
- (THHResult<id> *)mapBlock:(id _Nullable (^)(T _Nullable))block __attribute__((swift_name("map(block:)")));
@property (readonly) T _Nullable data __attribute__((swift_name("data")));
@property (readonly) THHErrorData * _Nullable error __attribute__((swift_name("error")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultError")))
@interface THHResultError<T> : THHResult<T>
- (instancetype)initWithData:(T _Nullable)data error:(THHErrorData * _Nullable)error __attribute__((swift_name("init(data:error:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultIdle")))
@interface THHResultIdle<T> : THHResult<T>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultSuccess")))
@interface THHResultSuccess<T> : THHResult<T>
- (instancetype)initWithData:(T _Nullable)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Service")))
@interface THHService : THHBase
- (instancetype)initWithTransaction_id:(NSString *)transaction_id service_payload:(NSString * _Nullable)service_payload service_type:(NSString * _Nullable)service_type sync_flag:(THHLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("init(transaction_id:service_payload:service_type:sync_flag:sync_at:)"))) __attribute__((objc_designated_initializer));
- (THHService *)doCopyTransaction_id:(NSString *)transaction_id service_payload:(NSString * _Nullable)service_payload service_type:(NSString * _Nullable)service_type sync_flag:(THHLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("doCopy(transaction_id:service_payload:service_type:sync_flag:sync_at:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable service_payload __attribute__((swift_name("service_payload")));
@property (readonly) NSString * _Nullable service_type __attribute__((swift_name("service_type")));
@property (readonly) NSString * _Nullable sync_at __attribute__((swift_name("sync_at")));
@property (readonly) THHLong * _Nullable sync_flag __attribute__((swift_name("sync_flag")));
@property (readonly) NSString *transaction_id __attribute__((swift_name("transaction_id")));
@end

__attribute__((swift_name("RuntimeBaseTransacterImpl")))
@interface THHRuntimeBaseTransacterImpl : THHBase
- (instancetype)initWithDriver:(id<THHRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));

/**
 * For internal use, creates a string in the format (?, ?, ?) where there are [count] question marks.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (NSString *)createArgumentsCount:(int32_t)count __attribute__((swift_name("createArguments(count:)")));

/**
 * For internal use, notifies the listeners provided by [listenerProvider] that their underlying result set has
 * changed.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)notifyQueriesIdentifier:(int32_t)identifier tableProvider:(void (^)(THHKotlinUnit *(^)(NSString *)))tableProvider __attribute__((swift_name("notifyQueries(identifier:tableProvider:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (id _Nullable)postTransactionCleanupTransaction:(THHRuntimeTransacterTransaction *)transaction enclosing:(THHRuntimeTransacterTransaction * _Nullable)enclosing thrownException:(THHKotlinThrowable * _Nullable)thrownException returnValue:(id _Nullable)returnValue __attribute__((swift_name("postTransactionCleanup(transaction:enclosing:thrownException:returnValue:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<THHRuntimeSqlDriver> driver __attribute__((swift_name("driver")));
@end


/**
 * A transaction-aware [SqlDriver] wrapper which can begin a [Transaction] on the current connection.
 */
__attribute__((swift_name("RuntimeTransacterImpl")))
@interface THHRuntimeTransacterImpl : THHRuntimeBaseTransacterImpl <THHRuntimeTransacter>
- (instancetype)initWithDriver:(id<THHRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)transactionNoEnclosing:(BOOL)noEnclosing body:(void (^)(id<THHRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(noEnclosing:body:)")));
- (id _Nullable)transactionWithResultNoEnclosing:(BOOL)noEnclosing bodyWithReturn:(id _Nullable (^)(id<THHRuntimeTransactionWithReturn>))bodyWithReturn __attribute__((swift_name("transactionWithResult(noEnclosing:bodyWithReturn:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceQueries")))
@interface THHServiceQueries : THHRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<THHRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)deleteSync __attribute__((swift_name("deleteSync()")));
- (void)insertService:(THHService *)Service __attribute__((swift_name("insert(Service:)")));
- (void)replaceService:(THHService *)Service __attribute__((swift_name("replace(Service:)")));
- (THHRuntimeQuery<THHService *> *)selectByIdTransaction_id:(NSString *)transaction_id __attribute__((swift_name("selectById(transaction_id:)")));
- (THHRuntimeQuery<id> *)selectByIdTransaction_id:(NSString *)transaction_id mapper:(id (^)(NSString *, NSString * _Nullable, NSString * _Nullable, THHLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectById(transaction_id:mapper:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/Status.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Status")))
@interface THHStatus : THHKotlinEnum<THHStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHStatusCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHStatus *success __attribute__((swift_name("success")));
@property (class, readonly) THHStatus *failed __attribute__((swift_name("failed")));
@property (class, readonly) THHStatus *unknown __attribute__((swift_name("unknown")));
+ (THHKotlinArray<THHStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHStatus *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Status.Companion")))
@interface THHStatusCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHStatusCompanion *shared __attribute__((swift_name("shared")));
- (THHStatus *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHStatus *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHStatus *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Terminal")))
@interface THHTerminal : THHBase
- (instancetype)initWithTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("init(tid:actualTid:ipAddress:)"))) __attribute__((objc_designated_initializer));
- (THHTerminal *)doCopyTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("doCopy(tid:actualTid:ipAddress:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *actualTid __attribute__((swift_name("actualTid")));
@property (readonly) NSString * _Nullable ipAddress __attribute__((swift_name("ipAddress")));
@property (readonly) NSString *tid __attribute__((swift_name("tid")));
@end

__attribute__((swift_name("TerminalDevice")))
@interface THHTerminalDevice : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) THHTerminalDeviceCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isProviderAppAvailableProvider:(THHTerminalOperation *)provider __attribute__((swift_name("isProviderAppAvailable(provider:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updateStateDevice:(THHTerminalDevice * _Nullable)device __attribute__((swift_name("updateState(device:)")));
@property (readonly) id<THHKotlinx_coroutines_coreStateFlow> error __attribute__((swift_name("error")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) NSString *ipAddress __attribute__((swift_name("ipAddress")));
@property (readonly) int32_t priority __attribute__((swift_name("priority")));
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));
@property (readonly) id<THHKotlinx_coroutines_coreStateFlow> state __attribute__((swift_name("state")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalDevice.Companion")))
@interface THHTerminalDeviceCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTerminalDeviceCompanion *shared __attribute__((swift_name("shared")));
- (THHTerminalDevice *)createId:(NSString *)id ipAddress:(NSString *)ipAddress provider:(NSString *)provider __attribute__((swift_name("create(id:ipAddress:provider:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalProvider")))
@interface THHTerminalProvider : THHBase
- (instancetype)initWithName:(NSString *)name currency:(NSString *)currency ports:(NSArray<THHInt *> *)ports __attribute__((swift_name("init(name:currency:ports:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSString *currency __attribute__((swift_name("currency")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalQueries")))
@interface THHTerminalQueries : THHRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<THHRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (THHRuntimeQuery<THHTerminal *> *)getAllTid:(NSString *)tid __attribute__((swift_name("getAll(tid:)")));
- (THHRuntimeQuery<id> *)getAllTid:(NSString *)tid mapper:(id (^)(NSString *, NSString *, NSString * _Nullable))mapper __attribute__((swift_name("getAll(tid:mapper:)")));
- (THHRuntimeQuery<THHTerminal *> *)getAllByIpAddressIpAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("getAllByIpAddress(ipAddress:)")));
- (THHRuntimeQuery<id> *)getAllByIpAddressIpAddress:(NSString * _Nullable)ipAddress mapper:(id (^)(NSString *, NSString *, NSString * _Nullable))mapper __attribute__((swift_name("getAllByIpAddress(ipAddress:mapper:)")));
- (void)insertTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("insert(tid:actualTid:ipAddress:)")));
- (void)removeTid:(NSString *)tid __attribute__((swift_name("remove(tid:)")));
- (void)removeAll __attribute__((swift_name("removeAll()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalResult")))
@interface THHTerminalResult : THHBase
- (instancetype)initWithOrderID:(NSString * _Nullable)orderID terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(THHDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(THHStatus * _Nullable)status __attribute__((swift_name("init(orderID:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (THHTerminalResult *)doCopyOrderID:(NSString * _Nullable)orderID terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(THHDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(THHStatus * _Nullable)status __attribute__((swift_name("doCopy(orderID:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) THHDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString * _Nullable currency __attribute__((swift_name("currency")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderID __attribute__((swift_name("orderID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property (readonly) THHStatus * _Nullable status __attribute__((swift_name("status")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_reference")
*/
@property (readonly) NSString * _Nullable terminalReference __attribute__((swift_name("terminalReference")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString * _Nullable transactionDate __attribute__((swift_name("transactionDate")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalResult.Companion")))
@interface THHTerminalResultCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTerminalResultCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionQueries")))
@interface THHTransactionQueries : THHRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<THHRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)deleteSync __attribute__((swift_name("deleteSync()")));
- (void)deleteSyncWithTimeTimestamp:(THHLong * _Nullable)timestamp __attribute__((swift_name("deleteSyncWithTime(timestamp:)")));
- (void)insertTransactions:(THHTransactions *)Transactions __attribute__((swift_name("insert(Transactions:)")));
- (void)replaceTransactions:(THHTransactions *)Transactions __attribute__((swift_name("replace(Transactions:)")));
- (THHRuntimeQuery<THHTransactions *> *)selectAll __attribute__((swift_name("selectAll()")));
- (THHRuntimeQuery<id> *)selectAllMapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, THHLong * _Nullable, THHLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAll(mapper:)")));
- (THHRuntimeQuery<THHTransactions *> *)selectAllWithStatusAndActionStatuses:(id)statuses actions:(id)actions __attribute__((swift_name("selectAllWithStatusAndAction(statuses:actions:)")));
- (THHRuntimeQuery<id> *)selectAllWithStatusAndActionStatuses:(id)statuses actions:(id)actions mapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, THHLong * _Nullable, THHLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAllWithStatusAndAction(statuses:actions:mapper:)")));
- (THHRuntimeQuery<THHTransactions *> *)selectAllWithStatusAndActionAndRangeStatuses:(id)statuses actions:(id)actions from:(THHLong * _Nullable)from end:(THHLong * _Nullable)end __attribute__((swift_name("selectAllWithStatusAndActionAndRange(statuses:actions:from:end:)")));
- (THHRuntimeQuery<id> *)selectAllWithStatusAndActionAndRangeStatuses:(id)statuses actions:(id)actions from:(THHLong * _Nullable)from end:(THHLong * _Nullable)end mapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, THHLong * _Nullable, THHLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAllWithStatusAndActionAndRange(statuses:actions:from:end:mapper:)")));
- (THHRuntimeQuery<THHTransactions *> *)selectUnsync __attribute__((swift_name("selectUnsync()")));
- (THHRuntimeQuery<id> *)selectUnsyncMapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, THHLong * _Nullable, THHLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectUnsync(mapper:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Transactions")))
@interface THHTransactions : THHBase
- (instancetype)initWithId:(NSString *)id transactionId:(NSString *)transactionId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId provider:(NSString * _Nullable)provider action:(NSString *)action request_payload:(NSString *)request_payload response_payload:(NSString *)response_payload tid:(NSString *)tid status:(NSString *)status timestamp:(THHLong * _Nullable)timestamp sync_flag:(THHLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("init(id:transactionId:orderId:paymentRequestId:provider:action:request_payload:response_payload:tid:status:timestamp:sync_flag:sync_at:)"))) __attribute__((objc_designated_initializer));
- (THHTransactions *)doCopyId:(NSString *)id transactionId:(NSString *)transactionId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId provider:(NSString * _Nullable)provider action:(NSString *)action request_payload:(NSString *)request_payload response_payload:(NSString *)response_payload tid:(NSString *)tid status:(NSString *)status timestamp:(THHLong * _Nullable)timestamp sync_flag:(THHLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("doCopy(id:transactionId:orderId:paymentRequestId:provider:action:request_payload:response_payload:tid:status:timestamp:sync_flag:sync_at:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *action __attribute__((swift_name("action")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));
@property (readonly) NSString * _Nullable paymentRequestId __attribute__((swift_name("paymentRequestId")));
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));
@property (readonly) NSString *request_payload __attribute__((swift_name("request_payload")));
@property (readonly) NSString *response_payload __attribute__((swift_name("response_payload")));
@property (readonly) NSString *status __attribute__((swift_name("status")));
@property (readonly) NSString * _Nullable sync_at __attribute__((swift_name("sync_at")));
@property (readonly) THHLong * _Nullable sync_flag __attribute__((swift_name("sync_flag")));
@property (readonly) NSString *tid __attribute__((swift_name("tid")));
@property (readonly) THHLong * _Nullable timestamp __attribute__((swift_name("timestamp")));
@property (readonly) NSString *transactionId __attribute__((swift_name("transactionId")));
@end


/**
 * Represents an action that is not supported by the current implementation.
 *
 * Used as a fallback or placeholder when an action cannot be processed.
 * All data retrieval methods return default empty or null values.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("UnsupportedAction")))
@interface THHUnsupportedAction : THHAction

/**
 * Represents an action that is not supported by the current implementation.
 *
 * Used as a fallback or placeholder when an action cannot be processed.
 * All data retrieval methods return default empty or null values.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Represents an action that is not supported by the current implementation.
 *
 * Used as a fallback or placeholder when an action cannot be processed.
 * All data retrieval methods return default empty or null values.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (NSString * _Nullable)getPaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (id<THHTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CheckVersionRequest")))
@interface THHCheckVersionRequest : THHBase
- (instancetype)initWithCurrentVersion:(NSString *)currentVersion platform:(NSString *)platform __attribute__((swift_name("init(currentVersion:platform:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHCheckVersionRequestCompanion *companion __attribute__((swift_name("companion")));
- (THHCheckVersionRequest *)doCopyCurrentVersion:(NSString *)currentVersion platform:(NSString *)platform __attribute__((swift_name("doCopy(currentVersion:platform:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="current_version")
*/
@property (readonly) NSString *currentVersion __attribute__((swift_name("currentVersion")));
@property (readonly) NSString *platform __attribute__((swift_name("platform")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CheckVersionRequest.Companion")))
@interface THHCheckVersionRequestCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHCheckVersionRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((swift_name("TransactionsRequestPayload")))
@interface THHTransactionsRequestPayload : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHTransactionsRequestPayloadCompanion *companion __attribute__((swift_name("companion")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogsRequest")))
@interface THHLogsRequest : THHTransactionsRequestPayload
- (instancetype)initWithSerialNumber:(NSString *)serialNumber payload:(THHKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("init(serialNumber:payload:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHLogsRequestCompanion *companion __attribute__((swift_name("companion")));
- (THHLogsRequest *)doCopySerialNumber:(NSString *)serialNumber payload:(THHKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("doCopy(serialNumber:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payload")
*/
@property (readonly) THHKotlinx_serialization_jsonJsonElement *payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogsRequest.Companion")))
@interface THHLogsRequestCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHLogsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RawTransactionsRequest")))
@interface THHRawTransactionsRequest : THHBase
- (instancetype)initWithTerminalId:(NSString *)terminalId payload:(THHKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("init(terminalId:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHRawTransactionsRequestCompanion *companion __attribute__((swift_name("companion")));
- (THHRawTransactionsRequest *)doCopyTerminalId:(NSString *)terminalId payload:(THHKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("doCopy(terminalId:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHKotlinx_serialization_jsonJsonElement *payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RawTransactionsRequest.Companion")))
@interface THHRawTransactionsRequestCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHRawTransactionsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationRequest")))
@interface THHSimulationRequest : THHBase
- (instancetype)initWithOrderId:(NSString * _Nullable)orderId terminalId:(NSString *)terminalId paymentMethod:(NSString *)paymentMethod amount:(double)amount currency:(NSString *)currency __attribute__((swift_name("init(orderId:terminalId:paymentMethod:amount:currency:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHSimulationRequestCompanion *companion __attribute__((swift_name("companion")));
- (THHSimulationRequest *)doCopyOrderId:(NSString * _Nullable)orderId terminalId:(NSString *)terminalId paymentMethod:(NSString *)paymentMethod amount:(double)amount currency:(NSString *)currency __attribute__((swift_name("doCopy(orderId:terminalId:paymentMethod:amount:currency:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The total transaction amount.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) double amount __attribute__((swift_name("amount")));

/**
 * The currency for the transaction.
 * Supported values: IDR, VND, THB.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString *currency __attribute__((swift_name("currency")));

/**
 * Order ID. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * Payment method based on the provider.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * The unique identifier for the terminal.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationRequest.Companion")))
@interface THHSimulationRequestCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHSimulationRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequest")))
@interface THHTransactionsRequest<T> : THHBase
- (instancetype)initWithTerminalId:(NSString *)terminalId payload:(T)payload __attribute__((swift_name("init(terminalId:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHTransactionsRequestCompanion *companion __attribute__((swift_name("companion")));
- (THHTransactionsRequest<T> *)doCopyTerminalId:(NSString *)terminalId payload:(T)payload __attribute__((swift_name("doCopy(terminalId:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) T payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequestCompanion")))
@interface THHTransactionsRequestCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTransactionsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeSerial0:(id<THHKotlinx_serialization_coreKSerializer>)typeSerial0 __attribute__((swift_name("serializer(typeSerial0:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequestPayload.Companion")))
@interface THHTransactionsRequestPayloadCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTransactionsRequestPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VerifyRequest")))
@interface THHVerifyRequest : THHTransactionsRequestPayload
- (instancetype)initWithSerialNumber:(NSString *)serialNumber paymentMethod:(NSString *)paymentMethod amount:(double)amount __attribute__((swift_name("init(serialNumber:paymentMethod:amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHVerifyRequestCompanion *companion __attribute__((swift_name("companion")));
- (THHVerifyRequest *)doCopySerialNumber:(NSString *)serialNumber paymentMethod:(NSString *)paymentMethod amount:(double)amount __attribute__((swift_name("doCopy(serialNumber:paymentMethod:amount:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) double amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="serial_number")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VerifyRequest.Companion")))
@interface THHVerifyRequestCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHVerifyRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Command")))
@interface THHCommand : THHBase
- (instancetype)initWithTerminalId:(NSString * _Nullable)terminalId referenceId:(NSString * _Nullable)referenceId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId commandId:(NSString * _Nullable)commandId type:(THHCommandType *)type provider:(NSString * _Nullable)provider created:(NSString * _Nullable)created rawPayload:(THHKotlinx_serialization_jsonJsonElement * _Nullable)rawPayload data:(id<THHCommandPayload>)data __attribute__((swift_name("init(terminalId:referenceId:orderId:paymentRequestId:commandId:type:provider:created:rawPayload:data:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHCommandCompanion *companion __attribute__((swift_name("companion")));
- (THHCommand *)doCopyTerminalId:(NSString * _Nullable)terminalId referenceId:(NSString * _Nullable)referenceId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId commandId:(NSString * _Nullable)commandId type:(THHCommandType *)type provider:(NSString * _Nullable)provider created:(NSString * _Nullable)created rawPayload:(THHKotlinx_serialization_jsonJsonElement * _Nullable)rawPayload data:(id<THHCommandPayload>)data __attribute__((swift_name("doCopy(terminalId:referenceId:orderId:paymentRequestId:commandId:type:provider:created:rawPayload:data:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="command_id")
*/
@property (readonly) NSString * _Nullable commandId __attribute__((swift_name("commandId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="created")
*/
@property (readonly) NSString * _Nullable created __attribute__((swift_name("created")));
@property id<THHCommandPayload> data __attribute__((swift_name("data")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_request_id")
*/
@property (readonly) NSString * _Nullable paymentRequestId __attribute__((swift_name("paymentRequestId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="provider")
*/
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payload")
*/
@property (readonly) THHKotlinx_serialization_jsonJsonElement * _Nullable rawPayload __attribute__((swift_name("rawPayload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reference_id")
*/
@property (readonly) NSString * _Nullable referenceId __attribute__((swift_name("referenceId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="type")
*/
@property (readonly) THHCommandType *type __attribute__((swift_name("type")));
@property (readonly) NSString * _Nullable uniqueID __attribute__((swift_name("uniqueID")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Command.Companion")))
@interface THHCommandCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHCommandCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandConstants")))
@interface THHCommandConstants : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)commandConstants __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHCommandConstants *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *COMMAND_ID_PREFIX __attribute__((swift_name("COMMAND_ID_PREFIX")));
@end

__attribute__((swift_name("CommandPayload")))
@protocol THHCommandPayload
@required

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) THHInt * _Nullable attempts __attribute__((swift_name("attempts")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/response/CommandType.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandType")))
@interface THHCommandType : THHKotlinEnum<THHCommandType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHCommandTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHCommandType *pay __attribute__((swift_name("pay")));
@property (class, readonly) THHCommandType *refund __attribute__((swift_name("refund")));
@property (class, readonly) THHCommandType *void_ __attribute__((swift_name("void_")));
@property (class, readonly) THHCommandType *settle __attribute__((swift_name("settle")));
@property (class, readonly) THHCommandType *printReceipt __attribute__((swift_name("printReceipt")));
@property (class, readonly) THHCommandType *unknown __attribute__((swift_name("unknown")));
+ (THHKotlinArray<THHCommandType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHCommandType *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandType.Companion")))
@interface THHCommandTypeCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHCommandTypeCompanion *shared __attribute__((swift_name("shared")));
- (THHCommandType *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHCommandType *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHCommandType *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Error")))
@interface THHError : THHBase
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHErrorCompanion *companion __attribute__((swift_name("companion")));
- (THHError *)doCopyMessage:(NSString *)message __attribute__((swift_name("doCopy(message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString *message __attribute__((swift_name("message")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Error.Companion")))
@interface THHErrorCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHErrorCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LatestVersion")))
@interface THHLatestVersion : THHBase
- (instancetype)initWithStatus:(THHVersionStatus *)status latestVersion:(NSString * _Nullable)latestVersion downloadUrl:(NSString * _Nullable)downloadUrl releaseNotes:(NSString * _Nullable)releaseNotes __attribute__((swift_name("init(status:latestVersion:downloadUrl:releaseNotes:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHLatestVersionCompanion *companion __attribute__((swift_name("companion")));
- (THHLatestVersion *)doCopyStatus:(THHVersionStatus *)status latestVersion:(NSString * _Nullable)latestVersion downloadUrl:(NSString * _Nullable)downloadUrl releaseNotes:(NSString * _Nullable)releaseNotes __attribute__((swift_name("doCopy(status:latestVersion:downloadUrl:releaseNotes:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="download_url")
*/
@property (readonly) NSString * _Nullable downloadUrl __attribute__((swift_name("downloadUrl")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="latest_version")
*/
@property (readonly) NSString * _Nullable latestVersion __attribute__((swift_name("latestVersion")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="release_notes")
*/
@property (readonly) NSString * _Nullable releaseNotes __attribute__((swift_name("releaseNotes")));
@property (readonly) THHVersionStatus *status __attribute__((swift_name("status")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LatestVersion.Companion")))
@interface THHLatestVersionCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHLatestVersionCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PayPayload")))
@interface THHPayPayload : THHBase <THHCommandPayload>
- (instancetype)initWithRequestAmount:(THHDouble * _Nullable)requestAmount paymentMethods:(NSArray<NSString *> * _Nullable)paymentMethods attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("init(requestAmount:paymentMethods:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHPayPayloadCompanion *companion __attribute__((swift_name("companion")));
- (THHPayPayload *)doCopyRequestAmount:(THHDouble * _Nullable)requestAmount paymentMethods:(NSArray<NSString *> * _Nullable)paymentMethods attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("doCopy(requestAmount:paymentMethods:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) THHInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_methods")
*/
@property (readonly) NSArray<NSString *> * _Nullable paymentMethods __attribute__((swift_name("paymentMethods")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="request_amount")
*/
@property (readonly) THHDouble * _Nullable requestAmount __attribute__((swift_name("requestAmount")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PayPayload.Companion")))
@interface THHPayPayloadCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHPayPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PrintReceiptPayload")))
@interface THHPrintReceiptPayload : THHBase <THHCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHPrintReceiptPayloadCompanion *companion __attribute__((swift_name("companion")));
- (THHPrintReceiptPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) THHInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PrintReceiptPayload.Companion")))
@interface THHPrintReceiptPayloadCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHPrintReceiptPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RefundPayload")))
@interface THHRefundPayload : THHBase <THHCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod requestAmount:(THHDouble * _Nullable)requestAmount reason:(NSString * _Nullable)reason attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:requestAmount:reason:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHRefundPayloadCompanion *companion __attribute__((swift_name("companion")));
- (THHRefundPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod requestAmount:(THHDouble * _Nullable)requestAmount reason:(NSString * _Nullable)reason attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:requestAmount:reason:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) THHInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reason")
*/
@property (readonly) NSString * _Nullable reason __attribute__((swift_name("reason")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="request_amount")
*/
@property (readonly) THHDouble * _Nullable requestAmount __attribute__((swift_name("requestAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_id")
*/
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RefundPayload.Companion")))
@interface THHRefundPayloadCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHRefundPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SettlementPayload")))
@interface THHSettlementPayload : THHBase <THHCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHSettlementPayloadCompanion *companion __attribute__((swift_name("companion")));
- (THHSettlementPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) THHInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SettlementPayload.Companion")))
@interface THHSettlementPayloadCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHSettlementPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationResponse")))
@interface THHSimulationResponse : THHBase
- (instancetype)initWithProvider:(NSString * _Nullable)provider orderId:(NSString * _Nullable)orderId terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(THHDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(NSString * _Nullable)status errorCode:(THHErrorCode * _Nullable)errorCode message:(NSString * _Nullable)message __attribute__((swift_name("init(provider:orderId:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:errorCode:message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHSimulationResponseCompanion *companion __attribute__((swift_name("companion")));
- (THHSimulationResponse *)doCopyProvider:(NSString * _Nullable)provider orderId:(NSString * _Nullable)orderId terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(THHDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(NSString * _Nullable)status errorCode:(THHErrorCode * _Nullable)errorCode message:(NSString * _Nullable)message __attribute__((swift_name("doCopy(provider:orderId:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:errorCode:message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (THHResult<THHTerminalResult *> *)toResultOperation:(THHTerminalOperation *)operation __attribute__((swift_name("toResult(operation:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The total amount of the transaction.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) THHDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * The currency code for the transaction amount.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString * _Nullable currency __attribute__((swift_name("currency")));

/**
 * An error code if the transaction did not succeed. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) THHErrorCode * _Nullable errorCode __attribute__((swift_name("errorCode")));

/**
 * A descriptive message about the transaction's result. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * The unique Order ID for the transaction.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * The payment method used, specific to the provider.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * Provider name.
 * Examples: "BRI", "GHL", "ATOM"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="provider")
*/
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));

/**
 * The final status of the transaction.
 * Example: "SUCCESS"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property (readonly) NSString * _Nullable status __attribute__((swift_name("status")));

/**
 * The identifier for the terminal.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * A reference string from the terminal. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_reference")
*/
@property (readonly) NSString * _Nullable terminalReference __attribute__((swift_name("terminalReference")));

/**
 * The date and time of the transaction, preferably in ISO 8601 format.
 * Example: "2025-07-31T05:37:38Z"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString * _Nullable transactionDate __attribute__((swift_name("transactionDate")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationResponse.Companion")))
@interface THHSimulationResponseCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHSimulationResponseCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionResponse")))
@interface THHTransactionResponse : THHBase
- (instancetype)initWithCode:(NSString * _Nullable)code errorCode:(NSString * _Nullable)errorCode errors:(NSArray<THHError *> * _Nullable)errors message:(NSString * _Nullable)message msg:(NSString * _Nullable)msg __attribute__((swift_name("init(code:errorCode:errors:message:msg:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHTransactionResponseCompanion *companion __attribute__((swift_name("companion")));
- (THHTransactionResponse *)doCopyCode:(NSString * _Nullable)code errorCode:(NSString * _Nullable)errorCode errors:(NSArray<THHError *> * _Nullable)errors message:(NSString * _Nullable)message msg:(NSString * _Nullable)msg __attribute__((swift_name("doCopy(code:errorCode:errors:message:msg:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable apiCode __attribute__((swift_name("apiCode")));
@property (readonly) NSString * _Nullable apiMessage __attribute__((swift_name("apiMessage")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="code")
*/
@property (readonly) NSString * _Nullable code __attribute__((swift_name("code")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) NSString * _Nullable errorCode __attribute__((swift_name("errorCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="errors")
*/
@property (readonly) NSArray<THHError *> * _Nullable errors __attribute__((swift_name("errors")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="msg")
*/
@property (readonly) NSString * _Nullable msg __attribute__((swift_name("msg")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionResponse.Companion")))
@interface THHTransactionResponseCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTransactionResponseCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VersionStatus")))
@interface THHVersionStatus : THHKotlinEnum<THHVersionStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHVersionStatus *upToDate __attribute__((swift_name("upToDate")));
@property (class, readonly) THHVersionStatus *updateAvailable __attribute__((swift_name("updateAvailable")));
@property (class, readonly) THHVersionStatus *forceUpdate __attribute__((swift_name("forceUpdate")));
+ (THHKotlinArray<THHVersionStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHVersionStatus *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VoidPayload")))
@interface THHVoidPayload : THHBase <THHCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHVoidPayloadCompanion *companion __attribute__((swift_name("companion")));
- (THHVoidPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(THHInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) THHInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VoidPayload.Companion")))
@interface THHVoidPayloadCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHVoidPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("AppModule")))
@interface THHAppModule : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (THHKtor_client_coreHttpClient *)apiClientTimeoutInSecond:(THHLong * _Nullable)timeoutInSecond block:(void (^)(THHKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("apiClient(timeoutInSecond:block:)")));
- (THHKtor_client_coreHttpClient *)clientBlock:(void (^)(THHKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("client(block:)")));
- (BOOL)retryRuleException:(THHKotlinException *)exception __attribute__((swift_name("retryRule(exception:)")));
- (THHKtor_client_coreHttpClient *)secureClientTimeoutInSecond:(THHLong * _Nullable)timeoutInSecond block:(void (^)(THHKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("secureClient(timeoutInSecond:block:)")));
- (void)websocketSettingsConfig:(THHKtor_client_coreWebSocketsConfig *)config __attribute__((swift_name("websocketSettings(config:)")));
- (THHKtor_client_coreHttpClient *)wssClientBlock:(void (^)(THHKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("wssClient(block:)")));
@property (readonly) BOOL isDesktop __attribute__((swift_name("isDesktop")));
@property (readonly) int64_t timeoutInSecond __attribute__((swift_name("timeoutInSecond")));
@end

__attribute__((swift_name("BaseSecurity")))
@interface THHBaseSecurity : THHBase
- (instancetype)initWithApiKey:(NSString *)apiKey __attribute__((swift_name("init(apiKey:)"))) __attribute__((objc_designated_initializer));
- (THHResult<NSString *> *)decryptStrToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(strToEncrypt:)")));
- (THHResult<NSString *> *)decryptKey:(THHKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(key:strToEncrypt:)")));
- (THHResult<NSString *> *)encryptStrToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(strToEncrypt:)")));
- (THHResult<NSString *> *)encryptKey:(THHKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(key:strToEncrypt:)")));
@end

__attribute__((swift_name("BluetoothService")))
@protocol THHBluetoothService
@required
- (void)close __attribute__((swift_name("close()")));
- (void)connect __attribute__((swift_name("connect()")));
- (NSArray<THHBluetoothData<id> *> *)scan __attribute__((swift_name("scan()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)sendData:(THHKotlinByteArray *)data completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("send(data:completionHandler:)")));
@property (readonly) id<THHKotlinx_coroutines_coreFlow> isConnected __attribute__((swift_name("isConnected")));
@property (readonly) id<THHKotlinx_coroutines_coreFlow> state __attribute__((swift_name("state")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IOSAppModule")))
@interface THHIOSAppModule : THHAppModule
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (THHKtor_client_coreHttpClient *)clientBlock:(void (^)(THHKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("client(block:)")));
- (BOOL)retryRuleException:(THHKotlinException *)exception __attribute__((swift_name("retryRule(exception:)")));
- (THHKtor_client_coreHttpClient *)secureClientTimeoutInSecond:(THHLong * _Nullable)timeoutInSecond block:(void (^)(THHKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("secureClient(timeoutInSecond:block:)")));
- (void)websocketSettingsConfig:(THHKtor_client_coreWebSocketsConfig *)config __attribute__((swift_name("websocketSettings(config:)")));
@end

__attribute__((swift_name("Platform")))
@protocol THHPlatform
@required
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IOSPlatform")))
@interface THHIOSPlatform : THHBase <THHPlatform>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Security")))
@interface THHSecurity : THHBaseSecurity
- (instancetype)initWithApiKey:(NSString *)apiKey __attribute__((swift_name("init(apiKey:)"))) __attribute__((objc_designated_initializer));
- (THHResult<NSString *> *)decryptKey:(THHKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(key:strToEncrypt:)")));
- (THHResult<NSString *> *)encryptKey:(THHKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(key:strToEncrypt:)")));
@end

__attribute__((swift_name("KotlinThrowable")))
@interface THHKotlinThrowable : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));

/**
 * @note annotations
 *   kotlin.experimental.ExperimentalNativeApi
*/
- (THHKotlinArray<NSString *> *)getStackTrace __attribute__((swift_name("getStackTrace()")));
- (void)printStackTrace __attribute__((swift_name("printStackTrace()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHKotlinThrowable * _Nullable cause __attribute__((swift_name("cause")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
- (NSError *)asError __attribute__((swift_name("asError()")));
@end

__attribute__((swift_name("KotlinException")))
@interface THHKotlinException : THHKotlinThrowable
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinRuntimeException")))
@interface THHKotlinRuntimeException : THHKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinIllegalStateException")))
@interface THHKotlinIllegalStateException : THHKotlinRuntimeException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.4")
*/
__attribute__((swift_name("KotlinCancellationException")))
@interface THHKotlinCancellationException : THHKotlinIllegalStateException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * A custom [CancellationException] used to signal a "force cancel" operation.
 *
 * This exception can be thrown to explicitly stop or cancel an ongoing coroutine
 * or operation, indicating that the cancellation was initiated deliberately and
 * not due to a general system-level cancellation. It inherits from [CancellationException]
 * so that it's typically ignored by generic exception handlers (as [CancellationException]s
 * are often used for flow control rather than error conditions) but can be specifically
 * caught if a particular "force cancel" scenario needs to be handled.
 *
 * @param message An optional message providing more detail about the force cancellation.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ForceCancelException")))
@interface THHForceCancelException : THHKotlinCancellationException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithCause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end


/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RetryCancellationException")))
@interface THHRetryCancellationException : THHKotlinCancellationException

/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((swift_name("BaseProviderAppLauncher")))
@protocol THHBaseProviderAppLauncher
@required
- (BOOL)isProviderAppAvailablePackageName:(NSString *)packageName __attribute__((swift_name("isProviderAppAvailable(packageName:)")));
@property (readonly) THHTerminalCommunicationService *communicationService __attribute__((swift_name("communicationService")));
@end

__attribute__((swift_name("TerminalAppLauncherWrapper")))
@protocol THHTerminalAppLauncherWrapper
@required
- (BOOL)isProviderAppAvailable __attribute__((swift_name("isProviderAppAvailable()")));
@property (readonly) NSString *packageName __attribute__((swift_name("packageName")));
@property id<THHBaseProviderAppLauncher> _Nullable providerAppLauncher __attribute__((swift_name("providerAppLauncher")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InternalNetworkService")))
@interface THHInternalNetworkService : THHBase
- (instancetype)initWithApiUrl:(NSString *)apiUrl __attribute__((swift_name("init(apiUrl:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHInternalNetworkServiceCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandCallbackTerminalId:(NSString *)terminalId request:(THHKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(THHTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commandCallback(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandsTerminalIds:(NSArray<NSString *> *)terminalIds completionHandler:(void (^)(THHResult<NSArray<THHCommand *> *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commands(terminalIds:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)healthWithCompletionHandler:(void (^)(THHResult<THHKotlinUnit *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("health(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)logsRequest:(THHLogsRequest *)request completionHandler:(void (^)(THHTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("logs(request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)refundTerminalId:(NSString *)terminalId request:(THHKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(THHTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("refund(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)simulationTerminalId:(NSString *)terminalId orderID:(NSString * _Nullable)orderID amount:(double)amount paymentMethod:(NSString *)paymentMethod currency:(NSString *)currency completionHandler:(void (^)(THHSimulationResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("simulation(terminalId:orderID:amount:paymentMethod:currency:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)transactionsTerminalId:(NSString *)terminalId request:(THHKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(THHTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("transactions(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)verifyRequest:(THHVerifyRequest *)request completionHandler:(void (^)(THHTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("verify(request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)voidTerminalId:(NSString *)terminalId request:(THHKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(THHTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("void(terminalId:request:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InternalNetworkService.Companion")))
@interface THHInternalNetworkServiceCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHInternalNetworkServiceCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionType")))
@interface THHTransactionType : THHKotlinEnum<THHTransactionType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHTransactionTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHTransactionType *callback __attribute__((swift_name("callback")));
@property (class, readonly) THHTransactionType *payment __attribute__((swift_name("payment")));
@property (class, readonly) THHTransactionType *void_ __attribute__((swift_name("void_")));
+ (THHKotlinArray<THHTransactionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHTransactionType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionType.Companion")))
@interface THHTransactionTypeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTransactionTypeCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("UnsupportedCommunicationService")))
@interface THHUnsupportedCommunicationService : THHTerminalCommunicationService
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(THHTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
@end

__attribute__((swift_name("BaseDatabaseHandler")))
@interface THHBaseDatabaseHandler : THHBase
- (BOOL)isTidMatchTid:(NSString *)tid __attribute__((swift_name("isTidMatch(tid:)")));
@property (readonly) THHBaseSecurity *security __attribute__((swift_name("security")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseHandler")))
@interface THHDatabaseHandler : THHBaseDatabaseHandler
- (instancetype)initWithNetworkService:(THHInternalNetworkService *)networkService database:(id<THHDatabase> _Nullable)database security:(THHBaseSecurity *)security __attribute__((swift_name("init(networkService:database:security:)"))) __attribute__((objc_designated_initializer));
- (THHService * _Nullable)createServiceDataTerminalOperation:(THHTerminalOperation *)terminalOperation transactions:(THHTransactions *)transactions request:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)request response:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)response __attribute__((swift_name("createServiceData(terminalOperation:transactions:request:response:)")));
@property (readonly) id<THHKotlinx_datetimeDateTimeFormat> dateTimeFormat __attribute__((swift_name("dateTimeFormat")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DriverFactory")))
@interface THHDriverFactory : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (id<THHRuntimeSqlDriver> _Nullable)createDriver __attribute__((swift_name("createDriver()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LocalStorage")))
@interface THHLocalStorage : THHBase
- (instancetype)initWithTerminals:(THHMutableDictionary<NSString *, THHTerminal *> *)terminals transactions:(THHMutableDictionary<NSString *, THHTransactions *> *)transactions services:(THHMutableDictionary<NSString *, THHService *> *)services __attribute__((swift_name("init(terminals:transactions:services:)"))) __attribute__((objc_designated_initializer));
- (THHLocalStorage *)doCopyTerminals:(THHMutableDictionary<NSString *, THHTerminal *> *)terminals transactions:(THHMutableDictionary<NSString *, THHTransactions *> *)transactions services:(THHMutableDictionary<NSString *, THHService *> *)services __attribute__((swift_name("doCopy(terminals:transactions:services:)")));
- (void)deleteSyncedTransactions __attribute__((swift_name("deleteSyncedTransactions()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (id)getUnsyncTransactions __attribute__((swift_name("getUnsyncTransactions()")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property THHMutableDictionary<NSString *, THHService *> *services __attribute__((swift_name("services")));
@property (readonly) THHMutableDictionary<NSString *, THHTerminal *> *terminals __attribute__((swift_name("terminals")));
@property THHMutableDictionary<NSString *, THHTransactions *> *transactions __attribute__((swift_name("transactions")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ActionJob")))
@interface THHActionJob : THHBase
- (instancetype)initWithOnCancel:(id<THHKotlinSuspendFunction0>)onCancel onCompleted:(id<THHKotlinSuspendFunction0>)onCompleted onRefresh:(id<THHKotlinSuspendFunction0>)onRefresh cancelable:(BOOL)cancelable block:(id<THHKotlinSuspendFunction1>)block __attribute__((swift_name("init(onCancel:onCompleted:onRefresh:cancelable:block:)"))) __attribute__((objc_designated_initializer));

/**
 * Cancel running SDK job, to allow perform/proceed new action
 */
- (void)cancel __attribute__((swift_name("cancel()")));
- (THHActionJob *)doCopyOnCancel:(id<THHKotlinSuspendFunction0>)onCancel onCompleted:(id<THHKotlinSuspendFunction0>)onCompleted onRefresh:(id<THHKotlinSuspendFunction0>)onRefresh cancelable:(BOOL)cancelable block:(id<THHKotlinSuspendFunction1>)block __attribute__((swift_name("doCopy(onCancel:onCompleted:onRefresh:cancelable:block:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isActive __attribute__((swift_name("isActive()")));
- (void)refresh __attribute__((swift_name("refresh()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<THHKotlinSuspendFunction1> block __attribute__((swift_name("block")));
@property (readonly) id<THHKotlinSuspendFunction0> onCancel __attribute__((swift_name("onCancel")));
@property (readonly) id<THHKotlinSuspendFunction0> onCompleted __attribute__((swift_name("onCompleted")));
@property (readonly) id<THHKotlinSuspendFunction0> onRefresh __attribute__((swift_name("onRefresh")));
@end

__attribute__((swift_name("Kermit_coreLogWriter")))
@interface THHKermit_coreLogWriter : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (BOOL)isLoggableTag:(NSString *)tag severity:(THHKermit_coreSeverity *)severity __attribute__((swift_name("isLoggable(tag:severity:)")));
- (void)logSeverity:(THHKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@end

__attribute__((swift_name("Kermit_ioRollingFileLogWriter")))
@interface THHKermit_ioRollingFileLogWriter : THHKermit_coreLogWriter
- (instancetype)initWithConfig:(THHKermit_ioRollingFileLogWriterConfig *)config messageStringFormatter:(id<THHKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<THHKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(THHKermit_ioRollingFileLogWriterConfig *)config clock:(id<THHKotlinClock>)clock messageStringFormatter:(id<THHKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<THHKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:clock:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (void)logSeverity:(THHKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CustomRollingFileLogWriter")))
@interface THHCustomRollingFileLogWriter : THHKermit_ioRollingFileLogWriter
- (instancetype)initWithConfig:(THHKermit_ioRollingFileLogWriterConfig *)config onLog:(void (^)(THHKermit_coreSeverity *, NSString *, NSString *, THHKotlinThrowable * _Nullable))onLog __attribute__((swift_name("init(config:onLog:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(THHKermit_ioRollingFileLogWriterConfig *)config messageStringFormatter:(id<THHKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<THHKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithConfig:(THHKermit_ioRollingFileLogWriterConfig *)config clock:(id<THHKotlinClock>)clock messageStringFormatter:(id<THHKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<THHKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:clock:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)logSeverity:(THHKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@property (readonly) void (^onLog)(THHKermit_coreSeverity *, NSString *, NSString *, THHKotlinThrowable * _Nullable) __attribute__((swift_name("onLog")));
@end

__attribute__((swift_name("LoggingLoggerApi")))
@protocol THHLoggingLoggerApi
@required
- (void)debugTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("debug(tag:msg:)")));
- (void)errorTag:(NSString *)tag msg:(NSString *)msg t:(THHKotlinThrowable * _Nullable)t __attribute__((swift_name("error(tag:msg:t:)")));
- (void)infoTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("info(tag:msg:)")));
- (void)verboseTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("verbose(tag:msg:)")));
- (void)warnTag:(NSString *)tag msg:(NSString *)msg t:(THHKotlinThrowable * _Nullable)t __attribute__((swift_name("warn(tag:msg:t:)")));
@end

__attribute__((swift_name("LoggingLogLevelController")))
@protocol THHLoggingLogLevelController
@required
- (BOOL)isLoggingDebug __attribute__((swift_name("isLoggingDebug()")));
- (BOOL)isLoggingError __attribute__((swift_name("isLoggingError()")));
- (BOOL)isLoggingInfo __attribute__((swift_name("isLoggingInfo()")));
- (BOOL)isLoggingVerbose __attribute__((swift_name("isLoggingVerbose()")));
- (BOOL)isLoggingWarning __attribute__((swift_name("isLoggingWarning()")));
@end

__attribute__((swift_name("LoggingLogger")))
@protocol THHLoggingLogger <THHLoggingLoggerApi, THHLoggingLogLevelController>
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DesktopLogger")))
@interface THHDesktopLogger : THHBase <THHLoggingLogger>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)debugTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("debug(tag:msg:)")));
- (void)errorTag:(NSString *)tag msg:(NSString *)msg t:(THHKotlinThrowable * _Nullable)t __attribute__((swift_name("error(tag:msg:t:)")));
- (void)infoTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("info(tag:msg:)")));
- (BOOL)isLoggingDebug __attribute__((swift_name("isLoggingDebug()")));
- (BOOL)isLoggingError __attribute__((swift_name("isLoggingError()")));
- (BOOL)isLoggingInfo __attribute__((swift_name("isLoggingInfo()")));
- (BOOL)isLoggingVerbose __attribute__((swift_name("isLoggingVerbose()")));
- (BOOL)isLoggingWarning __attribute__((swift_name("isLoggingWarning()")));
- (void)verboseTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("verbose(tag:msg:)")));
- (void)warnTag:(NSString *)tag msg:(NSString *)msg t:(THHKotlinThrowable * _Nullable)t __attribute__((swift_name("warn(tag:msg:t:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogLevel")))
@interface THHLogLevel : THHKotlinEnum<THHLogLevel *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHLogLevel *off __attribute__((swift_name("off")));
@property (class, readonly) THHLogLevel *info __attribute__((swift_name("info")));
@property (class, readonly) THHLogLevel *debug __attribute__((swift_name("debug")));
@property (class, readonly) THHLogLevel *verbose __attribute__((swift_name("verbose")));
+ (THHKotlinArray<THHLogLevel *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHLogLevel *> *entries __attribute__((swift_name("entries")));

/**
 * The internal integer representation of the log level, used for comparison and filtering.
 * A higher integer value generally indicates a more verbose log level.
 */
- (THHKermit_coreSeverity *)toLevel __attribute__((swift_name("toLevel()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalMode")))
@interface THHTerminalMode : THHKotlinEnum<THHTerminalMode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHTerminalMode *live __attribute__((swift_name("live")));
@property (class, readonly) THHTerminalMode *integration __attribute__((swift_name("integration")));
+ (THHKotlinArray<THHTerminalMode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHTerminalMode *> *entries __attribute__((swift_name("entries")));
@property (readonly) BOOL mock __attribute__((swift_name("mock")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("XLogger")))
@interface THHXLogger : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) THHXLoggerCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("XLogger.Companion")))
@interface THHXLoggerCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHXLoggerCompanion *shared __attribute__((swift_name("shared")));
- (void)debugMessage:(NSString *)message __attribute__((swift_name("debug(message:)")));
- (void)errorE:(THHKotlinException *)e __attribute__((swift_name("error(e:)")));
- (void)errorMessage:(NSString *)message __attribute__((swift_name("error(message:)")));
- (void)errorMessage:(NSString *)message e:(THHKotlinException *)e __attribute__((swift_name("error(message:e:)")));
- (void)infoBlock:(NSString *(^)(void))block __attribute__((swift_name("info(block:)")));
- (void)infoMessage:(NSString *)message __attribute__((swift_name("info(message:)")));
- (void)logToFilePath:(THHKotlinx_io_corePath *)path onLog:(void (^)(THHKermit_coreSeverity *, NSString *, NSString *, THHKotlinThrowable * _Nullable))onLog __attribute__((swift_name("logToFile(path:onLog:)")));
- (void)setLogLevelLevel:(THHLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));
@property (readonly) NSString *LOG_FILE_NAME __attribute__((swift_name("LOG_FILE_NAME")));
@property THHKermit_ioRollingFileLogWriter * _Nullable fileWriter __attribute__((swift_name("fileWriter")));
@property THHKermitLogger *log __attribute__((swift_name("log")));
@end


/**
 * The core abstract class responsible for managing terminal devices, polling for commands,
 * and orchestrating operations between the backend and physical terminal hardware.
 *
 * This gateway handles:
 * - Device registration and connection monitoring.
 * - Polling commands from the server.
 * - Executing commands on specific providers (e.g., Verifone, Ingenico).
 * - Error handling, retries, and timeout management.
 */
__attribute__((swift_name("BaseTerminalGateway")))
@interface THHBaseTerminalGateway : THHMultiTerminalOperation

/**
 * The core abstract class responsible for managing terminal devices, polling for commands,
 * and orchestrating operations between the backend and physical terminal hardware.
 *
 * This gateway handles:
 * - Device registration and connection monitoring.
 * - Polling commands from the server.
 * - Executing commands on specific providers (e.g., Verifone, Ingenico).
 * - Error handling, retries, and timeout management.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * The core abstract class responsible for managing terminal devices, polling for commands,
 * and orchestrating operations between the backend and physical terminal hardware.
 *
 * This gateway handles:
 * - Device registration and connection monitoring.
 * - Polling commands from the server.
 * - Executing commands on specific providers (e.g., Verifone, Ingenico).
 * - Error handling, retries, and timeout management.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Returns a [Flow] that emits connection state changes (e.g., CONNECTED, DISCONNECTED) for a specific device.
 *
 * @param device The terminal device to observe.
 * @return A [Flow] emitting the [ConnectionState] of the device.
 */
- (id<THHKotlinx_coroutines_coreFlow>)connectionStateDevice:(THHTerminalDevice *)device __attribute__((swift_name("connectionState(device:)")));

/**
 * Handles a generic terminal action.
 *
 * Note: This implementation is currently unsupported in the gateway level and
 * will always return an [ErrorCode.UNSUPPORTED] result.
 *
 * @param actionJob The job context associated with the action.
 * @param payload The specific action details/payload.
 * @param device The target terminal device.
 * @param orderId Optional order identifier.
 * @param paymentRequestId Optional payment request identifier.
 * @param isSimulation Flag indicating if the action should run in simulation mode.
 * @param isSynchronize Flag for synchronous execution.
 * @return A [Result] containing [TerminalResult], currently always unsupported.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(THHActionJob *)actionJob payload:(THHAction *)payload device:(THHTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Returns a [StateFlow] that emits error updates for a specific terminal device.
 *
 * @param terminalDevice The device whose error state is to be observed.
 * @return A [StateFlow] emitting the latest [ErrorData] or null.
 */
- (id<THHKotlinx_coroutines_coreStateFlow>)errorStateTerminalDevice:(THHTerminalDevice *)terminalDevice __attribute__((swift_name("errorState(terminalDevice:)")));

/**
 * Extension function for [Command] that orchestrates its execution on a physical device.
 *
 * Workflow:
 * 1. Finds the device and the appropriate provider for the command.
 * 2. Cleans up previous sessions/connections using [release].
 * 3. Prepares the action payload and cancels any existing sessions on the device.
 * 4. For `PayPayload`, optionally checks transaction status before execution to prevent double charges.
 * 5. Executes the command with a timeout ([withTimeout]) based on the action type.
 * 6. Updates the device state and priority based on the result.
 *
 * @param isSimulation If true, the command is executed in simulation mode.
 * @param completer A callback to report errors encountered during execution.
 * @return A [Result] containing the [TerminalResult] or an error (e.g., TIMEOUT, FAILED_TO_CONNECT).
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)execute:(THHCommand *)receiver isSimulation:(BOOL)isSimulation completer:(void (^)(THHErrorData * _Nullable))completer completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(_:isSimulation:completer:completionHandler:)")));

/**
 * Helper function to retrieve the simple class name of the data payload within a command.
 * Used for deduplicating commands in the flow.
 */
- (NSString * _Nullable)getClassNameCommand:(THHCommand * _Nullable)command __attribute__((swift_name("getClassName(command:)")));

/**
 * Checks if the underlying provider application (e.g., the banking app on the terminal)
 * is available and installed.
 *
 * @return True if the provider app is available, false otherwise.
 */
- (BOOL)isProviderAppAvailable __attribute__((swift_name("isProviderAppAvailable()")));

/**
 * Observes the connection state of a specific device, using the default IO Dispatcher.
 *
 * @param device The device to observe.
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine.
 */
- (id<THHKotlinx_coroutines_coreJob>)observeConnectionDevice:(THHTerminalDevice *)device onResult:(void (^)(THHConnectionState *))onResult __attribute__((swift_name("observeConnection(device:onResult:)")));

/**
 * Observes the connection state of a specific device within a given CoroutineScope.
 *
 * @param scope The [CoroutineScope] in which the observation coroutine will be launched.
 * @param device The device to observe.
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine.
 */
- (id<THHKotlinx_coroutines_coreJob>)observeConnectionScope:(id<THHKotlinx_coroutines_coreCoroutineScope>)scope device:(THHTerminalDevice *)device onResult:(void (^)(THHConnectionState *))onResult __attribute__((swift_name("observeConnection(scope:device:onResult:)")));

/**
 * Observes the combined error state from all devices and the gateway, using the default IO Dispatcher.
 *
 * @param onResult The callback function invoked with the device (nullable) and the error data (nullable).
 * @return The [Job] managing the observation coroutine.
 */
- (id<THHKotlinx_coroutines_coreJob>)observeErrorOnResult:(void (^)(THHTerminalDevice * _Nullable, THHErrorData * _Nullable))onResult __attribute__((swift_name("observeError(onResult:)")));

/**
 * Observes the combined error state from all devices and the gateway within a specified CoroutineScope.
 *
 * @param scope The [CoroutineScope] in which to launch the observer.
 * @param onResult The callback function invoked with the device (nullable) and the error data (nullable).
 * @return The [Job] managing the observation coroutine.
 */
- (id<THHKotlinx_coroutines_coreJob>)observeErrorScope:(id<THHKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(THHTerminalDevice * _Nullable, THHErrorData * _Nullable))onResult __attribute__((swift_name("observeError(scope:onResult:)")));

/**
 * Observes the active state of the gateway service, using the default IO Dispatcher.
 *
 * @param onResult The callback function invoked with the latest service state (true for active, false for inactive).
 * @return The [Job] managing the observation coroutine.
 */
- (id<THHKotlinx_coroutines_coreJob>)observeServiceOnResult:(void (^)(THHBoolean *))onResult __attribute__((swift_name("observeService(onResult:)")));

/**
 * Observes the active state of the gateway service within a specified CoroutineScope.
 *
 * @param scope The [CoroutineScope] in which to launch the observer.
 * @param onResult The callback function invoked with the latest service state (true for active, false for inactive).
 * @return The [Job] managing the observation coroutine.
 */
- (id<THHKotlinx_coroutines_coreJob>)observeServiceScope:(id<THHKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(THHBoolean *))onResult __attribute__((swift_name("observeService(scope:onResult:)")));

/**
 * Registers a list of terminal devices with the gateway.
 * This is a convenience method that delegates to the main registration logic with a default scope.
 *
 * @param devices The list of [H2HTerminalDevice] objects to register.
 */
- (void)registerDevicesDevices:(NSArray<THHTerminalDevice *> *)devices __attribute__((swift_name("registerDevices(devices:)")));

/**
 * Registers a list of terminal devices with the gateway.
 * This is a convenience method that delegates to the main registration logic with a default scope.
 *
 * @param devices The list of [H2HTerminalDevice] objects to register.
 * @param restart If true, the service will be restarted to apply the changes immediately.
 */
- (void)registerDevicesDevices:(NSArray<THHTerminalDevice *> *)devices restart:(BOOL)restart __attribute__((swift_name("registerDevices(devices:restart:)")));

/**
 * Registers a list of terminal devices with the gateway, updates the internal device list,
 * configures error reporting flows, and optionally restarts the polling service.
 *
 * @param scope An optional [CoroutineScope] to run the service in.
 * @param devices The list of [H2HTerminalDevice] objects to register.
 * @param restart If true, the service will be stopped and started again to use the new device list.
 */
- (void)registerDevicesScope:(id<THHKotlinx_coroutines_coreCoroutineScope> _Nullable)scope devices:(NSArray<THHTerminalDevice *> *)devices restart:(BOOL)restart __attribute__((swift_name("registerDevices(scope:devices:restart:)")));

/**
 * Restarts one or all managed jobs.
 *
 * @param terminalID The unique identifier of the job to restart.
 * - If `null` (Hard Restart): Calls [releaseAll], clears run states, and restarts the entire service loop via [start].
 * - If provided (Soft Restart): Cancels the specific terminal's job. The main [suspendStart] loop will automatically
 * detect the missing job and recreate it in the next iteration.
 */
- (void)restartTerminalID:(NSString * _Nullable)terminalID __attribute__((swift_name("restart(terminalID:)")));

/**
 * Configures whether the gateway service should start automatically after devices are registered.
 *
 * @param autoStart If true, the service starts automatically; otherwise, it requires a manual [start] call.
 */
- (void)setAutoStartServiceAutoStart:(BOOL)autoStart __attribute__((swift_name("setAutoStartService(autoStart:)")));

/**
 * Sets the maximum number of retry attempts for a single operation before it is considered failed.
 *
 * @param attempt The number of attempts (must be 1 or greater).
 */
- (void)setNumberOfAttemptPerOperationAttempt:(int32_t)attempt __attribute__((swift_name("setNumberOfAttemptPerOperation(attempt:)")));

/**
 * Starts the main gateway service, which polls for and executes commands for registered devices.
 * If the service is already running, this call is ignored.
 *
 * @param scope An optional [CoroutineScope] to run the service in. Defaults to a new scope on the IO dispatcher.
 * @param onComplete A callback invoked when the service is fully stopped via a [ForceCancelException].
 * @param completer A callback to signal the immediate result of the start attempt (e.g., an initial error).
 */
- (void)startScope:(id<THHKotlinx_coroutines_coreCoroutineScope> _Nullable)scope onComplete:(void (^)(void))onComplete completer:(void (^)(THHErrorData * _Nullable))completer __attribute__((swift_name("start(scope:onComplete:completer:)")));

/**
 * Stops ongoing background jobs.
 *
 * @param terminalID The optional ID of the specific terminal job to stop.
 * - If [terminalID] is provided, only the job for that terminal is cancelled (via [ForceCancelException]).
 * - If [terminalID] is null, **all** jobs and the main service loop are stopped, and resources are released.
 *
 * This method is idempotent.
 */
- (void)stopTerminalID:(NSString * _Nullable)terminalID __attribute__((swift_name("stop(terminalID:)")));

/**
 * Pings all registered devices via their respective providers to check for reachability.
 *
 * - If a device is unreachable, its state is set to [ConnectionState.UNREACHABLE] and
 * its priority is lowered (set to [Int.MAX_VALUE]).
 * - If reachable, priority is reset to 0.
 *
 * @return The list of devices with their connection states updated.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)testDevicesConnectionWithCompletionHandler:(void (^)(NSArray<THHTerminalDevice *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("testDevicesConnection(completionHandler:)")));
@property (readonly) NSArray<THHTerminalDevice *> *devices __attribute__((swift_name("devices")));

/**
 * A [Flow] that combines and emits errors from all registered devices as well as gateway-level errors.
 * Each emission is a [Pair] containing:
 * - `first`: The [H2HTerminalDevice] that produced the error, or `null` if it is a general gateway error.
 * - `second`: The [ErrorData] object detailing the error.
 */
@property (readonly) id<THHKotlinx_coroutines_coreFlow> errorsState __attribute__((swift_name("errorsState")));
@property (readonly) THHMutableDictionary<NSString *, THHBoolean *> *isRuns __attribute__((swift_name("isRuns")));

/**
 * A [StateFlow] that indicates whether the main gateway service (command polling loop) is currently active.
 */
@property (readonly) id<THHKotlinx_coroutines_coreStateFlow> isServiceActive __attribute__((swift_name("isServiceActive")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalH2H")))
@interface THHTerminalH2H : THHBaseTerminalGateway
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));

/**
 * The core abstract class responsible for managing terminal devices, polling for commands,
 * and orchestrating operations between the backend and physical terminal hardware.
 *
 * This gateway handles:
 * - Device registration and connection monitoring.
 * - Polling commands from the server.
 * - Executing commands on specific providers (e.g., Verifone, Ingenico).
 * - Error handling, retries, and timeout management.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalH2H __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTerminalH2H *shared __attribute__((swift_name("shared")));
@end


/**
 * Implementation of [TerminalOperation] for NTT (Network Technical Trust) terminals.
 *
 * This class handles communication with NTT devices via WebSocket, maps generic terminal
 * actions to NTT-specific protocols (Sale, Void, PreAuth, etc.), and manages transaction
 * lifecycles. It also handles payload formatting (e.g., amount strings) and backend synchronization.
 */
__attribute__((swift_name("BaseTerminalNTT")))
@interface THHBaseTerminalNTT : THHTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(THHTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Maps a generic [Command.PAY] command to an NTT [NTTAction.Sale] action.
 * Generates a trimmed order ID if necessary and determines the trade type.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHNTTAction * _Nullable)onPayCommand:(THHCommand *)command data:(THHPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onPrintReceiptCommand:(THHCommand *)command data:(THHPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the status of a transaction.
 * Currently, this is not implemented for NTT terminals and returns null.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHKotlinNothing * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onSettlementCommand:(THHCommand *)command data:(THHSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Maps a generic [Command.VOID] command to an NTT [Void] action.
 * Extracts the invoice number from the trace ID.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHNTTAction * _Nullable)onVoidCommand:(THHCommand *)command data:(THHVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Pings the terminal device via WebSocket by sending a test transaction type message.
 * Returns true if the connection is successful.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(THHTerminalDevice *)device completionHandler:(void (^)(THHBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));

/**
 * Prepares the request payload for the NTT terminal.
 *
 * Specifically handles the [NTTAction.AMOUNT] field by ensuring it is formatted
 * as a string with two decimal places (e.g., "100.00"), which is required by the NTT protocol.
 */
- (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(THHAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));
- (NSString * _Nullable)terminalIDData:(THHKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));
- (NSArray<id<THHTerminalAction>> *)toActionsCommandType:(THHCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (THHGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (THHResult<THHTerminalResult *> * _Nullable)toResultTerminalDevice:(THHTerminalDevice *)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));

/**
 * Converts the raw JSON response from the terminal into a format suitable for backend synchronization.
 * Maps valid success statuses to appropriate transaction types (PAYMENT, VOID, CALLBACK).
 *
 * @param request The original request.
 * @param json The response JSON.
 * @param transactions The transaction context.
 * @return A pair of transaction type name and synchronized payload, or null if sync is not required.
 */
- (THHKotlinPair<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(THHKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)json transactions:(THHTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (THHTerminalResult * _Nullable)toTerminalResultTerminalDevice:(THHTerminalDevice * _Nullable)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));
- (THHTerminalResult *)transformJsonToResultJson:(THHKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHKotlinNothing * _Nullable bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHNTTWebSocketService *communicationService __attribute__((swift_name("communicationService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalNTT")))
@interface THHTerminalNTT : THHBaseTerminalNTT
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalNTT __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTerminalNTT *shared __attribute__((swift_name("shared")));
@end


/**
 * Sealed class representing all supported actions for the NTT (Network Technical Trust) terminal protocol.
 * Maps high-level terminal actions to the specific JSON payload keys (e.g., "transaction_type", "trade_type")
 * required by the NTT WebSocket API.
 */
__attribute__((swift_name("NTTAction")))
@interface THHNTTAction : THHAction
- (instancetype)initWithData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHNTTActionCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)getPaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (id<THHTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.Companion")))
@interface THHNTTActionCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHNTTActionCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *AMOUNT __attribute__((swift_name("AMOUNT")));
@property (readonly) NSString *INVOICE_NO __attribute__((swift_name("INVOICE_NO")));
@property (readonly) NSString *POS_REF_NO __attribute__((swift_name("POS_REF_NO")));
@property (readonly) NSString *SERVICE_TYPE __attribute__((swift_name("SERVICE_TYPE")));
@property (readonly) NSString *TRADE_TYPE __attribute__((swift_name("TRADE_TYPE")));
@property (readonly) NSString *TRANSACTION_TYPE __attribute__((swift_name("TRANSACTION_TYPE")));
@end


/**
 * Base class for payment-related actions in the NTT protocol.
 *
 * @param orderID The unique identifier for the order (pos_ref_no).
 * @param amount The transaction amount.
 * @param tradeType The type of trade (e.g., CARD, QR).
 * @param serviceType Optional service type (e.g., SCAN, SHOWQR).
 */
__attribute__((swift_name("NTTAction.Payment")))
@interface THHNTTActionPayment : THHNTTAction
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/ntt/data/NTTPaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTPaymentMethod")))
@interface THHNTTPaymentMethod : THHKotlinEnum<THHNTTPaymentMethod *> <THHPaymentMethod>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHNTTPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHNTTPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) THHNTTPaymentMethod *multiipp __attribute__((swift_name("multiipp")));
@property (class, readonly) THHNTTPaymentMethod *alipayPlus __attribute__((swift_name("alipayPlus")));
@property (class, readonly) THHNTTPaymentMethod *wechatpaycil __attribute__((swift_name("wechatpaycil")));
@property (class, readonly) THHNTTPaymentMethod *wechatpayocgt __attribute__((swift_name("wechatpayocgt")));
@property (class, readonly) THHNTTPaymentMethod *truemoney __attribute__((swift_name("truemoney")));
@property (class, readonly) THHNTTPaymentMethod *linepay __attribute__((swift_name("linepay")));
@property (class, readonly) THHNTTPaymentMethod *shopee __attribute__((swift_name("shopee")));
@property (class, readonly) THHNTTPaymentMethod *bblQrcs __attribute__((swift_name("bblQrcs")));
@property (class, readonly) THHNTTPaymentMethod *thaiqrcode __attribute__((swift_name("thaiqrcode")));
@property (class, readonly) THHNTTPaymentMethod *atome __attribute__((swift_name("atome")));
@property (class, readonly) THHNTTPaymentMethod *sabuymoney __attribute__((swift_name("sabuymoney")));
@property (class, readonly) THHNTTPaymentMethod *maxme __attribute__((swift_name("maxme")));
+ (THHKotlinArray<THHNTTPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHNTTPaymentMethod *> *entries __attribute__((swift_name("entries")));
- (THHGenericPaymentMethod *)toPaymentMethod __attribute__((swift_name("toPaymentMethod()")));
@property (readonly) NSArray<NSString *> * _Nullable alternativeValue __attribute__((swift_name("alternativeValue")));
@property (readonly) THHServiceCapabilities *capabilities __attribute__((swift_name("capabilities")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTPaymentMethod.Companion")))
@interface THHNTTPaymentMethodCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHNTTPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (THHNTTPaymentMethod *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (THHNTTPaymentMethod *)fromTerminalResultResult:(THHTerminalResult *)result __attribute__((swift_name("fromTerminalResult(result:)")));
- (THHNTTPaymentMethod * _Nullable)fromValueValue:(NSString *)value __attribute__((swift_name("fromValue(value:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHNTTPaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHNTTPaymentMethod * _Nullable)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalAction")))
@interface THHNTTTerminalAction : THHKotlinEnum<THHNTTTerminalAction *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHNTTTerminalAction *sale __attribute__((swift_name("sale")));
@property (class, readonly) THHNTTTerminalAction *void_ __attribute__((swift_name("void_")));
+ (THHKotlinArray<THHNTTTerminalAction *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHNTTTerminalAction *> *entries __attribute__((swift_name("entries")));
@end


/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalResult")))
@interface THHNTTTerminalResult : THHBase
- (instancetype)initWithPosRefNo:(NSString * _Nullable)posRefNo transactionType:(THHNTTTransactionType * _Nullable)transactionType tradeType:(THHNTTPaymentMethod * _Nullable)tradeType amount:(THHDouble * _Nullable)amount responseCode:(NSString * _Nullable)responseCode responseMsg:(NSString * _Nullable)responseMsg terminalId:(NSString * _Nullable)terminalId merchantId:(NSString * _Nullable)merchantId transactionId:(NSString * _Nullable)transactionId invoiceNo:(NSString * _Nullable)invoiceNo cardNo:(NSString * _Nullable)cardNo cardType:(NSString * _Nullable)cardType cardApprovalCode:(NSString * _Nullable)cardApprovalCode ippTerm:(NSString * _Nullable)ippTerm monthlyDue:(THHDouble * _Nullable)monthlyDue totalDue:(THHDouble * _Nullable)totalDue paymentDate:(NSString * _Nullable)paymentDate __attribute__((swift_name("init(posRefNo:transactionType:tradeType:amount:responseCode:responseMsg:terminalId:merchantId:transactionId:invoiceNo:cardNo:cardType:cardApprovalCode:ippTerm:monthlyDue:totalDue:paymentDate:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHNTTTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (THHNTTTerminalResult *)doCopyPosRefNo:(NSString * _Nullable)posRefNo transactionType:(THHNTTTransactionType * _Nullable)transactionType tradeType:(THHNTTPaymentMethod * _Nullable)tradeType amount:(THHDouble * _Nullable)amount responseCode:(NSString * _Nullable)responseCode responseMsg:(NSString * _Nullable)responseMsg terminalId:(NSString * _Nullable)terminalId merchantId:(NSString * _Nullable)merchantId transactionId:(NSString * _Nullable)transactionId invoiceNo:(NSString * _Nullable)invoiceNo cardNo:(NSString * _Nullable)cardNo cardType:(NSString * _Nullable)cardType cardApprovalCode:(NSString * _Nullable)cardApprovalCode ippTerm:(NSString * _Nullable)ippTerm monthlyDue:(THHDouble * _Nullable)monthlyDue totalDue:(THHDouble * _Nullable)totalDue paymentDate:(NSString * _Nullable)paymentDate __attribute__((swift_name("doCopy(posRefNo:transactionType:tradeType:amount:responseCode:responseMsg:terminalId:merchantId:transactionId:invoiceNo:cardNo:cardType:cardApprovalCode:ippTerm:monthlyDue:totalDue:paymentDate:)")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (THHErrorCode * _Nullable)toErrorCode __attribute__((swift_name("toErrorCode()")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (NSString *)description __attribute__((swift_name("description()")));
- (THHTerminalResult *)toTerminalResult __attribute__((swift_name("toTerminalResult()")));

/**
 * Total sale amount.
 * Minimum: 1. Example: 1299.99
 */
@property (readonly) THHDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * Card approval code. Optional field.
 * Max length: 6 characters. Example: "ABC123"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_approval_code")
*/
@property (readonly) NSString * _Nullable cardApprovalCode __attribute__((swift_name("cardApprovalCode")));

/**
 * Payer's card number. Optional field.
 * Max length: 19 characters. Example: "411111******1111"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_no")
*/
@property (readonly) NSString * _Nullable cardNo __attribute__((swift_name("cardNo")));

/**
 * Type of card. Optional field.
 * Max length: 10 characters. Example: "VISA"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_type")
*/
@property (readonly) NSString * _Nullable cardType __attribute__((swift_name("cardType")));

/**
 * Invoice Number.
 * Max length: 20 characters. Example: "INV20250606-001"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="invoice_no")
*/
@property (readonly) NSString * _Nullable invoiceNo __attribute__((swift_name("invoiceNo")));

/**
 * Installment Payment Plan (IPP) term. Optional field.
 * Max length: 2 characters. Example: "06"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ipp_term")
*/
@property (readonly) NSString * _Nullable ippTerm __attribute__((swift_name("ippTerm")));

/**
 * Merchant Identifier. Optional field.
 * Max length: 15 characters. Example: "MCH123456789012"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_id")
*/
@property (readonly) NSString * _Nullable merchantId __attribute__((swift_name("merchantId")));

/**
 * Monthly due amount for IPP. Optional field.
 * Example: 216.67
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="monthly_due")
*/
@property (readonly) THHDouble * _Nullable monthlyDue __attribute__((swift_name("monthlyDue")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_date")
*/
@property (readonly) NSString * _Nullable paymentDate __attribute__((swift_name("paymentDate")));

/**
 * Point of Sale Reference Number.
 * Max length: 12 characters. Example: "123456789012"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="pos_ref_no")
*/
@property (readonly) NSString * _Nullable posRefNo __attribute__((swift_name("posRefNo")));

/**
 * Response code from the host.
 * Max length: 2 characters. Example: "00"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="response_code")
*/
@property (readonly) NSString * _Nullable responseCode __attribute__((swift_name("responseCode")));

/**
 * Response message.
 * Max length: 32 characters. Example: "Approved"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="response_msg")
*/
@property (readonly) NSString * _Nullable responseMsg __attribute__((swift_name("responseMsg")));

/**
 * Terminal Identifier.
 * Max length: 8 characters. Example: "TERM1234"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * Total due amount. Optional field.
 * Example: 1300.02
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="total_due")
*/
@property (readonly) THHDouble * _Nullable totalDue __attribute__((swift_name("totalDue")));

/**
 * Type of payment or trade.
 * Restricted to predefined values in TradeTypeEnum.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="trade_type")
*/
@property (readonly) THHNTTPaymentMethod * _Nullable tradeType __attribute__((swift_name("tradeType")));

/**
 * Host Transaction Number.
 * Max length: 32 characters. Example: "TXN202506060001"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_id")
*/
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));

/**
 * Type of the transaction.
 * Restricted to predefined values in TransactionTypeEnum.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_type")
*/
@property (readonly) THHNTTTransactionType * _Nullable transactionType __attribute__((swift_name("transactionType")));
@end


/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalResult.Companion")))
@interface THHNTTTerminalResultCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHNTTTerminalResultCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Enum representing the type of transaction.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTransactionType")))
@interface THHNTTTransactionType : THHKotlinEnum<THHNTTTransactionType *> <THHTerminalAction>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enum representing the type of transaction.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHNTTTransactionTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHNTTTransactionType *sale __attribute__((swift_name("sale")));
@property (class, readonly) THHNTTTransactionType *preauth __attribute__((swift_name("preauth")));
@property (class, readonly) THHNTTTransactionType *void_ __attribute__((swift_name("void_")));
@property (class, readonly) THHNTTTransactionType *query __attribute__((swift_name("query")));
@property (class, readonly) THHNTTTransactionType *precomp __attribute__((swift_name("precomp")));
+ (THHKotlinArray<THHNTTTransactionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHNTTTransactionType *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Enum representing the type of transaction.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTransactionType.Companion")))
@interface THHNTTTransactionTypeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enum representing the type of transaction.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHNTTTransactionTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Enum representing the type of transaction.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * Enum representing the type of transaction.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end


/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceCapabilities")))
@interface THHServiceCapabilities : THHBase
- (instancetype)initWithSupportsScan:(BOOL)supportsScan supportsShowQr:(BOOL)supportsShowQr __attribute__((swift_name("init(supportsScan:supportsShowQr:)"))) __attribute__((objc_designated_initializer));
- (THHServiceCapabilities *)doCopySupportsScan:(BOOL)supportsScan supportsShowQr:(BOOL)supportsShowQr __attribute__((swift_name("doCopy(supportsScan:supportsShowQr:)")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL supportsScan __attribute__((swift_name("supportsScan")));
@property (readonly) BOOL supportsShowQr __attribute__((swift_name("supportsShowQr")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceType")))
@interface THHServiceType : THHKotlinEnum<THHServiceType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHServiceType *scan __attribute__((swift_name("scan")));
@property (class, readonly) THHServiceType *showqr __attribute__((swift_name("showqr")));
+ (THHKotlinArray<THHServiceType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHServiceType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FakeResponseGenerator_")))
@interface THHFakeResponseGenerator_ : THHBaseFakeResponseGenerator
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)fakeResponseGenerator __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHFakeResponseGenerator_ *shared __attribute__((swift_name("shared")));
- (NSString *)formatDateTimeDateTime:(THHKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
- (NSString *)formatToSimpleDateTimeDateTime:(THHKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatToSimpleDateTime(dateTime:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateRawTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(THHResult<THHNTTTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generateRaw(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionFakeCode")))
@interface THHTransactionFakeCode : THHKotlinEnum<THHTransactionFakeCode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHTransactionFakeCode *terminalBusy __attribute__((swift_name("terminalBusy")));
@property (class, readonly) THHTransactionFakeCode *declinedByReader __attribute__((swift_name("declinedByReader")));
@property (class, readonly) THHTransactionFakeCode *duplicated __attribute__((swift_name("duplicated")));
@property (class, readonly) THHTransactionFakeCode *cancelled __attribute__((swift_name("cancelled")));
@property (class, readonly) THHTransactionFakeCode *timeout __attribute__((swift_name("timeout")));
@property (class, readonly) THHTransactionFakeCode *dataNotFound __attribute__((swift_name("dataNotFound")));
@property (class, readonly) THHTransactionFakeCode *voidFailed __attribute__((swift_name("voidFailed")));
@property (class, readonly) THHTransactionFakeCode *needDoSettlement __attribute__((swift_name("needDoSettlement")));
@property (class, readonly) THHTransactionFakeCode *transactionFailed __attribute__((swift_name("transactionFailed")));
@property (class, readonly) THHTransactionFakeCode *tidNotMatch __attribute__((swift_name("tidNotMatch")));
@property (class, readonly) THHTransactionFakeCode *wrongPin __attribute__((swift_name("wrongPin")));
+ (THHKotlinArray<THHTransactionFakeCode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHTransactionFakeCode *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSArray<THHNTTTransactionType *> * _Nullable actions __attribute__((swift_name("actions")));
@property (readonly) id _Nullable amount __attribute__((swift_name("amount")));
@property (readonly) NSString * _Nullable code __attribute__((swift_name("code")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@property (readonly) NSArray<THHNTTPaymentMethod *> * _Nullable methods __attribute__((swift_name("methods")));
@property (readonly) id _Nullable traceNumber __attribute__((swift_name("traceNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTWebSocketService")))
@interface THHNTTWebSocketService : THHWebSocketService
- (instancetype)initWithResultFlow:(id<THHKotlinx_coroutines_coreMutableStateFlow>)resultFlow shouldRetry:(THHBoolean *(^)(THHKotlinException *))shouldRetry builder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:shouldRetry:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * Connect to the EDC
 * @param address the IP address
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(THHTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
@property id<THHKtor_ioByteWriteChannel> _Nullable output __attribute__((swift_name("output")));
@property THHMutableDictionary<NSString *, id<THHKtor_networkSocket>> *sockets __attribute__((swift_name("sockets")));
@end


/**
 * Implementation of [TerminalOperation] for SHC (Soft Space/GHL) terminals.
 *
 * This class interacts with SHC terminals via WebSocket (typically port 8888).
 * It handles:
 * - Specific amount formatting (e.g., padded decimal strings).
 * - Distinguishing between Card and E-Wallet transaction flows.
 * - Session cancellation support.
 * - Mapping generic commands to SHC specific actions (Sale, Void, Settlement).
 */
__attribute__((swift_name("BaseTerminalSHC")))
@interface THHBaseTerminalSHC : THHTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(THHTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Cancels the current session on the terminal device.
 * This sends a specific [SHCAction.CancelSession] command to the device.
 *
 * @param payload The action associated with the session to cancel.
 * @param device The target device.
 * @param isSimulation Flag for simulation mode.
 * @return A [Result] indicating success or failure of the cancellation.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)cancelSessionPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelSession(payload:device:isSimulation:completionHandler:)")));
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(THHActionJob *)actionJob payload:(THHAction *)payload device:(THHTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(THHResult<THHTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Maps a generic [Command.PAY] command to an SHC [SHCAction.Sale] action.
 * Generates an Order ID if missing and determines the product code.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHSHCAction * _Nullable)onPayCommand:(THHCommand *)command data:(THHPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onPrintReceiptCommand:(THHCommand *)command data:(THHPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the status of a transaction.
 * Currently, this is not implemented for SHC terminals and returns null.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(THHAction *)payload device:(THHTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(THHBoolean * _Nullable)isSimulation completionHandler:(void (^)(THHKotlinNothing * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * Maps a generic [Command.SETTLE] command to an SHC Settlement action.
 * Distinguishes between Standard Settlement and E-Wallet Settlement.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHAction * _Nullable)onSettlementCommand:(THHCommand *)command data:(THHSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Maps a generic [Command.VOID] command to an SHC [Void] action.
 * Determines the correct void transaction type based on the payment method.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHSHCAction * _Nullable)onVoidCommand:(THHCommand *)command data:(THHVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Pings the terminal device via WebSocket to check for reachability.
 * Includes a timeout to prevent hanging on unresponsive devices.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(THHTerminalDevice *)device completionHandler:(void (^)(THHBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));

/**
 * Prepares the request payload for the SHC terminal.
 *
 * Formats the [SHCAction.AMOUNT] field to ensure it complies with SHC protocols,
 * typically requiring a string with two decimal places (e.g., "10.00").
 */
- (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(THHAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (THHActionJob *)runActionIt:(THHAction *)it device:(THHTerminalDevice * _Nullable)device isSimulation:(THHBoolean * _Nullable)isSimulation callback:(void (^)(THHTerminalResult * _Nullable, THHErrorData * _Nullable))callback __attribute__((swift_name("runAction(it:device:isSimulation:callback:)")));
- (NSString * _Nullable)terminalIDData:(THHKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));
- (NSArray<id<THHTerminalAction>> *)toActionsCommandType:(THHCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (THHGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (THHResult<THHTerminalResult *> * _Nullable)toResultTerminalDevice:(THHTerminalDevice *)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));

/**
 * Converts the raw JSON response from the terminal into a format suitable for backend synchronization.
 * Maps transaction types (SALE, VOID, CALLBACK) based on the action and success status.
 *
 * @param request The original request.
 * @param json The response JSON.
 * @param transactions The transaction context.
 * @return A pair of transaction type name and synchronized payload, or null if sync is not required.
 */
- (THHKotlinPair<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(THHKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)json transactions:(THHTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (THHTerminalResult * _Nullable)toTerminalResultTerminalDevice:(THHTerminalDevice * _Nullable)terminalDevice json:(THHKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));
- (THHTerminalResult *)transformJsonToResultJson:(THHKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHKotlinNothing * _Nullable bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHTerminalCommunicationService *communicationService __attribute__((swift_name("communicationService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalGHL")))
@interface THHTerminalGHL : THHBaseTerminalSHC
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalGHL __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHTerminalGHL *shared __attribute__((swift_name("shared")));
@end


/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EppDetails")))
@interface THHEppDetails : THHBase
- (instancetype)initWithAcquirer:(NSString *)acquirer tenure:(NSString *)tenure totalAmt:(NSString *)totalAmt monthlyAmt:(NSString *)monthlyAmt finalAmt:(NSString *)finalAmt __attribute__((swift_name("init(acquirer:tenure:totalAmt:monthlyAmt:finalAmt:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHEppDetailsCompanion *companion __attribute__((swift_name("companion")));
- (THHEppDetails *)doCopyAcquirer:(NSString *)acquirer tenure:(NSString *)tenure totalAmt:(NSString *)totalAmt monthlyAmt:(NSString *)monthlyAmt finalAmt:(NSString *)finalAmt __attribute__((swift_name("doCopy(acquirer:tenure:totalAmt:monthlyAmt:finalAmt:)")));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="Acquirer")
*/
@property (readonly) NSString *acquirer __attribute__((swift_name("acquirer")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="FinalAmt")
*/
@property (readonly) NSString *finalAmt __attribute__((swift_name("finalAmt")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="MonthlyAmt")
*/
@property (readonly) NSString *monthlyAmt __attribute__((swift_name("monthlyAmt")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="Tenure")
*/
@property (readonly) NSString *tenure __attribute__((swift_name("tenure")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TotalAmt")
*/
@property (readonly) NSString *totalAmt __attribute__((swift_name("totalAmt")));
@end


/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EppDetails.Companion")))
@interface THHEppDetailsCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHEppDetailsCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Sealed class representing all supported actions for the SHC terminal protocol.
 * Maps high-level terminal actions to the specific JSON payload keys required by the SHC WebSocket API.
 */
__attribute__((swift_name("SHCAction")))
@interface THHSHCAction : THHAction
- (instancetype)initWithData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHSHCActionCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)getPaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (id<THHTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end


/**
 * Represents a request to terminate the current session on the terminal.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCAction.CancelSession")))
@interface THHSHCActionCancelSession : THHSHCAction

/**
 * Represents a request to terminate the current session on the terminal.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Represents a request to terminate the current session on the terminal.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (BOOL)isNeedVerified __attribute__((swift_name("isNeedVerified()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCAction.Companion")))
@interface THHSHCActionCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHSHCActionCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *AMOUNT __attribute__((swift_name("AMOUNT")));
@property (readonly) NSString *POS_REF_NO __attribute__((swift_name("POS_REF_NO")));
@property (readonly) NSString *PRODUCT_CODE __attribute__((swift_name("PRODUCT_CODE")));
@property (readonly) NSString *TRANSACTION_APPROVAL_CODE __attribute__((swift_name("TRANSACTION_APPROVAL_CODE")));
@property (readonly) NSString *TRANSACTION_INVOICE __attribute__((swift_name("TRANSACTION_INVOICE")));
@property (readonly) NSString *TRANSACTION_REF_ID __attribute__((swift_name("TRANSACTION_REF_ID")));
@property (readonly) NSString *TRANSACTION_RRN __attribute__((swift_name("TRANSACTION_RRN")));
@property (readonly) NSString *TRANSACTION_TYPE __attribute__((swift_name("TRANSACTION_TYPE")));
@end


/**
 * Base class for payment-related actions.
 *
 * @param orderID The unique identifier for the order (PosReference).
 * @param amount The transaction amount.
 * @param productCode The specific product code (e.g., specifying a particular card scheme or e-wallet).
 */
__attribute__((swift_name("SHCAction.Payment")))
@interface THHSHCActionPayment : THHSHCAction
@end


/**
 * Represents a Settlement request for standard card transactions.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCAction.Settlement")))
@interface THHSHCActionSettlement : THHSHCAction

/**
 * Represents a Settlement request for standard card transactions.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Represents a Settlement request for standard card transactions.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end


/**
 * Represents a Settlement request specifically for E-Wallet transactions.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCAction.SettlementEWallet")))
@interface THHSHCActionSettlementEWallet : THHSHCAction

/**
 * Represents a Settlement request specifically for E-Wallet transactions.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Represents a Settlement request specifically for E-Wallet transactions.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end


/**
 * Represents QR types with an explicit `value` field and uppercase serial names.
 *
 * @param value The raw string value of the QR type, useful for direct access.
 * @param category The category of the QR type, either GENERATE or SCAN.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/shc/data/SHCPaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethod")))
@interface THHSHCPaymentMethod : THHKotlinEnum<THHSHCPaymentMethod *> <THHPaymentMethod>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents QR types with an explicit `value` field and uppercase serial names.
 *
 * @param value The raw string value of the QR type, useful for direct access.
 * @param category The category of the QR type, either GENERATE or SCAN.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHSHCPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHSHCPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) THHSHCPaymentMethod *ewallet __attribute__((swift_name("ewallet")));
@property (class, readonly) THHSHCPaymentMethod *qrAlipayplus __attribute__((swift_name("qrAlipayplus")));
@property (class, readonly) THHSHCPaymentMethod *qrBoost __attribute__((swift_name("qrBoost")));
@property (class, readonly) THHSHCPaymentMethod *qrDuitnow __attribute__((swift_name("qrDuitnow")));
@property (class, readonly) THHSHCPaymentMethod *qrFavePay __attribute__((swift_name("qrFavePay")));
@property (class, readonly) THHSHCPaymentMethod *qrGrabPay __attribute__((swift_name("qrGrabPay")));
@property (class, readonly) THHSHCPaymentMethod *qrMcash __attribute__((swift_name("qrMcash")));
@property (class, readonly) THHSHCPaymentMethod *qrNetsPay __attribute__((swift_name("qrNetsPay")));
@property (class, readonly) THHSHCPaymentMethod *qrRedPay __attribute__((swift_name("qrRedPay")));
@property (class, readonly) THHSHCPaymentMethod *qrUnionPay __attribute__((swift_name("qrUnionPay")));
+ (THHKotlinArray<THHSHCPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHSHCPaymentMethod *> *entries __attribute__((swift_name("entries")));
- (THHSHCPaymentMethod * _Nullable)filtered __attribute__((swift_name("filtered()")));
- (THHGenericPaymentMethod *)toPaymentMethod __attribute__((swift_name("toPaymentMethod()")));
@property (readonly) THHSHCPaymentMethodCategory * _Nullable category __attribute__((swift_name("category")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethod.Category")))
@interface THHSHCPaymentMethodCategory : THHKotlinEnum<THHSHCPaymentMethodCategory *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHSHCPaymentMethodCategoryCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHSHCPaymentMethodCategory *generate __attribute__((swift_name("generate")));
@property (class, readonly) THHSHCPaymentMethodCategory *scan __attribute__((swift_name("scan")));
+ (THHKotlinArray<THHSHCPaymentMethodCategory *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHSHCPaymentMethodCategory *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethod.CategoryCompanion")))
@interface THHSHCPaymentMethodCategoryCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHSHCPaymentMethodCategoryCompanion *shared __attribute__((swift_name("shared")));

/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethod.Companion")))
@interface THHSHCPaymentMethodCompanion : THHBase <THHKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHSHCPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (THHSHCPaymentMethod *)deserializeDecoder:(id<THHKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (THHSHCPaymentMethod *)fromTerminalResultResult:(THHTerminalResult *)result __attribute__((swift_name("fromTerminalResult(result:)")));
- (void)serializeEncoder:(id<THHKotlinx_serialization_coreEncoder>)encoder value:(THHSHCPaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHSHCPaymentMethod * _Nullable)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<THHKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTerminalAction")))
@interface THHSHCTerminalAction : THHKotlinEnum<THHSHCTerminalAction *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHSHCTerminalAction *sale __attribute__((swift_name("sale")));
@property (class, readonly) THHSHCTerminalAction *void_ __attribute__((swift_name("void_")));
+ (THHKotlinArray<THHSHCTerminalAction *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHSHCTerminalAction *> *entries __attribute__((swift_name("entries")));
@end


/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTerminalResult")))
@interface THHSHCTerminalResult : THHBase
- (instancetype)initWithResponseCode:(NSString * _Nullable)responseCode responseDescription:(NSString * _Nullable)responseDescription transactionType:(THHSHCTransactionType * _Nullable)transactionType transactionAmount:(NSString * _Nullable)transactionAmount transactionMID:(NSString * _Nullable)transactionMID transactionTID:(NSString * _Nullable)transactionTID transactionSTN:(NSString * _Nullable)transactionSTN transactionRRN:(NSString * _Nullable)transactionRRN transactionBatchNo:(NSString * _Nullable)transactionBatchNo transactionApplicationLabel:(NSString * _Nullable)transactionApplicationLabel transactionCardNo:(NSString * _Nullable)transactionCardNo transactionEntryType:(NSString * _Nullable)transactionEntryType transactionARQC:(NSString * _Nullable)transactionARQC transactionTVR:(NSString * _Nullable)transactionTVR transactionAID:(NSString * _Nullable)transactionAID transactionCVM:(NSString * _Nullable)transactionCVM transactionTSI:(NSString * _Nullable)transactionTSI transactionApprovalCode:(NSString * _Nullable)transactionApprovalCode transactionInvoice:(NSString * _Nullable)transactionInvoice transactionSchemeID:(NSString * _Nullable)transactionSchemeID transactionDateTime:(NSString * _Nullable)transactionDateTime transactionEPP:(NSString * _Nullable)transactionEPP posReference:(NSString * _Nullable)posReference transactionRefId:(NSString * _Nullable)transactionRefId __attribute__((swift_name("init(responseCode:responseDescription:transactionType:transactionAmount:transactionMID:transactionTID:transactionSTN:transactionRRN:transactionBatchNo:transactionApplicationLabel:transactionCardNo:transactionEntryType:transactionARQC:transactionTVR:transactionAID:transactionCVM:transactionTSI:transactionApprovalCode:transactionInvoice:transactionSchemeID:transactionDateTime:transactionEPP:posReference:transactionRefId:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHSHCTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (THHSHCTerminalResult *)doCopyResponseCode:(NSString * _Nullable)responseCode responseDescription:(NSString * _Nullable)responseDescription transactionType:(THHSHCTransactionType * _Nullable)transactionType transactionAmount:(NSString * _Nullable)transactionAmount transactionMID:(NSString * _Nullable)transactionMID transactionTID:(NSString * _Nullable)transactionTID transactionSTN:(NSString * _Nullable)transactionSTN transactionRRN:(NSString * _Nullable)transactionRRN transactionBatchNo:(NSString * _Nullable)transactionBatchNo transactionApplicationLabel:(NSString * _Nullable)transactionApplicationLabel transactionCardNo:(NSString * _Nullable)transactionCardNo transactionEntryType:(NSString * _Nullable)transactionEntryType transactionARQC:(NSString * _Nullable)transactionARQC transactionTVR:(NSString * _Nullable)transactionTVR transactionAID:(NSString * _Nullable)transactionAID transactionCVM:(NSString * _Nullable)transactionCVM transactionTSI:(NSString * _Nullable)transactionTSI transactionApprovalCode:(NSString * _Nullable)transactionApprovalCode transactionInvoice:(NSString * _Nullable)transactionInvoice transactionSchemeID:(NSString * _Nullable)transactionSchemeID transactionDateTime:(NSString * _Nullable)transactionDateTime transactionEPP:(NSString * _Nullable)transactionEPP posReference:(NSString * _Nullable)posReference transactionRefId:(NSString * _Nullable)transactionRefId __attribute__((swift_name("doCopy(responseCode:responseDescription:transactionType:transactionAmount:transactionMID:transactionTID:transactionSTN:transactionRRN:transactionBatchNo:transactionApplicationLabel:transactionCardNo:transactionEntryType:transactionARQC:transactionTVR:transactionAID:transactionCVM:transactionTSI:transactionApprovalCode:transactionInvoice:transactionSchemeID:transactionDateTime:transactionEPP:posReference:transactionRefId:)")));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Maps a string-based response code from a terminal or API to a corresponding [ErrorCode].
 *
 * This function consolidates various specific codes into a smaller, more manageable
 * set of semantic errors. A successful response code ("00") will result in a `null`
 * return value, as it does not represent an error.
 *
 * @param responseCode The string code received from the response (e.g., "01", "51", "E6").
 * @return The matching [ErrorCode], or `null` if the transaction was approved ("00").
 * Returns [ErrorCode.UNKNOWN_ERROR] for any unrecognized error codes.
 */
- (THHErrorCode * _Nullable)toErrorCode __attribute__((swift_name("toErrorCode()")));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
- (NSString *)description __attribute__((swift_name("description()")));
- (THHTerminalResult *)toTerminalResult __attribute__((swift_name("toTerminalResult()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="PosReference")
*/
@property (readonly) NSString * _Nullable posReference __attribute__((swift_name("posReference")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ResponseCode")
*/
@property (readonly) NSString * _Nullable responseCode __attribute__((swift_name("responseCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ResponseDescription")
*/
@property (readonly) NSString * _Nullable responseDescription __attribute__((swift_name("responseDescription")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionAID")
*/
@property (readonly) NSString * _Nullable transactionAID __attribute__((swift_name("transactionAID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionARQC")
*/
@property (readonly) NSString * _Nullable transactionARQC __attribute__((swift_name("transactionARQC")));
@property (readonly) NSString * _Nullable transactionAmount __attribute__((swift_name("transactionAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionApplicationLabel")
*/
@property (readonly) NSString * _Nullable transactionApplicationLabel __attribute__((swift_name("transactionApplicationLabel")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionApprovalCode")
*/
@property (readonly) NSString * _Nullable transactionApprovalCode __attribute__((swift_name("transactionApprovalCode")));
@property (readonly) NSString * _Nullable transactionBatchNo __attribute__((swift_name("transactionBatchNo")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionCVM")
*/
@property (readonly) NSString * _Nullable transactionCVM __attribute__((swift_name("transactionCVM")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionCardNo")
*/
@property (readonly) NSString * _Nullable transactionCardNo __attribute__((swift_name("transactionCardNo")));
@property (readonly) NSString * _Nullable transactionDateTime __attribute__((swift_name("transactionDateTime")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionEPP")
*/
@property (readonly) NSString * _Nullable transactionEPP __attribute__((swift_name("transactionEPP")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionEntryType")
*/
@property (readonly) NSString * _Nullable transactionEntryType __attribute__((swift_name("transactionEntryType")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionInvoice")
*/
@property (readonly) NSString * _Nullable transactionInvoice __attribute__((swift_name("transactionInvoice")));
@property (readonly) NSString * _Nullable transactionMID __attribute__((swift_name("transactionMID")));
@property (readonly) NSString * _Nullable transactionRRN __attribute__((swift_name("transactionRRN")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionRefId")
*/
@property (readonly) NSString * _Nullable transactionRefId __attribute__((swift_name("transactionRefId")));
@property (readonly) NSString * _Nullable transactionSTN __attribute__((swift_name("transactionSTN")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionSchemeID")
*/
@property (readonly) NSString * _Nullable transactionSchemeID __attribute__((swift_name("transactionSchemeID")));
@property (readonly) NSString * _Nullable transactionTID __attribute__((swift_name("transactionTID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionTSI")
*/
@property (readonly) NSString * _Nullable transactionTSI __attribute__((swift_name("transactionTSI")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionTVR")
*/
@property (readonly) NSString * _Nullable transactionTVR __attribute__((swift_name("transactionTVR")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionType")
*/
@property (readonly) THHSHCTransactionType * _Nullable transactionType __attribute__((swift_name("transactionType")));
@end


/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTerminalResult.Companion")))
@interface THHSHCTerminalResultCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHSHCTerminalResultCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Represents different types of transactions, serializing to its integer value as a string.
 *
 * @property value The integer code associated with the transaction type.
 * @property type The method of the transaction, either CARD or EWALLET.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTransactionType")))
@interface THHSHCTransactionType : THHKotlinEnum<THHSHCTransactionType *> <THHTerminalAction>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents different types of transactions, serializing to its integer value as a string.
 *
 * @property value The integer code associated with the transaction type.
 * @property type The method of the transaction, either CARD or EWALLET.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHSHCTransactionTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHSHCTransactionType *terminateSession __attribute__((swift_name("terminateSession")));
@property (class, readonly) THHSHCTransactionType *sale __attribute__((swift_name("sale")));
@property (class, readonly) THHSHCTransactionType *void_ __attribute__((swift_name("void_")));
@property (class, readonly) THHSHCTransactionType *settlement __attribute__((swift_name("settlement")));
@property (class, readonly) THHSHCTransactionType *preAuthorization __attribute__((swift_name("preAuthorization")));
@property (class, readonly) THHSHCTransactionType *saleComplete __attribute__((swift_name("saleComplete")));
@property (class, readonly) THHSHCTransactionType *voidPreAuthorization __attribute__((swift_name("voidPreAuthorization")));
@property (class, readonly) THHSHCTransactionType *eWalletSale __attribute__((swift_name("eWalletSale")));
@property (class, readonly) THHSHCTransactionType *eWalletVoid __attribute__((swift_name("eWalletVoid")));
@property (class, readonly) THHSHCTransactionType *eWalletSettlement __attribute__((swift_name("eWalletSettlement")));
@property (class, readonly) THHSHCTransactionType *voidSaleComplete __attribute__((swift_name("voidSaleComplete")));
@property (class, readonly) THHSHCTransactionType *motoSale __attribute__((swift_name("motoSale")));
@property (class, readonly) THHSHCTransactionType *eppSale __attribute__((swift_name("eppSale")));
+ (THHKotlinArray<THHSHCTransactionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHSHCTransactionType *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHSHCPaymentMethod * _Nullable type __attribute__((swift_name("type")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTransactionType.Companion")))
@interface THHSHCTransactionTypeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHSHCTransactionTypeCompanion *shared __attribute__((swift_name("shared")));
- (THHSHCTransactionType *)fromTerminalResultResult:(THHTerminalResult *)result __attribute__((swift_name("fromTerminalResult(result:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(THHKotlinArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (THHSHCTransactionType * _Nullable)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FakeResponseGenerator__")))
@interface THHFakeResponseGenerator__ : THHBaseFakeResponseGenerator
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)fakeResponseGenerator __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHFakeResponseGenerator__ *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCWebSocketService")))
@interface THHSHCWebSocketService : THHWebSocketService
- (instancetype)initWithResultFlow:(id<THHKotlinx_coroutines_coreMutableStateFlow>)resultFlow shouldRetry:(THHBoolean *(^)(THHKotlinException *))shouldRetry builder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:shouldRetry:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(THHKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * Connect to the EDC
 * @param address the IP address
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(THHTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(THHResult<THHKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
- (THHKtor_client_coreHttpClient *)createClientDevice:(THHTerminalDevice *)device __attribute__((swift_name("createClient(device:)")));
@property (readonly) THHKtor_client_coreHttpClient *(^builder)(void) __attribute__((swift_name("builder")));
@end

@interface THHCashupTerminalResult (Extensions)
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
@end

@interface THHPaymentMethodCompanion (Extensions)
- (THHCashupPaymentMethod *)card __attribute__((swift_name("card()")));
- (THHCashupPaymentMethod *)qris __attribute__((swift_name("qris()")));
@end

@interface THHTerminalDeviceCompanion (Extensions)
- (THHTerminalDevice *)briId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("bri(id:ipAddress:)")));
- (THHTerminalDevice *)cashupId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("cashup(id:ipAddress:)")));
- (THHTerminalDevice *)shcId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("shc(id:ipAddress:)")));
@end

@interface THHTerminalResult (Extensions)
- (NSString * _Nullable)approval __attribute__((swift_name("approval()")));
- (NSString * _Nullable)approval_ __attribute__((swift_name("approval_()")));
- (NSString * _Nullable)invoiceNo __attribute__((swift_name("invoiceNo()")));
- (NSString * _Nullable)invoiceNo_ __attribute__((swift_name("invoiceNo_()")));
- (NSString * _Nullable)invoiceNo__ __attribute__((swift_name("invoiceNo__()")));
- (BOOL)isSuccess __attribute__((swift_name("isSuccess()")));
- (BOOL)isSuccess_ __attribute__((swift_name("isSuccess_()")));
- (BOOL)isSuccess__ __attribute__((swift_name("isSuccess__()")));
- (BOOL)isSuccess___ __attribute__((swift_name("isSuccess___()")));
- (NSString * _Nullable)referenceID __attribute__((swift_name("referenceID()")));
- (NSString * _Nullable)referenceID_ __attribute__((swift_name("referenceID_()")));
- (NSString * _Nullable)referenceNumber __attribute__((swift_name("referenceNumber()")));
- (NSString * _Nullable)rrn __attribute__((swift_name("rrn()")));
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
- (NSString *)toRaw_ __attribute__((swift_name("toRaw_()")));
- (NSString *)toRaw__ __attribute__((swift_name("toRaw__()")));
- (NSString *)toRaw___ __attribute__((swift_name("toRaw___()")));
- (THHNTTPaymentMethod * _Nullable)tradeType __attribute__((swift_name("tradeType()")));
@end

@interface THHNTTTerminalResult (Extensions)
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
@end

@interface THHSHCTerminalResult (Extensions)
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalDateTimeSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateTime")))
@interface THHKotlinx_datetimeLocalDateTime : THHBase <THHKotlinComparable>
- (instancetype)initWithDate:(THHKotlinx_datetimeLocalDate *)date time:(THHKotlinx_datetimeLocalTime *)time __attribute__((swift_name("init(date:time:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(int32_t)month day:(int32_t)day hour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(year:month:day:hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(THHKotlinx_datetimeMonth *)month day:(int32_t)day hour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond_:(int32_t)nanosecond __attribute__((swift_name("init(year:month:day:hour:minute:second:nanosecond_:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinx_datetimeLocalDateTimeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(THHKotlinx_datetimeLocalDateTime *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHKotlinx_datetimeLocalDate *date __attribute__((swift_name("date")));
@property (readonly) int32_t day __attribute__((swift_name("day")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth"))) __attribute__((deprecated("Use the 'day' property instead")));
@property (readonly) THHKotlinx_datetimeDayOfWeek *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) int32_t hour __attribute__((swift_name("hour")));
@property (readonly) int32_t minute __attribute__((swift_name("minute")));
@property (readonly) THHKotlinx_datetimeMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t monthNumber __attribute__((swift_name("monthNumber"))) __attribute__((deprecated("Use the 'month' property instead")));
@property (readonly) int32_t nanosecond __attribute__((swift_name("nanosecond")));
@property (readonly) int32_t second __attribute__((swift_name("second")));
@property (readonly) THHKotlinx_datetimeLocalTime *time __attribute__((swift_name("time")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end

@interface THHKotlinx_datetimeLocalDateTime (Extensions)
- (NSString *)formatTransactionDateTime __attribute__((swift_name("formatTransactionDateTime()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/TimeZoneSerializer))
*/
__attribute__((swift_name("Kotlinx_datetimeTimeZone")))
@interface THHKotlinx_datetimeTimeZone : THHBase
@property (class, readonly, getter=companion) THHKotlinx_datetimeTimeZoneCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (THHKotlinInstant *)toInstant:(THHKotlinx_datetimeLocalDateTime *)receiver youShallNotPass:(THHKotlinx_datetimeOverloadMarker *)youShallNotPass __attribute__((swift_name("toInstant(_:youShallNotPass:)")));
- (THHKotlinx_datetimeLocalDateTime *)toLocalDateTime:(THHKotlinInstant *)receiver __attribute__((swift_name("toLocalDateTime(_:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@end

@interface THHKotlinx_datetimeTimeZone (Extensions)

/**
 * Converts a TimeZone to a GMT string like "GMT+08:00".
 * @param instant The specific moment in time to get the offset for.
 * Defaults to the current system time.
 */
- (NSString *)toGmtStringInstant:(THHKotlinInstant *)instant __attribute__((swift_name("toGmtString(instant:)")));

/**
 * Converts a TimeZone to a GMT string like "GMT+08:00".
 * @param instant The specific moment in time to get the offset for.
 * Defaults to the current system time.
 */
- (NSString *)toOffsetInstant:(THHKotlinInstant *)instant __attribute__((swift_name("toOffset(instant:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppModule_iosKt")))
@interface THHAppModule_iosKt : THHBase
+ (THHAppModule *)getAppModule __attribute__((swift_name("getAppModule()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionKt")))
@interface THHBRIActionKt : THHBase

/**
 * Formats a [LocalDateTime] into the string format required by BRI ("yyyy-MM-dd HH:mm:ss").
 */
+ (NSString *)formatDateTimeDateTime:(THHKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));

/**
 * Formats a [LocalDateTime] into a full ISO-like string with timezone ("yyyy-MM-dd'T'HH:mm:sszzz").
 */
+ (NSString *)formatDateTimeWithTimeZoneDateTime:(THHKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTimeWithTimeZone(dateTime:)")));

/**
 * Parses a date string into a [LocalDateTime], defaulting to GMT+0700 if no timezone is provided.
 */
+ (THHKotlinx_datetimeLocalDateTime * _Nullable)parseDateTimeDateTime:(NSString *)dateTime timeZone:(THHKotlinx_datetimeTimeZone *)timeZone __attribute__((swift_name("parseDateTime(dateTime:timeZone:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPaymentMethodKt")))
@interface THHBRIPaymentMethodKt : THHBase
+ (THHBRIPaymentMethod *)brizzi:(id<THHPaymentMethod>)receiver __attribute__((swift_name("brizzi(_:)")));
+ (THHBRIPaymentMethod *)contactless:(id<THHPaymentMethod>)receiver __attribute__((swift_name("contactless(_:)")));
+ (THHBRIPaymentMethod *)insertCard:(id<THHPaymentMethod>)receiver __attribute__((swift_name("insertCard(_:)")));
+ (THHBRIPaymentMethod *)qris:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qris(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BaseDatabaseKt")))
@interface THHBaseDatabaseKt : THHBase
+ (BOOL)contains:(NSArray<id<THHTerminalAction>> *)receiver value:(NSString * _Nullable)value __attribute__((swift_name("contains(_:value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Bluetooth_iosKt")))
@interface THHBluetooth_iosKt : THHBase
+ (id<THHBluetoothService>)getBriBluetoothServiceResult:(id<THHKotlinx_coroutines_coreMutableStateFlow>)result __attribute__((swift_name("getBriBluetoothService(result:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriTerminalResultKt")))
@interface THHBriTerminalResultKt : THHBase
+ (THHResult<THHKotlinx_serialization_jsonJsonElement *> *)parseBriResponse:(NSString *)receiver __attribute__((swift_name("parseBriResponse(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseKt")))
@interface THHDatabaseKt : THHBase
+ (THHDatabaseHandler *)createDatabaseDriverFactory:(THHDriverFactory *)driverFactory oldSecurity:(THHBaseSecurity *)oldSecurity security:(THHBaseSecurity *)security networkService:(THHInternalNetworkService *)networkService __attribute__((swift_name("createDatabase(driverFactory:oldSecurity:security:networkService:)")));
@property (class, readonly) NSString *DB_NAME __attribute__((swift_name("DB_NAME")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DateUtilKt")))
@interface THHDateUtilKt : THHBase
+ (NSString *)addDeviceOffset:(NSString *)receiver __attribute__((swift_name("addDeviceOffset(_:)")));
+ (NSString *)toDateWithT:(NSString *)receiver __attribute__((swift_name("toDateWithT(_:)")));

/**
 * Helper to convert the timestamp string to a LocalDateTime object.
 * Automatically handles Seconds (10 digits) vs Milliseconds (13 digits).
 * Uses kotlinx-datetime for KMP compatibility.
 */
+ (THHKotlinx_datetimeLocalDateTime * _Nullable)toLocalDateTime:(int64_t)receiver __attribute__((swift_name("toLocalDateTime(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorMapperKt")))
@interface THHErrorMapperKt : THHBase
+ (THHErrorCode *)toSaleErrorMapperAction:(THHBRITerminalAction * _Nullable)action code:(NSString *)code info:(NSString *)info message:(NSString * _Nullable)message __attribute__((swift_name("toSaleErrorMapper(action:code:info:message:)")));
@property (class, readonly) NSString *TC_TRANSACTION_CANCELLED __attribute__((swift_name("TC_TRANSACTION_CANCELLED")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IPAddresses_iosKt")))
@interface THHIPAddresses_iosKt : THHBase
+ (NSString * _Nullable)getDeviceIPAddress __attribute__((swift_name("getDeviceIPAddress()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTActionKt")))
@interface THHNTTActionKt : THHBase

/**
 * Formats a [LocalDateTime] into the string format required by NTT ("yyyy-MM-dd HH:mm:ss").
 */
+ (NSString *)formatDateTimeDateTime:(THHKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTPaymentMethodKt")))
@interface THHNTTPaymentMethodKt : THHBase
+ (THHNTTPaymentMethod *)alipayPlus:(id<THHPaymentMethod>)receiver __attribute__((swift_name("alipayPlus(_:)")));
+ (THHNTTPaymentMethod *)atome:(id<THHPaymentMethod>)receiver __attribute__((swift_name("atome(_:)")));
+ (THHNTTPaymentMethod *)bblQrcs:(id<THHPaymentMethod>)receiver __attribute__((swift_name("bblQrcs(_:)")));
+ (THHNTTPaymentMethod *)card:(id<THHPaymentMethod>)receiver __attribute__((swift_name("card(_:)")));
+ (THHNTTPaymentMethod *)linePay:(id<THHPaymentMethod>)receiver __attribute__((swift_name("linePay(_:)")));
+ (THHNTTPaymentMethod *)maxMe:(id<THHPaymentMethod>)receiver __attribute__((swift_name("maxMe(_:)")));
+ (THHNTTPaymentMethod *)multiIpp:(id<THHPaymentMethod>)receiver __attribute__((swift_name("multiIpp(_:)")));
+ (THHNTTPaymentMethod *)sabuyMoney:(id<THHPaymentMethod>)receiver __attribute__((swift_name("sabuyMoney(_:)")));
+ (THHNTTPaymentMethod *)shopee:(id<THHPaymentMethod>)receiver __attribute__((swift_name("shopee(_:)")));
+ (THHNTTPaymentMethod *)thaiQrCode:(id<THHPaymentMethod>)receiver __attribute__((swift_name("thaiQrCode(_:)")));
+ (THHNTTPaymentMethod *)trueMoney:(id<THHPaymentMethod>)receiver __attribute__((swift_name("trueMoney(_:)")));
+ (THHNTTPaymentMethod *)wechatPayCil:(id<THHPaymentMethod>)receiver __attribute__((swift_name("wechatPayCil(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Platform_iosKt")))
@interface THHPlatform_iosKt : THHBase
+ (id<THHPlatform>)getPlatform __attribute__((swift_name("getPlatform()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt")))
@interface THHResultKt : THHBase
+ (NSString *)approval:(NSString *)receiver __attribute__((swift_name("approval(_:)")));
+ (NSString *)getLast:(NSString *)receiver __attribute__((swift_name("getLast(_:)")));
+ (NSString *)referenceID:(NSString *)receiver __attribute__((swift_name("referenceID(_:)")));
+ (NSString *)referenceNumber:(NSString *)receiver __attribute__((swift_name("referenceNumber(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt_")))
@interface THHResultKt_ : THHBase
+ (NSString *)invoiceNo:(NSString *)receiver __attribute__((swift_name("invoiceNo(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt__")))
@interface THHResultKt__ : THHBase
+ (THHInt * _Nullable)getHttpResponseCodeCode:(THHErrorCode *)code __attribute__((swift_name("getHttpResponseCode(code:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt___")))
@interface THHResultKt___ : THHBase
+ (NSString *)invoiceNo:(NSString *)receiver __attribute__((swift_name("invoiceNo(_:)")));
+ (NSString *)tradeType:(NSString *)receiver __attribute__((swift_name("tradeType(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt____")))
@interface THHResultKt____ : THHBase
+ (NSString *)approval:(NSString *)receiver __attribute__((swift_name("approval(_:)")));
+ (NSString *)approval_:(NSArray<NSString *> *)receiver __attribute__((swift_name("approval(__:)")));
+ (NSString *)invoiceNo:(NSString *)receiver __attribute__((swift_name("invoiceNo(_:)")));
+ (NSString *)invoiceNo_:(NSArray<NSString *> *)receiver __attribute__((swift_name("invoiceNo(__:)")));
+ (NSString *)referenceID:(NSString *)receiver __attribute__((swift_name("referenceID(_:)")));
+ (NSString *)referenceID_:(NSArray<NSString *> *)receiver __attribute__((swift_name("referenceID(__:)")));
+ (NSString *)rrn:(NSString *)receiver __attribute__((swift_name("rrn(_:)")));
+ (NSString *)rrn_:(NSArray<NSString *> *)receiver __attribute__((swift_name("rrn(__:)")));
+ (NSString *)uniqueID:(NSString *)receiver __attribute__((swift_name("uniqueID(_:)")));
+ (NSString *)uniqueID_:(NSArray<NSString *> *)receiver __attribute__((swift_name("uniqueID(__:)")));
+ (NSArray<NSString *> *)values:(NSString *)receiver __attribute__((swift_name("values(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCActionKt")))
@interface THHSHCActionKt : THHBase

/**
 * Formats a [LocalDateTime] into the string format required by SHC ("yyyy-MM-dd HH:mm:ss").
 */
+ (NSString *)formatDateTimeDateTime:(THHKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethodKt")))
@interface THHSHCPaymentMethodKt : THHBase
+ (THHSHCPaymentMethod *)card:(id<THHPaymentMethod>)receiver __attribute__((swift_name("card(_:)")));
+ (THHSHCPaymentMethod *)ewallet:(id<THHPaymentMethod>)receiver __attribute__((swift_name("ewallet(_:)")));
+ (THHSHCPaymentMethod *)qrAlipayPlus:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrAlipayPlus(_:)")));
+ (THHSHCPaymentMethod *)qrBoost:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrBoost(_:)")));
+ (THHSHCPaymentMethod *)qrDuitNow:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrDuitNow(_:)")));
+ (THHSHCPaymentMethod *)qrFavePay:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrFavePay(_:)")));
+ (THHSHCPaymentMethod *)qrGrabPay:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrGrabPay(_:)")));
+ (THHSHCPaymentMethod *)qrMcash:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrMcash(_:)")));
+ (THHSHCPaymentMethod *)qrNetsPay:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrNetsPay(_:)")));
+ (THHSHCPaymentMethod *)qrRedPay:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrRedPay(_:)")));
+ (THHSHCPaymentMethod *)qrUnionPay:(id<THHPaymentMethod>)receiver __attribute__((swift_name("qrUnionPay(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Security_iosKt")))
@interface THHSecurity_iosKt : THHBase
+ (THHBaseSecurity *)getSecurityApiKey:(NSString *)apiKey __attribute__((swift_name("getSecurity(apiKey:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalBRIKt")))
@interface THHTerminalBRIKt : THHBase
+ (THHBRIPaymentMethod *)toSaleMethod:(NSString *)receiver __attribute__((swift_name("toSaleMethod(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalOperationKt")))
@interface THHTerminalOperationKt : THHBase
@property (class, readonly) id<THHKotlinx_datetimeDateTimeFormat> dateTimeFormat __attribute__((swift_name("dateTimeFormat")));
@property (class, readonly) NSString *formatPattern __attribute__((swift_name("formatPattern")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DartKt")))
@interface THHDartKt : THHBase

/**
 * Manually converts a VERY SIMPLE JsonObject to an XML string.
 *
 * This function is HIGHLY SPECIFIC to a flat JsonObject structure
 * where keys map directly to XML element names and primitive values
 * map directly to XML element text content.
 *
 * It will **NOT** handle:
 * - Nested JsonObjects or JsonArrays.
 * - Complex XML structures (attributes, namespaces, comments, etc.).
 * - Proper XML entity escaping for special characters (<, >, &, ", ') in values.
 * If your JSON values contain these, the generated XML will be invalid.
 * - Indentation or pretty-printing.
 *
 * Use an actual XML serialization library for robust and correct XML generation.
 *
 * @param jsonObject The flat JsonObject to convert.
 * @param rootTagName The name of the root XML element (e.g., "data", "root").
 * @return A simple XML string.
 */
+ (NSString *)convertJsonObjectToXmlManuallyJsonObject:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)jsonObject rootTagName:(NSString *)rootTagName __attribute__((swift_name("convertJsonObjectToXmlManually(jsonObject:rootTagName:)")));

/**
 * Manually converts a VERY SIMPLE XML string to a JsonObject without an XML parsing library.
 *
 * This function is HIGHLY SPECIFIC to the input XML format:
 * <root_tag>
 * <key1>value1</key1>
 * <key2>value2</key2>
 * ...
 * <keyN>valueN</keyN>
 * </root_tag>
 *
 * It will **NOT** work for:
 * - Nested elements (e.g., <parent><child>...</child></parent>)
 * - Attributes (e.g., <key1 id="abc">value1</key1>)
 * - XML declarations, comments, CDATA, entities, etc.
 * - Mixed content (text directly inside the root tag alongside child tags)
 * - Self-closing tags (<key/>)
 * - Any deviation from the strict <key>value</key> pattern for children.
 * - Poorly formatted XML (e.g., missing closing tags, incorrect nesting).
 *
 * Use an actual XML parsing library (like xmlutil.dom2) for anything more complex.
 */
+ (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)convertSimpleXmlToSimpleJsonManuallyXmlString:(NSString *)xmlString stringValue:(NSDictionary<NSString *, id> *)stringValue __attribute__((swift_name("convertSimpleXmlToSimpleJsonManually(xmlString:stringValue:)")));
+ (NSString *)escapeXmlSpecialChars:(NSString *)receiver __attribute__((swift_name("escapeXmlSpecialChars(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DartKt_")))
@interface THHDartKt_ : THHBase

/**
 * Manually converts a VERY SIMPLE JsonObject to an XML string.
 *
 * This function is HIGHLY SPECIFIC to a flat JsonObject structure
 * where keys map directly to XML element names and primitive values
 * map directly to XML element text content.
 *
 * It will **NOT** handle:
 * - Nested JsonObjects or JsonArrays.
 * - Complex XML structures (attributes, namespaces, comments, etc.).
 * - Proper XML entity escaping for special characters (<, >, &, ", ') in values.
 * If your JSON values contain these, the generated XML will be invalid.
 * - Indentation or pretty-printing.
 *
 * Use an actual XML serialization library for robust and correct XML generation.
 *
 * @param jsonObject The flat JsonObject to convert.
 * @param rootTagName The name of the root XML element (e.g., "data", "root").
 * @return A simple XML string.
 */
+ (NSString *)convertJsonObjectToXmlManuallyJsonObject:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)jsonObject rootTagName:(NSString *)rootTagName __attribute__((swift_name("convertJsonObjectToXmlManually(jsonObject:rootTagName:)")));

/**
 * Manually converts a VERY SIMPLE XML string to a JsonObject without an XML parsing library.
 *
 * This function is HIGHLY SPECIFIC to the input XML format:
 * <root_tag>
 * <key1>value1</key1>
 * <key2>value2</key2>
 * ...
 * <keyN>valueN</keyN>
 * </root_tag>
 *
 * It will **NOT** work for:
 * - Nested elements (e.g., <parent><child>...</child></parent>)
 * - Attributes (e.g., <key1 id="abc">value1</key1>)
 * - XML declarations, comments, CDATA, entities, etc.
 * - Mixed content (text directly inside the root tag alongside child tags)
 * - Self-closing tags (<key/>)
 * - Any deviation from the strict <key>value</key> pattern for children.
 * - Poorly formatted XML (e.g., missing closing tags, incorrect nesting).
 *
 * Use an actual XML parsing library (like xmlutil.dom2) for anything more complex.
 */
+ (NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)convertSimpleXmlToSimpleJsonManuallyXmlString:(NSString *)xmlString stringValue:(NSDictionary<NSString *, id> *)stringValue __attribute__((swift_name("convertSimpleXmlToSimpleJsonManually(xmlString:stringValue:)")));
+ (NSString *)escapeXmlSpecialChars:(NSString *)receiver __attribute__((swift_name("escapeXmlSpecialChars(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("JsonKt")))
@interface THHJsonKt : THHBase
+ (NSString *)prettyJsonValue:(id _Nullable)value __attribute__((swift_name("prettyJson(value:)")));
+ (THHKotlinPair<NSString *, THHKotlinx_serialization_jsonJsonPrimitive *> *)toJsonPrimitive:(NSString * _Nullable)receiver key:(NSString *)key __attribute__((swift_name("toJsonPrimitive(_:key:)")));
+ (NSDictionary<NSString *, id> *)toMapNotNull:(NSArray<THHKotlinPair<NSString *, THHKotlinx_serialization_jsonJsonElement *> *> *)receiver __attribute__((swift_name("toMapNotNull(_:)")));
@property (class, readonly) THHKotlinx_serialization_jsonJson *PrettyJson __attribute__((swift_name("PrettyJson")));
@property (class, readonly) THHKotlinx_serialization_jsonJson *XenJson __attribute__((swift_name("XenJson")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MockKt")))
@interface THHMockKt : THHBase
+ (THHKotlinx_serialization_jsonJsonElement *)mockRefund:(NSDictionary<NSString *, THHKotlinx_serialization_jsonJsonElement *> *)receiver success:(BOOL)success __attribute__((swift_name("mockRefund(_:success:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinCoroutineContext")))
@protocol THHKotlinCoroutineContext
@required
- (id _Nullable)foldInitial:(id _Nullable)initial operation:(id _Nullable (^)(id _Nullable, id<THHKotlinCoroutineContextElement>))operation __attribute__((swift_name("fold(initial:operation:)")));
- (id<THHKotlinCoroutineContextElement> _Nullable)getKey:(id<THHKotlinCoroutineContextKey>)key __attribute__((swift_name("get(key:)")));
- (id<THHKotlinCoroutineContext>)minusKeyKey:(id<THHKotlinCoroutineContextKey>)key __attribute__((swift_name("minusKey(key:)")));
- (id<THHKotlinCoroutineContext>)plusContext:(id<THHKotlinCoroutineContext>)context __attribute__((swift_name("plus(context:)")));
@end

__attribute__((swift_name("KotlinCoroutineContextElement")))
@protocol THHKotlinCoroutineContextElement <THHKotlinCoroutineContext>
@required
@property (readonly) id<THHKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreJob")))
@protocol THHKotlinx_coroutines_coreJob <THHKotlinCoroutineContextElement>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (id<THHKotlinx_coroutines_coreChildHandle>)attachChildChild:(id<THHKotlinx_coroutines_coreChildJob>)child __attribute__((swift_name("attachChild(child:)")));
- (void)cancelCause:(THHKotlinCancellationException * _Nullable)cause __attribute__((swift_name("cancel(cause:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (THHKotlinCancellationException *)getCancellationException __attribute__((swift_name("getCancellationException()")));
- (id<THHKotlinx_coroutines_coreDisposableHandle>)invokeOnCompletionHandler:(void (^)(THHKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnCompletion(handler:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (id<THHKotlinx_coroutines_coreDisposableHandle>)invokeOnCompletionOnCancelling:(BOOL)onCancelling invokeImmediately:(BOOL)invokeImmediately handler:(void (^)(THHKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnCompletion(onCancelling:invokeImmediately:handler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)joinWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("join(completionHandler:)")));
- (id<THHKotlinx_coroutines_coreJob>)plusOther:(id<THHKotlinx_coroutines_coreJob>)other __attribute__((swift_name("plus(other:)"))) __attribute__((unavailable("Operator '+' on two Job objects is meaningless. Job is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The job to the right of `+` just replaces the job the left of `+`.")));
- (BOOL)start __attribute__((swift_name("start()")));
@property (readonly) id<THHKotlinSequence> children __attribute__((swift_name("children")));
@property (readonly) BOOL isActive __attribute__((swift_name("isActive")));
@property (readonly) BOOL isCancelled __attribute__((swift_name("isCancelled")));
@property (readonly) BOOL isCompleted __attribute__((swift_name("isCompleted")));
@property (readonly) id<THHKotlinx_coroutines_coreSelectClause0> onJoin __attribute__((swift_name("onJoin")));

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
@property (readonly) id<THHKotlinx_coroutines_coreJob> _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineScope")))
@protocol THHKotlinx_coroutines_coreCoroutineScope
@required
@property (readonly) id<THHKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/serialization/json/JsonElementSerializer))
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonElement")))
@interface THHKotlinx_serialization_jsonJsonElement : THHBase
@property (class, readonly, getter=companion) THHKotlinx_serialization_jsonJsonElementCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((swift_name("KotlinFunction")))
@protocol THHKotlinFunction
@required
@end

__attribute__((swift_name("KotlinSuspendFunction0")))
@protocol THHKotlinSuspendFunction0 <THHKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeWithCompletionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinPair")))
@interface THHKotlinPair<__covariant A, __covariant B> : THHBase
- (instancetype)initWithFirst:(A _Nullable)first second:(B _Nullable)second __attribute__((swift_name("init(first:second:)"))) __attribute__((objc_designated_initializer));
- (THHKotlinPair<A, B> *)doCopyFirst:(A _Nullable)first second:(B _Nullable)second __attribute__((swift_name("doCopy(first:second:)")));
- (BOOL)equalsOther:(id _Nullable)other __attribute__((swift_name("equals(other:)")));
- (int32_t)hashCode __attribute__((swift_name("hashCode()")));
- (NSString *)toString __attribute__((swift_name("toString()")));
@property (readonly) A _Nullable first __attribute__((swift_name("first")));
@property (readonly) B _Nullable second __attribute__((swift_name("second")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreFlow")))
@protocol THHKotlinx_coroutines_coreFlow
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)collectCollector:(id<THHKotlinx_coroutines_coreFlowCollector>)collector completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("collect(collector:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSharedFlow")))
@protocol THHKotlinx_coroutines_coreSharedFlow <THHKotlinx_coroutines_coreFlow>
@required
@property (readonly) NSArray<id> *replayCache __attribute__((swift_name("replayCache")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreStateFlow")))
@protocol THHKotlinx_coroutines_coreStateFlow <THHKotlinx_coroutines_coreSharedFlow>
@required
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreFlowCollector")))
@protocol THHKotlinx_coroutines_coreFlowCollector
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)emitValue:(id _Nullable)value completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("emit(value:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutableSharedFlow")))
@protocol THHKotlinx_coroutines_coreMutableSharedFlow <THHKotlinx_coroutines_coreSharedFlow, THHKotlinx_coroutines_coreFlowCollector>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
- (void)resetReplayCache __attribute__((swift_name("resetReplayCache()")));
- (BOOL)tryEmitValue:(id _Nullable)value __attribute__((swift_name("tryEmit(value:)")));
@property (readonly) id<THHKotlinx_coroutines_coreStateFlow> subscriptionCount __attribute__((swift_name("subscriptionCount")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutableStateFlow")))
@protocol THHKotlinx_coroutines_coreMutableStateFlow <THHKotlinx_coroutines_coreStateFlow, THHKotlinx_coroutines_coreMutableSharedFlow>
@required
- (void)setValue:(id _Nullable)value __attribute__((swift_name("setValue(_:)")));
- (BOOL)compareAndSetExpect:(id _Nullable)expect update:(id _Nullable)update __attribute__((swift_name("compareAndSet(expect:update:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinEnumCompanion")))
@interface THHKotlinEnumCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinEnumCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinArray")))
@interface THHKotlinArray<T> : THHBase
+ (instancetype)arrayWithSize:(int32_t)size init:(T _Nullable (^)(THHInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (T _Nullable)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (id<THHKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(T _Nullable)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreEncoder")))
@protocol THHKotlinx_serialization_coreEncoder
@required
- (id<THHKotlinx_serialization_coreCompositeEncoder>)beginCollectionDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor collectionSize:(int32_t)collectionSize __attribute__((swift_name("beginCollection(descriptor:collectionSize:)")));
- (id<THHKotlinx_serialization_coreCompositeEncoder>)beginStructureDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("beginStructure(descriptor:)")));
- (void)encodeBooleanValue:(BOOL)value __attribute__((swift_name("encodeBoolean(value:)")));
- (void)encodeByteValue:(int8_t)value __attribute__((swift_name("encodeByte(value:)")));
- (void)encodeCharValue:(unichar)value __attribute__((swift_name("encodeChar(value:)")));
- (void)encodeDoubleValue:(double)value __attribute__((swift_name("encodeDouble(value:)")));
- (void)encodeEnumEnumDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)enumDescriptor index:(int32_t)index __attribute__((swift_name("encodeEnum(enumDescriptor:index:)")));
- (void)encodeFloatValue:(float)value __attribute__((swift_name("encodeFloat(value:)")));
- (id<THHKotlinx_serialization_coreEncoder>)encodeInlineDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("encodeInline(descriptor:)")));
- (void)encodeIntValue:(int32_t)value __attribute__((swift_name("encodeInt(value:)")));
- (void)encodeLongValue:(int64_t)value __attribute__((swift_name("encodeLong(value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNotNullMark __attribute__((swift_name("encodeNotNullMark()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNull __attribute__((swift_name("encodeNull()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNullableSerializableValueSerializer:(id<THHKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeNullableSerializableValue(serializer:value:)")));
- (void)encodeSerializableValueSerializer:(id<THHKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeSerializableValue(serializer:value:)")));
- (void)encodeShortValue:(int16_t)value __attribute__((swift_name("encodeShort(value:)")));
- (void)encodeStringValue:(NSString *)value __attribute__((swift_name("encodeString(value:)")));
@property (readonly) THHKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialDescriptor")))
@protocol THHKotlinx_serialization_coreSerialDescriptor
@required
- (NSArray<id<THHKotlinAnnotation>> *)getElementAnnotationsIndex:(int32_t)index __attribute__((swift_name("getElementAnnotations(index:)")));
- (id<THHKotlinx_serialization_coreSerialDescriptor>)getElementDescriptorIndex:(int32_t)index __attribute__((swift_name("getElementDescriptor(index:)")));
- (int32_t)getElementIndexName:(NSString *)name __attribute__((swift_name("getElementIndex(name:)")));
- (NSString *)getElementNameIndex:(int32_t)index __attribute__((swift_name("getElementName(index:)")));
- (BOOL)isElementOptionalIndex:(int32_t)index __attribute__((swift_name("isElementOptional(index:)")));
@property (readonly) NSArray<id<THHKotlinAnnotation>> *annotations __attribute__((swift_name("annotations")));
@property (readonly) int32_t elementsCount __attribute__((swift_name("elementsCount")));
@property (readonly) BOOL isInline __attribute__((swift_name("isInline")));
@property (readonly) BOOL isNullable __attribute__((swift_name("isNullable")));
@property (readonly) THHKotlinx_serialization_coreSerialKind *kind __attribute__((swift_name("kind")));
@property (readonly) NSString *serialName __attribute__((swift_name("serialName")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreDecoder")))
@protocol THHKotlinx_serialization_coreDecoder
@required
- (id<THHKotlinx_serialization_coreCompositeDecoder>)beginStructureDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("beginStructure(descriptor:)")));
- (BOOL)decodeBoolean __attribute__((swift_name("decodeBoolean()")));
- (int8_t)decodeByte __attribute__((swift_name("decodeByte()")));
- (unichar)decodeChar __attribute__((swift_name("decodeChar()")));
- (double)decodeDouble __attribute__((swift_name("decodeDouble()")));
- (int32_t)decodeEnumEnumDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)enumDescriptor __attribute__((swift_name("decodeEnum(enumDescriptor:)")));
- (float)decodeFloat __attribute__((swift_name("decodeFloat()")));
- (id<THHKotlinx_serialization_coreDecoder>)decodeInlineDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeInline(descriptor:)")));
- (int32_t)decodeInt __attribute__((swift_name("decodeInt()")));
- (int64_t)decodeLong __attribute__((swift_name("decodeLong()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)decodeNotNullMark __attribute__((swift_name("decodeNotNullMark()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (THHKotlinNothing * _Nullable)decodeNull __attribute__((swift_name("decodeNull()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id _Nullable)decodeNullableSerializableValueDeserializer:(id<THHKotlinx_serialization_coreDeserializationStrategy>)deserializer __attribute__((swift_name("decodeNullableSerializableValue(deserializer:)")));
- (id _Nullable)decodeSerializableValueDeserializer:(id<THHKotlinx_serialization_coreDeserializationStrategy>)deserializer __attribute__((swift_name("decodeSerializableValue(deserializer:)")));
- (int16_t)decodeShort __attribute__((swift_name("decodeShort()")));
- (NSString *)decodeString __attribute__((swift_name("decodeString()")));
@property (readonly) THHKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutex")))
@protocol THHKotlinx_coroutines_coreMutex
@required
- (BOOL)holdsLockOwner:(id)owner __attribute__((swift_name("holdsLock(owner:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)lockOwner:(id _Nullable)owner completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("lock(owner:completionHandler:)")));
- (BOOL)tryLockOwner:(id _Nullable)owner __attribute__((swift_name("tryLock(owner:)")));
- (void)unlockOwner:(id _Nullable)owner __attribute__((swift_name("unlock(owner:)")));
@property (readonly) BOOL isLocked __attribute__((swift_name("isLocked")));
@property (readonly) id<THHKotlinx_coroutines_coreSelectClause2> onLock __attribute__((swift_name("onLock"))) __attribute__((deprecated("Mutex.onLock deprecated without replacement. For additional details please refer to #2794")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.0")
*/
__attribute__((swift_name("KotlinAutoCloseable")))
@protocol THHKotlinAutoCloseable
@required
- (void)close __attribute__((swift_name("close()")));
@end

__attribute__((swift_name("Ktor_ioCloseable")))
@protocol THHKtor_ioCloseable <THHKotlinAutoCloseable>
@required
@end


/**
 * A multiplatform asynchronous HTTP client that allows you to make requests, handle responses,
 * and extend its functionality with plugins such as authentication, JSON serialization, and more.
 *
 * # Creating client
 * To create a new client, you can call:
 * ```kotlin
 * val client = HttpClient()
 * ```
 * You can create as many clients as you need.
 *
 * If you no longer need the client, please consider closing it to release resources:
 * ```
 * client.close()
 * ```
 *
 * To learn more on how to create and configure an [HttpClient] see the tutorial page:
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * # Making API Requests
 * For every HTTP method (GET, POST, PUT, etc.), there is a corresponding function:
 * ```kotlin
 * val response: HttpResponse = client.get("https://ktor.io/")
 * val body = response.bodyAsText()
 * ```
 * See [Making HTTP requests](https://ktor.io/docs/client-requests.html) for more details.
 *
 * # Query Parameters
 * Add query parameters to your request using the `parameter` function:
 * ```kotlin
 * val response = client.get("https://google.com/search") {
 *     url {
 *         parameter("q", "REST API with Ktor")
 *     }
 * }
 * ```
 * For more information, refer to [Passing request parameters](https://ktor.io/docs/client-requests.html#parameters).
 *
 * # Adding Headers
 * Include headers in your request using the `headers` builder or the `header` function:
 * ```kotlin
 * val response = client.get("https://httpbin.org/bearer") {
 *     headers {
 *         append("Authorization", "Bearer your_token_here")
 *         append("Accept", "application/json")
 *     }
 * }
 * ```
 * Learn more at [Adding headers to a request](https://ktor.io/docs/client-requests.html#headers).
 *
 * # JSON Serialization
 * Add dependencies:
 * - io.ktor:ktor-client-content-negotiation:3.+
 * - io.ktor:ktor-serialization-kotlinx-json:3.+
 * Add Gradle plugin:
 * ```
 * plugins {
 *     kotlin("plugin.serialization")
 * }
 * ```
 *
 * Send and receive JSON data by installing the `ContentNegotiation` plugin with `kotlinx.serialization`:
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         json()
 *     }
 * }
 *
 * @Serializable
 * data class MyRequestType(val someData: String)
 *
 * @Serializable
 * data class MyResponseType(val someResponseData: String)
 *
 * val response: MyResponseType = client.post("https://api.example.com/data") {
 *     contentType(ContentType.Application.Json)
 *     setBody(MyRequestType(someData = "value"))
 * }.body()
 * ```
 * See [Serializing JSON data](https://ktor.io/docs/client-serialization.html) for maven configuration and other details.
 *
 * # Submitting Forms
 * Submit form data using `FormDataContent` or the `submitForm` function:
 * ```kotlin
 * // Using FormDataContent
 * val response = client.post("https://example.com/submit") {
 *     setBody(FormDataContent(Parameters.build {
 *         append("username", "user")
 *         append("password", "pass")
 *     }))
 * }
 *
 * // Or using submitForm
 * val response = client.submitForm(
 *     url = "https://example.com/submit",
 *     formParameters = Parameters.build {
 *         append("username", "user")
 *         append("password", "pass")
 *     }
 * )
 * ```
 * More information is available at [Submitting form parameters](https://ktor.io/docs/client-requests.html#form_parameters).
 *
 * # Handling Authentication
 * Add dependency: io.ktor:ktor-client-auth:3.+
 *
 * Use the `Auth` plugin to handle various authentication schemes like Basic or Bearer token authentication:
 * ```kotlin
 * val client = HttpClient {
 *     install(Auth) {
 *         bearer {
 *             loadTokens {
 *                 BearerTokens(accessToken = "your_access_token", refreshToken = "your_refresh_token")
 *             }
 *         }
 *     }
 * }
 *
 * val response = client.get("https://api.example.com/protected")
 * ```
 * Refer to [Client authentication](https://ktor.io/docs/client-auth.html) for more details.
 *
 * # Setting Timeouts and Retries
 * Configure timeouts and implement retry logic for your requests:
 * ```kotlin
 * val client = HttpClient {
 *     install(HttpTimeout) {
 *         requestTimeoutMillis = 10000
 *         connectTimeoutMillis = 5000
 *         socketTimeoutMillis = 15000
 *     }
 * }
 * ```
 *
 * For the request timeout:
 * ```kotlin
 * client.get("") {
 *     timeout {
 *         requestTimeoutMillis = 1000
 *     }
 * }
 * ```
 * See [Timeout](https://ktor.io/docs/client-timeout.html) for more information.
 *
 * # Handling Cookies
 *
 * Manage cookies automatically by installing the `HttpCookies` plugin:
 * ```kotlin
 * val client = HttpClient {
 *     install(HttpCookies) {
 *         storage = AcceptAllCookiesStorage()
 *     }
 * }
 *
 * // Accessing cookies
 * val cookies: List<Cookie> = client.cookies("https://example.com")
 * ```
 * Learn more at [Cookies](https://ktor.io/docs/client-cookies.html).
 *
 * # Uploading Files
 * Upload files using multipart/form-data requests:
 * ```kotlin
 * client.submitFormWithBinaryData(
 *      url = "https://example.com/upload",
 *      formData = formData {
 *          append("description", "File upload example")
 *          append("file", {
 *              File("path/to/file.txt").readChannel()
 *          })
 *      }
 *  )
 *
 * See [Uploading data](https://ktor.io/docs/client-requests.html#upload_file) for details.
 *
 * # Using WebSockets
 *
 * Communicate over WebSockets using the `webSocket` function:
 * ```kotlin
 * client.webSocket("wss://echo.websocket.org") {
 *     send(Frame.Text("Hello, WebSocket!"))
 *     val frame = incoming.receive()
 *     if (frame is Frame.Text) {
 *         println("Received: ${frame.readText()}")
 *     }
 * }
 * ```
 * Learn more at [Client WebSockets](https://ktor.io/docs/client-websockets.html).
 *
 * # Error Handling
 * Handle exceptions and HTTP error responses gracefully:
 * val client = HttpClient {
 *     HttpResponseValidator {
 *         validateResponse { response ->
 *             val statusCode = response.status.value
 *             when (statusCode) {
 *                 in 300..399 -> error("Redirects are not allowed")
 *             }
 *         }
 *     }
 * }
 * See [Error handling](https://ktor.io/docs/client-response-validation.html) for more information.
 *
 * # Configuring SSL/TLS
 *
 * Customize SSL/TLS settings for secure connections is engine-specific. Please refer to the following page for
 * the details: [Client SSL/TLS](https://ktor.io/docs/client-ssl.html).
 *
 * # Using Proxies
 * Route requests through an HTTP or SOCKS proxy:
 * ```kotlin
 * val client = HttpClient() {
 *     engine {
 *         proxy = ProxyBuilder.http("http://proxy.example.com:8080")
 *         // For a SOCKS proxy:
 *         // proxy = ProxyBuilder.socks(host = "proxy.example.com", port = 1080)
 *     }
 * }
 * ```
 * See [Using a proxy](https://ktor.io/docs/client-proxy.html) for details.
 *
 * # Streaming Data
 *
 * Stream large data efficiently without loading it entirely into memory.
 *
 * Stream request:
 * ```kotlin
 * val response = client.post("https://example.com/upload") {
 *      setBody(object: OutgoingContent.WriteChannelContent() {
 *          override suspend fun writeTo(channel: ByteWriteChannel) {
 *              repeat(1000) {
 *                  channel.writeString("Hello!")
 *              }
 *          }
 *      })
 * }
 * ```
 *
 * Stream response:
 * ```kotlin
 * client.prepareGet("https://example.com/largefile.zip").execute { response ->
 *     val channel: ByteReadChannel = response.bodyAsChannel()
 *
 *     while (!channel.exhausted()) {
 *         val chunk = channel.readBuffer()
 *         // ...
 *     }
 * }
 * ```
 * Learn more at [Streaming data](https://ktor.io/docs/client-responses.html#streaming).
 *
 * # Using SSE
 * Server-Sent Events (SSE) is a technology that allows a server to continuously push events to a client over an HTTP
 * connection. It's particularly useful in cases where the server needs to send event-based updates without requiring
 * the client to repeatedly poll the server.
 *
 * Install the plugin:
 * ```kotlin
 * val client = HttpClient(CIO) {
 *     install(SSE)
 * }
 * ```
 *
 * ```
 * client.sse(host = "0.0.0.0", port = 8080, path = "/events") {
 *     while (true) {
 *         for (event in incoming) {
 *             println("Event from server:")
 *             println(event)
 *         }
 *     }
 * }
 * ```
 *
 * Visit [Using SSE](https://ktor.io/docs/client-server-sent-events.html#install_plugin) to learn more.
 *
 * # Customizing a client with plugins
 * To extend out-of-the-box functionality, you can install plugins for a Ktor client:
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         json()
 *     }
 * }
 * ```
 *
 * There are many plugins available out of the box, and you can write your own. See
 * [Create custom client plugins](https://ktor.io/docs/client-custom-plugins.html) to learn more.
 *
 * # Service Loader and Default Engine
 * On JVM, calling `HttpClient()` without specifying an engine uses a service loader mechanism to
 * determine the appropriate default engine. This can introduce a performance overhead, especially on
 * slower devices, such as Android.
 *
 * **Performance Note**: If you are targeting platforms where initialization speed is critical,
 * consider explicitly specifying an engine to avoid the service loader lookup.
 *
 * Example with manual engine specification:
 * ```
 * val client = HttpClient(Apache) // Explicitly uses Apache engine, bypassing service loader
 * ```
 *
 * By directly setting the engine (e.g., `Apache`, `OkHttp`), you can optimize startup performance
 * by preventing the default service loader mechanism.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClient")))
@interface THHKtor_client_coreHttpClient : THHBase <THHKotlinx_coroutines_coreCoroutineScope, THHKtor_ioCloseable>
- (instancetype)initWithEngine:(id<THHKtor_client_coreHttpClientEngine>)engine userConfig:(THHKtor_client_coreHttpClientConfig<THHKtor_client_coreHttpClientEngineConfig *> *)userConfig __attribute__((swift_name("init(engine:userConfig:)"))) __attribute__((objc_designated_initializer));

/**
 * Initiates the shutdown process for the `HttpClient`. This is a non-blocking call, which
 * means it returns immediately and begins the client closure in the background.
 *
 * ## Usage
 * ```
 * val client = HttpClient()
 * client.close()
 * client.coroutineContext.job.join() // Waits for complete termination if necessary
 * ```
 *
 * ## Important Notes
 * - **Non-blocking**: `close()` only starts the closing process and does not wait for it to complete.
 * - **Coroutine Context**: To wait for all client resources to be freed, use `client.coroutineContext.job.join()`
 *   or `client.coroutineContext.cancel()` to terminate ongoing tasks.
 * - **Manual Engine Management**: If a custom `engine` was manually created, it must be closed explicitly
 *   after calling `client.close()` to release all resources.
 *
 * Example with custom engine management:
 * ```
 * val engine = HttpClientEngine() // Custom engine instance
 * val client = HttpClient(engine)
 *
 * client.close()
 * engine.close() // Ensure manually created engine is also closed
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.close)
 */
- (void)close __attribute__((swift_name("close()")));

/**
 * Returns a new [HttpClient] by copying this client's configuration
 * and additionally configured by the [block] parameter.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.config)
 */
- (THHKtor_client_coreHttpClient *)configBlock:(void (^)(THHKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("config(block:)")));

/**
 * Checks if the specified [capability] is supported by this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.isSupported)
 */
- (BOOL)isSupportedCapability:(id<THHKtor_client_coreHttpClientEngineCapability>)capability __attribute__((swift_name("isSupported(capability:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * Typed attributes used as a lightweight container for this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.attributes)
 */
@property (readonly) id<THHKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) id<THHKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@property (readonly) id<THHKtor_client_coreHttpClientEngine> engine __attribute__((swift_name("engine")));

/**
 * Provides access to the client's engine configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.engineConfig)
 */
@property (readonly) THHKtor_client_coreHttpClientEngineConfig *engineConfig __attribute__((swift_name("engineConfig")));

/**
 * Provides access to the events of the client's lifecycle.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.monitor)
 */
@property (readonly) THHKtor_eventsEvents *monitor __attribute__((swift_name("monitor")));

/**
 * A pipeline used for receiving a request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.receivePipeline)
 */
@property (readonly) THHKtor_client_coreHttpReceivePipeline *receivePipeline __attribute__((swift_name("receivePipeline")));

/**
 * A pipeline used for processing all requests sent by this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.requestPipeline)
 */
@property (readonly) THHKtor_client_coreHttpRequestPipeline *requestPipeline __attribute__((swift_name("requestPipeline")));

/**
 * A pipeline used for processing all responses sent by the server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.responsePipeline)
 */
@property (readonly) THHKtor_client_coreHttpResponsePipeline *responsePipeline __attribute__((swift_name("responsePipeline")));

/**
 * A pipeline used for sending a request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.sendPipeline)
 */
@property (readonly) THHKtor_client_coreHttpSendPipeline *sendPipeline __attribute__((swift_name("sendPipeline")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinNothing")))
@interface THHKotlinNothing : THHBase
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/serialization/json/JsonPrimitiveSerializer))
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonPrimitive")))
@interface THHKotlinx_serialization_jsonJsonPrimitive : THHKotlinx_serialization_jsonJsonElement
@property (class, readonly, getter=companion) THHKotlinx_serialization_jsonJsonPrimitiveCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *content __attribute__((swift_name("content")));
@property (readonly) BOOL isString __attribute__((swift_name("isString")));
@end

__attribute__((swift_name("RuntimeTransactionCallbacks")))
@protocol THHRuntimeTransactionCallbacks
@required
- (void)afterCommitFunction:(void (^)(void))function __attribute__((swift_name("afterCommit(function:)")));
- (void)afterRollbackFunction:(void (^)(void))function __attribute__((swift_name("afterRollback(function:)")));
@end

__attribute__((swift_name("RuntimeTransactionWithoutReturn")))
@protocol THHRuntimeTransactionWithoutReturn <THHRuntimeTransactionCallbacks>
@required

/**
 * Rolls back this transaction.
 */
- (void)rollback __attribute__((swift_name("rollback()")));

/**
 * Begin an inner transaction.
 */
- (void)transactionBody:(void (^)(id<THHRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(body:)")));
@end

__attribute__((swift_name("RuntimeTransactionWithReturn")))
@protocol THHRuntimeTransactionWithReturn <THHRuntimeTransactionCallbacks>
@required

/**
 * Rolls back this transaction.
 */
- (void)rollbackReturnValue:(id _Nullable)returnValue __attribute__((swift_name("rollback(returnValue:)")));

/**
 * Begin an inner transaction.
 */
- (id _Nullable)transactionBody_:(id _Nullable (^)(id<THHRuntimeTransactionWithReturn>))body __attribute__((swift_name("transaction(body_:)")));
@end

__attribute__((swift_name("RuntimeCloseable")))
@protocol THHRuntimeCloseable
@required
- (void)close __attribute__((swift_name("close()")));
@end


/**
 * Maintains connections to an underlying SQL database and provides APIs for managing transactions
 * and executing SQL statements.
 */
__attribute__((swift_name("RuntimeSqlDriver")))
@protocol THHRuntimeSqlDriver <THHRuntimeCloseable>
@required
- (void)addListenerQueryKeys:(THHKotlinArray<NSString *> *)queryKeys listener:(id<THHRuntimeQueryListener>)listener __attribute__((swift_name("addListener(queryKeys:listener:)")));

/**
 * The currently open [Transacter.Transaction] on the database.
 *
 * It's up to the implementor how this method behaves for different connection/threading patterns.
 */
- (THHRuntimeTransacterTransaction * _Nullable)currentTransaction __attribute__((swift_name("currentTransaction()")));

/**
 * Execute a SQL statement.
 *
 * @param [identifier] An opaque, unique value that can be used to implement any driver-side
 *   caching of prepared statements. If [identifier] is null, a fresh statement is required.
 * @param [sql] The SQL string to be executed.
 * @param [parameters] The number of bindable parameters [sql] contains.
 * @param [binders] A lambda which is called before execution to bind any parameters to the SQL
 *   statement.
 *
 * @return The number of rows updated for an INSERT/DELETE/UPDATE, or 0 for other SQL statements.
 *
 * NOTE it is up to the specific driver to correctly return the row changes. Notably the SQLJS
 * driver does not do this and you should query changes() manually.
 */
- (id<THHRuntimeQueryResult>)executeIdentifier:(THHInt * _Nullable)identifier sql:(NSString *)sql parameters:(int32_t)parameters binders:(void (^ _Nullable)(id<THHRuntimeSqlPreparedStatement>))binders __attribute__((swift_name("execute(identifier:sql:parameters:binders:)")));

/**
 * Execute a SQL statement and evaluate its result set using the given block.
 *
 * @param [identifier] An opaque, unique value that can be used to implement any driver-side
 *   caching of prepared statements. If [identifier] is null, a fresh statement is required.
 * @param [sql] The SQL string to be executed.
 * @param [mapper] A lambda which is called with the cursor when the statement is executed
 *   successfully. The generic result of the lambda is returned to the caller, as soon as the
 *   mutual exclusion on the database connection ends. The cursor **must not escape** the block
 *   scope.
 * @param [parameters] The number of bindable parameters [sql] contains.
 * @param [binders] A lambda which is called before execution to bind any parameters to the SQL
 *   statement.
 */
- (id<THHRuntimeQueryResult>)executeQueryIdentifier:(THHInt * _Nullable)identifier sql:(NSString *)sql mapper:(id<THHRuntimeQueryResult> (^)(id<THHRuntimeSqlCursor>))mapper parameters:(int32_t)parameters binders:(void (^ _Nullable)(id<THHRuntimeSqlPreparedStatement>))binders __attribute__((swift_name("executeQuery(identifier:sql:mapper:parameters:binders:)")));

/**
 * Start a new [Transacter.Transaction] on the database.
 *
 * It's up to the implementor how this method behaves for different connection/threading patterns.
 */
- (id<THHRuntimeQueryResult>)doNewTransaction __attribute__((swift_name("doNewTransaction()")));
- (void)notifyListenersQueryKeys:(THHKotlinArray<NSString *> *)queryKeys __attribute__((swift_name("notifyListeners(queryKeys:)")));
- (void)removeListenerQueryKeys:(THHKotlinArray<NSString *> *)queryKeys listener:(id<THHRuntimeQueryListener>)listener __attribute__((swift_name("removeListener(queryKeys:listener:)")));
@end


/**
 * API for creating and migrating a SQL database. The implementation of this interface is generated
 * by SQLDelight.
 *
 * @param T Says whether the generated code for this database is asynchronous or synchronous. Most
 *          implementations of [app.cash.sqldelight.SqlDriver] will require one or the other, which
 *          is enforced by requesting the correlated type of Schema ([QueryResult.Value] for
 *          a synchronous runtime, [QueryResult.AsyncValue] for asynchronous). In a multiplatform
 *          environment where you have some drivers that use an asynchronous runtime, and some that
 *          require synchronous, you can generate an asynchronous runtime and then pass a
 *          synchronous schema to synchronous drivers with [SqlSchema.synchronous()]
 */
__attribute__((swift_name("RuntimeSqlSchema")))
@protocol THHRuntimeSqlSchema
@required

/**
 * Use [driver] to create the schema from scratch. Assumes no existing database state.
 */
- (id<THHRuntimeQueryResult>)createDriver:(id<THHRuntimeSqlDriver>)driver __attribute__((swift_name("create(driver:)")));

/**
 * Use [driver] to migrate from schema [oldVersion] to [newVersion].
 * Each of the [callbacks] are executed during the migration whenever the upgrade to the version specified by
 * [AfterVersion.afterVersion] has been completed.
 */
- (id<THHRuntimeQueryResult>)migrateDriver:(id<THHRuntimeSqlDriver>)driver oldVersion:(int64_t)oldVersion newVersion:(int64_t)newVersion callbacks:(THHKotlinArray<THHRuntimeAfterVersion *> *)callbacks __attribute__((swift_name("migrate(driver:oldVersion:newVersion:callbacks:)")));

/**
 * The version of this schema.
 */
@property (readonly) int64_t version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinUnit")))
@interface THHKotlinUnit : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)unit __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinUnit *shared __attribute__((swift_name("shared")));
- (NSString *)description __attribute__((swift_name("description()")));
@end


/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
__attribute__((swift_name("RuntimeTransacterTransaction")))
@interface THHRuntimeTransacterTransaction : THHBase <THHRuntimeTransactionCallbacks>

/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Queues [function] to be run after this transaction successfully commits.
 */
- (void)afterCommitFunction:(void (^)(void))function __attribute__((swift_name("afterCommit(function:)")));

/**
 * Queues [function] to be run after this transaction rolls back.
 */
- (void)afterRollbackFunction:(void (^)(void))function __attribute__((swift_name("afterRollback(function:)")));

/**
 * Signal to the underlying SQL driver that this transaction should be finished.
 *
 * @param successful Whether the transaction completed successfully or not.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (id<THHRuntimeQueryResult>)endTransactionSuccessful:(BOOL)successful __attribute__((swift_name("endTransaction(successful:)")));

/**
 * The parent transaction, if there is any.
 *
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHRuntimeTransacterTransaction * _Nullable enclosingTransaction __attribute__((swift_name("enclosingTransaction")));
@end

__attribute__((swift_name("RuntimeExecutableQuery")))
@interface THHRuntimeExecutableQuery<__covariant RowType> : THHBase
- (instancetype)initWithMapper:(RowType (^)(id<THHRuntimeSqlCursor>))mapper __attribute__((swift_name("init(mapper:)"))) __attribute__((objc_designated_initializer));

/**
 * Execute the underlying statement. The resulting cursor is passed to the given block.
 *
 * The cursor is closed automatically after the block returns.
 */
- (id<THHRuntimeQueryResult>)executeMapper:(id<THHRuntimeQueryResult> (^)(id<THHRuntimeSqlCursor>))mapper __attribute__((swift_name("execute(mapper:)")));

/**
 * @return The result set of the underlying SQL statement as a list of [RowType].
 */
- (NSArray<RowType> *)executeAsList __attribute__((swift_name("executeAsList()")));

/**
 * @return The only row of the result set for the underlying SQL statement as a non null
 *   [RowType].
 *
 * @throws NullPointerException if when executed this query has no rows in its result set.
 * @throws IllegalStateException if when executed this query has multiple rows in its result set.
 */
- (RowType)executeAsOne __attribute__((swift_name("executeAsOne()")));

/**
 * @return The first row of the result set for the underlying SQL statement as a non null
 *   [RowType] or null if the result set has no rows.
 *
 * @throws IllegalStateException if when executed this query has multiple rows in its result set.
 */
- (RowType _Nullable)executeAsOneOrNull __attribute__((swift_name("executeAsOneOrNull()")));
@property (readonly) RowType (^mapper)(id<THHRuntimeSqlCursor>) __attribute__((swift_name("mapper")));
@end


/**
 * A listenable, typed query generated by SQLDelight.
 *
 * @param RowType the type that this query can map its result set to.
 *
 * @property mapper The mapper this [Query] was created with, which can convert a row in the SQL
 *   cursor returned by [execute] to [RowType].
 */
__attribute__((swift_name("RuntimeQuery")))
@interface THHRuntimeQuery<__covariant RowType> : THHRuntimeExecutableQuery<RowType>
- (instancetype)initWithMapper:(RowType (^)(id<THHRuntimeSqlCursor>))mapper __attribute__((swift_name("init(mapper:)"))) __attribute__((objc_designated_initializer));

/**
 * Register a listener to be notified of future changes in the result set.
 */
- (void)addListenerListener:(id<THHRuntimeQueryListener>)listener __attribute__((swift_name("addListener(listener:)")));

/**
 * Remove a listener to no longer be notified of future changes in the result set.
 */
- (void)removeListenerListener:(id<THHRuntimeQueryListener>)listener __attribute__((swift_name("removeListener(listener:)")));
@end


/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClientConfig")))
@interface THHKtor_client_coreHttpClientConfig<T> : THHBase

/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Clones this [HttpClientConfig] by duplicating all the [plugins] and [customInterceptors].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.clone)
 */
- (THHKtor_client_coreHttpClientConfig<T> *)clone __attribute__((swift_name("clone()")));

/**
 * A builder for configuring engine-specific settings in [HttpClientEngineConfig],
 * such as dispatcher, thread count, proxy, and more.
 *
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>
 *     engine { // CIOEngineConfig.() -> Unit
 *         proxy = ProxyBuilder.http("proxy.example.com", 8080)
 *     }
 * ```
 *
 * You can learn more from [Engines](https://ktor.io/docs/http-client-engines.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.engine)
 */
- (void)engineBlock:(void (^)(T))block __attribute__((swift_name("engine(block:)")));

/**
 * Applies all the installed [plugins] and [customInterceptors] from this configuration
 * into the specified [client].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installClient:(THHKtor_client_coreHttpClient *)client __attribute__((swift_name("install(client:)")));

/**
 * Installs the specified [plugin] and optionally configures it using the [configure] block.
 *
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         // configuration block
 *         json()
 *     }
 * }
 * ```
 *
 * If the plugin is already installed, the configuration block will be applied to the existing configuration class.
 *
 * Learn more from [Plugins](https://ktor.io/docs/http-client-plugins.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installPlugin:(id<THHKtor_client_coreHttpClientPlugin>)plugin configure:(void (^)(id))configure __attribute__((swift_name("install(plugin:configure:)")));

/**
 * Installs an interceptor defined by [block].
 * The [key] parameter is used as a unique name, that also prevents installing duplicated interceptors.
 *
 * If the [key] is already used, the new interceptor will replace the old one.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installKey:(NSString *)key block:(void (^)(THHKtor_client_coreHttpClient *))block __attribute__((swift_name("install(key:block:)")));

/**
 * Installs the plugin from the [other] client's configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.plusAssign)
 */
- (void)plusAssignOther:(THHKtor_client_coreHttpClientConfig<T> *)other __attribute__((swift_name("plusAssign(other:)")));

/**
 * Development mode is no longer required all functionality is enabled by default. The property is safe to remove.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.developmentMode)
 */
@property BOOL developmentMode __attribute__((swift_name("developmentMode"))) __attribute__((deprecated("Development mode is no longer required. The property will be removed in the future.")));

/**
 * Terminates [HttpClient.receivePipeline] if the status code is not successful (>=300).
 * Learn more from [Response validation](https://ktor.io/docs/response-validation.html).
 *
 * For more details, see the [HttpCallValidator] documentation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.expectSuccess)
 */
@property BOOL expectSuccess __attribute__((swift_name("expectSuccess")));

/**
 * Specifies whether the client redirects to URLs provided in the `Location` header.
 * You can disable redirections by setting this property to `false`.
 *
 * For an advanced redirection configuration, use the [HttpRedirect] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.followRedirects)
 */
@property BOOL followRedirects __attribute__((swift_name("followRedirects")));

/**
 * Enables body transformations for many common types like [String], [ByteArray], [ByteReadChannel], etc.
 * These transformations are applied to the request and response bodies.
 *
 * The transformers will be used when the response body is received with a type:
 * ```kotlin
 * val client = HttpClient()
 * val bytes = client.get("https://ktor.io")
 *                   .body<ByteArray>()
 * ```
 *
 * This flag is enabled by default.
 * You might want to disable it if you want to write your own transformers or handle body manually.
 *
 * For more details, see the [defaultTransformers] documentation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.useDefaultTransformers)
 */
@property BOOL useDefaultTransformers __attribute__((swift_name("useDefaultTransformers")));
@end


/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreWebSockets.Config")))
@interface THHKtor_client_coreWebSocketsConfig : THHBase

/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Configure WebSocket extensions.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.extensions)
 */
- (void)extensionsBlock:(void (^)(THHKtor_websocketsWebSocketExtensionsConfig *))block __attribute__((swift_name("extensions(block:)")));

/**
 * A converter for serialization/deserialization
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.contentConverter)
 */
@property id<THHKtor_serializationWebsocketContentConverter> _Nullable contentConverter __attribute__((swift_name("contentConverter")));

/**
 * Sets maximum frame size in bytes.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.maxFrameSize)
 */
@property int64_t maxFrameSize __attribute__((swift_name("maxFrameSize")));

/**
 * Sets interval of sending ping frames.
 *
 * Use [PINGER_DISABLED] to disable ping.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.pingIntervalMillis)
 */
@property int64_t pingIntervalMillis __attribute__((swift_name("pingIntervalMillis")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinByteArray")))
@interface THHKotlinByteArray : THHBase
+ (instancetype)arrayWithSize:(int32_t)size __attribute__((swift_name("init(size:)")));
+ (instancetype)arrayWithSize:(int32_t)size init:(THHByte *(^)(THHInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (int8_t)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (THHKotlinByteIterator *)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(int8_t)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormat")))
@protocol THHKotlinx_datetimeDateTimeFormat
@required
- (NSString *)formatValue:(id _Nullable)value __attribute__((swift_name("format(value:)")));
- (id<THHKotlinAppendable>)formatToAppendable:(id<THHKotlinAppendable>)appendable value:(id _Nullable)value __attribute__((swift_name("formatTo(appendable:value:)")));
- (id _Nullable)parseInput:(id)input __attribute__((swift_name("parse(input:)")));
- (id _Nullable)parseOrNullInput:(id)input __attribute__((swift_name("parseOrNull(input:)")));
@end

__attribute__((swift_name("KotlinSuspendFunction1")))
@protocol THHKotlinSuspendFunction1 <THHKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kermit_coreSeverity")))
@interface THHKermit_coreSeverity : THHKotlinEnum<THHKermit_coreSeverity *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHKermit_coreSeverity *verbose __attribute__((swift_name("verbose")));
@property (class, readonly) THHKermit_coreSeverity *debug __attribute__((swift_name("debug")));
@property (class, readonly) THHKermit_coreSeverity *info __attribute__((swift_name("info")));
@property (class, readonly) THHKermit_coreSeverity *warn __attribute__((swift_name("warn")));
@property (class, readonly) THHKermit_coreSeverity *error __attribute__((swift_name("error")));
@property (class, readonly) THHKermit_coreSeverity *assert __attribute__((swift_name("assert")));
+ (THHKotlinArray<THHKermit_coreSeverity *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKermit_coreSeverity *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kermit_ioRollingFileLogWriterConfig")))
@interface THHKermit_ioRollingFileLogWriterConfig : THHBase
- (instancetype)initWithLogFileName:(NSString *)logFileName logFilePath:(THHKotlinx_io_corePath *)logFilePath rollOnSize:(int64_t)rollOnSize maxLogFiles:(int32_t)maxLogFiles logTag:(BOOL)logTag prependTimestamp:(BOOL)prependTimestamp __attribute__((swift_name("init(logFileName:logFilePath:rollOnSize:maxLogFiles:logTag:prependTimestamp:)"))) __attribute__((objc_designated_initializer));
- (THHKermit_ioRollingFileLogWriterConfig *)doCopyLogFileName:(NSString *)logFileName logFilePath:(THHKotlinx_io_corePath *)logFilePath rollOnSize:(int64_t)rollOnSize maxLogFiles:(int32_t)maxLogFiles logTag:(BOOL)logTag prependTimestamp:(BOOL)prependTimestamp __attribute__((swift_name("doCopy(logFileName:logFilePath:rollOnSize:maxLogFiles:logTag:prependTimestamp:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *logFileName __attribute__((swift_name("logFileName")));
@property (readonly) THHKotlinx_io_corePath *logFilePath __attribute__((swift_name("logFilePath")));
@property (readonly) BOOL logTag __attribute__((swift_name("logTag")));
@property (readonly) int32_t maxLogFiles __attribute__((swift_name("maxLogFiles")));
@property (readonly) BOOL prependTimestamp __attribute__((swift_name("prependTimestamp")));
@property (readonly) int64_t rollOnSize __attribute__((swift_name("rollOnSize")));
@end

__attribute__((swift_name("Kermit_coreMessageStringFormatter")))
@protocol THHKermit_coreMessageStringFormatter
@required
- (NSString *)formatMessageSeverity:(THHKermit_coreSeverity * _Nullable)severity tag:(id _Nullable)tag message:(id)message __attribute__((swift_name("formatMessage(severity:tag:message:)")));
- (NSString *)formatSeveritySeverity:(THHKermit_coreSeverity *)severity __attribute__((swift_name("formatSeverity(severity:)")));
- (NSString *)formatTagTag:(id)tag __attribute__((swift_name("formatTag(tag:)")));
@end

__attribute__((swift_name("Kotlinx_io_coreFileSystem")))
@protocol THHKotlinx_io_coreFileSystem
@required
- (void)atomicMoveSource:(THHKotlinx_io_corePath *)source destination:(THHKotlinx_io_corePath *)destination __attribute__((swift_name("atomicMove(source:destination:)")));
- (void)createDirectoriesPath:(THHKotlinx_io_corePath *)path mustCreate:(BOOL)mustCreate __attribute__((swift_name("createDirectories(path:mustCreate:)")));
- (void)deletePath:(THHKotlinx_io_corePath *)path mustExist:(BOOL)mustExist __attribute__((swift_name("delete(path:mustExist:)")));
- (BOOL)existsPath:(THHKotlinx_io_corePath *)path __attribute__((swift_name("exists(path:)")));
- (id)listDirectory:(THHKotlinx_io_corePath *)directory __attribute__((swift_name("list(directory:)")));
- (THHKotlinx_io_coreFileMetadata * _Nullable)metadataOrNullPath:(THHKotlinx_io_corePath *)path __attribute__((swift_name("metadataOrNull(path:)")));
- (THHKotlinx_io_corePath *)resolvePath:(THHKotlinx_io_corePath *)path __attribute__((swift_name("resolve(path:)")));
- (id<THHKotlinx_io_coreRawSink>)sinkPath:(THHKotlinx_io_corePath *)path append:(BOOL)append __attribute__((swift_name("sink(path:append:)")));
- (id<THHKotlinx_io_coreRawSource>)sourcePath:(THHKotlinx_io_corePath *)path __attribute__((swift_name("source(path:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.1")
 *   kotlin.time.ExperimentalTime
*/
__attribute__((swift_name("KotlinClock")))
@protocol THHKotlinClock
@required
- (THHKotlinInstant *)now __attribute__((swift_name("now()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_corePath")))
@interface THHKotlinx_io_corePath : THHBase
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL isAbsolute __attribute__((swift_name("isAbsolute")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) THHKotlinx_io_corePath * _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("Kermit_coreBaseLogger")))
@interface THHKermit_coreBaseLogger : THHBase
- (instancetype)initWithConfig:(id<THHKermit_coreLoggerConfig>)config __attribute__((swift_name("init(config:)"))) __attribute__((objc_designated_initializer));
- (void)logSeverity:(THHKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *)message __attribute__((swift_name("log(severity:tag:throwable:message:)")));
- (void)logBlockSeverity:(THHKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("logBlock(severity:tag:throwable:message:)")));
- (void)processLogSeverity:(THHKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *)message __attribute__((swift_name("processLog(severity:tag:throwable:message:)")));
@property (readonly) id<THHKermit_coreLoggerConfig> config __attribute__((swift_name("config")));
@property (readonly) id<THHKermit_coreMutableLoggerConfig> mutableConfig __attribute__((swift_name("mutableConfig")));
@end

__attribute__((swift_name("KermitLogger")))
@interface THHKermitLogger : THHKermit_coreBaseLogger
- (instancetype)initWithConfig:(id<THHKermit_coreLoggerConfig>)config tag:(NSString *)tag __attribute__((swift_name("init(config:tag:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(id<THHKermit_coreLoggerConfig>)config __attribute__((swift_name("init(config:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKermitLoggerCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)aMessageString:(NSString *)messageString throwable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("a(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)aThrowable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("a(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)dMessageString:(NSString *)messageString throwable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("d(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)dThrowable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("d(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)eMessageString:(NSString *)messageString throwable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("e(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)eThrowable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("e(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)iMessageString:(NSString *)messageString throwable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("i(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)iThrowable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("i(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)vMessageString:(NSString *)messageString throwable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("v(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)vThrowable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("v(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)wMessageString:(NSString *)messageString throwable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("w(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)wThrowable:(THHKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("w(throwable:tag:message:)")));
- (THHKermitLogger *)withTagTag:(NSString *)tag __attribute__((swift_name("withTag(tag:)")));
@property (readonly) NSString *tag __attribute__((swift_name("tag")));
@end


/**
 * Channel for asynchronous writing of sequences of bytes.
 * This is a **single-writer channel**.
 *
 * Operations on this channel cannot be invoked concurrently, unless explicitly specified otherwise
 * in the description. Exceptions are [close] and [flush].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteWriteChannel)
 */
__attribute__((swift_name("Ktor_ioByteWriteChannel")))
@protocol THHKtor_ioByteWriteChannel
@required
- (void)cancelCause_:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flush(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
@property (readonly) BOOL autoFlush __attribute__((swift_name("autoFlush")));
@property (readonly) THHKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForWrite __attribute__((swift_name("isClosedForWrite")));
@property (readonly) id<THHKotlinx_io_coreSink> writeBuffer __attribute__((swift_name("writeBuffer")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreDisposableHandle")))
@protocol THHKotlinx_coroutines_coreDisposableHandle
@required
- (void)dispose __attribute__((swift_name("dispose()")));
@end


/**
 * Base type for all async sockets
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ASocket)
 */
__attribute__((swift_name("Ktor_networkASocket")))
@protocol THHKtor_networkASocket <THHKtor_ioCloseable, THHKotlinx_coroutines_coreDisposableHandle>
@required

/**
 * Represents a socket lifetime, completes at socket closure
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ASocket.socketContext)
 */
@property (readonly) id<THHKotlinx_coroutines_coreJob> socketContext __attribute__((swift_name("socketContext")));
@end


/**
 * Represent a readable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AReadable)
 */
__attribute__((swift_name("Ktor_networkAReadable")))
@protocol THHKtor_networkAReadable
@required

/**
 * Attach [channel] for reading so incoming bytes appears in the attached channel.
 * Only one channel could be attached
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AReadable.attachForReading)
 *
 * @return a job that does supply data
 */
- (THHKtor_ioWriterJob *)attachForReadingChannel:(THHKtor_ioByteChannel *)channel __attribute__((swift_name("attachForReading(channel:)")));
@end


/**
 * Represents a writable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AWritable)
 */
__attribute__((swift_name("Ktor_networkAWritable")))
@protocol THHKtor_networkAWritable
@required

/**
 * Attach [channel] for writing so bytes written to the attached channel will be transmitted
 * Only one channel could be attached
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AWritable.attachForWriting)
 *
 * @return a job that does transmit data from the channel
 */
- (THHKtor_ioReaderJob *)attachForWritingChannel:(THHKtor_ioByteChannel *)channel __attribute__((swift_name("attachForWriting(channel:)")));
@end


/**
 * Represents both readable and writable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ReadWriteSocket)
 */
__attribute__((swift_name("Ktor_networkReadWriteSocket")))
@protocol THHKtor_networkReadWriteSocket <THHKtor_networkASocket, THHKtor_networkAReadable, THHKtor_networkAWritable>
@required
@end


/**
 * Represents a bound socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ABoundSocket)
 */
__attribute__((swift_name("Ktor_networkABoundSocket")))
@protocol THHKtor_networkABoundSocket
@required

/**
 * Local socket address. Could throw an exception if no address bound yet.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ABoundSocket.localAddress)
 */
@property (readonly) THHKtor_networkSocketAddress *localAddress __attribute__((swift_name("localAddress")));
@end


/**
 * Represent a connected socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AConnectedSocket)
 */
__attribute__((swift_name("Ktor_networkAConnectedSocket")))
@protocol THHKtor_networkAConnectedSocket
@required

/**
 * Remote socket address. Could throw an exception if the peer is not yet connected or already disconnected.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AConnectedSocket.remoteAddress)
 */
@property (readonly) THHKtor_networkSocketAddress *remoteAddress __attribute__((swift_name("remoteAddress")));
@end


/**
 * Represents a connected socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.Socket)
 */
__attribute__((swift_name("Ktor_networkSocket")))
@protocol THHKtor_networkSocket <THHKtor_networkReadWriteSocket, THHKtor_networkABoundSocket, THHKtor_networkAConnectedSocket, THHKotlinx_coroutines_coreCoroutineScope>
@required
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalDateSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDate")))
@interface THHKotlinx_datetimeLocalDate : THHBase <THHKotlinComparable>
- (instancetype)initWithYear:(int32_t)year month:(int32_t)month day:(int32_t)day __attribute__((swift_name("init(year:month:day:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(THHKotlinx_datetimeMonth *)month day_:(int32_t)day __attribute__((swift_name("init(year:month:day_:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinx_datetimeLocalDateCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(THHKotlinx_datetimeLocalDate *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (THHKotlinx_datetimeLocalDateRange *)rangeToThat:(THHKotlinx_datetimeLocalDate *)that __attribute__((swift_name("rangeTo(that:)")));
- (THHKotlinx_datetimeLocalDateRange *)rangeUntilThat:(THHKotlinx_datetimeLocalDate *)that __attribute__((swift_name("rangeUntil(that:)")));
- (int64_t)toEpochDays __attribute__((swift_name("toEpochDays()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t day __attribute__((swift_name("day")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth"))) __attribute__((deprecated("Use the 'day' property instead")));
@property (readonly) THHKotlinx_datetimeDayOfWeek *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) THHKotlinx_datetimeMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t monthNumber __attribute__((swift_name("monthNumber"))) __attribute__((deprecated("Use the 'month' property instead")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalTimeSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalTime")))
@interface THHKotlinx_datetimeLocalTime : THHBase <THHKotlinComparable>
- (instancetype)initWithHour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinx_datetimeLocalTimeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(THHKotlinx_datetimeLocalTime *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (int32_t)toMillisecondOfDay __attribute__((swift_name("toMillisecondOfDay()")));
- (int64_t)toNanosecondOfDay __attribute__((swift_name("toNanosecondOfDay()")));
- (int32_t)toSecondOfDay __attribute__((swift_name("toSecondOfDay()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t hour __attribute__((swift_name("hour")));
@property (readonly) int32_t minute __attribute__((swift_name("minute")));
@property (readonly) int32_t nanosecond __attribute__((swift_name("nanosecond")));
@property (readonly) int32_t second __attribute__((swift_name("second")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonth")))
@interface THHKotlinx_datetimeMonth : THHKotlinEnum<THHKotlinx_datetimeMonth *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHKotlinx_datetimeMonth *january __attribute__((swift_name("january")));
@property (class, readonly) THHKotlinx_datetimeMonth *february __attribute__((swift_name("february")));
@property (class, readonly) THHKotlinx_datetimeMonth *march __attribute__((swift_name("march")));
@property (class, readonly) THHKotlinx_datetimeMonth *april __attribute__((swift_name("april")));
@property (class, readonly) THHKotlinx_datetimeMonth *may __attribute__((swift_name("may")));
@property (class, readonly) THHKotlinx_datetimeMonth *june __attribute__((swift_name("june")));
@property (class, readonly) THHKotlinx_datetimeMonth *july __attribute__((swift_name("july")));
@property (class, readonly) THHKotlinx_datetimeMonth *august __attribute__((swift_name("august")));
@property (class, readonly) THHKotlinx_datetimeMonth *september __attribute__((swift_name("september")));
@property (class, readonly) THHKotlinx_datetimeMonth *october __attribute__((swift_name("october")));
@property (class, readonly) THHKotlinx_datetimeMonth *november __attribute__((swift_name("november")));
@property (class, readonly) THHKotlinx_datetimeMonth *december __attribute__((swift_name("december")));
+ (THHKotlinArray<THHKotlinx_datetimeMonth *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKotlinx_datetimeMonth *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateTime.Companion")))
@interface THHKotlinx_datetimeLocalDateTimeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeLocalDateTimeCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_datetimeDateTimeFormat>)FormatBuilder:(void (^)(id<THHKotlinx_datetimeDateTimeFormatBuilderWithDateTime>))builder __attribute__((swift_name("Format(builder:)")));
- (THHKotlinx_datetimeLocalDateTime *)parseInput:(id)input format:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeek")))
@interface THHKotlinx_datetimeDayOfWeek : THHKotlinEnum<THHKotlinx_datetimeDayOfWeek *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHKotlinx_datetimeDayOfWeek *monday __attribute__((swift_name("monday")));
@property (class, readonly) THHKotlinx_datetimeDayOfWeek *tuesday __attribute__((swift_name("tuesday")));
@property (class, readonly) THHKotlinx_datetimeDayOfWeek *wednesday __attribute__((swift_name("wednesday")));
@property (class, readonly) THHKotlinx_datetimeDayOfWeek *thursday __attribute__((swift_name("thursday")));
@property (class, readonly) THHKotlinx_datetimeDayOfWeek *friday __attribute__((swift_name("friday")));
@property (class, readonly) THHKotlinx_datetimeDayOfWeek *saturday __attribute__((swift_name("saturday")));
@property (class, readonly) THHKotlinx_datetimeDayOfWeek *sunday __attribute__((swift_name("sunday")));
+ (THHKotlinArray<THHKotlinx_datetimeDayOfWeek *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKotlinx_datetimeDayOfWeek *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeTimeZone.Companion")))
@interface THHKotlinx_datetimeTimeZoneCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeTimeZoneCompanion *shared __attribute__((swift_name("shared")));
- (THHKotlinx_datetimeTimeZone *)currentSystemDefault __attribute__((swift_name("currentSystemDefault()")));
- (THHKotlinx_datetimeTimeZone *)ofZoneId:(NSString *)zoneId __attribute__((swift_name("of(zoneId:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) THHKotlinx_datetimeFixedOffsetTimeZone *UTC __attribute__((swift_name("UTC")));
@property (readonly) NSSet<NSString *> *availableZoneIds __attribute__((swift_name("availableZoneIds")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.1")
 *   kotlin.time.ExperimentalTime
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinInstant")))
@interface THHKotlinInstant : THHBase <THHKotlinComparable>
@property (class, readonly, getter=companion) THHKotlinInstantCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(THHKotlinInstant *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (THHKotlinInstant *)minusDuration:(int64_t)duration __attribute__((swift_name("minus(duration:)")));
- (int64_t)minusOther:(THHKotlinInstant *)other __attribute__((swift_name("minus(other:)")));
- (THHKotlinInstant *)plusDuration:(int64_t)duration __attribute__((swift_name("plus(duration:)")));
- (int64_t)toEpochMilliseconds __attribute__((swift_name("toEpochMilliseconds()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int64_t epochSeconds __attribute__((swift_name("epochSeconds")));
@property (readonly) int32_t nanosecondsOfSecond __attribute__((swift_name("nanosecondsOfSecond")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeOverloadMarker")))
@interface THHKotlinx_datetimeOverloadMarker : THHBase
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialFormat")))
@protocol THHKotlinx_serialization_coreSerialFormat
@required
@property (readonly) THHKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreStringFormat")))
@protocol THHKotlinx_serialization_coreStringFormat <THHKotlinx_serialization_coreSerialFormat>
@required
- (id _Nullable)decodeFromStringDeserializer:(id<THHKotlinx_serialization_coreDeserializationStrategy>)deserializer string:(NSString *)string __attribute__((swift_name("decodeFromString(deserializer:string:)")));
- (NSString *)encodeToStringSerializer:(id<THHKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToString(serializer:value:)")));
@end

__attribute__((swift_name("Kotlinx_serialization_jsonJson")))
@interface THHKotlinx_serialization_jsonJson : THHBase <THHKotlinx_serialization_coreStringFormat>
@property (class, readonly, getter=companion) THHKotlinx_serialization_jsonJsonDefault *companion __attribute__((swift_name("companion")));
- (id _Nullable)decodeFromJsonElementDeserializer:(id<THHKotlinx_serialization_coreDeserializationStrategy>)deserializer element:(THHKotlinx_serialization_jsonJsonElement *)element __attribute__((swift_name("decodeFromJsonElement(deserializer:element:)")));
- (id _Nullable)decodeFromStringString:(NSString *)string __attribute__((swift_name("decodeFromString(string:)")));
- (id _Nullable)decodeFromStringDeserializer:(id<THHKotlinx_serialization_coreDeserializationStrategy>)deserializer string:(NSString *)string __attribute__((swift_name("decodeFromString(deserializer:string:)")));
- (THHKotlinx_serialization_jsonJsonElement *)encodeToJsonElementSerializer:(id<THHKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToJsonElement(serializer:value:)")));
- (NSString *)encodeToStringValue:(id _Nullable)value __attribute__((swift_name("encodeToString(value:)")));
- (NSString *)encodeToStringSerializer:(id<THHKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToString(serializer:value:)")));
- (THHKotlinx_serialization_jsonJsonElement *)parseToJsonElementString:(NSString *)string __attribute__((swift_name("parseToJsonElement(string:)")));
@property (readonly) THHKotlinx_serialization_jsonJsonConfiguration *configuration __attribute__((swift_name("configuration")));
@property (readonly) THHKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreChildHandle")))
@protocol THHKotlinx_coroutines_coreChildHandle <THHKotlinx_coroutines_coreDisposableHandle>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (BOOL)childCancelledCause:(THHKotlinThrowable *)cause __attribute__((swift_name("childCancelled(cause:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
@property (readonly) id<THHKotlinx_coroutines_coreJob> _Nullable parent __attribute__((swift_name("parent")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreChildJob")))
@protocol THHKotlinx_coroutines_coreChildJob <THHKotlinx_coroutines_coreJob>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (void)parentCancelledParentJob:(id<THHKotlinx_coroutines_coreParentJob>)parentJob __attribute__((swift_name("parentCancelled(parentJob:)")));
@end

__attribute__((swift_name("KotlinSequence")))
@protocol THHKotlinSequence
@required
- (id<THHKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause")))
@protocol THHKotlinx_coroutines_coreSelectClause
@required
@property (readonly) id clauseObject __attribute__((swift_name("clauseObject")));
@property (readonly) THHKotlinUnit *(^(^ _Nullable onCancellationConstructor)(id<THHKotlinx_coroutines_coreSelectInstance>, id _Nullable, id _Nullable))(THHKotlinThrowable *, id _Nullable, id<THHKotlinCoroutineContext>) __attribute__((swift_name("onCancellationConstructor")));
@property (readonly) id _Nullable (^processResFunc)(id, id _Nullable, id _Nullable) __attribute__((swift_name("processResFunc")));
@property (readonly) void (^regFunc)(id, id<THHKotlinx_coroutines_coreSelectInstance>, id _Nullable) __attribute__((swift_name("regFunc")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause0")))
@protocol THHKotlinx_coroutines_coreSelectClause0 <THHKotlinx_coroutines_coreSelectClause>
@required
@end

__attribute__((swift_name("KotlinCoroutineContextKey")))
@protocol THHKotlinCoroutineContextKey
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonElement.Companion")))
@interface THHKotlinx_serialization_jsonJsonElementCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_serialization_jsonJsonElementCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("KotlinIterator")))
@protocol THHKotlinIterator
@required
- (BOOL)hasNext __attribute__((swift_name("hasNext()")));
- (id _Nullable)next __attribute__((swift_name("next()")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreCompositeEncoder")))
@protocol THHKotlinx_serialization_coreCompositeEncoder
@required
- (void)encodeBooleanElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(BOOL)value __attribute__((swift_name("encodeBooleanElement(descriptor:index:value:)")));
- (void)encodeByteElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int8_t)value __attribute__((swift_name("encodeByteElement(descriptor:index:value:)")));
- (void)encodeCharElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(unichar)value __attribute__((swift_name("encodeCharElement(descriptor:index:value:)")));
- (void)encodeDoubleElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(double)value __attribute__((swift_name("encodeDoubleElement(descriptor:index:value:)")));
- (void)encodeFloatElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(float)value __attribute__((swift_name("encodeFloatElement(descriptor:index:value:)")));
- (id<THHKotlinx_serialization_coreEncoder>)encodeInlineElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("encodeInlineElement(descriptor:index:)")));
- (void)encodeIntElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int32_t)value __attribute__((swift_name("encodeIntElement(descriptor:index:value:)")));
- (void)encodeLongElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int64_t)value __attribute__((swift_name("encodeLongElement(descriptor:index:value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNullableSerializableElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index serializer:(id<THHKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeNullableSerializableElement(descriptor:index:serializer:value:)")));
- (void)encodeSerializableElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index serializer:(id<THHKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeSerializableElement(descriptor:index:serializer:value:)")));
- (void)encodeShortElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int16_t)value __attribute__((swift_name("encodeShortElement(descriptor:index:value:)")));
- (void)encodeStringElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(NSString *)value __attribute__((swift_name("encodeStringElement(descriptor:index:value:)")));
- (void)endStructureDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("endStructure(descriptor:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)shouldEncodeElementDefaultDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("shouldEncodeElementDefault(descriptor:index:)")));
@property (readonly) THHKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerializersModule")))
@interface THHKotlinx_serialization_coreSerializersModule : THHBase

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)dumpToCollector:(id<THHKotlinx_serialization_coreSerializersModuleCollector>)collector __attribute__((swift_name("dumpTo(collector:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<THHKotlinx_serialization_coreKSerializer> _Nullable)getContextualKClass:(id<THHKotlinKClass>)kClass typeArgumentsSerializers:(NSArray<id<THHKotlinx_serialization_coreKSerializer>> *)typeArgumentsSerializers __attribute__((swift_name("getContextual(kClass:typeArgumentsSerializers:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<THHKotlinx_serialization_coreSerializationStrategy> _Nullable)getPolymorphicBaseClass:(id<THHKotlinKClass>)baseClass value:(id)value __attribute__((swift_name("getPolymorphic(baseClass:value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<THHKotlinx_serialization_coreDeserializationStrategy> _Nullable)getPolymorphicBaseClass:(id<THHKotlinKClass>)baseClass serializedClassName:(NSString * _Nullable)serializedClassName __attribute__((swift_name("getPolymorphic(baseClass:serializedClassName:)")));
@end

__attribute__((swift_name("KotlinAnnotation")))
@protocol THHKotlinAnnotation
@required
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialKind")))
@interface THHKotlinx_serialization_coreSerialKind : THHBase
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreCompositeDecoder")))
@protocol THHKotlinx_serialization_coreCompositeDecoder
@required
- (BOOL)decodeBooleanElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeBooleanElement(descriptor:index:)")));
- (int8_t)decodeByteElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeByteElement(descriptor:index:)")));
- (unichar)decodeCharElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeCharElement(descriptor:index:)")));
- (int32_t)decodeCollectionSizeDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeCollectionSize(descriptor:)")));
- (double)decodeDoubleElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeDoubleElement(descriptor:index:)")));
- (int32_t)decodeElementIndexDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeElementIndex(descriptor:)")));
- (float)decodeFloatElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeFloatElement(descriptor:index:)")));
- (id<THHKotlinx_serialization_coreDecoder>)decodeInlineElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeInlineElement(descriptor:index:)")));
- (int32_t)decodeIntElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeIntElement(descriptor:index:)")));
- (int64_t)decodeLongElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeLongElement(descriptor:index:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id _Nullable)decodeNullableSerializableElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index deserializer:(id<THHKotlinx_serialization_coreDeserializationStrategy>)deserializer previousValue:(id _Nullable)previousValue __attribute__((swift_name("decodeNullableSerializableElement(descriptor:index:deserializer:previousValue:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)decodeSequentially __attribute__((swift_name("decodeSequentially()")));
- (id _Nullable)decodeSerializableElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index deserializer:(id<THHKotlinx_serialization_coreDeserializationStrategy>)deserializer previousValue:(id _Nullable)previousValue __attribute__((swift_name("decodeSerializableElement(descriptor:index:deserializer:previousValue:)")));
- (int16_t)decodeShortElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeShortElement(descriptor:index:)")));
- (NSString *)decodeStringElementDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeStringElement(descriptor:index:)")));
- (void)endStructureDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("endStructure(descriptor:)")));
@property (readonly) THHKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause2")))
@protocol THHKotlinx_coroutines_coreSelectClause2 <THHKotlinx_coroutines_coreSelectClause>
@required
@end


/**
 * Serves as the base interface for an [HttpClient]'s engine.
 *
 * An `HttpClientEngine` represents the underlying network implementation that
 * performs HTTP requests and handles responses.
 * Developers can implement this interface to create custom engines for use with [HttpClient].
 *
 * This interface provides a set of properties and methods that define the
 * contract for configuring, executing, and managing HTTP requests within the engine.
 *
 * For a base implementation that handles common engine functionality, see [HttpClientEngineBase].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngine")))
@protocol THHKtor_client_coreHttpClientEngine <THHKotlinx_coroutines_coreCoroutineScope, THHKtor_ioCloseable>
@required

/**
 * Executes an HTTP request and produces an HTTP response.
 *
 * This function takes [HttpRequestData], which contains all details of the HTTP request,
 * and returns [HttpResponseData] with the server's response, including headers, status code, and body.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.execute)
 *
 * @param data The [HttpRequestData] representing the request to be executed.
 * @return An [HttpResponseData] object containing the server's response.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeData:(THHKtor_client_coreHttpRequestData *)data completionHandler:(void (^)(THHKtor_client_coreHttpResponseData * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(data:completionHandler:)")));

/**
 * Installs the engine into an [HttpClient].
 *
 * This method is called when the engine is being set up within an `HttpClient`.
 * Use it to register interceptors, validate configuration, or prepare the engine
 * for use with the client.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.install)
 *
 * @param client The [HttpClient] instance to which the engine is being installed.
 */
- (void)installClient:(THHKtor_client_coreHttpClient *)client __attribute__((swift_name("install(client:)")));

/**
 * Provides access to the engine's configuration via [HttpClientEngineConfig].
 *
 * The [config] object stores user-defined parameters or settings that control
 * how the engine operates. When creating a custom engine, this property
 * should return the specific configuration implementation.
 *
 * Example:
 * ```kotlin
 * override val config: HttpClientEngineConfig = CustomEngineConfig()
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.config)
 */
@property (readonly) THHKtor_client_coreHttpClientEngineConfig *config __attribute__((swift_name("config")));

/**
 * Specifies the [CoroutineDispatcher] for I/O operations in the engine.
 *
 * This dispatcher is used for all network-related operations, such as
 * sending requests and receiving responses.
 * By default, it should be optimized for I/O tasks.
 *
 * Example:
 * ```kotlin
 * override val dispatcher: CoroutineDispatcher = Dispatchers.IO
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.dispatcher)
 */
@property (readonly) THHKotlinx_coroutines_coreCoroutineDispatcher *dispatcher __attribute__((swift_name("dispatcher")));

/**
 * Specifies the set of capabilities supported by this HTTP client engine.
 *
 * Capabilities provide a mechanism for plugins and other components to
 * determine whether the engine supports specific features such as timeouts,
 * WebSocket communication, HTTP/2, HTTP/3, or other advanced networking
 * capabilities. This allows seamless integration of features based on the
 * engine's functionality.
 *
 * Each capability is represented as an instance of [HttpClientEngineCapability],
 * which can carry additional metadata or configurations for the capability.
 *
 * Example:
 * ```kotlin
 * override val supportedCapabilities: Set<HttpClientEngineCapability<*>> = setOf(
 *     WebSocketCapability,
 *     Http2Capability,
 *     TimeoutCapability
 * )
 * ```
 *
 * **Usage in Plugins**:
 * Plugins can check if the engine supports a specific capability before
 * applying behavior:
 * ```kotlin
 * if (engine.supportedCapabilities.contains(WebSocketCapability)) {
 *     // Configure WebSocket-specific settings
 * }
 * ```
 *
 * When implementing a custom engine, ensure this property accurately reflects
 * the engine's abilities to avoid unexpected plugin behavior or runtime errors.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.supportedCapabilities)
 */
@property (readonly) NSSet<id<THHKtor_client_coreHttpClientEngineCapability>> *supportedCapabilities __attribute__((swift_name("supportedCapabilities")));
@end


/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngineConfig")))
@interface THHKtor_client_coreHttpClientEngineConfig : THHBase

/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Allow specifying the coroutine dispatcher to use for IO operations.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.dispatcher)
 */
@property THHKotlinx_coroutines_coreCoroutineDispatcher * _Nullable dispatcher __attribute__((swift_name("dispatcher")));

/**
 * Enables HTTP pipelining advice.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.pipelining)
 */
@property BOOL pipelining __attribute__((swift_name("pipelining")));

/**
 * Specifies a proxy address to use.
 * Uses a system proxy by default.
 *
 * You can learn more from [Proxy](https://ktor.io/docs/proxy.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.proxy)
 */
@property THHKtor_client_coreProxyConfig * _Nullable proxy __attribute__((swift_name("proxy")));

/**
 * Specifies network threads count advice.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.threadsCount)
 */
@property int32_t threadsCount __attribute__((swift_name("threadsCount"))) __attribute__((unavailable("The [threadsCount] property is deprecated. Consider setting [dispatcher] instead.")));
@end


/**
 * Represents a capability that an [HttpClientEngine] can support, with [T] representing the type
 * of configuration or metadata associated with the capability.
 *
 * Capabilities are used to declare optional features or behaviors that an engine may support,
 * such as WebSocket communication, HTTP/2, or custom timeouts. They enable plugins and request
 * builders to configure engine-specific functionality by associating a capability with a
 * specific configuration.
 *
 * Capabilities can be set on a per-request basis using the `HttpRequestBuilder.setCapability` method,
 * allowing users to configure engine-specific behavior for individual requests.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineCapability)
 *
 * @param T The type of the configuration or metadata associated with this capability.
 *
 * Example:
 * Suppose you have a custom capability for WebSocket support that requires a specific configuration:
 * ```kotlin
 * object WebSocketCapability : HttpClientEngineCapability<WebSocketConfig>
 *
 * data class WebSocketConfig(val maxFrameSize: Int, val pingIntervalMillis: Long)
 * ```
 *
 * Setting a capability in a request:
 * ```kotlin
 * client.request {
 *     setCapability(WebSocketCapability, WebSocketConfig(
 *         maxFrameSize = 65536,
 *         pingIntervalMillis = 30000
 *     ))
 * }
 * ```
 *
 * Engine Example:
 * A custom engine implementation can declare support for specific capabilities in its `supportedCapabilities` property:
 * ```kotlin
 * override val supportedCapabilities: Set<HttpClientEngineCapability<*>> = setOf(WebSocketCapability)
 * ```
 *
 * Plugin Integration Example:
 * Plugins use capabilities to interact with engine-specific features. For example:
 * ```kotlin
 * if (engine.supportedCapabilities.contains(WebSocketCapability)) {
 *     // Configure WebSocket behavior if supported by the engine
 * }
 * ```
 *
 * When creating a custom capability:
 * - Define a singleton object implementing `HttpClientEngineCapability`.
 * - Use the type parameter [T] to provide the associated configuration type or metadata.
 * - Ensure that engines supporting the capability handle the associated configuration properly.
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngineCapability")))
@protocol THHKtor_client_coreHttpClientEngineCapability
@required
@end


/**
 * Map of attributes accessible by [AttributeKey] in a typed manner
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes)
 */
__attribute__((swift_name("Ktor_utilsAttributes")))
@protocol THHKtor_utilsAttributes
@required

/**
 * Gets a value of the attribute for the specified [key], or calls supplied [block] to compute its value
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.computeIfAbsent)
 */
- (id)computeIfAbsentKey:(THHKtor_utilsAttributeKey<id> *)key block:(id (^)(void))block __attribute__((swift_name("computeIfAbsent(key:block:)")));

/**
 * Checks if an attribute with the specified [key] exists
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.contains)
 */
- (BOOL)containsKey:(THHKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("contains(key:)")));

/**
 * Gets a value of the attribute for the specified [key], or throws an exception if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.get)
 */
- (id)getKey_:(THHKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("get(key_:)")));

/**
 * Gets a value of the attribute for the specified [key], or return `null` if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.getOrNull)
 */
- (id _Nullable)getOrNullKey:(THHKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("getOrNull(key:)")));

/**
 * Creates or changes an attribute with the specified [key] using [value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.put)
 */
- (void)putKey:(THHKtor_utilsAttributeKey<id> *)key value:(id)value __attribute__((swift_name("put(key:value:)")));

/**
 * Removes an attribute with the specified [key]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.remove)
 */
- (void)removeKey:(THHKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("remove(key:)")));

/**
 * Creates or changes an attribute with the specified [key] using [value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.set)
 */
- (void)setKey:(THHKtor_utilsAttributeKey<id> *)key value:(id)value __attribute__((swift_name("set(key:value:)")));

/**
 * Removes an attribute with the specified [key] and returns its current value, throws an exception if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.take)
 */
- (id)takeKey:(THHKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("take(key:)")));

/**
 * Removes an attribute with the specified [key] and returns its current value, returns `null` if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.takeOrNull)
 */
- (id _Nullable)takeOrNullKey:(THHKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("takeOrNull(key:)")));

/**
 * Returns [List] of all [AttributeKey] instances in this map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.allKeys)
 */
@property (readonly) NSArray<THHKtor_utilsAttributeKey<id> *> *allKeys __attribute__((swift_name("allKeys")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_eventsEvents")))
@interface THHKtor_eventsEvents : THHBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Raises the event specified by [definition] with the [value] and calls all handlers.
 *
 * Handlers are called in order of subscriptions.
 * If some handler throws an exception, all remaining handlers will still run. The exception will eventually be re-thrown.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.raise)
 */
- (void)raiseDefinition:(THHKtor_eventsEventDefinition<id> *)definition value:(id _Nullable)value __attribute__((swift_name("raise(definition:value:)")));

/**
 * Subscribe [handler] to an event specified by [definition]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.subscribe)
 */
- (id<THHKotlinx_coroutines_coreDisposableHandle>)subscribeDefinition:(THHKtor_eventsEventDefinition<id> *)definition handler:(void (^)(id _Nullable))handler __attribute__((swift_name("subscribe(definition:handler:)")));

/**
 * Unsubscribe [handler] from an event specified by [definition]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.unsubscribe)
 */
- (void)unsubscribeDefinition:(THHKtor_eventsEventDefinition<id> *)definition handler:(void (^)(id _Nullable))handler __attribute__((swift_name("unsubscribe(definition:handler:)")));
@end


/**
 * Represents an execution pipeline for asynchronous extensible computations
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline)
 */
__attribute__((swift_name("Ktor_utilsPipeline")))
@interface THHKtor_utilsPipeline<TSubject, TContext> : THHBase
- (instancetype)initWithPhases:(THHKotlinArray<THHKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhase:(THHKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<THHKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer));

/**
 * Adds [phase] to the end of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.addPhase)
 */
- (void)addPhasePhase:(THHKtor_utilsPipelinePhase *)phase __attribute__((swift_name("addPhase(phase:)")));

/**
 * Invoked after an interceptor has been installed
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.afterIntercepted)
 */
- (void)afterIntercepted __attribute__((swift_name("afterIntercepted()")));

/**
 * Executes this pipeline in the given [context] and with the given [subject]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.execute)
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeContext:(TContext)context subject:(TSubject)subject completionHandler:(void (^)(TSubject _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(context:subject:completionHandler:)")));

/**
 * Inserts [phase] after the [reference] phase. If there are other phases inserted after [reference], then [phase]
 * will be inserted after them.
 * Example:
 * ```
 * val pipeline = Pipeline<String, String>(a)
 * pipeline.insertPhaseAfter(a, b)
 * pipeline.insertPhaseAfter(a, c)
 * assertEquals(listOf(a, b, c), pipeline.items)
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.insertPhaseAfter)
 */
- (void)insertPhaseAfterReference:(THHKtor_utilsPipelinePhase *)reference phase:(THHKtor_utilsPipelinePhase *)phase __attribute__((swift_name("insertPhaseAfter(reference:phase:)")));

/**
 * Inserts [phase] before the [reference] phase.
 * Example:
 * ```
 * val pipeline = Pipeline<String, String>(c)
 * pipeline.insertPhaseBefore(c, a)
 * pipeline.insertPhaseBefore(c, b)
 * assertEquals(listOf(a, b, c), pipeline.items)
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.insertPhaseBefore)
 */
- (void)insertPhaseBeforeReference:(THHKtor_utilsPipelinePhase *)reference phase:(THHKtor_utilsPipelinePhase *)phase __attribute__((swift_name("insertPhaseBefore(reference:phase:)")));

/**
 * Adds [block] to the [phase] of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.intercept)
 */
- (void)interceptPhase:(THHKtor_utilsPipelinePhase *)phase block:(id<THHKotlinSuspendFunction2>)block __attribute__((swift_name("intercept(phase:block:)")));
- (NSArray<id<THHKotlinSuspendFunction2>> *)interceptorsForPhasePhase:(THHKtor_utilsPipelinePhase *)phase __attribute__((swift_name("interceptorsForPhase(phase:)")));

/**
 * Merges another pipeline into this pipeline, maintaining relative phases order
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.merge)
 */
- (void)mergeFrom:(THHKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("merge(from:)")));
- (void)mergePhasesFrom:(THHKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("mergePhases(from:)")));

/**
 * Reset current pipeline from other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.resetFrom)
 */
- (void)resetFromFrom:(THHKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("resetFrom(from:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * Provides common place to store pipeline attributes
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.attributes)
 */
@property (readonly) id<THHKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * Indicated if debug mode is enabled. In debug mode users will get more details in the stacktrace.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.developmentMode)
 */
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));

/**
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.isEmpty)
 *
 * @return `true` if there are no interceptors installed regardless number of phases
 */
@property (readonly) BOOL isEmpty __attribute__((swift_name("isEmpty")));

/**
 * Phases of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.items)
 */
@property (readonly) NSArray<THHKtor_utilsPipelinePhase *> *items __attribute__((swift_name("items")));
@end


/**
 * [HttpClient] Pipeline used for receiving [HttpResponse] without any processing.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpReceivePipeline")))
@interface THHKtor_client_coreHttpReceivePipeline : THHKtor_utilsPipeline<THHKtor_client_coreHttpResponse *, THHKotlinUnit *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(THHKotlinArray<THHKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(THHKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<THHKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKtor_client_coreHttpReceivePipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * An [HttpClient]'s pipeline used for executing [HttpRequest].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestPipeline")))
@interface THHKtor_client_coreHttpRequestPipeline : THHKtor_utilsPipeline<id, THHKtor_client_coreHttpRequestBuilder *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(THHKotlinArray<THHKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(THHKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<THHKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKtor_client_coreHttpRequestPipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * [HttpClient] Pipeline used for executing [HttpResponse].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponsePipeline")))
@interface THHKtor_client_coreHttpResponsePipeline : THHKtor_utilsPipeline<THHKtor_client_coreHttpResponseContainer *, THHKtor_client_coreHttpClientCall *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(THHKotlinArray<THHKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(THHKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<THHKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKtor_client_coreHttpResponsePipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * An [HttpClient]'s pipeline used for sending [HttpRequest] to a remote server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpSendPipeline")))
@interface THHKtor_client_coreHttpSendPipeline : THHKtor_utilsPipeline<id, THHKtor_client_coreHttpRequestBuilder *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(THHKotlinArray<THHKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(THHKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<THHKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKtor_client_coreHttpSendPipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonPrimitive.Companion")))
@interface THHKotlinx_serialization_jsonJsonPrimitiveCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_serialization_jsonJsonPrimitiveCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * An interface for listening to changes in the result set of a query.
 */
__attribute__((swift_name("RuntimeQueryListener")))
@protocol THHRuntimeQueryListener
@required

/**
 * Called whenever the query this listener was attached to is dirtied.
 *
 * Calls are made synchronously on the thread where the updated occurred, after the update applied successfully.
 */
- (void)queryResultsChanged __attribute__((swift_name("queryResultsChanged()")));
@end


/**
 * The returned [value] is the result of a database query or other database operation.
 *
 * This interface enables drivers to be based on non-blocking APIs where the result can be obtained using the suspending
 * [await] method. See [AsyncValue].
 */
__attribute__((swift_name("RuntimeQueryResult")))
@protocol THHRuntimeQueryResult
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitWithCompletionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("await(completionHandler:)")));
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Represents a SQL statement that has been prepared by a driver to be executed.
 *
 * This type is not thread safe unless otherwise specified by the driver emitting these.
 *
 * Prepared statements should not be cached by client code. Drivers can implement caching by using
 * the integer identifier passed to [SqlDriver.execute] or [SqlDriver.executeQuery].
 * Client code can pass the same identifier to that method to request that the prepared statement
 * is cached.
 */
__attribute__((swift_name("RuntimeSqlPreparedStatement")))
@protocol THHRuntimeSqlPreparedStatement
@required

/**
 * Bind [boolean] to the underlying statement at [index].
 */
- (void)bindBooleanIndex:(int32_t)index boolean:(THHBoolean * _Nullable)boolean __attribute__((swift_name("bindBoolean(index:boolean:)")));

/**
 * Bind [bytes] to the underlying statement at [index].
 */
- (void)bindBytesIndex:(int32_t)index bytes:(THHKotlinByteArray * _Nullable)bytes __attribute__((swift_name("bindBytes(index:bytes:)")));

/**
 * Bind [double] to the underlying statement at [index].
 */
- (void)bindDoubleIndex:(int32_t)index double:(THHDouble * _Nullable)double_ __attribute__((swift_name("bindDouble(index:double:)")));

/**
 * Bind [long] to the underlying statement at [index].
 */
- (void)bindLongIndex:(int32_t)index long:(THHLong * _Nullable)long_ __attribute__((swift_name("bindLong(index:long:)")));

/**
 * Bind [string] to the underlying statement at [index].
 */
- (void)bindStringIndex:(int32_t)index string:(NSString * _Nullable)string __attribute__((swift_name("bindString(index:string:)")));
@end


/**
 * Represents a SQL result set which can be iterated through with [next]. Initially the cursor will
 * not point to any row, and calling [next] once will iterate to the first row.
 */
__attribute__((swift_name("RuntimeSqlCursor")))
@protocol THHRuntimeSqlCursor
@required

/**
 * @return The boolean or null value of column [index] for the current row of the result set.
 */
- (THHBoolean * _Nullable)getBooleanIndex:(int32_t)index __attribute__((swift_name("getBoolean(index:)")));

/**
 * @return The bytes or null value of column [index] for the current row of the result set.
 */
- (THHKotlinByteArray * _Nullable)getBytesIndex:(int32_t)index __attribute__((swift_name("getBytes(index:)")));

/**
 * @return The double or null value of column [index] for the current row of the result set.
 */
- (THHDouble * _Nullable)getDoubleIndex:(int32_t)index __attribute__((swift_name("getDouble(index:)")));

/**
 * @return The int or null value of column [index] for the current row of the result set.
 */
- (THHLong * _Nullable)getLongIndex:(int32_t)index __attribute__((swift_name("getLong(index:)")));

/**
 * @return The string or null value of column [index] for the current row of the result set.
 */
- (NSString * _Nullable)getStringIndex:(int32_t)index __attribute__((swift_name("getString(index:)")));

/**
 * Move to the next row in the result set.
 *
 * @return true if the cursor successfully moved to a new row, false if there was no row to
 *   iterate to.
 */
- (id<THHRuntimeQueryResult>)next __attribute__((swift_name("next()")));
@end


/**
 * Represents a block of code [block] that should be executed during a migration after the migration
 * has finished migrating to [afterVersion].
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RuntimeAfterVersion")))
@interface THHRuntimeAfterVersion : THHBase
- (instancetype)initWithAfterVersion:(int64_t)afterVersion block:(void (^)(id<THHRuntimeSqlDriver>))block __attribute__((swift_name("init(afterVersion:block:)"))) __attribute__((objc_designated_initializer));
@property (readonly) int64_t afterVersion __attribute__((swift_name("afterVersion")));
@property (readonly) void (^block)(id<THHRuntimeSqlDriver>) __attribute__((swift_name("block")));
@end


/**
 * Base interface representing a [HttpClient] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientPlugin")))
@protocol THHKtor_client_coreHttpClientPlugin
@required

/**
 * Installs the [plugin] class for a [HttpClient] defined at [scope].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.install)
 */
- (void)installPlugin:(id)plugin scope:(THHKtor_client_coreHttpClient *)scope __attribute__((swift_name("install(plugin:scope:)")));

/**
 * Builds a [TPlugin] by calling the [block] with a [TConfig] config instance as receiver.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.prepare)
 */
- (id)prepareBlock:(void (^)(id))block __attribute__((swift_name("prepare(block:)")));

/**
 * The [AttributeKey] for this plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.key)
 */
@property (readonly) THHKtor_utilsAttributeKey<id> *key __attribute__((swift_name("key")));
@end


/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionsConfig")))
@interface THHKtor_websocketsWebSocketExtensionsConfig : THHBase

/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Instantiates all installed extensions.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig.build)
 */
- (NSArray<id<THHKtor_websocketsWebSocketExtension>> *)build __attribute__((swift_name("build()")));

/**
 * Installs the provided [extension] using [config]. Every extension is processed in order of installation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig.install)
 */
- (void)installExtension:(id<THHKtor_websocketsWebSocketExtensionFactory>)extension config:(void (^)(id))config __attribute__((swift_name("install(extension:config:)")));
@end


/**
 * A custom content converter that could be used in the [WebSockets] plugin
 * Could provide bi-directional conversion implementation.
 * One of the most typical examples of the content converter is a JSON converter that provides
 * both serialization and deserialization
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter)
 */
__attribute__((swift_name("Ktor_serializationWebsocketContentConverter")))
@protocol THHKtor_serializationWebsocketContentConverter
@required

/**
 * Deserializes [content] to the value of type [typeInfo]
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.deserialize)
 *
 * @return a converted value (deserialized) or throws `WebsocketConverterNotFoundException` if the context's
 * subject is not suitable for this converter
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deserializeCharset:(THHKtor_ioCharset *)charset typeInfo:(THHKtor_utilsTypeInfo *)typeInfo content:(THHKtor_websocketsFrame *)content completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("deserialize(charset:typeInfo:content:completionHandler:)")));

/**
 * Checks if the content converter can deserialize a [frame]
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.isApplicable)
 *
 * @param frame a WebSocket frame
 *
 * @return true if the content converter can deserialize a [frame] type or false if a type of [frame]
 * is not supported by the converter
 */
- (BOOL)isApplicableFrame:(THHKtor_websocketsFrame *)frame __attribute__((swift_name("isApplicable(frame:)")));

/**
 * Serializes a [value] to a WebSocket [Frame].
 * This function could throw `WebsocketConverterNotFoundException` if the value is not suitable for conversion
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.serialize)
 *
 * @param charset response charset
 * @param typeInfo response body typeInfo
 * @param value to be converted
 *
 * @return a converted [Frame] value, or null if [value] isn't suitable for this converter
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)serializeCharset:(THHKtor_ioCharset *)charset typeInfo:(THHKtor_utilsTypeInfo *)typeInfo value:(id _Nullable)value completionHandler:(void (^)(THHKtor_websocketsFrame * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("serialize(charset:typeInfo:value:completionHandler:)")));
@end

__attribute__((swift_name("KotlinByteIterator")))
@interface THHKotlinByteIterator : THHBase <THHKotlinIterator>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (THHByte *)next __attribute__((swift_name("next()")));
- (int8_t)nextByte __attribute__((swift_name("nextByte()")));
@end

__attribute__((swift_name("KotlinAppendable")))
@protocol THHKotlinAppendable
@required
- (id<THHKotlinAppendable>)appendValue:(unichar)value __attribute__((swift_name("append(value:)")));
- (id<THHKotlinAppendable>)appendValue_:(id _Nullable)value __attribute__((swift_name("append(value_:)")));
- (id<THHKotlinAppendable>)appendValue:(id _Nullable)value startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("append(value:startIndex:endIndex:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_coreFileMetadata")))
@interface THHKotlinx_io_coreFileMetadata : THHBase
- (instancetype)initWithIsRegularFile:(BOOL)isRegularFile isDirectory:(BOOL)isDirectory size:(int64_t)size __attribute__((swift_name("init(isRegularFile:isDirectory:size:)"))) __attribute__((objc_designated_initializer));
@property (readonly) BOOL isDirectory __attribute__((swift_name("isDirectory")));
@property (readonly) BOOL isRegularFile __attribute__((swift_name("isRegularFile")));
@property (readonly) int64_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_io_coreRawSink")))
@protocol THHKotlinx_io_coreRawSink <THHKotlinAutoCloseable>
@required
- (void)flush __attribute__((swift_name("flush()")));
- (void)writeSource:(THHKotlinx_io_coreBuffer *)source byteCount:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount:)")));
@end

__attribute__((swift_name("Kotlinx_io_coreRawSource")))
@protocol THHKotlinx_io_coreRawSource <THHKotlinAutoCloseable>
@required
- (int64_t)readAtMostToSink:(THHKotlinx_io_coreBuffer *)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readAtMostTo(sink:byteCount:)")));
@end

__attribute__((swift_name("Kermit_coreLoggerConfig")))
@protocol THHKermit_coreLoggerConfig
@required
@property (readonly) NSArray<THHKermit_coreLogWriter *> *logWriterList __attribute__((swift_name("logWriterList")));
@property (readonly) THHKermit_coreSeverity *minSeverity __attribute__((swift_name("minSeverity")));
@end

__attribute__((swift_name("Kermit_coreMutableLoggerConfig")))
@protocol THHKermit_coreMutableLoggerConfig <THHKermit_coreLoggerConfig>
@required
- (void)setLogWriterList:(NSArray<THHKermit_coreLogWriter *> *)value __attribute__((swift_name("setLogWriterList(_:)")));
- (void)setMinSeverity:(THHKermit_coreSeverity *)value __attribute__((swift_name("setMinSeverity(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KermitLogger.Companion")))
@interface THHKermitLoggerCompanion : THHKermitLogger
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithConfig:(id<THHKermit_coreLoggerConfig>)config tag:(NSString *)tag __attribute__((swift_name("init(config:tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKermitLoggerCompanion *shared __attribute__((swift_name("shared")));
- (void)aTag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("a(tag:throwable:message:)")));
- (void)addLogWriterLogWriter:(THHKotlinArray<THHKermit_coreLogWriter *> *)logWriter __attribute__((swift_name("addLogWriter(logWriter:)")));
- (void)dTag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("d(tag:throwable:message:)")));
- (void)eTag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("e(tag:throwable:message:)")));
- (void)iTag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("i(tag:throwable:message:)")));
- (void)setLogWritersLogWriter:(THHKotlinArray<THHKermit_coreLogWriter *> *)logWriter __attribute__((swift_name("setLogWriters(logWriter:)")));
- (void)setLogWritersLogWriters:(NSArray<THHKermit_coreLogWriter *> *)logWriters __attribute__((swift_name("setLogWriters(logWriters:)")));
- (void)setMinSeveritySeverity:(THHKermit_coreSeverity *)severity __attribute__((swift_name("setMinSeverity(severity:)")));
- (void)setTagTag:(NSString *)tag __attribute__((swift_name("setTag(tag:)")));
- (void)vTag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("v(tag:throwable:message:)")));
- (void)wTag:(NSString *)tag throwable:(THHKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("w(tag:throwable:message:)")));
@property (readonly) NSString *tag __attribute__((swift_name("tag")));
@end

__attribute__((swift_name("Kotlinx_io_coreSink")))
@protocol THHKotlinx_io_coreSink <THHKotlinx_io_coreRawSink>
@required
- (void)emit __attribute__((swift_name("emit()")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
- (void)hintEmit __attribute__((swift_name("hintEmit()")));
- (int64_t)transferFromSource:(id<THHKotlinx_io_coreRawSource>)source __attribute__((swift_name("transferFrom(source:)")));
- (void)writeSource:(id<THHKotlinx_io_coreRawSource>)source byteCount_:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount_:)")));
- (void)writeSource:(THHKotlinByteArray *)source startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("write(source:startIndex:endIndex:)")));
- (void)writeByteByte:(int8_t)byte __attribute__((swift_name("writeByte(byte:)")));
- (void)writeIntInt:(int32_t)int_ __attribute__((swift_name("writeInt(int:)")));
- (void)writeLongLong:(int64_t)long_ __attribute__((swift_name("writeLong(long:)")));
- (void)writeShortShort:(int16_t)short_ __attribute__((swift_name("writeShort(short:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) THHKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@end

__attribute__((swift_name("Ktor_ioChannelJob")))
@protocol THHKtor_ioChannelJob
@required
@property (readonly) id<THHKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioWriterJob")))
@interface THHKtor_ioWriterJob : THHBase <THHKtor_ioChannelJob>
@property (readonly) id<THHKtor_ioByteReadChannel> channel __attribute__((swift_name("channel")));
@property (readonly) id<THHKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end


/**
 * Channel for asynchronous reading of sequences of bytes.
 * This is a **single-reader channel**.
 *
 * Operations on this channel cannot be invoked concurrently.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteReadChannel)
 */
__attribute__((swift_name("Ktor_ioByteReadChannel")))
@protocol THHKtor_ioByteReadChannel
@required

/**
 * Suspend the channel until it has [min] bytes or gets closed. Throws exception if the channel was closed with an
 * error. If there are bytes available in the channel, this function returns immediately.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteReadChannel.awaitContent)
 *
 * @return return `false` eof is reached, otherwise `true`.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitContentMin:(int32_t)min completionHandler:(void (^)(THHBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("awaitContent(min:completionHandler:)")));
- (void)cancelCause_:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));
@property (readonly) THHKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForRead __attribute__((swift_name("isClosedForRead")));
@property (readonly) id<THHKotlinx_io_coreSource> readBuffer __attribute__((swift_name("readBuffer")));
@end

__attribute__((swift_name("Ktor_ioBufferedByteWriteChannel")))
@protocol THHKtor_ioBufferedByteWriteChannel <THHKtor_ioByteWriteChannel>
@required

/**
 * Flush all pending bytes from [writeBuffer] to the internal read buffer without suspension and initiate channel close.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.BufferedByteWriteChannel.close)
 */
- (void)close __attribute__((swift_name("close()")));

/**
 * Flush all pending bytes from [writeBuffer] to the internal read buffer without suspension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.BufferedByteWriteChannel.flushWriteBuffer)
 */
- (void)flushWriteBuffer __attribute__((swift_name("flushWriteBuffer()")));
@end


/**
 * Sequential (non-concurrent) byte channel implementation
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteChannel)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioByteChannel")))
@interface THHKtor_ioByteChannel : THHBase <THHKtor_ioByteReadChannel, THHKtor_ioBufferedByteWriteChannel>
- (instancetype)initWithAutoFlush:(BOOL)autoFlush __attribute__((swift_name("init(autoFlush:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitContentMin:(int32_t)min completionHandler:(void (^)(THHBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("awaitContent(min:completionHandler:)")));
- (void)cancelCause_:(THHKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));
- (void)close __attribute__((swift_name("close()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flush(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
- (void)flushWriteBuffer __attribute__((swift_name("flushWriteBuffer()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL autoFlush __attribute__((swift_name("autoFlush")));
@property (readonly) THHKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForRead __attribute__((swift_name("isClosedForRead")));
@property (readonly) BOOL isClosedForWrite __attribute__((swift_name("isClosedForWrite")));
@property (readonly) id<THHKotlinx_io_coreSource> readBuffer __attribute__((swift_name("readBuffer")));
@property (readonly) id<THHKotlinx_io_coreSink> writeBuffer __attribute__((swift_name("writeBuffer")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioReaderJob")))
@interface THHKtor_ioReaderJob : THHBase <THHKtor_ioChannelJob>

/**
 * To avoid the risk of concurrent write operations, we cancel the nested job before
 * performing `flushAndClose` on the [ByteWriteChannel].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ReaderJob.flushAndClose)
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
@property (readonly) id<THHKtor_ioByteWriteChannel> channel __attribute__((swift_name("channel")));
@property (readonly) id<THHKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end

__attribute__((swift_name("Ktor_networkSocketAddress")))
@interface THHKtor_networkSocketAddress : THHBase
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDate.Companion")))
@interface THHKotlinx_datetimeLocalDateCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeLocalDateCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_datetimeDateTimeFormat>)FormatBlock:(void (^)(id<THHKotlinx_datetimeDateTimeFormatBuilderWithDate>))block __attribute__((swift_name("Format(block:)")));
- (THHKotlinx_datetimeLocalDate *)fromEpochDaysEpochDays:(int32_t)epochDays __attribute__((swift_name("fromEpochDays(epochDays:)")));
- (THHKotlinx_datetimeLocalDate *)fromEpochDaysEpochDays_:(int64_t)epochDays __attribute__((swift_name("fromEpochDays(epochDays_:)")));
- (THHKotlinx_datetimeLocalDate *)parseInput:(id)input format:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("KotlinIterable")))
@protocol THHKotlinIterable
@required
- (id<THHKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
@end

__attribute__((swift_name("KotlinCollection")))
@protocol THHKotlinCollection <THHKotlinIterable>
@required
- (BOOL)containsElement:(id _Nullable)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsAllElements:(id)elements __attribute__((swift_name("containsAll(elements:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_datetimeLocalDateProgression")))
@interface THHKotlinx_datetimeLocalDateProgression : THHBase <THHKotlinCollection>
@property (class, readonly, getter=companion) THHKotlinx_datetimeLocalDateProgressionCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsElement:(THHKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsAllElements:(id)elements __attribute__((swift_name("containsAll(elements:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (id<THHKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHKotlinx_datetimeLocalDate *first __attribute__((swift_name("first")));
@property (readonly) THHKotlinx_datetimeLocalDate *last __attribute__((swift_name("last")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("KotlinClosedRange")))
@protocol THHKotlinClosedRange
@required
- (BOOL)containsValue:(id)value __attribute__((swift_name("contains(value:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) id endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly, getter=start_) id start __attribute__((swift_name("start")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.9")
*/
__attribute__((swift_name("KotlinOpenEndRange")))
@protocol THHKotlinOpenEndRange
@required
- (BOOL)containsValue_:(id)value __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) id endExclusive __attribute__((swift_name("endExclusive")));
@property (readonly, getter=start_) id start __attribute__((swift_name("start")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateRange")))
@interface THHKotlinx_datetimeLocalDateRange : THHKotlinx_datetimeLocalDateProgression <THHKotlinClosedRange, THHKotlinOpenEndRange>
- (instancetype)initWithStart:(THHKotlinx_datetimeLocalDate *)start endInclusive:(THHKotlinx_datetimeLocalDate *)endInclusive __attribute__((swift_name("init(start:endInclusive:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinx_datetimeLocalDateRangeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsElement:(THHKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsValue:(THHKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(value:)")));
- (BOOL)containsValue_:(THHKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHKotlinx_datetimeLocalDate *endExclusive __attribute__((swift_name("endExclusive"))) __attribute__((deprecated("This throws an exception if the exclusive end if not inside the platform-specific boundaries for LocalDate. The 'endInclusive' property does not throw and should be preferred.")));
@property (readonly) THHKotlinx_datetimeLocalDate *endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly, getter=start_) THHKotlinx_datetimeLocalDate *start __attribute__((swift_name("start")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalTime.Companion")))
@interface THHKotlinx_datetimeLocalTimeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeLocalTimeCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_datetimeDateTimeFormat>)FormatBuilder:(void (^)(id<THHKotlinx_datetimeDateTimeFormatBuilderWithTime>))builder __attribute__((swift_name("Format(builder:)")));
- (THHKotlinx_datetimeLocalTime *)fromMillisecondOfDayMillisecondOfDay:(int32_t)millisecondOfDay __attribute__((swift_name("fromMillisecondOfDay(millisecondOfDay:)")));
- (THHKotlinx_datetimeLocalTime *)fromNanosecondOfDayNanosecondOfDay:(int64_t)nanosecondOfDay __attribute__((swift_name("fromNanosecondOfDay(nanosecondOfDay:)")));
- (THHKotlinx_datetimeLocalTime *)fromSecondOfDaySecondOfDay:(int32_t)secondOfDay __attribute__((swift_name("fromSecondOfDay(secondOfDay:)")));
- (THHKotlinx_datetimeLocalTime *)parseInput:(id)input format:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilder")))
@protocol THHKotlinx_datetimeDateTimeFormatBuilder
@required
- (void)charsValue:(NSString *)value __attribute__((swift_name("chars(value:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithYearMonth")))
@protocol THHKotlinx_datetimeDateTimeFormatBuilderWithYearMonth <THHKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)monthNameNames:(THHKotlinx_datetimeMonthNames *)names __attribute__((swift_name("monthName(names:)")));
- (void)monthNumberPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("monthNumber(padding:)")));
- (void)yearPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("year(padding:)")));
- (void)yearMonthFormat:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("yearMonth(format:)")));
- (void)yearTwoDigitsBaseYear:(int32_t)baseYear __attribute__((swift_name("yearTwoDigits(baseYear:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithDate")))
@protocol THHKotlinx_datetimeDateTimeFormatBuilderWithDate <THHKotlinx_datetimeDateTimeFormatBuilderWithYearMonth>
@required
- (void)dateFormat:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("date(format:)")));
- (void)dayPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("day(padding:)")));
- (void)dayOfMonthPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("dayOfMonth(padding:)"))) __attribute__((deprecated("Use 'day' instead")));
- (void)dayOfWeekNames:(THHKotlinx_datetimeDayOfWeekNames *)names __attribute__((swift_name("dayOfWeek(names:)")));
- (void)dayOfYearPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("dayOfYear(padding:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithTime")))
@protocol THHKotlinx_datetimeDateTimeFormatBuilderWithTime <THHKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)amPmHourPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("amPmHour(padding:)")));
- (void)amPmMarkerAm:(NSString *)am pm:(NSString *)pm __attribute__((swift_name("amPmMarker(am:pm:)")));
- (void)hourPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("hour(padding:)")));
- (void)minutePadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("minute(padding:)")));
- (void)secondPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("second(padding:)")));
- (void)secondFractionFixedLength:(int32_t)fixedLength __attribute__((swift_name("secondFraction(fixedLength:)")));
- (void)secondFractionMinLength:(int32_t)minLength maxLength:(int32_t)maxLength __attribute__((swift_name("secondFraction(minLength:maxLength:)")));
- (void)timeFormat:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("time(format:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithDateTime")))
@protocol THHKotlinx_datetimeDateTimeFormatBuilderWithDateTime <THHKotlinx_datetimeDateTimeFormatBuilderWithDate, THHKotlinx_datetimeDateTimeFormatBuilderWithTime>
@required
- (void)dateTimeFormat:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("dateTime(format:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/FixedOffsetTimeZoneSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeFixedOffsetTimeZone")))
@interface THHKotlinx_datetimeFixedOffsetTimeZone : THHKotlinx_datetimeTimeZone
- (instancetype)initWithOffset:(THHKotlinx_datetimeUtcOffset *)offset __attribute__((swift_name("init(offset:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinx_datetimeFixedOffsetTimeZoneCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) THHKotlinx_datetimeUtcOffset *offset __attribute__((swift_name("offset")));
@property (readonly) int32_t totalSeconds __attribute__((swift_name("totalSeconds"))) __attribute__((deprecated("Use offset.totalSeconds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinInstant.Companion")))
@interface THHKotlinInstantCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinInstantCompanion *shared __attribute__((swift_name("shared")));
- (THHKotlinInstant *)fromEpochMillisecondsEpochMilliseconds:(int64_t)epochMilliseconds __attribute__((swift_name("fromEpochMilliseconds(epochMilliseconds:)")));
- (THHKotlinInstant *)fromEpochSecondsEpochSeconds:(int64_t)epochSeconds nanosecondAdjustment:(int32_t)nanosecondAdjustment __attribute__((swift_name("fromEpochSeconds(epochSeconds:nanosecondAdjustment:)")));
- (THHKotlinInstant *)fromEpochSecondsEpochSeconds:(int64_t)epochSeconds nanosecondAdjustment_:(int64_t)nanosecondAdjustment __attribute__((swift_name("fromEpochSeconds(epochSeconds:nanosecondAdjustment_:)")));
- (THHKotlinInstant *)now __attribute__((swift_name("now()"))) __attribute__((unavailable("Use Clock.System.now() instead")));
- (THHKotlinInstant *)parseInput:(id)input __attribute__((swift_name("parse(input:)")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.2")
*/
- (THHKotlinInstant * _Nullable)parseOrNullInput:(id)input __attribute__((swift_name("parseOrNull(input:)")));
@property (readonly) THHKotlinInstant *DISTANT_FUTURE __attribute__((swift_name("DISTANT_FUTURE")));
@property (readonly) THHKotlinInstant *DISTANT_PAST __attribute__((swift_name("DISTANT_PAST")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJson.Default")))
@interface THHKotlinx_serialization_jsonJsonDefault : THHKotlinx_serialization_jsonJson
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)default_ __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_serialization_jsonJsonDefault *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonConfiguration")))
@interface THHKotlinx_serialization_jsonJsonConfiguration : THHBase
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL allowComments __attribute__((swift_name("allowComments")));
@property (readonly) BOOL allowSpecialFloatingPointValues __attribute__((swift_name("allowSpecialFloatingPointValues")));
@property (readonly) BOOL allowStructuredMapKeys __attribute__((swift_name("allowStructuredMapKeys")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL allowTrailingComma __attribute__((swift_name("allowTrailingComma")));
@property (readonly) NSString *classDiscriminator __attribute__((swift_name("classDiscriminator")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property THHKotlinx_serialization_jsonClassDiscriminatorMode *classDiscriminatorMode __attribute__((swift_name("classDiscriminatorMode")));
@property (readonly) BOOL coerceInputValues __attribute__((swift_name("coerceInputValues")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL decodeEnumsCaseInsensitive __attribute__((swift_name("decodeEnumsCaseInsensitive")));
@property (readonly) BOOL encodeDefaults __attribute__((swift_name("encodeDefaults")));
@property (readonly) BOOL explicitNulls __attribute__((swift_name("explicitNulls")));
@property (readonly) BOOL ignoreUnknownKeys __attribute__((swift_name("ignoreUnknownKeys")));
@property (readonly) BOOL isLenient __attribute__((swift_name("isLenient")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) id<THHKotlinx_serialization_jsonJsonNamingStrategy> _Nullable namingStrategy __attribute__((swift_name("namingStrategy")));
@property (readonly) BOOL prettyPrint __attribute__((swift_name("prettyPrint")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) NSString *prettyPrintIndent __attribute__((swift_name("prettyPrintIndent")));
@property (readonly) BOOL useAlternativeNames __attribute__((swift_name("useAlternativeNames")));
@property (readonly) BOOL useArrayPolymorphism __attribute__((swift_name("useArrayPolymorphism")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreParentJob")))
@protocol THHKotlinx_coroutines_coreParentJob <THHKotlinx_coroutines_coreJob>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (THHKotlinCancellationException *)getChildJobCancellationCause __attribute__((swift_name("getChildJobCancellationCause()")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreSelectInstance")))
@protocol THHKotlinx_coroutines_coreSelectInstance
@required
- (void)disposeOnCompletionDisposableHandle:(id<THHKotlinx_coroutines_coreDisposableHandle>)disposableHandle __attribute__((swift_name("disposeOnCompletion(disposableHandle:)")));
- (void)selectInRegistrationPhaseInternalResult:(id _Nullable)internalResult __attribute__((swift_name("selectInRegistrationPhase(internalResult:)")));
- (BOOL)trySelectClauseObject:(id)clauseObject result:(id _Nullable)result __attribute__((swift_name("trySelect(clauseObject:result:)")));
@property (readonly) id<THHKotlinCoroutineContext> context __attribute__((swift_name("context")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
__attribute__((swift_name("Kotlinx_serialization_coreSerializersModuleCollector")))
@protocol THHKotlinx_serialization_coreSerializersModuleCollector
@required
- (void)contextualKClass:(id<THHKotlinKClass>)kClass provider:(id<THHKotlinx_serialization_coreKSerializer> (^)(NSArray<id<THHKotlinx_serialization_coreKSerializer>> *))provider __attribute__((swift_name("contextual(kClass:provider:)")));
- (void)contextualKClass:(id<THHKotlinKClass>)kClass serializer:(id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("contextual(kClass:serializer:)")));
- (void)polymorphicBaseClass:(id<THHKotlinKClass>)baseClass actualClass:(id<THHKotlinKClass>)actualClass actualSerializer:(id<THHKotlinx_serialization_coreKSerializer>)actualSerializer __attribute__((swift_name("polymorphic(baseClass:actualClass:actualSerializer:)")));
- (void)polymorphicDefaultBaseClass:(id<THHKotlinKClass>)baseClass defaultDeserializerProvider:(id<THHKotlinx_serialization_coreDeserializationStrategy> _Nullable (^)(NSString * _Nullable))defaultDeserializerProvider __attribute__((swift_name("polymorphicDefault(baseClass:defaultDeserializerProvider:)"))) __attribute__((deprecated("Deprecated in favor of function with more precise name: polymorphicDefaultDeserializer")));
- (void)polymorphicDefaultDeserializerBaseClass:(id<THHKotlinKClass>)baseClass defaultDeserializerProvider:(id<THHKotlinx_serialization_coreDeserializationStrategy> _Nullable (^)(NSString * _Nullable))defaultDeserializerProvider __attribute__((swift_name("polymorphicDefaultDeserializer(baseClass:defaultDeserializerProvider:)")));
- (void)polymorphicDefaultSerializerBaseClass:(id<THHKotlinKClass>)baseClass defaultSerializerProvider:(id<THHKotlinx_serialization_coreSerializationStrategy> _Nullable (^)(id))defaultSerializerProvider __attribute__((swift_name("polymorphicDefaultSerializer(baseClass:defaultSerializerProvider:)")));
@end

__attribute__((swift_name("KotlinKDeclarationContainer")))
@protocol THHKotlinKDeclarationContainer
@required
@end

__attribute__((swift_name("KotlinKAnnotatedElement")))
@protocol THHKotlinKAnnotatedElement
@required
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((swift_name("KotlinKClassifier")))
@protocol THHKotlinKClassifier
@required
@end

__attribute__((swift_name("KotlinKClass")))
@protocol THHKotlinKClass <THHKotlinKDeclarationContainer, THHKotlinKAnnotatedElement, THHKotlinKClassifier>
@required

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
- (BOOL)isInstanceValue:(id _Nullable)value __attribute__((swift_name("isInstance(value:)")));
@property (readonly) NSString * _Nullable qualifiedName __attribute__((swift_name("qualifiedName")));
@property (readonly) NSString * _Nullable simpleName __attribute__((swift_name("simpleName")));
@end


/**
 * Actual data of the [HttpRequest], including [url], [method], [headers], [body] and [executionContext].
 * Built by [HttpRequestBuilder].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestData)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestData")))
@interface THHKtor_client_coreHttpRequestData : THHBase
- (instancetype)initWithUrl:(THHKtor_httpUrl *)url method:(THHKtor_httpHttpMethod *)method headers:(id<THHKtor_httpHeaders>)headers body:(THHKtor_httpOutgoingContent *)body executionContext:(id<THHKotlinx_coroutines_coreJob>)executionContext attributes:(id<THHKtor_utilsAttributes>)attributes __attribute__((swift_name("init(url:method:headers:body:executionContext:attributes:)"))) __attribute__((objc_designated_initializer));

/**
 * Retrieve extension by its key.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestData.getCapabilityOrNull)
 */
- (id _Nullable)getCapabilityOrNullKey:(id<THHKtor_client_coreHttpClientEngineCapability>)key __attribute__((swift_name("getCapabilityOrNull(key:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<THHKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) THHKtor_httpOutgoingContent *body __attribute__((swift_name("body")));
@property (readonly) id<THHKotlinx_coroutines_coreJob> executionContext __attribute__((swift_name("executionContext")));
@property (readonly) id<THHKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) THHKtor_httpHttpMethod *method __attribute__((swift_name("method")));
@property (readonly) THHKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * Data prepared for [HttpResponse].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpResponseData)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponseData")))
@interface THHKtor_client_coreHttpResponseData : THHBase
- (instancetype)initWithStatusCode:(THHKtor_httpHttpStatusCode *)statusCode requestTime:(THHKtor_utilsGMTDate *)requestTime headers:(id<THHKtor_httpHeaders>)headers version:(THHKtor_httpHttpProtocolVersion *)version body:(id)body callContext:(id<THHKotlinCoroutineContext>)callContext __attribute__((swift_name("init(statusCode:requestTime:headers:version:body:callContext:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id body __attribute__((swift_name("body")));
@property (readonly) id<THHKotlinCoroutineContext> callContext __attribute__((swift_name("callContext")));
@property (readonly) id<THHKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) THHKtor_utilsGMTDate *requestTime __attribute__((swift_name("requestTime")));
@property (readonly) THHKtor_utilsGMTDate *responseTime __attribute__((swift_name("responseTime")));
@property (readonly) THHKtor_httpHttpStatusCode *statusCode __attribute__((swift_name("statusCode")));
@property (readonly) THHKtor_httpHttpProtocolVersion *version __attribute__((swift_name("version")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinAbstractCoroutineContextElement")))
@interface THHKotlinAbstractCoroutineContextElement : THHBase <THHKotlinCoroutineContextElement>
- (instancetype)initWithKey:(id<THHKotlinCoroutineContextKey>)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer));
@property (readonly) id<THHKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinContinuationInterceptor")))
@protocol THHKotlinContinuationInterceptor <THHKotlinCoroutineContextElement>
@required
- (id<THHKotlinContinuation>)interceptContinuationContinuation:(id<THHKotlinContinuation>)continuation __attribute__((swift_name("interceptContinuation(continuation:)")));
- (void)releaseInterceptedContinuationContinuation:(id<THHKotlinContinuation>)continuation __attribute__((swift_name("releaseInterceptedContinuation(continuation:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineDispatcher")))
@interface THHKotlinx_coroutines_coreCoroutineDispatcher : THHKotlinAbstractCoroutineContextElement <THHKotlinContinuationInterceptor>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithKey:(id<THHKotlinCoroutineContextKey>)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKotlinx_coroutines_coreCoroutineDispatcherKey *companion __attribute__((swift_name("companion")));
- (void)dispatchContext:(id<THHKotlinCoroutineContext>)context block:(id<THHKotlinx_coroutines_coreRunnable>)block __attribute__((swift_name("dispatch(context:block:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (void)dispatchYieldContext:(id<THHKotlinCoroutineContext>)context block:(id<THHKotlinx_coroutines_coreRunnable>)block __attribute__((swift_name("dispatchYield(context:block:)")));
- (id<THHKotlinContinuation>)interceptContinuationContinuation:(id<THHKotlinContinuation>)continuation __attribute__((swift_name("interceptContinuation(continuation:)")));
- (BOOL)isDispatchNeededContext:(id<THHKotlinCoroutineContext>)context __attribute__((swift_name("isDispatchNeeded(context:)")));
- (THHKotlinx_coroutines_coreCoroutineDispatcher *)limitedParallelismParallelism:(int32_t)parallelism name:(NSString * _Nullable)name __attribute__((swift_name("limitedParallelism(parallelism:name:)")));
- (THHKotlinx_coroutines_coreCoroutineDispatcher *)plusOther_:(THHKotlinx_coroutines_coreCoroutineDispatcher *)other __attribute__((swift_name("plus(other_:)"))) __attribute__((unavailable("Operator '+' on two CoroutineDispatcher objects is meaningless. CoroutineDispatcher is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The dispatcher to the right of `+` just replaces the dispatcher to the left.")));
- (void)releaseInterceptedContinuationContinuation:(id<THHKotlinContinuation>)continuation __attribute__((swift_name("releaseInterceptedContinuation(continuation:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@end


/**
 * Proxy configuration.
 *
 * See [ProxyBuilder] to create proxy.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.ProxyConfig)
 *
 * @param url: proxy url address.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreProxyConfig")))
@interface THHKtor_client_coreProxyConfig : THHBase
- (instancetype)initWithUrl:(THHKtor_httpUrl *)url __attribute__((swift_name("init(url:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsAttributeKey")))
@interface THHKtor_utilsAttributeKey<T> : THHBase

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (instancetype)initWithName:(NSString *)name type:(THHKtor_utilsTypeInfo *)type __attribute__((swift_name("init(name:type:)"))) __attribute__((objc_designated_initializer));
- (THHKtor_utilsAttributeKey<T> *)doCopyName:(NSString *)name type:(THHKtor_utilsTypeInfo *)type __attribute__((swift_name("doCopy(name:type:)")));

/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end


/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
__attribute__((swift_name("Ktor_eventsEventDefinition")))
@interface THHKtor_eventsEventDefinition<T> : THHBase

/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end


/**
 * Represents a phase in a pipeline
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.PipelinePhase)
 *
 * @param name a name for this phase
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsPipelinePhase")))
@interface THHKtor_utilsPipelinePhase : THHBase
- (instancetype)initWithName:(NSString *)name __attribute__((swift_name("init(name:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((swift_name("KotlinSuspendFunction2")))
@protocol THHKotlinSuspendFunction2 <THHKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 p2:(id _Nullable)p2 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:p2:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpReceivePipeline.Phases")))
@interface THHKtor_client_coreHttpReceivePipelinePhases : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_client_coreHttpReceivePipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * Latest response pipeline phase
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.After)
 */
@property (readonly) THHKtor_utilsPipelinePhase *After __attribute__((swift_name("After")));

/**
 * The earliest phase that happens before any other
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.Before)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Use this phase to store request shared state
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.State)
 */
@property (readonly) THHKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@end


/**
 * A message either from the client or the server,
 * that has [headers] associated.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessage)
 */
__attribute__((swift_name("Ktor_httpHttpMessage")))
@protocol THHKtor_httpHttpMessage
@required

/**
 * Message [Headers]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessage.headers)
 */
@property (readonly) id<THHKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@end


/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
__attribute__((swift_name("Ktor_client_coreHttpResponse")))
@interface THHKtor_client_coreHttpResponse : THHBase <THHKtor_httpHttpMessage, THHKotlinx_coroutines_coreCoroutineScope>

/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The associated [HttpClientCall] containing both
 * the underlying [HttpClientCall.request] and [HttpClientCall.response].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.call)
 */
@property (readonly) THHKtor_client_coreHttpClientCall *call __attribute__((swift_name("call")));

/**
 * Provides a raw [ByteReadChannel] to the response content as it is read from the network.
 * This content can be still compressed or encoded.
 *
 * This content doesn't go through any interceptors from [HttpResponsePipeline].
 *
 * If you need to read the content as decoded bytes, use the [bodyAsChannel] method instead.
 *
 * This property produces a new channel every time it's accessed.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.rawContent)
 */
@property (readonly) id<THHKtor_ioByteReadChannel> rawContent __attribute__((swift_name("rawContent")));

/**
 * [GMTDate] of the request start.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.requestTime)
 */
@property (readonly) THHKtor_utilsGMTDate *requestTime __attribute__((swift_name("requestTime")));

/**
 * [GMTDate] of the response start.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.responseTime)
 */
@property (readonly) THHKtor_utilsGMTDate *responseTime __attribute__((swift_name("responseTime")));

/**
 * The [HttpStatusCode] returned by the server. It includes both,
 * the [HttpStatusCode.description] and the [HttpStatusCode.value] (code).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.status)
 */
@property (readonly) THHKtor_httpHttpStatusCode *status __attribute__((swift_name("status")));

/**
 * HTTP version. Usually [HttpProtocolVersion.HTTP_1_1] or [HttpProtocolVersion.HTTP_2_0].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.version)
 */
@property (readonly) THHKtor_httpHttpProtocolVersion *version_ __attribute__((swift_name("version_")));
@end


/**
 * All interceptors accept payload as [subject] and try to convert it to [OutgoingContent].
 * Last phase should proceed with [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestPipeline.Phases")))
@interface THHKtor_client_coreHttpRequestPipelinePhases : THHBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * All interceptors accept payload as [subject] and try to convert it to [OutgoingContent].
 * Last phase should proceed with [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_client_coreHttpRequestPipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * The earliest phase that happens before any other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Before)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Encode a request body to [OutgoingContent].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Render)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Render __attribute__((swift_name("Render")));

/**
 * A phase for the [HttpSend] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Send)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Send __attribute__((swift_name("Send")));

/**
 * Use this phase to modify a request with a shared state.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.State)
 */
@property (readonly) THHKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));

/**
 * Transform a request body to supported render format.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Transform)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Transform __attribute__((swift_name("Transform")));
@end


/**
 * A builder message either for the client or the server,
 * that has a [headers] builder associated.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessageBuilder)
 */
__attribute__((swift_name("Ktor_httpHttpMessageBuilder")))
@protocol THHKtor_httpHttpMessageBuilder
@required

/**
 * MessageBuilder [HeadersBuilder]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessageBuilder.headers)
 */
@property (readonly) THHKtor_httpHeadersBuilder *headers __attribute__((swift_name("headers")));
@end


/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestBuilder")))
@interface THHKtor_client_coreHttpRequestBuilder : THHBase <THHKtor_httpHttpMessageBuilder>

/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) THHKtor_client_coreHttpRequestBuilderCompanion *companion __attribute__((swift_name("companion")));

/**
 * Creates immutable [HttpRequestData].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.build)
 */
- (THHKtor_client_coreHttpRequestData *)build __attribute__((swift_name("build()")));

/**
 * Retrieves capability by the key.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.getCapabilityOrNull)
 */
- (id _Nullable)getCapabilityOrNullKey:(id<THHKtor_client_coreHttpClientEngineCapability>)key __attribute__((swift_name("getCapabilityOrNull(key:)")));

/**
 * Sets request-specific attributes specified by [block].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.setAttributes)
 */
- (void)setAttributesBlock:(void (^)(id<THHKtor_utilsAttributes>))block __attribute__((swift_name("setAttributes(block:)")));

/**
 * Sets capability configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.setCapability)
 */
- (void)setCapabilityKey:(id<THHKtor_client_coreHttpClientEngineCapability>)key capability:(id)capability __attribute__((swift_name("setCapability(key:capability:)")));

/**
 * Mutates [this] by copying all the data but execution context from another [builder] using it as the base.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.takeFrom)
 */
- (THHKtor_client_coreHttpRequestBuilder *)takeFromBuilder:(THHKtor_client_coreHttpRequestBuilder *)builder __attribute__((swift_name("takeFrom(builder:)")));

/**
 * Mutates [this] copying all the data from another [builder] using it as the base.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.takeFromWithExecutionContext)
 */
- (THHKtor_client_coreHttpRequestBuilder *)takeFromWithExecutionContextBuilder:(THHKtor_client_coreHttpRequestBuilder *)builder __attribute__((swift_name("takeFromWithExecutionContext(builder:)")));

/**
 * Executes a [block] that configures the [URLBuilder] associated to this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.url)
 */
- (void)urlBlock:(void (^)(THHKtor_httpURLBuilder *, THHKtor_httpURLBuilder *))block __attribute__((swift_name("url(block:)")));

/**
 * Provides access to attributes specific for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.attributes)
 */
@property (readonly) id<THHKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * The [body] for this request. Initially [EmptyContent].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.body)
 */
@property id body __attribute__((swift_name("body")));

/**
 * The [KType] of [body] for this request. Null for default types that don't need serialization.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.bodyType)
 */
@property THHKtor_utilsTypeInfo * _Nullable bodyType __attribute__((swift_name("bodyType")));

/**
 * A deferred used to control the execution of this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.executionContext)
 */
@property (readonly) id<THHKotlinx_coroutines_coreJob> executionContext __attribute__((swift_name("executionContext")));

/**
 * [HeadersBuilder] to configure the headers for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.headers)
 */
@property (readonly) THHKtor_httpHeadersBuilder *headers __attribute__((swift_name("headers")));

/**
 * [HttpMethod] used by this request. [HttpMethod.Get] by default.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.method)
 */
@property THHKtor_httpHttpMethod *method __attribute__((swift_name("method")));

/**
 * [URLBuilder] to configure the URL for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.url)
 */
@property (readonly) THHKtor_httpURLBuilder *url __attribute__((swift_name("url")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponsePipeline.Phases")))
@interface THHKtor_client_coreHttpResponsePipelinePhases : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_client_coreHttpResponsePipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * Latest response pipeline phase
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.After)
 */
@property (readonly) THHKtor_utilsPipelinePhase *After __attribute__((swift_name("After")));

/**
 * Decode response body
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Parse)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Parse __attribute__((swift_name("Parse")));

/**
 * The earliest phase that happens before any other
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Receive)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Receive __attribute__((swift_name("Receive")));

/**
 * Use this phase to store request shared state
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.State)
 */
@property (readonly) THHKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));

/**
 * Transform response body to expected format
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Transform)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Transform __attribute__((swift_name("Transform")));
@end


/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponseContainer")))
@interface THHKtor_client_coreHttpResponseContainer : THHBase
- (instancetype)initWithExpectedType:(THHKtor_utilsTypeInfo *)expectedType response:(id)response __attribute__((swift_name("init(expectedType:response:)"))) __attribute__((objc_designated_initializer));
- (THHKtor_client_coreHttpResponseContainer *)doCopyExpectedType:(THHKtor_utilsTypeInfo *)expectedType response:(id)response __attribute__((swift_name("doCopy(expectedType:response:)")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHKtor_utilsTypeInfo *expectedType __attribute__((swift_name("expectedType")));
@property (readonly) id response __attribute__((swift_name("response")));
@end


/**
 * A pair of a [request] and [response] for a specific [HttpClient].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall)
 *
 * @property client the client that executed the call.
 */
__attribute__((swift_name("Ktor_client_coreHttpClientCall")))
@interface THHKtor_client_coreHttpClientCall : THHBase <THHKotlinx_coroutines_coreCoroutineScope>
- (instancetype)initWithClient:(THHKtor_client_coreHttpClient *)client __attribute__((swift_name("init(client:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithClient:(THHKtor_client_coreHttpClient *)client requestData:(THHKtor_client_coreHttpRequestData *)requestData responseData:(THHKtor_client_coreHttpResponseData *)responseData __attribute__((swift_name("init(client:requestData:responseData:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_client_coreHttpClientCallCompanion *companion __attribute__((swift_name("companion")));

/**
 * Tries to receive the payload of the [response] as a specific expected type provided in [info].
 * Returns [response] if [info] corresponds to [HttpResponse].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.body)
 *
 * @throws NoTransformationFoundException If no transformation is found for the type [info].
 * @throws DoubleReceiveException If already called [body].
 * @throws NullPointerException If content is `null`.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)bodyInfo:(THHKtor_utilsTypeInfo *)info completionHandler:(void (^)(id _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("body(info:completionHandler:)")));

/**
 * Tries to receive the payload of the [response] as a specific expected type provided in [info].
 * Returns [response] if [info] corresponds to [HttpResponse].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.bodyNullable)
 *
 * @throws NoTransformationFoundException If no transformation is found for the type [info].
 * @throws DoubleReceiveException If already called [body].
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)bodyNullableInfo:(THHKtor_utilsTypeInfo *)info completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("bodyNullable(info:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)getResponseContentWithCompletionHandler:(void (^)(id<THHKtor_ioByteReadChannel> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getResponseContent(completionHandler:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) BOOL allowDoubleReceive __attribute__((swift_name("allowDoubleReceive")));

/**
 * Typed [Attributes] associated to this call serving as a lightweight container.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.attributes)
 */
@property (readonly) id<THHKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) THHKtor_client_coreHttpClient *client __attribute__((swift_name("client")));
@property (readonly) id<THHKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));

/**
 * The [request] sent by the client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.request)
 */
@property id<THHKtor_client_coreHttpRequest> request __attribute__((swift_name("request")));

/**
 * The [response] sent by the server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.response)
 */
@property THHKtor_client_coreHttpResponse *response __attribute__((swift_name("response")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpSendPipeline.Phases")))
@interface THHKtor_client_coreHttpSendPipelinePhases : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_client_coreHttpSendPipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * The earliest phase that happens before any other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Before)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Send a request to a remote server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Engine)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Engine __attribute__((swift_name("Engine")));

/**
 * Use this phase for logging and other actions that don't modify a request or shared data.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Monitoring)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Monitoring __attribute__((swift_name("Monitoring")));

/**
 * Receive a pipeline execution phase.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Receive)
 */
@property (readonly) THHKtor_utilsPipelinePhase *Receive __attribute__((swift_name("Receive")));

/**
 * Use this phase to modify request with a shared state.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.State)
 */
@property (readonly) THHKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@end


/**
 * A WebSocket extension instance.
 * This instance is created for each WebSocket request, for every installed extension by [WebSocketExtensionFactory].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension)
 */
__attribute__((swift_name("Ktor_websocketsWebSocketExtension")))
@protocol THHKtor_websocketsWebSocketExtension
@required

/**
 * This method is called only for the client, when it receives the WebSocket upgrade response.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.clientNegotiation)
 *
 * @param negotiatedProtocols contains list of negotiated extensions from the server (can be empty).
 *
 * It's up to extension to decide if it should be used or not.
 * @return `true` if the extension should be used by the client.
 */
- (BOOL)clientNegotiationNegotiatedProtocols:(NSArray<THHKtor_websocketsWebSocketExtensionHeader *> *)negotiatedProtocols __attribute__((swift_name("clientNegotiation(negotiatedProtocols:)")));

/**
 * This method is called on each incoming frame before handling it in WebSocket session.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.processIncomingFrame)
 */
- (THHKtor_websocketsFrame *)processIncomingFrameFrame:(THHKtor_websocketsFrame *)frame __attribute__((swift_name("processIncomingFrame(frame:)")));

/**
 * This method is called on each outgoing frame and handle it before sending.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.processOutgoingFrame)
 */
- (THHKtor_websocketsFrame *)processOutgoingFrameFrame:(THHKtor_websocketsFrame *)frame __attribute__((swift_name("processOutgoingFrame(frame:)")));

/**
 * This method is called only for the server, when it receives WebSocket session.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.serverNegotiation)
 *
 * @param requestedProtocols contains list of requested extensions from the client (can be empty).
 *
 * @return list of protocols (with parameters), which server prefers to use for the current client request.
 */
- (NSArray<THHKtor_websocketsWebSocketExtensionHeader *> *)serverNegotiationRequestedProtocols:(NSArray<THHKtor_websocketsWebSocketExtensionHeader *> *)requestedProtocols __attribute__((swift_name("serverNegotiation(requestedProtocols:)")));

/**
 * Reference to the [WebSocketExtensionFactory], which produced this extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.factory)
 */
@property (readonly) id<THHKtor_websocketsWebSocketExtensionFactory> factory __attribute__((swift_name("factory")));

/**
 * List of WebSocket extension protocols which will be sent by client in headers.
 * They are required to inform server that client wants to negotiate the current extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.protocols)
 */
@property (readonly) NSArray<THHKtor_websocketsWebSocketExtensionHeader *> *protocols __attribute__((swift_name("protocols")));
@end


/**
 * A factory that defines a WebSocket extension. The factory is used in pair with the
 * [WebSocketExtensionsConfig.install] method to install the WebSocket extension in client or server.
 *
 * Usually this interface is implemented in `companion object` of the origin [WebSocketExtension].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory)
 */
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionFactory")))
@protocol THHKtor_websocketsWebSocketExtensionFactory
@required

/**
 * Creates an extension instance using [config] block. The extension instance is created for each WebSocket request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.install)
 */
- (id<THHKtor_websocketsWebSocketExtension>)installConfig:(void (^)(id))config __attribute__((swift_name("install(config:)")));

/**
 * A key used to locate an extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.key)
 */
@property (readonly) THHKtor_utilsAttributeKey<id<THHKtor_websocketsWebSocketExtension>> *key __attribute__((swift_name("key")));

/**
 * The first extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with the enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv1)
 */
@property (readonly) BOOL rsv1 __attribute__((swift_name("rsv1")));

/**
 * A second extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with the enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv2)
 */
@property (readonly) BOOL rsv2 __attribute__((swift_name("rsv2")));

/**
 * A third extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv3)
 */
@property (readonly) BOOL rsv3 __attribute__((swift_name("rsv3")));
@end

__attribute__((swift_name("Ktor_ioCharset")))
@interface THHKtor_ioCharset : THHBase
- (instancetype)initWith_name:(NSString *)_name __attribute__((swift_name("init(_name:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_ioCharsetCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (THHKtor_ioCharsetDecoder *)doNewDecoder __attribute__((swift_name("doNewDecoder()")));
- (THHKtor_ioCharsetEncoder *)doNewEncoder __attribute__((swift_name("doNewEncoder()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end


/**
 * Ktor type information.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.reflect.TypeInfo)
 *
 * @property type Source KClass<*>
 * @property kotlinType Kotlin reified type with all generic type parameters.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsTypeInfo")))
@interface THHKtor_utilsTypeInfo : THHBase
- (instancetype)initWithType:(id<THHKotlinKClass>)type kotlinType:(id<THHKotlinKType> _Nullable)kotlinType __attribute__((swift_name("init(type:kotlinType:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithType:(id<THHKotlinKClass>)type reifiedType:(id<THHKotlinKType>)reifiedType kotlinType:(id<THHKotlinKType> _Nullable)kotlinType __attribute__((swift_name("init(type:reifiedType:kotlinType:)"))) __attribute__((objc_designated_initializer)) __attribute__((deprecated("Use constructor without reifiedType parameter.")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<THHKotlinKType> _Nullable kotlinType __attribute__((swift_name("kotlinType")));
@property (readonly) id<THHKotlinKClass> type __attribute__((swift_name("type")));
@end


/**
 * A frame received or ready to be sent. It is not reusable and not thread-safe
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame)
 *
 * @property fin is it final fragment, should be always `true` for control frames and if no fragmentation is used
 * @property frameType enum value
 * @property data - a frame content or fragment content
 * @property disposableHandle could be invoked when the frame is processed
 */
__attribute__((swift_name("Ktor_websocketsFrame")))
@interface THHKtor_websocketsFrame : THHBase
@property (class, readonly, getter=companion) THHKtor_websocketsFrameCompanion *companion __attribute__((swift_name("companion")));

/**
 * Creates a frame copy.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame.copy)
 */
- (THHKtor_websocketsFrame *)doCopy __attribute__((swift_name("doCopy()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) THHKotlinByteArray *data __attribute__((swift_name("data")));
@property (readonly) id<THHKotlinx_coroutines_coreDisposableHandle> disposableHandle __attribute__((swift_name("disposableHandle")));
@property (readonly) BOOL fin __attribute__((swift_name("fin")));
@property (readonly) THHKtor_websocketsFrameType *frameType __attribute__((swift_name("frameType")));
@property (readonly) BOOL rsv1 __attribute__((swift_name("rsv1")));
@property (readonly) BOOL rsv2 __attribute__((swift_name("rsv2")));
@property (readonly) BOOL rsv3 __attribute__((swift_name("rsv3")));
@end

__attribute__((swift_name("Kotlinx_io_coreSource")))
@protocol THHKotlinx_io_coreSource <THHKotlinx_io_coreRawSource>
@required
- (BOOL)exhausted __attribute__((swift_name("exhausted()")));
- (id<THHKotlinx_io_coreSource>)peek __attribute__((swift_name("peek()")));
- (int32_t)readAtMostToSink:(THHKotlinByteArray *)sink startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("readAtMostTo(sink:startIndex:endIndex:)")));
- (int8_t)readByte __attribute__((swift_name("readByte()")));
- (int32_t)readInt __attribute__((swift_name("readInt()")));
- (int64_t)readLong __attribute__((swift_name("readLong()")));
- (int16_t)readShort __attribute__((swift_name("readShort()")));
- (void)readToSink:(id<THHKotlinx_io_coreRawSink>)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readTo(sink:byteCount:)")));
- (BOOL)requestByteCount:(int64_t)byteCount __attribute__((swift_name("request(byteCount:)")));
- (void)requireByteCount:(int64_t)byteCount __attribute__((swift_name("require(byteCount:)")));
- (void)skipByteCount:(int64_t)byteCount __attribute__((swift_name("skip(byteCount:)")));
- (int64_t)transferToSink:(id<THHKotlinx_io_coreRawSink>)sink __attribute__((swift_name("transferTo(sink:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) THHKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_coreBuffer")))
@interface THHKotlinx_io_coreBuffer : THHBase <THHKotlinx_io_coreSource, THHKotlinx_io_coreSink>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)clear __attribute__((swift_name("clear()")));
- (void)close __attribute__((swift_name("close()")));
- (THHKotlinx_io_coreBuffer *)doCopy __attribute__((swift_name("doCopy()")));
- (void)doCopyToOut:(THHKotlinx_io_coreBuffer *)out startIndex:(int64_t)startIndex endIndex:(int64_t)endIndex __attribute__((swift_name("doCopyTo(out:startIndex:endIndex:)")));
- (void)emit __attribute__((swift_name("emit()")));
- (BOOL)exhausted __attribute__((swift_name("exhausted()")));
- (void)flush __attribute__((swift_name("flush()")));
- (int8_t)getPosition:(int64_t)position __attribute__((swift_name("get(position:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
- (void)hintEmit __attribute__((swift_name("hintEmit()")));
- (id<THHKotlinx_io_coreSource>)peek __attribute__((swift_name("peek()")));
- (int64_t)readAtMostToSink:(THHKotlinx_io_coreBuffer *)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readAtMostTo(sink:byteCount:)")));
- (int32_t)readAtMostToSink:(THHKotlinByteArray *)sink startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("readAtMostTo(sink:startIndex:endIndex:)")));
- (int8_t)readByte __attribute__((swift_name("readByte()")));
- (int32_t)readInt __attribute__((swift_name("readInt()")));
- (int64_t)readLong __attribute__((swift_name("readLong()")));
- (int16_t)readShort __attribute__((swift_name("readShort()")));
- (void)readToSink:(id<THHKotlinx_io_coreRawSink>)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readTo(sink:byteCount:)")));
- (BOOL)requestByteCount:(int64_t)byteCount __attribute__((swift_name("request(byteCount:)")));
- (void)requireByteCount:(int64_t)byteCount __attribute__((swift_name("require(byteCount:)")));
- (void)skipByteCount:(int64_t)byteCount __attribute__((swift_name("skip(byteCount:)")));
- (NSString *)description __attribute__((swift_name("description()")));
- (int64_t)transferFromSource:(id<THHKotlinx_io_coreRawSource>)source __attribute__((swift_name("transferFrom(source:)")));
- (int64_t)transferToSink:(id<THHKotlinx_io_coreRawSink>)sink __attribute__((swift_name("transferTo(sink:)")));
- (void)writeSource:(THHKotlinx_io_coreBuffer *)source byteCount:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount:)")));
- (void)writeSource:(id<THHKotlinx_io_coreRawSource>)source byteCount_:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount_:)")));
- (void)writeSource:(THHKotlinByteArray *)source startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("write(source:startIndex:endIndex:)")));
- (void)writeByteByte:(int8_t)byte __attribute__((swift_name("writeByte(byte:)")));
- (void)writeIntInt:(int32_t)int_ __attribute__((swift_name("writeInt(int:)")));
- (void)writeLongLong:(int64_t)long_ __attribute__((swift_name("writeLong(long:)")));
- (void)writeShortShort:(int16_t)short_ __attribute__((swift_name("writeShort(short:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) THHKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@property (readonly) int64_t size __attribute__((swift_name("size")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateProgression.Companion")))
@interface THHKotlinx_datetimeLocalDateProgressionCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeLocalDateProgressionCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateRange.Companion")))
@interface THHKotlinx_datetimeLocalDateRangeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeLocalDateRangeCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) THHKotlinx_datetimeLocalDateRange *EMPTY __attribute__((swift_name("EMPTY")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimePadding")))
@interface THHKotlinx_datetimePadding : THHKotlinEnum<THHKotlinx_datetimePadding *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHKotlinx_datetimePadding *none __attribute__((swift_name("none")));
@property (class, readonly) THHKotlinx_datetimePadding *zero __attribute__((swift_name("zero")));
@property (class, readonly) THHKotlinx_datetimePadding *space __attribute__((swift_name("space")));
+ (THHKotlinArray<THHKotlinx_datetimePadding *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKotlinx_datetimePadding *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeekNames")))
@interface THHKotlinx_datetimeDayOfWeekNames : THHBase
- (instancetype)initWithNames:(NSArray<NSString *> *)names __attribute__((swift_name("init(names:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMonday:(NSString *)monday tuesday:(NSString *)tuesday wednesday:(NSString *)wednesday thursday:(NSString *)thursday friday:(NSString *)friday saturday:(NSString *)saturday sunday:(NSString *)sunday __attribute__((swift_name("init(monday:tuesday:wednesday:thursday:friday:saturday:sunday:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinx_datetimeDayOfWeekNamesCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *names __attribute__((swift_name("names")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonthNames")))
@interface THHKotlinx_datetimeMonthNames : THHBase
- (instancetype)initWithNames:(NSArray<NSString *> *)names __attribute__((swift_name("init(names:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithJanuary:(NSString *)january february:(NSString *)february march:(NSString *)march april:(NSString *)april may:(NSString *)may june:(NSString *)june july:(NSString *)july august:(NSString *)august september:(NSString *)september october:(NSString *)october november:(NSString *)november december:(NSString *)december __attribute__((swift_name("init(january:february:march:april:may:june:july:august:september:october:november:december:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinx_datetimeMonthNamesCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *names __attribute__((swift_name("names")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/UtcOffsetSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeUtcOffset")))
@interface THHKotlinx_datetimeUtcOffset : THHBase
@property (class, readonly, getter=companion) THHKotlinx_datetimeUtcOffsetCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t totalSeconds __attribute__((swift_name("totalSeconds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeFixedOffsetTimeZone.Companion")))
@interface THHKotlinx_datetimeFixedOffsetTimeZoneCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeFixedOffsetTimeZoneCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonClassDiscriminatorMode")))
@interface THHKotlinx_serialization_jsonClassDiscriminatorMode : THHKotlinEnum<THHKotlinx_serialization_jsonClassDiscriminatorMode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHKotlinx_serialization_jsonClassDiscriminatorMode *none __attribute__((swift_name("none")));
@property (class, readonly) THHKotlinx_serialization_jsonClassDiscriminatorMode *allJsonObjects __attribute__((swift_name("allJsonObjects")));
@property (class, readonly) THHKotlinx_serialization_jsonClassDiscriminatorMode *polymorphic __attribute__((swift_name("polymorphic")));
+ (THHKotlinArray<THHKotlinx_serialization_jsonClassDiscriminatorMode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKotlinx_serialization_jsonClassDiscriminatorMode *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonNamingStrategy")))
@protocol THHKotlinx_serialization_jsonJsonNamingStrategy
@required
- (NSString *)serialNameForJsonDescriptor:(id<THHKotlinx_serialization_coreSerialDescriptor>)descriptor elementIndex:(int32_t)elementIndex serialName:(NSString *)serialName __attribute__((swift_name("serialNameForJson(descriptor:elementIndex:serialName:)")));
@end

__attribute__((swift_name("Ktor_ioJvmSerializable")))
@protocol THHKtor_ioJvmSerializable
@required
@end


/**
 * Represents an immutable URL
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url)
 *
 * @property protocol
 * @property host name without port (domain)
 * @property port the specified port or protocol default port
 * @property specifiedPort port number that was specified to override protocol's default
 * @property encodedPath encoded path without query string
 * @property parameters URL query parameters
 * @property fragment URL fragment (anchor name)
 * @property user username part of URL
 * @property password password part of URL
 * @property trailingQuery keep trailing question character even if there are no query parameters
 *
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=io/ktor/http/UrlSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpUrl")))
@interface THHKtor_httpUrl : THHBase <THHKtor_ioJvmSerializable>
@property (class, readonly, getter=companion) THHKtor_httpUrlCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *encodedFragment __attribute__((swift_name("encodedFragment")));
@property (readonly) NSString * _Nullable encodedPassword __attribute__((swift_name("encodedPassword")));
@property (readonly) NSString *encodedPath __attribute__((swift_name("encodedPath")));
@property (readonly) NSString *encodedPathAndQuery __attribute__((swift_name("encodedPathAndQuery")));
@property (readonly) NSString *encodedQuery __attribute__((swift_name("encodedQuery")));
@property (readonly) NSString * _Nullable encodedUser __attribute__((swift_name("encodedUser")));
@property (readonly) NSString *fragment __attribute__((swift_name("fragment")));
@property (readonly) NSString *host __attribute__((swift_name("host")));
@property (readonly) id<THHKtor_httpParameters> parameters __attribute__((swift_name("parameters")));
@property (readonly) NSString * _Nullable password __attribute__((swift_name("password")));

/**
 * A list containing the segments of the URL path.
 *
 * This property was designed to distinguish between absolute and relative paths,
 * so it will have an empty segment at the beginning for URLs with a hostname
 * and an empty segment at the end for URLs with a trailing slash.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.pathSegments == listOf("", "docs", "")
 *
 * val absolute = Url("/docs/")
 * absolute.pathSegments == listOf("", "docs", "")
 *
 * val relative = Url("docs")
 * relative.pathSegments == listOf("docs")
 * ```
 *
 * This behaviour may not be ideal if you're working only with full URLs.
 * If you don't require the specific handling of empty segments, consider using the [segments] property instead:
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 *
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * To address this issue, the current [pathSegments] property will be renamed to [rawSegments].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.pathSegments)
 */
@property (readonly) NSArray<NSString *> *pathSegments __attribute__((swift_name("pathSegments"))) __attribute__((deprecated("\n        `pathSegments` is deprecated.\n\n        This property will contain an empty path segment at the beginning for URLs with a hostname,\n        and an empty path segment at the end for the URLs with a trailing slash. If you need to keep this behaviour please\n        use [rawSegments]. If you only need to access the meaningful parts of the path, consider using [segments] instead.\n             \n        Please decide if you need [rawSegments] or [segments] explicitly.\n        ")));
@property (readonly) int32_t port __attribute__((swift_name("port")));
@property (readonly) THHKtor_httpURLProtocol *protocol __attribute__((swift_name("protocol")));
@property (readonly) THHKtor_httpURLProtocol * _Nullable protocolOrNull __attribute__((swift_name("protocolOrNull")));

/**
 * A list containing the segments of the URL path.
 *
 * This property is designed to distinguish between absolute and relative paths,
 * so it will have an empty segment at the beginning for URLs with a hostname
 * and an empty segment at the end for URLs with a trailing slash.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.rawSegments == listOf("", "docs", "")
 *
 * val absolute = Url("/docs/")
 * absolute.rawSegments == listOf("", "docs", "")
 *
 * val relative = Url("docs")
 * relative.rawSegments == listOf("docs")
 * ```
 *
 * This behaviour may not be ideal if you're working only with full URLs.
 * If you don't require the specific handling of empty segments, consider using the [segments] property instead:
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 *
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.rawSegments)
 */
@property (readonly) NSArray<NSString *> *rawSegments __attribute__((swift_name("rawSegments")));

/**
 * A list of path segments derived from the URL, excluding any leading
 * and trailing empty segments.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * If you need to check for trailing slash and relative/absolute paths, please check the [rawSegments] property.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.segments)
 **/
@property (readonly) NSArray<NSString *> *segments __attribute__((swift_name("segments")));
@property (readonly) int32_t specifiedPort __attribute__((swift_name("specifiedPort")));
@property (readonly) BOOL trailingQuery __attribute__((swift_name("trailingQuery")));
@property (readonly) NSString * _Nullable user __attribute__((swift_name("user")));
@end


/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpMethod")))
@interface THHKtor_httpHttpMethod : THHBase
- (instancetype)initWithValue:(NSString *)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_httpHttpMethodCompanion *companion __attribute__((swift_name("companion")));
- (THHKtor_httpHttpMethod *)doCopyValue:(NSString *)value __attribute__((swift_name("doCopy(value:)")));

/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Provides data structure for associating a [String] with a [List] of Strings
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues)
 */
__attribute__((swift_name("Ktor_utilsStringValues")))
@protocol THHKtor_utilsStringValues
@required

/**
 * Checks if the given [name] exists in the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.contains)
 */
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));

/**
 * Checks if the given [name] and [value] pair exists in the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.contains)
 */
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));

/**
 * Gets all entries from the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.entries)
 */
- (NSSet<id<THHKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));

/**
 * Iterates over all entries in this map and calls [body] for each pair
 *
 * Can be optimized in implementations
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.forEach)
 */
- (void)forEachBody:(void (^)(NSString *, NSArray<NSString *> *))body __attribute__((swift_name("forEach(body:)")));

/**
 * Gets first value from the list of values associated with a [name], or null if the name is not present
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.get)
 */
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));

/**
 * Gets all values associated with the [name], or null if the name is not present
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.getAll)
 */
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));

/**
 * Checks if this map is empty
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.isEmpty)
 */
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));

/**
 * Gets all names from the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.names)
 */
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));

/**
 * Specifies if map has case-sensitive or case-insensitive names
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.caseInsensitiveName)
 */
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));
@end


/**
 * Represents HTTP headers as a map from case-insensitive names to collection of [String] values
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Headers)
 */
__attribute__((swift_name("Ktor_httpHeaders")))
@protocol THHKtor_httpHeaders <THHKtor_utilsStringValues>
@required
@end


/**
 * Information about the content to be sent to the peer, recognized by a client or server engine
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent)
 */
__attribute__((swift_name("Ktor_httpOutgoingContent")))
@interface THHKtor_httpOutgoingContent : THHBase

/**
 * Gets an extension property for this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.getProperty)
 */
- (id _Nullable)getPropertyKey:(THHKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("getProperty(key:)")));

/**
 * Sets an extension property for this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.setProperty)
 */
- (void)setPropertyKey:(THHKtor_utilsAttributeKey<id> *)key value:(id _Nullable)value __attribute__((swift_name("setProperty(key:value:)")));

/**
 * Trailers to set when sending this content, will be ignored if request is not in HTTP2 mode
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.trailers)
 */
- (id<THHKtor_httpHeaders> _Nullable)trailers __attribute__((swift_name("trailers()")));

/**
 * Specifies content length in bytes for this resource.
 *
 * If null, the resources will be sent as `Transfer-Encoding: chunked`
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.contentLength)
 */
@property (readonly) THHLong * _Nullable contentLength __attribute__((swift_name("contentLength")));

/**
 * Specifies [ContentType] for this resource.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.contentType)
 */
@property (readonly) THHKtor_httpContentType * _Nullable contentType __attribute__((swift_name("contentType")));

/**
 * Headers to set when sending this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.headers)
 */
@property (readonly) id<THHKtor_httpHeaders> headers __attribute__((swift_name("headers")));

/**
 * Status code to set when sending this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.status)
 */
@property (readonly) THHKtor_httpHttpStatusCode * _Nullable status __attribute__((swift_name("status")));
@end


/**
 * Represents an HTTP status code and description.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode)
 *
 * @param value is a numeric code.
 * @param description is free form description of a status.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpStatusCode")))
@interface THHKtor_httpHttpStatusCode : THHBase <THHKotlinComparable>
- (instancetype)initWithValue:(int32_t)value description:(NSString *)description __attribute__((swift_name("init(value:description:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_httpHttpStatusCodeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(THHKtor_httpHttpStatusCode *)other __attribute__((swift_name("compareTo(other:)")));
- (THHKtor_httpHttpStatusCode *)doCopyValue:(int32_t)value description:(NSString *)description __attribute__((swift_name("doCopy(value:description:)")));

/**
 * Returns a copy of `this` code with a description changed to [value].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.description)
 */
- (THHKtor_httpHttpStatusCode *)descriptionValue:(NSString *)value __attribute__((swift_name("description(value:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) int32_t value __attribute__((swift_name("value")));
@end


/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsGMTDate")))
@interface THHKtor_utilsGMTDate : THHBase <THHKotlinComparable>
- (instancetype)initWithSeconds:(int32_t)seconds minutes:(int32_t)minutes hours:(int32_t)hours dayOfWeek:(THHKtor_utilsWeekDay *)dayOfWeek dayOfMonth:(int32_t)dayOfMonth dayOfYear:(int32_t)dayOfYear month:(THHKtor_utilsMonth *)month year:(int32_t)year timestamp:(int64_t)timestamp __attribute__((swift_name("init(seconds:minutes:hours:dayOfWeek:dayOfMonth:dayOfYear:month:year:timestamp:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_utilsGMTDateCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(THHKtor_utilsGMTDate *)other __attribute__((swift_name("compareTo(other:)")));
- (THHKtor_utilsGMTDate *)doCopy __attribute__((swift_name("doCopy()")));
- (THHKtor_utilsGMTDate *)doCopySeconds:(int32_t)seconds minutes:(int32_t)minutes hours:(int32_t)hours dayOfWeek:(THHKtor_utilsWeekDay *)dayOfWeek dayOfMonth:(int32_t)dayOfMonth dayOfYear:(int32_t)dayOfYear month:(THHKtor_utilsMonth *)month year:(int32_t)year timestamp:(int64_t)timestamp __attribute__((swift_name("doCopy(seconds:minutes:hours:dayOfWeek:dayOfMonth:dayOfYear:month:year:timestamp:)")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth")));
@property (readonly) THHKtor_utilsWeekDay *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) int32_t hours __attribute__((swift_name("hours")));
@property (readonly) int32_t minutes __attribute__((swift_name("minutes")));
@property (readonly) THHKtor_utilsMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t seconds __attribute__((swift_name("seconds")));
@property (readonly) int64_t timestamp __attribute__((swift_name("timestamp")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end


/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpProtocolVersion")))
@interface THHKtor_httpHttpProtocolVersion : THHBase
- (instancetype)initWithName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("init(name:major:minor:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_httpHttpProtocolVersionCompanion *companion __attribute__((swift_name("companion")));
- (THHKtor_httpHttpProtocolVersion *)doCopyName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("doCopy(name:major:minor:)")));

/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t major __attribute__((swift_name("major")));
@property (readonly) int32_t minor __attribute__((swift_name("minor")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinContinuation")))
@protocol THHKotlinContinuation
@required
- (void)resumeWithResult:(id _Nullable)result __attribute__((swift_name("resumeWith(result:)")));
@property (readonly) id<THHKotlinCoroutineContext> context __attribute__((swift_name("context")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
 *   kotlin.ExperimentalStdlibApi
*/
__attribute__((swift_name("KotlinAbstractCoroutineContextKey")))
@interface THHKotlinAbstractCoroutineContextKey<B, E> : THHBase <THHKotlinCoroutineContextKey>
- (instancetype)initWithBaseKey:(id<THHKotlinCoroutineContextKey>)baseKey safeCast:(E _Nullable (^)(id<THHKotlinCoroutineContextElement>))safeCast __attribute__((swift_name("init(baseKey:safeCast:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * @note annotations
 *   kotlin.ExperimentalStdlibApi
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineDispatcher.Key")))
@interface THHKotlinx_coroutines_coreCoroutineDispatcherKey : THHKotlinAbstractCoroutineContextKey<id<THHKotlinContinuationInterceptor>, THHKotlinx_coroutines_coreCoroutineDispatcher *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithBaseKey:(id<THHKotlinCoroutineContextKey>)baseKey safeCast:(id<THHKotlinCoroutineContextElement> _Nullable (^)(id<THHKotlinCoroutineContextElement>))safeCast __attribute__((swift_name("init(baseKey:safeCast:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)key __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_coroutines_coreCoroutineDispatcherKey *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreRunnable")))
@protocol THHKotlinx_coroutines_coreRunnable
@required
- (void)run __attribute__((swift_name("run()")));
@end

__attribute__((swift_name("Ktor_utilsStringValuesBuilder")))
@protocol THHKtor_utilsStringValuesBuilder
@required
- (void)appendName:(NSString *)name value:(NSString *)value __attribute__((swift_name("append(name:value:)")));
- (void)appendAllStringValues:(id<THHKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendAll(stringValues:)")));
- (void)appendAllName:(NSString *)name values:(id)values __attribute__((swift_name("appendAll(name:values:)")));
- (void)appendMissingStringValues:(id<THHKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendMissing(stringValues:)")));
- (void)appendMissingName:(NSString *)name values:(id)values __attribute__((swift_name("appendMissing(name:values:)")));
- (id<THHKtor_utilsStringValues>)build __attribute__((swift_name("build()")));
- (void)clear __attribute__((swift_name("clear()")));
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<THHKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
- (void)removeName:(NSString *)name __attribute__((swift_name("remove(name:)")));
- (BOOL)removeName:(NSString *)name value:(NSString *)value __attribute__((swift_name("remove(name:value:)")));
- (void)removeKeysWithNoEntries __attribute__((swift_name("removeKeysWithNoEntries()")));
- (void)setName:(NSString *)name value:(NSString *)value __attribute__((swift_name("set(name:value:)")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));
@end

__attribute__((swift_name("Ktor_utilsStringValuesBuilderImpl")))
@interface THHKtor_utilsStringValuesBuilderImpl : THHBase <THHKtor_utilsStringValuesBuilder>
- (instancetype)initWithCaseInsensitiveName:(BOOL)caseInsensitiveName size:(int32_t)size __attribute__((swift_name("init(caseInsensitiveName:size:)"))) __attribute__((objc_designated_initializer));
- (void)appendName:(NSString *)name value:(NSString *)value __attribute__((swift_name("append(name:value:)")));
- (void)appendAllStringValues:(id<THHKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendAll(stringValues:)")));
- (void)appendAllName:(NSString *)name values:(id)values __attribute__((swift_name("appendAll(name:values:)")));
- (void)appendMissingStringValues:(id<THHKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendMissing(stringValues:)")));
- (void)appendMissingName:(NSString *)name values:(id)values __attribute__((swift_name("appendMissing(name:values:)")));
- (id<THHKtor_utilsStringValues>)build __attribute__((swift_name("build()")));
- (void)clear __attribute__((swift_name("clear()")));
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<THHKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
- (void)removeName:(NSString *)name __attribute__((swift_name("remove(name:)")));
- (BOOL)removeName:(NSString *)name value:(NSString *)value __attribute__((swift_name("remove(name:value:)")));
- (void)removeKeysWithNoEntries __attribute__((swift_name("removeKeysWithNoEntries()")));
- (void)setName:(NSString *)name value:(NSString *)value __attribute__((swift_name("set(name:value:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateNameName:(NSString *)name __attribute__((swift_name("validateName(name:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateValueValue:(NSString *)value __attribute__((swift_name("validateValue(value:)")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) THHMutableDictionary<NSString *, NSMutableArray<NSString *> *> *values __attribute__((swift_name("values")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeadersBuilder")))
@interface THHKtor_httpHeadersBuilder : THHKtor_utilsStringValuesBuilderImpl
- (instancetype)initWithSize:(int32_t)size __attribute__((swift_name("init(size:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCaseInsensitiveName:(BOOL)caseInsensitiveName size:(int32_t)size __attribute__((swift_name("init(caseInsensitiveName:size:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (id<THHKtor_httpHeaders>)build __attribute__((swift_name("build()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateNameName:(NSString *)name __attribute__((swift_name("validateName(name:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateValueValue:(NSString *)value __attribute__((swift_name("validateValue(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestBuilder.Companion")))
@interface THHKtor_client_coreHttpRequestBuilderCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_client_coreHttpRequestBuilderCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * A URL builder with all mutable components
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder)
 *
 * @property protocol URL protocol (scheme)
 * @property host name without port (domain)
 * @property port port number
 * @property user username part (optional)
 * @property password password part (optional)
 * @property pathSegments URL path without query
 * @property parameters URL query parameters
 * @property fragment URL fragment (anchor name)
 * @property trailingQuery keep a trailing question character even if there are no query parameters
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLBuilder")))
@interface THHKtor_httpURLBuilder : THHBase
- (instancetype)initWithProtocol:(THHKtor_httpURLProtocol * _Nullable)protocol host:(NSString *)host port:(int32_t)port user:(NSString * _Nullable)user password:(NSString * _Nullable)password pathSegments:(NSArray<NSString *> *)pathSegments parameters:(id<THHKtor_httpParameters>)parameters fragment:(NSString *)fragment trailingQuery:(BOOL)trailingQuery __attribute__((swift_name("init(protocol:host:port:user:password:pathSegments:parameters:fragment:trailingQuery:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_httpURLBuilderCompanion *companion __attribute__((swift_name("companion")));

/**
 * Build a [Url] instance (everything is copied to a new instance)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder.build)
 */
- (THHKtor_httpUrl *)build __attribute__((swift_name("build()")));

/**
 * Build a URL string
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder.buildString)
 */
- (NSString *)buildString __attribute__((swift_name("buildString()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property NSString *encodedFragment __attribute__((swift_name("encodedFragment")));
@property id<THHKtor_httpParametersBuilder> encodedParameters __attribute__((swift_name("encodedParameters")));
@property NSString * _Nullable encodedPassword __attribute__((swift_name("encodedPassword")));
@property NSArray<NSString *> *encodedPathSegments __attribute__((swift_name("encodedPathSegments")));
@property NSString * _Nullable encodedUser __attribute__((swift_name("encodedUser")));
@property NSString *fragment __attribute__((swift_name("fragment")));
@property NSString *host __attribute__((swift_name("host")));
@property (readonly) id<THHKtor_httpParametersBuilder> parameters __attribute__((swift_name("parameters")));
@property NSString * _Nullable password __attribute__((swift_name("password")));
@property NSArray<NSString *> *pathSegments __attribute__((swift_name("pathSegments")));
@property int32_t port __attribute__((swift_name("port")));
@property THHKtor_httpURLProtocol *protocol __attribute__((swift_name("protocol")));
@property THHKtor_httpURLProtocol * _Nullable protocolOrNull __attribute__((swift_name("protocolOrNull")));
@property BOOL trailingQuery __attribute__((swift_name("trailingQuery")));
@property NSString * _Nullable user __attribute__((swift_name("user")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClientCall.Companion")))
@interface THHKtor_client_coreHttpClientCallCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_client_coreHttpClientCallCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * A request for [HttpClient], first part of [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest)
 */
__attribute__((swift_name("Ktor_client_coreHttpRequest")))
@protocol THHKtor_client_coreHttpRequest <THHKtor_httpHttpMessage, THHKotlinx_coroutines_coreCoroutineScope>
@required

/**
 * Typed [Attributes] associated to this call serving as a lightweight container.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.attributes)
 */
@property (readonly) id<THHKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * The associated [HttpClientCall] containing both
 * the underlying [HttpClientCall.request] and [HttpClientCall.response].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.call)
 */
@property (readonly) THHKtor_client_coreHttpClientCall *call __attribute__((swift_name("call")));

/**
 * An [OutgoingContent] representing the request body
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.content)
 */
@property (readonly) THHKtor_httpOutgoingContent *content __attribute__((swift_name("content")));

/**
 * The [HttpMethod] or HTTP VERB used for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.method)
 */
@property (readonly) THHKtor_httpHttpMethod *method __attribute__((swift_name("method")));

/**
 * The [Url] representing the endpoint and the uri for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.url)
 */
@property (readonly) THHKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * A parsed `Sec-WebSocket-Accept` header item representation.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionHeader)
 *
 * @param name is extension name.
 * @param parameters is list of extension parameters.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionHeader")))
@interface THHKtor_websocketsWebSocketExtensionHeader : THHBase
- (instancetype)initWithName:(NSString *)name parameters:(NSArray<NSString *> *)parameters __attribute__((swift_name("init(name:parameters:)"))) __attribute__((objc_designated_initializer));

/**
 * Parses parameters keys and values.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionHeader.parseParameters)
 */
- (id<THHKotlinSequence>)parseParameters __attribute__((swift_name("parseParameters()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) NSArray<NSString *> *parameters __attribute__((swift_name("parameters")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioCharset.Companion")))
@interface THHKtor_ioCharsetCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_ioCharsetCompanion *shared __attribute__((swift_name("shared")));
- (THHKtor_ioCharset *)forNameName:(NSString *)name __attribute__((swift_name("forName(name:)")));
- (BOOL)isSupportedCharset:(NSString *)charset __attribute__((swift_name("isSupported(charset:)")));
@end

__attribute__((swift_name("Ktor_ioCharsetDecoder")))
@interface THHKtor_ioCharsetDecoder : THHBase
- (instancetype)initWith_charset:(THHKtor_ioCharset *)_charset __attribute__((swift_name("init(_charset:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("Ktor_ioCharsetEncoder")))
@interface THHKtor_ioCharsetEncoder : THHBase
- (instancetype)initWith_charset:(THHKtor_ioCharset *)_charset __attribute__((swift_name("init(_charset:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinKType")))
@protocol THHKotlinKType
@required

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
@property (readonly) NSArray<THHKotlinKTypeProjection *> *arguments __attribute__((swift_name("arguments")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
@property (readonly) id<THHKotlinKClassifier> _Nullable classifier __attribute__((swift_name("classifier")));
@property (readonly) BOOL isMarkedNullable __attribute__((swift_name("isMarkedNullable")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrame.Companion")))
@interface THHKtor_websocketsFrameCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_websocketsFrameCompanion *shared __attribute__((swift_name("shared")));

/**
 * Create a particular [Frame] instance by frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame.Companion.byType)
 */
- (THHKtor_websocketsFrame *)byTypeFin:(BOOL)fin frameType:(THHKtor_websocketsFrameType *)frameType data:(THHKotlinByteArray *)data rsv1:(BOOL)rsv1 rsv2:(BOOL)rsv2 rsv3:(BOOL)rsv3 __attribute__((swift_name("byType(fin:frameType:data:rsv1:rsv2:rsv3:)")));
@end


/**
 * A WebSocket frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType)
 *
 * @property controlFrame if this is control frame type
 * @property opcode - frame type id that is used to transport it
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrameType")))
@interface THHKtor_websocketsFrameType : THHKotlinEnum<THHKtor_websocketsFrameType *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * A WebSocket frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType)
 *
 * @property controlFrame if this is control frame type
 * @property opcode - frame type id that is used to transport it
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKtor_websocketsFrameTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHKtor_websocketsFrameType *text __attribute__((swift_name("text")));
@property (class, readonly) THHKtor_websocketsFrameType *binary __attribute__((swift_name("binary")));
@property (class, readonly) THHKtor_websocketsFrameType *close __attribute__((swift_name("close")));
@property (class, readonly) THHKtor_websocketsFrameType *ping __attribute__((swift_name("ping")));
@property (class, readonly) THHKtor_websocketsFrameType *pong __attribute__((swift_name("pong")));
+ (THHKotlinArray<THHKtor_websocketsFrameType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKtor_websocketsFrameType *> *entries __attribute__((swift_name("entries")));
@property (readonly) BOOL controlFrame __attribute__((swift_name("controlFrame")));
@property (readonly) int32_t opcode __attribute__((swift_name("opcode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeekNames.Companion")))
@interface THHKotlinx_datetimeDayOfWeekNamesCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeDayOfWeekNamesCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) THHKotlinx_datetimeDayOfWeekNames *ENGLISH_ABBREVIATED __attribute__((swift_name("ENGLISH_ABBREVIATED")));
@property (readonly) THHKotlinx_datetimeDayOfWeekNames *ENGLISH_FULL __attribute__((swift_name("ENGLISH_FULL")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonthNames.Companion")))
@interface THHKotlinx_datetimeMonthNamesCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeMonthNamesCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) THHKotlinx_datetimeMonthNames *ENGLISH_ABBREVIATED __attribute__((swift_name("ENGLISH_ABBREVIATED")));
@property (readonly) THHKotlinx_datetimeMonthNames *ENGLISH_FULL __attribute__((swift_name("ENGLISH_FULL")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeUtcOffset.Companion")))
@interface THHKotlinx_datetimeUtcOffsetCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinx_datetimeUtcOffsetCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_datetimeDateTimeFormat>)FormatBlock:(void (^)(id<THHKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset>))block __attribute__((swift_name("Format(block:)")));
- (THHKotlinx_datetimeUtcOffset *)parseInput:(id)input format:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) THHKotlinx_datetimeUtcOffset *ZERO __attribute__((swift_name("ZERO")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpUrl.Companion")))
@interface THHKtor_httpUrlCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_httpUrlCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Represents HTTP parameters as a map from case-insensitive names to collection of [String] values
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Parameters)
 */
__attribute__((swift_name("Ktor_httpParameters")))
@protocol THHKtor_httpParameters <THHKtor_utilsStringValues>
@required
@end


/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLProtocol")))
@interface THHKtor_httpURLProtocol : THHBase <THHKtor_ioJvmSerializable>
- (instancetype)initWithName:(NSString *)name defaultPort:(int32_t)defaultPort __attribute__((swift_name("init(name:defaultPort:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_httpURLProtocolCompanion *companion __attribute__((swift_name("companion")));
- (THHKtor_httpURLProtocol *)doCopyName:(NSString *)name defaultPort:(int32_t)defaultPort __attribute__((swift_name("doCopy(name:defaultPort:)")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t defaultPort __attribute__((swift_name("defaultPort")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpMethod.Companion")))
@interface THHKtor_httpHttpMethodCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_httpHttpMethodCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parse HTTP method by [method] string
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod.Companion.parse)
 */
- (THHKtor_httpHttpMethod *)parseMethod:(NSString *)method __attribute__((swift_name("parse(method:)")));

/**
 * A list of default HTTP methods
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod.Companion.DefaultMethods)
 */
@property (readonly) NSArray<THHKtor_httpHttpMethod *> *DefaultMethods __attribute__((swift_name("DefaultMethods")));
@property (readonly) THHKtor_httpHttpMethod *Delete __attribute__((swift_name("Delete")));
@property (readonly) THHKtor_httpHttpMethod *Get __attribute__((swift_name("Get")));
@property (readonly) THHKtor_httpHttpMethod *Head __attribute__((swift_name("Head")));
@property (readonly) THHKtor_httpHttpMethod *Options __attribute__((swift_name("Options")));
@property (readonly) THHKtor_httpHttpMethod *Patch __attribute__((swift_name("Patch")));
@property (readonly) THHKtor_httpHttpMethod *Post __attribute__((swift_name("Post")));
@property (readonly) THHKtor_httpHttpMethod *Put __attribute__((swift_name("Put")));
@end

__attribute__((swift_name("KotlinMapEntry")))
@protocol THHKotlinMapEntry
@required
@property (readonly) id _Nullable key __attribute__((swift_name("key")));
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Represents a header value that consist of [content] followed by [parameters].
 * Useful for headers such as `Content-Type`, `Content-Disposition` and so on.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters)
 *
 * @property content header's content without parameters
 * @property parameters
 */
__attribute__((swift_name("Ktor_httpHeaderValueWithParameters")))
@interface THHKtor_httpHeaderValueWithParameters : THHBase
- (instancetype)initWithContent:(NSString *)content parameters:(NSArray<THHKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(content:parameters:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKtor_httpHeaderValueWithParametersCompanion *companion __attribute__((swift_name("companion")));

/**
 * The first value for the parameter with [name] comparing case-insensitively or `null` if no such parameters found
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters.parameter)
 */
- (NSString * _Nullable)parameterName:(NSString *)name __attribute__((swift_name("parameter(name:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) NSString *content __attribute__((swift_name("content")));
@property (readonly) NSArray<THHKtor_httpHeaderValueParam *> *parameters __attribute__((swift_name("parameters")));
@end


/**
 * Represents a value for a `Content-Type` header.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType)
 *
 * @property contentType represents a type part of the media type.
 * @property contentSubtype represents a subtype part of the media type.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpContentType")))
@interface THHKtor_httpContentType : THHKtor_httpHeaderValueWithParameters
- (instancetype)initWithContentType:(NSString *)contentType contentSubtype:(NSString *)contentSubtype parameters:(NSArray<THHKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(contentType:contentSubtype:parameters:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithContent:(NSString *)content parameters:(NSArray<THHKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(content:parameters:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKtor_httpContentTypeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Checks if `this` type matches a [pattern] type taking into account placeholder symbols `*` and parameters.
 * The `this` type must be a more specific type than the [pattern] type. In other words:
 *
 * ```kotlin
 * ContentType("a", "b").match(ContentType("a", "b").withParameter("foo", "bar")) === false
 * ContentType("a", "b").withParameter("foo", "bar").match(ContentType("a", "b")) === true
 * ContentType("a", "*").match(ContentType("a", "b")) === false
 * ContentType("a", "b").match(ContentType("a", "*")) === true
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.match)
 */
- (BOOL)matchPattern:(THHKtor_httpContentType *)pattern __attribute__((swift_name("match(pattern:)")));

/**
 * Checks if `this` type matches a [pattern] type taking into account placeholder symbols `*` and parameters.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.match)
 */
- (BOOL)matchPattern_:(NSString *)pattern __attribute__((swift_name("match(pattern_:)")));

/**
 * Creates a copy of `this` type with the added parameter with the [name] and [value].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.withParameter)
 */
- (THHKtor_httpContentType *)withParameterName:(NSString *)name value:(NSString *)value __attribute__((swift_name("withParameter(name:value:)")));

/**
 * Creates a copy of `this` type without any parameters
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.withoutParameters)
 */
- (THHKtor_httpContentType *)withoutParameters __attribute__((swift_name("withoutParameters()")));
@property (readonly) NSString *contentSubtype __attribute__((swift_name("contentSubtype")));
@property (readonly) NSString *contentType __attribute__((swift_name("contentType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpStatusCode.Companion")))
@interface THHKtor_httpHttpStatusCodeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_httpHttpStatusCodeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Creates an instance of [HttpStatusCode] with the given numeric value.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.Companion.fromValue)
 */
- (THHKtor_httpHttpStatusCode *)fromValueValue:(int32_t)value __attribute__((swift_name("fromValue(value:)")));
@property (readonly) THHKtor_httpHttpStatusCode *Accepted __attribute__((swift_name("Accepted")));
@property (readonly) THHKtor_httpHttpStatusCode *BadGateway __attribute__((swift_name("BadGateway")));
@property (readonly) THHKtor_httpHttpStatusCode *BadRequest __attribute__((swift_name("BadRequest")));
@property (readonly) THHKtor_httpHttpStatusCode *Conflict __attribute__((swift_name("Conflict")));
@property (readonly) THHKtor_httpHttpStatusCode *Continue __attribute__((swift_name("Continue")));
@property (readonly) THHKtor_httpHttpStatusCode *Created __attribute__((swift_name("Created")));
@property (readonly) THHKtor_httpHttpStatusCode *ExpectationFailed __attribute__((swift_name("ExpectationFailed")));
@property (readonly) THHKtor_httpHttpStatusCode *FailedDependency __attribute__((swift_name("FailedDependency")));
@property (readonly) THHKtor_httpHttpStatusCode *Forbidden __attribute__((swift_name("Forbidden")));
@property (readonly) THHKtor_httpHttpStatusCode *Found __attribute__((swift_name("Found")));
@property (readonly) THHKtor_httpHttpStatusCode *GatewayTimeout __attribute__((swift_name("GatewayTimeout")));
@property (readonly) THHKtor_httpHttpStatusCode *Gone __attribute__((swift_name("Gone")));
@property (readonly) THHKtor_httpHttpStatusCode *InsufficientStorage __attribute__((swift_name("InsufficientStorage")));
@property (readonly) THHKtor_httpHttpStatusCode *InternalServerError __attribute__((swift_name("InternalServerError")));
@property (readonly) THHKtor_httpHttpStatusCode *LengthRequired __attribute__((swift_name("LengthRequired")));
@property (readonly) THHKtor_httpHttpStatusCode *Locked __attribute__((swift_name("Locked")));
@property (readonly) THHKtor_httpHttpStatusCode *MethodNotAllowed __attribute__((swift_name("MethodNotAllowed")));
@property (readonly) THHKtor_httpHttpStatusCode *MovedPermanently __attribute__((swift_name("MovedPermanently")));
@property (readonly) THHKtor_httpHttpStatusCode *MultiStatus __attribute__((swift_name("MultiStatus")));
@property (readonly) THHKtor_httpHttpStatusCode *MultipleChoices __attribute__((swift_name("MultipleChoices")));
@property (readonly) THHKtor_httpHttpStatusCode *NoContent __attribute__((swift_name("NoContent")));
@property (readonly) THHKtor_httpHttpStatusCode *NonAuthoritativeInformation __attribute__((swift_name("NonAuthoritativeInformation")));
@property (readonly) THHKtor_httpHttpStatusCode *NotAcceptable __attribute__((swift_name("NotAcceptable")));
@property (readonly) THHKtor_httpHttpStatusCode *NotFound __attribute__((swift_name("NotFound")));
@property (readonly) THHKtor_httpHttpStatusCode *NotImplemented __attribute__((swift_name("NotImplemented")));
@property (readonly) THHKtor_httpHttpStatusCode *NotModified __attribute__((swift_name("NotModified")));
@property (readonly) THHKtor_httpHttpStatusCode *OK __attribute__((swift_name("OK")));
@property (readonly) THHKtor_httpHttpStatusCode *PartialContent __attribute__((swift_name("PartialContent")));
@property (readonly) THHKtor_httpHttpStatusCode *PayloadTooLarge __attribute__((swift_name("PayloadTooLarge")));
@property (readonly) THHKtor_httpHttpStatusCode *PaymentRequired __attribute__((swift_name("PaymentRequired")));
@property (readonly) THHKtor_httpHttpStatusCode *PermanentRedirect __attribute__((swift_name("PermanentRedirect")));
@property (readonly) THHKtor_httpHttpStatusCode *PreconditionFailed __attribute__((swift_name("PreconditionFailed")));
@property (readonly) THHKtor_httpHttpStatusCode *Processing __attribute__((swift_name("Processing")));
@property (readonly) THHKtor_httpHttpStatusCode *ProxyAuthenticationRequired __attribute__((swift_name("ProxyAuthenticationRequired")));
@property (readonly) THHKtor_httpHttpStatusCode *RequestHeaderFieldTooLarge __attribute__((swift_name("RequestHeaderFieldTooLarge")));
@property (readonly) THHKtor_httpHttpStatusCode *RequestTimeout __attribute__((swift_name("RequestTimeout")));
@property (readonly) THHKtor_httpHttpStatusCode *RequestURITooLong __attribute__((swift_name("RequestURITooLong")));
@property (readonly) THHKtor_httpHttpStatusCode *RequestedRangeNotSatisfiable __attribute__((swift_name("RequestedRangeNotSatisfiable")));
@property (readonly) THHKtor_httpHttpStatusCode *ResetContent __attribute__((swift_name("ResetContent")));
@property (readonly) THHKtor_httpHttpStatusCode *SeeOther __attribute__((swift_name("SeeOther")));
@property (readonly) THHKtor_httpHttpStatusCode *ServiceUnavailable __attribute__((swift_name("ServiceUnavailable")));
@property (readonly) THHKtor_httpHttpStatusCode *SwitchProxy __attribute__((swift_name("SwitchProxy")));
@property (readonly) THHKtor_httpHttpStatusCode *SwitchingProtocols __attribute__((swift_name("SwitchingProtocols")));
@property (readonly) THHKtor_httpHttpStatusCode *TemporaryRedirect __attribute__((swift_name("TemporaryRedirect")));
@property (readonly) THHKtor_httpHttpStatusCode *TooEarly __attribute__((swift_name("TooEarly")));
@property (readonly) THHKtor_httpHttpStatusCode *TooManyRequests __attribute__((swift_name("TooManyRequests")));
@property (readonly) THHKtor_httpHttpStatusCode *Unauthorized __attribute__((swift_name("Unauthorized")));
@property (readonly) THHKtor_httpHttpStatusCode *UnprocessableEntity __attribute__((swift_name("UnprocessableEntity")));
@property (readonly) THHKtor_httpHttpStatusCode *UnsupportedMediaType __attribute__((swift_name("UnsupportedMediaType")));
@property (readonly) THHKtor_httpHttpStatusCode *UpgradeRequired __attribute__((swift_name("UpgradeRequired")));
@property (readonly) THHKtor_httpHttpStatusCode *UseProxy __attribute__((swift_name("UseProxy")));
@property (readonly) THHKtor_httpHttpStatusCode *VariantAlsoNegotiates __attribute__((swift_name("VariantAlsoNegotiates")));
@property (readonly) THHKtor_httpHttpStatusCode *VersionNotSupported __attribute__((swift_name("VersionNotSupported")));

/**
 * All known status codes
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.Companion.allStatusCodes)
 */
@property (readonly) NSArray<THHKtor_httpHttpStatusCode *> *allStatusCodes __attribute__((swift_name("allStatusCodes")));
@end


/**
 * Day of week
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsWeekDay")))
@interface THHKtor_utilsWeekDay : THHKotlinEnum<THHKtor_utilsWeekDay *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Day of week
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKtor_utilsWeekDayCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHKtor_utilsWeekDay *monday __attribute__((swift_name("monday")));
@property (class, readonly) THHKtor_utilsWeekDay *tuesday __attribute__((swift_name("tuesday")));
@property (class, readonly) THHKtor_utilsWeekDay *wednesday __attribute__((swift_name("wednesday")));
@property (class, readonly) THHKtor_utilsWeekDay *thursday __attribute__((swift_name("thursday")));
@property (class, readonly) THHKtor_utilsWeekDay *friday __attribute__((swift_name("friday")));
@property (class, readonly) THHKtor_utilsWeekDay *saturday __attribute__((swift_name("saturday")));
@property (class, readonly) THHKtor_utilsWeekDay *sunday __attribute__((swift_name("sunday")));
+ (THHKotlinArray<THHKtor_utilsWeekDay *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKtor_utilsWeekDay *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Month
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsMonth")))
@interface THHKtor_utilsMonth : THHKotlinEnum<THHKtor_utilsMonth *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Month
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) THHKtor_utilsMonthCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) THHKtor_utilsMonth *january __attribute__((swift_name("january")));
@property (class, readonly) THHKtor_utilsMonth *february __attribute__((swift_name("february")));
@property (class, readonly) THHKtor_utilsMonth *march __attribute__((swift_name("march")));
@property (class, readonly) THHKtor_utilsMonth *april __attribute__((swift_name("april")));
@property (class, readonly) THHKtor_utilsMonth *may __attribute__((swift_name("may")));
@property (class, readonly) THHKtor_utilsMonth *june __attribute__((swift_name("june")));
@property (class, readonly) THHKtor_utilsMonth *july __attribute__((swift_name("july")));
@property (class, readonly) THHKtor_utilsMonth *august __attribute__((swift_name("august")));
@property (class, readonly) THHKtor_utilsMonth *september __attribute__((swift_name("september")));
@property (class, readonly) THHKtor_utilsMonth *october __attribute__((swift_name("october")));
@property (class, readonly) THHKtor_utilsMonth *november __attribute__((swift_name("november")));
@property (class, readonly) THHKtor_utilsMonth *december __attribute__((swift_name("december")));
+ (THHKotlinArray<THHKtor_utilsMonth *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKtor_utilsMonth *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsGMTDate.Companion")))
@interface THHKtor_utilsGMTDateCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_utilsGMTDateCompanion *shared __attribute__((swift_name("shared")));
- (id<THHKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * An instance of [GMTDate] corresponding to the epoch beginning
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate.Companion.START)
 */
@property (readonly) THHKtor_utilsGMTDate *START __attribute__((swift_name("START")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpProtocolVersion.Companion")))
@interface THHKtor_httpHttpProtocolVersionCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_httpHttpProtocolVersionCompanion *shared __attribute__((swift_name("shared")));

/**
 * Creates an instance of [HttpProtocolVersion] from the given parameters.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.fromValue)
 */
- (THHKtor_httpHttpProtocolVersion *)fromValueName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("fromValue(name:major:minor:)")));

/**
 * Create an instance of [HttpProtocolVersion] from http string representation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.parse)
 */
- (THHKtor_httpHttpProtocolVersion *)parseValue:(id)value __attribute__((swift_name("parse(value:)")));

/**
 * HTTP/1.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_1_0)
 */
@property (readonly) THHKtor_httpHttpProtocolVersion *HTTP_1_0 __attribute__((swift_name("HTTP_1_0")));

/**
 * HTTP/1.1 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_1_1)
 */
@property (readonly) THHKtor_httpHttpProtocolVersion *HTTP_1_1 __attribute__((swift_name("HTTP_1_1")));

/**
 * HTTP/2.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_2_0)
 */
@property (readonly) THHKtor_httpHttpProtocolVersion *HTTP_2_0 __attribute__((swift_name("HTTP_2_0")));

/**
 * HTTP/3.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_3_0)
 */
@property (readonly) THHKtor_httpHttpProtocolVersion *HTTP_3_0 __attribute__((swift_name("HTTP_3_0")));

/**
 * QUIC/1.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.QUIC)
 */
@property (readonly) THHKtor_httpHttpProtocolVersion *QUIC __attribute__((swift_name("QUIC")));

/**
 * SPDY/3.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.SPDY_3)
 */
@property (readonly) THHKtor_httpHttpProtocolVersion *SPDY_3 __attribute__((swift_name("SPDY_3")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLBuilder.Companion")))
@interface THHKtor_httpURLBuilderCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_httpURLBuilderCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Ktor_httpParametersBuilder")))
@protocol THHKtor_httpParametersBuilder <THHKtor_utilsStringValuesBuilder>
@required
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKTypeProjection")))
@interface THHKotlinKTypeProjection : THHBase
- (instancetype)initWithVariance:(THHKotlinKVariance * _Nullable)variance type:(id<THHKotlinKType> _Nullable)type __attribute__((swift_name("init(variance:type:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) THHKotlinKTypeProjectionCompanion *companion __attribute__((swift_name("companion")));
- (THHKotlinKTypeProjection *)doCopyVariance:(THHKotlinKVariance * _Nullable)variance type:(id<THHKotlinKType> _Nullable)type __attribute__((swift_name("doCopy(variance:type:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<THHKotlinKType> _Nullable type __attribute__((swift_name("type")));
@property (readonly) THHKotlinKVariance * _Nullable variance __attribute__((swift_name("variance")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrameType.Companion")))
@interface THHKtor_websocketsFrameTypeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_websocketsFrameTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Finds [FrameType] instance by numeric [opcode].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType.Companion.get)
 *
 * @return a [FrameType] instance or `null` of the [opcode] value is not valid
 */
- (THHKtor_websocketsFrameType * _Nullable)getOpcode:(int32_t)opcode __attribute__((swift_name("get(opcode:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithUtcOffset")))
@protocol THHKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset <THHKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)offsetFormat:(id<THHKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("offset(format:)")));
- (void)offsetHoursPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetHours(padding:)")));
- (void)offsetMinutesOfHourPadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetMinutesOfHour(padding:)")));
- (void)offsetSecondsOfMinutePadding:(THHKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetSecondsOfMinute(padding:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLProtocol.Companion")))
@interface THHKtor_httpURLProtocolCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_httpURLProtocolCompanion *shared __attribute__((swift_name("shared")));

/**
 * Create an instance by [name] or use already existing instance
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.createOrDefault)
 */
- (THHKtor_httpURLProtocol *)createOrDefaultName:(NSString *)name __attribute__((swift_name("createOrDefault(name:)")));

/**
 * HTTP with port 80
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.HTTP)
 */
@property (readonly) THHKtor_httpURLProtocol *HTTP __attribute__((swift_name("HTTP")));

/**
 * secure HTTPS with port 443
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.HTTPS)
 */
@property (readonly) THHKtor_httpURLProtocol *HTTPS __attribute__((swift_name("HTTPS")));

/**
 * Socks proxy url protocol.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.SOCKS)
 */
@property (readonly) THHKtor_httpURLProtocol *SOCKS __attribute__((swift_name("SOCKS")));

/**
 * Web socket over HTTP on port 80
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.WS)
 */
@property (readonly) THHKtor_httpURLProtocol *WS __attribute__((swift_name("WS")));

/**
 * Web socket over secure HTTPS on port 443
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.WSS)
 */
@property (readonly) THHKtor_httpURLProtocol *WSS __attribute__((swift_name("WSS")));

/**
 * Protocols by names map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.byName)
 */
@property (readonly) NSDictionary<NSString *, THHKtor_httpURLProtocol *> *byName __attribute__((swift_name("byName")));
@end


/**
 * Represents a single value parameter
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueParam)
 *
 * @property name of parameter
 * @property value of parameter
 * @property escapeValue specifies if the value should be escaped
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeaderValueParam")))
@interface THHKtor_httpHeaderValueParam : THHBase
- (instancetype)initWithName:(NSString *)name value:(NSString *)value __attribute__((swift_name("init(name:value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithName:(NSString *)name value:(NSString *)value escapeValue:(BOOL)escapeValue __attribute__((swift_name("init(name:value:escapeValue:)"))) __attribute__((objc_designated_initializer));
- (THHKtor_httpHeaderValueParam *)doCopyName:(NSString *)name value:(NSString *)value escapeValue:(BOOL)escapeValue __attribute__((swift_name("doCopy(name:value:escapeValue:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a single value parameter
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueParam)
 *
 * @property name of parameter
 * @property value of parameter
 * @property escapeValue specifies if the value should be escaped
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL escapeValue __attribute__((swift_name("escapeValue")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeaderValueWithParameters.Companion")))
@interface THHKtor_httpHeaderValueWithParametersCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_httpHeaderValueWithParametersCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parse header with parameter and pass it to [init] function to instantiate particular type
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters.Companion.parse)
 */
- (id _Nullable)parseValue:(NSString *)value init:(id _Nullable (^)(NSString *, NSArray<THHKtor_httpHeaderValueParam *> *))init __attribute__((swift_name("parse(value:init:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpContentType.Companion")))
@interface THHKtor_httpContentTypeCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_httpContentTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parses a string representing a `Content-Type` header into a [ContentType] instance.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.Companion.parse)
 */
- (THHKtor_httpContentType *)parseValue:(NSString *)value __attribute__((swift_name("parse(value:)")));

/**
 * Represents a pattern `* / *` to match any content type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.Companion.Any)
 */
@property (readonly) THHKtor_httpContentType *Any __attribute__((swift_name("Any")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsWeekDay.Companion")))
@interface THHKtor_utilsWeekDayCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_utilsWeekDayCompanion *shared __attribute__((swift_name("shared")));

/**
 * Lookup an instance by [ordinal]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay.Companion.from)
 */
- (THHKtor_utilsWeekDay *)fromOrdinal:(int32_t)ordinal __attribute__((swift_name("from(ordinal:)")));

/**
 * Lookup an instance by short week day name [WeekDay.value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay.Companion.from)
 */
- (THHKtor_utilsWeekDay *)fromValue:(NSString *)value __attribute__((swift_name("from(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsMonth.Companion")))
@interface THHKtor_utilsMonthCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKtor_utilsMonthCompanion *shared __attribute__((swift_name("shared")));

/**
 * Lookup an instance by [ordinal]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month.Companion.from)
 */
- (THHKtor_utilsMonth *)fromOrdinal:(int32_t)ordinal __attribute__((swift_name("from(ordinal:)")));

/**
 * Lookup an instance by short month name [Month.value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month.Companion.from)
 */
- (THHKtor_utilsMonth *)fromValue:(NSString *)value __attribute__((swift_name("from(value:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKVariance")))
@interface THHKotlinKVariance : THHKotlinEnum<THHKotlinKVariance *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) THHKotlinKVariance *invariant __attribute__((swift_name("invariant")));
@property (class, readonly) THHKotlinKVariance *in __attribute__((swift_name("in")));
@property (class, readonly) THHKotlinKVariance *out __attribute__((swift_name("out")));
+ (THHKotlinArray<THHKotlinKVariance *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<THHKotlinKVariance *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKTypeProjection.Companion")))
@interface THHKotlinKTypeProjectionCompanion : THHBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) THHKotlinKTypeProjectionCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (THHKotlinKTypeProjection *)contravariantType:(id<THHKotlinKType>)type __attribute__((swift_name("contravariant(type:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (THHKotlinKTypeProjection *)covariantType:(id<THHKotlinKType>)type __attribute__((swift_name("covariant(type:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (THHKotlinKTypeProjection *)invariantType:(id<THHKotlinKType>)type __attribute__((swift_name("invariant(type:)")));
@property (readonly) THHKotlinKTypeProjection *STAR __attribute__((swift_name("STAR")));
@end

#pragma pop_macro("_Nullable_result")
#pragma clang diagnostic pop
NS_ASSUME_NONNULL_END
