// swift-tools-version: 5.5
import PackageDescription

let package = Package(
    name: "TerminalH2H",
    platforms: [
        .iOS("15.0")
    ],
    products: [
        // We export the library under the name "TerminalH2H".
        // It points to the "TerminalH2HWrapper" target which includes the binary and Sentry.
        .library(
            name: "TerminalH2H",
            targets: ["TerminalH2HWrapper"]
        )
    ],
    dependencies: [
        .package(url: "https://github.com/getsentry/sentry-cocoa", from: "8.57.3")
    ],
    targets: [
        // 1. The actual binary framework.
        // We give it a unique name (TerminalH2HBinary) to avoid
        // namespace collisions with the wrapper target or the product name.
        .binaryTarget(
            name: "TerminalH2HBinary",
            path: "TerminalH2H.xcframework"
        ),

        // 2. The wrapper target.
        // This is the target that the consuming app actually "sees" and builds.
        .target(
            name: "TerminalH2HWrapper",
            dependencies: [
                .target(name: "TerminalH2HBinary"),
                .product(name: "Sentry", package: "sentry-cocoa")
            ],
            path: "Sources/TerminalH2HWrapper"
        )
    ]
)