#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSError.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSSet.h>
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>

@class TCCAction, TCCActionCompanion, TCCActionJob, TCCApiError, TCCApiErrorCompanion, TCCAppInformation, TCCAppModule, TCCBRIPaymentMethod, TCCBRIPaymentMethodCompanion, TCCBRITerminalAction, TCCBRITerminalActionCompanion, TCCBaseDatabaseHandler, TCCBaseFakeResponseGenerator, TCCBaseRequestCompanion, TCCBaseSecurity, TCCBaseTerminal, TCCBaseTerminalBRI, TCCBaseTerminalCashup, TCCBaseTerminalNTT, TCCBaseTerminalOperation, TCCBaseTerminalSHC, TCCBluetoothData<T>, TCCBriEDCWebSocketService, TCCBriStatus, TCCBriStatusCompanion, TCCCancel, TCCCancelCompanion, TCCCashupAction, TCCCashupPaymentMethod, TCCCashupPaymentMethodCompanion, TCCCashupTerminalResult, TCCCashupTerminalResultCompanion, TCCCheckVersionRequest, TCCCheckVersionRequestCompanion, TCCCommand, TCCCommandCompanion, TCCCommandConstants, TCCCommandType, TCCCommandTypeCompanion, TCCConnectionState, TCCConnectionType, TCCDatabaseCompanion, TCCDatabaseHandler, TCCDriverFactory, TCCEppDetails, TCCEppDetailsCompanion, TCCError, TCCErrorCode, TCCErrorCodeCompanion, TCCErrorCompanion, TCCErrorData, TCCErrorDataCompanion, TCCFakeResponseGenerator, TCCFakeResponseGenerator_, TCCFakeResponseGenerator__, TCCGenericPaymentMethod, TCCGenericPaymentMethodCompanion, TCCHistories, TCCHistoriesCompanion, TCCInternalNetworkService, TCCInternalNetworkServiceCompanion, TCCKermitLogger, TCCKermitLoggerCompanion, TCCKermit_coreBaseLogger, TCCKermit_coreLogWriter, TCCKermit_coreSeverity, TCCKermit_ioRollingFileLogWriter, TCCKermit_ioRollingFileLogWriterConfig, TCCKotlinAbstractCoroutineContextElement, TCCKotlinAbstractCoroutineContextKey<B, E>, TCCKotlinArray<T>, TCCKotlinByteArray, TCCKotlinByteIterator, TCCKotlinCancellationException, TCCKotlinEnum<E>, TCCKotlinEnumCompanion, TCCKotlinException, TCCKotlinIllegalStateException, TCCKotlinInstant, TCCKotlinInstantCompanion, TCCKotlinKTypeProjection, TCCKotlinKTypeProjectionCompanion, TCCKotlinKVariance, TCCKotlinNothing, TCCKotlinPair<__covariant A, __covariant B>, TCCKotlinRuntimeException, TCCKotlinThrowable, TCCKotlinUnit, TCCKotlinx_coroutines_coreCoroutineDispatcher, TCCKotlinx_coroutines_coreCoroutineDispatcherKey, TCCKotlinx_datetimeDayOfWeek, TCCKotlinx_datetimeDayOfWeekNames, TCCKotlinx_datetimeDayOfWeekNamesCompanion, TCCKotlinx_datetimeFixedOffsetTimeZone, TCCKotlinx_datetimeFixedOffsetTimeZoneCompanion, TCCKotlinx_datetimeLocalDate, TCCKotlinx_datetimeLocalDateCompanion, TCCKotlinx_datetimeLocalDateProgression, TCCKotlinx_datetimeLocalDateProgressionCompanion, TCCKotlinx_datetimeLocalDateRange, TCCKotlinx_datetimeLocalDateRangeCompanion, TCCKotlinx_datetimeLocalDateTime, TCCKotlinx_datetimeLocalDateTimeCompanion, TCCKotlinx_datetimeLocalTime, TCCKotlinx_datetimeLocalTimeCompanion, TCCKotlinx_datetimeMonth, TCCKotlinx_datetimeMonthNames, TCCKotlinx_datetimeMonthNamesCompanion, TCCKotlinx_datetimeOverloadMarker, TCCKotlinx_datetimePadding, TCCKotlinx_datetimeTimeZone, TCCKotlinx_datetimeTimeZoneCompanion, TCCKotlinx_datetimeUtcOffset, TCCKotlinx_datetimeUtcOffsetCompanion, TCCKotlinx_io_coreBuffer, TCCKotlinx_io_coreFileMetadata, TCCKotlinx_io_corePath, TCCKotlinx_serialization_coreSerialKind, TCCKotlinx_serialization_coreSerializersModule, TCCKotlinx_serialization_jsonClassDiscriminatorMode, TCCKotlinx_serialization_jsonJson, TCCKotlinx_serialization_jsonJsonConfiguration, TCCKotlinx_serialization_jsonJsonDefault, TCCKotlinx_serialization_jsonJsonElement, TCCKotlinx_serialization_jsonJsonElementCompanion, TCCKotlinx_serialization_jsonJsonPrimitive, TCCKotlinx_serialization_jsonJsonPrimitiveCompanion, TCCKtor_client_coreHttpClient, TCCKtor_client_coreHttpClientCall, TCCKtor_client_coreHttpClientCallCompanion, TCCKtor_client_coreHttpClientConfig<T>, TCCKtor_client_coreHttpClientEngineConfig, TCCKtor_client_coreHttpReceivePipeline, TCCKtor_client_coreHttpReceivePipelinePhases, TCCKtor_client_coreHttpRequestBuilder, TCCKtor_client_coreHttpRequestBuilderCompanion, TCCKtor_client_coreHttpRequestData, TCCKtor_client_coreHttpRequestPipeline, TCCKtor_client_coreHttpRequestPipelinePhases, TCCKtor_client_coreHttpResponse, TCCKtor_client_coreHttpResponseContainer, TCCKtor_client_coreHttpResponseData, TCCKtor_client_coreHttpResponsePipeline, TCCKtor_client_coreHttpResponsePipelinePhases, TCCKtor_client_coreHttpSendPipeline, TCCKtor_client_coreHttpSendPipelinePhases, TCCKtor_client_coreProxyConfig, TCCKtor_client_coreWebSocketsConfig, TCCKtor_eventsEventDefinition<T>, TCCKtor_eventsEvents, TCCKtor_httpContentType, TCCKtor_httpContentTypeCompanion, TCCKtor_httpHeaderValueParam, TCCKtor_httpHeaderValueWithParameters, TCCKtor_httpHeaderValueWithParametersCompanion, TCCKtor_httpHeadersBuilder, TCCKtor_httpHttpMethod, TCCKtor_httpHttpMethodCompanion, TCCKtor_httpHttpProtocolVersion, TCCKtor_httpHttpProtocolVersionCompanion, TCCKtor_httpHttpStatusCode, TCCKtor_httpHttpStatusCodeCompanion, TCCKtor_httpOutgoingContent, TCCKtor_httpURLBuilder, TCCKtor_httpURLBuilderCompanion, TCCKtor_httpURLProtocol, TCCKtor_httpURLProtocolCompanion, TCCKtor_httpUrl, TCCKtor_httpUrlCompanion, TCCKtor_ioByteChannel, TCCKtor_ioCharset, TCCKtor_ioCharsetCompanion, TCCKtor_ioCharsetDecoder, TCCKtor_ioCharsetEncoder, TCCKtor_ioReaderJob, TCCKtor_ioWriterJob, TCCKtor_networkSocketAddress, TCCKtor_utilsAttributeKey<T>, TCCKtor_utilsGMTDate, TCCKtor_utilsGMTDateCompanion, TCCKtor_utilsMonth, TCCKtor_utilsMonthCompanion, TCCKtor_utilsPipeline<TSubject, TContext>, TCCKtor_utilsPipelinePhase, TCCKtor_utilsStringValuesBuilderImpl, TCCKtor_utilsTypeInfo, TCCKtor_utilsWeekDay, TCCKtor_utilsWeekDayCompanion, TCCKtor_websocketsFrame, TCCKtor_websocketsFrameCompanion, TCCKtor_websocketsFrameType, TCCKtor_websocketsFrameTypeCompanion, TCCKtor_websocketsWebSocketExtensionHeader, TCCKtor_websocketsWebSocketExtensionsConfig, TCCLatestVersion, TCCLatestVersionCompanion, TCCLocalStorage, TCCLogLevel, TCCLogsRequest, TCCLogsRequestCompanion, TCCMultiTerminalOperation, TCCNTTAction, TCCNTTActionCompanion, TCCNTTPaymentMethod, TCCNTTPaymentMethodCompanion, TCCNTTTerminalAction, TCCNTTTerminalResult, TCCNTTTerminalResultCompanion, TCCNTTTransactionType, TCCNTTTransactionTypeCompanion, TCCNTTWebSocketService, TCCNetInterface, TCCPayPayload, TCCPayPayloadCompanion, TCCPayment, TCCPaymentCompanion, TCCPaymentMethodCompanion, TCCPaymentMethodSerializer, TCCPrintReceiptPayload, TCCPrintReceiptPayloadCompanion, TCCRawTransactionsRequest, TCCRawTransactionsRequestCompanion, TCCReceipt, TCCReceiptCompanion, TCCRefundPayload, TCCRefundPayloadCompanion, TCCResult<T>, TCCRuntimeAfterVersion, TCCRuntimeBaseTransacterImpl, TCCRuntimeExecutableQuery<__covariant RowType>, TCCRuntimeQuery<__covariant RowType>, TCCRuntimeTransacterImpl, TCCRuntimeTransacterTransaction, TCCSHCAction, TCCSHCActionCompanion, TCCSHCPaymentMethod, TCCSHCPaymentMethodCategory, TCCSHCPaymentMethodCategoryCompanion, TCCSHCPaymentMethodCompanion, TCCSHCTerminalAction, TCCSHCTerminalResult, TCCSHCTerminalResultCompanion, TCCSHCTransactionType, TCCSHCTransactionTypeCompanion, TCCService, TCCServiceCapabilities, TCCServicePaymentMethod, TCCServicePaymentMethodCompanion, TCCServiceQueries, TCCServiceType, TCCSettlement, TCCSettlementCompanion, TCCSettlementPayload, TCCSettlementPayloadCompanion, TCCSimulationRequest, TCCSimulationRequestCompanion, TCCSimulationResponse, TCCSimulationResponseCompanion, TCCStatus, TCCStatusCompanion, TCCTerminal, TCCTerminalApp, TCCTerminalBRI, TCCTerminalC2C, TCCTerminalCashup, TCCTerminalCommunicationService, TCCTerminalCore<T>, TCCTerminalDevice, TCCTerminalDeviceCompanion, TCCTerminalGHL, TCCTerminalMode, TCCTerminalNTT, TCCTerminalOperation, TCCTerminalProvider, TCCTerminalQueries, TCCTerminalResult, TCCTerminalResultCompanion, TCCTimeoutType, TCCTimeoutTypeCompanion, TCCTransactionFakeCode, TCCTransactionQueries, TCCTransactionResponse, TCCTransactionResponseCompanion, TCCTransactionType, TCCTransactionTypeCompanion, TCCTransactions, TCCTransactionsRequest<T>, TCCTransactionsRequestCompanion, TCCTransactionsRequestPayload, TCCTransactionsRequestPayloadCompanion, TCCVerifyRequest, TCCVerifyRequestCompanion, TCCVersionStatus, TCCVoidPayload, TCCVoidPayloadCompanion, TCCWebSocketService, TCCXLoggerCompanion;

@protocol TCCBaseProviderAppLauncher, TCCBluetoothService, TCCCommandPayload, TCCDatabase, TCCKermit_coreLoggerConfig, TCCKermit_coreMessageStringFormatter, TCCKermit_coreMutableLoggerConfig, TCCKotlinAnnotation, TCCKotlinAppendable, TCCKotlinAutoCloseable, TCCKotlinClock, TCCKotlinClosedRange, TCCKotlinCollection, TCCKotlinComparable, TCCKotlinContinuation, TCCKotlinContinuationInterceptor, TCCKotlinCoroutineContext, TCCKotlinCoroutineContextElement, TCCKotlinCoroutineContextKey, TCCKotlinFunction, TCCKotlinIterable, TCCKotlinIterator, TCCKotlinKAnnotatedElement, TCCKotlinKClass, TCCKotlinKClassifier, TCCKotlinKDeclarationContainer, TCCKotlinKType, TCCKotlinMapEntry, TCCKotlinOpenEndRange, TCCKotlinSequence, TCCKotlinSuspendFunction0, TCCKotlinSuspendFunction1, TCCKotlinSuspendFunction2, TCCKotlinx_coroutines_coreChildHandle, TCCKotlinx_coroutines_coreChildJob, TCCKotlinx_coroutines_coreCoroutineScope, TCCKotlinx_coroutines_coreDisposableHandle, TCCKotlinx_coroutines_coreFlow, TCCKotlinx_coroutines_coreFlowCollector, TCCKotlinx_coroutines_coreJob, TCCKotlinx_coroutines_coreMutableSharedFlow, TCCKotlinx_coroutines_coreMutableStateFlow, TCCKotlinx_coroutines_coreMutex, TCCKotlinx_coroutines_coreParentJob, TCCKotlinx_coroutines_coreRunnable, TCCKotlinx_coroutines_coreSelectClause, TCCKotlinx_coroutines_coreSelectClause0, TCCKotlinx_coroutines_coreSelectClause2, TCCKotlinx_coroutines_coreSelectInstance, TCCKotlinx_coroutines_coreSharedFlow, TCCKotlinx_coroutines_coreStateFlow, TCCKotlinx_datetimeDateTimeFormat, TCCKotlinx_datetimeDateTimeFormatBuilder, TCCKotlinx_datetimeDateTimeFormatBuilderWithDate, TCCKotlinx_datetimeDateTimeFormatBuilderWithDateTime, TCCKotlinx_datetimeDateTimeFormatBuilderWithTime, TCCKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset, TCCKotlinx_datetimeDateTimeFormatBuilderWithYearMonth, TCCKotlinx_io_coreFileSystem, TCCKotlinx_io_coreRawSink, TCCKotlinx_io_coreRawSource, TCCKotlinx_io_coreSink, TCCKotlinx_io_coreSource, TCCKotlinx_serialization_coreCompositeDecoder, TCCKotlinx_serialization_coreCompositeEncoder, TCCKotlinx_serialization_coreDecoder, TCCKotlinx_serialization_coreDeserializationStrategy, TCCKotlinx_serialization_coreEncoder, TCCKotlinx_serialization_coreKSerializer, TCCKotlinx_serialization_coreSerialDescriptor, TCCKotlinx_serialization_coreSerialFormat, TCCKotlinx_serialization_coreSerializationStrategy, TCCKotlinx_serialization_coreSerializersModuleCollector, TCCKotlinx_serialization_coreStringFormat, TCCKotlinx_serialization_jsonJsonNamingStrategy, TCCKtor_client_coreHttpClientEngine, TCCKtor_client_coreHttpClientEngineCapability, TCCKtor_client_coreHttpClientPlugin, TCCKtor_client_coreHttpRequest, TCCKtor_httpHeaders, TCCKtor_httpHttpMessage, TCCKtor_httpHttpMessageBuilder, TCCKtor_httpParameters, TCCKtor_httpParametersBuilder, TCCKtor_ioBufferedByteWriteChannel, TCCKtor_ioByteReadChannel, TCCKtor_ioByteWriteChannel, TCCKtor_ioChannelJob, TCCKtor_ioCloseable, TCCKtor_ioJvmSerializable, TCCKtor_networkABoundSocket, TCCKtor_networkAConnectedSocket, TCCKtor_networkAReadable, TCCKtor_networkASocket, TCCKtor_networkAWritable, TCCKtor_networkReadWriteSocket, TCCKtor_networkSocket, TCCKtor_serializationWebsocketContentConverter, TCCKtor_utilsAttributes, TCCKtor_utilsStringValues, TCCKtor_utilsStringValuesBuilder, TCCKtor_websocketsWebSocketExtension, TCCKtor_websocketsWebSocketExtensionFactory, TCCLoggingLogLevelController, TCCLoggingLogger, TCCLoggingLoggerApi, TCCPaymentMethod, TCCPlatform, TCCRequest, TCCRuntimeCloseable, TCCRuntimeQueryListener, TCCRuntimeQueryResult, TCCRuntimeSqlCursor, TCCRuntimeSqlDriver, TCCRuntimeSqlPreparedStatement, TCCRuntimeSqlSchema, TCCRuntimeTransacter, TCCRuntimeTransacterBase, TCCRuntimeTransactionCallbacks, TCCRuntimeTransactionWithReturn, TCCRuntimeTransactionWithoutReturn, TCCTerminalAction;

NS_ASSUME_NONNULL_BEGIN
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunknown-warning-option"
#pragma clang diagnostic ignored "-Wincompatible-property-type"
#pragma clang diagnostic ignored "-Wnullability"

#pragma push_macro("_Nullable_result")
#if !__has_feature(nullability_nullable_result)
#undef _Nullable_result
#define _Nullable_result _Nullable
#endif

__attribute__((swift_name("KotlinBase")))
@interface TCCBase : NSObject
- (instancetype)init __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (void)initialize __attribute__((objc_requires_super));
@end

@interface TCCBase (TCCBaseCopying) <NSCopying>
@end

__attribute__((swift_name("KotlinMutableSet")))
@interface TCCMutableSet<ObjectType> : NSMutableSet<ObjectType>
@end

__attribute__((swift_name("KotlinMutableDictionary")))
@interface TCCMutableDictionary<KeyType, ObjectType> : NSMutableDictionary<KeyType, ObjectType>
@end

@interface NSError (NSErrorTCCKotlinException)
@property (readonly) id _Nullable kotlinException;
@end

__attribute__((swift_name("KotlinNumber")))
@interface TCCNumber : NSNumber
- (instancetype)initWithChar:(char)value __attribute__((unavailable));
- (instancetype)initWithUnsignedChar:(unsigned char)value __attribute__((unavailable));
- (instancetype)initWithShort:(short)value __attribute__((unavailable));
- (instancetype)initWithUnsignedShort:(unsigned short)value __attribute__((unavailable));
- (instancetype)initWithInt:(int)value __attribute__((unavailable));
- (instancetype)initWithUnsignedInt:(unsigned int)value __attribute__((unavailable));
- (instancetype)initWithLong:(long)value __attribute__((unavailable));
- (instancetype)initWithUnsignedLong:(unsigned long)value __attribute__((unavailable));
- (instancetype)initWithLongLong:(long long)value __attribute__((unavailable));
- (instancetype)initWithUnsignedLongLong:(unsigned long long)value __attribute__((unavailable));
- (instancetype)initWithFloat:(float)value __attribute__((unavailable));
- (instancetype)initWithDouble:(double)value __attribute__((unavailable));
- (instancetype)initWithBool:(BOOL)value __attribute__((unavailable));
- (instancetype)initWithInteger:(NSInteger)value __attribute__((unavailable));
- (instancetype)initWithUnsignedInteger:(NSUInteger)value __attribute__((unavailable));
+ (instancetype)numberWithChar:(char)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedChar:(unsigned char)value __attribute__((unavailable));
+ (instancetype)numberWithShort:(short)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedShort:(unsigned short)value __attribute__((unavailable));
+ (instancetype)numberWithInt:(int)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedInt:(unsigned int)value __attribute__((unavailable));
+ (instancetype)numberWithLong:(long)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedLong:(unsigned long)value __attribute__((unavailable));
+ (instancetype)numberWithLongLong:(long long)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedLongLong:(unsigned long long)value __attribute__((unavailable));
+ (instancetype)numberWithFloat:(float)value __attribute__((unavailable));
+ (instancetype)numberWithDouble:(double)value __attribute__((unavailable));
+ (instancetype)numberWithBool:(BOOL)value __attribute__((unavailable));
+ (instancetype)numberWithInteger:(NSInteger)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedInteger:(NSUInteger)value __attribute__((unavailable));
@end

__attribute__((swift_name("KotlinByte")))
@interface TCCByte : TCCNumber
- (instancetype)initWithChar:(char)value;
+ (instancetype)numberWithChar:(char)value;
@end

__attribute__((swift_name("KotlinUByte")))
@interface TCCUByte : TCCNumber
- (instancetype)initWithUnsignedChar:(unsigned char)value;
+ (instancetype)numberWithUnsignedChar:(unsigned char)value;
@end

__attribute__((swift_name("KotlinShort")))
@interface TCCShort : TCCNumber
- (instancetype)initWithShort:(short)value;
+ (instancetype)numberWithShort:(short)value;
@end

__attribute__((swift_name("KotlinUShort")))
@interface TCCUShort : TCCNumber
- (instancetype)initWithUnsignedShort:(unsigned short)value;
+ (instancetype)numberWithUnsignedShort:(unsigned short)value;
@end

__attribute__((swift_name("KotlinInt")))
@interface TCCInt : TCCNumber
- (instancetype)initWithInt:(int)value;
+ (instancetype)numberWithInt:(int)value;
@end

__attribute__((swift_name("KotlinUInt")))
@interface TCCUInt : TCCNumber
- (instancetype)initWithUnsignedInt:(unsigned int)value;
+ (instancetype)numberWithUnsignedInt:(unsigned int)value;
@end

__attribute__((swift_name("KotlinLong")))
@interface TCCLong : TCCNumber
- (instancetype)initWithLongLong:(long long)value;
+ (instancetype)numberWithLongLong:(long long)value;
@end

__attribute__((swift_name("KotlinULong")))
@interface TCCULong : TCCNumber
- (instancetype)initWithUnsignedLongLong:(unsigned long long)value;
+ (instancetype)numberWithUnsignedLongLong:(unsigned long long)value;
@end

__attribute__((swift_name("KotlinFloat")))
@interface TCCFloat : TCCNumber
- (instancetype)initWithFloat:(float)value;
+ (instancetype)numberWithFloat:(float)value;
@end

__attribute__((swift_name("KotlinDouble")))
@interface TCCDouble : TCCNumber
- (instancetype)initWithDouble:(double)value;
+ (instancetype)numberWithDouble:(double)value;
@end

__attribute__((swift_name("KotlinBoolean")))
@interface TCCBoolean : TCCNumber
- (instancetype)initWithBool:(BOOL)value;
+ (instancetype)numberWithBool:(BOOL)value;
@end

__attribute__((swift_name("BaseTerminalOperation")))
@interface TCCBaseTerminalOperation : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandsTids:(NSArray<NSString *> *)tids completionHandler:(void (^)(TCCResult<NSArray<TCCCommand *> *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commands(tids:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TCCActionJob *)actionJob payload:(TCCAction *)payload device:(TCCTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));
- (id<TCCKotlinx_coroutines_coreJob>)observePayloadScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable))onResult __attribute__((swift_name("observePayload(scope:onResult:)")));
@end

__attribute__((swift_name("TerminalOperation")))
@interface TCCTerminalOperation : TCCBaseTerminalOperation
- (instancetype)initWithTerminalProvider:(TCCTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));

/**
 * Cancel an intent
 */
- (void)cancelDevice:(TCCTerminalDevice *)device key:(TCCAction *)key __attribute__((swift_name("cancel(device:key:)")));

/**
 * Cancel all the intents
 */
- (void)cancelAllDevice:(TCCTerminalDevice *)device __attribute__((swift_name("cancelAll(device:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)cancelSessionPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelSession(payload:device:isSimulation:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkStatusPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkStatus(payload:device:paymentRequestId:isSimulation:completionHandler:)")));
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectDevice:(TCCTerminalDevice * _Nullable)device __attribute__((swift_name("disconnect(device:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TCCActionJob *)actionJob payload:(TCCAction *)payload device:(TCCTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeAction:(TCCAction * _Nullable)action command:(TCCCommand *)command device:(TCCTerminalDevice *)device isSimulation:(BOOL)isSimulation completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(action:command:device:isSimulation:completionHandler:)")));
- (TCCTimeoutType * _Nullable)getTimeoutTypeAction:(TCCAction *)action __attribute__((swift_name("getTimeoutType(action:)")));
- (BOOL)isLockedDevice:(TCCTerminalDevice *)device __attribute__((swift_name("isLocked(device:)")));
- (BOOL)isSupported __attribute__((swift_name("isSupported()")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<TCCKotlinx_coroutines_coreJob>)observeResultOnResult:(void (^)(TCCResult<TCCTerminalResult *> *))onResult __attribute__((swift_name("observeResult(onResult:)")));

/**
 * Observes the Terminal connection state on [Dispatchers.IO] and
 * delivers updates via the [onResult] callback.
 *
 * This is a convenience function that launches the observation in a default [CoroutineScope]
 * on the [Dispatchers.IO] dispatcher.
 *
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine. Cancelling this job will stop the observation.
 */
- (id<TCCKotlinx_coroutines_coreJob>)observeTerminalConnectionOnResult:(void (^)(TCCConnectionState *))onResult __attribute__((swift_name("observeTerminalConnection(onResult:)")));

/**
 * Observes the Terminal connection state within a given [scope] and
 * delivers updates via the [onResult] callback.
 *
 * This function collects the [ConnectionState] emitted by [connectionState] and
 * invokes the [onResult] callback with the latest state. The observation will continue
 * as long as the provided [scope] is active.
 *
 * @param scope The [CoroutineScope] in which the observation coroutine will be launched.
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine. Cancelling this job will stop the observation.
 */
- (id<TCCKotlinx_coroutines_coreJob>)observeTerminalConnectionScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(TCCConnectionState *))onResult __attribute__((swift_name("observeTerminalConnection(scope:onResult:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onPayCommand:(TCCCommand *)command data:(TCCPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onPrintReceiptCommand:(TCCCommand *)command data:(TCCPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onSettlementCommand:(TCCCommand *)command data:(TCCSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onVoidCommand:(TCCCommand *)command data:(TCCVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(TCCTerminalDevice *)device completionHandler:(void (^)(TCCBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));
- (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(TCCAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));
- (TCCBoolean * _Nullable)releaseDevice:(TCCTerminalDevice * _Nullable)device __attribute__((swift_name("release(device:)")));
- (BOOL)releaseTerminalID:(NSString *)terminalID __attribute__((swift_name("release(terminalID:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCActionJob *)runActionIt:(TCCAction *)it device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation callback:(void (^)(TCCTerminalResult * _Nullable, TCCErrorData * _Nullable))callback __attribute__((swift_name("runAction(it:device:isSimulation:callback:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCActionJob *)runActionIt:(TCCAction *)it device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onCancel:(id<TCCKotlinSuspendFunction0>)onCancel callback:(void (^)(TCCTerminalResult * _Nullable, TCCErrorData * _Nullable))callback __attribute__((swift_name("runAction(it:device:isSimulation:onCancel:callback:)")));
- (void)setConnectionTypeConnectionType:(TCCConnectionType *)connectionType __attribute__((swift_name("setConnectionType(connectionType:)")));
- (NSString * _Nullable)terminalIDData:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)testDeviceConnectionTerminalOperation:(TCCTerminalOperation *)terminalOperation device:(TCCTerminalDevice *)device completionHandler:(void (^)(TCCTerminalDevice * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("testDeviceConnection(terminalOperation:device:completionHandler:)")));
- (TCCAction * _Nullable)toActionPayloadCommand:(TCCCommand *)command data:(id<TCCCommandPayload> _Nullable)data __attribute__((swift_name("toActionPayload(command:data:)")));
- (NSArray<id<TCCTerminalAction>> *)toActionsCommandType:(TCCCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (int64_t)toMillis:(NSString *)receiver __attribute__((swift_name("toMillis(_:)")));
- (TCCGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (TCCResult<TCCTerminalResult *> * _Nullable)toResultTerminalDevice:(TCCTerminalDevice *)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));
- (TCCKotlinPair<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(TCCKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)json transactions:(TCCTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (TCCTerminalResult * _Nullable)toTerminalResultTerminalDevice:(TCCTerminalDevice * _Nullable)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));
- (NSArray<TCCTerminalResult *> * _Nullable)transactionRecordsActions:(NSArray<id<TCCTerminalAction>> *)actions statuses:(NSArray<TCCStatus *> *)statuses from:(NSString * _Nullable)from to:(NSString * _Nullable)to __attribute__((swift_name("transactionRecords(actions:statuses:from:to:)")));
- (NSArray<TCCTerminalResult *> * _Nullable)transactionRecordsActions:(NSArray<NSString *> *)actions statuses:(NSArray<TCCStatus *> *)statuses fromTimestamp:(TCCLong * _Nullable)fromTimestamp toTimestamp:(TCCLong * _Nullable)toTimestamp __attribute__((swift_name("transactionRecords(actions:statuses:fromTimestamp:toTimestamp:)")));
- (TCCTerminalResult *)transformJsonToResultJson:(TCCKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));
- (void)useWifi __attribute__((swift_name("useWifi()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TCCBluetoothService> _Nullable bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCTerminalCommunicationService * _Nullable communicationService __attribute__((swift_name("communicationService")));
@property (readonly) id<TCCKotlinx_coroutines_coreFlow> connectionState __attribute__((swift_name("connectionState")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property TCCTerminalDevice * _Nullable device __attribute__((swift_name("device")));
@property BOOL isSimulation __attribute__((swift_name("isSimulation")));
@property (readonly) BOOL needVerify __attribute__((swift_name("needVerify")));

/**
 * Get the result flow
 * @return the result flow
 */
@property (readonly) id<TCCKotlinx_coroutines_coreStateFlow> result __attribute__((swift_name("result")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TCCKotlinx_coroutines_coreMutableStateFlow> resultFlow __attribute__((swift_name("resultFlow")));
@property (readonly) TCCConnectionType *sdkConnectionType __attribute__((swift_name("sdkConnectionType")));
@property (readonly) TCCTerminalProvider *terminalProvider __attribute__((swift_name("terminalProvider")));
@end


/**
 * Implementation of [TerminalOperation] for BRI (Bank Rakyat Indonesia) terminals.
 * This class handles communication with BRI EDCs via WebSocket or Bluetooth, maps
 * generic terminal actions to BRI-specific protocols, and manages transaction lifecycles
 * including payments, settlements, voids, and refunds.
 */
__attribute__((swift_name("BaseTerminalBRI")))
@interface TCCBaseTerminalBRI : TCCTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(TCCTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Checks the status of a specific transaction on the terminal device.
 * This is typically used to verify if a previous operation (like a sale or verification)
 * was successful when the initial response was ambiguous or lost.
 *
 * @param payload The action payload.
 * @param device The target terminal device.
 * @param paymentRequestId The ID of the payment request.
 * @param isSimulation Flag to indicate if this is a simulation.
 * @return A [Result] containing the [TerminalResult], or [ErrorCode.DATA_NOT_FOUND] if no Order ID exists.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkStatusPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkStatus(payload:device:paymentRequestId:isSimulation:completionHandler:)")));
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Executes a terminal action. If the action is a payment, it verifies the consistency
 * of the Order ID between the request and the result. If they mismatch, it attempts
 * to fetch the correct status from the device.
 *
 * @param actionJob The job context for the action.
 * @param payload The action payload.
 * @param device The target terminal device.
 * @param orderId The order identifier.
 * @param paymentRequestId The payment request identifier.
 * @param isSimulation Flag for simulation mode.
 * @param isSynchronize Flag for synchronous execution.
 * @return The result of the terminal operation.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TCCActionJob *)actionJob payload:(TCCAction *)payload device:(TCCTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));
- (TCCTimeoutType * _Nullable)getTimeoutTypeAction:(TCCAction *)action __attribute__((swift_name("getTimeoutType(action:)")));

/**
 * Maps a generic [Command.PAY] command to a specific BRI payment action.
 * Handles various payment methods like Insert Card, Contactless, BRIZZI, and QRIS.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onPayCommand:(TCCCommand *)command data:(TCCPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * Maps a generic [Command.PRINT_RECEIPT] command to a BRI Reprint or CheckStatus action.
 * For QRIS, it uses CheckStatus to fetch and print the latest status.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction *)onPrintReceiptCommand:(TCCCommand *)command data:(TCCPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the status of a transaction. If a valid Order ID is associated with the payload,
 * it triggers a status check on the device.
 *
 * @param payload The action payload containing transaction details.
 * @param device The target terminal device.
 * @param paymentRequestId The ID of the payment request.
 * @param isSimulation Flag to indicate if this is a simulation.
 * @return A [Result] containing the [TerminalResult] of the status check.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * Maps a generic [Command.SETTLE] command to a BRI Settlement action.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onSettlementCommand:(TCCCommand *)command data:(TCCSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Maps a generic [Command.VOID] command to a BRI Void or Refund action.
 * Uses [RefundQris] for QRIS methods and standard [Void] for others.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onVoidCommand:(TCCCommand *)command data:(TCCVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Pings the terminal device via WebSocket to check for reachability.
 * Returns true if connection is successful or if specific error codes (like DECLINED_BY_READER) indicate presence.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(TCCTerminalDevice *)device completionHandler:(void (^)(TCCBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));
- (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(TCCAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));
- (NSString * _Nullable)terminalIDData:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));
- (NSArray<id<TCCTerminalAction>> *)toActionsCommandType:(TCCCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (TCCGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (TCCResult<TCCTerminalResult *> * _Nullable)toResultTerminalDevice:(TCCTerminalDevice *)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));

/**
 * Converts the raw JSON response from the terminal into a format suitable for backend synchronization.
 * It handles different transaction types (payment, void, callback) and filters based on status.
 *
 * @param request The original request JSON.
 * @param json The response JSON from the terminal.
 * @param transactions The transaction context.
 * @return A pair of the transaction type name and the synchronized JSON payload.
 */
- (TCCKotlinPair<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(TCCKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)json transactions:(TCCTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (TCCTerminalResult * _Nullable)toTerminalResultTerminalDevice:(TCCTerminalDevice * _Nullable)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));
- (TCCTerminalResult *)transformJsonToResultJson:(TCCKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));
- (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)updateJsonObjectValueJsonObject:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)jsonObject key:(NSString *)key newValue:(TCCKotlinx_serialization_jsonJsonElement *)newValue __attribute__((swift_name("updateJsonObjectValue(jsonObject:key:newValue:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TCCBluetoothService> bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCBriEDCWebSocketService *communicationService __attribute__((swift_name("communicationService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalBRI")))
@interface TCCTerminalBRI : TCCBaseTerminalBRI
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalBRI __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTerminalBRI *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("KotlinComparable")))
@protocol TCCKotlinComparable
@required
- (int32_t)compareToOther:(id _Nullable)other __attribute__((swift_name("compareTo(other:)")));
@end

__attribute__((swift_name("KotlinEnum")))
@interface TCCKotlinEnum<E> : TCCBase <TCCKotlinComparable>
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinEnumCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(E)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) int32_t ordinal __attribute__((swift_name("ordinal")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/PaymentMethodSerializer))
*/
__attribute__((swift_name("PaymentMethod")))
@protocol TCCPaymentMethod
@required
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Enumeration of supported sale methods in the BRI terminal protocol.
 * Maps keys like "purchase", "qris", "brizzi" to internal types.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/BRIPaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPaymentMethod")))
@interface TCCBRIPaymentMethod : TCCKotlinEnum<TCCBRIPaymentMethod *> <TCCPaymentMethod>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enumeration of supported sale methods in the BRI terminal protocol.
 * Maps keys like "purchase", "qris", "brizzi" to internal types.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCBRIPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCBRIPaymentMethod *qris __attribute__((swift_name("qris")));
@property (class, readonly) TCCBRIPaymentMethod *brizzi __attribute__((swift_name("brizzi")));
@property (class, readonly) TCCBRIPaymentMethod *insertCard __attribute__((swift_name("insertCard")));
@property (class, readonly) TCCBRIPaymentMethod *contactless __attribute__((swift_name("contactless")));
@property (class, readonly) TCCBRIPaymentMethod *none __attribute__((swift_name("none")));
+ (TCCKotlinArray<TCCBRIPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCBRIPaymentMethod *> *entries __attribute__((swift_name("entries")));
- (TCCGenericPaymentMethod * _Nullable)toPaymentMethod __attribute__((swift_name("toPaymentMethod()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerializationStrategy")))
@protocol TCCKotlinx_serialization_coreSerializationStrategy
@required
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(id _Nullable)value __attribute__((swift_name("serialize(encoder:value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreDeserializationStrategy")))
@protocol TCCKotlinx_serialization_coreDeserializationStrategy
@required
- (id _Nullable)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreKSerializer")))
@protocol TCCKotlinx_serialization_coreKSerializer <TCCKotlinx_serialization_coreSerializationStrategy, TCCKotlinx_serialization_coreDeserializationStrategy>
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPaymentMethod.Companion")))
@interface TCCBRIPaymentMethodCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCBRIPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (TCCBRIPaymentMethod *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (TCCBRIPaymentMethod *)fromPaymentMethodMethodName:(NSString * _Nullable)methodName __attribute__((swift_name("fromPaymentMethod(methodName:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCBRIPaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCBRIPaymentMethod *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * Marker interface for specific terminal actions (e.g., Payment, Void).
 *
 * Implementations of this interface typically represent concrete operations
 * supported by a terminal.
 */
__attribute__((swift_name("TerminalAction")))
@protocol TCCTerminalAction
@required
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/BRITerminalAction.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRITerminalAction")))
@interface TCCBRITerminalAction : TCCKotlinEnum<TCCBRITerminalAction *> <TCCTerminalAction>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCBRITerminalActionCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCBRITerminalAction *contactless __attribute__((swift_name("contactless")));
@property (class, readonly) TCCBRITerminalAction *sale __attribute__((swift_name("sale")));
@property (class, readonly) TCCBRITerminalAction *settlement __attribute__((swift_name("settlement")));
@property (class, readonly) TCCBRITerminalAction *void_ __attribute__((swift_name("void_")));
@property (class, readonly) TCCBRITerminalAction *reprintAny __attribute__((swift_name("reprintAny")));
@property (class, readonly) TCCBRITerminalAction *reprintLast __attribute__((swift_name("reprintLast")));
@property (class, readonly) TCCBRITerminalAction *cardVerification __attribute__((swift_name("cardVerification")));
@property (class, readonly) TCCBRITerminalAction *saleCompletion __attribute__((swift_name("saleCompletion")));
@property (class, readonly) TCCBRITerminalAction *installment __attribute__((swift_name("installment")));
@property (class, readonly) TCCBRITerminalAction *checkStatus __attribute__((swift_name("checkStatus")));
@property (class, readonly) TCCBRITerminalAction *checkTrx __attribute__((swift_name("checkTrx")));
@property (class, readonly) TCCBRITerminalAction *refundQris __attribute__((swift_name("refundQris")));
@property (class, readonly) TCCBRITerminalAction *unknown __attribute__((swift_name("unknown")));
+ (TCCKotlinArray<TCCBRITerminalAction *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCBRITerminalAction *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRITerminalAction.Companion")))
@interface TCCBRITerminalActionCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCBRITerminalActionCompanion *shared __attribute__((swift_name("shared")));
- (TCCBRITerminalAction *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCBRITerminalAction *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCBRITerminalAction *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/BriStatus.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriStatus")))
@interface TCCBriStatus : TCCKotlinEnum<TCCBriStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCBriStatusCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCBriStatus *success __attribute__((swift_name("success")));
@property (class, readonly) TCCBriStatus *failed __attribute__((swift_name("failed")));
@property (class, readonly) TCCBriStatus *paid __attribute__((swift_name("paid")));
@property (class, readonly) TCCBriStatus *unpaid __attribute__((swift_name("unpaid")));
@property (class, readonly) TCCBriStatus *refund __attribute__((swift_name("refund")));
@property (class, readonly) TCCBriStatus *notFound __attribute__((swift_name("notFound")));
@property (class, readonly) TCCBriStatus *unknown __attribute__((swift_name("unknown")));
+ (TCCKotlinArray<TCCBriStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCBriStatus *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriStatus.Companion")))
@interface TCCBriStatusCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCBriStatusCompanion *shared __attribute__((swift_name("shared")));
- (TCCBriStatus *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCBriStatus *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCBriStatus *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@property (readonly) NSArray<TCCBriStatus *> *successStatusList __attribute__((swift_name("successStatusList")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/ServicePaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServicePaymentMethod")))
@interface TCCServicePaymentMethod : TCCKotlinEnum<TCCServicePaymentMethod *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCServicePaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCServicePaymentMethod *idInsertCard __attribute__((swift_name("idInsertCard")));
@property (class, readonly) TCCServicePaymentMethod *idContactless __attribute__((swift_name("idContactless")));
@property (class, readonly) TCCServicePaymentMethod *idBrizzi __attribute__((swift_name("idBrizzi")));
@property (class, readonly) TCCServicePaymentMethod *idQris __attribute__((swift_name("idQris")));
@property (class, readonly) TCCServicePaymentMethod *unknown __attribute__((swift_name("unknown")));
+ (TCCKotlinArray<TCCServicePaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCServicePaymentMethod *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServicePaymentMethod.Companion")))
@interface TCCServicePaymentMethodCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCServicePaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (TCCServicePaymentMethod *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCServicePaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCServicePaymentMethod *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("TerminalCommunicationService")))
@interface TCCTerminalCommunicationService : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)clearMutexTerminalID:(NSString *)terminalID payload:(id _Nullable)payload __attribute__((swift_name("clearMutex(terminalID:payload:)")));
- (void)closeDevice:(TCCTerminalDevice *)device __attribute__((swift_name("close(device:)")));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TCCTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)connectWithMutexDevice:(TCCTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connectWithMutex(device:port:payload:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updatePriorityDevice:(TCCTerminalDevice *)device priority:(int32_t)priority __attribute__((swift_name("updatePriority(device:priority:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updateStateDevice:(TCCTerminalDevice *)device state:(TCCConnectionState *)state __attribute__((swift_name("updateState(device:state:)")));
@property (readonly) TCCMutableDictionary<NSString *, id<TCCKotlinx_coroutines_coreMutex>> *mutex __attribute__((swift_name("mutex")));
@end

__attribute__((swift_name("WebSocketService")))
@interface TCCWebSocketService : TCCTerminalCommunicationService
- (instancetype)initWithBuilder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriEDCWebSocketService")))
@interface TCCBriEDCWebSocketService : TCCWebSocketService
- (instancetype)initWithResultFlow:(id<TCCKotlinx_coroutines_coreMutableStateFlow>)resultFlow shouldRetry:(TCCBoolean *(^)(TCCKotlinException *))shouldRetry builder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:shouldRetry:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * Connect to the EDC
 * @param device the Terminal Device data
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TCCTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
- (TCCKtor_client_coreHttpClient *)createClientDevice:(TCCTerminalDevice *)device __attribute__((swift_name("createClient(device:)")));
@property (readonly) TCCKtor_client_coreHttpClient *(^builder)(void) __attribute__((swift_name("builder")));
@end

__attribute__((swift_name("MultiTerminalOperation")))
@interface TCCMultiTerminalOperation : TCCBaseTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Adds a terminal provider (e.g., for a specific hardware brand like Verifone or Ingenico)
 * to the map of supported operations.
 *
 * @param provider The [TerminalOperation] implementation for the provider.
 */
- (void)addProviderProvider:(TCCTerminalOperation *)provider __attribute__((swift_name("addProvider(provider:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TCCActionJob *)actionJob payload:(TCCAction *)payload device:(TCCTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Extension function for [Command] that orchestrates its execution on a physical device.
 *
 * Workflow:
 * 1. Finds the device and the appropriate provider for the command.
 * 2. Cleans up previous sessions/connections using [release].
 * 3. Prepares the action payload and cancels any existing sessions on the device.
 * 4. For `PayPayload`, optionally checks transaction status before execution to prevent double charges.
 * 5. Executes the command with a timeout ([withTimeout]) based on the action type.
 * 6. Updates the device state and priority based on the result.
 *
 * @param isSimulation If true, the command is executed in simulation mode.
 * @param completer A callback to report errors encountered during execution.
 * @return A [Result] containing the [TerminalResult] or an error (e.g., TIMEOUT, FAILED_TO_CONNECT).
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)execute:(TCCCommand *)receiver devices:(NSArray<TCCTerminalDevice *> *)devices isSimulation:(BOOL)isSimulation completer:(void (^)(TCCErrorData * _Nullable))completer completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(_:devices:isSimulation:completer:completionHandler:)")));

/**
 * Retrieves a registered terminal provider by its name.
 *
 * @param provider The name of the provider.
 * @return The corresponding [TerminalOperation] or null if not found.
 */
- (TCCTerminalOperation * _Nullable)getProviderProvider:(NSString *)provider __attribute__((swift_name("getProvider(provider:)")));
- (BOOL)releaseTerminalID:(NSString *)terminalID __attribute__((swift_name("release(terminalID:)")));

/**
 * Sets the global maximum allowed time in minutes for any operation to complete before timing out.
 * This updates the timeout settings for all [TimeoutType]s.
 *
 * @param minutes The timeout duration in minutes (must be 1 or greater).
 */
- (void)setOperationTimeoutMinutes:(int32_t)minutes __attribute__((swift_name("setOperationTimeout(minutes:)")));

/**
 * Sets the maximum allowed time in minutes for a specific [TimeoutType] operation.
 *
 * @param type The type of operation (e.g., CARD, QR).
 * @param minutes The timeout duration in minutes (must be 1 or greater).
 */
- (void)setOperationTimeoutType:(TCCTimeoutType *)type minutes:(int32_t)minutes __attribute__((swift_name("setOperationTimeout(type:minutes:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property id<TCCKotlinx_coroutines_coreMutableSharedFlow> errorFlow __attribute__((swift_name("errorFlow")));
@property (readonly) TCCMutableDictionary<NSString *, TCCTerminalOperation *> *terminalOperations __attribute__((swift_name("terminalOperations")));
@end


/**
 * Singleton Client for the Terminal Gateway API.
 *
 * This object provides a unified interface to interact with Xendit Terminal devices via a local gateway.
 * It handles HTTP communication, request serialization, response parsing, and error handling.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalC2C")))
@interface TCCTerminalC2C : TCCMultiTerminalOperation
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Singleton Client for the Terminal Gateway API.
 *
 * This object provides a unified interface to interact with Xendit Terminal devices via a local gateway.
 * It handles HTTP communication, request serialization, response parsing, and error handling.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalC2C __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTerminalC2C *shared __attribute__((swift_name("shared")));

/**
 * Cancels an ongoing payment transaction on the default terminal device.
 *
 * @param cancel The [Cancel] details.
 * @return A [TerminalResult] indicating if the cancellation was accepted.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)cancelPaymentCancel:(TCCCancel *)cancel completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelPayment(cancel:completionHandler:)")));

/**
 * Cancels an ongoing payment transaction on a specific terminal device.
 *
 * @param cancel The [Cancel] details.
 * @param device The [TerminalDevice] to target.
 * @return A [TerminalResult] indicating if the cancellation was accepted.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)cancelPaymentDeviceCancel:(TCCCancel *)cancel device:(TCCTerminalDevice * _Nullable)device completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelPayment(cancel:device:completionHandler:)")));

/**
 * Cancels an ongoing payment transaction on the default terminal device with specific simulation setting.
 *
 * @param cancel The [Cancel] details.
 * @param isSimulation Optional boolean to force simulation mode.
 * @return A [TerminalResult] indicating if the cancellation was accepted.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)cancelPaymentSimulationCancel:(TCCCancel *)cancel isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelPayment(cancel:isSimulation:completionHandler:)")));

/**
 * Cancels an ongoing payment transaction.
 * Target Endpoint: `POST /commands/cancel`
 *
 * @param cancel The [Cancel] details.
 * @param device Optional [TerminalDevice] to target. If null, [defaultDevice] is used.
 * @param isSimulation Optional boolean to force simulation mode for this specific request.
 * @return A [TerminalResult] indicating if the cancellation was accepted.
 * @throws TerminalException If the cancellation fails.
 *
 * @note This method converts all Kotlin exceptions to errors.
*/
- (void)cancelPaymentFullCancel:(TCCCancel *)cancel device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelPayment(cancel:device:isSimulation:completionHandler:)")));

/**
 * Asynchronously cancels a payment on the default terminal device.
 *
 * @param cancel The cancel request data.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)cancelPaymentAsyncCancel:(TCCCancel *)cancel onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("cancelPaymentAsync(cancel:onResult:)")));

/**
 * Asynchronously cancels a payment on a specific terminal device.
 *
 * @param cancel The cancel request data.
 * @param device The terminal device to target.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)cancelPaymentAsyncDeviceCancel:(TCCCancel *)cancel device:(TCCTerminalDevice * _Nullable)device onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("cancelPaymentAsync(cancel:device:onResult:)")));

/**
 * Asynchronously cancels a payment on the default terminal device with specific simulation setting.
 *
 * @param cancel The cancel request data.
 * @param isSimulation Optional boolean to force simulation mode.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)cancelPaymentAsyncSimulationCancel:(TCCCancel *)cancel isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("cancelPaymentAsync(cancel:isSimulation:onResult:)")));

/**
 * Asynchronously cancels a payment using a callback mechanism.
 *
 * @param cancel The cancel request data.
 * @param device Optional terminal device.
 * @param isSimulation Optional simulation flag.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)cancelPaymentAsyncFullCancel:(TCCCancel *)cancel device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("cancelPaymentAsync(cancel:device:isSimulation:onResult:)")));

/**
 * Helper to run [cancelPayment] within a specific [CoroutineScope].
 */
- (void)cancelPaymentAsyncScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope cancel:(TCCCancel *)cancel device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("cancelPaymentAsync(scope:cancel:device:isSimulation:onResult:)")));

/**
 * Initiates a payment transaction on the default terminal device.
 *
 * @param payment The [Payment] containing transaction details.
 * @return A [TerminalResult] containing the outcome of the payment.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createPaymentPayment:(TCCPayment *)payment completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createPayment(payment:completionHandler:)")));

/**
 * Initiates a payment transaction on a specific terminal device.
 *
 * @param payment The [Payment] containing transaction details.
 * @param device The [TerminalDevice] to target.
 * @return A [TerminalResult] containing the outcome of the payment.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createPaymentDevicePayment:(TCCPayment *)payment device:(TCCTerminalDevice * _Nullable)device completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createPayment(payment:device:completionHandler:)")));

/**
 * Initiates a payment transaction on the default terminal device with specific simulation setting.
 *
 * @param payment The [Payment] containing transaction details.
 * @param isSimulation Optional boolean to force simulation mode.
 * @return A [TerminalResult] containing the outcome of the payment.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)createPaymentSimulationPayment:(TCCPayment *)payment isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createPayment(payment:isSimulation:completionHandler:)")));

/**
 * Initiates a payment transaction on the terminal.
 * Target Endpoint: `POST /commands/pay`
 *
 * @param payment The [Payment] containing transaction details (amount, currency, etc.).
 * @param device Optional [TerminalDevice] to target. If null, [defaultDevice] is used.
 * @param isSimulation Optional boolean to force simulation mode for this specific request.
 * @return A [TerminalResult] containing the outcome of the payment.
 * @throws TerminalException If the server returns a non-success status or a protocol error occurs.
 * @throws Exception For network-level failures.
 *
 * @note This method converts all Kotlin exceptions to errors.
*/
- (void)createPaymentFullPayment:(TCCPayment *)payment device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("createPayment(payment:device:isSimulation:completionHandler:)")));

/**
 * Asynchronously creates a payment request on the default terminal device.
 *
 * @param payment The payment request data.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle to control the launched coroutine.
 */
- (TCCActionJob *)createPaymentAsyncPayment:(TCCPayment *)payment onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("createPaymentAsync(payment:onResult:)")));

/**
 * Asynchronously creates a payment request on a specific terminal device.
 *
 * @param payment The payment request data.
 * @param device The terminal device to target.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle to control the launched coroutine.
 */
- (TCCActionJob *)createPaymentAsyncDevicePayment:(TCCPayment *)payment device:(TCCTerminalDevice * _Nullable)device onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("createPaymentAsync(payment:device:onResult:)")));

/**
 * Asynchronously creates a payment request on the default terminal device with specific simulation setting.
 *
 * @param payment The payment request data.
 * @param isSimulation Optional boolean to force simulation mode.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle to control the launched coroutine.
 */
- (TCCActionJob *)createPaymentAsyncSimulationPayment:(TCCPayment *)payment isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("createPaymentAsync(payment:isSimulation:onResult:)")));

/**
 * Asynchronously creates a payment request using a callback mechanism.
 * Suitable for interoperability with Java or Objective-C where suspend functions are not directly supported.
 *
 * @param payment The payment request data.
 * @param device Optional terminal device.
 * @param isSimulation Optional simulation flag.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle to control the launched coroutine.
 */
- (TCCActionJob *)createPaymentAsyncFullPayment:(TCCPayment *)payment device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("createPaymentAsync(payment:device:isSimulation:onResult:)")));

/**
 * Helper to run [createPayment] within a specific [CoroutineScope].
 */
- (void)createPaymentAsyncScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope payment:(TCCPayment *)payment device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("createPaymentAsync(scope:payment:device:isSimulation:onResult:)")));

/**
 * Retrieves a list of past transactions from the default terminal device.
 *
 * @param histories The [Histories] parameters.
 * @return A [List] of [TerminalResult] representing the transaction history.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getHistoryHistories:(TCCHistories *)histories completionHandler:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getHistory(histories:completionHandler:)")));

/**
 * Retrieves a list of past transactions from a specific terminal device.
 *
 * @param histories The [Histories] parameters.
 * @param device The [TerminalDevice] to target.
 * @return A [List] of [TerminalResult] representing the transaction history.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getHistoryDeviceHistories:(TCCHistories *)histories device:(TCCTerminalDevice * _Nullable)device completionHandler:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getHistory(histories:device:completionHandler:)")));

/**
 * Retrieves a list of past transactions from the default terminal device with specific simulation setting.
 *
 * @param histories The [Histories] parameters.
 * @param isSimulation Optional boolean to force simulation mode.
 * @return A [List] of [TerminalResult] representing the transaction history.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)getHistorySimulationHistories:(TCCHistories *)histories isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getHistory(histories:isSimulation:completionHandler:)")));

/**
 * Retrieves a list of past transactions from the terminal.
 * Target Endpoint: `POST /commands/histories`
 *
 * @param histories The [Histories] parameters (e.g., pagination or filters).
 * @param device Optional [TerminalDevice] to target. If null, [defaultDevice] is used.
 * @param isSimulation Optional boolean to force simulation mode.
 * @return A [List] of [TerminalResult] representing the transaction history.
 *
 * @note This method converts all Kotlin exceptions to errors.
*/
- (void)getHistoryFullHistories:(TCCHistories *)histories device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getHistory(histories:device:isSimulation:completionHandler:)")));

/**
 * Asynchronously retrieves history from the default terminal device.
 *
 * @param histories The history request data.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)getHistoryAsyncHistories:(TCCHistories *)histories onResult:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("getHistoryAsync(histories:onResult:)")));

/**
 * Asynchronously retrieves history from a specific terminal device.
 *
 * @param histories The history request data.
 * @param device The terminal device to target.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)getHistoryAsyncDeviceHistories:(TCCHistories *)histories device:(TCCTerminalDevice * _Nullable)device onResult:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("getHistoryAsync(histories:device:onResult:)")));

/**
 * Asynchronously retrieves history from the default terminal device with specific simulation setting.
 *
 * @param histories The history request data.
 * @param isSimulation Optional boolean to force simulation mode.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)getHistoryAsyncSimulationHistories:(TCCHistories *)histories isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("getHistoryAsync(histories:isSimulation:onResult:)")));

/**
 * Asynchronously retrieves history using a callback mechanism.
 *
 * @param histories The history request data.
 * @param device Optional terminal device.
 * @param isSimulation Optional boolean to force simulation mode.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)getHistoryAsyncFullHistories:(TCCHistories *)histories device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("getHistoryAsync(histories:device:isSimulation:onResult:)")));

/**
 * Helper to run [getHistory] within a specific [CoroutineScope].
 */
- (void)getHistoryAsyncScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope histories:(TCCHistories *)histories device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(NSArray<TCCTerminalResult *> * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("getHistoryAsync(scope:histories:device:isSimulation:onResult:)")));

/**
 * Initiates a settlement (batch close) process on the default terminal device.
 *
 * @param settlement The [Settlement] parameters.
 * @return A [TerminalResult] with the settlement outcome.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)performSettlementSettlement:(TCCSettlement *)settlement completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("performSettlement(settlement:completionHandler:)")));

/**
 * Initiates a settlement (batch close) process on a specific terminal device.
 *
 * @param settlement The [Settlement] parameters.
 * @param device The [TerminalDevice] to target.
 * @return A [TerminalResult] with the settlement outcome.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)performSettlementDeviceSettlement:(TCCSettlement *)settlement device:(TCCTerminalDevice * _Nullable)device completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("performSettlement(settlement:device:completionHandler:)")));

/**
 * Initiates a settlement (batch close) process on the default terminal device with specific simulation setting.
 *
 * @param settlement The [Settlement] parameters.
 * @param isSimulation Optional boolean to force simulation mode.
 * @return A [TerminalResult] with the settlement outcome.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)performSettlementSimulationSettlement:(TCCSettlement *)settlement isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("performSettlement(settlement:isSimulation:completionHandler:)")));

/**
 * Initiates a settlement (batch close) process on the terminal.
 * Target Endpoint: `POST /commands/settlement`
 *
 * @param settlement The [Settlement] parameters.
 * @param device Optional [TerminalDevice] to target. If null, [defaultDevice] is used.
 * @param isSimulation Optional boolean to force simulation mode.
 * @return A [TerminalResult] with the settlement outcome.
 *
 * @note This method converts all Kotlin exceptions to errors.
*/
- (void)performSettlementFullSettlement:(TCCSettlement *)settlement device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("performSettlement(settlement:device:isSimulation:completionHandler:)")));

/**
 * Asynchronously performs settlement on the default terminal device.
 *
 * @param settlement The settlement request data.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)performSettlementAsyncSettlement:(TCCSettlement *)settlement onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("performSettlementAsync(settlement:onResult:)")));

/**
 * Asynchronously performs settlement on a specific terminal device.
 *
 * @param settlement The settlement request data.
 * @param device The terminal device to target.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)performSettlementAsyncDeviceSettlement:(TCCSettlement *)settlement device:(TCCTerminalDevice * _Nullable)device onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("performSettlementAsync(settlement:device:onResult:)")));

/**
 * Asynchronously performs settlement on the default terminal device with specific simulation setting.
 *
 * @param settlement The settlement request data.
 * @param isSimulation Optional boolean to force simulation mode.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)performSettlementAsyncSimulationSettlement:(TCCSettlement *)settlement isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("performSettlementAsync(settlement:isSimulation:onResult:)")));

/**
 * Asynchronously performs settlement using a callback mechanism.
 *
 * @param settlement The settlement request data.
 * @param device Optional terminal device.
 * @param isSimulation Optional simulation flag.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)performSettlementAsyncFullSettlement:(TCCSettlement *)settlement device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("performSettlementAsync(settlement:device:isSimulation:onResult:)")));

/**
 * Helper to run [performSettlement] within a specific [CoroutineScope].
 */
- (void)performSettlementAsyncScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope settlement:(TCCSettlement *)settlement device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("performSettlementAsync(scope:settlement:device:isSimulation:onResult:)")));

/**
 * Triggers the printing of a transaction receipt on the default terminal device.
 *
 * @param receipt The [Receipt] specifying which transaction to print.
 * @return A [TerminalResult] indicating the print command status.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)printReceiptReceipt:(TCCReceipt *)receipt completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("printReceipt(receipt:completionHandler:)")));

/**
 * Triggers the printing of a transaction receipt on a specific terminal device.
 *
 * @param receipt The [Receipt] specifying which transaction to print.
 * @param device The [TerminalDevice] to target.
 * @return A [TerminalResult] indicating the print command status.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)printReceiptDeviceReceipt:(TCCReceipt *)receipt device:(TCCTerminalDevice * _Nullable)device completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("printReceipt(receipt:device:completionHandler:)")));

/**
 * Triggers the printing of a transaction receipt on the default terminal device with specific simulation setting.
 *
 * @param receipt The [Receipt] specifying which transaction to print.
 * @param isSimulation Optional boolean to force simulation mode.
 * @return A [TerminalResult] indicating the print command status.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)printReceiptSimulationReceipt:(TCCReceipt *)receipt isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("printReceipt(receipt:isSimulation:completionHandler:)")));

/**
 * Triggers the printing of a transaction receipt on the terminal.
 * Target Endpoint: `POST /commands/receipt`
 *
 * @param receipt The [Receipt] specifying which transaction to print.
 * @param device Optional [TerminalDevice] to target. If null, [defaultDevice] is used.
 * @param isSimulation Optional boolean to force simulation mode.
 * @return A [TerminalResult] indicating the print command status.
 *
 * @note This method converts all Kotlin exceptions to errors.
*/
- (void)printReceiptFullReceipt:(TCCReceipt *)receipt device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCTerminalResult * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("printReceipt(receipt:device:isSimulation:completionHandler:)")));

/**
 * Asynchronously prints a receipt on the default terminal device.
 *
 * @param receipt The receipt request data.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)printReceiptAsyncReceipt:(TCCReceipt *)receipt onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("printReceiptAsync(receipt:onResult:)")));

/**
 * Asynchronously prints a receipt on a specific terminal device.
 *
 * @param receipt The receipt request data.
 * @param device The terminal device to target.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)printReceiptAsyncDeviceReceipt:(TCCReceipt *)receipt device:(TCCTerminalDevice * _Nullable)device onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("printReceiptAsync(receipt:device:onResult:)")));

/**
 * Asynchronously prints a receipt on the default terminal device with specific simulation setting.
 *
 * @param receipt The receipt request data.
 * @param isSimulation Optional boolean to force simulation mode.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)printReceiptAsyncSimulationReceipt:(TCCReceipt *)receipt isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("printReceiptAsync(receipt:isSimulation:onResult:)")));

/**
 * Asynchronously prints a receipt using a callback mechanism.
 *
 * @param receipt The receipt request data.
 * @param device Optional terminal device.
 * @param isSimulation Optional simulation flag.
 * @param onResult Callback function invoked with value or error.
 * @return An [ActionJob] handle.
 */
- (TCCActionJob *)printReceiptAsyncFullReceipt:(TCCReceipt *)receipt device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("printReceiptAsync(receipt:device:isSimulation:onResult:)")));

/**
 * Helper to run [printReceipt] within a specific [CoroutineScope].
 */
- (void)printReceiptAsyncScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope receipt:(TCCReceipt *)receipt device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation onResult:(void (^)(TCCTerminalResult * _Nullable, TCCKotlinThrowable * _Nullable))onResult __attribute__((swift_name("printReceiptAsync(scope:receipt:device:isSimulation:onResult:)")));
- (NSArray<TCCTerminalResult *> *)queryHistoriesOperation:(TCCTerminalOperation *)operation histories:(TCCHistories *)histories __attribute__((swift_name("queryHistories(operation:histories:)")));

/**
 * Sets the default [TerminalDevice] for the client.
 * This device will be used for all subsequent requests where a specific device is not provided.
 *
 * @param terminalDevice The device configuration to set as default.
 */
- (void)setTerminalDeviceTerminalDevice:(TCCTerminalDevice *)terminalDevice __attribute__((swift_name("setTerminalDevice(terminalDevice:)")));

/**
 * Flag indicating if the client is operating in simulation mode.
 */
@property BOOL isSimulation __attribute__((swift_name("isSimulation")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ApiError")))
@interface TCCApiError : TCCBase
- (instancetype)initWithErrorCode:(TCCErrorCode * _Nullable)errorCode message:(NSString * _Nullable)message __attribute__((swift_name("init(errorCode:message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCApiErrorCompanion *companion __attribute__((swift_name("companion")));
- (TCCApiError *)doCopyErrorCode:(TCCErrorCode * _Nullable)errorCode message:(NSString * _Nullable)message __attribute__((swift_name("doCopy(errorCode:message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) TCCErrorCode * _Nullable errorCode __attribute__((swift_name("errorCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ApiError.Companion")))
@interface TCCApiErrorCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCApiErrorCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("Request")))
@protocol TCCRequest
@required
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((swift_name("BaseRequest")))
@interface TCCBaseRequest : TCCBase <TCCRequest>
- (instancetype)initWithTerminalId:(NSString *)terminalId paymentMethod:(id<TCCPaymentMethod> _Nullable)paymentMethod __attribute__((swift_name("init(terminalId:paymentMethod:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithSeen0:(int32_t)seen0 terminalId:(NSString * _Nullable)terminalId paymentMethod:(id<TCCPaymentMethod> _Nullable)paymentMethod serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:terminalId:paymentMethod:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCBaseRequestCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) id<TCCPaymentMethod> _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BaseRequest.Companion")))
@interface TCCBaseRequestCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCBaseRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Cancel")))
@interface TCCCancel : TCCBase <TCCRequest>
- (instancetype)initWithPaymentMethod:(id<TCCPaymentMethod> _Nullable)paymentMethod terminalReference:(NSString *)terminalReference __attribute__((swift_name("init(paymentMethod:terminalReference:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCCancelCompanion *companion __attribute__((swift_name("companion")));
- (TCCCancel *)doCopyPaymentMethod:(id<TCCPaymentMethod> _Nullable)paymentMethod terminalReference:(NSString *)terminalReference __attribute__((swift_name("doCopy(paymentMethod:terminalReference:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) id<TCCPaymentMethod> _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_reference")
*/
@property (readonly) NSString *terminalReference __attribute__((swift_name("terminalReference")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Cancel.Companion")))
@interface TCCCancelCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCCancelCompanion *shared __attribute__((swift_name("shared")));
- (TCCCancel *)fromResultResult:(TCCTerminalResult *)result __attribute__((swift_name("fromResult(result:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Histories")))
@interface TCCHistories : TCCBase <TCCRequest>
- (instancetype)initWithCommands:(NSArray<TCCCommandType *> * _Nullable)commands statuses:(NSArray<TCCStatus *> * _Nullable)statuses from:(NSString * _Nullable)from to:(NSString * _Nullable)to __attribute__((swift_name("init(commands:statuses:from:to:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCHistoriesCompanion *companion __attribute__((swift_name("companion")));
- (TCCHistories *)doCopyCommands:(NSArray<TCCCommandType *> * _Nullable)commands statuses:(NSArray<TCCStatus *> * _Nullable)statuses from:(NSString * _Nullable)from to:(NSString * _Nullable)to __attribute__((swift_name("doCopy(commands:statuses:from:to:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="commands")
*/
@property (readonly) NSArray<TCCCommandType *> * _Nullable commands __attribute__((swift_name("commands")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="from")
*/
@property (readonly) NSString * _Nullable from __attribute__((swift_name("from")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="statuses")
*/
@property (readonly) NSArray<TCCStatus *> * _Nullable statuses __attribute__((swift_name("statuses")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="to")
*/
@property (readonly) NSString * _Nullable to __attribute__((swift_name("to")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Histories.Companion")))
@interface TCCHistoriesCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCHistoriesCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Payment")))
@interface TCCPayment : TCCBase <TCCRequest>
- (instancetype)initWithOrderID:(NSString *)orderID amount:(double)amount paymentMethod:(id<TCCPaymentMethod>)paymentMethod __attribute__((swift_name("init(orderID:amount:paymentMethod:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCPaymentCompanion *companion __attribute__((swift_name("companion")));
- (TCCPayment *)doCopyOrderID:(NSString *)orderID amount:(double)amount paymentMethod:(id<TCCPaymentMethod>)paymentMethod __attribute__((swift_name("doCopy(orderID:amount:paymentMethod:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="request_amount")
*/
@property (readonly) double amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) id<TCCPaymentMethod> paymentMethod __attribute__((swift_name("paymentMethod")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Payment.Companion")))
@interface TCCPaymentCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCPaymentCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Receipt")))
@interface TCCReceipt : TCCBase <TCCRequest>
- (instancetype)initWithPaymentMethod:(id<TCCPaymentMethod> _Nullable)paymentMethod terminalReference:(NSString *)terminalReference __attribute__((swift_name("init(paymentMethod:terminalReference:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCReceiptCompanion *companion __attribute__((swift_name("companion")));
- (TCCReceipt *)doCopyPaymentMethod:(id<TCCPaymentMethod> _Nullable)paymentMethod terminalReference:(NSString *)terminalReference __attribute__((swift_name("doCopy(paymentMethod:terminalReference:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) id<TCCPaymentMethod> _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_reference")
*/
@property (readonly) NSString *terminalReference __attribute__((swift_name("terminalReference")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Receipt.Companion")))
@interface TCCReceiptCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCReceiptCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Settlement")))
@interface TCCSettlement : TCCBase <TCCRequest>
- (instancetype)initWithPaymentMethod:(id<TCCPaymentMethod> _Nullable)paymentMethod __attribute__((swift_name("init(paymentMethod:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCSettlementCompanion *companion __attribute__((swift_name("companion")));
- (TCCSettlement *)doCopyPaymentMethod:(id<TCCPaymentMethod> _Nullable)paymentMethod __attribute__((swift_name("doCopy(paymentMethod:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) id<TCCPaymentMethod> _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Settlement.Companion")))
@interface TCCSettlementCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSettlementCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("KotlinThrowable")))
@interface TCCKotlinThrowable : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));

/**
 * @note annotations
 *   kotlin.experimental.ExperimentalNativeApi
*/
- (TCCKotlinArray<NSString *> *)getStackTrace __attribute__((swift_name("getStackTrace()")));
- (void)printStackTrace __attribute__((swift_name("printStackTrace()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCKotlinThrowable * _Nullable cause __attribute__((swift_name("cause")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
- (NSError *)asError __attribute__((swift_name("asError()")));
@end

__attribute__((swift_name("KotlinException")))
@interface TCCKotlinException : TCCKotlinThrowable
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalException")))
@interface TCCTerminalException : TCCKotlinException
- (instancetype)initWithHttpCode:(int32_t)httpCode error:(TCCApiError *)error __attribute__((swift_name("init(httpCode:error:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (readonly) TCCApiError *error __attribute__((swift_name("error")));
@property (readonly) int32_t httpCode __attribute__((swift_name("httpCode")));
@end


/**
 * Base implementation for Cashup Terminal operations.
 *
 * This class handles the core logic for communicating with a Cashup terminal, including
 * parsing responses, handling payments, and managing void transactions.
 */
__attribute__((swift_name("BaseTerminalCashup")))
@interface TCCBaseTerminalCashup : TCCTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(TCCTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Generates a new unique Order ID using ULID.
 *
 * @return A string representation of a ULID.
 */
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Constructs the Payment action payload.
 *
 * @param command The base command containing context like order ID.
 * @param data The specific payment payload data.
 * @return A [CashupAction.Payment] action if valid, or null.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCCashupAction * _Nullable)onPayCommand:(TCCCommand *)command data:(TCCPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onPrintReceiptCommand:(TCCCommand *)command data:(TCCPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the terminal status. Currently implemented to return null for Cashup.
 *
 * @param payload The action payload.
 * @param device The target device.
 * @param paymentRequestId The ID of the payment request.
 * @param isSimulation Whether this is a simulation.
 * @return Null as refresh is not implemented.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCKotlinNothing * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onSettlementCommand:(TCCCommand *)command data:(TCCSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Constructs the Void action payload.
 *
 * @param command The base command containing context like order ID.
 * @param data The specific void payload data.
 * @return A [CashupAction.Void] action if valid, [UnsupportedAction] if QRIS, or null if invalid.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onVoidCommand:(TCCCommand *)command data:(TCCVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Pings the device to check connectivity.
 *
 * @param device The device to ping.
 * @return False (Not implemented for Cashup).
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(TCCTerminalDevice *)device completionHandler:(void (^)(TCCBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));

/**
 * Prepares the request payload for transmission.
 *
 * @param payload The action payload.
 * @return A map representing the JSON data to be sent.
 */
- (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(TCCAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));

/**
 * Extracts the terminal ID from the provided JSON data.
 *
 * @param data The JSON element containing terminal information.
 * @return The terminal ID string, or null if not present.
 */
- (NSString * _Nullable)terminalIDData:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));

/**
 * Maps a command type to a list of supported terminal actions.
 *
 * @param commandType The command type to map.
 * @return A list of [TerminalAction]s supported for that command.
 */
- (NSArray<id<TCCTerminalAction>> *)toActionsCommandType:(TCCCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));

/**
 * Determines the payment method from a string value.
 *
 * @param value The string representation of the payment method.
 * @return The corresponding [GenericPaymentMethod], or null if not found.
 */
- (TCCGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));

/**
 * Converts a JSON response into a [Result] containing a [TerminalResult].
 *
 * Checks for error codes in the response and wraps the result in either Success or Failure.
 *
 * @param terminalDevice The device associated with the result.
 * @param json The JSON response.
 * @return A Result containing the TerminalResult, or null if JSON is null.
 */
- (TCCResult<TCCTerminalResult *> * _Nullable)toResultTerminalDevice:(TCCTerminalDevice *)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));

/**
 * Converts a raw request and response into a service payload for callback processing.
 *
 * @param request The original request JSON.
 * @param json The response JSON object.
 * @param transactions The transaction details.
 * @return A pair containing the transaction type name and the processed JSON element.
 */
- (TCCKotlinPair<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(TCCKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)json transactions:(TCCTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));

/**
 * Converts a JSON response directly to a [TerminalResult].
 *
 * @param terminalDevice The device associated with the result.
 * @param json The JSON response.
 * @return The parsed TerminalResult, or null if JSON is null.
 */
- (TCCTerminalResult * _Nullable)toTerminalResultTerminalDevice:(TCCTerminalDevice * _Nullable)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));

/**
 * deserializes a JSON element into a [TerminalResult].
 *
 * @param json The JSON element to transform.
 * @return A [TerminalResult] derived from the JSON.
 */
- (TCCTerminalResult *)transformJsonToResultJson:(TCCKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCKotlinNothing * _Nullable bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCTerminalCommunicationService *communicationService __attribute__((swift_name("communicationService")));
@property (readonly) BOOL needVerify __attribute__((swift_name("needVerify")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalCashup")))
@interface TCCTerminalCashup : TCCBaseTerminalCashup
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalCashup __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTerminalCashup *shared __attribute__((swift_name("shared")));
@end


/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((swift_name("Action")))
@interface TCCAction : TCCBase
- (instancetype)initWithData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCActionCompanion *companion __attribute__((swift_name("companion")));

/**
 * Convenience method to get payment method using the instance's [data].
 *
 * @return The payment method, or null.
 */
- (NSString * _Nullable)getPaymentMethod __attribute__((swift_name("getPaymentMethod()")));

/**
 * Retrieves the payment method identifier from the data map.
 *
 * @param data The map containing transaction data.
 * @return The payment method string, or null if not present.
 */
- (NSString * _Nullable)getPaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));

/**
 * Convenience method to get service payment method using the instance's [data].
 *
 * @return The service payment method.
 */
- (NSString *)getServicePaymentMethod __attribute__((swift_name("getServicePaymentMethod()")));

/**
 * Retrieves the service-specific payment method from the data map.
 *
 * @param data The map containing transaction data.
 * @return The service payment method string.
 */
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));

/**
 * Convenience method to get terminal action using the instance's [data].
 *
 * @return The terminal action, or null.
 */
- (id<TCCTerminalAction> _Nullable)getTerminalAction __attribute__((swift_name("getTerminalAction()")));

/**
 * Derives the specific [TerminalAction] from the data map.
 *
 * @param data The map containing transaction data.
 * @return The corresponding [TerminalAction], or null if it cannot be determined.
 */
- (id<TCCTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));

/**
 * Convenience method to get transaction amount using the instance's [data].
 *
 * @return The transaction amount.
 */
- (double)getTransactionAmount __attribute__((swift_name("getTransactionAmount()")));

/**
 * Retrieves the transaction amount from the data map.
 *
 * @param data The map containing transaction data.
 * @return The transaction amount as a Double.
 */
- (double)getTransactionAmountData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));

/**
 * Convenience method to get transaction order ID using the instance's [data].
 *
 * @return The order ID, or null.
 */
- (NSString * _Nullable)getTransactionOrderID __attribute__((swift_name("getTransactionOrderID()")));

/**
 * Retrieves the transaction order ID from the data map.
 *
 * @param data The map containing transaction data.
 * @return The order ID string, or null if not present.
 */
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));

/**
 * Determines if this action requires verification.
 *
 * @return True if verification is needed, false otherwise. Defaults to true.
 */
- (BOOL)isNeedVerified __attribute__((swift_name("isNeedVerified()")));
@property (readonly) NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *data __attribute__((swift_name("data")));
@end


/**
 * Represents a fundamental action unit to be transmitted to the Cashup Terminal.
 *
 * This sealed class serves as a wrapper for various terminal operations such as
 * [Payment], [Void], and status checks. It abstracts the transformation
 * of high-level data models into the generic JSON map structure (`Map<String, JsonElement>`)
 * required by the underlying IPC or network layer.
 *
 * @param data The backing map containing raw JSON elements for the action payload.
 */
__attribute__((swift_name("CashupAction")))
@interface TCCCashupAction : TCCAction
- (instancetype)initWithData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Determines the broad [GenericPaymentMethod] category (e.g., QR or CARD) based on the
 * transaction type found in the data.
 *
 * @param data The raw data map.
 * @return A string representation of the [GenericPaymentMethod].
 */
- (NSString *)getPaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));

/**
 * Identifies the specific service payment method name.
 *
 * Unlike [getPaymentMethod] which returns the broad category, this may return specific
 * scheme names or subtypes if available, though currently defaults to mapping
 * [CashupTerminalAction.QRIS] to [GenericPaymentMethod.QR] and others to [GenericPaymentMethod.CARD].
 *
 * @param data The raw data map.
 * @return The name of the payment method.
 */
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));

/**
 * Resolves the raw transaction type code from the data map into a concrete [TerminalAction].
 *
 * @param data The raw data map.
 * @return The corresponding [CashupTerminalAction] enum entry, or `null` if the type is unrecognized.
 */
- (id<TCCTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));

/**
 * Retrieves the transaction amount from the action's data map.
 *
 * @param data The raw data map.
 * @return The transaction amount as a [Double]. Returns `0.0` if the key is missing or parsing fails.
 */
- (double)getTransactionAmountData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));

/**
 * Retrieves the Merchant Transaction ID (Order ID) from the action's data map.
 *
 * @param data The raw data map.
 * @return The Order ID as a [String], or `null` if not present.
 */
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/cashup/data/CashupPaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupPaymentMethod")))
@interface TCCCashupPaymentMethod : TCCKotlinEnum<TCCCashupPaymentMethod *> <TCCPaymentMethod>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCCashupPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCCashupPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) TCCCashupPaymentMethod *qris __attribute__((swift_name("qris")));
+ (TCCKotlinArray<TCCCashupPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCCashupPaymentMethod *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupPaymentMethod.Companion")))
@interface TCCCashupPaymentMethodCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCCashupPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (TCCCashupPaymentMethod *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCCashupPaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCCashupPaymentMethod *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * Represents the top-level API response structure.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupTerminalResult")))
@interface TCCCashupTerminalResult : TCCBase
- (instancetype)initWithStatus:(NSString * _Nullable)status message:(NSString * _Nullable)message responseCode:(NSString * _Nullable)responseCode approvalCode:(NSString * _Nullable)approvalCode baseAmount:(TCCDouble * _Nullable)baseAmount tipAmount:(TCCDouble * _Nullable)tipAmount invoiceNum:(NSString * _Nullable)invoiceNum batchNum:(NSString * _Nullable)batchNum rrn:(NSString * _Nullable)rrn midwareTimestamp:(NSString * _Nullable)midwareTimestamp merchantTrxId:(NSString * _Nullable)merchantTrxId deviceId:(NSString * _Nullable)deviceId deviceUser:(NSString * _Nullable)deviceUser additionalParam:(NSString * _Nullable)additionalParam acquirerName:(NSString * _Nullable)acquirerName aid:(NSString * _Nullable)aid applicationLabel:(NSString * _Nullable)applicationLabel batchGroup:(NSString * _Nullable)batchGroup binResult:(NSString * _Nullable)binResult cardExpired:(NSString * _Nullable)cardExpired emvResLen:(TCCInt * _Nullable)emvResLen entryMode:(NSString * _Nullable)entryMode hostDate:(NSString * _Nullable)hostDate hostTime:(NSString * _Nullable)hostTime isDebitFlag:(TCCBoolean * _Nullable)isDebitFlag maskedPan:(NSString * _Nullable)maskedPan mid:(NSString * _Nullable)mid tid:(NSString * _Nullable)tid tc:(NSString * _Nullable)tc tsi:(NSString * _Nullable)tsi tvr:(NSString * _Nullable)tvr printReceiptAddressLine1:(NSString * _Nullable)printReceiptAddressLine1 printReceiptAddressLine2:(NSString * _Nullable)printReceiptAddressLine2 printReceiptMerchantName:(NSString * _Nullable)printReceiptMerchantName merchantId:(NSString * _Nullable)merchantId merchantName:(NSString * _Nullable)merchantName merchantAddress1:(NSString * _Nullable)merchantAddress1 merchantAddress2:(NSString * _Nullable)merchantAddress2 issuerName:(NSString * _Nullable)issuerName batchGroupId:(TCCInt * _Nullable)batchGroupId batchGroupName:(NSString * _Nullable)batchGroupName createAt:(NSString * _Nullable)createAt qrGeneratedAt:(NSString * _Nullable)qrGeneratedAt qrPayAppId:(NSString * _Nullable)qrPayAppId qrPayAppName:(NSString * _Nullable)qrPayAppName __attribute__((swift_name("init(status:message:responseCode:approvalCode:baseAmount:tipAmount:invoiceNum:batchNum:rrn:midwareTimestamp:merchantTrxId:deviceId:deviceUser:additionalParam:acquirerName:aid:applicationLabel:batchGroup:binResult:cardExpired:emvResLen:entryMode:hostDate:hostTime:isDebitFlag:maskedPan:mid:tid:tc:tsi:tvr:printReceiptAddressLine1:printReceiptAddressLine2:printReceiptMerchantName:merchantId:merchantName:merchantAddress1:merchantAddress2:issuerName:batchGroupId:batchGroupName:createAt:qrGeneratedAt:qrPayAppId:qrPayAppName:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCCashupTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (TCCCashupTerminalResult *)doCopyStatus:(NSString * _Nullable)status message:(NSString * _Nullable)message responseCode:(NSString * _Nullable)responseCode approvalCode:(NSString * _Nullable)approvalCode baseAmount:(TCCDouble * _Nullable)baseAmount tipAmount:(TCCDouble * _Nullable)tipAmount invoiceNum:(NSString * _Nullable)invoiceNum batchNum:(NSString * _Nullable)batchNum rrn:(NSString * _Nullable)rrn midwareTimestamp:(NSString * _Nullable)midwareTimestamp merchantTrxId:(NSString * _Nullable)merchantTrxId deviceId:(NSString * _Nullable)deviceId deviceUser:(NSString * _Nullable)deviceUser additionalParam:(NSString * _Nullable)additionalParam acquirerName:(NSString * _Nullable)acquirerName aid:(NSString * _Nullable)aid applicationLabel:(NSString * _Nullable)applicationLabel batchGroup:(NSString * _Nullable)batchGroup binResult:(NSString * _Nullable)binResult cardExpired:(NSString * _Nullable)cardExpired emvResLen:(TCCInt * _Nullable)emvResLen entryMode:(NSString * _Nullable)entryMode hostDate:(NSString * _Nullable)hostDate hostTime:(NSString * _Nullable)hostTime isDebitFlag:(TCCBoolean * _Nullable)isDebitFlag maskedPan:(NSString * _Nullable)maskedPan mid:(NSString * _Nullable)mid tid:(NSString * _Nullable)tid tc:(NSString * _Nullable)tc tsi:(NSString * _Nullable)tsi tvr:(NSString * _Nullable)tvr printReceiptAddressLine1:(NSString * _Nullable)printReceiptAddressLine1 printReceiptAddressLine2:(NSString * _Nullable)printReceiptAddressLine2 printReceiptMerchantName:(NSString * _Nullable)printReceiptMerchantName merchantId:(NSString * _Nullable)merchantId merchantName:(NSString * _Nullable)merchantName merchantAddress1:(NSString * _Nullable)merchantAddress1 merchantAddress2:(NSString * _Nullable)merchantAddress2 issuerName:(NSString * _Nullable)issuerName batchGroupId:(TCCInt * _Nullable)batchGroupId batchGroupName:(NSString * _Nullable)batchGroupName createAt:(NSString * _Nullable)createAt qrGeneratedAt:(NSString * _Nullable)qrGeneratedAt qrPayAppId:(NSString * _Nullable)qrPayAppId qrPayAppName:(NSString * _Nullable)qrPayAppName __attribute__((swift_name("doCopy(status:message:responseCode:approvalCode:baseAmount:tipAmount:invoiceNum:batchNum:rrn:midwareTimestamp:merchantTrxId:deviceId:deviceUser:additionalParam:acquirerName:aid:applicationLabel:batchGroup:binResult:cardExpired:emvResLen:entryMode:hostDate:hostTime:isDebitFlag:maskedPan:mid:tid:tc:tsi:tvr:printReceiptAddressLine1:printReceiptAddressLine2:printReceiptMerchantName:merchantId:merchantName:merchantAddress1:merchantAddress2:issuerName:batchGroupId:batchGroupName:createAt:qrGeneratedAt:qrPayAppId:qrPayAppName:)")));

/**
 * Represents the top-level API response structure.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents the top-level API response structure.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Parses a string in the format "{key=value, key2=value2}" into a Kotlinx JsonElement.
 * * Note: The input string provided is NOT valid JSON (it uses '=' instead of ':' and lacks quotes).
 * This function manually parses that specific format.
 */
- (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)parseStringMapToJsonInput:(NSString *)input __attribute__((swift_name("parseStringMapToJson(input:)")));
- (TCCErrorCode * _Nullable)toErrorCode __attribute__((swift_name("toErrorCode()")));

/**
 * Represents the top-level API response structure.
 */
- (NSString *)description __attribute__((swift_name("description()")));
- (TCCTerminalResult *)toTerminalResultTerminalDevice:(TCCTerminalDevice * _Nullable)terminalDevice __attribute__((swift_name("toTerminalResult(terminalDevice:)")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="acquirer_name")
*/
@property (readonly) NSString * _Nullable acquirerName __attribute__((swift_name("acquirerName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="additional_param")
*/
@property (readonly) NSString * _Nullable additionalParam __attribute__((swift_name("additionalParam")));
@property (readonly) NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable additionalParamObject __attribute__((swift_name("additionalParamObject")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="aid")
*/
@property (readonly) NSString * _Nullable aid __attribute__((swift_name("aid")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="application_label")
*/
@property (readonly) NSString * _Nullable applicationLabel __attribute__((swift_name("applicationLabel")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="approval_code")
*/
@property (readonly) NSString * _Nullable approvalCode __attribute__((swift_name("approvalCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="base_amount")
*/
@property (readonly) TCCDouble * _Nullable baseAmount __attribute__((swift_name("baseAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_group")
*/
@property (readonly) NSString * _Nullable batchGroup __attribute__((swift_name("batchGroup")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_group_id")
*/
@property (readonly) TCCInt * _Nullable batchGroupId __attribute__((swift_name("batchGroupId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_group_name")
*/
@property (readonly) NSString * _Nullable batchGroupName __attribute__((swift_name("batchGroupName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_num")
*/
@property (readonly) NSString * _Nullable batchNum __attribute__((swift_name("batchNum")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="bin_result")
*/
@property (readonly) NSString * _Nullable binResult __attribute__((swift_name("binResult")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_expired")
*/
@property (readonly) NSString * _Nullable cardExpired __attribute__((swift_name("cardExpired")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="create_at")
*/
@property (readonly) NSString * _Nullable createAt __attribute__((swift_name("createAt")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="device_id")
*/
@property (readonly) NSString * _Nullable deviceId __attribute__((swift_name("deviceId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="device_user")
*/
@property (readonly) NSString * _Nullable deviceUser __attribute__((swift_name("deviceUser")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="emv_res_len")
*/
@property (readonly) TCCInt * _Nullable emvResLen __attribute__((swift_name("emvResLen")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="entry_mode")
*/
@property (readonly) NSString * _Nullable entryMode __attribute__((swift_name("entryMode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="host_date")
*/
@property (readonly) NSString * _Nullable hostDate __attribute__((swift_name("hostDate")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="host_time")
*/
@property (readonly) NSString * _Nullable hostTime __attribute__((swift_name("hostTime")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="invoice_num")
*/
@property (readonly) NSString * _Nullable invoiceNum __attribute__((swift_name("invoiceNum")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="is_debit_flag")
*/
@property (readonly) TCCBoolean * _Nullable isDebitFlag __attribute__((swift_name("isDebitFlag")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="issuer_name")
*/
@property (readonly) NSString * _Nullable issuerName __attribute__((swift_name("issuerName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="masked_pan")
*/
@property (readonly) NSString * _Nullable maskedPan __attribute__((swift_name("maskedPan")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_address1")
*/
@property (readonly) NSString * _Nullable merchantAddress1 __attribute__((swift_name("merchantAddress1")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_address2")
*/
@property (readonly) NSString * _Nullable merchantAddress2 __attribute__((swift_name("merchantAddress2")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_id")
*/
@property (readonly) NSString * _Nullable merchantId __attribute__((swift_name("merchantId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_name")
*/
@property (readonly) NSString * _Nullable merchantName __attribute__((swift_name("merchantName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_trx_id")
*/
@property (readonly) NSString * _Nullable merchantTrxId __attribute__((swift_name("merchantTrxId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="mid")
*/
@property (readonly) NSString * _Nullable mid __attribute__((swift_name("mid")));
@property (readonly) NSString * _Nullable midwareTimestamp __attribute__((swift_name("midwareTimestamp")));
@property (readonly) TCCGenericPaymentMethod *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="print_receipt_address_line_1")
*/
@property (readonly) NSString * _Nullable printReceiptAddressLine1 __attribute__((swift_name("printReceiptAddressLine1")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="print_receipt_address_line_2")
*/
@property (readonly) NSString * _Nullable printReceiptAddressLine2 __attribute__((swift_name("printReceiptAddressLine2")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="print_receipt_merchant_name")
*/
@property (readonly) NSString * _Nullable printReceiptMerchantName __attribute__((swift_name("printReceiptMerchantName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="qr_generated_at")
*/
@property (readonly) NSString * _Nullable qrGeneratedAt __attribute__((swift_name("qrGeneratedAt")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="qr_pay_app_id")
*/
@property (readonly) NSString * _Nullable qrPayAppId __attribute__((swift_name("qrPayAppId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="qr_pay_app_name")
*/
@property (readonly) NSString * _Nullable qrPayAppName __attribute__((swift_name("qrPayAppName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="response_code")
*/
@property (readonly) NSString * _Nullable responseCode __attribute__((swift_name("responseCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="rrn")
*/
@property (readonly) NSString * _Nullable rrn __attribute__((swift_name("rrn")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property (readonly) NSString * _Nullable status __attribute__((swift_name("status")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tc")
*/
@property (readonly) NSString * _Nullable tc __attribute__((swift_name("tc")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tid")
*/
@property (readonly) NSString * _Nullable tid __attribute__((swift_name("tid")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tip_amount")
*/
@property (readonly) TCCDouble * _Nullable tipAmount __attribute__((swift_name("tipAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tsi")
*/
@property (readonly) NSString * _Nullable tsi __attribute__((swift_name("tsi")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="tvr")
*/
@property (readonly) NSString * _Nullable tvr __attribute__((swift_name("tvr")));
@end


/**
 * Represents the top-level API response structure.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupTerminalResult.Companion")))
@interface TCCCashupTerminalResultCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents the top-level API response structure.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCCashupTerminalResultCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents the top-level API response structure.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("BaseFakeResponseGenerator")))
@interface TCCBaseFakeResponseGenerator : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FakeResponseGenerator")))
@interface TCCFakeResponseGenerator : TCCBaseFakeResponseGenerator
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)fakeResponseGenerator __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCFakeResponseGenerator *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CashupWebSocketService")))
@interface TCCCashupWebSocketService : TCCWebSocketService
- (instancetype)initWithResultFlow:(id<TCCKotlinx_coroutines_coreMutableStateFlow>)resultFlow builder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeDevice:(TCCTerminalDevice *)device __attribute__((swift_name("close(device:)")));

/**
 * Connect to the EDC
 * @param device the Terminal Device
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TCCTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
@property (readonly) id<TCCKotlinx_coroutines_coreMutableStateFlow> resultFlow __attribute__((swift_name("resultFlow")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppInformation")))
@interface TCCAppInformation : TCCBase
- (instancetype)initWithAppId:(NSString *)appId appName:(NSString *)appName version:(NSString *)version __attribute__((swift_name("init(appId:appName:version:)"))) __attribute__((objc_designated_initializer));
- (TCCAppInformation *)doCopyAppId:(NSString *)appId appName:(NSString *)appName version:(NSString *)version __attribute__((swift_name("doCopy(appId:appName:version:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *appId __attribute__((swift_name("appId")));
@property (readonly) NSString *appName __attribute__((swift_name("appName")));
@property (readonly) NSString *version __attribute__((swift_name("version")));
@end

__attribute__((swift_name("TerminalCore")))
@interface TCCTerminalCore<T> : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)addOperationTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("addOperation(terminalOperation:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkVersionWithCompletionHandler:(void (^)(TCCLatestVersion * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkVersion(completionHandler:)")));

/**
 * Get the connection state
 * @return the connection state
 */
- (id<TCCKotlinx_coroutines_coreFlow>)connectionStateTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("connectionState(terminalOperation:)")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("disconnect(terminalOperation:)")));

/**
 * Send the payload to the EDC
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)doActionActionJob:(TCCActionJob *)actionJob terminalOperation:(TCCTerminalOperation *)terminalOperation payload:(TCCAction *)payload device:(TCCTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:terminalOperation:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<TCCKotlinx_coroutines_coreJob>)observeConnectionTerminalOperation:(TCCTerminalOperation *)terminalOperation onResult:(void (^)(TCCConnectionState *))onResult __attribute__((swift_name("observeConnection(terminalOperation:onResult:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<TCCKotlinx_coroutines_coreJob>)observeConnectionScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope terminalOperation:(TCCTerminalOperation *)terminalOperation onResult:(void (^)(TCCConnectionState *))onResult __attribute__((swift_name("observeConnection(scope:terminalOperation:onResult:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<TCCKotlinx_coroutines_coreJob>)observePayloadScope:(id<TCCKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable))onResult __attribute__((swift_name("observePayload(scope:onResult:)")));

/**
 * Set device IP address
 */
- (void)setDeviceIpAddressDeviceIpAddress:(NSString *)deviceIpAddress __attribute__((swift_name("setDeviceIpAddress(deviceIpAddress:)")));

/**
 * Set the log level
 */
- (void)setLogLevelLevel:(TCCLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));

/**
 * to enable test environment
 */
- (void)setTerminalModeMode:(TCCTerminalMode *)mode __attribute__((swift_name("setTerminalMode(mode:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (T)transformValueJson:(NSString * _Nullable)json __attribute__((swift_name("transformValue(json:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (T)transformValueJson_:(TCCKotlinx_serialization_jsonJsonPrimitive * _Nullable)json __attribute__((swift_name("transformValue(json_:)")));

/**
 * Use the WIFI connection
 */
- (void)useWifiTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("useWifi(terminalOperation:)")));

/**
 * Get the WIFI state
 * @return the WIFI state
 */
- (id<TCCKotlinx_coroutines_coreFlow>)wifiStateTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("wifiState(terminalOperation:)")));
@property TCCDatabaseHandler *database __attribute__((swift_name("database")));
@property TCCTerminalMode *mode __attribute__((swift_name("mode")));
@property (readonly) TCCInternalNetworkService *networkService __attribute__((swift_name("networkService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppTerminal")))
@interface TCCAppTerminal : TCCTerminalCore<TCCLong *>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (id<TCCKotlinx_coroutines_coreFlow>)connectionStateTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("connectionState(terminalOperation:)")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("disconnect(terminalOperation:)")));

/**
 * Send the payload to the EDC
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)doActionActionJob:(TCCActionJob *)actionJob terminalOperation:(TCCTerminalOperation *)terminalOperation payload:(TCCAction *)payload device:(TCCTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:terminalOperation:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));
- (void)initializeDriver:(TCCDriverFactory *)driver clientKey:(NSString *)clientKey appInfo:(TCCAppInformation *)appInfo mode:(TCCTerminalMode *)mode __attribute__((swift_name("initialize(driver:clientKey:appInfo:mode:)")));

/**
 * Set device IP address
 */
- (void)setDeviceIpAddressDeviceIpAddress:(NSString *)deviceIpAddress __attribute__((swift_name("setDeviceIpAddress(deviceIpAddress:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCLong *)transformValueJson:(NSString * _Nullable)json __attribute__((swift_name("transformValue(json:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCLong *)transformValueJson_:(TCCKotlinx_serialization_jsonJsonPrimitive * _Nullable)json __attribute__((swift_name("transformValue(json_:)")));

/**
 * Use the WIFI connection
 */
- (void)useWifiTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("useWifi(terminalOperation:)")));
- (id<TCCKotlinx_coroutines_coreFlow>)wifiStateTerminalOperation:(TCCTerminalOperation *)terminalOperation __attribute__((swift_name("wifiState(terminalOperation:)")));
@end

__attribute__((swift_name("BaseTerminal")))
@interface TCCBaseTerminal : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)healthCheckWithCompletionHandler:(void (^)(TCCBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("healthCheck(completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)initialize __attribute__((swift_name("initialize()")));

/**
 * Sets the global logging verbosity level for the XenTerminal SDK.
 *
 * Log messages with a level lower than the set [level] will typically be suppressed.
 * For instance, if [LogLevel.INFO] is set, [LogLevel.DEBUG] and [LogLevel.VERBOSE] messages
 * will not be displayed.
 *
 * @param level The desired [LogLevel] to set for the SDK's logging output.
 * Use [LogLevel.OFF] to disable all logging, or [LogLevel.VERBOSE]
 * for the most detailed output.
 */
- (void)setLogLevelLevel:(TCCLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)versionCheckWithCompletionHandler:(void (^)(TCCLatestVersion * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("versionCheck(completionHandler:)")));
@property (readonly) NSString *clientKey __attribute__((swift_name("clientKey")));
@property void (^ _Nullable onInitialize)(void) __attribute__((swift_name("onInitialize")));
@end

__attribute__((swift_name("RuntimeTransacterBase")))
@protocol TCCRuntimeTransacterBase
@required
@end


/**
 * A transaction-aware [SqlDriver] wrapper which can begin a [Transaction] on the current connection.
 */
__attribute__((swift_name("RuntimeTransacter")))
@protocol TCCRuntimeTransacter <TCCRuntimeTransacterBase>
@required

/**
 * Starts a [Transaction] and runs [body] in that transaction.
 *
 * @throws IllegalStateException if [noEnclosing] is true and there is already an active
 *   [Transaction] on this thread.
 */
- (void)transactionNoEnclosing:(BOOL)noEnclosing body:(void (^)(id<TCCRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(noEnclosing:body:)")));

/**
 * Starts a [Transaction] and runs [bodyWithReturn] in that transaction.
 *
 * @throws IllegalStateException if [noEnclosing] is true and there is already an active
 *   [Transaction] on this thread.
 */
- (id _Nullable)transactionWithResultNoEnclosing:(BOOL)noEnclosing bodyWithReturn:(id _Nullable (^)(id<TCCRuntimeTransactionWithReturn>))bodyWithReturn __attribute__((swift_name("transactionWithResult(noEnclosing:bodyWithReturn:)")));
@end

__attribute__((swift_name("Database")))
@protocol TCCDatabase <TCCRuntimeTransacter>
@required
@property (readonly) TCCServiceQueries *serviceQueries __attribute__((swift_name("serviceQueries")));
@property (readonly) TCCTerminalQueries *terminalQueries __attribute__((swift_name("terminalQueries")));
@property (readonly) TCCTransactionQueries *transactionQueries __attribute__((swift_name("transactionQueries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseCompanion")))
@interface TCCDatabaseCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCDatabaseCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCDatabase>)invokeDriver:(id<TCCRuntimeSqlDriver>)driver __attribute__((swift_name("invoke(driver:)")));
@property (readonly) id<TCCRuntimeSqlSchema> Schema __attribute__((swift_name("Schema")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NetInterface")))
@interface TCCNetInterface : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)netInterface __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCNetInterface *shared __attribute__((swift_name("shared")));
- (NSSet<NSString *> *)getAddresses __attribute__((swift_name("getAddresses()")));
- (NSString *)getLocalAddress __attribute__((swift_name("getLocalAddress()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalApp")))
@interface TCCTerminalApp : TCCBaseTerminal
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalApp __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTerminalApp *shared __attribute__((swift_name("shared")));
- (void)initializeClientKey:(NSString *)clientKey mode:(TCCTerminalMode *)mode __attribute__((swift_name("initialize(clientKey:mode:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TimeoutType")))
@interface TCCTimeoutType : TCCKotlinEnum<TCCTimeoutType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCTimeoutTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCTimeoutType *card __attribute__((swift_name("card")));
@property (class, readonly) TCCTimeoutType *qr __attribute__((swift_name("qr")));
+ (TCCKotlinArray<TCCTimeoutType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCTimeoutType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TimeoutType.Companion")))
@interface TCCTimeoutTypeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTimeoutTypeCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("WifiScannerService")))
@interface TCCWifiScannerService : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)scan __attribute__((swift_name("scan()")));
@end

__attribute__((swift_name("ResultListener")))
@protocol TCCResultListener
@required
- (void)invokeData:(TCCTerminalResult * _Nullable)data error:(TCCErrorData * _Nullable)error __attribute__((swift_name("invoke(data:error:)")));
@end


/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Action.Companion")))
@interface TCCActionCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCActionCompanion *shared __attribute__((swift_name("shared")));

/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * Abstract base class representing a generic terminal action.
 *
 * Encapsulates the data required to perform an action on the terminal, such as a payment or void.
 * Subclasses or implementations should provide mechanisms to extract specific fields like amount,
 * order ID, and payment methods from the underlying data map.
 *
 * @property data A map containing the raw JSON data associated with the action.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BluetoothData")))
@interface TCCBluetoothData<T> : TCCBase
- (instancetype)initWithName:(NSString *)name address:(NSString *)address uuids:(TCCKotlinArray<NSString *> * _Nullable)uuids alias:(NSString * _Nullable)alias connected:(BOOL)connected data:(T _Nullable)data __attribute__((swift_name("init(name:address:uuids:alias:connected:data:)"))) __attribute__((objc_designated_initializer));
- (TCCBluetoothData<T> *)doCopyName:(NSString *)name address:(NSString *)address uuids:(TCCKotlinArray<NSString *> * _Nullable)uuids alias:(NSString * _Nullable)alias connected:(BOOL)connected data:(T _Nullable)data __attribute__((swift_name("doCopy(name:address:uuids:alias:connected:data:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *address __attribute__((swift_name("address")));
@property (readonly) NSString * _Nullable alias __attribute__((swift_name("alias")));
@property (readonly) BOOL connected __attribute__((swift_name("connected")));
@property (readonly) T _Nullable data __attribute__((swift_name("data")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) TCCKotlinArray<NSString *> * _Nullable uuids __attribute__((swift_name("uuids")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ConnectionState")))
@interface TCCConnectionState : TCCKotlinEnum<TCCConnectionState *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCConnectionState *connected __attribute__((swift_name("connected")));
@property (class, readonly) TCCConnectionState *disconnected __attribute__((swift_name("disconnected")));
@property (class, readonly) TCCConnectionState *unknown __attribute__((swift_name("unknown")));
@property (class, readonly) TCCConnectionState *connecting __attribute__((swift_name("connecting")));
@property (class, readonly) TCCConnectionState *connectingFailed __attribute__((swift_name("connectingFailed")));
@property (class, readonly) TCCConnectionState *unsupported __attribute__((swift_name("unsupported")));
@property (class, readonly) TCCConnectionState *unreachable __attribute__((swift_name("unreachable")));
+ (TCCKotlinArray<TCCConnectionState *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCConnectionState *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ConnectionType")))
@interface TCCConnectionType : TCCKotlinEnum<TCCConnectionType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCConnectionType *usb __attribute__((swift_name("usb")));
@property (class, readonly) TCCConnectionType *bluetooth __attribute__((swift_name("bluetooth")));
@property (class, readonly) TCCConnectionType *wifi __attribute__((swift_name("wifi")));
+ (TCCKotlinArray<TCCConnectionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCConnectionType *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/ErrorCode.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorCode")))
@interface TCCErrorCode : TCCKotlinEnum<TCCErrorCode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCErrorCodeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCErrorCode *invalidCredential __attribute__((swift_name("invalidCredential")));
@property (class, readonly) TCCErrorCode *invalidRequest __attribute__((swift_name("invalidRequest")));
@property (class, readonly) TCCErrorCode *internalServerError __attribute__((swift_name("internalServerError")));
@property (class, readonly) TCCErrorCode *unknownError __attribute__((swift_name("unknownError")));
@property (class, readonly) TCCErrorCode *keyInvalid __attribute__((swift_name("keyInvalid")));
@property (class, readonly) TCCErrorCode *sendFailed __attribute__((swift_name("sendFailed")));
@property (class, readonly) TCCErrorCode *notConnected __attribute__((swift_name("notConnected")));
@property (class, readonly) TCCErrorCode *failedToConnect __attribute__((swift_name("failedToConnect")));
@property (class, readonly) TCCErrorCode *unsupported __attribute__((swift_name("unsupported")));
@property (class, readonly) TCCErrorCode *terminalBusy __attribute__((swift_name("terminalBusy")));
@property (class, readonly) TCCErrorCode *encryptionFailed __attribute__((swift_name("encryptionFailed")));
@property (class, readonly) TCCErrorCode *declinedByReader __attribute__((swift_name("declinedByReader")));
@property (class, readonly) TCCErrorCode *paymentUnpaid __attribute__((swift_name("paymentUnpaid")));
@property (class, readonly) TCCErrorCode *duplicated __attribute__((swift_name("duplicated")));
@property (class, readonly) TCCErrorCode *cancelled __attribute__((swift_name("cancelled")));
@property (class, readonly) TCCErrorCode *timeout __attribute__((swift_name("timeout")));
@property (class, readonly) TCCErrorCode *noDataFound __attribute__((swift_name("noDataFound")));
@property (class, readonly) TCCErrorCode *voidFailed __attribute__((swift_name("voidFailed")));
@property (class, readonly) TCCErrorCode *refunded __attribute__((swift_name("refunded")));
@property (class, readonly) TCCErrorCode *needDoSettlement __attribute__((swift_name("needDoSettlement")));
@property (class, readonly) TCCErrorCode *chipCardDetected __attribute__((swift_name("chipCardDetected")));
@property (class, readonly) TCCErrorCode *transactionFailed __attribute__((swift_name("transactionFailed")));
@property (class, readonly) TCCErrorCode *tidNotSet __attribute__((swift_name("tidNotSet")));
@property (class, readonly) TCCErrorCode *tidNotMatch __attribute__((swift_name("tidNotMatch")));
@property (class, readonly) TCCErrorCode *authenticationFailed __attribute__((swift_name("authenticationFailed")));
@property (class, readonly) TCCErrorCode *wrongPin __attribute__((swift_name("wrongPin")));
@property (class, readonly) TCCErrorCode *dataNotFound __attribute__((swift_name("dataNotFound")));
@property (class, readonly) TCCErrorCode *tidNotFound __attribute__((swift_name("tidNotFound")));
@property (class, readonly) TCCErrorCode *cardExpired __attribute__((swift_name("cardExpired")));
@property (class, readonly) TCCErrorCode *insufficientFunds __attribute__((swift_name("insufficientFunds")));
@property (class, readonly) TCCErrorCode *declinedByIssuer __attribute__((swift_name("declinedByIssuer")));
@property (class, readonly) TCCErrorCode *invalidCard __attribute__((swift_name("invalidCard")));
@property (class, readonly) TCCErrorCode *stolenCard __attribute__((swift_name("stolenCard")));
@property (class, readonly) TCCErrorCode *pinTriesExceeded __attribute__((swift_name("pinTriesExceeded")));
@property (class, readonly) TCCErrorCode *badBatchNumber __attribute__((swift_name("badBatchNumber")));
@property (class, readonly) TCCErrorCode *originalTransactionNotFound __attribute__((swift_name("originalTransactionNotFound")));
@property (class, readonly) TCCErrorCode *issuerInoperative __attribute__((swift_name("issuerInoperative")));
@property (class, readonly) TCCErrorCode *unableToRoute __attribute__((swift_name("unableToRoute")));
@property (class, readonly) TCCErrorCode *actionCannotBeCompleted __attribute__((swift_name("actionCannotBeCompleted")));
@property (class, readonly) TCCErrorCode *serviceUnavailable __attribute__((swift_name("serviceUnavailable")));
@property (class, readonly) TCCErrorCode *illegalParameter __attribute__((swift_name("illegalParameter")));
@property (class, readonly) TCCErrorCode *reconcileError __attribute__((swift_name("reconcileError")));
@property (class, readonly) TCCErrorCode *transactionNotAllowed __attribute__((swift_name("transactionNotAllowed")));
+ (TCCKotlinArray<TCCErrorCode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCErrorCode *> *entries __attribute__((swift_name("entries")));
- (TCCErrorData *)toErrorMessage:(NSString * _Nullable)message __attribute__((swift_name("toError(message:)")));
- (TCCResult<id> *)toResultMessage:(NSString * _Nullable)message data:(id _Nullable)data __attribute__((swift_name("toResult(message:data:)")));
@property (readonly) int32_t code __attribute__((swift_name("code")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorCode.Companion")))
@interface TCCErrorCodeCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCErrorCodeCompanion *shared __attribute__((swift_name("shared")));
- (TCCErrorCode *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCErrorCode *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorData")))
@interface TCCErrorData : TCCBase
- (instancetype)initWithCode:(TCCErrorCode *)code message:(NSString * _Nullable)message __attribute__((swift_name("init(code:message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCErrorDataCompanion *companion __attribute__((swift_name("companion")));
- (TCCErrorData *)doCopyCode:(TCCErrorCode *)code message:(NSString * _Nullable)message __attribute__((swift_name("doCopy(code:message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
- (TCCResult<id> *)transform __attribute__((swift_name("transform()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) TCCErrorCode *code __attribute__((swift_name("code")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorData.Companion")))
@interface TCCErrorDataCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCErrorDataCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("GenericPaymentMethod")))
@interface TCCGenericPaymentMethod : TCCKotlinEnum<TCCGenericPaymentMethod *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCGenericPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCGenericPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) TCCGenericPaymentMethod *qr __attribute__((swift_name("qr")));
@property (class, readonly) TCCGenericPaymentMethod *brizzi __attribute__((swift_name("brizzi")));
+ (TCCKotlinArray<TCCGenericPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCGenericPaymentMethod *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("GenericPaymentMethod.Companion")))
@interface TCCGenericPaymentMethodCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCGenericPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PaymentMethodCompanion")))
@interface TCCPaymentMethodCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCPaymentMethod>)fromValueValue:(NSString *)value __attribute__((swift_name("fromValue(value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end


/**
 * Custom KSerializer to handle PaymentMethod serialization using the `value` property.
 * Equivalent to a Gson TypeAdapter.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PaymentMethodSerializer")))
@interface TCCPaymentMethodSerializer : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Custom KSerializer to handle PaymentMethod serialization using the `value` property.
 * Equivalent to a Gson TypeAdapter.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)paymentMethodSerializer __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCPaymentMethodSerializer *shared __attribute__((swift_name("shared")));
- (id<TCCPaymentMethod>)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(id<TCCPaymentMethod>)value __attribute__((swift_name("serialize(encoder:value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Result")))
@interface TCCResult<T> : TCCBase
- (TCCResult<id> *)mapBlock:(id _Nullable (^)(T _Nullable))block __attribute__((swift_name("map(block:)")));
@property (readonly) T _Nullable data __attribute__((swift_name("data")));
@property (readonly) TCCErrorData * _Nullable error __attribute__((swift_name("error")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultError")))
@interface TCCResultError<T> : TCCResult<T>
- (instancetype)initWithData:(T _Nullable)data error:(TCCErrorData * _Nullable)error __attribute__((swift_name("init(data:error:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultIdle")))
@interface TCCResultIdle<T> : TCCResult<T>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultSuccess")))
@interface TCCResultSuccess<T> : TCCResult<T>
- (instancetype)initWithData:(T _Nullable)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Service")))
@interface TCCService : TCCBase
- (instancetype)initWithTransaction_id:(NSString *)transaction_id service_payload:(NSString * _Nullable)service_payload service_type:(NSString * _Nullable)service_type sync_flag:(TCCLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("init(transaction_id:service_payload:service_type:sync_flag:sync_at:)"))) __attribute__((objc_designated_initializer));
- (TCCService *)doCopyTransaction_id:(NSString *)transaction_id service_payload:(NSString * _Nullable)service_payload service_type:(NSString * _Nullable)service_type sync_flag:(TCCLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("doCopy(transaction_id:service_payload:service_type:sync_flag:sync_at:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable service_payload __attribute__((swift_name("service_payload")));
@property (readonly) NSString * _Nullable service_type __attribute__((swift_name("service_type")));
@property (readonly) NSString * _Nullable sync_at __attribute__((swift_name("sync_at")));
@property (readonly) TCCLong * _Nullable sync_flag __attribute__((swift_name("sync_flag")));
@property (readonly) NSString *transaction_id __attribute__((swift_name("transaction_id")));
@end

__attribute__((swift_name("RuntimeBaseTransacterImpl")))
@interface TCCRuntimeBaseTransacterImpl : TCCBase
- (instancetype)initWithDriver:(id<TCCRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));

/**
 * For internal use, creates a string in the format (?, ?, ?) where there are [count] question marks.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (NSString *)createArgumentsCount:(int32_t)count __attribute__((swift_name("createArguments(count:)")));

/**
 * For internal use, notifies the listeners provided by [listenerProvider] that their underlying result set has
 * changed.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)notifyQueriesIdentifier:(int32_t)identifier tableProvider:(void (^)(TCCKotlinUnit *(^)(NSString *)))tableProvider __attribute__((swift_name("notifyQueries(identifier:tableProvider:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (id _Nullable)postTransactionCleanupTransaction:(TCCRuntimeTransacterTransaction *)transaction enclosing:(TCCRuntimeTransacterTransaction * _Nullable)enclosing thrownException:(TCCKotlinThrowable * _Nullable)thrownException returnValue:(id _Nullable)returnValue __attribute__((swift_name("postTransactionCleanup(transaction:enclosing:thrownException:returnValue:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TCCRuntimeSqlDriver> driver __attribute__((swift_name("driver")));
@end


/**
 * A transaction-aware [SqlDriver] wrapper which can begin a [Transaction] on the current connection.
 */
__attribute__((swift_name("RuntimeTransacterImpl")))
@interface TCCRuntimeTransacterImpl : TCCRuntimeBaseTransacterImpl <TCCRuntimeTransacter>
- (instancetype)initWithDriver:(id<TCCRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)transactionNoEnclosing:(BOOL)noEnclosing body:(void (^)(id<TCCRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(noEnclosing:body:)")));
- (id _Nullable)transactionWithResultNoEnclosing:(BOOL)noEnclosing bodyWithReturn:(id _Nullable (^)(id<TCCRuntimeTransactionWithReturn>))bodyWithReturn __attribute__((swift_name("transactionWithResult(noEnclosing:bodyWithReturn:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceQueries")))
@interface TCCServiceQueries : TCCRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<TCCRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)deleteSync __attribute__((swift_name("deleteSync()")));
- (void)insertService:(TCCService *)Service __attribute__((swift_name("insert(Service:)")));
- (void)replaceService:(TCCService *)Service __attribute__((swift_name("replace(Service:)")));
- (TCCRuntimeQuery<TCCService *> *)selectByIdTransaction_id:(NSString *)transaction_id __attribute__((swift_name("selectById(transaction_id:)")));
- (TCCRuntimeQuery<id> *)selectByIdTransaction_id:(NSString *)transaction_id mapper:(id (^)(NSString *, NSString * _Nullable, NSString * _Nullable, TCCLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectById(transaction_id:mapper:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/Status.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Status")))
@interface TCCStatus : TCCKotlinEnum<TCCStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCStatusCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCStatus *success __attribute__((swift_name("success")));
@property (class, readonly) TCCStatus *failed __attribute__((swift_name("failed")));
@property (class, readonly) TCCStatus *unknown __attribute__((swift_name("unknown")));
+ (TCCKotlinArray<TCCStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCStatus *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Status.Companion")))
@interface TCCStatusCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCStatusCompanion *shared __attribute__((swift_name("shared")));
- (TCCStatus *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCStatus *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCStatus *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Terminal")))
@interface TCCTerminal : TCCBase
- (instancetype)initWithTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("init(tid:actualTid:ipAddress:)"))) __attribute__((objc_designated_initializer));
- (TCCTerminal *)doCopyTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("doCopy(tid:actualTid:ipAddress:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *actualTid __attribute__((swift_name("actualTid")));
@property (readonly) NSString * _Nullable ipAddress __attribute__((swift_name("ipAddress")));
@property (readonly) NSString *tid __attribute__((swift_name("tid")));
@end

__attribute__((swift_name("TerminalDevice")))
@interface TCCTerminalDevice : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) TCCTerminalDeviceCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isProviderAppAvailableProvider:(TCCTerminalOperation *)provider __attribute__((swift_name("isProviderAppAvailable(provider:)")));
@property (readonly) id<TCCKotlinx_coroutines_coreStateFlow> error __attribute__((swift_name("error")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TCCKotlinx_coroutines_coreMutableStateFlow> errorFlow __attribute__((swift_name("errorFlow")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) NSString *ipAddress __attribute__((swift_name("ipAddress")));
@property int32_t priority __attribute__((swift_name("priority")));
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));
@property (readonly) id<TCCKotlinx_coroutines_coreStateFlow> state __attribute__((swift_name("state")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TCCKotlinx_coroutines_coreMutableStateFlow> stateFlow __attribute__((swift_name("stateFlow")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalDevice.Companion")))
@interface TCCTerminalDeviceCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTerminalDeviceCompanion *shared __attribute__((swift_name("shared")));
- (TCCTerminalDevice *)createId:(NSString *)id ipAddress:(NSString *)ipAddress provider:(NSString *)provider __attribute__((swift_name("create(id:ipAddress:provider:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalProvider")))
@interface TCCTerminalProvider : TCCBase
- (instancetype)initWithName:(NSString *)name currency:(NSString *)currency ports:(NSArray<TCCInt *> *)ports __attribute__((swift_name("init(name:currency:ports:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSString *currency __attribute__((swift_name("currency")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalQueries")))
@interface TCCTerminalQueries : TCCRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<TCCRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (TCCRuntimeQuery<TCCTerminal *> *)getAllTid:(NSString *)tid __attribute__((swift_name("getAll(tid:)")));
- (TCCRuntimeQuery<id> *)getAllTid:(NSString *)tid mapper:(id (^)(NSString *, NSString *, NSString * _Nullable))mapper __attribute__((swift_name("getAll(tid:mapper:)")));
- (TCCRuntimeQuery<TCCTerminal *> *)getAllByIpAddressIpAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("getAllByIpAddress(ipAddress:)")));
- (TCCRuntimeQuery<id> *)getAllByIpAddressIpAddress:(NSString * _Nullable)ipAddress mapper:(id (^)(NSString *, NSString *, NSString * _Nullable))mapper __attribute__((swift_name("getAllByIpAddress(ipAddress:mapper:)")));
- (void)insertTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("insert(tid:actualTid:ipAddress:)")));
- (void)removeTid:(NSString *)tid __attribute__((swift_name("remove(tid:)")));
- (void)removeAll __attribute__((swift_name("removeAll()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalResult")))
@interface TCCTerminalResult : TCCBase
- (instancetype)initWithOrderID:(NSString * _Nullable)orderID terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(TCCDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(TCCStatus * _Nullable)status __attribute__((swift_name("init(orderID:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (TCCTerminalResult *)doCopyOrderID:(NSString * _Nullable)orderID terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(TCCDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(TCCStatus * _Nullable)status __attribute__((swift_name("doCopy(orderID:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) TCCDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString * _Nullable currency __attribute__((swift_name("currency")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderID __attribute__((swift_name("orderID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property (readonly) TCCStatus * _Nullable status __attribute__((swift_name("status")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_reference")
*/
@property (readonly) NSString * _Nullable terminalReference __attribute__((swift_name("terminalReference")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString * _Nullable transactionDate __attribute__((swift_name("transactionDate")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalResult.Companion")))
@interface TCCTerminalResultCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTerminalResultCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionQueries")))
@interface TCCTransactionQueries : TCCRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<TCCRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)deleteSync __attribute__((swift_name("deleteSync()")));
- (void)deleteSyncWithTimeTimestamp:(TCCLong * _Nullable)timestamp __attribute__((swift_name("deleteSyncWithTime(timestamp:)")));
- (void)insertTransactions:(TCCTransactions *)Transactions __attribute__((swift_name("insert(Transactions:)")));
- (void)replaceTransactions:(TCCTransactions *)Transactions __attribute__((swift_name("replace(Transactions:)")));
- (TCCRuntimeQuery<TCCTransactions *> *)selectAll __attribute__((swift_name("selectAll()")));
- (TCCRuntimeQuery<id> *)selectAllMapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, TCCLong * _Nullable, TCCLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAll(mapper:)")));
- (TCCRuntimeQuery<TCCTransactions *> *)selectAllWithStatusAndActionStatuses:(id)statuses actions:(id)actions __attribute__((swift_name("selectAllWithStatusAndAction(statuses:actions:)")));
- (TCCRuntimeQuery<id> *)selectAllWithStatusAndActionStatuses:(id)statuses actions:(id)actions mapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, TCCLong * _Nullable, TCCLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAllWithStatusAndAction(statuses:actions:mapper:)")));
- (TCCRuntimeQuery<TCCTransactions *> *)selectAllWithStatusAndActionAndRangeStatuses:(id)statuses actions:(id)actions from:(TCCLong * _Nullable)from end:(TCCLong * _Nullable)end __attribute__((swift_name("selectAllWithStatusAndActionAndRange(statuses:actions:from:end:)")));
- (TCCRuntimeQuery<id> *)selectAllWithStatusAndActionAndRangeStatuses:(id)statuses actions:(id)actions from:(TCCLong * _Nullable)from end:(TCCLong * _Nullable)end mapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, TCCLong * _Nullable, TCCLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAllWithStatusAndActionAndRange(statuses:actions:from:end:mapper:)")));
- (TCCRuntimeQuery<TCCTransactions *> *)selectUnsync __attribute__((swift_name("selectUnsync()")));
- (TCCRuntimeQuery<id> *)selectUnsyncMapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, TCCLong * _Nullable, TCCLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectUnsync(mapper:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Transactions")))
@interface TCCTransactions : TCCBase
- (instancetype)initWithId:(NSString *)id transactionId:(NSString *)transactionId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId provider:(NSString * _Nullable)provider action:(NSString *)action request_payload:(NSString *)request_payload response_payload:(NSString *)response_payload tid:(NSString *)tid status:(NSString *)status timestamp:(TCCLong * _Nullable)timestamp sync_flag:(TCCLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("init(id:transactionId:orderId:paymentRequestId:provider:action:request_payload:response_payload:tid:status:timestamp:sync_flag:sync_at:)"))) __attribute__((objc_designated_initializer));
- (TCCTransactions *)doCopyId:(NSString *)id transactionId:(NSString *)transactionId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId provider:(NSString * _Nullable)provider action:(NSString *)action request_payload:(NSString *)request_payload response_payload:(NSString *)response_payload tid:(NSString *)tid status:(NSString *)status timestamp:(TCCLong * _Nullable)timestamp sync_flag:(TCCLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("doCopy(id:transactionId:orderId:paymentRequestId:provider:action:request_payload:response_payload:tid:status:timestamp:sync_flag:sync_at:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *action __attribute__((swift_name("action")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));
@property (readonly) NSString * _Nullable paymentRequestId __attribute__((swift_name("paymentRequestId")));
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));
@property (readonly) NSString *request_payload __attribute__((swift_name("request_payload")));
@property (readonly) NSString *response_payload __attribute__((swift_name("response_payload")));
@property (readonly) NSString *status __attribute__((swift_name("status")));
@property (readonly) NSString * _Nullable sync_at __attribute__((swift_name("sync_at")));
@property (readonly) TCCLong * _Nullable sync_flag __attribute__((swift_name("sync_flag")));
@property (readonly) NSString *tid __attribute__((swift_name("tid")));
@property (readonly) TCCLong * _Nullable timestamp __attribute__((swift_name("timestamp")));
@property (readonly) NSString *transactionId __attribute__((swift_name("transactionId")));
@end


/**
 * Represents an action that is not supported by the current implementation.
 *
 * Used as a fallback or placeholder when an action cannot be processed.
 * All data retrieval methods return default empty or null values.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("UnsupportedAction")))
@interface TCCUnsupportedAction : TCCAction

/**
 * Represents an action that is not supported by the current implementation.
 *
 * Used as a fallback or placeholder when an action cannot be processed.
 * All data retrieval methods return default empty or null values.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Represents an action that is not supported by the current implementation.
 *
 * Used as a fallback or placeholder when an action cannot be processed.
 * All data retrieval methods return default empty or null values.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (NSString * _Nullable)getPaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (id<TCCTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end

__attribute__((swift_name("WithPort")))
@protocol TCCWithPort
@required
- (NSString *)getPort __attribute__((swift_name("getPort()")));
- (void)setPortValue:(NSString *)value __attribute__((swift_name("setPort(value:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CheckVersionRequest")))
@interface TCCCheckVersionRequest : TCCBase
- (instancetype)initWithCurrentVersion:(NSString *)currentVersion platform:(NSString *)platform __attribute__((swift_name("init(currentVersion:platform:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCCheckVersionRequestCompanion *companion __attribute__((swift_name("companion")));
- (TCCCheckVersionRequest *)doCopyCurrentVersion:(NSString *)currentVersion platform:(NSString *)platform __attribute__((swift_name("doCopy(currentVersion:platform:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="current_version")
*/
@property (readonly) NSString *currentVersion __attribute__((swift_name("currentVersion")));
@property (readonly) NSString *platform __attribute__((swift_name("platform")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CheckVersionRequest.Companion")))
@interface TCCCheckVersionRequestCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCCheckVersionRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((swift_name("TransactionsRequestPayload")))
@interface TCCTransactionsRequestPayload : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCTransactionsRequestPayloadCompanion *companion __attribute__((swift_name("companion")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogsRequest")))
@interface TCCLogsRequest : TCCTransactionsRequestPayload
- (instancetype)initWithSerialNumber:(NSString *)serialNumber payload:(TCCKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("init(serialNumber:payload:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCLogsRequestCompanion *companion __attribute__((swift_name("companion")));
- (TCCLogsRequest *)doCopySerialNumber:(NSString *)serialNumber payload:(TCCKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("doCopy(serialNumber:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payload")
*/
@property (readonly) TCCKotlinx_serialization_jsonJsonElement *payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogsRequest.Companion")))
@interface TCCLogsRequestCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCLogsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RawTransactionsRequest")))
@interface TCCRawTransactionsRequest : TCCBase
- (instancetype)initWithTerminalId:(NSString *)terminalId payload:(TCCKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("init(terminalId:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCRawTransactionsRequestCompanion *companion __attribute__((swift_name("companion")));
- (TCCRawTransactionsRequest *)doCopyTerminalId:(NSString *)terminalId payload:(TCCKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("doCopy(terminalId:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCKotlinx_serialization_jsonJsonElement *payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RawTransactionsRequest.Companion")))
@interface TCCRawTransactionsRequestCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCRawTransactionsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationRequest")))
@interface TCCSimulationRequest : TCCBase
- (instancetype)initWithOrderId:(NSString * _Nullable)orderId terminalId:(NSString *)terminalId paymentMethod:(NSString *)paymentMethod amount:(double)amount currency:(NSString *)currency __attribute__((swift_name("init(orderId:terminalId:paymentMethod:amount:currency:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCSimulationRequestCompanion *companion __attribute__((swift_name("companion")));
- (TCCSimulationRequest *)doCopyOrderId:(NSString * _Nullable)orderId terminalId:(NSString *)terminalId paymentMethod:(NSString *)paymentMethod amount:(double)amount currency:(NSString *)currency __attribute__((swift_name("doCopy(orderId:terminalId:paymentMethod:amount:currency:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The total transaction amount.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) double amount __attribute__((swift_name("amount")));

/**
 * The currency for the transaction.
 * Supported values: IDR, VND, THB.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString *currency __attribute__((swift_name("currency")));

/**
 * Order ID. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * Payment method based on the provider.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * The unique identifier for the terminal.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationRequest.Companion")))
@interface TCCSimulationRequestCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSimulationRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequest")))
@interface TCCTransactionsRequest<T> : TCCBase
- (instancetype)initWithTerminalId:(NSString *)terminalId payload:(T)payload __attribute__((swift_name("init(terminalId:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCTransactionsRequestCompanion *companion __attribute__((swift_name("companion")));
- (TCCTransactionsRequest<T> *)doCopyTerminalId:(NSString *)terminalId payload:(T)payload __attribute__((swift_name("doCopy(terminalId:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) T payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequestCompanion")))
@interface TCCTransactionsRequestCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTransactionsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeSerial0:(id<TCCKotlinx_serialization_coreKSerializer>)typeSerial0 __attribute__((swift_name("serializer(typeSerial0:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequestPayload.Companion")))
@interface TCCTransactionsRequestPayloadCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTransactionsRequestPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VerifyRequest")))
@interface TCCVerifyRequest : TCCTransactionsRequestPayload
- (instancetype)initWithSerialNumber:(NSString *)serialNumber paymentMethod:(NSString *)paymentMethod amount:(double)amount __attribute__((swift_name("init(serialNumber:paymentMethod:amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCVerifyRequestCompanion *companion __attribute__((swift_name("companion")));
- (TCCVerifyRequest *)doCopySerialNumber:(NSString *)serialNumber paymentMethod:(NSString *)paymentMethod amount:(double)amount __attribute__((swift_name("doCopy(serialNumber:paymentMethod:amount:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) double amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="serial_number")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VerifyRequest.Companion")))
@interface TCCVerifyRequestCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCVerifyRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Command")))
@interface TCCCommand : TCCBase
- (instancetype)initWithTerminalId:(NSString * _Nullable)terminalId referenceId:(NSString * _Nullable)referenceId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId commandId:(NSString * _Nullable)commandId type:(TCCCommandType *)type provider:(NSString * _Nullable)provider created:(NSString * _Nullable)created rawPayload:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)rawPayload data:(id<TCCCommandPayload>)data __attribute__((swift_name("init(terminalId:referenceId:orderId:paymentRequestId:commandId:type:provider:created:rawPayload:data:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCCommandCompanion *companion __attribute__((swift_name("companion")));
- (TCCCommand *)doCopyTerminalId:(NSString * _Nullable)terminalId referenceId:(NSString * _Nullable)referenceId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId commandId:(NSString * _Nullable)commandId type:(TCCCommandType *)type provider:(NSString * _Nullable)provider created:(NSString * _Nullable)created rawPayload:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)rawPayload data:(id<TCCCommandPayload>)data __attribute__((swift_name("doCopy(terminalId:referenceId:orderId:paymentRequestId:commandId:type:provider:created:rawPayload:data:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="command_id")
*/
@property (readonly) NSString * _Nullable commandId __attribute__((swift_name("commandId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="created")
*/
@property (readonly) NSString * _Nullable created __attribute__((swift_name("created")));
@property id<TCCCommandPayload> data __attribute__((swift_name("data")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_request_id")
*/
@property (readonly) NSString * _Nullable paymentRequestId __attribute__((swift_name("paymentRequestId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="provider")
*/
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payload")
*/
@property (readonly) TCCKotlinx_serialization_jsonJsonElement * _Nullable rawPayload __attribute__((swift_name("rawPayload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reference_id")
*/
@property (readonly) NSString * _Nullable referenceId __attribute__((swift_name("referenceId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="type")
*/
@property (readonly) TCCCommandType *type __attribute__((swift_name("type")));
@property (readonly) NSString * _Nullable uniqueID __attribute__((swift_name("uniqueID")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Command.Companion")))
@interface TCCCommandCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCCommandCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandConstants")))
@interface TCCCommandConstants : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)commandConstants __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCCommandConstants *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *COMMAND_ID_PREFIX __attribute__((swift_name("COMMAND_ID_PREFIX")));
@end

__attribute__((swift_name("CommandPayload")))
@protocol TCCCommandPayload
@required

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TCCInt * _Nullable attempts __attribute__((swift_name("attempts")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/response/CommandType.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandType")))
@interface TCCCommandType : TCCKotlinEnum<TCCCommandType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCCommandTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCCommandType *pay __attribute__((swift_name("pay")));
@property (class, readonly) TCCCommandType *refund __attribute__((swift_name("refund")));
@property (class, readonly) TCCCommandType *void_ __attribute__((swift_name("void_")));
@property (class, readonly) TCCCommandType *settle __attribute__((swift_name("settle")));
@property (class, readonly) TCCCommandType *printReceipt __attribute__((swift_name("printReceipt")));
@property (class, readonly) TCCCommandType *unknown __attribute__((swift_name("unknown")));
+ (TCCKotlinArray<TCCCommandType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCCommandType *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandType.Companion")))
@interface TCCCommandTypeCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCCommandTypeCompanion *shared __attribute__((swift_name("shared")));
- (TCCCommandType *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCCommandType *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCCommandType *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Error")))
@interface TCCError : TCCBase
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCErrorCompanion *companion __attribute__((swift_name("companion")));
- (TCCError *)doCopyMessage:(NSString *)message __attribute__((swift_name("doCopy(message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString *message __attribute__((swift_name("message")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Error.Companion")))
@interface TCCErrorCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCErrorCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LatestVersion")))
@interface TCCLatestVersion : TCCBase
- (instancetype)initWithStatus:(TCCVersionStatus *)status latestVersion:(NSString * _Nullable)latestVersion downloadUrl:(NSString * _Nullable)downloadUrl releaseNotes:(NSString * _Nullable)releaseNotes __attribute__((swift_name("init(status:latestVersion:downloadUrl:releaseNotes:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCLatestVersionCompanion *companion __attribute__((swift_name("companion")));
- (TCCLatestVersion *)doCopyStatus:(TCCVersionStatus *)status latestVersion:(NSString * _Nullable)latestVersion downloadUrl:(NSString * _Nullable)downloadUrl releaseNotes:(NSString * _Nullable)releaseNotes __attribute__((swift_name("doCopy(status:latestVersion:downloadUrl:releaseNotes:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="download_url")
*/
@property (readonly) NSString * _Nullable downloadUrl __attribute__((swift_name("downloadUrl")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="latest_version")
*/
@property (readonly) NSString * _Nullable latestVersion __attribute__((swift_name("latestVersion")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="release_notes")
*/
@property (readonly) NSString * _Nullable releaseNotes __attribute__((swift_name("releaseNotes")));
@property (readonly) TCCVersionStatus *status __attribute__((swift_name("status")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LatestVersion.Companion")))
@interface TCCLatestVersionCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCLatestVersionCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PayPayload")))
@interface TCCPayPayload : TCCBase <TCCCommandPayload>
- (instancetype)initWithRequestAmount:(TCCDouble * _Nullable)requestAmount paymentMethods:(NSArray<NSString *> * _Nullable)paymentMethods attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("init(requestAmount:paymentMethods:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCPayPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TCCPayPayload *)doCopyRequestAmount:(TCCDouble * _Nullable)requestAmount paymentMethods:(NSArray<NSString *> * _Nullable)paymentMethods attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("doCopy(requestAmount:paymentMethods:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TCCInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_methods")
*/
@property (readonly) NSArray<NSString *> * _Nullable paymentMethods __attribute__((swift_name("paymentMethods")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="request_amount")
*/
@property (readonly) TCCDouble * _Nullable requestAmount __attribute__((swift_name("requestAmount")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PayPayload.Companion")))
@interface TCCPayPayloadCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCPayPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PrintReceiptPayload")))
@interface TCCPrintReceiptPayload : TCCBase <TCCCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCPrintReceiptPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TCCPrintReceiptPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TCCInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PrintReceiptPayload.Companion")))
@interface TCCPrintReceiptPayloadCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCPrintReceiptPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RefundPayload")))
@interface TCCRefundPayload : TCCBase <TCCCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod requestAmount:(TCCDouble * _Nullable)requestAmount reason:(NSString * _Nullable)reason attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:requestAmount:reason:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCRefundPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TCCRefundPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod requestAmount:(TCCDouble * _Nullable)requestAmount reason:(NSString * _Nullable)reason attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:requestAmount:reason:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TCCInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reason")
*/
@property (readonly) NSString * _Nullable reason __attribute__((swift_name("reason")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="request_amount")
*/
@property (readonly) TCCDouble * _Nullable requestAmount __attribute__((swift_name("requestAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_id")
*/
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RefundPayload.Companion")))
@interface TCCRefundPayloadCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCRefundPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SettlementPayload")))
@interface TCCSettlementPayload : TCCBase <TCCCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCSettlementPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TCCSettlementPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TCCInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SettlementPayload.Companion")))
@interface TCCSettlementPayloadCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSettlementPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationResponse")))
@interface TCCSimulationResponse : TCCBase
- (instancetype)initWithProvider:(NSString * _Nullable)provider orderId:(NSString * _Nullable)orderId terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(TCCDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(NSString * _Nullable)status errorCode:(TCCErrorCode * _Nullable)errorCode message:(NSString * _Nullable)message __attribute__((swift_name("init(provider:orderId:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:errorCode:message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCSimulationResponseCompanion *companion __attribute__((swift_name("companion")));
- (TCCSimulationResponse *)doCopyProvider:(NSString * _Nullable)provider orderId:(NSString * _Nullable)orderId terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(TCCDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(NSString * _Nullable)status errorCode:(TCCErrorCode * _Nullable)errorCode message:(NSString * _Nullable)message __attribute__((swift_name("doCopy(provider:orderId:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:errorCode:message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TCCResult<TCCTerminalResult *> *)toResultOperation:(TCCTerminalOperation *)operation __attribute__((swift_name("toResult(operation:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The total amount of the transaction.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) TCCDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * The currency code for the transaction amount.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString * _Nullable currency __attribute__((swift_name("currency")));

/**
 * An error code if the transaction did not succeed. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) TCCErrorCode * _Nullable errorCode __attribute__((swift_name("errorCode")));

/**
 * A descriptive message about the transaction's result. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * The unique Order ID for the transaction.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * The payment method used, specific to the provider.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * Provider name.
 * Examples: "BRI", "GHL", "ATOM"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="provider")
*/
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));

/**
 * The final status of the transaction.
 * Example: "SUCCESS"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property (readonly) NSString * _Nullable status __attribute__((swift_name("status")));

/**
 * The identifier for the terminal.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * A reference string from the terminal. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_reference")
*/
@property (readonly) NSString * _Nullable terminalReference __attribute__((swift_name("terminalReference")));

/**
 * The date and time of the transaction, preferably in ISO 8601 format.
 * Example: "2025-07-31T05:37:38Z"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString * _Nullable transactionDate __attribute__((swift_name("transactionDate")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationResponse.Companion")))
@interface TCCSimulationResponseCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSimulationResponseCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionResponse")))
@interface TCCTransactionResponse : TCCBase
- (instancetype)initWithCode:(NSString * _Nullable)code errorCode:(NSString * _Nullable)errorCode errors:(NSArray<TCCError *> * _Nullable)errors message:(NSString * _Nullable)message msg:(NSString * _Nullable)msg __attribute__((swift_name("init(code:errorCode:errors:message:msg:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCTransactionResponseCompanion *companion __attribute__((swift_name("companion")));
- (TCCTransactionResponse *)doCopyCode:(NSString * _Nullable)code errorCode:(NSString * _Nullable)errorCode errors:(NSArray<TCCError *> * _Nullable)errors message:(NSString * _Nullable)message msg:(NSString * _Nullable)msg __attribute__((swift_name("doCopy(code:errorCode:errors:message:msg:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable apiCode __attribute__((swift_name("apiCode")));
@property (readonly) NSString * _Nullable apiMessage __attribute__((swift_name("apiMessage")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="code")
*/
@property (readonly) NSString * _Nullable code __attribute__((swift_name("code")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) NSString * _Nullable errorCode __attribute__((swift_name("errorCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="errors")
*/
@property (readonly) NSArray<TCCError *> * _Nullable errors __attribute__((swift_name("errors")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="msg")
*/
@property (readonly) NSString * _Nullable msg __attribute__((swift_name("msg")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionResponse.Companion")))
@interface TCCTransactionResponseCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTransactionResponseCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VersionStatus")))
@interface TCCVersionStatus : TCCKotlinEnum<TCCVersionStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCVersionStatus *upToDate __attribute__((swift_name("upToDate")));
@property (class, readonly) TCCVersionStatus *updateAvailable __attribute__((swift_name("updateAvailable")));
@property (class, readonly) TCCVersionStatus *forceUpdate __attribute__((swift_name("forceUpdate")));
+ (TCCKotlinArray<TCCVersionStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCVersionStatus *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VoidPayload")))
@interface TCCVoidPayload : TCCBase <TCCCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCVoidPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TCCVoidPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TCCInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TCCInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VoidPayload.Companion")))
@interface TCCVoidPayloadCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCVoidPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("AppModule")))
@interface TCCAppModule : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (TCCKtor_client_coreHttpClient *)apiClientTimeoutInSecond:(TCCLong * _Nullable)timeoutInSecond block:(void (^)(TCCKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("apiClient(timeoutInSecond:block:)")));
- (TCCKtor_client_coreHttpClient *)clientBlock:(void (^)(TCCKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("client(block:)")));
- (BOOL)retryRuleException:(TCCKotlinException *)exception __attribute__((swift_name("retryRule(exception:)")));
- (TCCKtor_client_coreHttpClient *)secureClientTimeoutInSecond:(TCCLong * _Nullable)timeoutInSecond block:(void (^)(TCCKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("secureClient(timeoutInSecond:block:)")));
- (void)websocketSettingsConfig:(TCCKtor_client_coreWebSocketsConfig *)config __attribute__((swift_name("websocketSettings(config:)")));
- (TCCKtor_client_coreHttpClient *)wssClientBlock:(void (^)(TCCKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("wssClient(block:)")));
@property (readonly) BOOL isDesktop __attribute__((swift_name("isDesktop")));
@property (readonly) int64_t timeoutInSecond __attribute__((swift_name("timeoutInSecond")));
@end

__attribute__((swift_name("BaseSecurity")))
@interface TCCBaseSecurity : TCCBase
- (instancetype)initWithApiKey:(NSString *)apiKey __attribute__((swift_name("init(apiKey:)"))) __attribute__((objc_designated_initializer));
- (TCCResult<NSString *> *)decryptStrToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(strToEncrypt:)")));
- (TCCResult<NSString *> *)decryptKey:(TCCKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(key:strToEncrypt:)")));
- (TCCResult<NSString *> *)encryptStrToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(strToEncrypt:)")));
- (TCCResult<NSString *> *)encryptKey:(TCCKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(key:strToEncrypt:)")));
@end

__attribute__((swift_name("BluetoothService")))
@protocol TCCBluetoothService
@required
- (void)close __attribute__((swift_name("close()")));
- (void)connect __attribute__((swift_name("connect()")));
- (NSArray<TCCBluetoothData<id> *> *)scan __attribute__((swift_name("scan()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)sendData:(TCCKotlinByteArray *)data completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("send(data:completionHandler:)")));
@property (readonly) id<TCCKotlinx_coroutines_coreFlow> isConnected __attribute__((swift_name("isConnected")));
@property (readonly) id<TCCKotlinx_coroutines_coreFlow> state __attribute__((swift_name("state")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IOSAppModule")))
@interface TCCIOSAppModule : TCCAppModule
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (TCCKtor_client_coreHttpClient *)clientBlock:(void (^)(TCCKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("client(block:)")));
- (BOOL)retryRuleException:(TCCKotlinException *)exception __attribute__((swift_name("retryRule(exception:)")));
- (TCCKtor_client_coreHttpClient *)secureClientTimeoutInSecond:(TCCLong * _Nullable)timeoutInSecond block:(void (^)(TCCKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("secureClient(timeoutInSecond:block:)")));
- (void)websocketSettingsConfig:(TCCKtor_client_coreWebSocketsConfig *)config __attribute__((swift_name("websocketSettings(config:)")));
@end

__attribute__((swift_name("Platform")))
@protocol TCCPlatform
@required
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IOSPlatform")))
@interface TCCIOSPlatform : TCCBase <TCCPlatform>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Security")))
@interface TCCSecurity : TCCBaseSecurity
- (instancetype)initWithApiKey:(NSString *)apiKey __attribute__((swift_name("init(apiKey:)"))) __attribute__((objc_designated_initializer));
- (TCCResult<NSString *> *)decryptKey:(TCCKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(key:strToEncrypt:)")));
- (TCCResult<NSString *> *)encryptKey:(TCCKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(key:strToEncrypt:)")));
@end

__attribute__((swift_name("KotlinRuntimeException")))
@interface TCCKotlinRuntimeException : TCCKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinIllegalStateException")))
@interface TCCKotlinIllegalStateException : TCCKotlinRuntimeException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.4")
*/
__attribute__((swift_name("KotlinCancellationException")))
@interface TCCKotlinCancellationException : TCCKotlinIllegalStateException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * A custom [CancellationException] used to signal a "force cancel" operation.
 *
 * This exception can be thrown to explicitly stop or cancel an ongoing coroutine
 * or operation, indicating that the cancellation was initiated deliberately and
 * not due to a general system-level cancellation. It inherits from [CancellationException]
 * so that it's typically ignored by generic exception handlers (as [CancellationException]s
 * are often used for flow control rather than error conditions) but can be specifically
 * caught if a particular "force cancel" scenario needs to be handled.
 *
 * @param message An optional message providing more detail about the force cancellation.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ForceCancelException")))
@interface TCCForceCancelException : TCCKotlinCancellationException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithCause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end


/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RetryCancellationException")))
@interface TCCRetryCancellationException : TCCKotlinCancellationException

/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((swift_name("BaseProviderAppLauncher")))
@protocol TCCBaseProviderAppLauncher
@required
- (BOOL)isProviderAppAvailablePackageName:(NSString *)packageName __attribute__((swift_name("isProviderAppAvailable(packageName:)")));
@property (readonly) TCCTerminalCommunicationService *communicationService __attribute__((swift_name("communicationService")));
@end

__attribute__((swift_name("TerminalAppLauncherWrapper")))
@protocol TCCTerminalAppLauncherWrapper
@required
- (BOOL)isProviderAppAvailable __attribute__((swift_name("isProviderAppAvailable()")));
@property (readonly) NSString *packageName __attribute__((swift_name("packageName")));
@property id<TCCBaseProviderAppLauncher> _Nullable providerAppLauncher __attribute__((swift_name("providerAppLauncher")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InternalNetworkService")))
@interface TCCInternalNetworkService : TCCBase
- (instancetype)initWithApiUrl:(NSString *)apiUrl __attribute__((swift_name("init(apiUrl:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCInternalNetworkServiceCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandCallbackTerminalId:(NSString *)terminalId request:(TCCKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(TCCTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commandCallback(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandsTerminalIds:(NSArray<NSString *> *)terminalIds completionHandler:(void (^)(TCCResult<NSArray<TCCCommand *> *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commands(terminalIds:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)healthWithCompletionHandler:(void (^)(TCCResult<TCCKotlinUnit *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("health(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)logsRequest:(TCCLogsRequest *)request completionHandler:(void (^)(TCCTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("logs(request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)refundTerminalId:(NSString *)terminalId request:(TCCKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(TCCTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("refund(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)simulationTerminalId:(NSString *)terminalId orderID:(NSString * _Nullable)orderID amount:(double)amount paymentMethod:(NSString *)paymentMethod currency:(NSString *)currency completionHandler:(void (^)(TCCSimulationResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("simulation(terminalId:orderID:amount:paymentMethod:currency:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)transactionsTerminalId:(NSString *)terminalId request:(TCCKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(TCCTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("transactions(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)verifyRequest:(TCCVerifyRequest *)request completionHandler:(void (^)(TCCTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("verify(request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)voidTerminalId:(NSString *)terminalId request:(TCCKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(TCCTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("void(terminalId:request:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InternalNetworkService.Companion")))
@interface TCCInternalNetworkServiceCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCInternalNetworkServiceCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionType")))
@interface TCCTransactionType : TCCKotlinEnum<TCCTransactionType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCTransactionTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCTransactionType *callback __attribute__((swift_name("callback")));
@property (class, readonly) TCCTransactionType *payment __attribute__((swift_name("payment")));
@property (class, readonly) TCCTransactionType *void_ __attribute__((swift_name("void_")));
+ (TCCKotlinArray<TCCTransactionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCTransactionType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionType.Companion")))
@interface TCCTransactionTypeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTransactionTypeCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("UnsupportedCommunicationService")))
@interface TCCUnsupportedCommunicationService : TCCTerminalCommunicationService
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TCCTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
@end

__attribute__((swift_name("BaseDatabaseHandler")))
@interface TCCBaseDatabaseHandler : TCCBase
- (BOOL)isTidMatchTid:(NSString *)tid __attribute__((swift_name("isTidMatch(tid:)")));
@property (readonly) TCCBaseSecurity *security __attribute__((swift_name("security")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseHandler")))
@interface TCCDatabaseHandler : TCCBaseDatabaseHandler
- (instancetype)initWithNetworkService:(TCCInternalNetworkService *)networkService database:(id<TCCDatabase> _Nullable)database security:(TCCBaseSecurity *)security __attribute__((swift_name("init(networkService:database:security:)"))) __attribute__((objc_designated_initializer));
- (TCCService * _Nullable)createServiceDataTerminalOperation:(TCCTerminalOperation *)terminalOperation transactions:(TCCTransactions *)transactions request:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)request response:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)response __attribute__((swift_name("createServiceData(terminalOperation:transactions:request:response:)")));
@property (readonly) id<TCCKotlinx_datetimeDateTimeFormat> dateTimeFormat __attribute__((swift_name("dateTimeFormat")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DriverFactory")))
@interface TCCDriverFactory : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (id<TCCRuntimeSqlDriver> _Nullable)createDriver __attribute__((swift_name("createDriver()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LocalStorage")))
@interface TCCLocalStorage : TCCBase
- (instancetype)initWithTerminals:(TCCMutableDictionary<NSString *, TCCTerminal *> *)terminals transactions:(TCCMutableDictionary<NSString *, TCCTransactions *> *)transactions services:(TCCMutableDictionary<NSString *, TCCService *> *)services __attribute__((swift_name("init(terminals:transactions:services:)"))) __attribute__((objc_designated_initializer));
- (TCCLocalStorage *)doCopyTerminals:(TCCMutableDictionary<NSString *, TCCTerminal *> *)terminals transactions:(TCCMutableDictionary<NSString *, TCCTransactions *> *)transactions services:(TCCMutableDictionary<NSString *, TCCService *> *)services __attribute__((swift_name("doCopy(terminals:transactions:services:)")));
- (void)deleteSyncedTransactions __attribute__((swift_name("deleteSyncedTransactions()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (id)getUnsyncTransactions __attribute__((swift_name("getUnsyncTransactions()")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property TCCMutableDictionary<NSString *, TCCService *> *services __attribute__((swift_name("services")));
@property (readonly) TCCMutableDictionary<NSString *, TCCTerminal *> *terminals __attribute__((swift_name("terminals")));
@property TCCMutableDictionary<NSString *, TCCTransactions *> *transactions __attribute__((swift_name("transactions")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ActionJob")))
@interface TCCActionJob : TCCBase
- (instancetype)initWithOnCancel:(id<TCCKotlinSuspendFunction0>)onCancel onCompleted:(id<TCCKotlinSuspendFunction0>)onCompleted onRefresh:(id<TCCKotlinSuspendFunction0>)onRefresh cancelable:(BOOL)cancelable block:(id<TCCKotlinSuspendFunction1>)block __attribute__((swift_name("init(onCancel:onCompleted:onRefresh:cancelable:block:)"))) __attribute__((objc_designated_initializer));

/**
 * Cancel running SDK job, to allow perform/proceed new action
 */
- (void)cancel __attribute__((swift_name("cancel()")));
- (TCCActionJob *)doCopyOnCancel:(id<TCCKotlinSuspendFunction0>)onCancel onCompleted:(id<TCCKotlinSuspendFunction0>)onCompleted onRefresh:(id<TCCKotlinSuspendFunction0>)onRefresh cancelable:(BOOL)cancelable block:(id<TCCKotlinSuspendFunction1>)block __attribute__((swift_name("doCopy(onCancel:onCompleted:onRefresh:cancelable:block:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isActive __attribute__((swift_name("isActive()")));
- (void)refresh __attribute__((swift_name("refresh()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<TCCKotlinSuspendFunction1> block __attribute__((swift_name("block")));
@property (readonly) id<TCCKotlinSuspendFunction0> onCancel __attribute__((swift_name("onCancel")));
@property (readonly) id<TCCKotlinSuspendFunction0> onCompleted __attribute__((swift_name("onCompleted")));
@property (readonly) id<TCCKotlinSuspendFunction0> onRefresh __attribute__((swift_name("onRefresh")));
@end

__attribute__((swift_name("Kermit_coreLogWriter")))
@interface TCCKermit_coreLogWriter : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (BOOL)isLoggableTag:(NSString *)tag severity:(TCCKermit_coreSeverity *)severity __attribute__((swift_name("isLoggable(tag:severity:)")));
- (void)logSeverity:(TCCKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@end

__attribute__((swift_name("Kermit_ioRollingFileLogWriter")))
@interface TCCKermit_ioRollingFileLogWriter : TCCKermit_coreLogWriter
- (instancetype)initWithConfig:(TCCKermit_ioRollingFileLogWriterConfig *)config messageStringFormatter:(id<TCCKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<TCCKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(TCCKermit_ioRollingFileLogWriterConfig *)config clock:(id<TCCKotlinClock>)clock messageStringFormatter:(id<TCCKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<TCCKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:clock:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (void)logSeverity:(TCCKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CustomRollingFileLogWriter")))
@interface TCCCustomRollingFileLogWriter : TCCKermit_ioRollingFileLogWriter
- (instancetype)initWithConfig:(TCCKermit_ioRollingFileLogWriterConfig *)config onLog:(void (^)(TCCKermit_coreSeverity *, NSString *, NSString *, TCCKotlinThrowable * _Nullable))onLog __attribute__((swift_name("init(config:onLog:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(TCCKermit_ioRollingFileLogWriterConfig *)config messageStringFormatter:(id<TCCKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<TCCKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithConfig:(TCCKermit_ioRollingFileLogWriterConfig *)config clock:(id<TCCKotlinClock>)clock messageStringFormatter:(id<TCCKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<TCCKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:clock:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)logSeverity:(TCCKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@property (readonly) void (^onLog)(TCCKermit_coreSeverity *, NSString *, NSString *, TCCKotlinThrowable * _Nullable) __attribute__((swift_name("onLog")));
@end

__attribute__((swift_name("LoggingLoggerApi")))
@protocol TCCLoggingLoggerApi
@required
- (void)debugTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("debug(tag:msg:)")));
- (void)errorTag:(NSString *)tag msg:(NSString *)msg t:(TCCKotlinThrowable * _Nullable)t __attribute__((swift_name("error(tag:msg:t:)")));
- (void)infoTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("info(tag:msg:)")));
- (void)verboseTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("verbose(tag:msg:)")));
- (void)warnTag:(NSString *)tag msg:(NSString *)msg t:(TCCKotlinThrowable * _Nullable)t __attribute__((swift_name("warn(tag:msg:t:)")));
@end

__attribute__((swift_name("LoggingLogLevelController")))
@protocol TCCLoggingLogLevelController
@required
- (BOOL)isLoggingDebug __attribute__((swift_name("isLoggingDebug()")));
- (BOOL)isLoggingError __attribute__((swift_name("isLoggingError()")));
- (BOOL)isLoggingInfo __attribute__((swift_name("isLoggingInfo()")));
- (BOOL)isLoggingVerbose __attribute__((swift_name("isLoggingVerbose()")));
- (BOOL)isLoggingWarning __attribute__((swift_name("isLoggingWarning()")));
@end

__attribute__((swift_name("LoggingLogger")))
@protocol TCCLoggingLogger <TCCLoggingLoggerApi, TCCLoggingLogLevelController>
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DesktopLogger")))
@interface TCCDesktopLogger : TCCBase <TCCLoggingLogger>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)debugTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("debug(tag:msg:)")));
- (void)errorTag:(NSString *)tag msg:(NSString *)msg t:(TCCKotlinThrowable * _Nullable)t __attribute__((swift_name("error(tag:msg:t:)")));
- (void)infoTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("info(tag:msg:)")));
- (BOOL)isLoggingDebug __attribute__((swift_name("isLoggingDebug()")));
- (BOOL)isLoggingError __attribute__((swift_name("isLoggingError()")));
- (BOOL)isLoggingInfo __attribute__((swift_name("isLoggingInfo()")));
- (BOOL)isLoggingVerbose __attribute__((swift_name("isLoggingVerbose()")));
- (BOOL)isLoggingWarning __attribute__((swift_name("isLoggingWarning()")));
- (void)verboseTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("verbose(tag:msg:)")));
- (void)warnTag:(NSString *)tag msg:(NSString *)msg t:(TCCKotlinThrowable * _Nullable)t __attribute__((swift_name("warn(tag:msg:t:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogLevel")))
@interface TCCLogLevel : TCCKotlinEnum<TCCLogLevel *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCLogLevel *off __attribute__((swift_name("off")));
@property (class, readonly) TCCLogLevel *info __attribute__((swift_name("info")));
@property (class, readonly) TCCLogLevel *debug __attribute__((swift_name("debug")));
@property (class, readonly) TCCLogLevel *verbose __attribute__((swift_name("verbose")));
+ (TCCKotlinArray<TCCLogLevel *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCLogLevel *> *entries __attribute__((swift_name("entries")));

/**
 * The internal integer representation of the log level, used for comparison and filtering.
 * A higher integer value generally indicates a more verbose log level.
 */
- (TCCKermit_coreSeverity *)toLevel __attribute__((swift_name("toLevel()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalMode")))
@interface TCCTerminalMode : TCCKotlinEnum<TCCTerminalMode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCTerminalMode *live __attribute__((swift_name("live")));
@property (class, readonly) TCCTerminalMode *integration __attribute__((swift_name("integration")));
+ (TCCKotlinArray<TCCTerminalMode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCTerminalMode *> *entries __attribute__((swift_name("entries")));
@property (readonly) BOOL mock __attribute__((swift_name("mock")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("XLogger")))
@interface TCCXLogger : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) TCCXLoggerCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("XLogger.Companion")))
@interface TCCXLoggerCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCXLoggerCompanion *shared __attribute__((swift_name("shared")));
- (void)debugMessage:(NSString *)message __attribute__((swift_name("debug(message:)")));
- (void)errorE:(TCCKotlinException *)e __attribute__((swift_name("error(e:)")));
- (void)errorMessage:(NSString *)message __attribute__((swift_name("error(message:)")));
- (void)errorMessage:(NSString *)message e:(TCCKotlinException *)e __attribute__((swift_name("error(message:e:)")));
- (void)infoBlock:(NSString *(^)(void))block __attribute__((swift_name("info(block:)")));
- (void)infoMessage:(NSString *)message __attribute__((swift_name("info(message:)")));
- (void)logToFilePath:(TCCKotlinx_io_corePath *)path onLog:(void (^)(TCCKermit_coreSeverity *, NSString *, NSString *, TCCKotlinThrowable * _Nullable))onLog __attribute__((swift_name("logToFile(path:onLog:)")));
- (void)setLogLevelLevel:(TCCLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));
@property (readonly) NSString *LOG_FILE_NAME __attribute__((swift_name("LOG_FILE_NAME")));
@property TCCKermit_ioRollingFileLogWriter * _Nullable fileWriter __attribute__((swift_name("fileWriter")));
@property TCCKermitLogger *log __attribute__((swift_name("log")));
@end


/**
 * Implementation of [TerminalOperation] for NTT (Network Technical Trust) terminals.
 *
 * This class handles communication with NTT devices via WebSocket, maps generic terminal
 * actions to NTT-specific protocols (Sale, Void, PreAuth, etc.), and manages transaction
 * lifecycles. It also handles payload formatting (e.g., amount strings) and backend synchronization.
 */
__attribute__((swift_name("BaseTerminalNTT")))
@interface TCCBaseTerminalNTT : TCCTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(TCCTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Maps a generic [Command.PAY] command to an NTT [NTTAction.Sale] action.
 * Generates a trimmed order ID if necessary and determines the trade type.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCNTTAction * _Nullable)onPayCommand:(TCCCommand *)command data:(TCCPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onPrintReceiptCommand:(TCCCommand *)command data:(TCCPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the status of a transaction.
 * Currently, this is not implemented for NTT terminals and returns null.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCKotlinNothing * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onSettlementCommand:(TCCCommand *)command data:(TCCSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Maps a generic [Command.VOID] command to an NTT [Void] action.
 * Extracts the invoice number from the trace ID.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCNTTAction * _Nullable)onVoidCommand:(TCCCommand *)command data:(TCCVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Pings the terminal device via WebSocket by sending a test transaction type message.
 * Returns true if the connection is successful.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(TCCTerminalDevice *)device completionHandler:(void (^)(TCCBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));

/**
 * Prepares the request payload for the NTT terminal.
 *
 * Specifically handles the [NTTAction.AMOUNT] field by ensuring it is formatted
 * as a string with two decimal places (e.g., "100.00"), which is required by the NTT protocol.
 */
- (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(TCCAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));
- (NSString * _Nullable)terminalIDData:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));
- (NSArray<id<TCCTerminalAction>> *)toActionsCommandType:(TCCCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (TCCGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (TCCResult<TCCTerminalResult *> * _Nullable)toResultTerminalDevice:(TCCTerminalDevice *)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));

/**
 * Converts the raw JSON response from the terminal into a format suitable for backend synchronization.
 * Maps valid success statuses to appropriate transaction types (PAYMENT, VOID, CALLBACK).
 *
 * @param request The original request.
 * @param json The response JSON.
 * @param transactions The transaction context.
 * @return A pair of transaction type name and synchronized payload, or null if sync is not required.
 */
- (TCCKotlinPair<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(TCCKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)json transactions:(TCCTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (TCCTerminalResult * _Nullable)toTerminalResultTerminalDevice:(TCCTerminalDevice * _Nullable)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));
- (TCCTerminalResult *)transformJsonToResultJson:(TCCKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCKotlinNothing * _Nullable bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCNTTWebSocketService *communicationService __attribute__((swift_name("communicationService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalNTT")))
@interface TCCTerminalNTT : TCCBaseTerminalNTT
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalNTT __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTerminalNTT *shared __attribute__((swift_name("shared")));
@end


/**
 * Sealed class representing all supported actions for the NTT (Network Technical Trust) terminal protocol.
 * Maps high-level terminal actions to the specific JSON payload keys (e.g., "transaction_type", "trade_type")
 * required by the NTT WebSocket API.
 */
__attribute__((swift_name("NTTAction")))
@interface TCCNTTAction : TCCAction
- (instancetype)initWithData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCNTTActionCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)getPaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (id<TCCTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.Companion")))
@interface TCCNTTActionCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCNTTActionCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *AMOUNT __attribute__((swift_name("AMOUNT")));
@property (readonly) NSString *INVOICE_NO __attribute__((swift_name("INVOICE_NO")));
@property (readonly) NSString *POS_REF_NO __attribute__((swift_name("POS_REF_NO")));
@property (readonly) NSString *SERVICE_TYPE __attribute__((swift_name("SERVICE_TYPE")));
@property (readonly) NSString *TRADE_TYPE __attribute__((swift_name("TRADE_TYPE")));
@property (readonly) NSString *TRANSACTION_TYPE __attribute__((swift_name("TRANSACTION_TYPE")));
@end


/**
 * Base class for payment-related actions in the NTT protocol.
 *
 * @param orderID The unique identifier for the order (pos_ref_no).
 * @param amount The transaction amount.
 * @param tradeType The type of trade (e.g., CARD, QR).
 * @param serviceType Optional service type (e.g., SCAN, SHOWQR).
 */
__attribute__((swift_name("NTTAction.Payment")))
@interface TCCNTTActionPayment : TCCNTTAction
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/ntt/data/NTTPaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTPaymentMethod")))
@interface TCCNTTPaymentMethod : TCCKotlinEnum<TCCNTTPaymentMethod *> <TCCPaymentMethod>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCNTTPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCNTTPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) TCCNTTPaymentMethod *multiipp __attribute__((swift_name("multiipp")));
@property (class, readonly) TCCNTTPaymentMethod *alipayPlus __attribute__((swift_name("alipayPlus")));
@property (class, readonly) TCCNTTPaymentMethod *wechatpaycil __attribute__((swift_name("wechatpaycil")));
@property (class, readonly) TCCNTTPaymentMethod *wechatpayocgt __attribute__((swift_name("wechatpayocgt")));
@property (class, readonly) TCCNTTPaymentMethod *truemoney __attribute__((swift_name("truemoney")));
@property (class, readonly) TCCNTTPaymentMethod *linepay __attribute__((swift_name("linepay")));
@property (class, readonly) TCCNTTPaymentMethod *shopee __attribute__((swift_name("shopee")));
@property (class, readonly) TCCNTTPaymentMethod *bblQrcs __attribute__((swift_name("bblQrcs")));
@property (class, readonly) TCCNTTPaymentMethod *thaiqrcode __attribute__((swift_name("thaiqrcode")));
@property (class, readonly) TCCNTTPaymentMethod *atome __attribute__((swift_name("atome")));
@property (class, readonly) TCCNTTPaymentMethod *sabuymoney __attribute__((swift_name("sabuymoney")));
@property (class, readonly) TCCNTTPaymentMethod *maxme __attribute__((swift_name("maxme")));
+ (TCCKotlinArray<TCCNTTPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCNTTPaymentMethod *> *entries __attribute__((swift_name("entries")));
- (TCCGenericPaymentMethod *)toPaymentMethod __attribute__((swift_name("toPaymentMethod()")));
@property (readonly) NSArray<NSString *> * _Nullable alternativeValue __attribute__((swift_name("alternativeValue")));
@property (readonly) TCCServiceCapabilities *capabilities __attribute__((swift_name("capabilities")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTPaymentMethod.Companion")))
@interface TCCNTTPaymentMethodCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCNTTPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (TCCNTTPaymentMethod *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (TCCNTTPaymentMethod *)fromTerminalResultResult:(TCCTerminalResult *)result __attribute__((swift_name("fromTerminalResult(result:)")));
- (TCCNTTPaymentMethod * _Nullable)fromValueValue:(NSString *)value __attribute__((swift_name("fromValue(value:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCNTTPaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCNTTPaymentMethod * _Nullable)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalAction")))
@interface TCCNTTTerminalAction : TCCKotlinEnum<TCCNTTTerminalAction *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCNTTTerminalAction *sale __attribute__((swift_name("sale")));
@property (class, readonly) TCCNTTTerminalAction *void_ __attribute__((swift_name("void_")));
+ (TCCKotlinArray<TCCNTTTerminalAction *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCNTTTerminalAction *> *entries __attribute__((swift_name("entries")));
@end


/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalResult")))
@interface TCCNTTTerminalResult : TCCBase
- (instancetype)initWithPosRefNo:(NSString * _Nullable)posRefNo transactionType:(TCCNTTTransactionType * _Nullable)transactionType tradeType:(TCCNTTPaymentMethod * _Nullable)tradeType amount:(TCCDouble * _Nullable)amount responseCode:(NSString * _Nullable)responseCode responseMsg:(NSString * _Nullable)responseMsg terminalId:(NSString * _Nullable)terminalId merchantId:(NSString * _Nullable)merchantId transactionId:(NSString * _Nullable)transactionId invoiceNo:(NSString * _Nullable)invoiceNo cardNo:(NSString * _Nullable)cardNo cardType:(NSString * _Nullable)cardType cardApprovalCode:(NSString * _Nullable)cardApprovalCode ippTerm:(NSString * _Nullable)ippTerm monthlyDue:(TCCDouble * _Nullable)monthlyDue totalDue:(TCCDouble * _Nullable)totalDue paymentDate:(NSString * _Nullable)paymentDate __attribute__((swift_name("init(posRefNo:transactionType:tradeType:amount:responseCode:responseMsg:terminalId:merchantId:transactionId:invoiceNo:cardNo:cardType:cardApprovalCode:ippTerm:monthlyDue:totalDue:paymentDate:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCNTTTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (TCCNTTTerminalResult *)doCopyPosRefNo:(NSString * _Nullable)posRefNo transactionType:(TCCNTTTransactionType * _Nullable)transactionType tradeType:(TCCNTTPaymentMethod * _Nullable)tradeType amount:(TCCDouble * _Nullable)amount responseCode:(NSString * _Nullable)responseCode responseMsg:(NSString * _Nullable)responseMsg terminalId:(NSString * _Nullable)terminalId merchantId:(NSString * _Nullable)merchantId transactionId:(NSString * _Nullable)transactionId invoiceNo:(NSString * _Nullable)invoiceNo cardNo:(NSString * _Nullable)cardNo cardType:(NSString * _Nullable)cardType cardApprovalCode:(NSString * _Nullable)cardApprovalCode ippTerm:(NSString * _Nullable)ippTerm monthlyDue:(TCCDouble * _Nullable)monthlyDue totalDue:(TCCDouble * _Nullable)totalDue paymentDate:(NSString * _Nullable)paymentDate __attribute__((swift_name("doCopy(posRefNo:transactionType:tradeType:amount:responseCode:responseMsg:terminalId:merchantId:transactionId:invoiceNo:cardNo:cardType:cardApprovalCode:ippTerm:monthlyDue:totalDue:paymentDate:)")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TCCErrorCode * _Nullable)toErrorCode __attribute__((swift_name("toErrorCode()")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (NSString *)description __attribute__((swift_name("description()")));
- (TCCTerminalResult *)toTerminalResult __attribute__((swift_name("toTerminalResult()")));

/**
 * Total sale amount.
 * Minimum: 1. Example: 1299.99
 */
@property (readonly) TCCDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * Card approval code. Optional field.
 * Max length: 6 characters. Example: "ABC123"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_approval_code")
*/
@property (readonly) NSString * _Nullable cardApprovalCode __attribute__((swift_name("cardApprovalCode")));

/**
 * Payer's card number. Optional field.
 * Max length: 19 characters. Example: "411111******1111"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_no")
*/
@property (readonly) NSString * _Nullable cardNo __attribute__((swift_name("cardNo")));

/**
 * Type of card. Optional field.
 * Max length: 10 characters. Example: "VISA"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_type")
*/
@property (readonly) NSString * _Nullable cardType __attribute__((swift_name("cardType")));

/**
 * Invoice Number.
 * Max length: 20 characters. Example: "INV20250606-001"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="invoice_no")
*/
@property (readonly) NSString * _Nullable invoiceNo __attribute__((swift_name("invoiceNo")));

/**
 * Installment Payment Plan (IPP) term. Optional field.
 * Max length: 2 characters. Example: "06"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ipp_term")
*/
@property (readonly) NSString * _Nullable ippTerm __attribute__((swift_name("ippTerm")));

/**
 * Merchant Identifier. Optional field.
 * Max length: 15 characters. Example: "MCH123456789012"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_id")
*/
@property (readonly) NSString * _Nullable merchantId __attribute__((swift_name("merchantId")));

/**
 * Monthly due amount for IPP. Optional field.
 * Example: 216.67
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="monthly_due")
*/
@property (readonly) TCCDouble * _Nullable monthlyDue __attribute__((swift_name("monthlyDue")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_date")
*/
@property (readonly) NSString * _Nullable paymentDate __attribute__((swift_name("paymentDate")));

/**
 * Point of Sale Reference Number.
 * Max length: 12 characters. Example: "123456789012"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="pos_ref_no")
*/
@property (readonly) NSString * _Nullable posRefNo __attribute__((swift_name("posRefNo")));

/**
 * Response code from the host.
 * Max length: 2 characters. Example: "00"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="response_code")
*/
@property (readonly) NSString * _Nullable responseCode __attribute__((swift_name("responseCode")));

/**
 * Response message.
 * Max length: 32 characters. Example: "Approved"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="response_msg")
*/
@property (readonly) NSString * _Nullable responseMsg __attribute__((swift_name("responseMsg")));

/**
 * Terminal Identifier.
 * Max length: 8 characters. Example: "TERM1234"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * Total due amount. Optional field.
 * Example: 1300.02
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="total_due")
*/
@property (readonly) TCCDouble * _Nullable totalDue __attribute__((swift_name("totalDue")));

/**
 * Type of payment or trade.
 * Restricted to predefined values in TradeTypeEnum.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="trade_type")
*/
@property (readonly) TCCNTTPaymentMethod * _Nullable tradeType __attribute__((swift_name("tradeType")));

/**
 * Host Transaction Number.
 * Max length: 32 characters. Example: "TXN202506060001"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_id")
*/
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));

/**
 * Type of the transaction.
 * Restricted to predefined values in TransactionTypeEnum.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_type")
*/
@property (readonly) TCCNTTTransactionType * _Nullable transactionType __attribute__((swift_name("transactionType")));
@end


/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalResult.Companion")))
@interface TCCNTTTerminalResultCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCNTTTerminalResultCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Enum representing the type of transaction.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTransactionType")))
@interface TCCNTTTransactionType : TCCKotlinEnum<TCCNTTTransactionType *> <TCCTerminalAction>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enum representing the type of transaction.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCNTTTransactionTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCNTTTransactionType *sale __attribute__((swift_name("sale")));
@property (class, readonly) TCCNTTTransactionType *preauth __attribute__((swift_name("preauth")));
@property (class, readonly) TCCNTTTransactionType *void_ __attribute__((swift_name("void_")));
@property (class, readonly) TCCNTTTransactionType *query __attribute__((swift_name("query")));
@property (class, readonly) TCCNTTTransactionType *precomp __attribute__((swift_name("precomp")));
+ (TCCKotlinArray<TCCNTTTransactionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCNTTTransactionType *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Enum representing the type of transaction.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTransactionType.Companion")))
@interface TCCNTTTransactionTypeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enum representing the type of transaction.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCNTTTransactionTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Enum representing the type of transaction.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * Enum representing the type of transaction.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end


/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceCapabilities")))
@interface TCCServiceCapabilities : TCCBase
- (instancetype)initWithSupportsScan:(BOOL)supportsScan supportsShowQr:(BOOL)supportsShowQr __attribute__((swift_name("init(supportsScan:supportsShowQr:)"))) __attribute__((objc_designated_initializer));
- (TCCServiceCapabilities *)doCopySupportsScan:(BOOL)supportsScan supportsShowQr:(BOOL)supportsShowQr __attribute__((swift_name("doCopy(supportsScan:supportsShowQr:)")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL supportsScan __attribute__((swift_name("supportsScan")));
@property (readonly) BOOL supportsShowQr __attribute__((swift_name("supportsShowQr")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceType")))
@interface TCCServiceType : TCCKotlinEnum<TCCServiceType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCServiceType *scan __attribute__((swift_name("scan")));
@property (class, readonly) TCCServiceType *showqr __attribute__((swift_name("showqr")));
+ (TCCKotlinArray<TCCServiceType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCServiceType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FakeResponseGenerator_")))
@interface TCCFakeResponseGenerator_ : TCCBaseFakeResponseGenerator
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)fakeResponseGenerator __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCFakeResponseGenerator_ *shared __attribute__((swift_name("shared")));
- (NSString *)formatDateTimeDateTime:(TCCKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
- (NSString *)formatToSimpleDateTimeDateTime:(TCCKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatToSimpleDateTime(dateTime:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateRawTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TCCResult<TCCNTTTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generateRaw(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionFakeCode")))
@interface TCCTransactionFakeCode : TCCKotlinEnum<TCCTransactionFakeCode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCTransactionFakeCode *terminalBusy __attribute__((swift_name("terminalBusy")));
@property (class, readonly) TCCTransactionFakeCode *declinedByReader __attribute__((swift_name("declinedByReader")));
@property (class, readonly) TCCTransactionFakeCode *duplicated __attribute__((swift_name("duplicated")));
@property (class, readonly) TCCTransactionFakeCode *cancelled __attribute__((swift_name("cancelled")));
@property (class, readonly) TCCTransactionFakeCode *timeout __attribute__((swift_name("timeout")));
@property (class, readonly) TCCTransactionFakeCode *dataNotFound __attribute__((swift_name("dataNotFound")));
@property (class, readonly) TCCTransactionFakeCode *voidFailed __attribute__((swift_name("voidFailed")));
@property (class, readonly) TCCTransactionFakeCode *needDoSettlement __attribute__((swift_name("needDoSettlement")));
@property (class, readonly) TCCTransactionFakeCode *transactionFailed __attribute__((swift_name("transactionFailed")));
@property (class, readonly) TCCTransactionFakeCode *tidNotMatch __attribute__((swift_name("tidNotMatch")));
@property (class, readonly) TCCTransactionFakeCode *wrongPin __attribute__((swift_name("wrongPin")));
+ (TCCKotlinArray<TCCTransactionFakeCode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCTransactionFakeCode *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSArray<TCCNTTTransactionType *> * _Nullable actions __attribute__((swift_name("actions")));
@property (readonly) id _Nullable amount __attribute__((swift_name("amount")));
@property (readonly) NSString * _Nullable code __attribute__((swift_name("code")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@property (readonly) NSArray<TCCNTTPaymentMethod *> * _Nullable methods __attribute__((swift_name("methods")));
@property (readonly) id _Nullable traceNumber __attribute__((swift_name("traceNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTWebSocketService")))
@interface TCCNTTWebSocketService : TCCWebSocketService
- (instancetype)initWithResultFlow:(id<TCCKotlinx_coroutines_coreMutableStateFlow>)resultFlow shouldRetry:(TCCBoolean *(^)(TCCKotlinException *))shouldRetry builder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:shouldRetry:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * Connect to the EDC
 * @param address the IP address
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TCCTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
@property id<TCCKtor_ioByteWriteChannel> _Nullable output __attribute__((swift_name("output")));
@property TCCMutableDictionary<NSString *, id<TCCKtor_networkSocket>> *sockets __attribute__((swift_name("sockets")));
@end


/**
 * Implementation of [TerminalOperation] for SHC (Soft Space/GHL) terminals.
 *
 * This class interacts with SHC terminals via WebSocket (typically port 8888).
 * It handles:
 * - Specific amount formatting (e.g., padded decimal strings).
 * - Distinguishing between Card and E-Wallet transaction flows.
 * - Session cancellation support.
 * - Mapping generic commands to SHC specific actions (Sale, Void, Settlement).
 */
__attribute__((swift_name("BaseTerminalSHC")))
@interface TCCBaseTerminalSHC : TCCTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(TCCTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Cancels the current session on the terminal device.
 * This sends a specific [SHCAction.CancelSession] command to the device.
 *
 * @param payload The action associated with the session to cancel.
 * @param device The target device.
 * @param isSimulation Flag for simulation mode.
 * @return A [Result] indicating success or failure of the cancellation.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)cancelSessionPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelSession(payload:device:isSimulation:completionHandler:)")));
- (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TCCActionJob *)actionJob payload:(TCCAction *)payload device:(TCCTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TCCResult<TCCTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Maps a generic [Command.PAY] command to an SHC [SHCAction.Sale] action.
 * Generates an Order ID if missing and determines the product code.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCSHCAction * _Nullable)onPayCommand:(TCCCommand *)command data:(TCCPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onPrintReceiptCommand:(TCCCommand *)command data:(TCCPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the status of a transaction.
 * Currently, this is not implemented for SHC terminals and returns null.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(TCCAction *)payload device:(TCCTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TCCBoolean * _Nullable)isSimulation completionHandler:(void (^)(TCCKotlinNothing * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * Maps a generic [Command.SETTLE] command to an SHC Settlement action.
 * Distinguishes between Standard Settlement and E-Wallet Settlement.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCAction * _Nullable)onSettlementCommand:(TCCCommand *)command data:(TCCSettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Maps a generic [Command.VOID] command to an SHC [Void] action.
 * Determines the correct void transaction type based on the payment method.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCSHCAction * _Nullable)onVoidCommand:(TCCCommand *)command data:(TCCVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Pings the terminal device via WebSocket to check for reachability.
 * Includes a timeout to prevent hanging on unresponsive devices.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(TCCTerminalDevice *)device completionHandler:(void (^)(TCCBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));

/**
 * Prepares the request payload for the SHC terminal.
 *
 * Formats the [SHCAction.AMOUNT] field to ensure it complies with SHC protocols,
 * typically requiring a string with two decimal places (e.g., "10.00").
 */
- (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(TCCAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TCCActionJob *)runActionIt:(TCCAction *)it device:(TCCTerminalDevice * _Nullable)device isSimulation:(TCCBoolean * _Nullable)isSimulation callback:(void (^)(TCCTerminalResult * _Nullable, TCCErrorData * _Nullable))callback __attribute__((swift_name("runAction(it:device:isSimulation:callback:)")));
- (NSString * _Nullable)terminalIDData:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));
- (NSArray<id<TCCTerminalAction>> *)toActionsCommandType:(TCCCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (TCCGenericPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (TCCResult<TCCTerminalResult *> * _Nullable)toResultTerminalDevice:(TCCTerminalDevice *)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(terminalDevice:json:)")));

/**
 * Converts the raw JSON response from the terminal into a format suitable for backend synchronization.
 * Maps transaction types (SALE, VOID, CALLBACK) based on the action and success status.
 *
 * @param request The original request.
 * @param json The response JSON.
 * @param transactions The transaction context.
 * @return A pair of transaction type name and synchronized payload, or null if sync is not required.
 */
- (TCCKotlinPair<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(TCCKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)json transactions:(TCCTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (TCCTerminalResult * _Nullable)toTerminalResultTerminalDevice:(TCCTerminalDevice * _Nullable)terminalDevice json:(TCCKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(terminalDevice:json:)")));
- (TCCTerminalResult *)transformJsonToResultJson:(TCCKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCKotlinNothing * _Nullable bluetooth __attribute__((swift_name("bluetooth")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCTerminalCommunicationService *communicationService __attribute__((swift_name("communicationService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalGHL")))
@interface TCCTerminalGHL : TCCBaseTerminalSHC
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalGHL __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCTerminalGHL *shared __attribute__((swift_name("shared")));
@end


/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EppDetails")))
@interface TCCEppDetails : TCCBase
- (instancetype)initWithAcquirer:(NSString *)acquirer tenure:(NSString *)tenure totalAmt:(NSString *)totalAmt monthlyAmt:(NSString *)monthlyAmt finalAmt:(NSString *)finalAmt __attribute__((swift_name("init(acquirer:tenure:totalAmt:monthlyAmt:finalAmt:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCEppDetailsCompanion *companion __attribute__((swift_name("companion")));
- (TCCEppDetails *)doCopyAcquirer:(NSString *)acquirer tenure:(NSString *)tenure totalAmt:(NSString *)totalAmt monthlyAmt:(NSString *)monthlyAmt finalAmt:(NSString *)finalAmt __attribute__((swift_name("doCopy(acquirer:tenure:totalAmt:monthlyAmt:finalAmt:)")));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="Acquirer")
*/
@property (readonly) NSString *acquirer __attribute__((swift_name("acquirer")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="FinalAmt")
*/
@property (readonly) NSString *finalAmt __attribute__((swift_name("finalAmt")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="MonthlyAmt")
*/
@property (readonly) NSString *monthlyAmt __attribute__((swift_name("monthlyAmt")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="Tenure")
*/
@property (readonly) NSString *tenure __attribute__((swift_name("tenure")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TotalAmt")
*/
@property (readonly) NSString *totalAmt __attribute__((swift_name("totalAmt")));
@end


/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("EppDetails.Companion")))
@interface TCCEppDetailsCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCEppDetailsCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents the details of an Easy Payment Plan (EPP) transaction.
 * Maps to the nested "TransactionEPP" JSON object.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Sealed class representing all supported actions for the SHC terminal protocol.
 * Maps high-level terminal actions to the specific JSON payload keys required by the SHC WebSocket API.
 */
__attribute__((swift_name("SHCAction")))
@interface TCCSHCAction : TCCAction
- (instancetype)initWithData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCSHCActionCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)getPaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (id<TCCTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end


/**
 * Represents a request to terminate the current session on the terminal.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCAction.CancelSession")))
@interface TCCSHCActionCancelSession : TCCSHCAction

/**
 * Represents a request to terminate the current session on the terminal.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Represents a request to terminate the current session on the terminal.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (BOOL)isNeedVerified __attribute__((swift_name("isNeedVerified()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCAction.Companion")))
@interface TCCSHCActionCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSHCActionCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *AMOUNT __attribute__((swift_name("AMOUNT")));
@property (readonly) NSString *POS_REF_NO __attribute__((swift_name("POS_REF_NO")));
@property (readonly) NSString *PRODUCT_CODE __attribute__((swift_name("PRODUCT_CODE")));
@property (readonly) NSString *TRANSACTION_APPROVAL_CODE __attribute__((swift_name("TRANSACTION_APPROVAL_CODE")));
@property (readonly) NSString *TRANSACTION_INVOICE __attribute__((swift_name("TRANSACTION_INVOICE")));
@property (readonly) NSString *TRANSACTION_REF_ID __attribute__((swift_name("TRANSACTION_REF_ID")));
@property (readonly) NSString *TRANSACTION_RRN __attribute__((swift_name("TRANSACTION_RRN")));
@property (readonly) NSString *TRANSACTION_TYPE __attribute__((swift_name("TRANSACTION_TYPE")));
@end


/**
 * Base class for payment-related actions.
 *
 * @param orderID The unique identifier for the order (PosReference).
 * @param amount The transaction amount.
 * @param productCode The specific product code (e.g., specifying a particular card scheme or e-wallet).
 */
__attribute__((swift_name("SHCAction.Payment")))
@interface TCCSHCActionPayment : TCCSHCAction
@end


/**
 * Represents a Settlement request for standard card transactions.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCAction.Settlement")))
@interface TCCSHCActionSettlement : TCCSHCAction

/**
 * Represents a Settlement request for standard card transactions.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Represents a Settlement request for standard card transactions.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end


/**
 * Represents a Settlement request specifically for E-Wallet transactions.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCAction.SettlementEWallet")))
@interface TCCSHCActionSettlementEWallet : TCCSHCAction

/**
 * Represents a Settlement request specifically for E-Wallet transactions.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Represents a Settlement request specifically for E-Wallet transactions.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end


/**
 * Represents QR types with an explicit `value` field and uppercase serial names.
 *
 * @param value The raw string value of the QR type, useful for direct access.
 * @param category The category of the QR type, either GENERATE or SCAN.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/shc/data/SHCPaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethod")))
@interface TCCSHCPaymentMethod : TCCKotlinEnum<TCCSHCPaymentMethod *> <TCCPaymentMethod>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents QR types with an explicit `value` field and uppercase serial names.
 *
 * @param value The raw string value of the QR type, useful for direct access.
 * @param category The category of the QR type, either GENERATE or SCAN.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCSHCPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCSHCPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) TCCSHCPaymentMethod *ewallet __attribute__((swift_name("ewallet")));
@property (class, readonly) TCCSHCPaymentMethod *qrAlipayplus __attribute__((swift_name("qrAlipayplus")));
@property (class, readonly) TCCSHCPaymentMethod *qrBoost __attribute__((swift_name("qrBoost")));
@property (class, readonly) TCCSHCPaymentMethod *qrDuitnow __attribute__((swift_name("qrDuitnow")));
@property (class, readonly) TCCSHCPaymentMethod *qrFavePay __attribute__((swift_name("qrFavePay")));
@property (class, readonly) TCCSHCPaymentMethod *qrGrabPay __attribute__((swift_name("qrGrabPay")));
@property (class, readonly) TCCSHCPaymentMethod *qrMcash __attribute__((swift_name("qrMcash")));
@property (class, readonly) TCCSHCPaymentMethod *qrNetsPay __attribute__((swift_name("qrNetsPay")));
@property (class, readonly) TCCSHCPaymentMethod *qrRedPay __attribute__((swift_name("qrRedPay")));
@property (class, readonly) TCCSHCPaymentMethod *qrUnionPay __attribute__((swift_name("qrUnionPay")));
+ (TCCKotlinArray<TCCSHCPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCSHCPaymentMethod *> *entries __attribute__((swift_name("entries")));
- (TCCSHCPaymentMethod * _Nullable)filtered __attribute__((swift_name("filtered()")));
- (TCCGenericPaymentMethod *)toPaymentMethod __attribute__((swift_name("toPaymentMethod()")));
@property (readonly) TCCSHCPaymentMethodCategory * _Nullable category __attribute__((swift_name("category")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethod.Category")))
@interface TCCSHCPaymentMethodCategory : TCCKotlinEnum<TCCSHCPaymentMethodCategory *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCSHCPaymentMethodCategoryCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCSHCPaymentMethodCategory *generate __attribute__((swift_name("generate")));
@property (class, readonly) TCCSHCPaymentMethodCategory *scan __attribute__((swift_name("scan")));
+ (TCCKotlinArray<TCCSHCPaymentMethodCategory *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCSHCPaymentMethodCategory *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethod.CategoryCompanion")))
@interface TCCSHCPaymentMethodCategoryCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSHCPaymentMethodCategoryCompanion *shared __attribute__((swift_name("shared")));

/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * Defines the primary use case for a QR type.
 * @param value The raw string value of the category.
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethod.Companion")))
@interface TCCSHCPaymentMethodCompanion : TCCBase <TCCKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSHCPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (TCCSHCPaymentMethod *)deserializeDecoder:(id<TCCKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (TCCSHCPaymentMethod *)fromTerminalResultResult:(TCCTerminalResult *)result __attribute__((swift_name("fromTerminalResult(result:)")));
- (void)serializeEncoder:(id<TCCKotlinx_serialization_coreEncoder>)encoder value:(TCCSHCPaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCSHCPaymentMethod * _Nullable)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TCCKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTerminalAction")))
@interface TCCSHCTerminalAction : TCCKotlinEnum<TCCSHCTerminalAction *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCSHCTerminalAction *sale __attribute__((swift_name("sale")));
@property (class, readonly) TCCSHCTerminalAction *void_ __attribute__((swift_name("void_")));
+ (TCCKotlinArray<TCCSHCTerminalAction *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCSHCTerminalAction *> *entries __attribute__((swift_name("entries")));
@end


/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTerminalResult")))
@interface TCCSHCTerminalResult : TCCBase
- (instancetype)initWithResponseCode:(NSString * _Nullable)responseCode responseDescription:(NSString * _Nullable)responseDescription transactionType:(TCCSHCTransactionType * _Nullable)transactionType transactionAmount:(NSString * _Nullable)transactionAmount transactionMID:(NSString * _Nullable)transactionMID transactionTID:(NSString * _Nullable)transactionTID transactionSTN:(NSString * _Nullable)transactionSTN transactionRRN:(NSString * _Nullable)transactionRRN transactionBatchNo:(NSString * _Nullable)transactionBatchNo transactionApplicationLabel:(NSString * _Nullable)transactionApplicationLabel transactionCardNo:(NSString * _Nullable)transactionCardNo transactionEntryType:(NSString * _Nullable)transactionEntryType transactionARQC:(NSString * _Nullable)transactionARQC transactionTVR:(NSString * _Nullable)transactionTVR transactionAID:(NSString * _Nullable)transactionAID transactionCVM:(NSString * _Nullable)transactionCVM transactionTSI:(NSString * _Nullable)transactionTSI transactionApprovalCode:(NSString * _Nullable)transactionApprovalCode transactionInvoice:(NSString * _Nullable)transactionInvoice transactionSchemeID:(NSString * _Nullable)transactionSchemeID transactionDateTime:(NSString * _Nullable)transactionDateTime transactionEPP:(NSString * _Nullable)transactionEPP posReference:(NSString * _Nullable)posReference transactionRefId:(NSString * _Nullable)transactionRefId __attribute__((swift_name("init(responseCode:responseDescription:transactionType:transactionAmount:transactionMID:transactionTID:transactionSTN:transactionRRN:transactionBatchNo:transactionApplicationLabel:transactionCardNo:transactionEntryType:transactionARQC:transactionTVR:transactionAID:transactionCVM:transactionTSI:transactionApprovalCode:transactionInvoice:transactionSchemeID:transactionDateTime:transactionEPP:posReference:transactionRefId:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCSHCTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (TCCSHCTerminalResult *)doCopyResponseCode:(NSString * _Nullable)responseCode responseDescription:(NSString * _Nullable)responseDescription transactionType:(TCCSHCTransactionType * _Nullable)transactionType transactionAmount:(NSString * _Nullable)transactionAmount transactionMID:(NSString * _Nullable)transactionMID transactionTID:(NSString * _Nullable)transactionTID transactionSTN:(NSString * _Nullable)transactionSTN transactionRRN:(NSString * _Nullable)transactionRRN transactionBatchNo:(NSString * _Nullable)transactionBatchNo transactionApplicationLabel:(NSString * _Nullable)transactionApplicationLabel transactionCardNo:(NSString * _Nullable)transactionCardNo transactionEntryType:(NSString * _Nullable)transactionEntryType transactionARQC:(NSString * _Nullable)transactionARQC transactionTVR:(NSString * _Nullable)transactionTVR transactionAID:(NSString * _Nullable)transactionAID transactionCVM:(NSString * _Nullable)transactionCVM transactionTSI:(NSString * _Nullable)transactionTSI transactionApprovalCode:(NSString * _Nullable)transactionApprovalCode transactionInvoice:(NSString * _Nullable)transactionInvoice transactionSchemeID:(NSString * _Nullable)transactionSchemeID transactionDateTime:(NSString * _Nullable)transactionDateTime transactionEPP:(NSString * _Nullable)transactionEPP posReference:(NSString * _Nullable)posReference transactionRefId:(NSString * _Nullable)transactionRefId __attribute__((swift_name("doCopy(responseCode:responseDescription:transactionType:transactionAmount:transactionMID:transactionTID:transactionSTN:transactionRRN:transactionBatchNo:transactionApplicationLabel:transactionCardNo:transactionEntryType:transactionARQC:transactionTVR:transactionAID:transactionCVM:transactionTSI:transactionApprovalCode:transactionInvoice:transactionSchemeID:transactionDateTime:transactionEPP:posReference:transactionRefId:)")));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Maps a string-based response code from a terminal or API to a corresponding [ErrorCode].
 *
 * This function consolidates various specific codes into a smaller, more manageable
 * set of semantic errors. A successful response code ("00") will result in a `null`
 * return value, as it does not represent an error.
 *
 * @param responseCode The string code received from the response (e.g., "01", "51", "E6").
 * @return The matching [ErrorCode], or `null` if the transaction was approved ("00").
 * Returns [ErrorCode.UNKNOWN_ERROR] for any unrecognized error codes.
 */
- (TCCErrorCode * _Nullable)toErrorCode __attribute__((swift_name("toErrorCode()")));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
- (NSString *)description __attribute__((swift_name("description()")));
- (TCCTerminalResult *)toTerminalResult __attribute__((swift_name("toTerminalResult()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="PosReference")
*/
@property (readonly) NSString * _Nullable posReference __attribute__((swift_name("posReference")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ResponseCode")
*/
@property (readonly) NSString * _Nullable responseCode __attribute__((swift_name("responseCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ResponseDescription")
*/
@property (readonly) NSString * _Nullable responseDescription __attribute__((swift_name("responseDescription")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionAID")
*/
@property (readonly) NSString * _Nullable transactionAID __attribute__((swift_name("transactionAID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionARQC")
*/
@property (readonly) NSString * _Nullable transactionARQC __attribute__((swift_name("transactionARQC")));
@property (readonly) NSString * _Nullable transactionAmount __attribute__((swift_name("transactionAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionApplicationLabel")
*/
@property (readonly) NSString * _Nullable transactionApplicationLabel __attribute__((swift_name("transactionApplicationLabel")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionApprovalCode")
*/
@property (readonly) NSString * _Nullable transactionApprovalCode __attribute__((swift_name("transactionApprovalCode")));
@property (readonly) NSString * _Nullable transactionBatchNo __attribute__((swift_name("transactionBatchNo")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionCVM")
*/
@property (readonly) NSString * _Nullable transactionCVM __attribute__((swift_name("transactionCVM")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionCardNo")
*/
@property (readonly) NSString * _Nullable transactionCardNo __attribute__((swift_name("transactionCardNo")));
@property (readonly) NSString * _Nullable transactionDateTime __attribute__((swift_name("transactionDateTime")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionEPP")
*/
@property (readonly) NSString * _Nullable transactionEPP __attribute__((swift_name("transactionEPP")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionEntryType")
*/
@property (readonly) NSString * _Nullable transactionEntryType __attribute__((swift_name("transactionEntryType")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionInvoice")
*/
@property (readonly) NSString * _Nullable transactionInvoice __attribute__((swift_name("transactionInvoice")));
@property (readonly) NSString * _Nullable transactionMID __attribute__((swift_name("transactionMID")));
@property (readonly) NSString * _Nullable transactionRRN __attribute__((swift_name("transactionRRN")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionRefId")
*/
@property (readonly) NSString * _Nullable transactionRefId __attribute__((swift_name("transactionRefId")));
@property (readonly) NSString * _Nullable transactionSTN __attribute__((swift_name("transactionSTN")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionSchemeID")
*/
@property (readonly) NSString * _Nullable transactionSchemeID __attribute__((swift_name("transactionSchemeID")));
@property (readonly) NSString * _Nullable transactionTID __attribute__((swift_name("transactionTID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionTSI")
*/
@property (readonly) NSString * _Nullable transactionTSI __attribute__((swift_name("transactionTSI")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionTVR")
*/
@property (readonly) NSString * _Nullable transactionTVR __attribute__((swift_name("transactionTVR")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="TransactionType")
*/
@property (readonly) TCCSHCTransactionType * _Nullable transactionType __attribute__((swift_name("transactionType")));
@end


/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTerminalResult.Companion")))
@interface TCCSHCTerminalResultCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSHCTerminalResultCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents the main transaction response object from the API.
 * The @SerialName annotation maps the JSON keys (PascalCase) to
 * Kotlin's conventional camelCase properties.
 * A000000004  MASTER
 * A000000003  VISA
 * A000000615  MYDEBIT
 */
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Represents different types of transactions, serializing to its integer value as a string.
 *
 * @property value The integer code associated with the transaction type.
 * @property type The method of the transaction, either CARD or EWALLET.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTransactionType")))
@interface TCCSHCTransactionType : TCCKotlinEnum<TCCSHCTransactionType *> <TCCTerminalAction>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents different types of transactions, serializing to its integer value as a string.
 *
 * @property value The integer code associated with the transaction type.
 * @property type The method of the transaction, either CARD or EWALLET.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCSHCTransactionTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCSHCTransactionType *terminateSession __attribute__((swift_name("terminateSession")));
@property (class, readonly) TCCSHCTransactionType *sale __attribute__((swift_name("sale")));
@property (class, readonly) TCCSHCTransactionType *void_ __attribute__((swift_name("void_")));
@property (class, readonly) TCCSHCTransactionType *settlement __attribute__((swift_name("settlement")));
@property (class, readonly) TCCSHCTransactionType *preAuthorization __attribute__((swift_name("preAuthorization")));
@property (class, readonly) TCCSHCTransactionType *saleComplete __attribute__((swift_name("saleComplete")));
@property (class, readonly) TCCSHCTransactionType *voidPreAuthorization __attribute__((swift_name("voidPreAuthorization")));
@property (class, readonly) TCCSHCTransactionType *eWalletSale __attribute__((swift_name("eWalletSale")));
@property (class, readonly) TCCSHCTransactionType *eWalletVoid __attribute__((swift_name("eWalletVoid")));
@property (class, readonly) TCCSHCTransactionType *eWalletSettlement __attribute__((swift_name("eWalletSettlement")));
@property (class, readonly) TCCSHCTransactionType *voidSaleComplete __attribute__((swift_name("voidSaleComplete")));
@property (class, readonly) TCCSHCTransactionType *motoSale __attribute__((swift_name("motoSale")));
@property (class, readonly) TCCSHCTransactionType *eppSale __attribute__((swift_name("eppSale")));
+ (TCCKotlinArray<TCCSHCTransactionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCSHCTransactionType *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCSHCPaymentMethod * _Nullable type __attribute__((swift_name("type")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCTransactionType.Companion")))
@interface TCCSHCTransactionTypeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCSHCTransactionTypeCompanion *shared __attribute__((swift_name("shared")));
- (TCCSHCTransactionType *)fromTerminalResultResult:(TCCTerminalResult *)result __attribute__((swift_name("fromTerminalResult(result:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TCCKotlinArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TCCSHCTransactionType * _Nullable)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FakeResponseGenerator__")))
@interface TCCFakeResponseGenerator__ : TCCBaseFakeResponseGenerator
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)fakeResponseGenerator __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCFakeResponseGenerator__ *shared __attribute__((swift_name("shared")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCWebSocketService")))
@interface TCCSHCWebSocketService : TCCWebSocketService
- (instancetype)initWithResultFlow:(id<TCCKotlinx_coroutines_coreMutableStateFlow>)resultFlow shouldRetry:(TCCBoolean *(^)(TCCKotlinException *))shouldRetry builder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:shouldRetry:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(TCCKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * Connect to the EDC
 * @param address the IP address
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TCCTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TCCResult<TCCKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
- (TCCKtor_client_coreHttpClient *)createClientDevice:(TCCTerminalDevice *)device __attribute__((swift_name("createClient(device:)")));
@property (readonly) TCCKtor_client_coreHttpClient *(^builder)(void) __attribute__((swift_name("builder")));
@end

@interface TCCCashupTerminalResult (Extensions)
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
@end

@interface TCCPaymentMethodCompanion (Extensions)
- (TCCCashupPaymentMethod *)card __attribute__((swift_name("card()")));
- (TCCCashupPaymentMethod *)qris __attribute__((swift_name("qris()")));
@end

@interface TCCTerminalDeviceCompanion (Extensions)
- (TCCTerminalDevice *)briId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("bri(id:ipAddress:)")));
- (TCCTerminalDevice *)cashupId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("cashup(id:ipAddress:)")));
- (TCCTerminalDevice *)shcId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("shc(id:ipAddress:)")));
@end

@interface TCCTerminalResult (Extensions)
- (NSString * _Nullable)approval __attribute__((swift_name("approval()")));
- (NSString * _Nullable)approval_ __attribute__((swift_name("approval_()")));
- (NSString * _Nullable)invoiceNo __attribute__((swift_name("invoiceNo()")));
- (NSString * _Nullable)invoiceNo_ __attribute__((swift_name("invoiceNo_()")));
- (NSString * _Nullable)invoiceNo__ __attribute__((swift_name("invoiceNo__()")));
- (BOOL)isSuccess __attribute__((swift_name("isSuccess()")));
- (BOOL)isSuccess_ __attribute__((swift_name("isSuccess_()")));
- (BOOL)isSuccess__ __attribute__((swift_name("isSuccess__()")));
- (BOOL)isSuccess___ __attribute__((swift_name("isSuccess___()")));
- (NSString * _Nullable)referenceID __attribute__((swift_name("referenceID()")));
- (NSString * _Nullable)referenceID_ __attribute__((swift_name("referenceID_()")));
- (NSString * _Nullable)referenceNumber __attribute__((swift_name("referenceNumber()")));
- (NSString * _Nullable)rrn __attribute__((swift_name("rrn()")));
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
- (NSString *)toRaw_ __attribute__((swift_name("toRaw_()")));
- (NSString *)toRaw__ __attribute__((swift_name("toRaw__()")));
- (NSString *)toRaw___ __attribute__((swift_name("toRaw___()")));
- (TCCNTTPaymentMethod * _Nullable)tradeType __attribute__((swift_name("tradeType()")));
@end

@interface TCCNTTTerminalResult (Extensions)
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
@end

@interface TCCSHCTerminalResult (Extensions)
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalDateTimeSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateTime")))
@interface TCCKotlinx_datetimeLocalDateTime : TCCBase <TCCKotlinComparable>
- (instancetype)initWithDate:(TCCKotlinx_datetimeLocalDate *)date time:(TCCKotlinx_datetimeLocalTime *)time __attribute__((swift_name("init(date:time:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(int32_t)month day:(int32_t)day hour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(year:month:day:hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(TCCKotlinx_datetimeMonth *)month day:(int32_t)day hour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond_:(int32_t)nanosecond __attribute__((swift_name("init(year:month:day:hour:minute:second:nanosecond_:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinx_datetimeLocalDateTimeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TCCKotlinx_datetimeLocalDateTime *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCKotlinx_datetimeLocalDate *date __attribute__((swift_name("date")));
@property (readonly) int32_t day __attribute__((swift_name("day")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth"))) __attribute__((deprecated("Use the 'day' property instead")));
@property (readonly) TCCKotlinx_datetimeDayOfWeek *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) int32_t hour __attribute__((swift_name("hour")));
@property (readonly) int32_t minute __attribute__((swift_name("minute")));
@property (readonly) TCCKotlinx_datetimeMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t monthNumber __attribute__((swift_name("monthNumber"))) __attribute__((deprecated("Use the 'month' property instead")));
@property (readonly) int32_t nanosecond __attribute__((swift_name("nanosecond")));
@property (readonly) int32_t second __attribute__((swift_name("second")));
@property (readonly) TCCKotlinx_datetimeLocalTime *time __attribute__((swift_name("time")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end

@interface TCCKotlinx_datetimeLocalDateTime (Extensions)
- (NSString *)formatTransactionDateTime __attribute__((swift_name("formatTransactionDateTime()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/TimeZoneSerializer))
*/
__attribute__((swift_name("Kotlinx_datetimeTimeZone")))
@interface TCCKotlinx_datetimeTimeZone : TCCBase
@property (class, readonly, getter=companion) TCCKotlinx_datetimeTimeZoneCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TCCKotlinInstant *)toInstant:(TCCKotlinx_datetimeLocalDateTime *)receiver youShallNotPass:(TCCKotlinx_datetimeOverloadMarker *)youShallNotPass __attribute__((swift_name("toInstant(_:youShallNotPass:)")));
- (TCCKotlinx_datetimeLocalDateTime *)toLocalDateTime:(TCCKotlinInstant *)receiver __attribute__((swift_name("toLocalDateTime(_:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@end

@interface TCCKotlinx_datetimeTimeZone (Extensions)

/**
 * Converts a TimeZone to a GMT string like "GMT+08:00".
 * @param instant The specific moment in time to get the offset for.
 * Defaults to the current system time.
 */
- (NSString *)toGmtStringInstant:(TCCKotlinInstant *)instant __attribute__((swift_name("toGmtString(instant:)")));

/**
 * Converts a TimeZone to a GMT string like "GMT+08:00".
 * @param instant The specific moment in time to get the offset for.
 * Defaults to the current system time.
 */
- (NSString *)toOffsetInstant:(TCCKotlinInstant *)instant __attribute__((swift_name("toOffset(instant:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppModule_iosKt")))
@interface TCCAppModule_iosKt : TCCBase
+ (TCCAppModule *)getAppModule __attribute__((swift_name("getAppModule()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionKt")))
@interface TCCBRIActionKt : TCCBase

/**
 * Formats a [LocalDateTime] into the string format required by BRI ("yyyy-MM-dd HH:mm:ss").
 */
+ (NSString *)formatDateTimeDateTime:(TCCKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));

/**
 * Formats a [LocalDateTime] into a full ISO-like string with timezone ("yyyy-MM-dd'T'HH:mm:sszzz").
 */
+ (NSString *)formatDateTimeWithTimeZoneDateTime:(TCCKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTimeWithTimeZone(dateTime:)")));

/**
 * Parses a date string into a [LocalDateTime], defaulting to GMT+0700 if no timezone is provided.
 */
+ (TCCKotlinx_datetimeLocalDateTime * _Nullable)parseDateTimeDateTime:(NSString *)dateTime timeZone:(TCCKotlinx_datetimeTimeZone *)timeZone __attribute__((swift_name("parseDateTime(dateTime:timeZone:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPaymentMethodKt")))
@interface TCCBRIPaymentMethodKt : TCCBase
+ (TCCBRIPaymentMethod *)brizzi:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("brizzi(_:)")));
+ (TCCBRIPaymentMethod *)contactless:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("contactless(_:)")));
+ (TCCBRIPaymentMethod *)insertCard:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("insertCard(_:)")));
+ (TCCBRIPaymentMethod *)qris:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qris(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BaseDatabaseKt")))
@interface TCCBaseDatabaseKt : TCCBase
+ (BOOL)contains:(NSArray<id<TCCTerminalAction>> *)receiver value:(NSString * _Nullable)value __attribute__((swift_name("contains(_:value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Bluetooth_iosKt")))
@interface TCCBluetooth_iosKt : TCCBase
+ (id<TCCBluetoothService>)getBriBluetoothServiceResult:(id<TCCKotlinx_coroutines_coreMutableStateFlow>)result __attribute__((swift_name("getBriBluetoothService(result:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriTerminalResultKt")))
@interface TCCBriTerminalResultKt : TCCBase
+ (TCCResult<TCCKotlinx_serialization_jsonJsonElement *> *)parseBriResponse:(NSString *)receiver __attribute__((swift_name("parseBriResponse(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseKt")))
@interface TCCDatabaseKt : TCCBase
+ (TCCDatabaseHandler *)createDatabaseDriverFactory:(TCCDriverFactory *)driverFactory oldSecurity:(TCCBaseSecurity *)oldSecurity security:(TCCBaseSecurity *)security networkService:(TCCInternalNetworkService *)networkService __attribute__((swift_name("createDatabase(driverFactory:oldSecurity:security:networkService:)")));
@property (class, readonly) NSString *DB_NAME __attribute__((swift_name("DB_NAME")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DateUtilKt")))
@interface TCCDateUtilKt : TCCBase
+ (NSString *)addDeviceOffset:(NSString *)receiver __attribute__((swift_name("addDeviceOffset(_:)")));
+ (NSString *)toDateWithT:(NSString *)receiver __attribute__((swift_name("toDateWithT(_:)")));

/**
 * Helper to convert the timestamp string to a LocalDateTime object.
 * Automatically handles Seconds (10 digits) vs Milliseconds (13 digits).
 * Uses kotlinx-datetime for KMP compatibility.
 */
+ (TCCKotlinx_datetimeLocalDateTime * _Nullable)toLocalDateTime:(int64_t)receiver __attribute__((swift_name("toLocalDateTime(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorMapperKt")))
@interface TCCErrorMapperKt : TCCBase
+ (TCCErrorCode *)toSaleErrorMapperAction:(TCCBRITerminalAction * _Nullable)action code:(NSString *)code info:(NSString *)info message:(NSString * _Nullable)message __attribute__((swift_name("toSaleErrorMapper(action:code:info:message:)")));
@property (class, readonly) NSString *TC_TRANSACTION_CANCELLED __attribute__((swift_name("TC_TRANSACTION_CANCELLED")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IPAddresses_iosKt")))
@interface TCCIPAddresses_iosKt : TCCBase
+ (NSString * _Nullable)getDeviceIPAddress __attribute__((swift_name("getDeviceIPAddress()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTActionKt")))
@interface TCCNTTActionKt : TCCBase

/**
 * Formats a [LocalDateTime] into the string format required by NTT ("yyyy-MM-dd HH:mm:ss").
 */
+ (NSString *)formatDateTimeDateTime:(TCCKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTPaymentMethodKt")))
@interface TCCNTTPaymentMethodKt : TCCBase
+ (TCCNTTPaymentMethod *)alipayPlus:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("alipayPlus(_:)")));
+ (TCCNTTPaymentMethod *)atome:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("atome(_:)")));
+ (TCCNTTPaymentMethod *)bblQrcs:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("bblQrcs(_:)")));
+ (TCCNTTPaymentMethod *)card:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("card(_:)")));
+ (TCCNTTPaymentMethod *)linePay:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("linePay(_:)")));
+ (TCCNTTPaymentMethod *)maxMe:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("maxMe(_:)")));
+ (TCCNTTPaymentMethod *)multiIpp:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("multiIpp(_:)")));
+ (TCCNTTPaymentMethod *)sabuyMoney:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("sabuyMoney(_:)")));
+ (TCCNTTPaymentMethod *)shopee:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("shopee(_:)")));
+ (TCCNTTPaymentMethod *)thaiQrCode:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("thaiQrCode(_:)")));
+ (TCCNTTPaymentMethod *)trueMoney:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("trueMoney(_:)")));
+ (TCCNTTPaymentMethod *)wechatPayCil:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("wechatPayCil(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Platform_iosKt")))
@interface TCCPlatform_iosKt : TCCBase
+ (id<TCCPlatform>)getPlatform __attribute__((swift_name("getPlatform()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt")))
@interface TCCResultKt : TCCBase
+ (NSString *)approval:(NSString *)receiver __attribute__((swift_name("approval(_:)")));
+ (NSString *)getLast:(NSString *)receiver __attribute__((swift_name("getLast(_:)")));
+ (NSString *)referenceID:(NSString *)receiver __attribute__((swift_name("referenceID(_:)")));
+ (NSString *)referenceNumber:(NSString *)receiver __attribute__((swift_name("referenceNumber(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt_")))
@interface TCCResultKt_ : TCCBase
+ (NSString *)invoiceNo:(NSString *)receiver __attribute__((swift_name("invoiceNo(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt__")))
@interface TCCResultKt__ : TCCBase
+ (TCCInt * _Nullable)getHttpResponseCodeCode:(TCCErrorCode *)code __attribute__((swift_name("getHttpResponseCode(code:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt___")))
@interface TCCResultKt___ : TCCBase
+ (NSString *)invoiceNo:(NSString *)receiver __attribute__((swift_name("invoiceNo(_:)")));
+ (NSString *)tradeType:(NSString *)receiver __attribute__((swift_name("tradeType(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt____")))
@interface TCCResultKt____ : TCCBase
+ (NSString *)approval:(NSString *)receiver __attribute__((swift_name("approval(_:)")));
+ (NSString *)approval_:(NSArray<NSString *> *)receiver __attribute__((swift_name("approval(__:)")));
+ (NSString *)invoiceNo:(NSString *)receiver __attribute__((swift_name("invoiceNo(_:)")));
+ (NSString *)invoiceNo_:(NSArray<NSString *> *)receiver __attribute__((swift_name("invoiceNo(__:)")));
+ (NSString *)referenceID:(NSString *)receiver __attribute__((swift_name("referenceID(_:)")));
+ (NSString *)referenceID_:(NSArray<NSString *> *)receiver __attribute__((swift_name("referenceID(__:)")));
+ (NSString *)rrn:(NSString *)receiver __attribute__((swift_name("rrn(_:)")));
+ (NSString *)rrn_:(NSArray<NSString *> *)receiver __attribute__((swift_name("rrn(__:)")));
+ (NSString *)uniqueID:(NSString *)receiver __attribute__((swift_name("uniqueID(_:)")));
+ (NSString *)uniqueID_:(NSArray<NSString *> *)receiver __attribute__((swift_name("uniqueID(__:)")));
+ (NSArray<NSString *> *)values:(NSString *)receiver __attribute__((swift_name("values(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCActionKt")))
@interface TCCSHCActionKt : TCCBase

/**
 * Formats a [LocalDateTime] into the string format required by SHC ("yyyy-MM-dd HH:mm:ss").
 */
+ (NSString *)formatDateTimeDateTime:(TCCKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SHCPaymentMethodKt")))
@interface TCCSHCPaymentMethodKt : TCCBase
+ (TCCSHCPaymentMethod *)card:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("card(_:)")));
+ (TCCSHCPaymentMethod *)ewallet:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("ewallet(_:)")));
+ (TCCSHCPaymentMethod *)qrAlipayPlus:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrAlipayPlus(_:)")));
+ (TCCSHCPaymentMethod *)qrBoost:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrBoost(_:)")));
+ (TCCSHCPaymentMethod *)qrDuitNow:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrDuitNow(_:)")));
+ (TCCSHCPaymentMethod *)qrFavePay:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrFavePay(_:)")));
+ (TCCSHCPaymentMethod *)qrGrabPay:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrGrabPay(_:)")));
+ (TCCSHCPaymentMethod *)qrMcash:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrMcash(_:)")));
+ (TCCSHCPaymentMethod *)qrNetsPay:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrNetsPay(_:)")));
+ (TCCSHCPaymentMethod *)qrRedPay:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrRedPay(_:)")));
+ (TCCSHCPaymentMethod *)qrUnionPay:(id<TCCPaymentMethod>)receiver __attribute__((swift_name("qrUnionPay(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Security_iosKt")))
@interface TCCSecurity_iosKt : TCCBase
+ (TCCBaseSecurity *)getSecurityApiKey:(NSString *)apiKey __attribute__((swift_name("getSecurity(apiKey:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalBRIKt")))
@interface TCCTerminalBRIKt : TCCBase
+ (TCCBRIPaymentMethod *)toSaleMethod:(NSString *)receiver __attribute__((swift_name("toSaleMethod(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalOperationKt")))
@interface TCCTerminalOperationKt : TCCBase
@property (class, readonly) id<TCCKotlinx_datetimeDateTimeFormat> dateTimeFormat __attribute__((swift_name("dateTimeFormat")));
@property (class, readonly) NSString *formatPattern __attribute__((swift_name("formatPattern")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DartKt")))
@interface TCCDartKt : TCCBase

/**
 * Manually converts a VERY SIMPLE JsonObject to an XML string.
 *
 * This function is HIGHLY SPECIFIC to a flat JsonObject structure
 * where keys map directly to XML element names and primitive values
 * map directly to XML element text content.
 *
 * It will **NOT** handle:
 * - Nested JsonObjects or JsonArrays.
 * - Complex XML structures (attributes, namespaces, comments, etc.).
 * - Proper XML entity escaping for special characters (<, >, &, ", ') in values.
 * If your JSON values contain these, the generated XML will be invalid.
 * - Indentation or pretty-printing.
 *
 * Use an actual XML serialization library for robust and correct XML generation.
 *
 * @param jsonObject The flat JsonObject to convert.
 * @param rootTagName The name of the root XML element (e.g., "data", "root").
 * @return A simple XML string.
 */
+ (NSString *)convertJsonObjectToXmlManuallyJsonObject:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)jsonObject rootTagName:(NSString *)rootTagName __attribute__((swift_name("convertJsonObjectToXmlManually(jsonObject:rootTagName:)")));

/**
 * Manually converts a VERY SIMPLE XML string to a JsonObject without an XML parsing library.
 *
 * This function is HIGHLY SPECIFIC to the input XML format:
 * <root_tag>
 * <key1>value1</key1>
 * <key2>value2</key2>
 * ...
 * <keyN>valueN</keyN>
 * </root_tag>
 *
 * It will **NOT** work for:
 * - Nested elements (e.g., <parent><child>...</child></parent>)
 * - Attributes (e.g., <key1 id="abc">value1</key1>)
 * - XML declarations, comments, CDATA, entities, etc.
 * - Mixed content (text directly inside the root tag alongside child tags)
 * - Self-closing tags (<key/>)
 * - Any deviation from the strict <key>value</key> pattern for children.
 * - Poorly formatted XML (e.g., missing closing tags, incorrect nesting).
 *
 * Use an actual XML parsing library (like xmlutil.dom2) for anything more complex.
 */
+ (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)convertSimpleXmlToSimpleJsonManuallyXmlString:(NSString *)xmlString stringValue:(NSDictionary<NSString *, id> *)stringValue __attribute__((swift_name("convertSimpleXmlToSimpleJsonManually(xmlString:stringValue:)")));
+ (NSString *)escapeXmlSpecialChars:(NSString *)receiver __attribute__((swift_name("escapeXmlSpecialChars(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DartKt_")))
@interface TCCDartKt_ : TCCBase

/**
 * Manually converts a VERY SIMPLE JsonObject to an XML string.
 *
 * This function is HIGHLY SPECIFIC to a flat JsonObject structure
 * where keys map directly to XML element names and primitive values
 * map directly to XML element text content.
 *
 * It will **NOT** handle:
 * - Nested JsonObjects or JsonArrays.
 * - Complex XML structures (attributes, namespaces, comments, etc.).
 * - Proper XML entity escaping for special characters (<, >, &, ", ') in values.
 * If your JSON values contain these, the generated XML will be invalid.
 * - Indentation or pretty-printing.
 *
 * Use an actual XML serialization library for robust and correct XML generation.
 *
 * @param jsonObject The flat JsonObject to convert.
 * @param rootTagName The name of the root XML element (e.g., "data", "root").
 * @return A simple XML string.
 */
+ (NSString *)convertJsonObjectToXmlManuallyJsonObject:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)jsonObject rootTagName:(NSString *)rootTagName __attribute__((swift_name("convertJsonObjectToXmlManually(jsonObject:rootTagName:)")));

/**
 * Manually converts a VERY SIMPLE XML string to a JsonObject without an XML parsing library.
 *
 * This function is HIGHLY SPECIFIC to the input XML format:
 * <root_tag>
 * <key1>value1</key1>
 * <key2>value2</key2>
 * ...
 * <keyN>valueN</keyN>
 * </root_tag>
 *
 * It will **NOT** work for:
 * - Nested elements (e.g., <parent><child>...</child></parent>)
 * - Attributes (e.g., <key1 id="abc">value1</key1>)
 * - XML declarations, comments, CDATA, entities, etc.
 * - Mixed content (text directly inside the root tag alongside child tags)
 * - Self-closing tags (<key/>)
 * - Any deviation from the strict <key>value</key> pattern for children.
 * - Poorly formatted XML (e.g., missing closing tags, incorrect nesting).
 *
 * Use an actual XML parsing library (like xmlutil.dom2) for anything more complex.
 */
+ (NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)convertSimpleXmlToSimpleJsonManuallyXmlString:(NSString *)xmlString stringValue:(NSDictionary<NSString *, id> *)stringValue __attribute__((swift_name("convertSimpleXmlToSimpleJsonManually(xmlString:stringValue:)")));
+ (NSString *)escapeXmlSpecialChars:(NSString *)receiver __attribute__((swift_name("escapeXmlSpecialChars(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("JsonKt")))
@interface TCCJsonKt : TCCBase
+ (NSString *)prettyJsonValue:(id _Nullable)value __attribute__((swift_name("prettyJson(value:)")));
+ (TCCKotlinPair<NSString *, TCCKotlinx_serialization_jsonJsonPrimitive *> *)toJsonPrimitive:(NSString * _Nullable)receiver key:(NSString *)key __attribute__((swift_name("toJsonPrimitive(_:key:)")));
+ (NSDictionary<NSString *, id> *)toMapNotNull:(NSArray<TCCKotlinPair<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *> *)receiver __attribute__((swift_name("toMapNotNull(_:)")));
@property (class, readonly) TCCKotlinx_serialization_jsonJson *PrettyJson __attribute__((swift_name("PrettyJson")));
@property (class, readonly) TCCKotlinx_serialization_jsonJson *XenJson __attribute__((swift_name("XenJson")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MockKt")))
@interface TCCMockKt : TCCBase
+ (TCCKotlinx_serialization_jsonJsonElement *)mockRefund:(NSDictionary<NSString *, TCCKotlinx_serialization_jsonJsonElement *> *)receiver success:(BOOL)success __attribute__((swift_name("mockRefund(_:success:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinCoroutineContext")))
@protocol TCCKotlinCoroutineContext
@required
- (id _Nullable)foldInitial:(id _Nullable)initial operation:(id _Nullable (^)(id _Nullable, id<TCCKotlinCoroutineContextElement>))operation __attribute__((swift_name("fold(initial:operation:)")));
- (id<TCCKotlinCoroutineContextElement> _Nullable)getKey:(id<TCCKotlinCoroutineContextKey>)key __attribute__((swift_name("get(key:)")));
- (id<TCCKotlinCoroutineContext>)minusKeyKey:(id<TCCKotlinCoroutineContextKey>)key __attribute__((swift_name("minusKey(key:)")));
- (id<TCCKotlinCoroutineContext>)plusContext:(id<TCCKotlinCoroutineContext>)context __attribute__((swift_name("plus(context:)")));
@end

__attribute__((swift_name("KotlinCoroutineContextElement")))
@protocol TCCKotlinCoroutineContextElement <TCCKotlinCoroutineContext>
@required
@property (readonly) id<TCCKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreJob")))
@protocol TCCKotlinx_coroutines_coreJob <TCCKotlinCoroutineContextElement>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (id<TCCKotlinx_coroutines_coreChildHandle>)attachChildChild:(id<TCCKotlinx_coroutines_coreChildJob>)child __attribute__((swift_name("attachChild(child:)")));
- (void)cancelCause:(TCCKotlinCancellationException * _Nullable)cause __attribute__((swift_name("cancel(cause:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (TCCKotlinCancellationException *)getCancellationException __attribute__((swift_name("getCancellationException()")));
- (id<TCCKotlinx_coroutines_coreDisposableHandle>)invokeOnCompletionHandler:(void (^)(TCCKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnCompletion(handler:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (id<TCCKotlinx_coroutines_coreDisposableHandle>)invokeOnCompletionOnCancelling:(BOOL)onCancelling invokeImmediately:(BOOL)invokeImmediately handler:(void (^)(TCCKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnCompletion(onCancelling:invokeImmediately:handler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)joinWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("join(completionHandler:)")));
- (id<TCCKotlinx_coroutines_coreJob>)plusOther:(id<TCCKotlinx_coroutines_coreJob>)other __attribute__((swift_name("plus(other:)"))) __attribute__((unavailable("Operator '+' on two Job objects is meaningless. Job is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The job to the right of `+` just replaces the job the left of `+`.")));
- (BOOL)start __attribute__((swift_name("start()")));
@property (readonly) id<TCCKotlinSequence> children __attribute__((swift_name("children")));
@property (readonly) BOOL isActive __attribute__((swift_name("isActive")));
@property (readonly) BOOL isCancelled __attribute__((swift_name("isCancelled")));
@property (readonly) BOOL isCompleted __attribute__((swift_name("isCompleted")));
@property (readonly) id<TCCKotlinx_coroutines_coreSelectClause0> onJoin __attribute__((swift_name("onJoin")));

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
@property (readonly) id<TCCKotlinx_coroutines_coreJob> _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineScope")))
@protocol TCCKotlinx_coroutines_coreCoroutineScope
@required
@property (readonly) id<TCCKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/serialization/json/JsonElementSerializer))
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonElement")))
@interface TCCKotlinx_serialization_jsonJsonElement : TCCBase
@property (class, readonly, getter=companion) TCCKotlinx_serialization_jsonJsonElementCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((swift_name("KotlinFunction")))
@protocol TCCKotlinFunction
@required
@end

__attribute__((swift_name("KotlinSuspendFunction0")))
@protocol TCCKotlinSuspendFunction0 <TCCKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeWithCompletionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinPair")))
@interface TCCKotlinPair<__covariant A, __covariant B> : TCCBase
- (instancetype)initWithFirst:(A _Nullable)first second:(B _Nullable)second __attribute__((swift_name("init(first:second:)"))) __attribute__((objc_designated_initializer));
- (TCCKotlinPair<A, B> *)doCopyFirst:(A _Nullable)first second:(B _Nullable)second __attribute__((swift_name("doCopy(first:second:)")));
- (BOOL)equalsOther:(id _Nullable)other __attribute__((swift_name("equals(other:)")));
- (int32_t)hashCode __attribute__((swift_name("hashCode()")));
- (NSString *)toString __attribute__((swift_name("toString()")));
@property (readonly) A _Nullable first __attribute__((swift_name("first")));
@property (readonly) B _Nullable second __attribute__((swift_name("second")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreFlow")))
@protocol TCCKotlinx_coroutines_coreFlow
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)collectCollector:(id<TCCKotlinx_coroutines_coreFlowCollector>)collector completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("collect(collector:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSharedFlow")))
@protocol TCCKotlinx_coroutines_coreSharedFlow <TCCKotlinx_coroutines_coreFlow>
@required
@property (readonly) NSArray<id> *replayCache __attribute__((swift_name("replayCache")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreStateFlow")))
@protocol TCCKotlinx_coroutines_coreStateFlow <TCCKotlinx_coroutines_coreSharedFlow>
@required
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreFlowCollector")))
@protocol TCCKotlinx_coroutines_coreFlowCollector
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)emitValue:(id _Nullable)value completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("emit(value:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutableSharedFlow")))
@protocol TCCKotlinx_coroutines_coreMutableSharedFlow <TCCKotlinx_coroutines_coreSharedFlow, TCCKotlinx_coroutines_coreFlowCollector>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
- (void)resetReplayCache __attribute__((swift_name("resetReplayCache()")));
- (BOOL)tryEmitValue:(id _Nullable)value __attribute__((swift_name("tryEmit(value:)")));
@property (readonly) id<TCCKotlinx_coroutines_coreStateFlow> subscriptionCount __attribute__((swift_name("subscriptionCount")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutableStateFlow")))
@protocol TCCKotlinx_coroutines_coreMutableStateFlow <TCCKotlinx_coroutines_coreStateFlow, TCCKotlinx_coroutines_coreMutableSharedFlow>
@required
- (void)setValue:(id _Nullable)value __attribute__((swift_name("setValue(_:)")));
- (BOOL)compareAndSetExpect:(id _Nullable)expect update:(id _Nullable)update __attribute__((swift_name("compareAndSet(expect:update:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinEnumCompanion")))
@interface TCCKotlinEnumCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinEnumCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinArray")))
@interface TCCKotlinArray<T> : TCCBase
+ (instancetype)arrayWithSize:(int32_t)size init:(T _Nullable (^)(TCCInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (T _Nullable)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (id<TCCKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(T _Nullable)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreEncoder")))
@protocol TCCKotlinx_serialization_coreEncoder
@required
- (id<TCCKotlinx_serialization_coreCompositeEncoder>)beginCollectionDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor collectionSize:(int32_t)collectionSize __attribute__((swift_name("beginCollection(descriptor:collectionSize:)")));
- (id<TCCKotlinx_serialization_coreCompositeEncoder>)beginStructureDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("beginStructure(descriptor:)")));
- (void)encodeBooleanValue:(BOOL)value __attribute__((swift_name("encodeBoolean(value:)")));
- (void)encodeByteValue:(int8_t)value __attribute__((swift_name("encodeByte(value:)")));
- (void)encodeCharValue:(unichar)value __attribute__((swift_name("encodeChar(value:)")));
- (void)encodeDoubleValue:(double)value __attribute__((swift_name("encodeDouble(value:)")));
- (void)encodeEnumEnumDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)enumDescriptor index:(int32_t)index __attribute__((swift_name("encodeEnum(enumDescriptor:index:)")));
- (void)encodeFloatValue:(float)value __attribute__((swift_name("encodeFloat(value:)")));
- (id<TCCKotlinx_serialization_coreEncoder>)encodeInlineDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("encodeInline(descriptor:)")));
- (void)encodeIntValue:(int32_t)value __attribute__((swift_name("encodeInt(value:)")));
- (void)encodeLongValue:(int64_t)value __attribute__((swift_name("encodeLong(value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNotNullMark __attribute__((swift_name("encodeNotNullMark()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNull __attribute__((swift_name("encodeNull()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNullableSerializableValueSerializer:(id<TCCKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeNullableSerializableValue(serializer:value:)")));
- (void)encodeSerializableValueSerializer:(id<TCCKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeSerializableValue(serializer:value:)")));
- (void)encodeShortValue:(int16_t)value __attribute__((swift_name("encodeShort(value:)")));
- (void)encodeStringValue:(NSString *)value __attribute__((swift_name("encodeString(value:)")));
@property (readonly) TCCKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialDescriptor")))
@protocol TCCKotlinx_serialization_coreSerialDescriptor
@required
- (NSArray<id<TCCKotlinAnnotation>> *)getElementAnnotationsIndex:(int32_t)index __attribute__((swift_name("getElementAnnotations(index:)")));
- (id<TCCKotlinx_serialization_coreSerialDescriptor>)getElementDescriptorIndex:(int32_t)index __attribute__((swift_name("getElementDescriptor(index:)")));
- (int32_t)getElementIndexName:(NSString *)name __attribute__((swift_name("getElementIndex(name:)")));
- (NSString *)getElementNameIndex:(int32_t)index __attribute__((swift_name("getElementName(index:)")));
- (BOOL)isElementOptionalIndex:(int32_t)index __attribute__((swift_name("isElementOptional(index:)")));
@property (readonly) NSArray<id<TCCKotlinAnnotation>> *annotations __attribute__((swift_name("annotations")));
@property (readonly) int32_t elementsCount __attribute__((swift_name("elementsCount")));
@property (readonly) BOOL isInline __attribute__((swift_name("isInline")));
@property (readonly) BOOL isNullable __attribute__((swift_name("isNullable")));
@property (readonly) TCCKotlinx_serialization_coreSerialKind *kind __attribute__((swift_name("kind")));
@property (readonly) NSString *serialName __attribute__((swift_name("serialName")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreDecoder")))
@protocol TCCKotlinx_serialization_coreDecoder
@required
- (id<TCCKotlinx_serialization_coreCompositeDecoder>)beginStructureDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("beginStructure(descriptor:)")));
- (BOOL)decodeBoolean __attribute__((swift_name("decodeBoolean()")));
- (int8_t)decodeByte __attribute__((swift_name("decodeByte()")));
- (unichar)decodeChar __attribute__((swift_name("decodeChar()")));
- (double)decodeDouble __attribute__((swift_name("decodeDouble()")));
- (int32_t)decodeEnumEnumDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)enumDescriptor __attribute__((swift_name("decodeEnum(enumDescriptor:)")));
- (float)decodeFloat __attribute__((swift_name("decodeFloat()")));
- (id<TCCKotlinx_serialization_coreDecoder>)decodeInlineDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeInline(descriptor:)")));
- (int32_t)decodeInt __attribute__((swift_name("decodeInt()")));
- (int64_t)decodeLong __attribute__((swift_name("decodeLong()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)decodeNotNullMark __attribute__((swift_name("decodeNotNullMark()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (TCCKotlinNothing * _Nullable)decodeNull __attribute__((swift_name("decodeNull()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id _Nullable)decodeNullableSerializableValueDeserializer:(id<TCCKotlinx_serialization_coreDeserializationStrategy>)deserializer __attribute__((swift_name("decodeNullableSerializableValue(deserializer:)")));
- (id _Nullable)decodeSerializableValueDeserializer:(id<TCCKotlinx_serialization_coreDeserializationStrategy>)deserializer __attribute__((swift_name("decodeSerializableValue(deserializer:)")));
- (int16_t)decodeShort __attribute__((swift_name("decodeShort()")));
- (NSString *)decodeString __attribute__((swift_name("decodeString()")));
@property (readonly) TCCKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutex")))
@protocol TCCKotlinx_coroutines_coreMutex
@required
- (BOOL)holdsLockOwner:(id)owner __attribute__((swift_name("holdsLock(owner:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)lockOwner:(id _Nullable)owner completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("lock(owner:completionHandler:)")));
- (BOOL)tryLockOwner:(id _Nullable)owner __attribute__((swift_name("tryLock(owner:)")));
- (void)unlockOwner:(id _Nullable)owner __attribute__((swift_name("unlock(owner:)")));
@property (readonly) BOOL isLocked __attribute__((swift_name("isLocked")));
@property (readonly) id<TCCKotlinx_coroutines_coreSelectClause2> onLock __attribute__((swift_name("onLock"))) __attribute__((deprecated("Mutex.onLock deprecated without replacement. For additional details please refer to #2794")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.0")
*/
__attribute__((swift_name("KotlinAutoCloseable")))
@protocol TCCKotlinAutoCloseable
@required
- (void)close __attribute__((swift_name("close()")));
@end

__attribute__((swift_name("Ktor_ioCloseable")))
@protocol TCCKtor_ioCloseable <TCCKotlinAutoCloseable>
@required
@end


/**
 * A multiplatform asynchronous HTTP client that allows you to make requests, handle responses,
 * and extend its functionality with plugins such as authentication, JSON serialization, and more.
 *
 * # Creating client
 * To create a new client, you can call:
 * ```kotlin
 * val client = HttpClient()
 * ```
 * You can create as many clients as you need.
 *
 * If you no longer need the client, please consider closing it to release resources:
 * ```
 * client.close()
 * ```
 *
 * To learn more on how to create and configure an [HttpClient] see the tutorial page:
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * # Making API Requests
 * For every HTTP method (GET, POST, PUT, etc.), there is a corresponding function:
 * ```kotlin
 * val response: HttpResponse = client.get("https://ktor.io/")
 * val body = response.bodyAsText()
 * ```
 * See [Making HTTP requests](https://ktor.io/docs/client-requests.html) for more details.
 *
 * # Query Parameters
 * Add query parameters to your request using the `parameter` function:
 * ```kotlin
 * val response = client.get("https://google.com/search") {
 *     url {
 *         parameter("q", "REST API with Ktor")
 *     }
 * }
 * ```
 * For more information, refer to [Passing request parameters](https://ktor.io/docs/client-requests.html#parameters).
 *
 * # Adding Headers
 * Include headers in your request using the `headers` builder or the `header` function:
 * ```kotlin
 * val response = client.get("https://httpbin.org/bearer") {
 *     headers {
 *         append("Authorization", "Bearer your_token_here")
 *         append("Accept", "application/json")
 *     }
 * }
 * ```
 * Learn more at [Adding headers to a request](https://ktor.io/docs/client-requests.html#headers).
 *
 * # JSON Serialization
 * Add dependencies:
 * - io.ktor:ktor-client-content-negotiation:3.+
 * - io.ktor:ktor-serialization-kotlinx-json:3.+
 * Add Gradle plugin:
 * ```
 * plugins {
 *     kotlin("plugin.serialization")
 * }
 * ```
 *
 * Send and receive JSON data by installing the `ContentNegotiation` plugin with `kotlinx.serialization`:
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         json()
 *     }
 * }
 *
 * @Serializable
 * data class MyRequestType(val someData: String)
 *
 * @Serializable
 * data class MyResponseType(val someResponseData: String)
 *
 * val response: MyResponseType = client.post("https://api.example.com/data") {
 *     contentType(ContentType.Application.Json)
 *     setBody(MyRequestType(someData = "value"))
 * }.body()
 * ```
 * See [Serializing JSON data](https://ktor.io/docs/client-serialization.html) for maven configuration and other details.
 *
 * # Submitting Forms
 * Submit form data using `FormDataContent` or the `submitForm` function:
 * ```kotlin
 * // Using FormDataContent
 * val response = client.post("https://example.com/submit") {
 *     setBody(FormDataContent(Parameters.build {
 *         append("username", "user")
 *         append("password", "pass")
 *     }))
 * }
 *
 * // Or using submitForm
 * val response = client.submitForm(
 *     url = "https://example.com/submit",
 *     formParameters = Parameters.build {
 *         append("username", "user")
 *         append("password", "pass")
 *     }
 * )
 * ```
 * More information is available at [Submitting form parameters](https://ktor.io/docs/client-requests.html#form_parameters).
 *
 * # Handling Authentication
 * Add dependency: io.ktor:ktor-client-auth:3.+
 *
 * Use the `Auth` plugin to handle various authentication schemes like Basic or Bearer token authentication:
 * ```kotlin
 * val client = HttpClient {
 *     install(Auth) {
 *         bearer {
 *             loadTokens {
 *                 BearerTokens(accessToken = "your_access_token", refreshToken = "your_refresh_token")
 *             }
 *         }
 *     }
 * }
 *
 * val response = client.get("https://api.example.com/protected")
 * ```
 * Refer to [Client authentication](https://ktor.io/docs/client-auth.html) for more details.
 *
 * # Setting Timeouts and Retries
 * Configure timeouts and implement retry logic for your requests:
 * ```kotlin
 * val client = HttpClient {
 *     install(HttpTimeout) {
 *         requestTimeoutMillis = 10000
 *         connectTimeoutMillis = 5000
 *         socketTimeoutMillis = 15000
 *     }
 * }
 * ```
 *
 * For the request timeout:
 * ```kotlin
 * client.get("") {
 *     timeout {
 *         requestTimeoutMillis = 1000
 *     }
 * }
 * ```
 * See [Timeout](https://ktor.io/docs/client-timeout.html) for more information.
 *
 * # Handling Cookies
 *
 * Manage cookies automatically by installing the `HttpCookies` plugin:
 * ```kotlin
 * val client = HttpClient {
 *     install(HttpCookies) {
 *         storage = AcceptAllCookiesStorage()
 *     }
 * }
 *
 * // Accessing cookies
 * val cookies: List<Cookie> = client.cookies("https://example.com")
 * ```
 * Learn more at [Cookies](https://ktor.io/docs/client-cookies.html).
 *
 * # Uploading Files
 * Upload files using multipart/form-data requests:
 * ```kotlin
 * client.submitFormWithBinaryData(
 *      url = "https://example.com/upload",
 *      formData = formData {
 *          append("description", "File upload example")
 *          append("file", {
 *              File("path/to/file.txt").readChannel()
 *          })
 *      }
 *  )
 *
 * See [Uploading data](https://ktor.io/docs/client-requests.html#upload_file) for details.
 *
 * # Using WebSockets
 *
 * Communicate over WebSockets using the `webSocket` function:
 * ```kotlin
 * client.webSocket("wss://echo.websocket.org") {
 *     send(Frame.Text("Hello, WebSocket!"))
 *     val frame = incoming.receive()
 *     if (frame is Frame.Text) {
 *         println("Received: ${frame.readText()}")
 *     }
 * }
 * ```
 * Learn more at [Client WebSockets](https://ktor.io/docs/client-websockets.html).
 *
 * # Error Handling
 * Handle exceptions and HTTP error responses gracefully:
 * val client = HttpClient {
 *     HttpResponseValidator {
 *         validateResponse { response ->
 *             val statusCode = response.status.value
 *             when (statusCode) {
 *                 in 300..399 -> error("Redirects are not allowed")
 *             }
 *         }
 *     }
 * }
 * See [Error handling](https://ktor.io/docs/client-response-validation.html) for more information.
 *
 * # Configuring SSL/TLS
 *
 * Customize SSL/TLS settings for secure connections is engine-specific. Please refer to the following page for
 * the details: [Client SSL/TLS](https://ktor.io/docs/client-ssl.html).
 *
 * # Using Proxies
 * Route requests through an HTTP or SOCKS proxy:
 * ```kotlin
 * val client = HttpClient() {
 *     engine {
 *         proxy = ProxyBuilder.http("http://proxy.example.com:8080")
 *         // For a SOCKS proxy:
 *         // proxy = ProxyBuilder.socks(host = "proxy.example.com", port = 1080)
 *     }
 * }
 * ```
 * See [Using a proxy](https://ktor.io/docs/client-proxy.html) for details.
 *
 * # Streaming Data
 *
 * Stream large data efficiently without loading it entirely into memory.
 *
 * Stream request:
 * ```kotlin
 * val response = client.post("https://example.com/upload") {
 *      setBody(object: OutgoingContent.WriteChannelContent() {
 *          override suspend fun writeTo(channel: ByteWriteChannel) {
 *              repeat(1000) {
 *                  channel.writeString("Hello!")
 *              }
 *          }
 *      })
 * }
 * ```
 *
 * Stream response:
 * ```kotlin
 * client.prepareGet("https://example.com/largefile.zip").execute { response ->
 *     val channel: ByteReadChannel = response.bodyAsChannel()
 *
 *     while (!channel.exhausted()) {
 *         val chunk = channel.readBuffer()
 *         // ...
 *     }
 * }
 * ```
 * Learn more at [Streaming data](https://ktor.io/docs/client-responses.html#streaming).
 *
 * # Using SSE
 * Server-Sent Events (SSE) is a technology that allows a server to continuously push events to a client over an HTTP
 * connection. It's particularly useful in cases where the server needs to send event-based updates without requiring
 * the client to repeatedly poll the server.
 *
 * Install the plugin:
 * ```kotlin
 * val client = HttpClient(CIO) {
 *     install(SSE)
 * }
 * ```
 *
 * ```
 * client.sse(host = "0.0.0.0", port = 8080, path = "/events") {
 *     while (true) {
 *         for (event in incoming) {
 *             println("Event from server:")
 *             println(event)
 *         }
 *     }
 * }
 * ```
 *
 * Visit [Using SSE](https://ktor.io/docs/client-server-sent-events.html#install_plugin) to learn more.
 *
 * # Customizing a client with plugins
 * To extend out-of-the-box functionality, you can install plugins for a Ktor client:
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         json()
 *     }
 * }
 * ```
 *
 * There are many plugins available out of the box, and you can write your own. See
 * [Create custom client plugins](https://ktor.io/docs/client-custom-plugins.html) to learn more.
 *
 * # Service Loader and Default Engine
 * On JVM, calling `HttpClient()` without specifying an engine uses a service loader mechanism to
 * determine the appropriate default engine. This can introduce a performance overhead, especially on
 * slower devices, such as Android.
 *
 * **Performance Note**: If you are targeting platforms where initialization speed is critical,
 * consider explicitly specifying an engine to avoid the service loader lookup.
 *
 * Example with manual engine specification:
 * ```
 * val client = HttpClient(Apache) // Explicitly uses Apache engine, bypassing service loader
 * ```
 *
 * By directly setting the engine (e.g., `Apache`, `OkHttp`), you can optimize startup performance
 * by preventing the default service loader mechanism.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClient")))
@interface TCCKtor_client_coreHttpClient : TCCBase <TCCKotlinx_coroutines_coreCoroutineScope, TCCKtor_ioCloseable>
- (instancetype)initWithEngine:(id<TCCKtor_client_coreHttpClientEngine>)engine userConfig:(TCCKtor_client_coreHttpClientConfig<TCCKtor_client_coreHttpClientEngineConfig *> *)userConfig __attribute__((swift_name("init(engine:userConfig:)"))) __attribute__((objc_designated_initializer));

/**
 * Initiates the shutdown process for the `HttpClient`. This is a non-blocking call, which
 * means it returns immediately and begins the client closure in the background.
 *
 * ## Usage
 * ```
 * val client = HttpClient()
 * client.close()
 * client.coroutineContext.job.join() // Waits for complete termination if necessary
 * ```
 *
 * ## Important Notes
 * - **Non-blocking**: `close()` only starts the closing process and does not wait for it to complete.
 * - **Coroutine Context**: To wait for all client resources to be freed, use `client.coroutineContext.job.join()`
 *   or `client.coroutineContext.cancel()` to terminate ongoing tasks.
 * - **Manual Engine Management**: If a custom `engine` was manually created, it must be closed explicitly
 *   after calling `client.close()` to release all resources.
 *
 * Example with custom engine management:
 * ```
 * val engine = HttpClientEngine() // Custom engine instance
 * val client = HttpClient(engine)
 *
 * client.close()
 * engine.close() // Ensure manually created engine is also closed
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.close)
 */
- (void)close __attribute__((swift_name("close()")));

/**
 * Returns a new [HttpClient] by copying this client's configuration
 * and additionally configured by the [block] parameter.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.config)
 */
- (TCCKtor_client_coreHttpClient *)configBlock:(void (^)(TCCKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("config(block:)")));

/**
 * Checks if the specified [capability] is supported by this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.isSupported)
 */
- (BOOL)isSupportedCapability:(id<TCCKtor_client_coreHttpClientEngineCapability>)capability __attribute__((swift_name("isSupported(capability:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * Typed attributes used as a lightweight container for this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.attributes)
 */
@property (readonly) id<TCCKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) id<TCCKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@property (readonly) id<TCCKtor_client_coreHttpClientEngine> engine __attribute__((swift_name("engine")));

/**
 * Provides access to the client's engine configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.engineConfig)
 */
@property (readonly) TCCKtor_client_coreHttpClientEngineConfig *engineConfig __attribute__((swift_name("engineConfig")));

/**
 * Provides access to the events of the client's lifecycle.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.monitor)
 */
@property (readonly) TCCKtor_eventsEvents *monitor __attribute__((swift_name("monitor")));

/**
 * A pipeline used for receiving a request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.receivePipeline)
 */
@property (readonly) TCCKtor_client_coreHttpReceivePipeline *receivePipeline __attribute__((swift_name("receivePipeline")));

/**
 * A pipeline used for processing all requests sent by this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.requestPipeline)
 */
@property (readonly) TCCKtor_client_coreHttpRequestPipeline *requestPipeline __attribute__((swift_name("requestPipeline")));

/**
 * A pipeline used for processing all responses sent by the server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.responsePipeline)
 */
@property (readonly) TCCKtor_client_coreHttpResponsePipeline *responsePipeline __attribute__((swift_name("responsePipeline")));

/**
 * A pipeline used for sending a request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.sendPipeline)
 */
@property (readonly) TCCKtor_client_coreHttpSendPipeline *sendPipeline __attribute__((swift_name("sendPipeline")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinNothing")))
@interface TCCKotlinNothing : TCCBase
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/serialization/json/JsonPrimitiveSerializer))
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonPrimitive")))
@interface TCCKotlinx_serialization_jsonJsonPrimitive : TCCKotlinx_serialization_jsonJsonElement
@property (class, readonly, getter=companion) TCCKotlinx_serialization_jsonJsonPrimitiveCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *content __attribute__((swift_name("content")));
@property (readonly) BOOL isString __attribute__((swift_name("isString")));
@end

__attribute__((swift_name("RuntimeTransactionCallbacks")))
@protocol TCCRuntimeTransactionCallbacks
@required
- (void)afterCommitFunction:(void (^)(void))function __attribute__((swift_name("afterCommit(function:)")));
- (void)afterRollbackFunction:(void (^)(void))function __attribute__((swift_name("afterRollback(function:)")));
@end

__attribute__((swift_name("RuntimeTransactionWithoutReturn")))
@protocol TCCRuntimeTransactionWithoutReturn <TCCRuntimeTransactionCallbacks>
@required

/**
 * Rolls back this transaction.
 */
- (void)rollback __attribute__((swift_name("rollback()")));

/**
 * Begin an inner transaction.
 */
- (void)transactionBody:(void (^)(id<TCCRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(body:)")));
@end

__attribute__((swift_name("RuntimeTransactionWithReturn")))
@protocol TCCRuntimeTransactionWithReturn <TCCRuntimeTransactionCallbacks>
@required

/**
 * Rolls back this transaction.
 */
- (void)rollbackReturnValue:(id _Nullable)returnValue __attribute__((swift_name("rollback(returnValue:)")));

/**
 * Begin an inner transaction.
 */
- (id _Nullable)transactionBody_:(id _Nullable (^)(id<TCCRuntimeTransactionWithReturn>))body __attribute__((swift_name("transaction(body_:)")));
@end

__attribute__((swift_name("RuntimeCloseable")))
@protocol TCCRuntimeCloseable
@required
- (void)close __attribute__((swift_name("close()")));
@end


/**
 * Maintains connections to an underlying SQL database and provides APIs for managing transactions
 * and executing SQL statements.
 */
__attribute__((swift_name("RuntimeSqlDriver")))
@protocol TCCRuntimeSqlDriver <TCCRuntimeCloseable>
@required
- (void)addListenerQueryKeys:(TCCKotlinArray<NSString *> *)queryKeys listener:(id<TCCRuntimeQueryListener>)listener __attribute__((swift_name("addListener(queryKeys:listener:)")));

/**
 * The currently open [Transacter.Transaction] on the database.
 *
 * It's up to the implementor how this method behaves for different connection/threading patterns.
 */
- (TCCRuntimeTransacterTransaction * _Nullable)currentTransaction __attribute__((swift_name("currentTransaction()")));

/**
 * Execute a SQL statement.
 *
 * @param [identifier] An opaque, unique value that can be used to implement any driver-side
 *   caching of prepared statements. If [identifier] is null, a fresh statement is required.
 * @param [sql] The SQL string to be executed.
 * @param [parameters] The number of bindable parameters [sql] contains.
 * @param [binders] A lambda which is called before execution to bind any parameters to the SQL
 *   statement.
 *
 * @return The number of rows updated for an INSERT/DELETE/UPDATE, or 0 for other SQL statements.
 *
 * NOTE it is up to the specific driver to correctly return the row changes. Notably the SQLJS
 * driver does not do this and you should query changes() manually.
 */
- (id<TCCRuntimeQueryResult>)executeIdentifier:(TCCInt * _Nullable)identifier sql:(NSString *)sql parameters:(int32_t)parameters binders:(void (^ _Nullable)(id<TCCRuntimeSqlPreparedStatement>))binders __attribute__((swift_name("execute(identifier:sql:parameters:binders:)")));

/**
 * Execute a SQL statement and evaluate its result set using the given block.
 *
 * @param [identifier] An opaque, unique value that can be used to implement any driver-side
 *   caching of prepared statements. If [identifier] is null, a fresh statement is required.
 * @param [sql] The SQL string to be executed.
 * @param [mapper] A lambda which is called with the cursor when the statement is executed
 *   successfully. The generic result of the lambda is returned to the caller, as soon as the
 *   mutual exclusion on the database connection ends. The cursor **must not escape** the block
 *   scope.
 * @param [parameters] The number of bindable parameters [sql] contains.
 * @param [binders] A lambda which is called before execution to bind any parameters to the SQL
 *   statement.
 */
- (id<TCCRuntimeQueryResult>)executeQueryIdentifier:(TCCInt * _Nullable)identifier sql:(NSString *)sql mapper:(id<TCCRuntimeQueryResult> (^)(id<TCCRuntimeSqlCursor>))mapper parameters:(int32_t)parameters binders:(void (^ _Nullable)(id<TCCRuntimeSqlPreparedStatement>))binders __attribute__((swift_name("executeQuery(identifier:sql:mapper:parameters:binders:)")));

/**
 * Start a new [Transacter.Transaction] on the database.
 *
 * It's up to the implementor how this method behaves for different connection/threading patterns.
 */
- (id<TCCRuntimeQueryResult>)doNewTransaction __attribute__((swift_name("doNewTransaction()")));
- (void)notifyListenersQueryKeys:(TCCKotlinArray<NSString *> *)queryKeys __attribute__((swift_name("notifyListeners(queryKeys:)")));
- (void)removeListenerQueryKeys:(TCCKotlinArray<NSString *> *)queryKeys listener:(id<TCCRuntimeQueryListener>)listener __attribute__((swift_name("removeListener(queryKeys:listener:)")));
@end


/**
 * API for creating and migrating a SQL database. The implementation of this interface is generated
 * by SQLDelight.
 *
 * @param T Says whether the generated code for this database is asynchronous or synchronous. Most
 *          implementations of [app.cash.sqldelight.SqlDriver] will require one or the other, which
 *          is enforced by requesting the correlated type of Schema ([QueryResult.Value] for
 *          a synchronous runtime, [QueryResult.AsyncValue] for asynchronous). In a multiplatform
 *          environment where you have some drivers that use an asynchronous runtime, and some that
 *          require synchronous, you can generate an asynchronous runtime and then pass a
 *          synchronous schema to synchronous drivers with [SqlSchema.synchronous()]
 */
__attribute__((swift_name("RuntimeSqlSchema")))
@protocol TCCRuntimeSqlSchema
@required

/**
 * Use [driver] to create the schema from scratch. Assumes no existing database state.
 */
- (id<TCCRuntimeQueryResult>)createDriver:(id<TCCRuntimeSqlDriver>)driver __attribute__((swift_name("create(driver:)")));

/**
 * Use [driver] to migrate from schema [oldVersion] to [newVersion].
 * Each of the [callbacks] are executed during the migration whenever the upgrade to the version specified by
 * [AfterVersion.afterVersion] has been completed.
 */
- (id<TCCRuntimeQueryResult>)migrateDriver:(id<TCCRuntimeSqlDriver>)driver oldVersion:(int64_t)oldVersion newVersion:(int64_t)newVersion callbacks:(TCCKotlinArray<TCCRuntimeAfterVersion *> *)callbacks __attribute__((swift_name("migrate(driver:oldVersion:newVersion:callbacks:)")));

/**
 * The version of this schema.
 */
@property (readonly) int64_t version __attribute__((swift_name("version")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinUnit")))
@interface TCCKotlinUnit : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)unit __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinUnit *shared __attribute__((swift_name("shared")));
- (NSString *)description __attribute__((swift_name("description()")));
@end


/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
__attribute__((swift_name("RuntimeTransacterTransaction")))
@interface TCCRuntimeTransacterTransaction : TCCBase <TCCRuntimeTransactionCallbacks>

/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Queues [function] to be run after this transaction successfully commits.
 */
- (void)afterCommitFunction:(void (^)(void))function __attribute__((swift_name("afterCommit(function:)")));

/**
 * Queues [function] to be run after this transaction rolls back.
 */
- (void)afterRollbackFunction:(void (^)(void))function __attribute__((swift_name("afterRollback(function:)")));

/**
 * Signal to the underlying SQL driver that this transaction should be finished.
 *
 * @param successful Whether the transaction completed successfully or not.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (id<TCCRuntimeQueryResult>)endTransactionSuccessful:(BOOL)successful __attribute__((swift_name("endTransaction(successful:)")));

/**
 * The parent transaction, if there is any.
 *
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCRuntimeTransacterTransaction * _Nullable enclosingTransaction __attribute__((swift_name("enclosingTransaction")));
@end

__attribute__((swift_name("RuntimeExecutableQuery")))
@interface TCCRuntimeExecutableQuery<__covariant RowType> : TCCBase
- (instancetype)initWithMapper:(RowType (^)(id<TCCRuntimeSqlCursor>))mapper __attribute__((swift_name("init(mapper:)"))) __attribute__((objc_designated_initializer));

/**
 * Execute the underlying statement. The resulting cursor is passed to the given block.
 *
 * The cursor is closed automatically after the block returns.
 */
- (id<TCCRuntimeQueryResult>)executeMapper:(id<TCCRuntimeQueryResult> (^)(id<TCCRuntimeSqlCursor>))mapper __attribute__((swift_name("execute(mapper:)")));

/**
 * @return The result set of the underlying SQL statement as a list of [RowType].
 */
- (NSArray<RowType> *)executeAsList __attribute__((swift_name("executeAsList()")));

/**
 * @return The only row of the result set for the underlying SQL statement as a non null
 *   [RowType].
 *
 * @throws NullPointerException if when executed this query has no rows in its result set.
 * @throws IllegalStateException if when executed this query has multiple rows in its result set.
 */
- (RowType)executeAsOne __attribute__((swift_name("executeAsOne()")));

/**
 * @return The first row of the result set for the underlying SQL statement as a non null
 *   [RowType] or null if the result set has no rows.
 *
 * @throws IllegalStateException if when executed this query has multiple rows in its result set.
 */
- (RowType _Nullable)executeAsOneOrNull __attribute__((swift_name("executeAsOneOrNull()")));
@property (readonly) RowType (^mapper)(id<TCCRuntimeSqlCursor>) __attribute__((swift_name("mapper")));
@end


/**
 * A listenable, typed query generated by SQLDelight.
 *
 * @param RowType the type that this query can map its result set to.
 *
 * @property mapper The mapper this [Query] was created with, which can convert a row in the SQL
 *   cursor returned by [execute] to [RowType].
 */
__attribute__((swift_name("RuntimeQuery")))
@interface TCCRuntimeQuery<__covariant RowType> : TCCRuntimeExecutableQuery<RowType>
- (instancetype)initWithMapper:(RowType (^)(id<TCCRuntimeSqlCursor>))mapper __attribute__((swift_name("init(mapper:)"))) __attribute__((objc_designated_initializer));

/**
 * Register a listener to be notified of future changes in the result set.
 */
- (void)addListenerListener:(id<TCCRuntimeQueryListener>)listener __attribute__((swift_name("addListener(listener:)")));

/**
 * Remove a listener to no longer be notified of future changes in the result set.
 */
- (void)removeListenerListener:(id<TCCRuntimeQueryListener>)listener __attribute__((swift_name("removeListener(listener:)")));
@end


/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClientConfig")))
@interface TCCKtor_client_coreHttpClientConfig<T> : TCCBase

/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Clones this [HttpClientConfig] by duplicating all the [plugins] and [customInterceptors].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.clone)
 */
- (TCCKtor_client_coreHttpClientConfig<T> *)clone __attribute__((swift_name("clone()")));

/**
 * A builder for configuring engine-specific settings in [HttpClientEngineConfig],
 * such as dispatcher, thread count, proxy, and more.
 *
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>
 *     engine { // CIOEngineConfig.() -> Unit
 *         proxy = ProxyBuilder.http("proxy.example.com", 8080)
 *     }
 * ```
 *
 * You can learn more from [Engines](https://ktor.io/docs/http-client-engines.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.engine)
 */
- (void)engineBlock:(void (^)(T))block __attribute__((swift_name("engine(block:)")));

/**
 * Applies all the installed [plugins] and [customInterceptors] from this configuration
 * into the specified [client].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installClient:(TCCKtor_client_coreHttpClient *)client __attribute__((swift_name("install(client:)")));

/**
 * Installs the specified [plugin] and optionally configures it using the [configure] block.
 *
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         // configuration block
 *         json()
 *     }
 * }
 * ```
 *
 * If the plugin is already installed, the configuration block will be applied to the existing configuration class.
 *
 * Learn more from [Plugins](https://ktor.io/docs/http-client-plugins.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installPlugin:(id<TCCKtor_client_coreHttpClientPlugin>)plugin configure:(void (^)(id))configure __attribute__((swift_name("install(plugin:configure:)")));

/**
 * Installs an interceptor defined by [block].
 * The [key] parameter is used as a unique name, that also prevents installing duplicated interceptors.
 *
 * If the [key] is already used, the new interceptor will replace the old one.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installKey:(NSString *)key block:(void (^)(TCCKtor_client_coreHttpClient *))block __attribute__((swift_name("install(key:block:)")));

/**
 * Installs the plugin from the [other] client's configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.plusAssign)
 */
- (void)plusAssignOther:(TCCKtor_client_coreHttpClientConfig<T> *)other __attribute__((swift_name("plusAssign(other:)")));

/**
 * Development mode is no longer required all functionality is enabled by default. The property is safe to remove.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.developmentMode)
 */
@property BOOL developmentMode __attribute__((swift_name("developmentMode"))) __attribute__((deprecated("Development mode is no longer required. The property will be removed in the future.")));

/**
 * Terminates [HttpClient.receivePipeline] if the status code is not successful (>=300).
 * Learn more from [Response validation](https://ktor.io/docs/response-validation.html).
 *
 * For more details, see the [HttpCallValidator] documentation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.expectSuccess)
 */
@property BOOL expectSuccess __attribute__((swift_name("expectSuccess")));

/**
 * Specifies whether the client redirects to URLs provided in the `Location` header.
 * You can disable redirections by setting this property to `false`.
 *
 * For an advanced redirection configuration, use the [HttpRedirect] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.followRedirects)
 */
@property BOOL followRedirects __attribute__((swift_name("followRedirects")));

/**
 * Enables body transformations for many common types like [String], [ByteArray], [ByteReadChannel], etc.
 * These transformations are applied to the request and response bodies.
 *
 * The transformers will be used when the response body is received with a type:
 * ```kotlin
 * val client = HttpClient()
 * val bytes = client.get("https://ktor.io")
 *                   .body<ByteArray>()
 * ```
 *
 * This flag is enabled by default.
 * You might want to disable it if you want to write your own transformers or handle body manually.
 *
 * For more details, see the [defaultTransformers] documentation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.useDefaultTransformers)
 */
@property BOOL useDefaultTransformers __attribute__((swift_name("useDefaultTransformers")));
@end


/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreWebSockets.Config")))
@interface TCCKtor_client_coreWebSocketsConfig : TCCBase

/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Configure WebSocket extensions.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.extensions)
 */
- (void)extensionsBlock:(void (^)(TCCKtor_websocketsWebSocketExtensionsConfig *))block __attribute__((swift_name("extensions(block:)")));

/**
 * A converter for serialization/deserialization
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.contentConverter)
 */
@property id<TCCKtor_serializationWebsocketContentConverter> _Nullable contentConverter __attribute__((swift_name("contentConverter")));

/**
 * Sets maximum frame size in bytes.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.maxFrameSize)
 */
@property int64_t maxFrameSize __attribute__((swift_name("maxFrameSize")));

/**
 * Sets interval of sending ping frames.
 *
 * Use [PINGER_DISABLED] to disable ping.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.pingIntervalMillis)
 */
@property int64_t pingIntervalMillis __attribute__((swift_name("pingIntervalMillis")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinByteArray")))
@interface TCCKotlinByteArray : TCCBase
+ (instancetype)arrayWithSize:(int32_t)size __attribute__((swift_name("init(size:)")));
+ (instancetype)arrayWithSize:(int32_t)size init:(TCCByte *(^)(TCCInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (int8_t)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (TCCKotlinByteIterator *)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(int8_t)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormat")))
@protocol TCCKotlinx_datetimeDateTimeFormat
@required
- (NSString *)formatValue:(id _Nullable)value __attribute__((swift_name("format(value:)")));
- (id<TCCKotlinAppendable>)formatToAppendable:(id<TCCKotlinAppendable>)appendable value:(id _Nullable)value __attribute__((swift_name("formatTo(appendable:value:)")));
- (id _Nullable)parseInput:(id)input __attribute__((swift_name("parse(input:)")));
- (id _Nullable)parseOrNullInput:(id)input __attribute__((swift_name("parseOrNull(input:)")));
@end

__attribute__((swift_name("KotlinSuspendFunction1")))
@protocol TCCKotlinSuspendFunction1 <TCCKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kermit_coreSeverity")))
@interface TCCKermit_coreSeverity : TCCKotlinEnum<TCCKermit_coreSeverity *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCKermit_coreSeverity *verbose __attribute__((swift_name("verbose")));
@property (class, readonly) TCCKermit_coreSeverity *debug __attribute__((swift_name("debug")));
@property (class, readonly) TCCKermit_coreSeverity *info __attribute__((swift_name("info")));
@property (class, readonly) TCCKermit_coreSeverity *warn __attribute__((swift_name("warn")));
@property (class, readonly) TCCKermit_coreSeverity *error __attribute__((swift_name("error")));
@property (class, readonly) TCCKermit_coreSeverity *assert __attribute__((swift_name("assert")));
+ (TCCKotlinArray<TCCKermit_coreSeverity *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKermit_coreSeverity *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kermit_ioRollingFileLogWriterConfig")))
@interface TCCKermit_ioRollingFileLogWriterConfig : TCCBase
- (instancetype)initWithLogFileName:(NSString *)logFileName logFilePath:(TCCKotlinx_io_corePath *)logFilePath rollOnSize:(int64_t)rollOnSize maxLogFiles:(int32_t)maxLogFiles logTag:(BOOL)logTag prependTimestamp:(BOOL)prependTimestamp __attribute__((swift_name("init(logFileName:logFilePath:rollOnSize:maxLogFiles:logTag:prependTimestamp:)"))) __attribute__((objc_designated_initializer));
- (TCCKermit_ioRollingFileLogWriterConfig *)doCopyLogFileName:(NSString *)logFileName logFilePath:(TCCKotlinx_io_corePath *)logFilePath rollOnSize:(int64_t)rollOnSize maxLogFiles:(int32_t)maxLogFiles logTag:(BOOL)logTag prependTimestamp:(BOOL)prependTimestamp __attribute__((swift_name("doCopy(logFileName:logFilePath:rollOnSize:maxLogFiles:logTag:prependTimestamp:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *logFileName __attribute__((swift_name("logFileName")));
@property (readonly) TCCKotlinx_io_corePath *logFilePath __attribute__((swift_name("logFilePath")));
@property (readonly) BOOL logTag __attribute__((swift_name("logTag")));
@property (readonly) int32_t maxLogFiles __attribute__((swift_name("maxLogFiles")));
@property (readonly) BOOL prependTimestamp __attribute__((swift_name("prependTimestamp")));
@property (readonly) int64_t rollOnSize __attribute__((swift_name("rollOnSize")));
@end

__attribute__((swift_name("Kermit_coreMessageStringFormatter")))
@protocol TCCKermit_coreMessageStringFormatter
@required
- (NSString *)formatMessageSeverity:(TCCKermit_coreSeverity * _Nullable)severity tag:(id _Nullable)tag message:(id)message __attribute__((swift_name("formatMessage(severity:tag:message:)")));
- (NSString *)formatSeveritySeverity:(TCCKermit_coreSeverity *)severity __attribute__((swift_name("formatSeverity(severity:)")));
- (NSString *)formatTagTag:(id)tag __attribute__((swift_name("formatTag(tag:)")));
@end

__attribute__((swift_name("Kotlinx_io_coreFileSystem")))
@protocol TCCKotlinx_io_coreFileSystem
@required
- (void)atomicMoveSource:(TCCKotlinx_io_corePath *)source destination:(TCCKotlinx_io_corePath *)destination __attribute__((swift_name("atomicMove(source:destination:)")));
- (void)createDirectoriesPath:(TCCKotlinx_io_corePath *)path mustCreate:(BOOL)mustCreate __attribute__((swift_name("createDirectories(path:mustCreate:)")));
- (void)deletePath:(TCCKotlinx_io_corePath *)path mustExist:(BOOL)mustExist __attribute__((swift_name("delete(path:mustExist:)")));
- (BOOL)existsPath:(TCCKotlinx_io_corePath *)path __attribute__((swift_name("exists(path:)")));
- (id)listDirectory:(TCCKotlinx_io_corePath *)directory __attribute__((swift_name("list(directory:)")));
- (TCCKotlinx_io_coreFileMetadata * _Nullable)metadataOrNullPath:(TCCKotlinx_io_corePath *)path __attribute__((swift_name("metadataOrNull(path:)")));
- (TCCKotlinx_io_corePath *)resolvePath:(TCCKotlinx_io_corePath *)path __attribute__((swift_name("resolve(path:)")));
- (id<TCCKotlinx_io_coreRawSink>)sinkPath:(TCCKotlinx_io_corePath *)path append:(BOOL)append __attribute__((swift_name("sink(path:append:)")));
- (id<TCCKotlinx_io_coreRawSource>)sourcePath:(TCCKotlinx_io_corePath *)path __attribute__((swift_name("source(path:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.1")
 *   kotlin.time.ExperimentalTime
*/
__attribute__((swift_name("KotlinClock")))
@protocol TCCKotlinClock
@required
- (TCCKotlinInstant *)now __attribute__((swift_name("now()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_corePath")))
@interface TCCKotlinx_io_corePath : TCCBase
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL isAbsolute __attribute__((swift_name("isAbsolute")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) TCCKotlinx_io_corePath * _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("Kermit_coreBaseLogger")))
@interface TCCKermit_coreBaseLogger : TCCBase
- (instancetype)initWithConfig:(id<TCCKermit_coreLoggerConfig>)config __attribute__((swift_name("init(config:)"))) __attribute__((objc_designated_initializer));
- (void)logSeverity:(TCCKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *)message __attribute__((swift_name("log(severity:tag:throwable:message:)")));
- (void)logBlockSeverity:(TCCKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("logBlock(severity:tag:throwable:message:)")));
- (void)processLogSeverity:(TCCKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *)message __attribute__((swift_name("processLog(severity:tag:throwable:message:)")));
@property (readonly) id<TCCKermit_coreLoggerConfig> config __attribute__((swift_name("config")));
@property (readonly) id<TCCKermit_coreMutableLoggerConfig> mutableConfig __attribute__((swift_name("mutableConfig")));
@end

__attribute__((swift_name("KermitLogger")))
@interface TCCKermitLogger : TCCKermit_coreBaseLogger
- (instancetype)initWithConfig:(id<TCCKermit_coreLoggerConfig>)config tag:(NSString *)tag __attribute__((swift_name("init(config:tag:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(id<TCCKermit_coreLoggerConfig>)config __attribute__((swift_name("init(config:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKermitLoggerCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)aMessageString:(NSString *)messageString throwable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("a(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)aThrowable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("a(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)dMessageString:(NSString *)messageString throwable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("d(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)dThrowable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("d(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)eMessageString:(NSString *)messageString throwable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("e(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)eThrowable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("e(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)iMessageString:(NSString *)messageString throwable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("i(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)iThrowable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("i(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)vMessageString:(NSString *)messageString throwable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("v(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)vThrowable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("v(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)wMessageString:(NSString *)messageString throwable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("w(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)wThrowable:(TCCKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("w(throwable:tag:message:)")));
- (TCCKermitLogger *)withTagTag:(NSString *)tag __attribute__((swift_name("withTag(tag:)")));
@property (readonly) NSString *tag __attribute__((swift_name("tag")));
@end


/**
 * Channel for asynchronous writing of sequences of bytes.
 * This is a **single-writer channel**.
 *
 * Operations on this channel cannot be invoked concurrently, unless explicitly specified otherwise
 * in the description. Exceptions are [close] and [flush].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteWriteChannel)
 */
__attribute__((swift_name("Ktor_ioByteWriteChannel")))
@protocol TCCKtor_ioByteWriteChannel
@required
- (void)cancelCause_:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flush(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
@property (readonly) BOOL autoFlush __attribute__((swift_name("autoFlush")));
@property (readonly) TCCKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForWrite __attribute__((swift_name("isClosedForWrite")));
@property (readonly) id<TCCKotlinx_io_coreSink> writeBuffer __attribute__((swift_name("writeBuffer")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreDisposableHandle")))
@protocol TCCKotlinx_coroutines_coreDisposableHandle
@required
- (void)dispose __attribute__((swift_name("dispose()")));
@end


/**
 * Base type for all async sockets
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ASocket)
 */
__attribute__((swift_name("Ktor_networkASocket")))
@protocol TCCKtor_networkASocket <TCCKtor_ioCloseable, TCCKotlinx_coroutines_coreDisposableHandle>
@required

/**
 * Represents a socket lifetime, completes at socket closure
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ASocket.socketContext)
 */
@property (readonly) id<TCCKotlinx_coroutines_coreJob> socketContext __attribute__((swift_name("socketContext")));
@end


/**
 * Represent a readable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AReadable)
 */
__attribute__((swift_name("Ktor_networkAReadable")))
@protocol TCCKtor_networkAReadable
@required

/**
 * Attach [channel] for reading so incoming bytes appears in the attached channel.
 * Only one channel could be attached
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AReadable.attachForReading)
 *
 * @return a job that does supply data
 */
- (TCCKtor_ioWriterJob *)attachForReadingChannel:(TCCKtor_ioByteChannel *)channel __attribute__((swift_name("attachForReading(channel:)")));
@end


/**
 * Represents a writable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AWritable)
 */
__attribute__((swift_name("Ktor_networkAWritable")))
@protocol TCCKtor_networkAWritable
@required

/**
 * Attach [channel] for writing so bytes written to the attached channel will be transmitted
 * Only one channel could be attached
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AWritable.attachForWriting)
 *
 * @return a job that does transmit data from the channel
 */
- (TCCKtor_ioReaderJob *)attachForWritingChannel:(TCCKtor_ioByteChannel *)channel __attribute__((swift_name("attachForWriting(channel:)")));
@end


/**
 * Represents both readable and writable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ReadWriteSocket)
 */
__attribute__((swift_name("Ktor_networkReadWriteSocket")))
@protocol TCCKtor_networkReadWriteSocket <TCCKtor_networkASocket, TCCKtor_networkAReadable, TCCKtor_networkAWritable>
@required
@end


/**
 * Represents a bound socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ABoundSocket)
 */
__attribute__((swift_name("Ktor_networkABoundSocket")))
@protocol TCCKtor_networkABoundSocket
@required

/**
 * Local socket address. Could throw an exception if no address bound yet.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ABoundSocket.localAddress)
 */
@property (readonly) TCCKtor_networkSocketAddress *localAddress __attribute__((swift_name("localAddress")));
@end


/**
 * Represent a connected socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AConnectedSocket)
 */
__attribute__((swift_name("Ktor_networkAConnectedSocket")))
@protocol TCCKtor_networkAConnectedSocket
@required

/**
 * Remote socket address. Could throw an exception if the peer is not yet connected or already disconnected.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AConnectedSocket.remoteAddress)
 */
@property (readonly) TCCKtor_networkSocketAddress *remoteAddress __attribute__((swift_name("remoteAddress")));
@end


/**
 * Represents a connected socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.Socket)
 */
__attribute__((swift_name("Ktor_networkSocket")))
@protocol TCCKtor_networkSocket <TCCKtor_networkReadWriteSocket, TCCKtor_networkABoundSocket, TCCKtor_networkAConnectedSocket, TCCKotlinx_coroutines_coreCoroutineScope>
@required
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalDateSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDate")))
@interface TCCKotlinx_datetimeLocalDate : TCCBase <TCCKotlinComparable>
- (instancetype)initWithYear:(int32_t)year month:(int32_t)month day:(int32_t)day __attribute__((swift_name("init(year:month:day:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(TCCKotlinx_datetimeMonth *)month day_:(int32_t)day __attribute__((swift_name("init(year:month:day_:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinx_datetimeLocalDateCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TCCKotlinx_datetimeLocalDate *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TCCKotlinx_datetimeLocalDateRange *)rangeToThat:(TCCKotlinx_datetimeLocalDate *)that __attribute__((swift_name("rangeTo(that:)")));
- (TCCKotlinx_datetimeLocalDateRange *)rangeUntilThat:(TCCKotlinx_datetimeLocalDate *)that __attribute__((swift_name("rangeUntil(that:)")));
- (int64_t)toEpochDays __attribute__((swift_name("toEpochDays()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t day __attribute__((swift_name("day")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth"))) __attribute__((deprecated("Use the 'day' property instead")));
@property (readonly) TCCKotlinx_datetimeDayOfWeek *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) TCCKotlinx_datetimeMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t monthNumber __attribute__((swift_name("monthNumber"))) __attribute__((deprecated("Use the 'month' property instead")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalTimeSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalTime")))
@interface TCCKotlinx_datetimeLocalTime : TCCBase <TCCKotlinComparable>
- (instancetype)initWithHour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinx_datetimeLocalTimeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TCCKotlinx_datetimeLocalTime *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (int32_t)toMillisecondOfDay __attribute__((swift_name("toMillisecondOfDay()")));
- (int64_t)toNanosecondOfDay __attribute__((swift_name("toNanosecondOfDay()")));
- (int32_t)toSecondOfDay __attribute__((swift_name("toSecondOfDay()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t hour __attribute__((swift_name("hour")));
@property (readonly) int32_t minute __attribute__((swift_name("minute")));
@property (readonly) int32_t nanosecond __attribute__((swift_name("nanosecond")));
@property (readonly) int32_t second __attribute__((swift_name("second")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonth")))
@interface TCCKotlinx_datetimeMonth : TCCKotlinEnum<TCCKotlinx_datetimeMonth *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCKotlinx_datetimeMonth *january __attribute__((swift_name("january")));
@property (class, readonly) TCCKotlinx_datetimeMonth *february __attribute__((swift_name("february")));
@property (class, readonly) TCCKotlinx_datetimeMonth *march __attribute__((swift_name("march")));
@property (class, readonly) TCCKotlinx_datetimeMonth *april __attribute__((swift_name("april")));
@property (class, readonly) TCCKotlinx_datetimeMonth *may __attribute__((swift_name("may")));
@property (class, readonly) TCCKotlinx_datetimeMonth *june __attribute__((swift_name("june")));
@property (class, readonly) TCCKotlinx_datetimeMonth *july __attribute__((swift_name("july")));
@property (class, readonly) TCCKotlinx_datetimeMonth *august __attribute__((swift_name("august")));
@property (class, readonly) TCCKotlinx_datetimeMonth *september __attribute__((swift_name("september")));
@property (class, readonly) TCCKotlinx_datetimeMonth *october __attribute__((swift_name("october")));
@property (class, readonly) TCCKotlinx_datetimeMonth *november __attribute__((swift_name("november")));
@property (class, readonly) TCCKotlinx_datetimeMonth *december __attribute__((swift_name("december")));
+ (TCCKotlinArray<TCCKotlinx_datetimeMonth *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKotlinx_datetimeMonth *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateTime.Companion")))
@interface TCCKotlinx_datetimeLocalDateTimeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeLocalDateTimeCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_datetimeDateTimeFormat>)FormatBuilder:(void (^)(id<TCCKotlinx_datetimeDateTimeFormatBuilderWithDateTime>))builder __attribute__((swift_name("Format(builder:)")));
- (TCCKotlinx_datetimeLocalDateTime *)parseInput:(id)input format:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeek")))
@interface TCCKotlinx_datetimeDayOfWeek : TCCKotlinEnum<TCCKotlinx_datetimeDayOfWeek *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCKotlinx_datetimeDayOfWeek *monday __attribute__((swift_name("monday")));
@property (class, readonly) TCCKotlinx_datetimeDayOfWeek *tuesday __attribute__((swift_name("tuesday")));
@property (class, readonly) TCCKotlinx_datetimeDayOfWeek *wednesday __attribute__((swift_name("wednesday")));
@property (class, readonly) TCCKotlinx_datetimeDayOfWeek *thursday __attribute__((swift_name("thursday")));
@property (class, readonly) TCCKotlinx_datetimeDayOfWeek *friday __attribute__((swift_name("friday")));
@property (class, readonly) TCCKotlinx_datetimeDayOfWeek *saturday __attribute__((swift_name("saturday")));
@property (class, readonly) TCCKotlinx_datetimeDayOfWeek *sunday __attribute__((swift_name("sunday")));
+ (TCCKotlinArray<TCCKotlinx_datetimeDayOfWeek *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKotlinx_datetimeDayOfWeek *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeTimeZone.Companion")))
@interface TCCKotlinx_datetimeTimeZoneCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeTimeZoneCompanion *shared __attribute__((swift_name("shared")));
- (TCCKotlinx_datetimeTimeZone *)currentSystemDefault __attribute__((swift_name("currentSystemDefault()")));
- (TCCKotlinx_datetimeTimeZone *)ofZoneId:(NSString *)zoneId __attribute__((swift_name("of(zoneId:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) TCCKotlinx_datetimeFixedOffsetTimeZone *UTC __attribute__((swift_name("UTC")));
@property (readonly) NSSet<NSString *> *availableZoneIds __attribute__((swift_name("availableZoneIds")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.1")
 *   kotlin.time.ExperimentalTime
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinInstant")))
@interface TCCKotlinInstant : TCCBase <TCCKotlinComparable>
@property (class, readonly, getter=companion) TCCKotlinInstantCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TCCKotlinInstant *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TCCKotlinInstant *)minusDuration:(int64_t)duration __attribute__((swift_name("minus(duration:)")));
- (int64_t)minusOther:(TCCKotlinInstant *)other __attribute__((swift_name("minus(other:)")));
- (TCCKotlinInstant *)plusDuration:(int64_t)duration __attribute__((swift_name("plus(duration:)")));
- (int64_t)toEpochMilliseconds __attribute__((swift_name("toEpochMilliseconds()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int64_t epochSeconds __attribute__((swift_name("epochSeconds")));
@property (readonly) int32_t nanosecondsOfSecond __attribute__((swift_name("nanosecondsOfSecond")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeOverloadMarker")))
@interface TCCKotlinx_datetimeOverloadMarker : TCCBase
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialFormat")))
@protocol TCCKotlinx_serialization_coreSerialFormat
@required
@property (readonly) TCCKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreStringFormat")))
@protocol TCCKotlinx_serialization_coreStringFormat <TCCKotlinx_serialization_coreSerialFormat>
@required
- (id _Nullable)decodeFromStringDeserializer:(id<TCCKotlinx_serialization_coreDeserializationStrategy>)deserializer string:(NSString *)string __attribute__((swift_name("decodeFromString(deserializer:string:)")));
- (NSString *)encodeToStringSerializer:(id<TCCKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToString(serializer:value:)")));
@end

__attribute__((swift_name("Kotlinx_serialization_jsonJson")))
@interface TCCKotlinx_serialization_jsonJson : TCCBase <TCCKotlinx_serialization_coreStringFormat>
@property (class, readonly, getter=companion) TCCKotlinx_serialization_jsonJsonDefault *companion __attribute__((swift_name("companion")));
- (id _Nullable)decodeFromJsonElementDeserializer:(id<TCCKotlinx_serialization_coreDeserializationStrategy>)deserializer element:(TCCKotlinx_serialization_jsonJsonElement *)element __attribute__((swift_name("decodeFromJsonElement(deserializer:element:)")));
- (id _Nullable)decodeFromStringString:(NSString *)string __attribute__((swift_name("decodeFromString(string:)")));
- (id _Nullable)decodeFromStringDeserializer:(id<TCCKotlinx_serialization_coreDeserializationStrategy>)deserializer string:(NSString *)string __attribute__((swift_name("decodeFromString(deserializer:string:)")));
- (TCCKotlinx_serialization_jsonJsonElement *)encodeToJsonElementSerializer:(id<TCCKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToJsonElement(serializer:value:)")));
- (NSString *)encodeToStringValue:(id _Nullable)value __attribute__((swift_name("encodeToString(value:)")));
- (NSString *)encodeToStringSerializer:(id<TCCKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToString(serializer:value:)")));
- (TCCKotlinx_serialization_jsonJsonElement *)parseToJsonElementString:(NSString *)string __attribute__((swift_name("parseToJsonElement(string:)")));
@property (readonly) TCCKotlinx_serialization_jsonJsonConfiguration *configuration __attribute__((swift_name("configuration")));
@property (readonly) TCCKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreChildHandle")))
@protocol TCCKotlinx_coroutines_coreChildHandle <TCCKotlinx_coroutines_coreDisposableHandle>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (BOOL)childCancelledCause:(TCCKotlinThrowable *)cause __attribute__((swift_name("childCancelled(cause:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
@property (readonly) id<TCCKotlinx_coroutines_coreJob> _Nullable parent __attribute__((swift_name("parent")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreChildJob")))
@protocol TCCKotlinx_coroutines_coreChildJob <TCCKotlinx_coroutines_coreJob>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (void)parentCancelledParentJob:(id<TCCKotlinx_coroutines_coreParentJob>)parentJob __attribute__((swift_name("parentCancelled(parentJob:)")));
@end

__attribute__((swift_name("KotlinSequence")))
@protocol TCCKotlinSequence
@required
- (id<TCCKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause")))
@protocol TCCKotlinx_coroutines_coreSelectClause
@required
@property (readonly) id clauseObject __attribute__((swift_name("clauseObject")));
@property (readonly) TCCKotlinUnit *(^(^ _Nullable onCancellationConstructor)(id<TCCKotlinx_coroutines_coreSelectInstance>, id _Nullable, id _Nullable))(TCCKotlinThrowable *, id _Nullable, id<TCCKotlinCoroutineContext>) __attribute__((swift_name("onCancellationConstructor")));
@property (readonly) id _Nullable (^processResFunc)(id, id _Nullable, id _Nullable) __attribute__((swift_name("processResFunc")));
@property (readonly) void (^regFunc)(id, id<TCCKotlinx_coroutines_coreSelectInstance>, id _Nullable) __attribute__((swift_name("regFunc")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause0")))
@protocol TCCKotlinx_coroutines_coreSelectClause0 <TCCKotlinx_coroutines_coreSelectClause>
@required
@end

__attribute__((swift_name("KotlinCoroutineContextKey")))
@protocol TCCKotlinCoroutineContextKey
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonElement.Companion")))
@interface TCCKotlinx_serialization_jsonJsonElementCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_serialization_jsonJsonElementCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("KotlinIterator")))
@protocol TCCKotlinIterator
@required
- (BOOL)hasNext __attribute__((swift_name("hasNext()")));
- (id _Nullable)next __attribute__((swift_name("next()")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreCompositeEncoder")))
@protocol TCCKotlinx_serialization_coreCompositeEncoder
@required
- (void)encodeBooleanElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(BOOL)value __attribute__((swift_name("encodeBooleanElement(descriptor:index:value:)")));
- (void)encodeByteElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int8_t)value __attribute__((swift_name("encodeByteElement(descriptor:index:value:)")));
- (void)encodeCharElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(unichar)value __attribute__((swift_name("encodeCharElement(descriptor:index:value:)")));
- (void)encodeDoubleElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(double)value __attribute__((swift_name("encodeDoubleElement(descriptor:index:value:)")));
- (void)encodeFloatElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(float)value __attribute__((swift_name("encodeFloatElement(descriptor:index:value:)")));
- (id<TCCKotlinx_serialization_coreEncoder>)encodeInlineElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("encodeInlineElement(descriptor:index:)")));
- (void)encodeIntElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int32_t)value __attribute__((swift_name("encodeIntElement(descriptor:index:value:)")));
- (void)encodeLongElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int64_t)value __attribute__((swift_name("encodeLongElement(descriptor:index:value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNullableSerializableElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index serializer:(id<TCCKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeNullableSerializableElement(descriptor:index:serializer:value:)")));
- (void)encodeSerializableElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index serializer:(id<TCCKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeSerializableElement(descriptor:index:serializer:value:)")));
- (void)encodeShortElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int16_t)value __attribute__((swift_name("encodeShortElement(descriptor:index:value:)")));
- (void)encodeStringElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(NSString *)value __attribute__((swift_name("encodeStringElement(descriptor:index:value:)")));
- (void)endStructureDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("endStructure(descriptor:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)shouldEncodeElementDefaultDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("shouldEncodeElementDefault(descriptor:index:)")));
@property (readonly) TCCKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerializersModule")))
@interface TCCKotlinx_serialization_coreSerializersModule : TCCBase

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)dumpToCollector:(id<TCCKotlinx_serialization_coreSerializersModuleCollector>)collector __attribute__((swift_name("dumpTo(collector:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<TCCKotlinx_serialization_coreKSerializer> _Nullable)getContextualKClass:(id<TCCKotlinKClass>)kClass typeArgumentsSerializers:(NSArray<id<TCCKotlinx_serialization_coreKSerializer>> *)typeArgumentsSerializers __attribute__((swift_name("getContextual(kClass:typeArgumentsSerializers:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<TCCKotlinx_serialization_coreSerializationStrategy> _Nullable)getPolymorphicBaseClass:(id<TCCKotlinKClass>)baseClass value:(id)value __attribute__((swift_name("getPolymorphic(baseClass:value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<TCCKotlinx_serialization_coreDeserializationStrategy> _Nullable)getPolymorphicBaseClass:(id<TCCKotlinKClass>)baseClass serializedClassName:(NSString * _Nullable)serializedClassName __attribute__((swift_name("getPolymorphic(baseClass:serializedClassName:)")));
@end

__attribute__((swift_name("KotlinAnnotation")))
@protocol TCCKotlinAnnotation
@required
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialKind")))
@interface TCCKotlinx_serialization_coreSerialKind : TCCBase
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreCompositeDecoder")))
@protocol TCCKotlinx_serialization_coreCompositeDecoder
@required
- (BOOL)decodeBooleanElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeBooleanElement(descriptor:index:)")));
- (int8_t)decodeByteElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeByteElement(descriptor:index:)")));
- (unichar)decodeCharElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeCharElement(descriptor:index:)")));
- (int32_t)decodeCollectionSizeDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeCollectionSize(descriptor:)")));
- (double)decodeDoubleElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeDoubleElement(descriptor:index:)")));
- (int32_t)decodeElementIndexDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeElementIndex(descriptor:)")));
- (float)decodeFloatElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeFloatElement(descriptor:index:)")));
- (id<TCCKotlinx_serialization_coreDecoder>)decodeInlineElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeInlineElement(descriptor:index:)")));
- (int32_t)decodeIntElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeIntElement(descriptor:index:)")));
- (int64_t)decodeLongElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeLongElement(descriptor:index:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id _Nullable)decodeNullableSerializableElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index deserializer:(id<TCCKotlinx_serialization_coreDeserializationStrategy>)deserializer previousValue:(id _Nullable)previousValue __attribute__((swift_name("decodeNullableSerializableElement(descriptor:index:deserializer:previousValue:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)decodeSequentially __attribute__((swift_name("decodeSequentially()")));
- (id _Nullable)decodeSerializableElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index deserializer:(id<TCCKotlinx_serialization_coreDeserializationStrategy>)deserializer previousValue:(id _Nullable)previousValue __attribute__((swift_name("decodeSerializableElement(descriptor:index:deserializer:previousValue:)")));
- (int16_t)decodeShortElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeShortElement(descriptor:index:)")));
- (NSString *)decodeStringElementDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeStringElement(descriptor:index:)")));
- (void)endStructureDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("endStructure(descriptor:)")));
@property (readonly) TCCKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause2")))
@protocol TCCKotlinx_coroutines_coreSelectClause2 <TCCKotlinx_coroutines_coreSelectClause>
@required
@end


/**
 * Serves as the base interface for an [HttpClient]'s engine.
 *
 * An `HttpClientEngine` represents the underlying network implementation that
 * performs HTTP requests and handles responses.
 * Developers can implement this interface to create custom engines for use with [HttpClient].
 *
 * This interface provides a set of properties and methods that define the
 * contract for configuring, executing, and managing HTTP requests within the engine.
 *
 * For a base implementation that handles common engine functionality, see [HttpClientEngineBase].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngine")))
@protocol TCCKtor_client_coreHttpClientEngine <TCCKotlinx_coroutines_coreCoroutineScope, TCCKtor_ioCloseable>
@required

/**
 * Executes an HTTP request and produces an HTTP response.
 *
 * This function takes [HttpRequestData], which contains all details of the HTTP request,
 * and returns [HttpResponseData] with the server's response, including headers, status code, and body.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.execute)
 *
 * @param data The [HttpRequestData] representing the request to be executed.
 * @return An [HttpResponseData] object containing the server's response.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeData:(TCCKtor_client_coreHttpRequestData *)data completionHandler:(void (^)(TCCKtor_client_coreHttpResponseData * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(data:completionHandler:)")));

/**
 * Installs the engine into an [HttpClient].
 *
 * This method is called when the engine is being set up within an `HttpClient`.
 * Use it to register interceptors, validate configuration, or prepare the engine
 * for use with the client.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.install)
 *
 * @param client The [HttpClient] instance to which the engine is being installed.
 */
- (void)installClient:(TCCKtor_client_coreHttpClient *)client __attribute__((swift_name("install(client:)")));

/**
 * Provides access to the engine's configuration via [HttpClientEngineConfig].
 *
 * The [config] object stores user-defined parameters or settings that control
 * how the engine operates. When creating a custom engine, this property
 * should return the specific configuration implementation.
 *
 * Example:
 * ```kotlin
 * override val config: HttpClientEngineConfig = CustomEngineConfig()
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.config)
 */
@property (readonly) TCCKtor_client_coreHttpClientEngineConfig *config __attribute__((swift_name("config")));

/**
 * Specifies the [CoroutineDispatcher] for I/O operations in the engine.
 *
 * This dispatcher is used for all network-related operations, such as
 * sending requests and receiving responses.
 * By default, it should be optimized for I/O tasks.
 *
 * Example:
 * ```kotlin
 * override val dispatcher: CoroutineDispatcher = Dispatchers.IO
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.dispatcher)
 */
@property (readonly) TCCKotlinx_coroutines_coreCoroutineDispatcher *dispatcher __attribute__((swift_name("dispatcher")));

/**
 * Specifies the set of capabilities supported by this HTTP client engine.
 *
 * Capabilities provide a mechanism for plugins and other components to
 * determine whether the engine supports specific features such as timeouts,
 * WebSocket communication, HTTP/2, HTTP/3, or other advanced networking
 * capabilities. This allows seamless integration of features based on the
 * engine's functionality.
 *
 * Each capability is represented as an instance of [HttpClientEngineCapability],
 * which can carry additional metadata or configurations for the capability.
 *
 * Example:
 * ```kotlin
 * override val supportedCapabilities: Set<HttpClientEngineCapability<*>> = setOf(
 *     WebSocketCapability,
 *     Http2Capability,
 *     TimeoutCapability
 * )
 * ```
 *
 * **Usage in Plugins**:
 * Plugins can check if the engine supports a specific capability before
 * applying behavior:
 * ```kotlin
 * if (engine.supportedCapabilities.contains(WebSocketCapability)) {
 *     // Configure WebSocket-specific settings
 * }
 * ```
 *
 * When implementing a custom engine, ensure this property accurately reflects
 * the engine's abilities to avoid unexpected plugin behavior or runtime errors.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.supportedCapabilities)
 */
@property (readonly) NSSet<id<TCCKtor_client_coreHttpClientEngineCapability>> *supportedCapabilities __attribute__((swift_name("supportedCapabilities")));
@end


/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngineConfig")))
@interface TCCKtor_client_coreHttpClientEngineConfig : TCCBase

/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Allow specifying the coroutine dispatcher to use for IO operations.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.dispatcher)
 */
@property TCCKotlinx_coroutines_coreCoroutineDispatcher * _Nullable dispatcher __attribute__((swift_name("dispatcher")));

/**
 * Enables HTTP pipelining advice.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.pipelining)
 */
@property BOOL pipelining __attribute__((swift_name("pipelining")));

/**
 * Specifies a proxy address to use.
 * Uses a system proxy by default.
 *
 * You can learn more from [Proxy](https://ktor.io/docs/proxy.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.proxy)
 */
@property TCCKtor_client_coreProxyConfig * _Nullable proxy __attribute__((swift_name("proxy")));

/**
 * Specifies network threads count advice.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.threadsCount)
 */
@property int32_t threadsCount __attribute__((swift_name("threadsCount"))) __attribute__((unavailable("The [threadsCount] property is deprecated. Consider setting [dispatcher] instead.")));
@end


/**
 * Represents a capability that an [HttpClientEngine] can support, with [T] representing the type
 * of configuration or metadata associated with the capability.
 *
 * Capabilities are used to declare optional features or behaviors that an engine may support,
 * such as WebSocket communication, HTTP/2, or custom timeouts. They enable plugins and request
 * builders to configure engine-specific functionality by associating a capability with a
 * specific configuration.
 *
 * Capabilities can be set on a per-request basis using the `HttpRequestBuilder.setCapability` method,
 * allowing users to configure engine-specific behavior for individual requests.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineCapability)
 *
 * @param T The type of the configuration or metadata associated with this capability.
 *
 * Example:
 * Suppose you have a custom capability for WebSocket support that requires a specific configuration:
 * ```kotlin
 * object WebSocketCapability : HttpClientEngineCapability<WebSocketConfig>
 *
 * data class WebSocketConfig(val maxFrameSize: Int, val pingIntervalMillis: Long)
 * ```
 *
 * Setting a capability in a request:
 * ```kotlin
 * client.request {
 *     setCapability(WebSocketCapability, WebSocketConfig(
 *         maxFrameSize = 65536,
 *         pingIntervalMillis = 30000
 *     ))
 * }
 * ```
 *
 * Engine Example:
 * A custom engine implementation can declare support for specific capabilities in its `supportedCapabilities` property:
 * ```kotlin
 * override val supportedCapabilities: Set<HttpClientEngineCapability<*>> = setOf(WebSocketCapability)
 * ```
 *
 * Plugin Integration Example:
 * Plugins use capabilities to interact with engine-specific features. For example:
 * ```kotlin
 * if (engine.supportedCapabilities.contains(WebSocketCapability)) {
 *     // Configure WebSocket behavior if supported by the engine
 * }
 * ```
 *
 * When creating a custom capability:
 * - Define a singleton object implementing `HttpClientEngineCapability`.
 * - Use the type parameter [T] to provide the associated configuration type or metadata.
 * - Ensure that engines supporting the capability handle the associated configuration properly.
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngineCapability")))
@protocol TCCKtor_client_coreHttpClientEngineCapability
@required
@end


/**
 * Map of attributes accessible by [AttributeKey] in a typed manner
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes)
 */
__attribute__((swift_name("Ktor_utilsAttributes")))
@protocol TCCKtor_utilsAttributes
@required

/**
 * Gets a value of the attribute for the specified [key], or calls supplied [block] to compute its value
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.computeIfAbsent)
 */
- (id)computeIfAbsentKey:(TCCKtor_utilsAttributeKey<id> *)key block:(id (^)(void))block __attribute__((swift_name("computeIfAbsent(key:block:)")));

/**
 * Checks if an attribute with the specified [key] exists
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.contains)
 */
- (BOOL)containsKey:(TCCKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("contains(key:)")));

/**
 * Gets a value of the attribute for the specified [key], or throws an exception if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.get)
 */
- (id)getKey_:(TCCKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("get(key_:)")));

/**
 * Gets a value of the attribute for the specified [key], or return `null` if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.getOrNull)
 */
- (id _Nullable)getOrNullKey:(TCCKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("getOrNull(key:)")));

/**
 * Creates or changes an attribute with the specified [key] using [value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.put)
 */
- (void)putKey:(TCCKtor_utilsAttributeKey<id> *)key value:(id)value __attribute__((swift_name("put(key:value:)")));

/**
 * Removes an attribute with the specified [key]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.remove)
 */
- (void)removeKey:(TCCKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("remove(key:)")));

/**
 * Creates or changes an attribute with the specified [key] using [value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.set)
 */
- (void)setKey:(TCCKtor_utilsAttributeKey<id> *)key value:(id)value __attribute__((swift_name("set(key:value:)")));

/**
 * Removes an attribute with the specified [key] and returns its current value, throws an exception if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.take)
 */
- (id)takeKey:(TCCKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("take(key:)")));

/**
 * Removes an attribute with the specified [key] and returns its current value, returns `null` if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.takeOrNull)
 */
- (id _Nullable)takeOrNullKey:(TCCKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("takeOrNull(key:)")));

/**
 * Returns [List] of all [AttributeKey] instances in this map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.allKeys)
 */
@property (readonly) NSArray<TCCKtor_utilsAttributeKey<id> *> *allKeys __attribute__((swift_name("allKeys")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_eventsEvents")))
@interface TCCKtor_eventsEvents : TCCBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Raises the event specified by [definition] with the [value] and calls all handlers.
 *
 * Handlers are called in order of subscriptions.
 * If some handler throws an exception, all remaining handlers will still run. The exception will eventually be re-thrown.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.raise)
 */
- (void)raiseDefinition:(TCCKtor_eventsEventDefinition<id> *)definition value:(id _Nullable)value __attribute__((swift_name("raise(definition:value:)")));

/**
 * Subscribe [handler] to an event specified by [definition]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.subscribe)
 */
- (id<TCCKotlinx_coroutines_coreDisposableHandle>)subscribeDefinition:(TCCKtor_eventsEventDefinition<id> *)definition handler:(void (^)(id _Nullable))handler __attribute__((swift_name("subscribe(definition:handler:)")));

/**
 * Unsubscribe [handler] from an event specified by [definition]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.unsubscribe)
 */
- (void)unsubscribeDefinition:(TCCKtor_eventsEventDefinition<id> *)definition handler:(void (^)(id _Nullable))handler __attribute__((swift_name("unsubscribe(definition:handler:)")));
@end


/**
 * Represents an execution pipeline for asynchronous extensible computations
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline)
 */
__attribute__((swift_name("Ktor_utilsPipeline")))
@interface TCCKtor_utilsPipeline<TSubject, TContext> : TCCBase
- (instancetype)initWithPhases:(TCCKotlinArray<TCCKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhase:(TCCKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TCCKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer));

/**
 * Adds [phase] to the end of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.addPhase)
 */
- (void)addPhasePhase:(TCCKtor_utilsPipelinePhase *)phase __attribute__((swift_name("addPhase(phase:)")));

/**
 * Invoked after an interceptor has been installed
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.afterIntercepted)
 */
- (void)afterIntercepted __attribute__((swift_name("afterIntercepted()")));

/**
 * Executes this pipeline in the given [context] and with the given [subject]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.execute)
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeContext:(TContext)context subject:(TSubject)subject completionHandler:(void (^)(TSubject _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(context:subject:completionHandler:)")));

/**
 * Inserts [phase] after the [reference] phase. If there are other phases inserted after [reference], then [phase]
 * will be inserted after them.
 * Example:
 * ```
 * val pipeline = Pipeline<String, String>(a)
 * pipeline.insertPhaseAfter(a, b)
 * pipeline.insertPhaseAfter(a, c)
 * assertEquals(listOf(a, b, c), pipeline.items)
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.insertPhaseAfter)
 */
- (void)insertPhaseAfterReference:(TCCKtor_utilsPipelinePhase *)reference phase:(TCCKtor_utilsPipelinePhase *)phase __attribute__((swift_name("insertPhaseAfter(reference:phase:)")));

/**
 * Inserts [phase] before the [reference] phase.
 * Example:
 * ```
 * val pipeline = Pipeline<String, String>(c)
 * pipeline.insertPhaseBefore(c, a)
 * pipeline.insertPhaseBefore(c, b)
 * assertEquals(listOf(a, b, c), pipeline.items)
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.insertPhaseBefore)
 */
- (void)insertPhaseBeforeReference:(TCCKtor_utilsPipelinePhase *)reference phase:(TCCKtor_utilsPipelinePhase *)phase __attribute__((swift_name("insertPhaseBefore(reference:phase:)")));

/**
 * Adds [block] to the [phase] of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.intercept)
 */
- (void)interceptPhase:(TCCKtor_utilsPipelinePhase *)phase block:(id<TCCKotlinSuspendFunction2>)block __attribute__((swift_name("intercept(phase:block:)")));
- (NSArray<id<TCCKotlinSuspendFunction2>> *)interceptorsForPhasePhase:(TCCKtor_utilsPipelinePhase *)phase __attribute__((swift_name("interceptorsForPhase(phase:)")));

/**
 * Merges another pipeline into this pipeline, maintaining relative phases order
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.merge)
 */
- (void)mergeFrom:(TCCKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("merge(from:)")));
- (void)mergePhasesFrom:(TCCKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("mergePhases(from:)")));

/**
 * Reset current pipeline from other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.resetFrom)
 */
- (void)resetFromFrom:(TCCKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("resetFrom(from:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * Provides common place to store pipeline attributes
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.attributes)
 */
@property (readonly) id<TCCKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * Indicated if debug mode is enabled. In debug mode users will get more details in the stacktrace.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.developmentMode)
 */
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));

/**
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.isEmpty)
 *
 * @return `true` if there are no interceptors installed regardless number of phases
 */
@property (readonly) BOOL isEmpty __attribute__((swift_name("isEmpty")));

/**
 * Phases of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.items)
 */
@property (readonly) NSArray<TCCKtor_utilsPipelinePhase *> *items __attribute__((swift_name("items")));
@end


/**
 * [HttpClient] Pipeline used for receiving [HttpResponse] without any processing.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpReceivePipeline")))
@interface TCCKtor_client_coreHttpReceivePipeline : TCCKtor_utilsPipeline<TCCKtor_client_coreHttpResponse *, TCCKotlinUnit *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(TCCKotlinArray<TCCKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(TCCKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TCCKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKtor_client_coreHttpReceivePipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * An [HttpClient]'s pipeline used for executing [HttpRequest].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestPipeline")))
@interface TCCKtor_client_coreHttpRequestPipeline : TCCKtor_utilsPipeline<id, TCCKtor_client_coreHttpRequestBuilder *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(TCCKotlinArray<TCCKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(TCCKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TCCKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKtor_client_coreHttpRequestPipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * [HttpClient] Pipeline used for executing [HttpResponse].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponsePipeline")))
@interface TCCKtor_client_coreHttpResponsePipeline : TCCKtor_utilsPipeline<TCCKtor_client_coreHttpResponseContainer *, TCCKtor_client_coreHttpClientCall *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(TCCKotlinArray<TCCKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(TCCKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TCCKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKtor_client_coreHttpResponsePipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * An [HttpClient]'s pipeline used for sending [HttpRequest] to a remote server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpSendPipeline")))
@interface TCCKtor_client_coreHttpSendPipeline : TCCKtor_utilsPipeline<id, TCCKtor_client_coreHttpRequestBuilder *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(TCCKotlinArray<TCCKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(TCCKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TCCKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKtor_client_coreHttpSendPipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonPrimitive.Companion")))
@interface TCCKotlinx_serialization_jsonJsonPrimitiveCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_serialization_jsonJsonPrimitiveCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * An interface for listening to changes in the result set of a query.
 */
__attribute__((swift_name("RuntimeQueryListener")))
@protocol TCCRuntimeQueryListener
@required

/**
 * Called whenever the query this listener was attached to is dirtied.
 *
 * Calls are made synchronously on the thread where the updated occurred, after the update applied successfully.
 */
- (void)queryResultsChanged __attribute__((swift_name("queryResultsChanged()")));
@end


/**
 * The returned [value] is the result of a database query or other database operation.
 *
 * This interface enables drivers to be based on non-blocking APIs where the result can be obtained using the suspending
 * [await] method. See [AsyncValue].
 */
__attribute__((swift_name("RuntimeQueryResult")))
@protocol TCCRuntimeQueryResult
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitWithCompletionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("await(completionHandler:)")));
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Represents a SQL statement that has been prepared by a driver to be executed.
 *
 * This type is not thread safe unless otherwise specified by the driver emitting these.
 *
 * Prepared statements should not be cached by client code. Drivers can implement caching by using
 * the integer identifier passed to [SqlDriver.execute] or [SqlDriver.executeQuery].
 * Client code can pass the same identifier to that method to request that the prepared statement
 * is cached.
 */
__attribute__((swift_name("RuntimeSqlPreparedStatement")))
@protocol TCCRuntimeSqlPreparedStatement
@required

/**
 * Bind [boolean] to the underlying statement at [index].
 */
- (void)bindBooleanIndex:(int32_t)index boolean:(TCCBoolean * _Nullable)boolean __attribute__((swift_name("bindBoolean(index:boolean:)")));

/**
 * Bind [bytes] to the underlying statement at [index].
 */
- (void)bindBytesIndex:(int32_t)index bytes:(TCCKotlinByteArray * _Nullable)bytes __attribute__((swift_name("bindBytes(index:bytes:)")));

/**
 * Bind [double] to the underlying statement at [index].
 */
- (void)bindDoubleIndex:(int32_t)index double:(TCCDouble * _Nullable)double_ __attribute__((swift_name("bindDouble(index:double:)")));

/**
 * Bind [long] to the underlying statement at [index].
 */
- (void)bindLongIndex:(int32_t)index long:(TCCLong * _Nullable)long_ __attribute__((swift_name("bindLong(index:long:)")));

/**
 * Bind [string] to the underlying statement at [index].
 */
- (void)bindStringIndex:(int32_t)index string:(NSString * _Nullable)string __attribute__((swift_name("bindString(index:string:)")));
@end


/**
 * Represents a SQL result set which can be iterated through with [next]. Initially the cursor will
 * not point to any row, and calling [next] once will iterate to the first row.
 */
__attribute__((swift_name("RuntimeSqlCursor")))
@protocol TCCRuntimeSqlCursor
@required

/**
 * @return The boolean or null value of column [index] for the current row of the result set.
 */
- (TCCBoolean * _Nullable)getBooleanIndex:(int32_t)index __attribute__((swift_name("getBoolean(index:)")));

/**
 * @return The bytes or null value of column [index] for the current row of the result set.
 */
- (TCCKotlinByteArray * _Nullable)getBytesIndex:(int32_t)index __attribute__((swift_name("getBytes(index:)")));

/**
 * @return The double or null value of column [index] for the current row of the result set.
 */
- (TCCDouble * _Nullable)getDoubleIndex:(int32_t)index __attribute__((swift_name("getDouble(index:)")));

/**
 * @return The int or null value of column [index] for the current row of the result set.
 */
- (TCCLong * _Nullable)getLongIndex:(int32_t)index __attribute__((swift_name("getLong(index:)")));

/**
 * @return The string or null value of column [index] for the current row of the result set.
 */
- (NSString * _Nullable)getStringIndex:(int32_t)index __attribute__((swift_name("getString(index:)")));

/**
 * Move to the next row in the result set.
 *
 * @return true if the cursor successfully moved to a new row, false if there was no row to
 *   iterate to.
 */
- (id<TCCRuntimeQueryResult>)next __attribute__((swift_name("next()")));
@end


/**
 * Represents a block of code [block] that should be executed during a migration after the migration
 * has finished migrating to [afterVersion].
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RuntimeAfterVersion")))
@interface TCCRuntimeAfterVersion : TCCBase
- (instancetype)initWithAfterVersion:(int64_t)afterVersion block:(void (^)(id<TCCRuntimeSqlDriver>))block __attribute__((swift_name("init(afterVersion:block:)"))) __attribute__((objc_designated_initializer));
@property (readonly) int64_t afterVersion __attribute__((swift_name("afterVersion")));
@property (readonly) void (^block)(id<TCCRuntimeSqlDriver>) __attribute__((swift_name("block")));
@end


/**
 * Base interface representing a [HttpClient] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientPlugin")))
@protocol TCCKtor_client_coreHttpClientPlugin
@required

/**
 * Installs the [plugin] class for a [HttpClient] defined at [scope].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.install)
 */
- (void)installPlugin:(id)plugin scope:(TCCKtor_client_coreHttpClient *)scope __attribute__((swift_name("install(plugin:scope:)")));

/**
 * Builds a [TPlugin] by calling the [block] with a [TConfig] config instance as receiver.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.prepare)
 */
- (id)prepareBlock:(void (^)(id))block __attribute__((swift_name("prepare(block:)")));

/**
 * The [AttributeKey] for this plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.key)
 */
@property (readonly) TCCKtor_utilsAttributeKey<id> *key __attribute__((swift_name("key")));
@end


/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionsConfig")))
@interface TCCKtor_websocketsWebSocketExtensionsConfig : TCCBase

/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Instantiates all installed extensions.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig.build)
 */
- (NSArray<id<TCCKtor_websocketsWebSocketExtension>> *)build __attribute__((swift_name("build()")));

/**
 * Installs the provided [extension] using [config]. Every extension is processed in order of installation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig.install)
 */
- (void)installExtension:(id<TCCKtor_websocketsWebSocketExtensionFactory>)extension config:(void (^)(id))config __attribute__((swift_name("install(extension:config:)")));
@end


/**
 * A custom content converter that could be used in the [WebSockets] plugin
 * Could provide bi-directional conversion implementation.
 * One of the most typical examples of the content converter is a JSON converter that provides
 * both serialization and deserialization
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter)
 */
__attribute__((swift_name("Ktor_serializationWebsocketContentConverter")))
@protocol TCCKtor_serializationWebsocketContentConverter
@required

/**
 * Deserializes [content] to the value of type [typeInfo]
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.deserialize)
 *
 * @return a converted value (deserialized) or throws `WebsocketConverterNotFoundException` if the context's
 * subject is not suitable for this converter
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deserializeCharset:(TCCKtor_ioCharset *)charset typeInfo:(TCCKtor_utilsTypeInfo *)typeInfo content:(TCCKtor_websocketsFrame *)content completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("deserialize(charset:typeInfo:content:completionHandler:)")));

/**
 * Checks if the content converter can deserialize a [frame]
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.isApplicable)
 *
 * @param frame a WebSocket frame
 *
 * @return true if the content converter can deserialize a [frame] type or false if a type of [frame]
 * is not supported by the converter
 */
- (BOOL)isApplicableFrame:(TCCKtor_websocketsFrame *)frame __attribute__((swift_name("isApplicable(frame:)")));

/**
 * Serializes a [value] to a WebSocket [Frame].
 * This function could throw `WebsocketConverterNotFoundException` if the value is not suitable for conversion
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.serialize)
 *
 * @param charset response charset
 * @param typeInfo response body typeInfo
 * @param value to be converted
 *
 * @return a converted [Frame] value, or null if [value] isn't suitable for this converter
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)serializeCharset:(TCCKtor_ioCharset *)charset typeInfo:(TCCKtor_utilsTypeInfo *)typeInfo value:(id _Nullable)value completionHandler:(void (^)(TCCKtor_websocketsFrame * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("serialize(charset:typeInfo:value:completionHandler:)")));
@end

__attribute__((swift_name("KotlinByteIterator")))
@interface TCCKotlinByteIterator : TCCBase <TCCKotlinIterator>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (TCCByte *)next __attribute__((swift_name("next()")));
- (int8_t)nextByte __attribute__((swift_name("nextByte()")));
@end

__attribute__((swift_name("KotlinAppendable")))
@protocol TCCKotlinAppendable
@required
- (id<TCCKotlinAppendable>)appendValue:(unichar)value __attribute__((swift_name("append(value:)")));
- (id<TCCKotlinAppendable>)appendValue_:(id _Nullable)value __attribute__((swift_name("append(value_:)")));
- (id<TCCKotlinAppendable>)appendValue:(id _Nullable)value startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("append(value:startIndex:endIndex:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_coreFileMetadata")))
@interface TCCKotlinx_io_coreFileMetadata : TCCBase
- (instancetype)initWithIsRegularFile:(BOOL)isRegularFile isDirectory:(BOOL)isDirectory size:(int64_t)size __attribute__((swift_name("init(isRegularFile:isDirectory:size:)"))) __attribute__((objc_designated_initializer));
@property (readonly) BOOL isDirectory __attribute__((swift_name("isDirectory")));
@property (readonly) BOOL isRegularFile __attribute__((swift_name("isRegularFile")));
@property (readonly) int64_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_io_coreRawSink")))
@protocol TCCKotlinx_io_coreRawSink <TCCKotlinAutoCloseable>
@required
- (void)flush __attribute__((swift_name("flush()")));
- (void)writeSource:(TCCKotlinx_io_coreBuffer *)source byteCount:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount:)")));
@end

__attribute__((swift_name("Kotlinx_io_coreRawSource")))
@protocol TCCKotlinx_io_coreRawSource <TCCKotlinAutoCloseable>
@required
- (int64_t)readAtMostToSink:(TCCKotlinx_io_coreBuffer *)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readAtMostTo(sink:byteCount:)")));
@end

__attribute__((swift_name("Kermit_coreLoggerConfig")))
@protocol TCCKermit_coreLoggerConfig
@required
@property (readonly) NSArray<TCCKermit_coreLogWriter *> *logWriterList __attribute__((swift_name("logWriterList")));
@property (readonly) TCCKermit_coreSeverity *minSeverity __attribute__((swift_name("minSeverity")));
@end

__attribute__((swift_name("Kermit_coreMutableLoggerConfig")))
@protocol TCCKermit_coreMutableLoggerConfig <TCCKermit_coreLoggerConfig>
@required
- (void)setLogWriterList:(NSArray<TCCKermit_coreLogWriter *> *)value __attribute__((swift_name("setLogWriterList(_:)")));
- (void)setMinSeverity:(TCCKermit_coreSeverity *)value __attribute__((swift_name("setMinSeverity(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KermitLogger.Companion")))
@interface TCCKermitLoggerCompanion : TCCKermitLogger
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithConfig:(id<TCCKermit_coreLoggerConfig>)config tag:(NSString *)tag __attribute__((swift_name("init(config:tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKermitLoggerCompanion *shared __attribute__((swift_name("shared")));
- (void)aTag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("a(tag:throwable:message:)")));
- (void)addLogWriterLogWriter:(TCCKotlinArray<TCCKermit_coreLogWriter *> *)logWriter __attribute__((swift_name("addLogWriter(logWriter:)")));
- (void)dTag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("d(tag:throwable:message:)")));
- (void)eTag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("e(tag:throwable:message:)")));
- (void)iTag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("i(tag:throwable:message:)")));
- (void)setLogWritersLogWriter:(TCCKotlinArray<TCCKermit_coreLogWriter *> *)logWriter __attribute__((swift_name("setLogWriters(logWriter:)")));
- (void)setLogWritersLogWriters:(NSArray<TCCKermit_coreLogWriter *> *)logWriters __attribute__((swift_name("setLogWriters(logWriters:)")));
- (void)setMinSeveritySeverity:(TCCKermit_coreSeverity *)severity __attribute__((swift_name("setMinSeverity(severity:)")));
- (void)setTagTag:(NSString *)tag __attribute__((swift_name("setTag(tag:)")));
- (void)vTag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("v(tag:throwable:message:)")));
- (void)wTag:(NSString *)tag throwable:(TCCKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("w(tag:throwable:message:)")));
@property (readonly) NSString *tag __attribute__((swift_name("tag")));
@end

__attribute__((swift_name("Kotlinx_io_coreSink")))
@protocol TCCKotlinx_io_coreSink <TCCKotlinx_io_coreRawSink>
@required
- (void)emit __attribute__((swift_name("emit()")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
- (void)hintEmit __attribute__((swift_name("hintEmit()")));
- (int64_t)transferFromSource:(id<TCCKotlinx_io_coreRawSource>)source __attribute__((swift_name("transferFrom(source:)")));
- (void)writeSource:(id<TCCKotlinx_io_coreRawSource>)source byteCount_:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount_:)")));
- (void)writeSource:(TCCKotlinByteArray *)source startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("write(source:startIndex:endIndex:)")));
- (void)writeByteByte:(int8_t)byte __attribute__((swift_name("writeByte(byte:)")));
- (void)writeIntInt:(int32_t)int_ __attribute__((swift_name("writeInt(int:)")));
- (void)writeLongLong:(int64_t)long_ __attribute__((swift_name("writeLong(long:)")));
- (void)writeShortShort:(int16_t)short_ __attribute__((swift_name("writeShort(short:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) TCCKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@end

__attribute__((swift_name("Ktor_ioChannelJob")))
@protocol TCCKtor_ioChannelJob
@required
@property (readonly) id<TCCKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioWriterJob")))
@interface TCCKtor_ioWriterJob : TCCBase <TCCKtor_ioChannelJob>
@property (readonly) id<TCCKtor_ioByteReadChannel> channel __attribute__((swift_name("channel")));
@property (readonly) id<TCCKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end


/**
 * Channel for asynchronous reading of sequences of bytes.
 * This is a **single-reader channel**.
 *
 * Operations on this channel cannot be invoked concurrently.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteReadChannel)
 */
__attribute__((swift_name("Ktor_ioByteReadChannel")))
@protocol TCCKtor_ioByteReadChannel
@required

/**
 * Suspend the channel until it has [min] bytes or gets closed. Throws exception if the channel was closed with an
 * error. If there are bytes available in the channel, this function returns immediately.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteReadChannel.awaitContent)
 *
 * @return return `false` eof is reached, otherwise `true`.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitContentMin:(int32_t)min completionHandler:(void (^)(TCCBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("awaitContent(min:completionHandler:)")));
- (void)cancelCause_:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));
@property (readonly) TCCKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForRead __attribute__((swift_name("isClosedForRead")));
@property (readonly) id<TCCKotlinx_io_coreSource> readBuffer __attribute__((swift_name("readBuffer")));
@end

__attribute__((swift_name("Ktor_ioBufferedByteWriteChannel")))
@protocol TCCKtor_ioBufferedByteWriteChannel <TCCKtor_ioByteWriteChannel>
@required

/**
 * Flush all pending bytes from [writeBuffer] to the internal read buffer without suspension and initiate channel close.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.BufferedByteWriteChannel.close)
 */
- (void)close __attribute__((swift_name("close()")));

/**
 * Flush all pending bytes from [writeBuffer] to the internal read buffer without suspension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.BufferedByteWriteChannel.flushWriteBuffer)
 */
- (void)flushWriteBuffer __attribute__((swift_name("flushWriteBuffer()")));
@end


/**
 * Sequential (non-concurrent) byte channel implementation
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteChannel)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioByteChannel")))
@interface TCCKtor_ioByteChannel : TCCBase <TCCKtor_ioByteReadChannel, TCCKtor_ioBufferedByteWriteChannel>
- (instancetype)initWithAutoFlush:(BOOL)autoFlush __attribute__((swift_name("init(autoFlush:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitContentMin:(int32_t)min completionHandler:(void (^)(TCCBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("awaitContent(min:completionHandler:)")));
- (void)cancelCause_:(TCCKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));
- (void)close __attribute__((swift_name("close()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flush(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
- (void)flushWriteBuffer __attribute__((swift_name("flushWriteBuffer()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL autoFlush __attribute__((swift_name("autoFlush")));
@property (readonly) TCCKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForRead __attribute__((swift_name("isClosedForRead")));
@property (readonly) BOOL isClosedForWrite __attribute__((swift_name("isClosedForWrite")));
@property (readonly) id<TCCKotlinx_io_coreSource> readBuffer __attribute__((swift_name("readBuffer")));
@property (readonly) id<TCCKotlinx_io_coreSink> writeBuffer __attribute__((swift_name("writeBuffer")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioReaderJob")))
@interface TCCKtor_ioReaderJob : TCCBase <TCCKtor_ioChannelJob>

/**
 * To avoid the risk of concurrent write operations, we cancel the nested job before
 * performing `flushAndClose` on the [ByteWriteChannel].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ReaderJob.flushAndClose)
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
@property (readonly) id<TCCKtor_ioByteWriteChannel> channel __attribute__((swift_name("channel")));
@property (readonly) id<TCCKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end

__attribute__((swift_name("Ktor_networkSocketAddress")))
@interface TCCKtor_networkSocketAddress : TCCBase
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDate.Companion")))
@interface TCCKotlinx_datetimeLocalDateCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeLocalDateCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_datetimeDateTimeFormat>)FormatBlock:(void (^)(id<TCCKotlinx_datetimeDateTimeFormatBuilderWithDate>))block __attribute__((swift_name("Format(block:)")));
- (TCCKotlinx_datetimeLocalDate *)fromEpochDaysEpochDays:(int32_t)epochDays __attribute__((swift_name("fromEpochDays(epochDays:)")));
- (TCCKotlinx_datetimeLocalDate *)fromEpochDaysEpochDays_:(int64_t)epochDays __attribute__((swift_name("fromEpochDays(epochDays_:)")));
- (TCCKotlinx_datetimeLocalDate *)parseInput:(id)input format:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("KotlinIterable")))
@protocol TCCKotlinIterable
@required
- (id<TCCKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
@end

__attribute__((swift_name("KotlinCollection")))
@protocol TCCKotlinCollection <TCCKotlinIterable>
@required
- (BOOL)containsElement:(id _Nullable)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsAllElements:(id)elements __attribute__((swift_name("containsAll(elements:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_datetimeLocalDateProgression")))
@interface TCCKotlinx_datetimeLocalDateProgression : TCCBase <TCCKotlinCollection>
@property (class, readonly, getter=companion) TCCKotlinx_datetimeLocalDateProgressionCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsElement:(TCCKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsAllElements:(id)elements __attribute__((swift_name("containsAll(elements:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (id<TCCKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCKotlinx_datetimeLocalDate *first __attribute__((swift_name("first")));
@property (readonly) TCCKotlinx_datetimeLocalDate *last __attribute__((swift_name("last")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("KotlinClosedRange")))
@protocol TCCKotlinClosedRange
@required
- (BOOL)containsValue:(id)value __attribute__((swift_name("contains(value:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) id endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly, getter=start_) id start __attribute__((swift_name("start")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.9")
*/
__attribute__((swift_name("KotlinOpenEndRange")))
@protocol TCCKotlinOpenEndRange
@required
- (BOOL)containsValue_:(id)value __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) id endExclusive __attribute__((swift_name("endExclusive")));
@property (readonly, getter=start_) id start __attribute__((swift_name("start")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateRange")))
@interface TCCKotlinx_datetimeLocalDateRange : TCCKotlinx_datetimeLocalDateProgression <TCCKotlinClosedRange, TCCKotlinOpenEndRange>
- (instancetype)initWithStart:(TCCKotlinx_datetimeLocalDate *)start endInclusive:(TCCKotlinx_datetimeLocalDate *)endInclusive __attribute__((swift_name("init(start:endInclusive:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinx_datetimeLocalDateRangeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsElement:(TCCKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsValue:(TCCKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(value:)")));
- (BOOL)containsValue_:(TCCKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCKotlinx_datetimeLocalDate *endExclusive __attribute__((swift_name("endExclusive"))) __attribute__((deprecated("This throws an exception if the exclusive end if not inside the platform-specific boundaries for LocalDate. The 'endInclusive' property does not throw and should be preferred.")));
@property (readonly) TCCKotlinx_datetimeLocalDate *endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly, getter=start_) TCCKotlinx_datetimeLocalDate *start __attribute__((swift_name("start")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalTime.Companion")))
@interface TCCKotlinx_datetimeLocalTimeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeLocalTimeCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_datetimeDateTimeFormat>)FormatBuilder:(void (^)(id<TCCKotlinx_datetimeDateTimeFormatBuilderWithTime>))builder __attribute__((swift_name("Format(builder:)")));
- (TCCKotlinx_datetimeLocalTime *)fromMillisecondOfDayMillisecondOfDay:(int32_t)millisecondOfDay __attribute__((swift_name("fromMillisecondOfDay(millisecondOfDay:)")));
- (TCCKotlinx_datetimeLocalTime *)fromNanosecondOfDayNanosecondOfDay:(int64_t)nanosecondOfDay __attribute__((swift_name("fromNanosecondOfDay(nanosecondOfDay:)")));
- (TCCKotlinx_datetimeLocalTime *)fromSecondOfDaySecondOfDay:(int32_t)secondOfDay __attribute__((swift_name("fromSecondOfDay(secondOfDay:)")));
- (TCCKotlinx_datetimeLocalTime *)parseInput:(id)input format:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilder")))
@protocol TCCKotlinx_datetimeDateTimeFormatBuilder
@required
- (void)charsValue:(NSString *)value __attribute__((swift_name("chars(value:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithYearMonth")))
@protocol TCCKotlinx_datetimeDateTimeFormatBuilderWithYearMonth <TCCKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)monthNameNames:(TCCKotlinx_datetimeMonthNames *)names __attribute__((swift_name("monthName(names:)")));
- (void)monthNumberPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("monthNumber(padding:)")));
- (void)yearPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("year(padding:)")));
- (void)yearMonthFormat:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("yearMonth(format:)")));
- (void)yearTwoDigitsBaseYear:(int32_t)baseYear __attribute__((swift_name("yearTwoDigits(baseYear:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithDate")))
@protocol TCCKotlinx_datetimeDateTimeFormatBuilderWithDate <TCCKotlinx_datetimeDateTimeFormatBuilderWithYearMonth>
@required
- (void)dateFormat:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("date(format:)")));
- (void)dayPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("day(padding:)")));
- (void)dayOfMonthPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("dayOfMonth(padding:)"))) __attribute__((deprecated("Use 'day' instead")));
- (void)dayOfWeekNames:(TCCKotlinx_datetimeDayOfWeekNames *)names __attribute__((swift_name("dayOfWeek(names:)")));
- (void)dayOfYearPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("dayOfYear(padding:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithTime")))
@protocol TCCKotlinx_datetimeDateTimeFormatBuilderWithTime <TCCKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)amPmHourPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("amPmHour(padding:)")));
- (void)amPmMarkerAm:(NSString *)am pm:(NSString *)pm __attribute__((swift_name("amPmMarker(am:pm:)")));
- (void)hourPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("hour(padding:)")));
- (void)minutePadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("minute(padding:)")));
- (void)secondPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("second(padding:)")));
- (void)secondFractionFixedLength:(int32_t)fixedLength __attribute__((swift_name("secondFraction(fixedLength:)")));
- (void)secondFractionMinLength:(int32_t)minLength maxLength:(int32_t)maxLength __attribute__((swift_name("secondFraction(minLength:maxLength:)")));
- (void)timeFormat:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("time(format:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithDateTime")))
@protocol TCCKotlinx_datetimeDateTimeFormatBuilderWithDateTime <TCCKotlinx_datetimeDateTimeFormatBuilderWithDate, TCCKotlinx_datetimeDateTimeFormatBuilderWithTime>
@required
- (void)dateTimeFormat:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("dateTime(format:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/FixedOffsetTimeZoneSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeFixedOffsetTimeZone")))
@interface TCCKotlinx_datetimeFixedOffsetTimeZone : TCCKotlinx_datetimeTimeZone
- (instancetype)initWithOffset:(TCCKotlinx_datetimeUtcOffset *)offset __attribute__((swift_name("init(offset:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinx_datetimeFixedOffsetTimeZoneCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) TCCKotlinx_datetimeUtcOffset *offset __attribute__((swift_name("offset")));
@property (readonly) int32_t totalSeconds __attribute__((swift_name("totalSeconds"))) __attribute__((deprecated("Use offset.totalSeconds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinInstant.Companion")))
@interface TCCKotlinInstantCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinInstantCompanion *shared __attribute__((swift_name("shared")));
- (TCCKotlinInstant *)fromEpochMillisecondsEpochMilliseconds:(int64_t)epochMilliseconds __attribute__((swift_name("fromEpochMilliseconds(epochMilliseconds:)")));
- (TCCKotlinInstant *)fromEpochSecondsEpochSeconds:(int64_t)epochSeconds nanosecondAdjustment:(int32_t)nanosecondAdjustment __attribute__((swift_name("fromEpochSeconds(epochSeconds:nanosecondAdjustment:)")));
- (TCCKotlinInstant *)fromEpochSecondsEpochSeconds:(int64_t)epochSeconds nanosecondAdjustment_:(int64_t)nanosecondAdjustment __attribute__((swift_name("fromEpochSeconds(epochSeconds:nanosecondAdjustment_:)")));
- (TCCKotlinInstant *)now __attribute__((swift_name("now()"))) __attribute__((unavailable("Use Clock.System.now() instead")));
- (TCCKotlinInstant *)parseInput:(id)input __attribute__((swift_name("parse(input:)")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.2")
*/
- (TCCKotlinInstant * _Nullable)parseOrNullInput:(id)input __attribute__((swift_name("parseOrNull(input:)")));
@property (readonly) TCCKotlinInstant *DISTANT_FUTURE __attribute__((swift_name("DISTANT_FUTURE")));
@property (readonly) TCCKotlinInstant *DISTANT_PAST __attribute__((swift_name("DISTANT_PAST")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJson.Default")))
@interface TCCKotlinx_serialization_jsonJsonDefault : TCCKotlinx_serialization_jsonJson
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)default_ __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_serialization_jsonJsonDefault *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonConfiguration")))
@interface TCCKotlinx_serialization_jsonJsonConfiguration : TCCBase
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL allowComments __attribute__((swift_name("allowComments")));
@property (readonly) BOOL allowSpecialFloatingPointValues __attribute__((swift_name("allowSpecialFloatingPointValues")));
@property (readonly) BOOL allowStructuredMapKeys __attribute__((swift_name("allowStructuredMapKeys")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL allowTrailingComma __attribute__((swift_name("allowTrailingComma")));
@property (readonly) NSString *classDiscriminator __attribute__((swift_name("classDiscriminator")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property TCCKotlinx_serialization_jsonClassDiscriminatorMode *classDiscriminatorMode __attribute__((swift_name("classDiscriminatorMode")));
@property (readonly) BOOL coerceInputValues __attribute__((swift_name("coerceInputValues")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL decodeEnumsCaseInsensitive __attribute__((swift_name("decodeEnumsCaseInsensitive")));
@property (readonly) BOOL encodeDefaults __attribute__((swift_name("encodeDefaults")));
@property (readonly) BOOL explicitNulls __attribute__((swift_name("explicitNulls")));
@property (readonly) BOOL ignoreUnknownKeys __attribute__((swift_name("ignoreUnknownKeys")));
@property (readonly) BOOL isLenient __attribute__((swift_name("isLenient")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) id<TCCKotlinx_serialization_jsonJsonNamingStrategy> _Nullable namingStrategy __attribute__((swift_name("namingStrategy")));
@property (readonly) BOOL prettyPrint __attribute__((swift_name("prettyPrint")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) NSString *prettyPrintIndent __attribute__((swift_name("prettyPrintIndent")));
@property (readonly) BOOL useAlternativeNames __attribute__((swift_name("useAlternativeNames")));
@property (readonly) BOOL useArrayPolymorphism __attribute__((swift_name("useArrayPolymorphism")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreParentJob")))
@protocol TCCKotlinx_coroutines_coreParentJob <TCCKotlinx_coroutines_coreJob>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (TCCKotlinCancellationException *)getChildJobCancellationCause __attribute__((swift_name("getChildJobCancellationCause()")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreSelectInstance")))
@protocol TCCKotlinx_coroutines_coreSelectInstance
@required
- (void)disposeOnCompletionDisposableHandle:(id<TCCKotlinx_coroutines_coreDisposableHandle>)disposableHandle __attribute__((swift_name("disposeOnCompletion(disposableHandle:)")));
- (void)selectInRegistrationPhaseInternalResult:(id _Nullable)internalResult __attribute__((swift_name("selectInRegistrationPhase(internalResult:)")));
- (BOOL)trySelectClauseObject:(id)clauseObject result:(id _Nullable)result __attribute__((swift_name("trySelect(clauseObject:result:)")));
@property (readonly) id<TCCKotlinCoroutineContext> context __attribute__((swift_name("context")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
__attribute__((swift_name("Kotlinx_serialization_coreSerializersModuleCollector")))
@protocol TCCKotlinx_serialization_coreSerializersModuleCollector
@required
- (void)contextualKClass:(id<TCCKotlinKClass>)kClass provider:(id<TCCKotlinx_serialization_coreKSerializer> (^)(NSArray<id<TCCKotlinx_serialization_coreKSerializer>> *))provider __attribute__((swift_name("contextual(kClass:provider:)")));
- (void)contextualKClass:(id<TCCKotlinKClass>)kClass serializer:(id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("contextual(kClass:serializer:)")));
- (void)polymorphicBaseClass:(id<TCCKotlinKClass>)baseClass actualClass:(id<TCCKotlinKClass>)actualClass actualSerializer:(id<TCCKotlinx_serialization_coreKSerializer>)actualSerializer __attribute__((swift_name("polymorphic(baseClass:actualClass:actualSerializer:)")));
- (void)polymorphicDefaultBaseClass:(id<TCCKotlinKClass>)baseClass defaultDeserializerProvider:(id<TCCKotlinx_serialization_coreDeserializationStrategy> _Nullable (^)(NSString * _Nullable))defaultDeserializerProvider __attribute__((swift_name("polymorphicDefault(baseClass:defaultDeserializerProvider:)"))) __attribute__((deprecated("Deprecated in favor of function with more precise name: polymorphicDefaultDeserializer")));
- (void)polymorphicDefaultDeserializerBaseClass:(id<TCCKotlinKClass>)baseClass defaultDeserializerProvider:(id<TCCKotlinx_serialization_coreDeserializationStrategy> _Nullable (^)(NSString * _Nullable))defaultDeserializerProvider __attribute__((swift_name("polymorphicDefaultDeserializer(baseClass:defaultDeserializerProvider:)")));
- (void)polymorphicDefaultSerializerBaseClass:(id<TCCKotlinKClass>)baseClass defaultSerializerProvider:(id<TCCKotlinx_serialization_coreSerializationStrategy> _Nullable (^)(id))defaultSerializerProvider __attribute__((swift_name("polymorphicDefaultSerializer(baseClass:defaultSerializerProvider:)")));
@end

__attribute__((swift_name("KotlinKDeclarationContainer")))
@protocol TCCKotlinKDeclarationContainer
@required
@end

__attribute__((swift_name("KotlinKAnnotatedElement")))
@protocol TCCKotlinKAnnotatedElement
@required
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((swift_name("KotlinKClassifier")))
@protocol TCCKotlinKClassifier
@required
@end

__attribute__((swift_name("KotlinKClass")))
@protocol TCCKotlinKClass <TCCKotlinKDeclarationContainer, TCCKotlinKAnnotatedElement, TCCKotlinKClassifier>
@required

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
- (BOOL)isInstanceValue:(id _Nullable)value __attribute__((swift_name("isInstance(value:)")));
@property (readonly) NSString * _Nullable qualifiedName __attribute__((swift_name("qualifiedName")));
@property (readonly) NSString * _Nullable simpleName __attribute__((swift_name("simpleName")));
@end


/**
 * Actual data of the [HttpRequest], including [url], [method], [headers], [body] and [executionContext].
 * Built by [HttpRequestBuilder].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestData)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestData")))
@interface TCCKtor_client_coreHttpRequestData : TCCBase
- (instancetype)initWithUrl:(TCCKtor_httpUrl *)url method:(TCCKtor_httpHttpMethod *)method headers:(id<TCCKtor_httpHeaders>)headers body:(TCCKtor_httpOutgoingContent *)body executionContext:(id<TCCKotlinx_coroutines_coreJob>)executionContext attributes:(id<TCCKtor_utilsAttributes>)attributes __attribute__((swift_name("init(url:method:headers:body:executionContext:attributes:)"))) __attribute__((objc_designated_initializer));

/**
 * Retrieve extension by its key.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestData.getCapabilityOrNull)
 */
- (id _Nullable)getCapabilityOrNullKey:(id<TCCKtor_client_coreHttpClientEngineCapability>)key __attribute__((swift_name("getCapabilityOrNull(key:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<TCCKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) TCCKtor_httpOutgoingContent *body __attribute__((swift_name("body")));
@property (readonly) id<TCCKotlinx_coroutines_coreJob> executionContext __attribute__((swift_name("executionContext")));
@property (readonly) id<TCCKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) TCCKtor_httpHttpMethod *method __attribute__((swift_name("method")));
@property (readonly) TCCKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * Data prepared for [HttpResponse].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpResponseData)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponseData")))
@interface TCCKtor_client_coreHttpResponseData : TCCBase
- (instancetype)initWithStatusCode:(TCCKtor_httpHttpStatusCode *)statusCode requestTime:(TCCKtor_utilsGMTDate *)requestTime headers:(id<TCCKtor_httpHeaders>)headers version:(TCCKtor_httpHttpProtocolVersion *)version body:(id)body callContext:(id<TCCKotlinCoroutineContext>)callContext __attribute__((swift_name("init(statusCode:requestTime:headers:version:body:callContext:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id body __attribute__((swift_name("body")));
@property (readonly) id<TCCKotlinCoroutineContext> callContext __attribute__((swift_name("callContext")));
@property (readonly) id<TCCKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) TCCKtor_utilsGMTDate *requestTime __attribute__((swift_name("requestTime")));
@property (readonly) TCCKtor_utilsGMTDate *responseTime __attribute__((swift_name("responseTime")));
@property (readonly) TCCKtor_httpHttpStatusCode *statusCode __attribute__((swift_name("statusCode")));
@property (readonly) TCCKtor_httpHttpProtocolVersion *version __attribute__((swift_name("version")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinAbstractCoroutineContextElement")))
@interface TCCKotlinAbstractCoroutineContextElement : TCCBase <TCCKotlinCoroutineContextElement>
- (instancetype)initWithKey:(id<TCCKotlinCoroutineContextKey>)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer));
@property (readonly) id<TCCKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinContinuationInterceptor")))
@protocol TCCKotlinContinuationInterceptor <TCCKotlinCoroutineContextElement>
@required
- (id<TCCKotlinContinuation>)interceptContinuationContinuation:(id<TCCKotlinContinuation>)continuation __attribute__((swift_name("interceptContinuation(continuation:)")));
- (void)releaseInterceptedContinuationContinuation:(id<TCCKotlinContinuation>)continuation __attribute__((swift_name("releaseInterceptedContinuation(continuation:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineDispatcher")))
@interface TCCKotlinx_coroutines_coreCoroutineDispatcher : TCCKotlinAbstractCoroutineContextElement <TCCKotlinContinuationInterceptor>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithKey:(id<TCCKotlinCoroutineContextKey>)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKotlinx_coroutines_coreCoroutineDispatcherKey *companion __attribute__((swift_name("companion")));
- (void)dispatchContext:(id<TCCKotlinCoroutineContext>)context block:(id<TCCKotlinx_coroutines_coreRunnable>)block __attribute__((swift_name("dispatch(context:block:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (void)dispatchYieldContext:(id<TCCKotlinCoroutineContext>)context block:(id<TCCKotlinx_coroutines_coreRunnable>)block __attribute__((swift_name("dispatchYield(context:block:)")));
- (id<TCCKotlinContinuation>)interceptContinuationContinuation:(id<TCCKotlinContinuation>)continuation __attribute__((swift_name("interceptContinuation(continuation:)")));
- (BOOL)isDispatchNeededContext:(id<TCCKotlinCoroutineContext>)context __attribute__((swift_name("isDispatchNeeded(context:)")));
- (TCCKotlinx_coroutines_coreCoroutineDispatcher *)limitedParallelismParallelism:(int32_t)parallelism name:(NSString * _Nullable)name __attribute__((swift_name("limitedParallelism(parallelism:name:)")));
- (TCCKotlinx_coroutines_coreCoroutineDispatcher *)plusOther_:(TCCKotlinx_coroutines_coreCoroutineDispatcher *)other __attribute__((swift_name("plus(other_:)"))) __attribute__((unavailable("Operator '+' on two CoroutineDispatcher objects is meaningless. CoroutineDispatcher is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The dispatcher to the right of `+` just replaces the dispatcher to the left.")));
- (void)releaseInterceptedContinuationContinuation:(id<TCCKotlinContinuation>)continuation __attribute__((swift_name("releaseInterceptedContinuation(continuation:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@end


/**
 * Proxy configuration.
 *
 * See [ProxyBuilder] to create proxy.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.ProxyConfig)
 *
 * @param url: proxy url address.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreProxyConfig")))
@interface TCCKtor_client_coreProxyConfig : TCCBase
- (instancetype)initWithUrl:(TCCKtor_httpUrl *)url __attribute__((swift_name("init(url:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsAttributeKey")))
@interface TCCKtor_utilsAttributeKey<T> : TCCBase

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (instancetype)initWithName:(NSString *)name type:(TCCKtor_utilsTypeInfo *)type __attribute__((swift_name("init(name:type:)"))) __attribute__((objc_designated_initializer));
- (TCCKtor_utilsAttributeKey<T> *)doCopyName:(NSString *)name type:(TCCKtor_utilsTypeInfo *)type __attribute__((swift_name("doCopy(name:type:)")));

/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end


/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
__attribute__((swift_name("Ktor_eventsEventDefinition")))
@interface TCCKtor_eventsEventDefinition<T> : TCCBase

/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end


/**
 * Represents a phase in a pipeline
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.PipelinePhase)
 *
 * @param name a name for this phase
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsPipelinePhase")))
@interface TCCKtor_utilsPipelinePhase : TCCBase
- (instancetype)initWithName:(NSString *)name __attribute__((swift_name("init(name:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((swift_name("KotlinSuspendFunction2")))
@protocol TCCKotlinSuspendFunction2 <TCCKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 p2:(id _Nullable)p2 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:p2:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpReceivePipeline.Phases")))
@interface TCCKtor_client_coreHttpReceivePipelinePhases : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_client_coreHttpReceivePipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * Latest response pipeline phase
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.After)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *After __attribute__((swift_name("After")));

/**
 * The earliest phase that happens before any other
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.Before)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Use this phase to store request shared state
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.State)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@end


/**
 * A message either from the client or the server,
 * that has [headers] associated.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessage)
 */
__attribute__((swift_name("Ktor_httpHttpMessage")))
@protocol TCCKtor_httpHttpMessage
@required

/**
 * Message [Headers]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessage.headers)
 */
@property (readonly) id<TCCKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@end


/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
__attribute__((swift_name("Ktor_client_coreHttpResponse")))
@interface TCCKtor_client_coreHttpResponse : TCCBase <TCCKtor_httpHttpMessage, TCCKotlinx_coroutines_coreCoroutineScope>

/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The associated [HttpClientCall] containing both
 * the underlying [HttpClientCall.request] and [HttpClientCall.response].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.call)
 */
@property (readonly) TCCKtor_client_coreHttpClientCall *call __attribute__((swift_name("call")));

/**
 * Provides a raw [ByteReadChannel] to the response content as it is read from the network.
 * This content can be still compressed or encoded.
 *
 * This content doesn't go through any interceptors from [HttpResponsePipeline].
 *
 * If you need to read the content as decoded bytes, use the [bodyAsChannel] method instead.
 *
 * This property produces a new channel every time it's accessed.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.rawContent)
 */
@property (readonly) id<TCCKtor_ioByteReadChannel> rawContent __attribute__((swift_name("rawContent")));

/**
 * [GMTDate] of the request start.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.requestTime)
 */
@property (readonly) TCCKtor_utilsGMTDate *requestTime __attribute__((swift_name("requestTime")));

/**
 * [GMTDate] of the response start.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.responseTime)
 */
@property (readonly) TCCKtor_utilsGMTDate *responseTime __attribute__((swift_name("responseTime")));

/**
 * The [HttpStatusCode] returned by the server. It includes both,
 * the [HttpStatusCode.description] and the [HttpStatusCode.value] (code).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.status)
 */
@property (readonly) TCCKtor_httpHttpStatusCode *status __attribute__((swift_name("status")));

/**
 * HTTP version. Usually [HttpProtocolVersion.HTTP_1_1] or [HttpProtocolVersion.HTTP_2_0].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.version)
 */
@property (readonly) TCCKtor_httpHttpProtocolVersion *version_ __attribute__((swift_name("version_")));
@end


/**
 * All interceptors accept payload as [subject] and try to convert it to [OutgoingContent].
 * Last phase should proceed with [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestPipeline.Phases")))
@interface TCCKtor_client_coreHttpRequestPipelinePhases : TCCBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * All interceptors accept payload as [subject] and try to convert it to [OutgoingContent].
 * Last phase should proceed with [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_client_coreHttpRequestPipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * The earliest phase that happens before any other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Before)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Encode a request body to [OutgoingContent].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Render)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Render __attribute__((swift_name("Render")));

/**
 * A phase for the [HttpSend] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Send)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Send __attribute__((swift_name("Send")));

/**
 * Use this phase to modify a request with a shared state.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.State)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));

/**
 * Transform a request body to supported render format.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Transform)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Transform __attribute__((swift_name("Transform")));
@end


/**
 * A builder message either for the client or the server,
 * that has a [headers] builder associated.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessageBuilder)
 */
__attribute__((swift_name("Ktor_httpHttpMessageBuilder")))
@protocol TCCKtor_httpHttpMessageBuilder
@required

/**
 * MessageBuilder [HeadersBuilder]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessageBuilder.headers)
 */
@property (readonly) TCCKtor_httpHeadersBuilder *headers __attribute__((swift_name("headers")));
@end


/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestBuilder")))
@interface TCCKtor_client_coreHttpRequestBuilder : TCCBase <TCCKtor_httpHttpMessageBuilder>

/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) TCCKtor_client_coreHttpRequestBuilderCompanion *companion __attribute__((swift_name("companion")));

/**
 * Creates immutable [HttpRequestData].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.build)
 */
- (TCCKtor_client_coreHttpRequestData *)build __attribute__((swift_name("build()")));

/**
 * Retrieves capability by the key.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.getCapabilityOrNull)
 */
- (id _Nullable)getCapabilityOrNullKey:(id<TCCKtor_client_coreHttpClientEngineCapability>)key __attribute__((swift_name("getCapabilityOrNull(key:)")));

/**
 * Sets request-specific attributes specified by [block].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.setAttributes)
 */
- (void)setAttributesBlock:(void (^)(id<TCCKtor_utilsAttributes>))block __attribute__((swift_name("setAttributes(block:)")));

/**
 * Sets capability configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.setCapability)
 */
- (void)setCapabilityKey:(id<TCCKtor_client_coreHttpClientEngineCapability>)key capability:(id)capability __attribute__((swift_name("setCapability(key:capability:)")));

/**
 * Mutates [this] by copying all the data but execution context from another [builder] using it as the base.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.takeFrom)
 */
- (TCCKtor_client_coreHttpRequestBuilder *)takeFromBuilder:(TCCKtor_client_coreHttpRequestBuilder *)builder __attribute__((swift_name("takeFrom(builder:)")));

/**
 * Mutates [this] copying all the data from another [builder] using it as the base.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.takeFromWithExecutionContext)
 */
- (TCCKtor_client_coreHttpRequestBuilder *)takeFromWithExecutionContextBuilder:(TCCKtor_client_coreHttpRequestBuilder *)builder __attribute__((swift_name("takeFromWithExecutionContext(builder:)")));

/**
 * Executes a [block] that configures the [URLBuilder] associated to this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.url)
 */
- (void)urlBlock:(void (^)(TCCKtor_httpURLBuilder *, TCCKtor_httpURLBuilder *))block __attribute__((swift_name("url(block:)")));

/**
 * Provides access to attributes specific for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.attributes)
 */
@property (readonly) id<TCCKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * The [body] for this request. Initially [EmptyContent].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.body)
 */
@property id body __attribute__((swift_name("body")));

/**
 * The [KType] of [body] for this request. Null for default types that don't need serialization.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.bodyType)
 */
@property TCCKtor_utilsTypeInfo * _Nullable bodyType __attribute__((swift_name("bodyType")));

/**
 * A deferred used to control the execution of this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.executionContext)
 */
@property (readonly) id<TCCKotlinx_coroutines_coreJob> executionContext __attribute__((swift_name("executionContext")));

/**
 * [HeadersBuilder] to configure the headers for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.headers)
 */
@property (readonly) TCCKtor_httpHeadersBuilder *headers __attribute__((swift_name("headers")));

/**
 * [HttpMethod] used by this request. [HttpMethod.Get] by default.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.method)
 */
@property TCCKtor_httpHttpMethod *method __attribute__((swift_name("method")));

/**
 * [URLBuilder] to configure the URL for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.url)
 */
@property (readonly) TCCKtor_httpURLBuilder *url __attribute__((swift_name("url")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponsePipeline.Phases")))
@interface TCCKtor_client_coreHttpResponsePipelinePhases : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_client_coreHttpResponsePipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * Latest response pipeline phase
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.After)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *After __attribute__((swift_name("After")));

/**
 * Decode response body
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Parse)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Parse __attribute__((swift_name("Parse")));

/**
 * The earliest phase that happens before any other
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Receive)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Receive __attribute__((swift_name("Receive")));

/**
 * Use this phase to store request shared state
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.State)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));

/**
 * Transform response body to expected format
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Transform)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Transform __attribute__((swift_name("Transform")));
@end


/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponseContainer")))
@interface TCCKtor_client_coreHttpResponseContainer : TCCBase
- (instancetype)initWithExpectedType:(TCCKtor_utilsTypeInfo *)expectedType response:(id)response __attribute__((swift_name("init(expectedType:response:)"))) __attribute__((objc_designated_initializer));
- (TCCKtor_client_coreHttpResponseContainer *)doCopyExpectedType:(TCCKtor_utilsTypeInfo *)expectedType response:(id)response __attribute__((swift_name("doCopy(expectedType:response:)")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCKtor_utilsTypeInfo *expectedType __attribute__((swift_name("expectedType")));
@property (readonly) id response __attribute__((swift_name("response")));
@end


/**
 * A pair of a [request] and [response] for a specific [HttpClient].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall)
 *
 * @property client the client that executed the call.
 */
__attribute__((swift_name("Ktor_client_coreHttpClientCall")))
@interface TCCKtor_client_coreHttpClientCall : TCCBase <TCCKotlinx_coroutines_coreCoroutineScope>
- (instancetype)initWithClient:(TCCKtor_client_coreHttpClient *)client __attribute__((swift_name("init(client:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithClient:(TCCKtor_client_coreHttpClient *)client requestData:(TCCKtor_client_coreHttpRequestData *)requestData responseData:(TCCKtor_client_coreHttpResponseData *)responseData __attribute__((swift_name("init(client:requestData:responseData:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_client_coreHttpClientCallCompanion *companion __attribute__((swift_name("companion")));

/**
 * Tries to receive the payload of the [response] as a specific expected type provided in [info].
 * Returns [response] if [info] corresponds to [HttpResponse].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.body)
 *
 * @throws NoTransformationFoundException If no transformation is found for the type [info].
 * @throws DoubleReceiveException If already called [body].
 * @throws NullPointerException If content is `null`.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)bodyInfo:(TCCKtor_utilsTypeInfo *)info completionHandler:(void (^)(id _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("body(info:completionHandler:)")));

/**
 * Tries to receive the payload of the [response] as a specific expected type provided in [info].
 * Returns [response] if [info] corresponds to [HttpResponse].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.bodyNullable)
 *
 * @throws NoTransformationFoundException If no transformation is found for the type [info].
 * @throws DoubleReceiveException If already called [body].
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)bodyNullableInfo:(TCCKtor_utilsTypeInfo *)info completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("bodyNullable(info:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)getResponseContentWithCompletionHandler:(void (^)(id<TCCKtor_ioByteReadChannel> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getResponseContent(completionHandler:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) BOOL allowDoubleReceive __attribute__((swift_name("allowDoubleReceive")));

/**
 * Typed [Attributes] associated to this call serving as a lightweight container.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.attributes)
 */
@property (readonly) id<TCCKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) TCCKtor_client_coreHttpClient *client __attribute__((swift_name("client")));
@property (readonly) id<TCCKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));

/**
 * The [request] sent by the client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.request)
 */
@property id<TCCKtor_client_coreHttpRequest> request __attribute__((swift_name("request")));

/**
 * The [response] sent by the server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.response)
 */
@property TCCKtor_client_coreHttpResponse *response __attribute__((swift_name("response")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpSendPipeline.Phases")))
@interface TCCKtor_client_coreHttpSendPipelinePhases : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_client_coreHttpSendPipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * The earliest phase that happens before any other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Before)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Send a request to a remote server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Engine)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Engine __attribute__((swift_name("Engine")));

/**
 * Use this phase for logging and other actions that don't modify a request or shared data.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Monitoring)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Monitoring __attribute__((swift_name("Monitoring")));

/**
 * Receive a pipeline execution phase.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Receive)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *Receive __attribute__((swift_name("Receive")));

/**
 * Use this phase to modify request with a shared state.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.State)
 */
@property (readonly) TCCKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@end


/**
 * A WebSocket extension instance.
 * This instance is created for each WebSocket request, for every installed extension by [WebSocketExtensionFactory].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension)
 */
__attribute__((swift_name("Ktor_websocketsWebSocketExtension")))
@protocol TCCKtor_websocketsWebSocketExtension
@required

/**
 * This method is called only for the client, when it receives the WebSocket upgrade response.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.clientNegotiation)
 *
 * @param negotiatedProtocols contains list of negotiated extensions from the server (can be empty).
 *
 * It's up to extension to decide if it should be used or not.
 * @return `true` if the extension should be used by the client.
 */
- (BOOL)clientNegotiationNegotiatedProtocols:(NSArray<TCCKtor_websocketsWebSocketExtensionHeader *> *)negotiatedProtocols __attribute__((swift_name("clientNegotiation(negotiatedProtocols:)")));

/**
 * This method is called on each incoming frame before handling it in WebSocket session.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.processIncomingFrame)
 */
- (TCCKtor_websocketsFrame *)processIncomingFrameFrame:(TCCKtor_websocketsFrame *)frame __attribute__((swift_name("processIncomingFrame(frame:)")));

/**
 * This method is called on each outgoing frame and handle it before sending.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.processOutgoingFrame)
 */
- (TCCKtor_websocketsFrame *)processOutgoingFrameFrame:(TCCKtor_websocketsFrame *)frame __attribute__((swift_name("processOutgoingFrame(frame:)")));

/**
 * This method is called only for the server, when it receives WebSocket session.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.serverNegotiation)
 *
 * @param requestedProtocols contains list of requested extensions from the client (can be empty).
 *
 * @return list of protocols (with parameters), which server prefers to use for the current client request.
 */
- (NSArray<TCCKtor_websocketsWebSocketExtensionHeader *> *)serverNegotiationRequestedProtocols:(NSArray<TCCKtor_websocketsWebSocketExtensionHeader *> *)requestedProtocols __attribute__((swift_name("serverNegotiation(requestedProtocols:)")));

/**
 * Reference to the [WebSocketExtensionFactory], which produced this extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.factory)
 */
@property (readonly) id<TCCKtor_websocketsWebSocketExtensionFactory> factory __attribute__((swift_name("factory")));

/**
 * List of WebSocket extension protocols which will be sent by client in headers.
 * They are required to inform server that client wants to negotiate the current extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.protocols)
 */
@property (readonly) NSArray<TCCKtor_websocketsWebSocketExtensionHeader *> *protocols __attribute__((swift_name("protocols")));
@end


/**
 * A factory that defines a WebSocket extension. The factory is used in pair with the
 * [WebSocketExtensionsConfig.install] method to install the WebSocket extension in client or server.
 *
 * Usually this interface is implemented in `companion object` of the origin [WebSocketExtension].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory)
 */
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionFactory")))
@protocol TCCKtor_websocketsWebSocketExtensionFactory
@required

/**
 * Creates an extension instance using [config] block. The extension instance is created for each WebSocket request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.install)
 */
- (id<TCCKtor_websocketsWebSocketExtension>)installConfig:(void (^)(id))config __attribute__((swift_name("install(config:)")));

/**
 * A key used to locate an extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.key)
 */
@property (readonly) TCCKtor_utilsAttributeKey<id<TCCKtor_websocketsWebSocketExtension>> *key __attribute__((swift_name("key")));

/**
 * The first extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with the enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv1)
 */
@property (readonly) BOOL rsv1 __attribute__((swift_name("rsv1")));

/**
 * A second extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with the enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv2)
 */
@property (readonly) BOOL rsv2 __attribute__((swift_name("rsv2")));

/**
 * A third extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv3)
 */
@property (readonly) BOOL rsv3 __attribute__((swift_name("rsv3")));
@end

__attribute__((swift_name("Ktor_ioCharset")))
@interface TCCKtor_ioCharset : TCCBase
- (instancetype)initWith_name:(NSString *)_name __attribute__((swift_name("init(_name:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_ioCharsetCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TCCKtor_ioCharsetDecoder *)doNewDecoder __attribute__((swift_name("doNewDecoder()")));
- (TCCKtor_ioCharsetEncoder *)doNewEncoder __attribute__((swift_name("doNewEncoder()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end


/**
 * Ktor type information.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.reflect.TypeInfo)
 *
 * @property type Source KClass<*>
 * @property kotlinType Kotlin reified type with all generic type parameters.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsTypeInfo")))
@interface TCCKtor_utilsTypeInfo : TCCBase
- (instancetype)initWithType:(id<TCCKotlinKClass>)type kotlinType:(id<TCCKotlinKType> _Nullable)kotlinType __attribute__((swift_name("init(type:kotlinType:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithType:(id<TCCKotlinKClass>)type reifiedType:(id<TCCKotlinKType>)reifiedType kotlinType:(id<TCCKotlinKType> _Nullable)kotlinType __attribute__((swift_name("init(type:reifiedType:kotlinType:)"))) __attribute__((objc_designated_initializer)) __attribute__((deprecated("Use constructor without reifiedType parameter.")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<TCCKotlinKType> _Nullable kotlinType __attribute__((swift_name("kotlinType")));
@property (readonly) id<TCCKotlinKClass> type __attribute__((swift_name("type")));
@end


/**
 * A frame received or ready to be sent. It is not reusable and not thread-safe
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame)
 *
 * @property fin is it final fragment, should be always `true` for control frames and if no fragmentation is used
 * @property frameType enum value
 * @property data - a frame content or fragment content
 * @property disposableHandle could be invoked when the frame is processed
 */
__attribute__((swift_name("Ktor_websocketsFrame")))
@interface TCCKtor_websocketsFrame : TCCBase
@property (class, readonly, getter=companion) TCCKtor_websocketsFrameCompanion *companion __attribute__((swift_name("companion")));

/**
 * Creates a frame copy.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame.copy)
 */
- (TCCKtor_websocketsFrame *)doCopy __attribute__((swift_name("doCopy()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TCCKotlinByteArray *data __attribute__((swift_name("data")));
@property (readonly) id<TCCKotlinx_coroutines_coreDisposableHandle> disposableHandle __attribute__((swift_name("disposableHandle")));
@property (readonly) BOOL fin __attribute__((swift_name("fin")));
@property (readonly) TCCKtor_websocketsFrameType *frameType __attribute__((swift_name("frameType")));
@property (readonly) BOOL rsv1 __attribute__((swift_name("rsv1")));
@property (readonly) BOOL rsv2 __attribute__((swift_name("rsv2")));
@property (readonly) BOOL rsv3 __attribute__((swift_name("rsv3")));
@end

__attribute__((swift_name("Kotlinx_io_coreSource")))
@protocol TCCKotlinx_io_coreSource <TCCKotlinx_io_coreRawSource>
@required
- (BOOL)exhausted __attribute__((swift_name("exhausted()")));
- (id<TCCKotlinx_io_coreSource>)peek __attribute__((swift_name("peek()")));
- (int32_t)readAtMostToSink:(TCCKotlinByteArray *)sink startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("readAtMostTo(sink:startIndex:endIndex:)")));
- (int8_t)readByte __attribute__((swift_name("readByte()")));
- (int32_t)readInt __attribute__((swift_name("readInt()")));
- (int64_t)readLong __attribute__((swift_name("readLong()")));
- (int16_t)readShort __attribute__((swift_name("readShort()")));
- (void)readToSink:(id<TCCKotlinx_io_coreRawSink>)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readTo(sink:byteCount:)")));
- (BOOL)requestByteCount:(int64_t)byteCount __attribute__((swift_name("request(byteCount:)")));
- (void)requireByteCount:(int64_t)byteCount __attribute__((swift_name("require(byteCount:)")));
- (void)skipByteCount:(int64_t)byteCount __attribute__((swift_name("skip(byteCount:)")));
- (int64_t)transferToSink:(id<TCCKotlinx_io_coreRawSink>)sink __attribute__((swift_name("transferTo(sink:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) TCCKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_coreBuffer")))
@interface TCCKotlinx_io_coreBuffer : TCCBase <TCCKotlinx_io_coreSource, TCCKotlinx_io_coreSink>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)clear __attribute__((swift_name("clear()")));
- (void)close __attribute__((swift_name("close()")));
- (TCCKotlinx_io_coreBuffer *)doCopy __attribute__((swift_name("doCopy()")));
- (void)doCopyToOut:(TCCKotlinx_io_coreBuffer *)out startIndex:(int64_t)startIndex endIndex:(int64_t)endIndex __attribute__((swift_name("doCopyTo(out:startIndex:endIndex:)")));
- (void)emit __attribute__((swift_name("emit()")));
- (BOOL)exhausted __attribute__((swift_name("exhausted()")));
- (void)flush __attribute__((swift_name("flush()")));
- (int8_t)getPosition:(int64_t)position __attribute__((swift_name("get(position:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
- (void)hintEmit __attribute__((swift_name("hintEmit()")));
- (id<TCCKotlinx_io_coreSource>)peek __attribute__((swift_name("peek()")));
- (int64_t)readAtMostToSink:(TCCKotlinx_io_coreBuffer *)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readAtMostTo(sink:byteCount:)")));
- (int32_t)readAtMostToSink:(TCCKotlinByteArray *)sink startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("readAtMostTo(sink:startIndex:endIndex:)")));
- (int8_t)readByte __attribute__((swift_name("readByte()")));
- (int32_t)readInt __attribute__((swift_name("readInt()")));
- (int64_t)readLong __attribute__((swift_name("readLong()")));
- (int16_t)readShort __attribute__((swift_name("readShort()")));
- (void)readToSink:(id<TCCKotlinx_io_coreRawSink>)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readTo(sink:byteCount:)")));
- (BOOL)requestByteCount:(int64_t)byteCount __attribute__((swift_name("request(byteCount:)")));
- (void)requireByteCount:(int64_t)byteCount __attribute__((swift_name("require(byteCount:)")));
- (void)skipByteCount:(int64_t)byteCount __attribute__((swift_name("skip(byteCount:)")));
- (NSString *)description __attribute__((swift_name("description()")));
- (int64_t)transferFromSource:(id<TCCKotlinx_io_coreRawSource>)source __attribute__((swift_name("transferFrom(source:)")));
- (int64_t)transferToSink:(id<TCCKotlinx_io_coreRawSink>)sink __attribute__((swift_name("transferTo(sink:)")));
- (void)writeSource:(TCCKotlinx_io_coreBuffer *)source byteCount:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount:)")));
- (void)writeSource:(id<TCCKotlinx_io_coreRawSource>)source byteCount_:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount_:)")));
- (void)writeSource:(TCCKotlinByteArray *)source startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("write(source:startIndex:endIndex:)")));
- (void)writeByteByte:(int8_t)byte __attribute__((swift_name("writeByte(byte:)")));
- (void)writeIntInt:(int32_t)int_ __attribute__((swift_name("writeInt(int:)")));
- (void)writeLongLong:(int64_t)long_ __attribute__((swift_name("writeLong(long:)")));
- (void)writeShortShort:(int16_t)short_ __attribute__((swift_name("writeShort(short:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) TCCKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@property (readonly) int64_t size __attribute__((swift_name("size")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateProgression.Companion")))
@interface TCCKotlinx_datetimeLocalDateProgressionCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeLocalDateProgressionCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateRange.Companion")))
@interface TCCKotlinx_datetimeLocalDateRangeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeLocalDateRangeCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) TCCKotlinx_datetimeLocalDateRange *EMPTY __attribute__((swift_name("EMPTY")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimePadding")))
@interface TCCKotlinx_datetimePadding : TCCKotlinEnum<TCCKotlinx_datetimePadding *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCKotlinx_datetimePadding *none __attribute__((swift_name("none")));
@property (class, readonly) TCCKotlinx_datetimePadding *zero __attribute__((swift_name("zero")));
@property (class, readonly) TCCKotlinx_datetimePadding *space __attribute__((swift_name("space")));
+ (TCCKotlinArray<TCCKotlinx_datetimePadding *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKotlinx_datetimePadding *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeekNames")))
@interface TCCKotlinx_datetimeDayOfWeekNames : TCCBase
- (instancetype)initWithNames:(NSArray<NSString *> *)names __attribute__((swift_name("init(names:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMonday:(NSString *)monday tuesday:(NSString *)tuesday wednesday:(NSString *)wednesday thursday:(NSString *)thursday friday:(NSString *)friday saturday:(NSString *)saturday sunday:(NSString *)sunday __attribute__((swift_name("init(monday:tuesday:wednesday:thursday:friday:saturday:sunday:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinx_datetimeDayOfWeekNamesCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *names __attribute__((swift_name("names")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonthNames")))
@interface TCCKotlinx_datetimeMonthNames : TCCBase
- (instancetype)initWithNames:(NSArray<NSString *> *)names __attribute__((swift_name("init(names:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithJanuary:(NSString *)january february:(NSString *)february march:(NSString *)march april:(NSString *)april may:(NSString *)may june:(NSString *)june july:(NSString *)july august:(NSString *)august september:(NSString *)september october:(NSString *)october november:(NSString *)november december:(NSString *)december __attribute__((swift_name("init(january:february:march:april:may:june:july:august:september:october:november:december:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinx_datetimeMonthNamesCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *names __attribute__((swift_name("names")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/UtcOffsetSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeUtcOffset")))
@interface TCCKotlinx_datetimeUtcOffset : TCCBase
@property (class, readonly, getter=companion) TCCKotlinx_datetimeUtcOffsetCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t totalSeconds __attribute__((swift_name("totalSeconds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeFixedOffsetTimeZone.Companion")))
@interface TCCKotlinx_datetimeFixedOffsetTimeZoneCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeFixedOffsetTimeZoneCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonClassDiscriminatorMode")))
@interface TCCKotlinx_serialization_jsonClassDiscriminatorMode : TCCKotlinEnum<TCCKotlinx_serialization_jsonClassDiscriminatorMode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCKotlinx_serialization_jsonClassDiscriminatorMode *none __attribute__((swift_name("none")));
@property (class, readonly) TCCKotlinx_serialization_jsonClassDiscriminatorMode *allJsonObjects __attribute__((swift_name("allJsonObjects")));
@property (class, readonly) TCCKotlinx_serialization_jsonClassDiscriminatorMode *polymorphic __attribute__((swift_name("polymorphic")));
+ (TCCKotlinArray<TCCKotlinx_serialization_jsonClassDiscriminatorMode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKotlinx_serialization_jsonClassDiscriminatorMode *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonNamingStrategy")))
@protocol TCCKotlinx_serialization_jsonJsonNamingStrategy
@required
- (NSString *)serialNameForJsonDescriptor:(id<TCCKotlinx_serialization_coreSerialDescriptor>)descriptor elementIndex:(int32_t)elementIndex serialName:(NSString *)serialName __attribute__((swift_name("serialNameForJson(descriptor:elementIndex:serialName:)")));
@end

__attribute__((swift_name("Ktor_ioJvmSerializable")))
@protocol TCCKtor_ioJvmSerializable
@required
@end


/**
 * Represents an immutable URL
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url)
 *
 * @property protocol
 * @property host name without port (domain)
 * @property port the specified port or protocol default port
 * @property specifiedPort port number that was specified to override protocol's default
 * @property encodedPath encoded path without query string
 * @property parameters URL query parameters
 * @property fragment URL fragment (anchor name)
 * @property user username part of URL
 * @property password password part of URL
 * @property trailingQuery keep trailing question character even if there are no query parameters
 *
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=io/ktor/http/UrlSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpUrl")))
@interface TCCKtor_httpUrl : TCCBase <TCCKtor_ioJvmSerializable>
@property (class, readonly, getter=companion) TCCKtor_httpUrlCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *encodedFragment __attribute__((swift_name("encodedFragment")));
@property (readonly) NSString * _Nullable encodedPassword __attribute__((swift_name("encodedPassword")));
@property (readonly) NSString *encodedPath __attribute__((swift_name("encodedPath")));
@property (readonly) NSString *encodedPathAndQuery __attribute__((swift_name("encodedPathAndQuery")));
@property (readonly) NSString *encodedQuery __attribute__((swift_name("encodedQuery")));
@property (readonly) NSString * _Nullable encodedUser __attribute__((swift_name("encodedUser")));
@property (readonly) NSString *fragment __attribute__((swift_name("fragment")));
@property (readonly) NSString *host __attribute__((swift_name("host")));
@property (readonly) id<TCCKtor_httpParameters> parameters __attribute__((swift_name("parameters")));
@property (readonly) NSString * _Nullable password __attribute__((swift_name("password")));

/**
 * A list containing the segments of the URL path.
 *
 * This property was designed to distinguish between absolute and relative paths,
 * so it will have an empty segment at the beginning for URLs with a hostname
 * and an empty segment at the end for URLs with a trailing slash.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.pathSegments == listOf("", "docs", "")
 *
 * val absolute = Url("/docs/")
 * absolute.pathSegments == listOf("", "docs", "")
 *
 * val relative = Url("docs")
 * relative.pathSegments == listOf("docs")
 * ```
 *
 * This behaviour may not be ideal if you're working only with full URLs.
 * If you don't require the specific handling of empty segments, consider using the [segments] property instead:
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 *
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * To address this issue, the current [pathSegments] property will be renamed to [rawSegments].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.pathSegments)
 */
@property (readonly) NSArray<NSString *> *pathSegments __attribute__((swift_name("pathSegments"))) __attribute__((deprecated("\n        `pathSegments` is deprecated.\n\n        This property will contain an empty path segment at the beginning for URLs with a hostname,\n        and an empty path segment at the end for the URLs with a trailing slash. If you need to keep this behaviour please\n        use [rawSegments]. If you only need to access the meaningful parts of the path, consider using [segments] instead.\n             \n        Please decide if you need [rawSegments] or [segments] explicitly.\n        ")));
@property (readonly) int32_t port __attribute__((swift_name("port")));
@property (readonly) TCCKtor_httpURLProtocol *protocol __attribute__((swift_name("protocol")));
@property (readonly) TCCKtor_httpURLProtocol * _Nullable protocolOrNull __attribute__((swift_name("protocolOrNull")));

/**
 * A list containing the segments of the URL path.
 *
 * This property is designed to distinguish between absolute and relative paths,
 * so it will have an empty segment at the beginning for URLs with a hostname
 * and an empty segment at the end for URLs with a trailing slash.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.rawSegments == listOf("", "docs", "")
 *
 * val absolute = Url("/docs/")
 * absolute.rawSegments == listOf("", "docs", "")
 *
 * val relative = Url("docs")
 * relative.rawSegments == listOf("docs")
 * ```
 *
 * This behaviour may not be ideal if you're working only with full URLs.
 * If you don't require the specific handling of empty segments, consider using the [segments] property instead:
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 *
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.rawSegments)
 */
@property (readonly) NSArray<NSString *> *rawSegments __attribute__((swift_name("rawSegments")));

/**
 * A list of path segments derived from the URL, excluding any leading
 * and trailing empty segments.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * If you need to check for trailing slash and relative/absolute paths, please check the [rawSegments] property.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.segments)
 **/
@property (readonly) NSArray<NSString *> *segments __attribute__((swift_name("segments")));
@property (readonly) int32_t specifiedPort __attribute__((swift_name("specifiedPort")));
@property (readonly) BOOL trailingQuery __attribute__((swift_name("trailingQuery")));
@property (readonly) NSString * _Nullable user __attribute__((swift_name("user")));
@end


/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpMethod")))
@interface TCCKtor_httpHttpMethod : TCCBase
- (instancetype)initWithValue:(NSString *)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_httpHttpMethodCompanion *companion __attribute__((swift_name("companion")));
- (TCCKtor_httpHttpMethod *)doCopyValue:(NSString *)value __attribute__((swift_name("doCopy(value:)")));

/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Provides data structure for associating a [String] with a [List] of Strings
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues)
 */
__attribute__((swift_name("Ktor_utilsStringValues")))
@protocol TCCKtor_utilsStringValues
@required

/**
 * Checks if the given [name] exists in the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.contains)
 */
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));

/**
 * Checks if the given [name] and [value] pair exists in the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.contains)
 */
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));

/**
 * Gets all entries from the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.entries)
 */
- (NSSet<id<TCCKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));

/**
 * Iterates over all entries in this map and calls [body] for each pair
 *
 * Can be optimized in implementations
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.forEach)
 */
- (void)forEachBody:(void (^)(NSString *, NSArray<NSString *> *))body __attribute__((swift_name("forEach(body:)")));

/**
 * Gets first value from the list of values associated with a [name], or null if the name is not present
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.get)
 */
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));

/**
 * Gets all values associated with the [name], or null if the name is not present
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.getAll)
 */
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));

/**
 * Checks if this map is empty
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.isEmpty)
 */
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));

/**
 * Gets all names from the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.names)
 */
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));

/**
 * Specifies if map has case-sensitive or case-insensitive names
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.caseInsensitiveName)
 */
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));
@end


/**
 * Represents HTTP headers as a map from case-insensitive names to collection of [String] values
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Headers)
 */
__attribute__((swift_name("Ktor_httpHeaders")))
@protocol TCCKtor_httpHeaders <TCCKtor_utilsStringValues>
@required
@end


/**
 * Information about the content to be sent to the peer, recognized by a client or server engine
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent)
 */
__attribute__((swift_name("Ktor_httpOutgoingContent")))
@interface TCCKtor_httpOutgoingContent : TCCBase

/**
 * Gets an extension property for this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.getProperty)
 */
- (id _Nullable)getPropertyKey:(TCCKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("getProperty(key:)")));

/**
 * Sets an extension property for this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.setProperty)
 */
- (void)setPropertyKey:(TCCKtor_utilsAttributeKey<id> *)key value:(id _Nullable)value __attribute__((swift_name("setProperty(key:value:)")));

/**
 * Trailers to set when sending this content, will be ignored if request is not in HTTP2 mode
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.trailers)
 */
- (id<TCCKtor_httpHeaders> _Nullable)trailers __attribute__((swift_name("trailers()")));

/**
 * Specifies content length in bytes for this resource.
 *
 * If null, the resources will be sent as `Transfer-Encoding: chunked`
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.contentLength)
 */
@property (readonly) TCCLong * _Nullable contentLength __attribute__((swift_name("contentLength")));

/**
 * Specifies [ContentType] for this resource.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.contentType)
 */
@property (readonly) TCCKtor_httpContentType * _Nullable contentType __attribute__((swift_name("contentType")));

/**
 * Headers to set when sending this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.headers)
 */
@property (readonly) id<TCCKtor_httpHeaders> headers __attribute__((swift_name("headers")));

/**
 * Status code to set when sending this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.status)
 */
@property (readonly) TCCKtor_httpHttpStatusCode * _Nullable status __attribute__((swift_name("status")));
@end


/**
 * Represents an HTTP status code and description.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode)
 *
 * @param value is a numeric code.
 * @param description is free form description of a status.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpStatusCode")))
@interface TCCKtor_httpHttpStatusCode : TCCBase <TCCKotlinComparable>
- (instancetype)initWithValue:(int32_t)value description:(NSString *)description __attribute__((swift_name("init(value:description:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_httpHttpStatusCodeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TCCKtor_httpHttpStatusCode *)other __attribute__((swift_name("compareTo(other:)")));
- (TCCKtor_httpHttpStatusCode *)doCopyValue:(int32_t)value description:(NSString *)description __attribute__((swift_name("doCopy(value:description:)")));

/**
 * Returns a copy of `this` code with a description changed to [value].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.description)
 */
- (TCCKtor_httpHttpStatusCode *)descriptionValue:(NSString *)value __attribute__((swift_name("description(value:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) int32_t value __attribute__((swift_name("value")));
@end


/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsGMTDate")))
@interface TCCKtor_utilsGMTDate : TCCBase <TCCKotlinComparable>
- (instancetype)initWithSeconds:(int32_t)seconds minutes:(int32_t)minutes hours:(int32_t)hours dayOfWeek:(TCCKtor_utilsWeekDay *)dayOfWeek dayOfMonth:(int32_t)dayOfMonth dayOfYear:(int32_t)dayOfYear month:(TCCKtor_utilsMonth *)month year:(int32_t)year timestamp:(int64_t)timestamp __attribute__((swift_name("init(seconds:minutes:hours:dayOfWeek:dayOfMonth:dayOfYear:month:year:timestamp:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_utilsGMTDateCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TCCKtor_utilsGMTDate *)other __attribute__((swift_name("compareTo(other:)")));
- (TCCKtor_utilsGMTDate *)doCopy __attribute__((swift_name("doCopy()")));
- (TCCKtor_utilsGMTDate *)doCopySeconds:(int32_t)seconds minutes:(int32_t)minutes hours:(int32_t)hours dayOfWeek:(TCCKtor_utilsWeekDay *)dayOfWeek dayOfMonth:(int32_t)dayOfMonth dayOfYear:(int32_t)dayOfYear month:(TCCKtor_utilsMonth *)month year:(int32_t)year timestamp:(int64_t)timestamp __attribute__((swift_name("doCopy(seconds:minutes:hours:dayOfWeek:dayOfMonth:dayOfYear:month:year:timestamp:)")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth")));
@property (readonly) TCCKtor_utilsWeekDay *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) int32_t hours __attribute__((swift_name("hours")));
@property (readonly) int32_t minutes __attribute__((swift_name("minutes")));
@property (readonly) TCCKtor_utilsMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t seconds __attribute__((swift_name("seconds")));
@property (readonly) int64_t timestamp __attribute__((swift_name("timestamp")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end


/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpProtocolVersion")))
@interface TCCKtor_httpHttpProtocolVersion : TCCBase
- (instancetype)initWithName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("init(name:major:minor:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_httpHttpProtocolVersionCompanion *companion __attribute__((swift_name("companion")));
- (TCCKtor_httpHttpProtocolVersion *)doCopyName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("doCopy(name:major:minor:)")));

/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t major __attribute__((swift_name("major")));
@property (readonly) int32_t minor __attribute__((swift_name("minor")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinContinuation")))
@protocol TCCKotlinContinuation
@required
- (void)resumeWithResult:(id _Nullable)result __attribute__((swift_name("resumeWith(result:)")));
@property (readonly) id<TCCKotlinCoroutineContext> context __attribute__((swift_name("context")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
 *   kotlin.ExperimentalStdlibApi
*/
__attribute__((swift_name("KotlinAbstractCoroutineContextKey")))
@interface TCCKotlinAbstractCoroutineContextKey<B, E> : TCCBase <TCCKotlinCoroutineContextKey>
- (instancetype)initWithBaseKey:(id<TCCKotlinCoroutineContextKey>)baseKey safeCast:(E _Nullable (^)(id<TCCKotlinCoroutineContextElement>))safeCast __attribute__((swift_name("init(baseKey:safeCast:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * @note annotations
 *   kotlin.ExperimentalStdlibApi
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineDispatcher.Key")))
@interface TCCKotlinx_coroutines_coreCoroutineDispatcherKey : TCCKotlinAbstractCoroutineContextKey<id<TCCKotlinContinuationInterceptor>, TCCKotlinx_coroutines_coreCoroutineDispatcher *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithBaseKey:(id<TCCKotlinCoroutineContextKey>)baseKey safeCast:(id<TCCKotlinCoroutineContextElement> _Nullable (^)(id<TCCKotlinCoroutineContextElement>))safeCast __attribute__((swift_name("init(baseKey:safeCast:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)key __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_coroutines_coreCoroutineDispatcherKey *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreRunnable")))
@protocol TCCKotlinx_coroutines_coreRunnable
@required
- (void)run __attribute__((swift_name("run()")));
@end

__attribute__((swift_name("Ktor_utilsStringValuesBuilder")))
@protocol TCCKtor_utilsStringValuesBuilder
@required
- (void)appendName:(NSString *)name value:(NSString *)value __attribute__((swift_name("append(name:value:)")));
- (void)appendAllStringValues:(id<TCCKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendAll(stringValues:)")));
- (void)appendAllName:(NSString *)name values:(id)values __attribute__((swift_name("appendAll(name:values:)")));
- (void)appendMissingStringValues:(id<TCCKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendMissing(stringValues:)")));
- (void)appendMissingName:(NSString *)name values:(id)values __attribute__((swift_name("appendMissing(name:values:)")));
- (id<TCCKtor_utilsStringValues>)build __attribute__((swift_name("build()")));
- (void)clear __attribute__((swift_name("clear()")));
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<TCCKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
- (void)removeName:(NSString *)name __attribute__((swift_name("remove(name:)")));
- (BOOL)removeName:(NSString *)name value:(NSString *)value __attribute__((swift_name("remove(name:value:)")));
- (void)removeKeysWithNoEntries __attribute__((swift_name("removeKeysWithNoEntries()")));
- (void)setName:(NSString *)name value:(NSString *)value __attribute__((swift_name("set(name:value:)")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));
@end

__attribute__((swift_name("Ktor_utilsStringValuesBuilderImpl")))
@interface TCCKtor_utilsStringValuesBuilderImpl : TCCBase <TCCKtor_utilsStringValuesBuilder>
- (instancetype)initWithCaseInsensitiveName:(BOOL)caseInsensitiveName size:(int32_t)size __attribute__((swift_name("init(caseInsensitiveName:size:)"))) __attribute__((objc_designated_initializer));
- (void)appendName:(NSString *)name value:(NSString *)value __attribute__((swift_name("append(name:value:)")));
- (void)appendAllStringValues:(id<TCCKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendAll(stringValues:)")));
- (void)appendAllName:(NSString *)name values:(id)values __attribute__((swift_name("appendAll(name:values:)")));
- (void)appendMissingStringValues:(id<TCCKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendMissing(stringValues:)")));
- (void)appendMissingName:(NSString *)name values:(id)values __attribute__((swift_name("appendMissing(name:values:)")));
- (id<TCCKtor_utilsStringValues>)build __attribute__((swift_name("build()")));
- (void)clear __attribute__((swift_name("clear()")));
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<TCCKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
- (void)removeName:(NSString *)name __attribute__((swift_name("remove(name:)")));
- (BOOL)removeName:(NSString *)name value:(NSString *)value __attribute__((swift_name("remove(name:value:)")));
- (void)removeKeysWithNoEntries __attribute__((swift_name("removeKeysWithNoEntries()")));
- (void)setName:(NSString *)name value:(NSString *)value __attribute__((swift_name("set(name:value:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateNameName:(NSString *)name __attribute__((swift_name("validateName(name:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateValueValue:(NSString *)value __attribute__((swift_name("validateValue(value:)")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TCCMutableDictionary<NSString *, NSMutableArray<NSString *> *> *values __attribute__((swift_name("values")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeadersBuilder")))
@interface TCCKtor_httpHeadersBuilder : TCCKtor_utilsStringValuesBuilderImpl
- (instancetype)initWithSize:(int32_t)size __attribute__((swift_name("init(size:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCaseInsensitiveName:(BOOL)caseInsensitiveName size:(int32_t)size __attribute__((swift_name("init(caseInsensitiveName:size:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (id<TCCKtor_httpHeaders>)build __attribute__((swift_name("build()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateNameName:(NSString *)name __attribute__((swift_name("validateName(name:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateValueValue:(NSString *)value __attribute__((swift_name("validateValue(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestBuilder.Companion")))
@interface TCCKtor_client_coreHttpRequestBuilderCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_client_coreHttpRequestBuilderCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * A URL builder with all mutable components
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder)
 *
 * @property protocol URL protocol (scheme)
 * @property host name without port (domain)
 * @property port port number
 * @property user username part (optional)
 * @property password password part (optional)
 * @property pathSegments URL path without query
 * @property parameters URL query parameters
 * @property fragment URL fragment (anchor name)
 * @property trailingQuery keep a trailing question character even if there are no query parameters
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLBuilder")))
@interface TCCKtor_httpURLBuilder : TCCBase
- (instancetype)initWithProtocol:(TCCKtor_httpURLProtocol * _Nullable)protocol host:(NSString *)host port:(int32_t)port user:(NSString * _Nullable)user password:(NSString * _Nullable)password pathSegments:(NSArray<NSString *> *)pathSegments parameters:(id<TCCKtor_httpParameters>)parameters fragment:(NSString *)fragment trailingQuery:(BOOL)trailingQuery __attribute__((swift_name("init(protocol:host:port:user:password:pathSegments:parameters:fragment:trailingQuery:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_httpURLBuilderCompanion *companion __attribute__((swift_name("companion")));

/**
 * Build a [Url] instance (everything is copied to a new instance)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder.build)
 */
- (TCCKtor_httpUrl *)build __attribute__((swift_name("build()")));

/**
 * Build a URL string
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder.buildString)
 */
- (NSString *)buildString __attribute__((swift_name("buildString()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property NSString *encodedFragment __attribute__((swift_name("encodedFragment")));
@property id<TCCKtor_httpParametersBuilder> encodedParameters __attribute__((swift_name("encodedParameters")));
@property NSString * _Nullable encodedPassword __attribute__((swift_name("encodedPassword")));
@property NSArray<NSString *> *encodedPathSegments __attribute__((swift_name("encodedPathSegments")));
@property NSString * _Nullable encodedUser __attribute__((swift_name("encodedUser")));
@property NSString *fragment __attribute__((swift_name("fragment")));
@property NSString *host __attribute__((swift_name("host")));
@property (readonly) id<TCCKtor_httpParametersBuilder> parameters __attribute__((swift_name("parameters")));
@property NSString * _Nullable password __attribute__((swift_name("password")));
@property NSArray<NSString *> *pathSegments __attribute__((swift_name("pathSegments")));
@property int32_t port __attribute__((swift_name("port")));
@property TCCKtor_httpURLProtocol *protocol __attribute__((swift_name("protocol")));
@property TCCKtor_httpURLProtocol * _Nullable protocolOrNull __attribute__((swift_name("protocolOrNull")));
@property BOOL trailingQuery __attribute__((swift_name("trailingQuery")));
@property NSString * _Nullable user __attribute__((swift_name("user")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClientCall.Companion")))
@interface TCCKtor_client_coreHttpClientCallCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_client_coreHttpClientCallCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * A request for [HttpClient], first part of [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest)
 */
__attribute__((swift_name("Ktor_client_coreHttpRequest")))
@protocol TCCKtor_client_coreHttpRequest <TCCKtor_httpHttpMessage, TCCKotlinx_coroutines_coreCoroutineScope>
@required

/**
 * Typed [Attributes] associated to this call serving as a lightweight container.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.attributes)
 */
@property (readonly) id<TCCKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * The associated [HttpClientCall] containing both
 * the underlying [HttpClientCall.request] and [HttpClientCall.response].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.call)
 */
@property (readonly) TCCKtor_client_coreHttpClientCall *call __attribute__((swift_name("call")));

/**
 * An [OutgoingContent] representing the request body
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.content)
 */
@property (readonly) TCCKtor_httpOutgoingContent *content __attribute__((swift_name("content")));

/**
 * The [HttpMethod] or HTTP VERB used for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.method)
 */
@property (readonly) TCCKtor_httpHttpMethod *method __attribute__((swift_name("method")));

/**
 * The [Url] representing the endpoint and the uri for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.url)
 */
@property (readonly) TCCKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * A parsed `Sec-WebSocket-Accept` header item representation.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionHeader)
 *
 * @param name is extension name.
 * @param parameters is list of extension parameters.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionHeader")))
@interface TCCKtor_websocketsWebSocketExtensionHeader : TCCBase
- (instancetype)initWithName:(NSString *)name parameters:(NSArray<NSString *> *)parameters __attribute__((swift_name("init(name:parameters:)"))) __attribute__((objc_designated_initializer));

/**
 * Parses parameters keys and values.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionHeader.parseParameters)
 */
- (id<TCCKotlinSequence>)parseParameters __attribute__((swift_name("parseParameters()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) NSArray<NSString *> *parameters __attribute__((swift_name("parameters")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioCharset.Companion")))
@interface TCCKtor_ioCharsetCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_ioCharsetCompanion *shared __attribute__((swift_name("shared")));
- (TCCKtor_ioCharset *)forNameName:(NSString *)name __attribute__((swift_name("forName(name:)")));
- (BOOL)isSupportedCharset:(NSString *)charset __attribute__((swift_name("isSupported(charset:)")));
@end

__attribute__((swift_name("Ktor_ioCharsetDecoder")))
@interface TCCKtor_ioCharsetDecoder : TCCBase
- (instancetype)initWith_charset:(TCCKtor_ioCharset *)_charset __attribute__((swift_name("init(_charset:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("Ktor_ioCharsetEncoder")))
@interface TCCKtor_ioCharsetEncoder : TCCBase
- (instancetype)initWith_charset:(TCCKtor_ioCharset *)_charset __attribute__((swift_name("init(_charset:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinKType")))
@protocol TCCKotlinKType
@required

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
@property (readonly) NSArray<TCCKotlinKTypeProjection *> *arguments __attribute__((swift_name("arguments")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
@property (readonly) id<TCCKotlinKClassifier> _Nullable classifier __attribute__((swift_name("classifier")));
@property (readonly) BOOL isMarkedNullable __attribute__((swift_name("isMarkedNullable")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrame.Companion")))
@interface TCCKtor_websocketsFrameCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_websocketsFrameCompanion *shared __attribute__((swift_name("shared")));

/**
 * Create a particular [Frame] instance by frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame.Companion.byType)
 */
- (TCCKtor_websocketsFrame *)byTypeFin:(BOOL)fin frameType:(TCCKtor_websocketsFrameType *)frameType data:(TCCKotlinByteArray *)data rsv1:(BOOL)rsv1 rsv2:(BOOL)rsv2 rsv3:(BOOL)rsv3 __attribute__((swift_name("byType(fin:frameType:data:rsv1:rsv2:rsv3:)")));
@end


/**
 * A WebSocket frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType)
 *
 * @property controlFrame if this is control frame type
 * @property opcode - frame type id that is used to transport it
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrameType")))
@interface TCCKtor_websocketsFrameType : TCCKotlinEnum<TCCKtor_websocketsFrameType *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * A WebSocket frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType)
 *
 * @property controlFrame if this is control frame type
 * @property opcode - frame type id that is used to transport it
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKtor_websocketsFrameTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCKtor_websocketsFrameType *text __attribute__((swift_name("text")));
@property (class, readonly) TCCKtor_websocketsFrameType *binary __attribute__((swift_name("binary")));
@property (class, readonly) TCCKtor_websocketsFrameType *close __attribute__((swift_name("close")));
@property (class, readonly) TCCKtor_websocketsFrameType *ping __attribute__((swift_name("ping")));
@property (class, readonly) TCCKtor_websocketsFrameType *pong __attribute__((swift_name("pong")));
+ (TCCKotlinArray<TCCKtor_websocketsFrameType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKtor_websocketsFrameType *> *entries __attribute__((swift_name("entries")));
@property (readonly) BOOL controlFrame __attribute__((swift_name("controlFrame")));
@property (readonly) int32_t opcode __attribute__((swift_name("opcode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeekNames.Companion")))
@interface TCCKotlinx_datetimeDayOfWeekNamesCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeDayOfWeekNamesCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) TCCKotlinx_datetimeDayOfWeekNames *ENGLISH_ABBREVIATED __attribute__((swift_name("ENGLISH_ABBREVIATED")));
@property (readonly) TCCKotlinx_datetimeDayOfWeekNames *ENGLISH_FULL __attribute__((swift_name("ENGLISH_FULL")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonthNames.Companion")))
@interface TCCKotlinx_datetimeMonthNamesCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeMonthNamesCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) TCCKotlinx_datetimeMonthNames *ENGLISH_ABBREVIATED __attribute__((swift_name("ENGLISH_ABBREVIATED")));
@property (readonly) TCCKotlinx_datetimeMonthNames *ENGLISH_FULL __attribute__((swift_name("ENGLISH_FULL")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeUtcOffset.Companion")))
@interface TCCKotlinx_datetimeUtcOffsetCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinx_datetimeUtcOffsetCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_datetimeDateTimeFormat>)FormatBlock:(void (^)(id<TCCKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset>))block __attribute__((swift_name("Format(block:)")));
- (TCCKotlinx_datetimeUtcOffset *)parseInput:(id)input format:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) TCCKotlinx_datetimeUtcOffset *ZERO __attribute__((swift_name("ZERO")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpUrl.Companion")))
@interface TCCKtor_httpUrlCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_httpUrlCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Represents HTTP parameters as a map from case-insensitive names to collection of [String] values
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Parameters)
 */
__attribute__((swift_name("Ktor_httpParameters")))
@protocol TCCKtor_httpParameters <TCCKtor_utilsStringValues>
@required
@end


/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLProtocol")))
@interface TCCKtor_httpURLProtocol : TCCBase <TCCKtor_ioJvmSerializable>
- (instancetype)initWithName:(NSString *)name defaultPort:(int32_t)defaultPort __attribute__((swift_name("init(name:defaultPort:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_httpURLProtocolCompanion *companion __attribute__((swift_name("companion")));
- (TCCKtor_httpURLProtocol *)doCopyName:(NSString *)name defaultPort:(int32_t)defaultPort __attribute__((swift_name("doCopy(name:defaultPort:)")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t defaultPort __attribute__((swift_name("defaultPort")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpMethod.Companion")))
@interface TCCKtor_httpHttpMethodCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_httpHttpMethodCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parse HTTP method by [method] string
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod.Companion.parse)
 */
- (TCCKtor_httpHttpMethod *)parseMethod:(NSString *)method __attribute__((swift_name("parse(method:)")));

/**
 * A list of default HTTP methods
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod.Companion.DefaultMethods)
 */
@property (readonly) NSArray<TCCKtor_httpHttpMethod *> *DefaultMethods __attribute__((swift_name("DefaultMethods")));
@property (readonly) TCCKtor_httpHttpMethod *Delete __attribute__((swift_name("Delete")));
@property (readonly) TCCKtor_httpHttpMethod *Get __attribute__((swift_name("Get")));
@property (readonly) TCCKtor_httpHttpMethod *Head __attribute__((swift_name("Head")));
@property (readonly) TCCKtor_httpHttpMethod *Options __attribute__((swift_name("Options")));
@property (readonly) TCCKtor_httpHttpMethod *Patch __attribute__((swift_name("Patch")));
@property (readonly) TCCKtor_httpHttpMethod *Post __attribute__((swift_name("Post")));
@property (readonly) TCCKtor_httpHttpMethod *Put __attribute__((swift_name("Put")));
@end

__attribute__((swift_name("KotlinMapEntry")))
@protocol TCCKotlinMapEntry
@required
@property (readonly) id _Nullable key __attribute__((swift_name("key")));
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Represents a header value that consist of [content] followed by [parameters].
 * Useful for headers such as `Content-Type`, `Content-Disposition` and so on.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters)
 *
 * @property content header's content without parameters
 * @property parameters
 */
__attribute__((swift_name("Ktor_httpHeaderValueWithParameters")))
@interface TCCKtor_httpHeaderValueWithParameters : TCCBase
- (instancetype)initWithContent:(NSString *)content parameters:(NSArray<TCCKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(content:parameters:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKtor_httpHeaderValueWithParametersCompanion *companion __attribute__((swift_name("companion")));

/**
 * The first value for the parameter with [name] comparing case-insensitively or `null` if no such parameters found
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters.parameter)
 */
- (NSString * _Nullable)parameterName:(NSString *)name __attribute__((swift_name("parameter(name:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) NSString *content __attribute__((swift_name("content")));
@property (readonly) NSArray<TCCKtor_httpHeaderValueParam *> *parameters __attribute__((swift_name("parameters")));
@end


/**
 * Represents a value for a `Content-Type` header.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType)
 *
 * @property contentType represents a type part of the media type.
 * @property contentSubtype represents a subtype part of the media type.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpContentType")))
@interface TCCKtor_httpContentType : TCCKtor_httpHeaderValueWithParameters
- (instancetype)initWithContentType:(NSString *)contentType contentSubtype:(NSString *)contentSubtype parameters:(NSArray<TCCKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(contentType:contentSubtype:parameters:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithContent:(NSString *)content parameters:(NSArray<TCCKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(content:parameters:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKtor_httpContentTypeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Checks if `this` type matches a [pattern] type taking into account placeholder symbols `*` and parameters.
 * The `this` type must be a more specific type than the [pattern] type. In other words:
 *
 * ```kotlin
 * ContentType("a", "b").match(ContentType("a", "b").withParameter("foo", "bar")) === false
 * ContentType("a", "b").withParameter("foo", "bar").match(ContentType("a", "b")) === true
 * ContentType("a", "*").match(ContentType("a", "b")) === false
 * ContentType("a", "b").match(ContentType("a", "*")) === true
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.match)
 */
- (BOOL)matchPattern:(TCCKtor_httpContentType *)pattern __attribute__((swift_name("match(pattern:)")));

/**
 * Checks if `this` type matches a [pattern] type taking into account placeholder symbols `*` and parameters.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.match)
 */
- (BOOL)matchPattern_:(NSString *)pattern __attribute__((swift_name("match(pattern_:)")));

/**
 * Creates a copy of `this` type with the added parameter with the [name] and [value].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.withParameter)
 */
- (TCCKtor_httpContentType *)withParameterName:(NSString *)name value:(NSString *)value __attribute__((swift_name("withParameter(name:value:)")));

/**
 * Creates a copy of `this` type without any parameters
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.withoutParameters)
 */
- (TCCKtor_httpContentType *)withoutParameters __attribute__((swift_name("withoutParameters()")));
@property (readonly) NSString *contentSubtype __attribute__((swift_name("contentSubtype")));
@property (readonly) NSString *contentType __attribute__((swift_name("contentType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpStatusCode.Companion")))
@interface TCCKtor_httpHttpStatusCodeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_httpHttpStatusCodeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Creates an instance of [HttpStatusCode] with the given numeric value.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.Companion.fromValue)
 */
- (TCCKtor_httpHttpStatusCode *)fromValueValue:(int32_t)value __attribute__((swift_name("fromValue(value:)")));
@property (readonly) TCCKtor_httpHttpStatusCode *Accepted __attribute__((swift_name("Accepted")));
@property (readonly) TCCKtor_httpHttpStatusCode *BadGateway __attribute__((swift_name("BadGateway")));
@property (readonly) TCCKtor_httpHttpStatusCode *BadRequest __attribute__((swift_name("BadRequest")));
@property (readonly) TCCKtor_httpHttpStatusCode *Conflict __attribute__((swift_name("Conflict")));
@property (readonly) TCCKtor_httpHttpStatusCode *Continue __attribute__((swift_name("Continue")));
@property (readonly) TCCKtor_httpHttpStatusCode *Created __attribute__((swift_name("Created")));
@property (readonly) TCCKtor_httpHttpStatusCode *ExpectationFailed __attribute__((swift_name("ExpectationFailed")));
@property (readonly) TCCKtor_httpHttpStatusCode *FailedDependency __attribute__((swift_name("FailedDependency")));
@property (readonly) TCCKtor_httpHttpStatusCode *Forbidden __attribute__((swift_name("Forbidden")));
@property (readonly) TCCKtor_httpHttpStatusCode *Found __attribute__((swift_name("Found")));
@property (readonly) TCCKtor_httpHttpStatusCode *GatewayTimeout __attribute__((swift_name("GatewayTimeout")));
@property (readonly) TCCKtor_httpHttpStatusCode *Gone __attribute__((swift_name("Gone")));
@property (readonly) TCCKtor_httpHttpStatusCode *InsufficientStorage __attribute__((swift_name("InsufficientStorage")));
@property (readonly) TCCKtor_httpHttpStatusCode *InternalServerError __attribute__((swift_name("InternalServerError")));
@property (readonly) TCCKtor_httpHttpStatusCode *LengthRequired __attribute__((swift_name("LengthRequired")));
@property (readonly) TCCKtor_httpHttpStatusCode *Locked __attribute__((swift_name("Locked")));
@property (readonly) TCCKtor_httpHttpStatusCode *MethodNotAllowed __attribute__((swift_name("MethodNotAllowed")));
@property (readonly) TCCKtor_httpHttpStatusCode *MovedPermanently __attribute__((swift_name("MovedPermanently")));
@property (readonly) TCCKtor_httpHttpStatusCode *MultiStatus __attribute__((swift_name("MultiStatus")));
@property (readonly) TCCKtor_httpHttpStatusCode *MultipleChoices __attribute__((swift_name("MultipleChoices")));
@property (readonly) TCCKtor_httpHttpStatusCode *NoContent __attribute__((swift_name("NoContent")));
@property (readonly) TCCKtor_httpHttpStatusCode *NonAuthoritativeInformation __attribute__((swift_name("NonAuthoritativeInformation")));
@property (readonly) TCCKtor_httpHttpStatusCode *NotAcceptable __attribute__((swift_name("NotAcceptable")));
@property (readonly) TCCKtor_httpHttpStatusCode *NotFound __attribute__((swift_name("NotFound")));
@property (readonly) TCCKtor_httpHttpStatusCode *NotImplemented __attribute__((swift_name("NotImplemented")));
@property (readonly) TCCKtor_httpHttpStatusCode *NotModified __attribute__((swift_name("NotModified")));
@property (readonly) TCCKtor_httpHttpStatusCode *OK __attribute__((swift_name("OK")));
@property (readonly) TCCKtor_httpHttpStatusCode *PartialContent __attribute__((swift_name("PartialContent")));
@property (readonly) TCCKtor_httpHttpStatusCode *PayloadTooLarge __attribute__((swift_name("PayloadTooLarge")));
@property (readonly) TCCKtor_httpHttpStatusCode *PaymentRequired __attribute__((swift_name("PaymentRequired")));
@property (readonly) TCCKtor_httpHttpStatusCode *PermanentRedirect __attribute__((swift_name("PermanentRedirect")));
@property (readonly) TCCKtor_httpHttpStatusCode *PreconditionFailed __attribute__((swift_name("PreconditionFailed")));
@property (readonly) TCCKtor_httpHttpStatusCode *Processing __attribute__((swift_name("Processing")));
@property (readonly) TCCKtor_httpHttpStatusCode *ProxyAuthenticationRequired __attribute__((swift_name("ProxyAuthenticationRequired")));
@property (readonly) TCCKtor_httpHttpStatusCode *RequestHeaderFieldTooLarge __attribute__((swift_name("RequestHeaderFieldTooLarge")));
@property (readonly) TCCKtor_httpHttpStatusCode *RequestTimeout __attribute__((swift_name("RequestTimeout")));
@property (readonly) TCCKtor_httpHttpStatusCode *RequestURITooLong __attribute__((swift_name("RequestURITooLong")));
@property (readonly) TCCKtor_httpHttpStatusCode *RequestedRangeNotSatisfiable __attribute__((swift_name("RequestedRangeNotSatisfiable")));
@property (readonly) TCCKtor_httpHttpStatusCode *ResetContent __attribute__((swift_name("ResetContent")));
@property (readonly) TCCKtor_httpHttpStatusCode *SeeOther __attribute__((swift_name("SeeOther")));
@property (readonly) TCCKtor_httpHttpStatusCode *ServiceUnavailable __attribute__((swift_name("ServiceUnavailable")));
@property (readonly) TCCKtor_httpHttpStatusCode *SwitchProxy __attribute__((swift_name("SwitchProxy")));
@property (readonly) TCCKtor_httpHttpStatusCode *SwitchingProtocols __attribute__((swift_name("SwitchingProtocols")));
@property (readonly) TCCKtor_httpHttpStatusCode *TemporaryRedirect __attribute__((swift_name("TemporaryRedirect")));
@property (readonly) TCCKtor_httpHttpStatusCode *TooEarly __attribute__((swift_name("TooEarly")));
@property (readonly) TCCKtor_httpHttpStatusCode *TooManyRequests __attribute__((swift_name("TooManyRequests")));
@property (readonly) TCCKtor_httpHttpStatusCode *Unauthorized __attribute__((swift_name("Unauthorized")));
@property (readonly) TCCKtor_httpHttpStatusCode *UnprocessableEntity __attribute__((swift_name("UnprocessableEntity")));
@property (readonly) TCCKtor_httpHttpStatusCode *UnsupportedMediaType __attribute__((swift_name("UnsupportedMediaType")));
@property (readonly) TCCKtor_httpHttpStatusCode *UpgradeRequired __attribute__((swift_name("UpgradeRequired")));
@property (readonly) TCCKtor_httpHttpStatusCode *UseProxy __attribute__((swift_name("UseProxy")));
@property (readonly) TCCKtor_httpHttpStatusCode *VariantAlsoNegotiates __attribute__((swift_name("VariantAlsoNegotiates")));
@property (readonly) TCCKtor_httpHttpStatusCode *VersionNotSupported __attribute__((swift_name("VersionNotSupported")));

/**
 * All known status codes
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.Companion.allStatusCodes)
 */
@property (readonly) NSArray<TCCKtor_httpHttpStatusCode *> *allStatusCodes __attribute__((swift_name("allStatusCodes")));
@end


/**
 * Day of week
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsWeekDay")))
@interface TCCKtor_utilsWeekDay : TCCKotlinEnum<TCCKtor_utilsWeekDay *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Day of week
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKtor_utilsWeekDayCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCKtor_utilsWeekDay *monday __attribute__((swift_name("monday")));
@property (class, readonly) TCCKtor_utilsWeekDay *tuesday __attribute__((swift_name("tuesday")));
@property (class, readonly) TCCKtor_utilsWeekDay *wednesday __attribute__((swift_name("wednesday")));
@property (class, readonly) TCCKtor_utilsWeekDay *thursday __attribute__((swift_name("thursday")));
@property (class, readonly) TCCKtor_utilsWeekDay *friday __attribute__((swift_name("friday")));
@property (class, readonly) TCCKtor_utilsWeekDay *saturday __attribute__((swift_name("saturday")));
@property (class, readonly) TCCKtor_utilsWeekDay *sunday __attribute__((swift_name("sunday")));
+ (TCCKotlinArray<TCCKtor_utilsWeekDay *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKtor_utilsWeekDay *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Month
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsMonth")))
@interface TCCKtor_utilsMonth : TCCKotlinEnum<TCCKtor_utilsMonth *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Month
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TCCKtor_utilsMonthCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TCCKtor_utilsMonth *january __attribute__((swift_name("january")));
@property (class, readonly) TCCKtor_utilsMonth *february __attribute__((swift_name("february")));
@property (class, readonly) TCCKtor_utilsMonth *march __attribute__((swift_name("march")));
@property (class, readonly) TCCKtor_utilsMonth *april __attribute__((swift_name("april")));
@property (class, readonly) TCCKtor_utilsMonth *may __attribute__((swift_name("may")));
@property (class, readonly) TCCKtor_utilsMonth *june __attribute__((swift_name("june")));
@property (class, readonly) TCCKtor_utilsMonth *july __attribute__((swift_name("july")));
@property (class, readonly) TCCKtor_utilsMonth *august __attribute__((swift_name("august")));
@property (class, readonly) TCCKtor_utilsMonth *september __attribute__((swift_name("september")));
@property (class, readonly) TCCKtor_utilsMonth *october __attribute__((swift_name("october")));
@property (class, readonly) TCCKtor_utilsMonth *november __attribute__((swift_name("november")));
@property (class, readonly) TCCKtor_utilsMonth *december __attribute__((swift_name("december")));
+ (TCCKotlinArray<TCCKtor_utilsMonth *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKtor_utilsMonth *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsGMTDate.Companion")))
@interface TCCKtor_utilsGMTDateCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_utilsGMTDateCompanion *shared __attribute__((swift_name("shared")));
- (id<TCCKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * An instance of [GMTDate] corresponding to the epoch beginning
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate.Companion.START)
 */
@property (readonly) TCCKtor_utilsGMTDate *START __attribute__((swift_name("START")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpProtocolVersion.Companion")))
@interface TCCKtor_httpHttpProtocolVersionCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_httpHttpProtocolVersionCompanion *shared __attribute__((swift_name("shared")));

/**
 * Creates an instance of [HttpProtocolVersion] from the given parameters.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.fromValue)
 */
- (TCCKtor_httpHttpProtocolVersion *)fromValueName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("fromValue(name:major:minor:)")));

/**
 * Create an instance of [HttpProtocolVersion] from http string representation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.parse)
 */
- (TCCKtor_httpHttpProtocolVersion *)parseValue:(id)value __attribute__((swift_name("parse(value:)")));

/**
 * HTTP/1.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_1_0)
 */
@property (readonly) TCCKtor_httpHttpProtocolVersion *HTTP_1_0 __attribute__((swift_name("HTTP_1_0")));

/**
 * HTTP/1.1 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_1_1)
 */
@property (readonly) TCCKtor_httpHttpProtocolVersion *HTTP_1_1 __attribute__((swift_name("HTTP_1_1")));

/**
 * HTTP/2.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_2_0)
 */
@property (readonly) TCCKtor_httpHttpProtocolVersion *HTTP_2_0 __attribute__((swift_name("HTTP_2_0")));

/**
 * HTTP/3.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_3_0)
 */
@property (readonly) TCCKtor_httpHttpProtocolVersion *HTTP_3_0 __attribute__((swift_name("HTTP_3_0")));

/**
 * QUIC/1.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.QUIC)
 */
@property (readonly) TCCKtor_httpHttpProtocolVersion *QUIC __attribute__((swift_name("QUIC")));

/**
 * SPDY/3.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.SPDY_3)
 */
@property (readonly) TCCKtor_httpHttpProtocolVersion *SPDY_3 __attribute__((swift_name("SPDY_3")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLBuilder.Companion")))
@interface TCCKtor_httpURLBuilderCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_httpURLBuilderCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Ktor_httpParametersBuilder")))
@protocol TCCKtor_httpParametersBuilder <TCCKtor_utilsStringValuesBuilder>
@required
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKTypeProjection")))
@interface TCCKotlinKTypeProjection : TCCBase
- (instancetype)initWithVariance:(TCCKotlinKVariance * _Nullable)variance type:(id<TCCKotlinKType> _Nullable)type __attribute__((swift_name("init(variance:type:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TCCKotlinKTypeProjectionCompanion *companion __attribute__((swift_name("companion")));
- (TCCKotlinKTypeProjection *)doCopyVariance:(TCCKotlinKVariance * _Nullable)variance type:(id<TCCKotlinKType> _Nullable)type __attribute__((swift_name("doCopy(variance:type:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<TCCKotlinKType> _Nullable type __attribute__((swift_name("type")));
@property (readonly) TCCKotlinKVariance * _Nullable variance __attribute__((swift_name("variance")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrameType.Companion")))
@interface TCCKtor_websocketsFrameTypeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_websocketsFrameTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Finds [FrameType] instance by numeric [opcode].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType.Companion.get)
 *
 * @return a [FrameType] instance or `null` of the [opcode] value is not valid
 */
- (TCCKtor_websocketsFrameType * _Nullable)getOpcode:(int32_t)opcode __attribute__((swift_name("get(opcode:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithUtcOffset")))
@protocol TCCKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset <TCCKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)offsetFormat:(id<TCCKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("offset(format:)")));
- (void)offsetHoursPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetHours(padding:)")));
- (void)offsetMinutesOfHourPadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetMinutesOfHour(padding:)")));
- (void)offsetSecondsOfMinutePadding:(TCCKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetSecondsOfMinute(padding:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLProtocol.Companion")))
@interface TCCKtor_httpURLProtocolCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_httpURLProtocolCompanion *shared __attribute__((swift_name("shared")));

/**
 * Create an instance by [name] or use already existing instance
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.createOrDefault)
 */
- (TCCKtor_httpURLProtocol *)createOrDefaultName:(NSString *)name __attribute__((swift_name("createOrDefault(name:)")));

/**
 * HTTP with port 80
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.HTTP)
 */
@property (readonly) TCCKtor_httpURLProtocol *HTTP __attribute__((swift_name("HTTP")));

/**
 * secure HTTPS with port 443
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.HTTPS)
 */
@property (readonly) TCCKtor_httpURLProtocol *HTTPS __attribute__((swift_name("HTTPS")));

/**
 * Socks proxy url protocol.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.SOCKS)
 */
@property (readonly) TCCKtor_httpURLProtocol *SOCKS __attribute__((swift_name("SOCKS")));

/**
 * Web socket over HTTP on port 80
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.WS)
 */
@property (readonly) TCCKtor_httpURLProtocol *WS __attribute__((swift_name("WS")));

/**
 * Web socket over secure HTTPS on port 443
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.WSS)
 */
@property (readonly) TCCKtor_httpURLProtocol *WSS __attribute__((swift_name("WSS")));

/**
 * Protocols by names map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.byName)
 */
@property (readonly) NSDictionary<NSString *, TCCKtor_httpURLProtocol *> *byName __attribute__((swift_name("byName")));
@end


/**
 * Represents a single value parameter
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueParam)
 *
 * @property name of parameter
 * @property value of parameter
 * @property escapeValue specifies if the value should be escaped
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeaderValueParam")))
@interface TCCKtor_httpHeaderValueParam : TCCBase
- (instancetype)initWithName:(NSString *)name value:(NSString *)value __attribute__((swift_name("init(name:value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithName:(NSString *)name value:(NSString *)value escapeValue:(BOOL)escapeValue __attribute__((swift_name("init(name:value:escapeValue:)"))) __attribute__((objc_designated_initializer));
- (TCCKtor_httpHeaderValueParam *)doCopyName:(NSString *)name value:(NSString *)value escapeValue:(BOOL)escapeValue __attribute__((swift_name("doCopy(name:value:escapeValue:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a single value parameter
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueParam)
 *
 * @property name of parameter
 * @property value of parameter
 * @property escapeValue specifies if the value should be escaped
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL escapeValue __attribute__((swift_name("escapeValue")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeaderValueWithParameters.Companion")))
@interface TCCKtor_httpHeaderValueWithParametersCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_httpHeaderValueWithParametersCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parse header with parameter and pass it to [init] function to instantiate particular type
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters.Companion.parse)
 */
- (id _Nullable)parseValue:(NSString *)value init:(id _Nullable (^)(NSString *, NSArray<TCCKtor_httpHeaderValueParam *> *))init __attribute__((swift_name("parse(value:init:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpContentType.Companion")))
@interface TCCKtor_httpContentTypeCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_httpContentTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parses a string representing a `Content-Type` header into a [ContentType] instance.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.Companion.parse)
 */
- (TCCKtor_httpContentType *)parseValue:(NSString *)value __attribute__((swift_name("parse(value:)")));

/**
 * Represents a pattern `* / *` to match any content type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.Companion.Any)
 */
@property (readonly) TCCKtor_httpContentType *Any __attribute__((swift_name("Any")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsWeekDay.Companion")))
@interface TCCKtor_utilsWeekDayCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_utilsWeekDayCompanion *shared __attribute__((swift_name("shared")));

/**
 * Lookup an instance by [ordinal]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay.Companion.from)
 */
- (TCCKtor_utilsWeekDay *)fromOrdinal:(int32_t)ordinal __attribute__((swift_name("from(ordinal:)")));

/**
 * Lookup an instance by short week day name [WeekDay.value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay.Companion.from)
 */
- (TCCKtor_utilsWeekDay *)fromValue:(NSString *)value __attribute__((swift_name("from(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsMonth.Companion")))
@interface TCCKtor_utilsMonthCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKtor_utilsMonthCompanion *shared __attribute__((swift_name("shared")));

/**
 * Lookup an instance by [ordinal]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month.Companion.from)
 */
- (TCCKtor_utilsMonth *)fromOrdinal:(int32_t)ordinal __attribute__((swift_name("from(ordinal:)")));

/**
 * Lookup an instance by short month name [Month.value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month.Companion.from)
 */
- (TCCKtor_utilsMonth *)fromValue:(NSString *)value __attribute__((swift_name("from(value:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKVariance")))
@interface TCCKotlinKVariance : TCCKotlinEnum<TCCKotlinKVariance *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TCCKotlinKVariance *invariant __attribute__((swift_name("invariant")));
@property (class, readonly) TCCKotlinKVariance *in __attribute__((swift_name("in")));
@property (class, readonly) TCCKotlinKVariance *out __attribute__((swift_name("out")));
+ (TCCKotlinArray<TCCKotlinKVariance *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TCCKotlinKVariance *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKTypeProjection.Companion")))
@interface TCCKotlinKTypeProjectionCompanion : TCCBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TCCKotlinKTypeProjectionCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (TCCKotlinKTypeProjection *)contravariantType:(id<TCCKotlinKType>)type __attribute__((swift_name("contravariant(type:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (TCCKotlinKTypeProjection *)covariantType:(id<TCCKotlinKType>)type __attribute__((swift_name("covariant(type:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (TCCKotlinKTypeProjection *)invariantType:(id<TCCKotlinKType>)type __attribute__((swift_name("invariant(type:)")));
@property (readonly) TCCKotlinKTypeProjection *STAR __attribute__((swift_name("STAR")));
@end

#pragma pop_macro("_Nullable_result")
#pragma clang diagnostic pop
NS_ASSUME_NONNULL_END
