/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.shc.data;

import co.xendit.terminal.core.data.Action;
import co.xendit.terminal.core.data.GenericPaymentMethod;
import co.xendit.terminal.core.data.TerminalAction;
import co.xendit.terminal.core.util.JsonKt;
import co.xendit.terminal.shc.data.SHCPaymentMethod;
import co.xendit.terminal.shc.data.SHCTransactionType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\n\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\u001f\b\u0004\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001c\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001c\u0010\f\u001a\u00020\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u0082\u0001\b\u0019\u001a\u001b\u001c\u001d\u001e\u001f \u00a8\u0006!"}, d2={"Lco/xendit/terminal/shc/data/SHCAction;", "Lco/xendit/terminal/core/data/Action;", "data", "", "", "Lkotlinx/serialization/json/JsonElement;", "<init>", "(Ljava/util/Map;)V", "getTransactionAmount", "", "getTransactionOrderID", "getPaymentMethod", "getServicePaymentMethod", "getTerminalAction", "Lco/xendit/terminal/core/data/TerminalAction;", "Companion", "Payment", "Sale", "PreAuthorization", "SaleCompletion", "Installment", "Void", "Settlement", "SettlementEWallet", "CancelSession", "Lco/xendit/terminal/shc/data/SHCAction$CancelSession;", "Lco/xendit/terminal/shc/data/SHCAction$Installment;", "Lco/xendit/terminal/shc/data/SHCAction$Payment;", "Lco/xendit/terminal/shc/data/SHCAction$PreAuthorization;", "Lco/xendit/terminal/shc/data/SHCAction$SaleCompletion;", "Lco/xendit/terminal/shc/data/SHCAction$Settlement;", "Lco/xendit/terminal/shc/data/SHCAction$SettlementEWallet;", "Lco/xendit/terminal/shc/data/SHCAction$Void;", "my-shc"})
@SourceDebugExtension(value={"SMAP\nSHCAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SHCAction.kt\nco/xendit/terminal/shc/data/SHCAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n1#2:324\n295#3,2:325\n*S KotlinDebug\n*F\n+ 1 SHCAction.kt\nco/xendit/terminal/shc/data/SHCAction\n*L\n62#1:325,2\n*E\n"})
public abstract class SHCAction
extends Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String AMOUNT = "TransactionAmount";
    @NotNull
    public static final String TRANSACTION_TYPE = "TransactionType";
    @NotNull
    public static final String POS_REF_NO = "PosReference";
    @NotNull
    public static final String PRODUCT_CODE = "ProductCode";
    @NotNull
    public static final String TRANSACTION_INVOICE = "TransactionInvoice";
    @NotNull
    public static final String TRANSACTION_REF_ID = "TransactionRefId";
    @NotNull
    public static final String TRANSACTION_RRN = "TransactionRRN";
    @NotNull
    public static final String TRANSACTION_APPROVAL_CODE = "TransactionApprovalCode";

    private SHCAction(Map<String, ? extends JsonElement> data) {
        super(data);
    }

    public /* synthetic */ SHCAction(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map, null);
    }

    public double getTransactionAmount(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = data.get(AMOUNT);
        return object != null && (object = object.toString()) != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? (Double)object : 0.0;
    }

    @Nullable
    public String getTransactionOrderID(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        JsonElement jsonElement = data.get(POS_REF_NO);
        return jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getPaymentMethod(@NotNull Map<String, ? extends JsonElement> data) {
        GenericPaymentMethod genericPaymentMethod;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = data.get(PRODUCT_CODE);
        if (object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) != null) {
            Object object2 = object;
            boolean bl = false;
            SHCPaymentMethod sHCPaymentMethod = SHCPaymentMethod.Companion.toEnum((String)object2);
            object = sHCPaymentMethod;
            if (sHCPaymentMethod != null) {
                genericPaymentMethod = ((SHCPaymentMethod)((Object)object)).toPaymentMethod();
                return String.valueOf(genericPaymentMethod);
            }
        }
        genericPaymentMethod = null;
        return String.valueOf(genericPaymentMethod);
    }

    @NotNull
    public String getServicePaymentMethod(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = data.get(PRODUCT_CODE);
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public TerminalAction getTerminalAction(@NotNull Map<String, ? extends JsonElement> data) {
        SHCTransactionType sHCTransactionType;
        String string;
        JsonPrimitive jsonPrimitive;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        JsonElement jsonElement = data.get(TRANSACTION_TYPE);
        if (jsonElement != null && (jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null && (string = JsonElementKt.getContentOrNull((JsonPrimitive)jsonPrimitive)) != null) {
            Object v0;
            block3: {
                String it = string;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = (Iterable)SHCTransactionType.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SHCTransactionType type = (SHCTransactionType)((Object)element$iv);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)type.getValue(), (Object)it)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            sHCTransactionType = v0;
        } else {
            sHCTransactionType = null;
        }
        return sHCTransactionType;
    }

    public /* synthetic */ SHCAction(Map data, DefaultConstructorMarker $constructor_marker) {
        this(data);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$CancelSession;", "Lco/xendit/terminal/shc/data/SHCAction;", "<init>", "()V", "isNeedVerified", "", "my-shc"})
    public static final class CancelSession
    extends SHCAction {
        public CancelSession() {
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object)TuplesKt.to((Object)SHCAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)SHCTransactionType.TERMINATE_SESSION.getValue())))), null);
        }

        public boolean isNeedVerified() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$Companion;", "", "<init>", "()V", "AMOUNT", "", "TRANSACTION_TYPE", "POS_REF_NO", "PRODUCT_CODE", "TRANSACTION_INVOICE", "TRANSACTION_REF_ID", "TRANSACTION_RRN", "TRANSACTION_APPROVAL_CODE", "my-shc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$Installment;", "Lco/xendit/terminal/shc/data/SHCAction;", "orderID", "", "amount", "", "<init>", "(Ljava/lang/String;D)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()D", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "my-shc"})
    public static final class Installment
    extends SHCAction {
        @NotNull
        private final String orderID;
        private final double amount;

        public Installment(@NotNull String orderID, double amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)SHCAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive((Number)amount)), TuplesKt.to((Object)SHCAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)SHCTransactionType.EPP_SALE.getValue())), TuplesKt.to((Object)SHCAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID))};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.amount = amount;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        public final double getAmount() {
            return this.amount;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        public final double component2() {
            return this.amount;
        }

        @NotNull
        public final Installment copy(@NotNull String orderID, double amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            return new Installment(orderID, amount);
        }

        public static /* synthetic */ Installment copy$default(Installment installment, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = installment.orderID;
            }
            if ((n & 2) != 0) {
                d = installment.amount;
            }
            return installment.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "Installment(orderID=" + this.orderID + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result2 = this.orderID.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.amount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Installment)) {
                return false;
            }
            Installment installment = (Installment)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)installment.orderID)) {
                return false;
            }
            return Double.compare(this.amount, installment.amount) == 0;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B#\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\t\u0082\u0001\u0001\n\u00a8\u0006\u000b"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$Payment;", "Lco/xendit/terminal/shc/data/SHCAction;", "orderID", "", "amount", "", "productCode", "Lco/xendit/terminal/shc/data/SHCPaymentMethod;", "<init>", "(Ljava/lang/String;DLco/xendit/terminal/shc/data/SHCPaymentMethod;)V", "Lco/xendit/terminal/shc/data/SHCAction$Sale;", "my-shc"})
    public static abstract class Payment
    extends SHCAction {
        private Payment(String orderID, double amount, SHCPaymentMethod productCode) {
            String string;
            SHCPaymentMethod sHCPaymentMethod;
            Object[] objectArray = new Pair[4];
            objectArray[0] = TuplesKt.to((Object)SHCAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive((Number)amount));
            Enum enum_ = productCode;
            if (enum_ == null || (enum_ = ((SHCPaymentMethod)enum_).toTransactionSaleType$my_shc()) == null) {
                enum_ = SHCTransactionType.SALE;
            }
            objectArray[1] = TuplesKt.to((Object)SHCAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)((SHCTransactionType)enum_).getValue()));
            objectArray[2] = TuplesKt.to((Object)SHCAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID));
            objectArray[3] = productCode != null && (sHCPaymentMethod = productCode.filtered()) != null && (string = sHCPaymentMethod.getValue()) != null ? JsonKt.toJsonPrimitive((String)string, (String)SHCAction.PRODUCT_CODE) : null;
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
        }

        public /* synthetic */ Payment(String orderID, double amount, SHCPaymentMethod productCode, DefaultConstructorMarker $constructor_marker) {
            this(orderID, amount, productCode);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$PreAuthorization;", "Lco/xendit/terminal/shc/data/SHCAction;", "orderID", "", "amount", "", "<init>", "(Ljava/lang/String;D)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()D", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "my-shc"})
    public static final class PreAuthorization
    extends SHCAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String orderID;
        private final double amount;

        public PreAuthorization(@NotNull String orderID, double amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)SHCAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive((Number)amount)), TuplesKt.to((Object)SHCAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)SHCTransactionType.PRE_AUTHORIZATION.getValue())), TuplesKt.to((Object)SHCAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID))};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.amount = amount;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        public final double getAmount() {
            return this.amount;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        public final double component2() {
            return this.amount;
        }

        @NotNull
        public final PreAuthorization copy(@NotNull String orderID, double amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            return new PreAuthorization(orderID, amount);
        }

        public static /* synthetic */ PreAuthorization copy$default(PreAuthorization preAuthorization, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = preAuthorization.orderID;
            }
            if ((n & 2) != 0) {
                d = preAuthorization.amount;
            }
            return preAuthorization.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "PreAuthorization(orderID=" + this.orderID + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result2 = this.orderID.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.amount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreAuthorization)) {
                return false;
            }
            PreAuthorization preAuthorization = (PreAuthorization)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)preAuthorization.orderID)) {
                return false;
            }
            return Double.compare(this.amount, preAuthorization.amount) == 0;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$PreAuthorization$Companion;", "", "<init>", "()V", "fromPayment", "Lco/xendit/terminal/shc/data/SHCAction$PreAuthorization;", "payment", "Lco/xendit/terminal/shc/data/SHCAction$Payment;", "my-shc"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PreAuthorization fromPayment(@NotNull Payment payment) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)((Object)payment), (String)"payment");
                Object object2 = (JsonElement)payment.getData().get(SHCAction.POS_REF_NO);
                if (object2 == null || (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) == null || (object2 = object2.getContent()) == null) {
                    object2 = "";
                }
                return new PreAuthorization((String)object2, (object = (JsonElement)payment.getData().get(SHCAction.AMOUNT)) != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getDoubleOrNull((JsonPrimitive)object)) != null ? (Double)object : 0.0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$Sale;", "Lco/xendit/terminal/shc/data/SHCAction$Payment;", "orderID", "", "amount", "", "productCode", "Lco/xendit/terminal/shc/data/SHCPaymentMethod;", "<init>", "(Ljava/lang/String;DLco/xendit/terminal/shc/data/SHCPaymentMethod;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()D", "getProductCode", "()Lco/xendit/terminal/shc/data/SHCPaymentMethod;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "my-shc"})
    public static final class Sale
    extends Payment {
        @NotNull
        private final String orderID;
        private final double amount;
        @Nullable
        private final SHCPaymentMethod productCode;

        public Sale(@NotNull String orderID, double amount, @Nullable SHCPaymentMethod productCode) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            super(orderID, amount, productCode, null);
            this.orderID = orderID;
            this.amount = amount;
            this.productCode = productCode;
        }

        public /* synthetic */ Sale(String string, double d, SHCPaymentMethod sHCPaymentMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                sHCPaymentMethod = null;
            }
            this(string, d, sHCPaymentMethod);
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        public final double getAmount() {
            return this.amount;
        }

        @Nullable
        public final SHCPaymentMethod getProductCode() {
            return this.productCode;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        public final double component2() {
            return this.amount;
        }

        @Nullable
        public final SHCPaymentMethod component3() {
            return this.productCode;
        }

        @NotNull
        public final Sale copy(@NotNull String orderID, double amount, @Nullable SHCPaymentMethod productCode) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            return new Sale(orderID, amount, productCode);
        }

        public static /* synthetic */ Sale copy$default(Sale sale, String string, double d, SHCPaymentMethod sHCPaymentMethod, int n, Object object) {
            if ((n & 1) != 0) {
                string = sale.orderID;
            }
            if ((n & 2) != 0) {
                d = sale.amount;
            }
            if ((n & 4) != 0) {
                sHCPaymentMethod = sale.productCode;
            }
            return sale.copy(string, d, sHCPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "Sale(orderID=" + this.orderID + ", amount=" + this.amount + ", productCode=" + this.productCode + ")";
        }

        public int hashCode() {
            int result2 = this.orderID.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.amount);
            result2 = result2 * 31 + (this.productCode == null ? 0 : this.productCode.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Sale)) {
                return false;
            }
            Sale sale = (Sale)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)sale.orderID)) {
                return false;
            }
            if (Double.compare(this.amount, sale.amount) != 0) {
                return false;
            }
            return this.productCode == sale.productCode;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001f"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$SaleCompletion;", "Lco/xendit/terminal/shc/data/SHCAction;", "orderID", "", "amount", "", "invoiceNo", "rrn", "approvalCode", "<init>", "(Ljava/lang/String;DLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()D", "getInvoiceNo", "getRrn", "getApprovalCode", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "my-shc"})
    public static final class SaleCompletion
    extends SHCAction {
        @NotNull
        private final String orderID;
        private final double amount;
        @NotNull
        private final String invoiceNo;
        @NotNull
        private final String rrn;
        @NotNull
        private final String approvalCode;

        public SaleCompletion(@NotNull String orderID, double amount, @NotNull String invoiceNo, @NotNull String rrn, @NotNull String approvalCode) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter((Object)invoiceNo, (String)"invoiceNo");
            Intrinsics.checkNotNullParameter((Object)rrn, (String)"rrn");
            Intrinsics.checkNotNullParameter((Object)approvalCode, (String)"approvalCode");
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)SHCAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive((Number)amount)), TuplesKt.to((Object)SHCAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)SHCTransactionType.SALE_COMPLETE.getValue())), TuplesKt.to((Object)SHCAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID)), TuplesKt.to((Object)SHCAction.TRANSACTION_INVOICE, (Object)JsonElementKt.JsonPrimitive((String)invoiceNo)), TuplesKt.to((Object)SHCAction.TRANSACTION_RRN, (Object)JsonElementKt.JsonPrimitive((String)rrn)), TuplesKt.to((Object)SHCAction.TRANSACTION_APPROVAL_CODE, (Object)JsonElementKt.JsonPrimitive((String)approvalCode))};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.amount = amount;
            this.invoiceNo = invoiceNo;
            this.rrn = rrn;
            this.approvalCode = approvalCode;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        public final double getAmount() {
            return this.amount;
        }

        @NotNull
        public final String getInvoiceNo() {
            return this.invoiceNo;
        }

        @NotNull
        public final String getRrn() {
            return this.rrn;
        }

        @NotNull
        public final String getApprovalCode() {
            return this.approvalCode;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        public final double component2() {
            return this.amount;
        }

        @NotNull
        public final String component3() {
            return this.invoiceNo;
        }

        @NotNull
        public final String component4() {
            return this.rrn;
        }

        @NotNull
        public final String component5() {
            return this.approvalCode;
        }

        @NotNull
        public final SaleCompletion copy(@NotNull String orderID, double amount, @NotNull String invoiceNo, @NotNull String rrn, @NotNull String approvalCode) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter((Object)invoiceNo, (String)"invoiceNo");
            Intrinsics.checkNotNullParameter((Object)rrn, (String)"rrn");
            Intrinsics.checkNotNullParameter((Object)approvalCode, (String)"approvalCode");
            return new SaleCompletion(orderID, amount, invoiceNo, rrn, approvalCode);
        }

        public static /* synthetic */ SaleCompletion copy$default(SaleCompletion saleCompletion, String string, double d, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = saleCompletion.orderID;
            }
            if ((n & 2) != 0) {
                d = saleCompletion.amount;
            }
            if ((n & 4) != 0) {
                string2 = saleCompletion.invoiceNo;
            }
            if ((n & 8) != 0) {
                string3 = saleCompletion.rrn;
            }
            if ((n & 0x10) != 0) {
                string4 = saleCompletion.approvalCode;
            }
            return saleCompletion.copy(string, d, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "SaleCompletion(orderID=" + this.orderID + ", amount=" + this.amount + ", invoiceNo=" + this.invoiceNo + ", rrn=" + this.rrn + ", approvalCode=" + this.approvalCode + ")";
        }

        public int hashCode() {
            int result2 = this.orderID.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.amount);
            result2 = result2 * 31 + this.invoiceNo.hashCode();
            result2 = result2 * 31 + this.rrn.hashCode();
            result2 = result2 * 31 + this.approvalCode.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SaleCompletion)) {
                return false;
            }
            SaleCompletion saleCompletion = (SaleCompletion)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)saleCompletion.orderID)) {
                return false;
            }
            if (Double.compare(this.amount, saleCompletion.amount) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.invoiceNo, (Object)saleCompletion.invoiceNo)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rrn, (Object)saleCompletion.rrn)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.approvalCode, (Object)saleCompletion.approvalCode);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$Settlement;", "Lco/xendit/terminal/shc/data/SHCAction;", "<init>", "()V", "my-shc"})
    public static final class Settlement
    extends SHCAction {
        public Settlement() {
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object)TuplesKt.to((Object)SHCAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)SHCTransactionType.SETTLEMENT.getValue())))), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$SettlementEWallet;", "Lco/xendit/terminal/shc/data/SHCAction;", "<init>", "()V", "my-shc"})
    public static final class SettlementEWallet
    extends SHCAction {
        public SettlementEWallet() {
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object)TuplesKt.to((Object)SHCAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)SHCTransactionType.E_WALLET_SETTLEMENT.getValue())))), null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lco/xendit/terminal/shc/data/SHCAction$Void;", "Lco/xendit/terminal/shc/data/SHCAction;", "invoiceNo", "", "transactionType", "Lco/xendit/terminal/shc/data/SHCTransactionType;", "<init>", "(Ljava/lang/String;Lco/xendit/terminal/shc/data/SHCTransactionType;)V", "getInvoiceNo", "()Ljava/lang/String;", "getTransactionType", "()Lco/xendit/terminal/shc/data/SHCTransactionType;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "my-shc"})
    public static final class Void
    extends SHCAction {
        @NotNull
        private final String invoiceNo;
        @NotNull
        private final SHCTransactionType transactionType;

        public Void(@NotNull String invoiceNo, @NotNull SHCTransactionType transactionType) {
            Intrinsics.checkNotNullParameter((Object)invoiceNo, (String)"invoiceNo");
            Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
            Object[] objectArray = new Pair[2];
            objectArray[0] = TuplesKt.to((Object)SHCAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)transactionType.getValue()));
            SHCTransactionType[] sHCTransactionTypeArray = new SHCTransactionType[]{SHCTransactionType.E_WALLET_VOID, SHCTransactionType.E_WALLET_SALE};
            objectArray[1] = CollectionsKt.listOf((Object[])sHCTransactionTypeArray).contains((Object)transactionType) ? TuplesKt.to((Object)SHCAction.TRANSACTION_REF_ID, (Object)JsonElementKt.JsonPrimitive((String)invoiceNo)) : TuplesKt.to((Object)SHCAction.TRANSACTION_INVOICE, (Object)JsonElementKt.JsonPrimitive((String)invoiceNo));
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.invoiceNo = invoiceNo;
            this.transactionType = transactionType;
        }

        @NotNull
        public final String getInvoiceNo() {
            return this.invoiceNo;
        }

        @NotNull
        public final SHCTransactionType getTransactionType() {
            return this.transactionType;
        }

        @NotNull
        public final String component1() {
            return this.invoiceNo;
        }

        @NotNull
        public final SHCTransactionType component2() {
            return this.transactionType;
        }

        @NotNull
        public final Void copy(@NotNull String invoiceNo, @NotNull SHCTransactionType transactionType) {
            Intrinsics.checkNotNullParameter((Object)invoiceNo, (String)"invoiceNo");
            Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
            return new Void(invoiceNo, transactionType);
        }

        public static /* synthetic */ Void copy$default(Void void_, String string, SHCTransactionType sHCTransactionType, int n, Object object) {
            if ((n & 1) != 0) {
                string = void_.invoiceNo;
            }
            if ((n & 2) != 0) {
                sHCTransactionType = void_.transactionType;
            }
            return void_.copy(string, sHCTransactionType);
        }

        @NotNull
        public String toString() {
            return "Void(invoiceNo=" + this.invoiceNo + ", transactionType=" + this.transactionType + ")";
        }

        public int hashCode() {
            int result2 = this.invoiceNo.hashCode();
            result2 = result2 * 31 + this.transactionType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Void)) {
                return false;
            }
            Void void_ = (Void)((Object)other);
            if (!Intrinsics.areEqual((Object)this.invoiceNo, (Object)void_.invoiceNo)) {
                return false;
            }
            return this.transactionType == void_.transactionType;
        }
    }
}

