/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.shc.data;

import co.xendit.terminal.core.util.XLogger;
import co.xendit.terminal.shc.TerminalSHC;
import co.xendit.terminal.shc.data.SHCAction;
import co.xendit.terminal.shc.data.SHCPaymentMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB#\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0004\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lco/xendit/terminal/shc/data/PaymentIntentParametersBuilder;", "", "amount", "", "<init>", "(D)V", "orderID", "", "(Ljava/lang/String;D)V", "productCode", "Lco/xendit/terminal/shc/data/SHCPaymentMethod;", "(DLco/xendit/terminal/shc/data/SHCPaymentMethod;)V", "(Ljava/lang/String;DLco/xendit/terminal/shc/data/SHCPaymentMethod;)V", "build", "Lco/xendit/terminal/shc/data/SHCAction$Payment;", "my-shc"})
public final class PaymentIntentParametersBuilder {
    @NotNull
    private final String orderID;
    private final double amount;
    @Nullable
    private final SHCPaymentMethod productCode;

    public PaymentIntentParametersBuilder(double amount) {
        this.orderID = TerminalSHC.INSTANCE.createOrderID();
        this.amount = amount;
        this.productCode = null;
    }

    public PaymentIntentParametersBuilder(@NotNull String orderID, double amount) {
        Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
        this.orderID = orderID;
        this.amount = amount;
        this.productCode = null;
    }

    public PaymentIntentParametersBuilder(double amount, @Nullable SHCPaymentMethod productCode) {
        this.orderID = TerminalSHC.INSTANCE.createOrderID();
        this.amount = amount;
        this.productCode = productCode;
    }

    public PaymentIntentParametersBuilder(@NotNull String orderID, double amount, @Nullable SHCPaymentMethod productCode) {
        Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
        this.orderID = orderID;
        this.amount = amount;
        this.productCode = productCode;
    }

    @NotNull
    public final SHCAction.Payment build() {
        XLogger.Companion.info("Transaction ID: " + this.orderID);
        return new SHCAction.Sale(this.orderID, this.amount, this.productCode);
    }
}

