/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.core.storage;

import app.cash.sqldelight.Transacter;
import app.cash.sqldelight.TransactionWithoutReturn;
import co.xendit.terminal.core.Database;
import co.xendit.terminal.core.data.Service;
import co.xendit.terminal.core.data.Terminal;
import co.xendit.terminal.core.data.TransactionQueries;
import co.xendit.terminal.core.data.Transactions;
import co.xendit.terminal.core.di.BaseSecurity;
import co.xendit.terminal.core.storage.LocalStorage;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u001b\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JI\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u001d0\u001f\u00a2\u0006\u0002\b 2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u001d0\u001f\u00a2\u0006\u0002\b H\u0000\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b'J\u0019\u0010(\u001a\u0004\u0018\u00010%2\b\u0010)\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b*J\u000e\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020\u0010J(\u0010-\u001a\u00020.2\u0019\u0010/\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0004\u0012\u00020.0\u001f\u00a2\u0006\u0002\b H\u0000\u00a2\u0006\u0002\b1J'\u00102\u001a\u00020.2\u0006\u0010&\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00102\b\u0010)\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b4J\u007f\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00102\b\u00109\u001a\u0004\u0018\u00010\u00102\b\u0010:\u001a\u0004\u0018\u00010\u00102\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00102\u0006\u0010=\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\u0006\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010@2\b\u0010B\u001a\u0004\u0018\u00010\u00102\u0006\u0010C\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\bD\u0010EJA\u0010F\u001a\u0004\u0018\u00010G2\u0006\u00107\u001a\u00020\u00102\b\u0010H\u001a\u0004\u0018\u00010\u00102\b\u0010I\u001a\u0004\u0018\u00010\u00102\b\u0010A\u001a\u0004\u0018\u00010@2\b\u0010B\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0004\bJ\u0010KJ+\u0010L\u001a\u00020.2\u0006\u0010M\u001a\u0002062\b\u0010A\u001a\u0004\u0018\u00010@2\b\u0010B\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0004\bN\u0010OJ+\u0010P\u001a\u00020.2\u0006\u0010Q\u001a\u00020G2\b\u0010A\u001a\u0004\u0018\u00010@2\b\u0010B\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0004\bR\u0010SJ\u0017\u0010T\u001a\u0004\u0018\u00010G2\u0006\u00107\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\bUJ\u0013\u0010V\u001a\b\u0012\u0004\u0012\u0002060WH\u0000\u00a2\u0006\u0002\bXJ\u0011\u0010Y\u001a\u0004\u0018\u00010.H\u0000\u00a2\u0006\u0004\bZ\u0010[JG\u0010\\\u001a\n\u0012\u0004\u0012\u000206\u0018\u00010W2\b\u0010]\u001a\u0004\u0018\u00010@2\b\u0010^\u001a\u0004\u0018\u00010@2\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u00a2\u0006\u0004\ba\u0010bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u0082\u0001\u0001c\u00a8\u0006d"}, d2={"Lco/xendit/terminal/core/storage/BaseDatabaseHandler;", "", "database", "Lco/xendit/terminal/core/Database;", "security", "Lco/xendit/terminal/core/di/BaseSecurity;", "<init>", "(Lco/xendit/terminal/core/Database;Lco/xendit/terminal/core/di/BaseSecurity;)V", "getSecurity", "()Lco/xendit/terminal/core/di/BaseSecurity;", "storage", "Lco/xendit/terminal/core/storage/LocalStorage;", "getStorage$core", "()Lco/xendit/terminal/core/storage/LocalStorage;", "successStatuses", "", "", "getSuccessStatuses$core", "()Ljava/util/List;", "formatPattern", "getFormatPattern$core", "()Ljava/lang/String;", "queryMutex", "Lkotlinx/coroutines/sync/Mutex;", "getQueryMutex$core", "()Lkotlinx/coroutines/sync/Mutex;", "syncMutex", "getSyncMutex$core", "query", "T", "fromDatabase", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "fromStorage", "query$core", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getTerminal", "Lco/xendit/terminal/core/data/Terminal;", "tid", "getTerminal$core", "getTerminalByIpAddress", "ipAddress", "getTerminalByIpAddress$core", "isTidMatch", "", "terminalQueriesTransaction", "", "body", "Lapp/cash/sqldelight/TransactionWithoutReturn;", "terminalQueriesTransaction$core", "insertTerminal", "actualTid", "insertTerminal$core", "insertTransactions", "Lco/xendit/terminal/core/data/Transactions;", "id", "transactionId", "orderId", "paymentRequestId", "action", "requestPayload", "responsePayload", "status", "timestamp", "", "syncFlag", "syncAt", "provider", "insertTransactions$core", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/lang/Long;Ljava/lang/String;Ljava/lang/String;)Lco/xendit/terminal/core/data/Transactions;", "insertService", "Lco/xendit/terminal/core/data/Service;", "servicePayload", "serviceType", "insertService$core", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;)Lco/xendit/terminal/core/data/Service;", "replaceTransactions", "transaction", "replaceTransactions$core", "(Lco/xendit/terminal/core/data/Transactions;Ljava/lang/Long;Ljava/lang/String;)V", "replaceService", "service", "replaceService$core", "(Lco/xendit/terminal/core/data/Service;Ljava/lang/Long;Ljava/lang/String;)V", "getService", "getService$core", "getUnsyncTransactions", "", "getUnsyncTransactions$core", "deleteSyncedTransactions", "deleteSyncedTransactions$core", "()Lkotlin/Unit;", "select", "from", "end", "statuses", "actions", "select$core", "(Ljava/lang/Long;Ljava/lang/Long;Ljava/util/List;Ljava/util/List;)Ljava/util/Collection;", "Lco/xendit/terminal/core/storage/DatabaseHandler;", "core"})
@SourceDebugExtension(value={"SMAP\nBaseDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseDatabase.kt\nco/xendit/terminal/core/storage/BaseDatabaseHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n295#2,2:229\n*S KotlinDebug\n*F\n+ 1 BaseDatabase.kt\nco/xendit/terminal/core/storage/BaseDatabaseHandler\n*L\n51#1:229,2\n*E\n"})
public abstract class BaseDatabaseHandler {
    @Nullable
    private final Database database;
    @NotNull
    private final BaseSecurity security;
    @Nullable
    private final LocalStorage storage;
    @NotNull
    private final List<String> successStatuses;
    @NotNull
    private final String formatPattern;
    @NotNull
    private final Mutex queryMutex;
    @NotNull
    private final Mutex syncMutex;

    private BaseDatabaseHandler(Database database, BaseSecurity security) {
        this.database = database;
        this.security = security;
        this.storage = this.database == null ? new LocalStorage(null, null, null, 7, null) : null;
        Object[] objectArray = new String[]{"SUCCESS", "REFUND", "PAID"};
        this.successStatuses = CollectionsKt.listOf((Object[])objectArray);
        this.formatPattern = "yyyy-MM-dd'T'HH:mm:ss[.SSS]";
        this.queryMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.syncMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @NotNull
    public BaseSecurity getSecurity() {
        return this.security;
    }

    @Nullable
    public final LocalStorage getStorage$core() {
        return this.storage;
    }

    @NotNull
    public final List<String> getSuccessStatuses$core() {
        return this.successStatuses;
    }

    @NotNull
    public final String getFormatPattern$core() {
        return this.formatPattern;
    }

    @NotNull
    public final Mutex getQueryMutex$core() {
        return this.queryMutex;
    }

    @NotNull
    public final Mutex getSyncMutex$core() {
        return this.syncMutex;
    }

    @Nullable
    public final <T> T query$core(@NotNull Function1<? super Database, ? extends T> fromDatabase, @NotNull Function1<? super LocalStorage, ? extends T> fromStorage) {
        Intrinsics.checkNotNullParameter(fromDatabase, (String)"fromDatabase");
        Intrinsics.checkNotNullParameter(fromStorage, (String)"fromStorage");
        return (T)(this.database != null ? fromDatabase.invoke((Object)this.database) : (this.storage != null ? fromStorage.invoke((Object)this.storage) : null));
    }

    @Nullable
    public final Terminal getTerminal$core(@NotNull String tid) {
        Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
        return (Terminal)this.query$core(arg_0 -> BaseDatabaseHandler.getTerminal$lambda$0(tid, arg_0), arg_0 -> BaseDatabaseHandler.getTerminal$lambda$1(tid, arg_0));
    }

    @Nullable
    public final Terminal getTerminalByIpAddress$core(@Nullable String ipAddress) {
        return (Terminal)this.query$core(arg_0 -> BaseDatabaseHandler.getTerminalByIpAddress$lambda$0(ipAddress, arg_0), arg_0 -> BaseDatabaseHandler.getTerminalByIpAddress$lambda$1(ipAddress, arg_0));
    }

    public final boolean isTidMatch(@NotNull String tid) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
        Terminal terminal = this.getTerminal$core(tid);
        if (terminal != null) {
            Terminal $this$isTidMatch_u24lambda_u240 = terminal;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)$this$isTidMatch_u24lambda_u240.getTid(), (Object)$this$isTidMatch_u24lambda_u240.getActualTid());
        } else {
            bl = true;
        }
        return bl;
    }

    public final void terminalQueriesTransaction$core(@NotNull Function1<? super TransactionWithoutReturn, Unit> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        this.query$core(arg_0 -> BaseDatabaseHandler.terminalQueriesTransaction$lambda$0(body, arg_0), arg_0 -> BaseDatabaseHandler.terminalQueriesTransaction$lambda$1(body, arg_0));
    }

    public final void insertTerminal$core(@NotNull String tid, @NotNull String actualTid, @Nullable String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
        Intrinsics.checkNotNullParameter((Object)actualTid, (String)"actualTid");
        this.query$core(arg_0 -> BaseDatabaseHandler.insertTerminal$lambda$0(tid, actualTid, ipAddress, arg_0), arg_0 -> BaseDatabaseHandler.insertTerminal$lambda$1(tid, actualTid, ipAddress, arg_0));
    }

    @NotNull
    public final Transactions insertTransactions$core(@NotNull String id, @NotNull String transactionId, @Nullable String orderId, @Nullable String paymentRequestId, @NotNull String action, @NotNull String requestPayload, @NotNull String responsePayload, @NotNull String tid, @NotNull String status, long timestamp, @Nullable Long syncFlag, @Nullable String syncAt, @NotNull String provider) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)transactionId, (String)"transactionId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)requestPayload, (String)"requestPayload");
        Intrinsics.checkNotNullParameter((Object)responsePayload, (String)"responsePayload");
        Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Transactions transaction = new Transactions(id, transactionId, orderId, paymentRequestId, provider, action, requestPayload, responsePayload, tid, status, timestamp, syncFlag, syncAt);
        this.query$core(arg_0 -> BaseDatabaseHandler.insertTransactions$lambda$0(transaction, arg_0), arg_0 -> BaseDatabaseHandler.insertTransactions$lambda$1(id, transaction, arg_0));
        return transaction;
    }

    @Nullable
    public final Service insertService$core(@NotNull String id, @Nullable String servicePayload, @Nullable String serviceType, @Nullable Long syncFlag, @Nullable String syncAt) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (serviceType == null) {
            return null;
        }
        Service service = new Service(id, servicePayload, serviceType, syncFlag, syncAt);
        this.query$core(arg_0 -> BaseDatabaseHandler.insertService$lambda$0(service, arg_0), arg_0 -> BaseDatabaseHandler.insertService$lambda$1(id, service, arg_0));
        return service;
    }

    public final void replaceTransactions$core(@NotNull Transactions transaction, @Nullable Long syncFlag, @Nullable String syncAt) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Transactions newTransaction = Transactions.copy$default(transaction, null, null, null, null, null, null, null, null, null, null, null, syncFlag, syncAt, 2047, null);
        this.query$core(arg_0 -> BaseDatabaseHandler.replaceTransactions$lambda$0(newTransaction, arg_0), arg_0 -> BaseDatabaseHandler.replaceTransactions$lambda$1(newTransaction, arg_0));
    }

    public final void replaceService$core(@NotNull Service service, @Nullable Long syncFlag, @Nullable String syncAt) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Service newService = Service.copy$default(service, null, null, null, syncFlag, syncAt, 7, null);
        this.query$core(arg_0 -> BaseDatabaseHandler.replaceService$lambda$0(service, arg_0), arg_0 -> BaseDatabaseHandler.replaceService$lambda$1(newService, arg_0));
    }

    @Nullable
    public final Service getService$core(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return (Service)this.query$core(arg_0 -> BaseDatabaseHandler.getService$lambda$0(id, arg_0), arg_0 -> BaseDatabaseHandler.getService$lambda$1(id, arg_0));
    }

    @NotNull
    public final Collection<Transactions> getUnsyncTransactions$core() {
        Collection collection = (Collection)this.query$core(BaseDatabaseHandler::getUnsyncTransactions$lambda$0, BaseDatabaseHandler::getUnsyncTransactions$lambda$1);
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @Nullable
    public final Unit deleteSyncedTransactions$core() {
        return (Unit)this.query$core(BaseDatabaseHandler::deleteSyncedTransactions$lambda$0, BaseDatabaseHandler::deleteSyncedTransactions$lambda$1);
    }

    @Nullable
    public final Collection<Transactions> select$core(@Nullable Long from, @Nullable Long end, @NotNull List<String> statuses, @NotNull List<String> actions) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        return (Collection)this.query$core(arg_0 -> BaseDatabaseHandler.select$lambda$0(from, end, statuses, actions, arg_0), BaseDatabaseHandler::select$lambda$1);
    }

    private static final Terminal getTerminal$lambda$0(String $tid, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        return (Terminal)$this$query.getTerminalQueries().getAll($tid).executeAsOneOrNull();
    }

    private static final Terminal getTerminal$lambda$1(String $tid, LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        return $this$query.getTerminals().get($tid);
    }

    private static final Terminal getTerminalByIpAddress$lambda$0(String $ipAddress, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        return (Terminal)$this$query.getTerminalQueries().getAllByIpAddress($ipAddress).executeAsOneOrNull();
    }

    private static final Terminal getTerminalByIpAddress$lambda$1(String $ipAddress, LocalStorage $this$query) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
            Iterable $this$firstOrNull$iv = $this$query.getTerminals().values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Terminal it = (Terminal)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getIpAddress(), (Object)$ipAddress)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final Unit terminalQueriesTransaction$lambda$0(Function1 $body, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        Transacter.DefaultImpls.transaction$default((Transacter)((Transacter)$this$query.getTerminalQueries()), (boolean)false, (Function1)$body, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit terminalQueriesTransaction$lambda$1(Function1 $body, LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $body.invoke(null);
        return Unit.INSTANCE;
    }

    private static final Unit insertTerminal$lambda$0(String $tid, String $actualTid, String $ipAddress, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getTerminalQueries().insert($tid, $actualTid, $ipAddress);
        return Unit.INSTANCE;
    }

    private static final Unit insertTerminal$lambda$1(String $tid, String $actualTid, String $ipAddress, LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getTerminals().put($tid, new Terminal($tid, $actualTid, $ipAddress));
        return Unit.INSTANCE;
    }

    private static final Unit insertTransactions$lambda$0(Transactions $transaction, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getTransactionQueries().insert($transaction);
        return Unit.INSTANCE;
    }

    private static final Unit insertTransactions$lambda$1(String $id, Transactions $transaction, LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getTransactions().put($id, $transaction);
        return Unit.INSTANCE;
    }

    private static final Unit insertService$lambda$0(Service $service, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getServiceQueries().insert($service);
        return Unit.INSTANCE;
    }

    private static final Unit insertService$lambda$1(String $id, Service $service, LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getServices().put($id, $service);
        return Unit.INSTANCE;
    }

    private static final Unit replaceTransactions$lambda$0(Transactions $newTransaction, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getTransactionQueries().replace($newTransaction);
        return Unit.INSTANCE;
    }

    private static final Unit replaceTransactions$lambda$1(Transactions $newTransaction, LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getTransactions().put($newTransaction.getId(), $newTransaction);
        return Unit.INSTANCE;
    }

    private static final Unit replaceService$lambda$0(Service $service, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getServiceQueries().replace($service);
        return Unit.INSTANCE;
    }

    private static final Unit replaceService$lambda$1(Service $newService, LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getServices().put($newService.getTransaction_id(), $newService);
        return Unit.INSTANCE;
    }

    private static final Service getService$lambda$0(String $id, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        return (Service)$this$query.getServiceQueries().selectById($id).executeAsOneOrNull();
    }

    private static final Service getService$lambda$1(String $id, LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        return $this$query.getServices().get($id);
    }

    private static final Collection getUnsyncTransactions$lambda$0(Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        return $this$query.getTransactionQueries().selectUnsync().executeAsList();
    }

    private static final Collection getUnsyncTransactions$lambda$1(LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        return $this$query.getUnsyncTransactions();
    }

    private static final Unit deleteSyncedTransactions$lambda$0(Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.getTransactionQueries().deleteSyncWithTime(Clock.System.INSTANCE.now().plus-LRDsOJo(DurationKt.toDuration((int)-1, (DurationUnit)DurationUnit.DAYS)).toEpochMilliseconds());
        $this$query.getServiceQueries().deleteSync();
        return Unit.INSTANCE;
    }

    private static final Unit deleteSyncedTransactions$lambda$1(LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        $this$query.deleteSyncedTransactions();
        return Unit.INSTANCE;
    }

    private static final Collection select$lambda$0(Long $from, Long $end, List $statuses, List $actions, Database $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        TransactionQueries transactionQueries = $this$query.getTransactionQueries();
        Long l = $from;
        long l2 = l != null ? l : 0L;
        Long l3 = $end;
        long l4 = l3 != null ? l3 : Long.MAX_VALUE;
        return transactionQueries.selectAllWithStatusAndActionAndRange($statuses, $actions, l2, l4).executeAsList();
    }

    private static final Collection select$lambda$1(LocalStorage $this$query) {
        Intrinsics.checkNotNullParameter((Object)$this$query, (String)"$this$query");
        return $this$query.getTransactions().values();
    }

    public /* synthetic */ BaseDatabaseHandler(Database database, BaseSecurity security, DefaultConstructorMarker $constructor_marker) {
        this(database, security);
    }
}

