/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.core.di;

import co.xendit.terminal.core.data.ErrorCode;
import co.xendit.terminal.core.data.Result;
import co.xendit.terminal.core.di.BaseSecurity;
import co.xendit.terminal.core.util.XLogger;
import java.nio.charset.Charset;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lco/xendit/terminal/core/di/Security;", "Lco/xendit/terminal/core/di/BaseSecurity;", "apiKey", "", "<init>", "(Ljava/lang/String;)V", "encrypt", "Lco/xendit/terminal/core/data/Result;", "key", "", "strToEncrypt", "decrypt", "core"})
public final class Security
extends BaseSecurity {
    public Security(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        super(apiKey);
    }

    @Override
    @NotNull
    public Result<String> encrypt(@NotNull byte[] key, @NotNull String strToEncrypt) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)strToEncrypt, (String)"strToEncrypt");
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            Base64 base64 = (Base64)Base64.Default;
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = strToEncrypt.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = cipher.doFinal(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"doFinal(...)");
            return new Result.Success<String>(Base64.encode$default((Base64)base64, (byte[])byArray2, (int)0, (int)0, (int)6, null));
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                XLogger.Companion.debug(it);
            }
            XLogger.Companion.error(e);
            return ErrorCode.toResult$default(ErrorCode.ENCRYPTION_FAILED, "Error encrypting data", null, 2, null);
        }
    }

    @Override
    @NotNull
    public Result<String> decrypt(@NotNull byte[] key, @NotNull String strToEncrypt) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)strToEncrypt, (String)"strToEncrypt");
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, secretKey);
            byte[] decodedBytes = Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)strToEncrypt, (int)0, (int)0, (int)6, null);
            byte[] decryptedBytes = cipher.doFinal(decodedBytes);
            Intrinsics.checkNotNull((Object)decryptedBytes);
            byte[] byArray = decryptedBytes;
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            Charset charset2 = charset;
            return new Result.Success<String>(new String(byArray, charset2));
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                XLogger.Companion.debug(it);
            }
            XLogger.Companion.error(e);
            return ErrorCode.toResult$default(ErrorCode.ENCRYPTION_FAILED, "Error encrypting data", null, 2, null);
        }
    }
}

