/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.core.di;

import co.xendit.terminal.core.util.XLogger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"getDeviceIPAddress", "", "getIpv4HostAddress", "core"})
@SourceDebugExtension(value={"SMAP\nIPAddresses.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IPAddresses.desktop.kt\nco/xendit/terminal/core/di/IPAddresses_desktopKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1761#2,3:77\n*S KotlinDebug\n*F\n+ 1 IPAddresses.desktop.kt\nco/xendit/terminal/core/di/IPAddresses_desktopKt\n*L\n45#1:77,3\n*E\n"})
public final class IPAddresses_desktopKt {
    @Nullable
    public static final String getDeviceIPAddress() {
        return IPAddresses_desktopKt.getIpv4HostAddress();
    }

    @NotNull
    public static final String getIpv4HostAddress() {
        Object[] objectArray = new String[]{"bridge", "docker", "vbox", "vmnet", "utun", "awdl", "lo", "ap"};
        List excludedInterfaceNamePatterns = CollectionsKt.listOf((Object[])objectArray);
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces(...)");
            ArrayList<NetworkInterface> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            List networkInterfaces = arrayList;
            List sortedInterfaces = CollectionsKt.sortedWith((Iterable)networkInterfaces, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    NetworkInterface it = (NetworkInterface)a;
                    boolean bl = false;
                    String string = it.getDisplayName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    String name = string2;
                    it = (NetworkInterface)b;
                    Comparable comparable = StringsKt.startsWith$default((String)name, (String)"en", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(0) : (StringsKt.startsWith$default((String)name, (String)"eth", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(1) : (StringsKt.startsWith$default((String)name, (String)"wl", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(2) : (Comparable)Integer.valueOf(100)));
                    bl = false;
                    String string3 = it.getDisplayName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDisplayName(...)");
                    String string4 = string3.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    name = string4;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(StringsKt.startsWith$default((String)name, (String)"en", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(0) : (StringsKt.startsWith$default((String)name, (String)"eth", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(1) : (StringsKt.startsWith$default((String)name, (String)"wl", (boolean)false, (int)2, null) ? (Comparable)Integer.valueOf(2) : (Comparable)Integer.valueOf(100)))));
                }
            });
            for (NetworkInterface networkInterface : sortedInterfaces) {
                boolean isExcludedByName;
                block7: {
                    String string = networkInterface.getDisplayName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    Iterable $this$any$iv = excludedInterfaceNamePatterns;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String interfaceName;
                            String pattern = (String)element$iv;
                            boolean bl = false;
                            if (!StringsKt.contains$default((CharSequence)interfaceName, (CharSequence)pattern, (boolean)false, (int)2, null)) continue;
                            v3 = true;
                            break block7;
                        }
                        v3 = isExcludedByName = false;
                    }
                }
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual() || networkInterface.isPointToPoint() || isExcludedByName) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                Intrinsics.checkNotNull(inetAddresses);
                Iterator iterator = CollectionsKt.iterator(inetAddresses);
                while (iterator.hasNext()) {
                    InetAddress inetAddress = (InetAddress)iterator.next();
                    if (!(inetAddress instanceof Inet4Address) || ((Inet4Address)inetAddress).isLoopbackAddress()) continue;
                    String hostAddress = ((Inet4Address)inetAddress).getHostAddress();
                    XLogger.Companion.debug("[IPADDRESS] Found network IP: " + hostAddress + " on interface: " + networkInterface.getDisplayName());
                    Intrinsics.checkNotNull((Object)hostAddress);
                    return hostAddress;
                }
            }
        }
        catch (Exception e) {
            XLogger.Companion.error(e);
        }
        return "";
    }
}

