/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.core.di;

import co.xendit.terminal.core.data.Result;
import co.xendit.terminal.core.util.XLogger;
import io.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.kotlincrypto.core.digest.Digest;
import org.kotlincrypto.hash.sha1.SHA1;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003H&J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u0003J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lco/xendit/terminal/core/di/BaseSecurity;", "", "apiKey", "", "<init>", "(Ljava/lang/String;)V", "key", "", "encrypt", "Lco/xendit/terminal/core/data/Result;", "strToEncrypt", "setKey", "", "decrypt", "core"})
public abstract class BaseSecurity {
    @NotNull
    private final String apiKey;
    @NotNull
    private byte[] key;

    public BaseSecurity(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
        this.key = new byte[0];
        this.setKey();
    }

    @NotNull
    public final Result<String> encrypt(@NotNull String strToEncrypt) {
        Intrinsics.checkNotNullParameter((Object)strToEncrypt, (String)"strToEncrypt");
        return this.encrypt(this.key, strToEncrypt);
    }

    private final void setKey() {
        Digest sha = null;
        try {
            this.key = StringsKt.toByteArray((String)this.apiKey, (Charset)Charsets.UTF_8);
            sha = (Digest)new SHA1();
            this.key = ((SHA1)sha).digest(this.key);
            byte[] byArray = Arrays.copyOf(this.key, 16);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            this.key = byArray;
        }
        catch (Exception e) {
            XLogger.Companion.error(e);
        }
    }

    @NotNull
    public abstract Result<String> encrypt(@NotNull byte[] var1, @NotNull String var2);

    @NotNull
    public final Result<String> decrypt(@NotNull String strToEncrypt) {
        Intrinsics.checkNotNullParameter((Object)strToEncrypt, (String)"strToEncrypt");
        return this.decrypt(this.key, strToEncrypt);
    }

    @NotNull
    public abstract Result<String> decrypt(@NotNull byte[] var1, @NotNull String var2);
}

