/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.core.core;

import app.cash.sqldelight.TransacterImpl;
import app.cash.sqldelight.db.AfterVersion;
import app.cash.sqldelight.db.QueryResult;
import app.cash.sqldelight.db.SqlDriver;
import app.cash.sqldelight.db.SqlSchema;
import co.xendit.terminal.core.Database;
import co.xendit.terminal.core.data.ServiceQueries;
import co.xendit.terminal.core.data.TerminalQueries;
import co.xendit.terminal.core.data.TransactionQueries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lco/xendit/terminal/core/core/DatabaseImpl;", "Lapp/cash/sqldelight/TransacterImpl;", "Lco/xendit/terminal/core/Database;", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "<init>", "(Lapp/cash/sqldelight/db/SqlDriver;)V", "serviceQueries", "Lco/xendit/terminal/core/data/ServiceQueries;", "getServiceQueries", "()Lco/xendit/terminal/core/data/ServiceQueries;", "terminalQueries", "Lco/xendit/terminal/core/data/TerminalQueries;", "getTerminalQueries", "()Lco/xendit/terminal/core/data/TerminalQueries;", "transactionQueries", "Lco/xendit/terminal/core/data/TransactionQueries;", "getTransactionQueries", "()Lco/xendit/terminal/core/data/TransactionQueries;", "Schema", "core"})
final class DatabaseImpl
extends TransacterImpl
implements Database {
    @NotNull
    private final ServiceQueries serviceQueries;
    @NotNull
    private final TerminalQueries terminalQueries;
    @NotNull
    private final TransactionQueries transactionQueries;

    public DatabaseImpl(@NotNull SqlDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        super(driver);
        this.serviceQueries = new ServiceQueries(driver);
        this.terminalQueries = new TerminalQueries(driver);
        this.transactionQueries = new TransactionQueries(driver);
    }

    @Override
    @NotNull
    public ServiceQueries getServiceQueries() {
        return this.serviceQueries;
    }

    @Override
    @NotNull
    public TerminalQueries getTerminalQueries() {
        return this.terminalQueries;
    }

    @Override
    @NotNull
    public TransactionQueries getTransactionQueries() {
        return this.transactionQueries;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013JA\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lco/xendit/terminal/core/core/DatabaseImpl$Schema;", "Lapp/cash/sqldelight/db/SqlSchema;", "Lapp/cash/sqldelight/db/QueryResult$Value;", "", "<init>", "()V", "version", "", "getVersion", "()J", "create", "driver", "Lapp/cash/sqldelight/db/SqlDriver;", "create-0iQ1-z0", "(Lapp/cash/sqldelight/db/SqlDriver;)Ljava/lang/Object;", "migrateInternal", "oldVersion", "newVersion", "migrateInternal-ElmaSbI", "(Lapp/cash/sqldelight/db/SqlDriver;JJ)Ljava/lang/Object;", "migrate", "callbacks", "", "Lapp/cash/sqldelight/db/AfterVersion;", "migrate-zeHU3Mk", "(Lapp/cash/sqldelight/db/SqlDriver;JJ[Lapp/cash/sqldelight/db/AfterVersion;)Ljava/lang/Object;", "core"})
    @SourceDebugExtension(value={"SMAP\nDatabaseImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseImpl.kt\nco/xendit/terminal/core/core/DatabaseImpl$Schema\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n3919#2:120\n4434#2,2:121\n1056#3:123\n1869#3,2:124\n*S KotlinDebug\n*F\n+ 1 DatabaseImpl.kt\nco/xendit/terminal/core/core/DatabaseImpl$Schema\n*L\n104#1:120\n104#1:121,2\n105#1:123\n106#1:124,2\n*E\n"})
    public static final class Schema
    implements SqlSchema<QueryResult.Value<Unit>> {
        @NotNull
        public static final Schema INSTANCE = new Schema();

        private Schema() {
        }

        public long getVersion() {
            return 5L;
        }

        @NotNull
        public Object create-0iQ1-z0(@NotNull SqlDriver driver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)"CREATE TABLE Service(\n  transaction_id TEXT PRIMARY KEY NOT NULL,\n  service_payload TEXT,\n  service_type TEXT,\n  sync_flag INTEGER DEFAULT 0,\n  sync_at TEXT DEFAULT NULL\n)", (int)0, null, (int)8, null);
            SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)"CREATE TABLE Terminal (\n  tid TEXT PRIMARY KEY NOT NULL,\n  actualTid TEXT NOT NULL,\n  ipAddress TEXT\n)", (int)0, null, (int)8, null);
            SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)"CREATE TABLE Transactions (\n  id TEXT PRIMARY KEY NOT NULL,\n  transactionId TEXT NOT NULL,\n  orderId TEXT,\n  paymentRequestId TEXT,\n  provider TEXT DEFAULT \"BRI\",\n  action TEXT NOT NULL,\n  request_payload TEXT NOT NULL,\n  response_payload TEXT NOT NULL,\n  tid TEXT NOT NULL,\n  status TEXT NOT NULL ,\n  timestamp INTEGER DEFAULT 0,\n  sync_flag INTEGER DEFAULT 0,\n  sync_at TEXT DEFAULT NULL\n)", (int)0, null, (int)8, null);
            return QueryResult.Companion.getUnit-mlR-ZEE();
        }

        private final Object migrateInternal-ElmaSbI(SqlDriver driver, long oldVersion, long newVersion) {
            if (oldVersion <= 2L && newVersion > 2L) {
                SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)"ALTER TABLE Transactions ADD COLUMN orderId TEXT", (int)0, null, (int)8, null);
            }
            if (oldVersion <= 3L && newVersion > 3L) {
                SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)"ALTER TABLE Transactions ADD COLUMN paymentRequestId TEXT", (int)0, null, (int)8, null);
                SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)"ALTER TABLE Transactions ADD COLUMN provider TEXT DEFAULT \"BRI\"", (int)0, null, (int)8, null);
                SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)"UPDATE Transactions SET sync_flag = 2 WHERE sync_flag = 1", (int)0, null, (int)8, null);
                SqlDriver.DefaultImpls.execute$default((SqlDriver)driver, null, (String)"CREATE TABLE Service(\n  transaction_id TEXT PRIMARY KEY NOT NULL,\n  service_payload TEXT,\n  service_type TEXT\n)", (int)0, null, (int)8, null);
            }
            if (oldVersion > 4L || newVersion > 4L) {
                // empty if block
            }
            return QueryResult.Companion.getUnit-mlR-ZEE();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object migrate-zeHU3Mk(@NotNull SqlDriver driver, long oldVersion, long newVersion, AfterVersion ... callbacks) {
            void $this$forEach$iv;
            Iterable $this$sortedBy$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)callbacks, (String)"callbacks");
            long lastVersion = 0L;
            lastVersion = oldVersion;
            Object $this$filter$iv = callbacks;
            boolean $i$f$filter = false;
            AfterVersion[] afterVersionArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                long l = it.getAfterVersion();
                boolean bl2 = oldVersion <= l ? l < newVersion : false;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AfterVersion it = (AfterVersion)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getAfterVersion());
                    it = (AfterVersion)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getAfterVersion()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AfterVersion callback = (AfterVersion)element$iv;
                boolean bl = false;
                INSTANCE.migrateInternal-ElmaSbI(driver, lastVersion, callback.getAfterVersion() + 1L);
                callback.getBlock().invoke((Object)driver);
                lastVersion = callback.getAfterVersion() + 1L;
            }
            if (lastVersion < newVersion) {
                this.migrateInternal-ElmaSbI(driver, lastVersion, newVersion);
            }
            return QueryResult.Companion.getUnit-mlR-ZEE();
        }
    }
}

