/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.bri.data;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalDateTimeKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.UnicodeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"formatDateTime", "", "dateTime", "Lkotlinx/datetime/LocalDateTime;", "formatDateTimeWithTimeZone", "parseDateTime", "timeZone", "Lkotlinx/datetime/TimeZone;", "toGmtString", "instant", "Lkotlin/time/Instant;", "toOffset", "id-bri"})
public final class BRIActionKt {
    @NotNull
    public static final String formatDateTime(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        DateTimeFormat formatter = LocalDateTime.Companion.Format(BRIActionKt::formatDateTime$lambda$0);
        return LocalDateTimeKt.format((LocalDateTime)dateTime, (DateTimeFormat)formatter);
    }

    @NotNull
    public static final String formatDateTimeWithTimeZone(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        DateTimeFormat formatter = LocalDateTime.Companion.Format(BRIActionKt::formatDateTimeWithTimeZone$lambda$0);
        return LocalDateTimeKt.format((LocalDateTime)dateTime, (DateTimeFormat)formatter);
    }

    @Nullable
    public static final LocalDateTime parseDateTime(@NotNull String dateTime, @NotNull TimeZone timeZone) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        DateTimeFormat formatter = LocalDateTime.Companion.Format(BRIActionKt::parseDateTime$lambda$0);
        try {
            localDateTime = TimeZoneKt.toLocalDateTime((Instant)TimeZoneKt.toInstant$default((LocalDateTime)((LocalDateTime)formatter.parse((CharSequence)dateTime)), (TimeZone)timeZone, null, (int)2, null), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        }
        catch (Exception e) {
            localDateTime = null;
        }
        return localDateTime;
    }

    public static /* synthetic */ LocalDateTime parseDateTime$default(String string, TimeZone timeZone, int n, Object object) {
        if ((n & 2) != 0) {
            timeZone = TimeZone.Companion.of("GMT+0700");
        }
        return BRIActionKt.parseDateTime(string, timeZone);
    }

    @NotNull
    public static final String toGmtString(@NotNull TimeZone $this$toGmtString, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)$this$toGmtString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return "GMT" + TimeZoneKt.offsetAt((TimeZone)$this$toGmtString, (Instant)instant);
    }

    public static /* synthetic */ String toGmtString$default(TimeZone timeZone, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            instant = Clock.System.INSTANCE.now();
        }
        return BRIActionKt.toGmtString(timeZone, instant);
    }

    @NotNull
    public static final String toOffset(@NotNull TimeZone $this$toOffset, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)$this$toOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return String.valueOf(TimeZoneKt.offsetAt((TimeZone)$this$toOffset, (Instant)instant));
    }

    public static /* synthetic */ String toOffset$default(TimeZone timeZone, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            instant = Clock.System.INSTANCE.now();
        }
        return BRIActionKt.toOffset(timeZone, instant);
    }

    private static final Unit formatDateTime$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)"yyyy-MM-dd HH:mm:ss");
        return Unit.INSTANCE;
    }

    private static final Unit formatDateTimeWithTimeZone$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)"yyyy-MM-dd'T'HH:mm:sszzz");
        return Unit.INSTANCE;
    }

    private static final Unit parseDateTime$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)"yyyy-MM-dd HH:mm:ss");
        return Unit.INSTANCE;
    }
}

