/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.bri.data;

import co.xendit.terminal.bri.data.BRIPaymentMethod;
import co.xendit.terminal.bri.data.BRITerminalAction;
import co.xendit.terminal.bri.data.ResponsePaymentMethod;
import co.xendit.terminal.core.data.Action;
import co.xendit.terminal.core.data.GenericPaymentMethod;
import co.xendit.terminal.core.util.JsonKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u000f2\u00020\u0001:\r\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001bB\u001f\b\u0004\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001c\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001c\u0010\f\u001a\u00020\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u0082\u0001\n\u001c\u001d\u001e\u001f !\"#$%\u00a8\u0006&"}, d2={"Lco/xendit/terminal/bri/data/BRIAction;", "Lco/xendit/terminal/core/data/Action;", "data", "", "", "Lkotlinx/serialization/json/JsonElement;", "<init>", "(Ljava/util/Map;)V", "getTransactionAmount", "", "getTransactionOrderID", "getPaymentMethod", "getServicePaymentMethod", "getTerminalAction", "Lco/xendit/terminal/bri/data/BRITerminalAction;", "Companion", "Payment", "Sale", "Contactless", "CardVerification", "SaleCompletion", "Installment", "CheckStatus", "RefundQris", "Settlement", "ReprintLast", "ReprintAny", "Void", "Lco/xendit/terminal/bri/data/BRIAction$CardVerification;", "Lco/xendit/terminal/bri/data/BRIAction$CheckStatus;", "Lco/xendit/terminal/bri/data/BRIAction$Installment;", "Lco/xendit/terminal/bri/data/BRIAction$Payment;", "Lco/xendit/terminal/bri/data/BRIAction$RefundQris;", "Lco/xendit/terminal/bri/data/BRIAction$ReprintAny;", "Lco/xendit/terminal/bri/data/BRIAction$ReprintLast;", "Lco/xendit/terminal/bri/data/BRIAction$SaleCompletion;", "Lco/xendit/terminal/bri/data/BRIAction$Settlement;", "Lco/xendit/terminal/bri/data/BRIAction$Void;", "id-bri"})
@SourceDebugExtension(value={"SMAP\nBRIAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BRIAction.kt\nco/xendit/terminal/bri/data/BRIAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,474:1\n1#2:475\n*E\n"})
public abstract class BRIAction
extends Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String AMOUNT = "amount";
    @NotNull
    public static final String ACTION = "action";
    @NotNull
    public static final String TRX_ID = "trx_id";
    @NotNull
    public static final String APPROVAL = "approval";
    @NotNull
    public static final String POS_ADDRESS = "pos_address";
    @NotNull
    public static final String METHOD = "method";
    @NotNull
    public static final String TRACE_NUMBER = "trace_number";
    @NotNull
    public static final String REFERENCE_NUMBER = "reference_number";
    @NotNull
    public static final String REFERENCE_ID = "reff_id";
    @NotNull
    public static final String PLAN = "plan";
    @NotNull
    public static final String PERIOD = "periode";

    private BRIAction(Map<String, ? extends JsonElement> data) {
        super(data);
    }

    public /* synthetic */ BRIAction(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(map2, null);
    }

    public double getTransactionAmount(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = data.get(AMOUNT);
        return object != null && (object = object.toString()) != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? (Double)object : 0.0;
    }

    @Nullable
    public String getTransactionOrderID(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        JsonElement jsonElement = data.get(TRX_ID);
        return jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getPaymentMethod(@NotNull Map<String, ? extends JsonElement> data) {
        GenericPaymentMethod genericPaymentMethod;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = data.get(METHOD);
        if (object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) != null) {
            Object object2 = object;
            boolean bl = false;
            BRIPaymentMethod bRIPaymentMethod = BRIPaymentMethod.Companion.toEnum((String)object2);
            object = bRIPaymentMethod;
            if (bRIPaymentMethod != null) {
                genericPaymentMethod = ((BRIPaymentMethod)((Object)object)).toPaymentMethod();
                return String.valueOf(genericPaymentMethod);
            }
        }
        genericPaymentMethod = null;
        return String.valueOf(genericPaymentMethod);
    }

    @NotNull
    public String getServicePaymentMethod(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return ResponsePaymentMethod.Companion.fromRequest(data).getValue();
    }

    @Nullable
    public BRITerminalAction getTerminalAction(@NotNull Map<String, ? extends JsonElement> data) {
        BRITerminalAction bRITerminalAction;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = data.get(ACTION);
        if (object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) != null) {
            Object it = object;
            boolean bl = false;
            bRITerminalAction = BRITerminalAction.Companion.toEnum((String)it);
        } else {
            bRITerminalAction = null;
        }
        return bRITerminalAction;
    }

    public /* synthetic */ BRIAction(Map data, DefaultConstructorMarker $constructor_marker) {
        this(data);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u0019*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0019B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u000f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$CardVerification;", "T", "", "Lco/xendit/terminal/bri/data/BRIAction;", "orderID", "", "amount", "<init>", "(Ljava/lang/String;Ljava/lang/Number;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()Ljava/lang/Number;", "Ljava/lang/Number;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Number;)Lco/xendit/terminal/bri/data/BRIAction$CardVerification;", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "id-bri"})
    public static final class CardVerification<T extends Number>
    extends BRIAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String orderID;
        @NotNull
        private final T amount;

        public CardVerification(@NotNull String orderID, @NotNull T amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            Object[] objectArray = new Pair[4];
            objectArray[0] = TuplesKt.to((Object)BRIAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive(amount));
            objectArray[1] = TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)BRITerminalAction.CARD_VERIFICATION.getValue()));
            objectArray[2] = TuplesKt.to((Object)BRIAction.TRX_ID, (Object)JsonElementKt.JsonPrimitive((String)orderID));
            String string = BRIPaymentMethod.INSERT_CARD.getValue();
            objectArray[3] = string != null ? JsonKt.toJsonPrimitive((String)string, (String)BRIAction.METHOD) : null;
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.amount = amount;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        @NotNull
        public final T getAmount() {
            return this.amount;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        @NotNull
        public final T component2() {
            return this.amount;
        }

        @NotNull
        public final CardVerification<T> copy(@NotNull String orderID, @NotNull T amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            return new CardVerification<T>(orderID, amount);
        }

        public static /* synthetic */ CardVerification copy$default(CardVerification cardVerification, String string, Number number, int n, Object object) {
            if ((n & 1) != 0) {
                string = cardVerification.orderID;
            }
            if ((n & 2) != 0) {
                number = cardVerification.amount;
            }
            return cardVerification.copy(string, number);
        }

        @NotNull
        public String toString() {
            return "CardVerification(orderID=" + this.orderID + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + this.amount.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CardVerification)) {
                return false;
            }
            CardVerification cardVerification = (CardVerification)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)cardVerification.orderID)) {
                return false;
            }
            return Intrinsics.areEqual(this.amount, cardVerification.amount);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0014\u0010\n\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u0002H\u00060\u000b\u00a8\u0006\r"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$CardVerification$Companion;", "", "<init>", "()V", "fromPayment", "Lco/xendit/terminal/bri/data/BRIAction$CardVerification;", "T", "", "payment", "Lco/xendit/terminal/bri/data/BRIAction$Payment;", "transform", "Lkotlin/Function1;", "Lkotlinx/serialization/json/JsonPrimitive;", "id-bri"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final <T extends Number> CardVerification<T> fromPayment(@NotNull Payment<T> payment, @NotNull Function1<? super JsonPrimitive, ? extends T> transform) {
                Intrinsics.checkNotNullParameter(payment, (String)"payment");
                Intrinsics.checkNotNullParameter(transform, (String)"transform");
                Object object = (JsonElement)payment.getData().get(BRIAction.TRX_ID);
                if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
                    object = "";
                }
                JsonElement jsonElement = (JsonElement)payment.getData().get(BRIAction.AMOUNT);
                return new CardVerification<Number>((String)object, (Number)transform.invoke(jsonElement != null ? JsonElementKt.getJsonPrimitive((JsonElement)jsonElement) : null));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\bH\u0016J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000e\u0010\u0016\u001a\u00020\bH\u00c0\u0003\u00a2\u0006\u0002\b\u0017J7\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$CheckStatus;", "Lco/xendit/terminal/bri/data/BRIAction;", "orderID", "", "referenceNumber", "method", "Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "verification", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lco/xendit/terminal/bri/data/BRIPaymentMethod;Z)V", "getOrderID", "()Ljava/lang/String;", "getReferenceNumber", "getMethod", "()Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "getVerification$id_bri", "()Z", "isNeedVerified", "component1", "component2", "component3", "component4", "component4$id_bri", "copy", "equals", "other", "", "hashCode", "", "toString", "id-bri"})
    public static final class CheckStatus
    extends BRIAction {
        @Nullable
        private final String orderID;
        @Nullable
        private final String referenceNumber;
        @Nullable
        private final BRIPaymentMethod method;
        private final boolean verification;

        public CheckStatus(@Nullable String orderID, @Nullable String referenceNumber, @Nullable BRIPaymentMethod method, boolean verification) {
            Pair pair;
            Object[] objectArray = new Pair[4];
            objectArray[0] = TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)(method == BRIPaymentMethod.QRIS && orderID == null ? BRITerminalAction.CHECK_STATUS.getValue() : BRITerminalAction.CHECK_TRX.getValue())));
            String string = referenceNumber;
            int n = 1;
            Object[] objectArray2 = objectArray;
            CheckStatus checkStatus2 = this;
            boolean bl = false;
            objectArray2[n] = pair = method == BRIPaymentMethod.QRIS && orderID == null ? TuplesKt.to((Object)BRIAction.REFERENCE_NUMBER, (Object)JsonElementKt.JsonPrimitive((String)referenceNumber)) : TuplesKt.to((Object)BRIAction.TRX_ID, (Object)JsonElementKt.JsonPrimitive((String)orderID));
            Object object = method;
            objectArray[2] = object != null && (object = object.getValue()) != null ? JsonKt.toJsonPrimitive((String)object, (String)BRIAction.METHOD) : null;
            objectArray[3] = TuplesKt.to((Object)"verification", (Object)JsonElementKt.JsonPrimitive((Boolean)verification));
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.referenceNumber = referenceNumber;
            this.method = method;
            this.verification = verification;
        }

        public /* synthetic */ CheckStatus(String string, String string2, BRIPaymentMethod bRIPaymentMethod, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                bRIPaymentMethod = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(string, string2, bRIPaymentMethod, bl);
        }

        @Nullable
        public final String getOrderID() {
            return this.orderID;
        }

        @Nullable
        public final String getReferenceNumber() {
            return this.referenceNumber;
        }

        @Nullable
        public final BRIPaymentMethod getMethod() {
            return this.method;
        }

        public final boolean getVerification$id_bri() {
            return this.verification;
        }

        public boolean isNeedVerified() {
            return this.verification;
        }

        @Nullable
        public final String component1() {
            return this.orderID;
        }

        @Nullable
        public final String component2() {
            return this.referenceNumber;
        }

        @Nullable
        public final BRIPaymentMethod component3() {
            return this.method;
        }

        public final boolean component4$id_bri() {
            return this.verification;
        }

        @NotNull
        public final CheckStatus copy(@Nullable String orderID, @Nullable String referenceNumber, @Nullable BRIPaymentMethod method, boolean verification) {
            return new CheckStatus(orderID, referenceNumber, method, verification);
        }

        public static /* synthetic */ CheckStatus copy$default(CheckStatus checkStatus2, String string, String string2, BRIPaymentMethod bRIPaymentMethod, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = checkStatus2.orderID;
            }
            if ((n & 2) != 0) {
                string2 = checkStatus2.referenceNumber;
            }
            if ((n & 4) != 0) {
                bRIPaymentMethod = checkStatus2.method;
            }
            if ((n & 8) != 0) {
                bl = checkStatus2.verification;
            }
            return checkStatus2.copy(string, string2, bRIPaymentMethod, bl);
        }

        @NotNull
        public String toString() {
            return "CheckStatus(orderID=" + this.orderID + ", referenceNumber=" + this.referenceNumber + ", method=" + this.method + ", verification=" + this.verification + ")";
        }

        public int hashCode() {
            int result = this.orderID == null ? 0 : this.orderID.hashCode();
            result = result * 31 + (this.referenceNumber == null ? 0 : this.referenceNumber.hashCode());
            result = result * 31 + (this.method == null ? 0 : this.method.hashCode());
            result = result * 31 + Boolean.hashCode(this.verification);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CheckStatus)) {
                return false;
            }
            CheckStatus checkStatus2 = (CheckStatus)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)checkStatus2.orderID)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.referenceNumber, (Object)checkStatus2.referenceNumber)) {
                return false;
            }
            if (this.method != checkStatus2.method) {
                return false;
            }
            return this.verification == checkStatus2.verification;
        }

        public CheckStatus() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$Companion;", "", "<init>", "()V", "AMOUNT", "", "ACTION", "TRX_ID", "APPROVAL", "POS_ADDRESS", "METHOD", "TRACE_NUMBER", "REFERENCE_NUMBER", "REFERENCE_ID", "PLAN", "PERIOD", "id-bri"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u000f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$Contactless;", "T", "", "Lco/xendit/terminal/bri/data/BRIAction$Payment;", "orderID", "", "amount", "<init>", "(Ljava/lang/String;Ljava/lang/Number;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()Ljava/lang/Number;", "Ljava/lang/Number;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Number;)Lco/xendit/terminal/bri/data/BRIAction$Contactless;", "equals", "", "other", "", "hashCode", "", "toString", "id-bri"})
    public static final class Contactless<T extends Number>
    extends Payment<T> {
        @NotNull
        private final String orderID;
        @NotNull
        private final T amount;

        public Contactless(@NotNull String orderID, @NotNull T amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            super(BRITerminalAction.CONTACTLESS, orderID, (Number)amount, BRIPaymentMethod.INSERT_CARD, null);
            this.orderID = orderID;
            this.amount = amount;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        @NotNull
        public final T getAmount() {
            return this.amount;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        @NotNull
        public final T component2() {
            return this.amount;
        }

        @NotNull
        public final Contactless<T> copy(@NotNull String orderID, @NotNull T amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            return new Contactless<T>(orderID, amount);
        }

        public static /* synthetic */ Contactless copy$default(Contactless contactless, String string, Number number, int n, Object object) {
            if ((n & 1) != 0) {
                string = contactless.orderID;
            }
            if ((n & 2) != 0) {
                number = contactless.amount;
            }
            return contactless.copy(string, number);
        }

        @NotNull
        public String toString() {
            return "Contactless(orderID=" + this.orderID + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + this.amount.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Contactless)) {
                return false;
            }
            Contactless contactless = (Contactless)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)contactless.orderID)) {
                return false;
            }
            return Intrinsics.areEqual(this.amount, contactless.amount);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J<\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001f"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$Installment;", "T", "", "Lco/xendit/terminal/bri/data/BRIAction;", "orderID", "", "amount", "plan", "period", "<init>", "(Ljava/lang/String;Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()Ljava/lang/Number;", "Ljava/lang/Number;", "getPlan", "getPeriod", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/Number;Ljava/lang/String;Ljava/lang/String;)Lco/xendit/terminal/bri/data/BRIAction$Installment;", "equals", "", "other", "", "hashCode", "", "toString", "id-bri"})
    public static final class Installment<T extends Number>
    extends BRIAction {
        @NotNull
        private final String orderID;
        @NotNull
        private final T amount;
        @NotNull
        private final String plan;
        @NotNull
        private final String period;

        public Installment(@NotNull String orderID, @NotNull T amount, @NotNull String plan, @NotNull String period) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            Intrinsics.checkNotNullParameter((Object)plan, (String)BRIAction.PLAN);
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            Object[] objectArray = new Pair[6];
            objectArray[0] = TuplesKt.to((Object)BRIAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive(amount));
            objectArray[1] = TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)BRITerminalAction.INSTALLMENT.getValue()));
            objectArray[2] = TuplesKt.to((Object)BRIAction.TRX_ID, (Object)JsonElementKt.JsonPrimitive((String)orderID));
            objectArray[3] = TuplesKt.to((Object)BRIAction.PLAN, (Object)JsonElementKt.JsonPrimitive((String)plan));
            objectArray[4] = TuplesKt.to((Object)BRIAction.PERIOD, (Object)JsonElementKt.JsonPrimitive((String)period));
            String string = BRIPaymentMethod.INSERT_CARD.getValue();
            objectArray[5] = string != null ? JsonKt.toJsonPrimitive((String)string, (String)BRIAction.METHOD) : null;
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.amount = amount;
            this.plan = plan;
            this.period = period;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        @NotNull
        public final T getAmount() {
            return this.amount;
        }

        @NotNull
        public final String getPlan() {
            return this.plan;
        }

        @NotNull
        public final String getPeriod() {
            return this.period;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        @NotNull
        public final T component2() {
            return this.amount;
        }

        @NotNull
        public final String component3() {
            return this.plan;
        }

        @NotNull
        public final String component4() {
            return this.period;
        }

        @NotNull
        public final Installment<T> copy(@NotNull String orderID, @NotNull T amount, @NotNull String plan, @NotNull String period) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            Intrinsics.checkNotNullParameter((Object)plan, (String)BRIAction.PLAN);
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            return new Installment<T>(orderID, amount, plan, period);
        }

        public static /* synthetic */ Installment copy$default(Installment installment, String string, Number number, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = installment.orderID;
            }
            if ((n & 2) != 0) {
                number = installment.amount;
            }
            if ((n & 4) != 0) {
                string2 = installment.plan;
            }
            if ((n & 8) != 0) {
                string3 = installment.period;
            }
            return installment.copy(string, number, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Installment(orderID=" + this.orderID + ", amount=" + this.amount + ", plan=" + this.plan + ", period=" + this.period + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + this.amount.hashCode();
            result = result * 31 + this.plan.hashCode();
            result = result * 31 + this.period.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Installment)) {
                return false;
            }
            Installment installment = (Installment)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)installment.orderID)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.amount, installment.amount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.plan, (Object)installment.plan)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.period, (Object)installment.period);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B-\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\f\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$Payment;", "T", "", "Lco/xendit/terminal/bri/data/BRIAction;", "action", "Lco/xendit/terminal/bri/data/BRITerminalAction;", "orderID", "", "amount", "method", "Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "<init>", "(Lco/xendit/terminal/bri/data/BRITerminalAction;Ljava/lang/String;Ljava/lang/Number;Lco/xendit/terminal/bri/data/BRIPaymentMethod;)V", "Lco/xendit/terminal/bri/data/BRIAction$Contactless;", "Lco/xendit/terminal/bri/data/BRIAction$Sale;", "id-bri"})
    public static abstract class Payment<T extends Number>
    extends BRIAction {
        private Payment(BRITerminalAction action, String orderID, T amount, BRIPaymentMethod method) {
            Object object;
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)BRIAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive(amount)), TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)action.getValue())), TuplesKt.to((Object)BRIAction.TRX_ID, (Object)JsonElementKt.JsonPrimitive((String)orderID)), (object = method) != null && (object = object.getValue()) != null ? JsonKt.toJsonPrimitive((String)object, (String)BRIAction.METHOD) : null};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
        }

        public /* synthetic */ Payment(BRITerminalAction bRITerminalAction, String string, Number number, BRIPaymentMethod bRIPaymentMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bRIPaymentMethod = BRIPaymentMethod.INSERT_CARD;
            }
            this(bRITerminalAction, string, number, bRIPaymentMethod, null);
        }

        public /* synthetic */ Payment(BRITerminalAction action, String orderID, Number amount, BRIPaymentMethod method, DefaultConstructorMarker $constructor_marker) {
            this(action, orderID, amount, method);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$RefundQris;", "Lco/xendit/terminal/bri/data/BRIAction;", "referenceID", "", "method", "Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "<init>", "(Ljava/lang/String;Lco/xendit/terminal/bri/data/BRIPaymentMethod;)V", "getReferenceID", "()Ljava/lang/String;", "getMethod", "()Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "id-bri"})
    public static final class RefundQris
    extends BRIAction {
        @NotNull
        private final String referenceID;
        @NotNull
        private final BRIPaymentMethod method;

        public RefundQris(@NotNull String referenceID, @NotNull BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)referenceID, (String)"referenceID");
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)BRIAction.METHOD);
            Object[] objectArray = new Pair[3];
            objectArray[0] = TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)BRITerminalAction.REFUND_QRIS.getValue()));
            objectArray[1] = TuplesKt.to((Object)BRIAction.REFERENCE_ID, (Object)JsonElementKt.JsonPrimitive((String)referenceID));
            String string = BRIPaymentMethod.QRIS.getValue();
            objectArray[2] = string != null ? JsonKt.toJsonPrimitive((String)string, (String)BRIAction.METHOD) : null;
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.referenceID = referenceID;
            this.method = method;
        }

        public /* synthetic */ RefundQris(String string, BRIPaymentMethod bRIPaymentMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bRIPaymentMethod = BRIPaymentMethod.QRIS;
            }
            this(string, bRIPaymentMethod);
        }

        @NotNull
        public final String getReferenceID() {
            return this.referenceID;
        }

        @NotNull
        public final BRIPaymentMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final String component1() {
            return this.referenceID;
        }

        @NotNull
        public final BRIPaymentMethod component2() {
            return this.method;
        }

        @NotNull
        public final RefundQris copy(@NotNull String referenceID, @NotNull BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)referenceID, (String)"referenceID");
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)BRIAction.METHOD);
            return new RefundQris(referenceID, method);
        }

        public static /* synthetic */ RefundQris copy$default(RefundQris refundQris, String string, BRIPaymentMethod bRIPaymentMethod, int n, Object object) {
            if ((n & 1) != 0) {
                string = refundQris.referenceID;
            }
            if ((n & 2) != 0) {
                bRIPaymentMethod = refundQris.method;
            }
            return refundQris.copy(string, bRIPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "RefundQris(referenceID=" + this.referenceID + ", method=" + this.method + ")";
        }

        public int hashCode() {
            int result = this.referenceID.hashCode();
            result = result * 31 + this.method.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RefundQris)) {
                return false;
            }
            RefundQris refundQris = (RefundQris)((Object)other);
            if (!Intrinsics.areEqual((Object)this.referenceID, (Object)refundQris.referenceID)) {
                return false;
            }
            return this.method == refundQris.method;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$ReprintAny;", "Lco/xendit/terminal/bri/data/BRIAction;", "traceNumber", "", "method", "Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "<init>", "(ILco/xendit/terminal/bri/data/BRIPaymentMethod;)V", "getTraceNumber", "()I", "getMethod", "()Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "id-bri"})
    public static final class ReprintAny
    extends BRIAction {
        private final int traceNumber;
        @NotNull
        private final BRIPaymentMethod method;

        public ReprintAny(int traceNumber, @NotNull BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)BRIAction.METHOD);
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)BRITerminalAction.REPRINT_ANY.getValue())), TuplesKt.to((Object)BRIAction.TRACE_NUMBER, (Object)JsonElementKt.JsonPrimitive((Number)traceNumber)), TuplesKt.to((Object)BRIAction.METHOD, (Object)JsonElementKt.JsonPrimitive((String)method.getValue()))};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.traceNumber = traceNumber;
            this.method = method;
        }

        public final int getTraceNumber() {
            return this.traceNumber;
        }

        @NotNull
        public final BRIPaymentMethod getMethod() {
            return this.method;
        }

        public final int component1() {
            return this.traceNumber;
        }

        @NotNull
        public final BRIPaymentMethod component2() {
            return this.method;
        }

        @NotNull
        public final ReprintAny copy(int traceNumber, @NotNull BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)BRIAction.METHOD);
            return new ReprintAny(traceNumber, method);
        }

        public static /* synthetic */ ReprintAny copy$default(ReprintAny reprintAny, int n, BRIPaymentMethod bRIPaymentMethod, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = reprintAny.traceNumber;
            }
            if ((n2 & 2) != 0) {
                bRIPaymentMethod = reprintAny.method;
            }
            return reprintAny.copy(n, bRIPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "ReprintAny(traceNumber=" + this.traceNumber + ", method=" + this.method + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.traceNumber);
            result = result * 31 + this.method.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReprintAny)) {
                return false;
            }
            ReprintAny reprintAny = (ReprintAny)((Object)other);
            if (this.traceNumber != reprintAny.traceNumber) {
                return false;
            }
            return this.method == reprintAny.method;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$ReprintLast;", "Lco/xendit/terminal/bri/data/BRIAction;", "method", "Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "<init>", "(Lco/xendit/terminal/bri/data/BRIPaymentMethod;)V", "getMethod", "()Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "id-bri"})
    public static final class ReprintLast
    extends BRIAction {
        @NotNull
        private final BRIPaymentMethod method;

        public ReprintLast(@NotNull BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)BRIAction.METHOD);
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)BRITerminalAction.REPRINT_LAST.getValue())), TuplesKt.to((Object)BRIAction.METHOD, (Object)JsonElementKt.JsonPrimitive((String)method.getValue()))};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.method = method;
        }

        @NotNull
        public final BRIPaymentMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final BRIPaymentMethod component1() {
            return this.method;
        }

        @NotNull
        public final ReprintLast copy(@NotNull BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)BRIAction.METHOD);
            return new ReprintLast(method);
        }

        public static /* synthetic */ ReprintLast copy$default(ReprintLast reprintLast, BRIPaymentMethod bRIPaymentMethod, int n, Object object) {
            if ((n & 1) != 0) {
                bRIPaymentMethod = reprintLast.method;
            }
            return reprintLast.copy(bRIPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "ReprintLast(method=" + this.method + ")";
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReprintLast)) {
                return false;
            }
            ReprintLast reprintLast = (ReprintLast)((Object)other);
            return this.method == reprintLast.method;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u0013\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u00c6\u0003J4\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u00002\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$Sale;", "T", "", "Lco/xendit/terminal/bri/data/BRIAction$Payment;", "orderID", "", "amount", "method", "Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "<init>", "(Ljava/lang/String;Ljava/lang/Number;Lco/xendit/terminal/bri/data/BRIPaymentMethod;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()Ljava/lang/Number;", "Ljava/lang/Number;", "getMethod", "()Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/Number;Lco/xendit/terminal/bri/data/BRIPaymentMethod;)Lco/xendit/terminal/bri/data/BRIAction$Sale;", "equals", "", "other", "", "hashCode", "", "toString", "id-bri"})
    public static final class Sale<T extends Number>
    extends Payment<T> {
        @NotNull
        private final String orderID;
        @NotNull
        private final T amount;
        @Nullable
        private final BRIPaymentMethod method;

        public Sale(@NotNull String orderID, @NotNull T amount, @Nullable BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            super(BRITerminalAction.SALE, orderID, (Number)amount, method, null);
            this.orderID = orderID;
            this.amount = amount;
            this.method = method;
        }

        public /* synthetic */ Sale(String string, Number number, BRIPaymentMethod bRIPaymentMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bRIPaymentMethod = BRIPaymentMethod.INSERT_CARD;
            }
            this(string, number, bRIPaymentMethod);
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        @NotNull
        public final T getAmount() {
            return this.amount;
        }

        @Nullable
        public final BRIPaymentMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        @NotNull
        public final T component2() {
            return this.amount;
        }

        @Nullable
        public final BRIPaymentMethod component3() {
            return this.method;
        }

        @NotNull
        public final Sale<T> copy(@NotNull String orderID, @NotNull T amount, @Nullable BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            return new Sale<T>(orderID, amount, method);
        }

        public static /* synthetic */ Sale copy$default(Sale sale, String string, Number number, BRIPaymentMethod bRIPaymentMethod, int n, Object object) {
            if ((n & 1) != 0) {
                string = sale.orderID;
            }
            if ((n & 2) != 0) {
                number = sale.amount;
            }
            if ((n & 4) != 0) {
                bRIPaymentMethod = sale.method;
            }
            return sale.copy(string, number, bRIPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "Sale(orderID=" + this.orderID + ", amount=" + this.amount + ", method=" + this.method + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + this.amount.hashCode();
            result = result * 31 + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Sale)) {
                return false;
            }
            Sale sale = (Sale)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)sale.orderID)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.amount, sale.amount)) {
                return false;
            }
            return this.method == sale.method;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u0011\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$SaleCompletion;", "T", "", "Lco/xendit/terminal/bri/data/BRIAction;", "orderID", "", "amount", "approval", "<init>", "(Ljava/lang/String;Ljava/lang/Number;Ljava/lang/String;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()Ljava/lang/Number;", "Ljava/lang/Number;", "getApproval", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljava/lang/Number;Ljava/lang/String;)Lco/xendit/terminal/bri/data/BRIAction$SaleCompletion;", "equals", "", "other", "", "hashCode", "", "toString", "id-bri"})
    public static final class SaleCompletion<T extends Number>
    extends BRIAction {
        @NotNull
        private final String orderID;
        @NotNull
        private final T amount;
        @NotNull
        private final String approval;

        public SaleCompletion(@NotNull String orderID, @NotNull T amount, @NotNull String approval) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            Intrinsics.checkNotNullParameter((Object)approval, (String)BRIAction.APPROVAL);
            Object[] objectArray = new Pair[5];
            objectArray[0] = TuplesKt.to((Object)BRIAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive(amount));
            objectArray[1] = TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)BRITerminalAction.SALE_COMPLETION.getValue()));
            objectArray[2] = TuplesKt.to((Object)BRIAction.TRX_ID, (Object)JsonElementKt.JsonPrimitive((String)orderID));
            objectArray[3] = TuplesKt.to((Object)BRIAction.APPROVAL, (Object)JsonElementKt.JsonPrimitive((String)approval));
            String string = BRIPaymentMethod.INSERT_CARD.getValue();
            objectArray[4] = string != null ? JsonKt.toJsonPrimitive((String)string, (String)BRIAction.METHOD) : null;
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.amount = amount;
            this.approval = approval;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        @NotNull
        public final T getAmount() {
            return this.amount;
        }

        @NotNull
        public final String getApproval() {
            return this.approval;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        @NotNull
        public final T component2() {
            return this.amount;
        }

        @NotNull
        public final String component3() {
            return this.approval;
        }

        @NotNull
        public final SaleCompletion<T> copy(@NotNull String orderID, @NotNull T amount, @NotNull String approval) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter(amount, (String)BRIAction.AMOUNT);
            Intrinsics.checkNotNullParameter((Object)approval, (String)BRIAction.APPROVAL);
            return new SaleCompletion<T>(orderID, amount, approval);
        }

        public static /* synthetic */ SaleCompletion copy$default(SaleCompletion saleCompletion, String string, Number number, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = saleCompletion.orderID;
            }
            if ((n & 2) != 0) {
                number = saleCompletion.amount;
            }
            if ((n & 4) != 0) {
                string2 = saleCompletion.approval;
            }
            return saleCompletion.copy(string, number, string2);
        }

        @NotNull
        public String toString() {
            return "SaleCompletion(orderID=" + this.orderID + ", amount=" + this.amount + ", approval=" + this.approval + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + this.amount.hashCode();
            result = result * 31 + this.approval.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SaleCompletion)) {
                return false;
            }
            SaleCompletion saleCompletion = (SaleCompletion)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)saleCompletion.orderID)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.amount, saleCompletion.amount)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.approval, (Object)saleCompletion.approval);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$Settlement;", "Lco/xendit/terminal/bri/data/BRIAction;", "method", "Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "<init>", "(Lco/xendit/terminal/bri/data/BRIPaymentMethod;)V", "getMethod", "()Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "id-bri"})
    public static final class Settlement
    extends BRIAction {
        @Nullable
        private final BRIPaymentMethod method;

        public Settlement(@Nullable BRIPaymentMethod method) {
            Object object;
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)BRITerminalAction.SETTLEMENT.getValue())), (object = method) != null && (object = object.getValue()) != null ? JsonKt.toJsonPrimitive((String)object, (String)BRIAction.METHOD) : null};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.method = method;
        }

        public /* synthetic */ Settlement(BRIPaymentMethod bRIPaymentMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bRIPaymentMethod = null;
            }
            this(bRIPaymentMethod);
        }

        @Nullable
        public final BRIPaymentMethod getMethod() {
            return this.method;
        }

        @Nullable
        public final BRIPaymentMethod component1() {
            return this.method;
        }

        @NotNull
        public final Settlement copy(@Nullable BRIPaymentMethod method) {
            return new Settlement(method);
        }

        public static /* synthetic */ Settlement copy$default(Settlement settlement, BRIPaymentMethod bRIPaymentMethod, int n, Object object) {
            if ((n & 1) != 0) {
                bRIPaymentMethod = settlement.method;
            }
            return settlement.copy(bRIPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "Settlement(method=" + this.method + ")";
        }

        public int hashCode() {
            return this.method == null ? 0 : this.method.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Settlement)) {
                return false;
            }
            Settlement settlement = (Settlement)((Object)other);
            return this.method == settlement.method;
        }

        public Settlement() {
            this((BRIPaymentMethod)null, 1, (DefaultConstructorMarker)null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lco/xendit/terminal/bri/data/BRIAction$Void;", "Lco/xendit/terminal/bri/data/BRIAction;", "traceNumber", "", "method", "Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "<init>", "(ILco/xendit/terminal/bri/data/BRIPaymentMethod;)V", "getTraceNumber", "()I", "getMethod", "()Lco/xendit/terminal/bri/data/BRIPaymentMethod;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "id-bri"})
    public static final class Void
    extends BRIAction {
        private final int traceNumber;
        @NotNull
        private final BRIPaymentMethod method;

        public Void(int traceNumber, @NotNull BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)BRIAction.METHOD);
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)BRIAction.ACTION, (Object)JsonElementKt.JsonPrimitive((String)BRITerminalAction.VOID.getValue())), TuplesKt.to((Object)BRIAction.TRACE_NUMBER, (Object)JsonElementKt.JsonPrimitive((Number)traceNumber)), TuplesKt.to((Object)BRIAction.METHOD, (Object)JsonElementKt.JsonPrimitive((String)method.getValue()))};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.traceNumber = traceNumber;
            this.method = method;
        }

        public final int getTraceNumber() {
            return this.traceNumber;
        }

        @NotNull
        public final BRIPaymentMethod getMethod() {
            return this.method;
        }

        public final int component1() {
            return this.traceNumber;
        }

        @NotNull
        public final BRIPaymentMethod component2() {
            return this.method;
        }

        @NotNull
        public final Void copy(int traceNumber, @NotNull BRIPaymentMethod method) {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)BRIAction.METHOD);
            return new Void(traceNumber, method);
        }

        public static /* synthetic */ Void copy$default(Void void_, int n, BRIPaymentMethod bRIPaymentMethod, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = void_.traceNumber;
            }
            if ((n2 & 2) != 0) {
                bRIPaymentMethod = void_.method;
            }
            return void_.copy(n, bRIPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "Void(traceNumber=" + this.traceNumber + ", method=" + this.method + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.traceNumber);
            result = result * 31 + this.method.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Void)) {
                return false;
            }
            Void void_ = (Void)((Object)other);
            if (this.traceNumber != void_.traceNumber) {
                return false;
            }
            return this.method == void_.method;
        }
    }
}

