/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.bri;

import co.xendit.terminal.bri.BaseTerminalBRI;
import co.xendit.terminal.bri.TerminalBRIKt;
import co.xendit.terminal.bri.data.BRIAction;
import co.xendit.terminal.bri.data.BRIActionKt;
import co.xendit.terminal.bri.data.BRIPayload;
import co.xendit.terminal.bri.data.BRIPaymentMethod;
import co.xendit.terminal.bri.data.BRITerminalAction;
import co.xendit.terminal.bri.data.BriStatus;
import co.xendit.terminal.bri.data.BriTerminalResult;
import co.xendit.terminal.bri.data.ErrorMapperKt;
import co.xendit.terminal.bri.data.ResponsePaymentMethod;
import co.xendit.terminal.bri.data.ServicePaymentMethod;
import co.xendit.terminal.bri.di.Bluetooth_desktopKt;
import co.xendit.terminal.bri.service.BriEDCWebSocketService;
import co.xendit.terminal.core.BaseTerminalOperation;
import co.xendit.terminal.core.TerminalOperation;
import co.xendit.terminal.core.TimeoutType;
import co.xendit.terminal.core.data.Action;
import co.xendit.terminal.core.data.ErrorCode;
import co.xendit.terminal.core.data.ErrorData;
import co.xendit.terminal.core.data.GenericPaymentMethod;
import co.xendit.terminal.core.data.Result;
import co.xendit.terminal.core.data.TerminalAction;
import co.xendit.terminal.core.data.TerminalDevice;
import co.xendit.terminal.core.data.TerminalProvider;
import co.xendit.terminal.core.data.TerminalResult;
import co.xendit.terminal.core.data.Transactions;
import co.xendit.terminal.core.data.response.Command;
import co.xendit.terminal.core.data.response.CommandType;
import co.xendit.terminal.core.data.response.PayPayload;
import co.xendit.terminal.core.data.response.PrintReceiptPayload;
import co.xendit.terminal.core.data.response.SettlementPayload;
import co.xendit.terminal.core.data.response.VoidPayload;
import co.xendit.terminal.core.di.AppModule;
import co.xendit.terminal.core.di.AppModule_desktopKt;
import co.xendit.terminal.core.di.BluetoothService;
import co.xendit.terminal.core.di.IPAddresses_desktopKt;
import co.xendit.terminal.core.exception.RetryCancellationException;
import co.xendit.terminal.core.util.ActionJob;
import co.xendit.terminal.core.util.JsonKt;
import co.xendit.terminal.core.util.XLogger;
import io.ktor.client.HttpClient;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ulid.ULID;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ<\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJP\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0094@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d0\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001e\u0010\"\u001a\u0004\u0018\u00010\u00062\b\u0010!\u001a\u0004\u0018\u00010\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\fH\u0016J0\u0010.\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\u001d0/2\u0006\u00100\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J(\u00104\u001a\u00020\u001d2\u0006\u00102\u001a\u0002032\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0018\u0010;\u001a\u00020\u001d2\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u00020\u001dH\u0002J\u001e\u0010<\u001a\u0002012\u0006\u0010=\u001a\u0002012\u0006\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u001dJ\u0010\u0010@\u001a\u00020\f2\u0006\u00107\u001a\u000208H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010C\u001a\u00020\bH\u0016J\u001a\u0010I\u001a\u0004\u0018\u00010\b2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0014J\u001a\u0010N\u001a\u0004\u0018\u00010\b2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020OH\u0014J\u001a\u0010P\u001a\u0004\u0018\u00010\b2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020QH\u0014J\u0014\u0010R\u001a\u0004\u0018\u00010\f2\b\u0010L\u001a\u0004\u0018\u00010\u001dH\u0016J\u0016\u0010S\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010TJ\u0018\u0010U\u001a\b\u0012\u0004\u0012\u00020V0'2\b\u0010W\u001a\u0004\u0018\u00010XH\u0016J\b\u0010Y\u001a\u00020\fH\u0016J\u0018\u0010Z\u001a\u00020\b2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020[H\u0014R\u0014\u0010\u0017\u001a\u00020\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0014\u0010D\u001a\u00020EX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020\f0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\\"}, d2={"Lco/xendit/terminal/bri/BaseTerminalBRI;", "Lco/xendit/terminal/core/TerminalOperation;", "<init>", "()V", "onRefresh", "Lco/xendit/terminal/core/data/Result;", "Lco/xendit/terminal/core/data/TerminalResult;", "payload", "Lco/xendit/terminal/core/data/Action;", "device", "Lco/xendit/terminal/core/data/TerminalDevice;", "paymentRequestId", "", "isSimulation", "", "(Lco/xendit/terminal/core/data/Action;Lco/xendit/terminal/core/data/TerminalDevice;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkStatus", "doAction", "actionJob", "Lco/xendit/terminal/core/util/ActionJob;", "orderId", "isSynchronize", "(Lco/xendit/terminal/core/util/ActionJob;Lco/xendit/terminal/core/data/Action;Lco/xendit/terminal/core/data/TerminalDevice;Ljava/lang/String;Ljava/lang/String;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "communicationService", "Lco/xendit/terminal/bri/service/BriEDCWebSocketService;", "getCommunicationService", "()Lco/xendit/terminal/bri/service/BriEDCWebSocketService;", "transformJsonToResult", "json", "Lkotlinx/serialization/json/JsonElement;", "prepareRequestPayload", "", "toResult", "terminalDevice", "toTerminalResult", "toPaymentMethod", "Lco/xendit/terminal/core/data/GenericPaymentMethod;", "value", "paymentActions", "", "getPaymentActions$id_bri", "()Ljava/util/List;", "voidActions", "getVoidActions$id_bri", "refundActions", "getRefundActions$id_bri", "toServicePayload", "Lkotlin/Pair;", "request", "Lkotlinx/serialization/json/JsonObject;", "transactions", "Lco/xendit/terminal/core/data/Transactions;", "syncPaymentData", "method", "Lco/xendit/terminal/bri/data/ResponsePaymentMethod;", "response", "Lco/xendit/terminal/bri/data/BriTerminalResult;", "amount", "", "syncCallback", "updateJsonObjectValue", "jsonObject", "key", "newValue", "toApiTransactionDate", "getTimeoutType", "Lco/xendit/terminal/core/TimeoutType;", "action", "bluetooth", "Lco/xendit/terminal/core/di/BluetoothService;", "getBluetooth", "()Lco/xendit/terminal/core/di/BluetoothService;", "successStatuses", "onPay", "command", "Lco/xendit/terminal/core/data/response/Command;", "data", "Lco/xendit/terminal/core/data/response/PayPayload;", "onVoid", "Lco/xendit/terminal/core/data/response/VoidPayload;", "onSettlement", "Lco/xendit/terminal/core/data/response/SettlementPayload;", "terminalID", "ping", "(Lco/xendit/terminal/core/data/TerminalDevice;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toActions", "Lco/xendit/terminal/core/data/TerminalAction;", "commandType", "Lco/xendit/terminal/core/data/response/CommandType;", "createOrderID", "onPrintReceipt", "Lco/xendit/terminal/core/data/response/PrintReceiptPayload;", "id-bri"})
@SourceDebugExtension(value={"SMAP\nTerminalBRI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBRI.kt\nco/xendit/terminal/bri/BaseTerminalBRI\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,539:1\n295#2,2:540\n1740#2,3:544\n335#3:542\n335#3:543\n1#4:547\n29#5,2:548\n31#5:552\n216#6,2:550\n*S KotlinDebug\n*F\n+ 1 TerminalBRI.kt\nco/xendit/terminal/bri/BaseTerminalBRI\n*L\n248#1:540,2\n314#1:544,3\n287#1:542\n313#1:543\n377#1:548,2\n377#1:552\n378#1:550,2\n*E\n"})
public class BaseTerminalBRI
extends TerminalOperation {
    @NotNull
    private final BriEDCWebSocketService communicationService = new BriEDCWebSocketService((MutableStateFlow<Result<JsonElement>>)this.getResultFlow(), (Function1<? super Exception, Boolean>)((Function1)BaseTerminalBRI::communicationService$lambda$0), (Function0<HttpClient>)((Function0)BaseTerminalBRI::communicationService$lambda$1));
    @NotNull
    private final List<String> paymentActions;
    @NotNull
    private final List<String> voidActions;
    @NotNull
    private final List<String> refundActions;
    @NotNull
    private final BluetoothService bluetooth;
    @NotNull
    private final List<String> successStatuses;

    public BaseTerminalBRI() {
        super(new TerminalProvider("BRI", "IDR", TerminalBRIKt.getBRI_PORTS()), true);
        Object[] objectArray = new String[]{BRITerminalAction.SALE.getValue(), BRITerminalAction.CONTACTLESS.getValue(), BRITerminalAction.INSTALLMENT.getValue()};
        this.paymentActions = CollectionsKt.listOf((Object[])objectArray);
        this.voidActions = CollectionsKt.listOf((Object)BRITerminalAction.VOID.getValue());
        this.refundActions = CollectionsKt.listOf((Object)BRITerminalAction.REFUND_QRIS.getValue());
        this.bluetooth = Bluetooth_desktopKt.getBriBluetoothService((MutableStateFlow<Result<JsonElement>>)this.getResultFlow());
        objectArray = new String[]{BriStatus.SUCCESS.getValue(), BriStatus.REFUND.getValue(), BriStatus.PAID.getValue()};
        this.successStatuses = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public Object onRefresh(@NotNull Action payload, @Nullable TerminalDevice device, @Nullable String paymentRequestId, @Nullable Boolean isSimulation, @NotNull Continuation<? super Result<TerminalResult>> $completion) {
        return this.checkStatus(payload, device, paymentRequestId, isSimulation, $completion);
    }

    @Nullable
    public Object checkStatus(@NotNull Action payload, @Nullable TerminalDevice device, @Nullable String paymentRequestId, @Nullable Boolean isSimulation, @NotNull Continuation<? super Result<TerminalResult>> $completion) {
        return BaseTerminalBRI.checkStatus$suspendImpl(this, payload, device, paymentRequestId, isSimulation, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object checkStatus$suspendImpl(BaseTerminalBRI $this, Action payload, TerminalDevice device, String paymentRequestId, Boolean isSimulation, Continuation<? super Result<TerminalResult>> $completion) {
        block12: {
            block10: {
                block11: {
                    if (!($completion instanceof checkStatus.1)) ** GOTO lbl-1000
                    var13_6 = $completion;
                    if ((var13_6.label & -2147483648) != 0) {
                        var13_6.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl($this, $completion){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            Object L$5;
                            Object L$6;
                            Object L$7;
                            int I$0;
                            int I$1;
                            /* synthetic */ Object result;
                            final /* synthetic */ BaseTerminalBRI this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return BaseTerminalBRI.checkStatus$suspendImpl(this.this$0, null, null, null, null, (Continuation<? super Result<TerminalResult>>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var14_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = payload.getTransactionOrderID();
                            if (v0 == null) break block10;
                            it = v0;
                            $i$a$-let-BaseTerminalBRI$checkStatus$2 = 0;
                            var8_13 = new BRITerminalAction[]{BRITerminalAction.CONTACTLESS, BRITerminalAction.CARD_VERIFICATION, BRITerminalAction.SALE, BRITerminalAction.SALE_COMPLETION};
                            if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])var8_13), (Object)payload.getTerminalAction())) break block11;
                            v1 = device;
                            if (v1 == null) {
                                v1 = $this.getDevice();
                            }
                            if (v1 == null) break;
                            device = v1;
                            $i$a$-let-BaseTerminalBRI$checkStatus$2$1 = 0;
                            v2 = isSimulation;
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)payload);
                            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)device);
                            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)paymentRequestId);
                            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)isSimulation);
                            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)it);
                            $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)device);
                            $continuation.I$0 = $i$a$-let-BaseTerminalBRI$checkStatus$2;
                            $continuation.I$1 = $i$a$-let-BaseTerminalBRI$checkStatus$2$1;
                            $continuation.label = 1;
                            v3 = BaseTerminalOperation.doAction$default((BaseTerminalOperation)((BaseTerminalOperation)$this), (ActionJob)new ActionJob(null, null, null, false, null, 31, null), (Action)new BRIAction.CheckStatus(it, null, null, false, 6, null), (TerminalDevice)device, (String)it, (String)paymentRequestId, (boolean)(v2 != null ? v2.booleanValue() : $this.isSimulation()), (boolean)false, (Continuation)$continuation, (int)64, null);
                            if (v3 == var14_8) {
                                return var14_8;
                            }
                            ** GOTO lbl51
                        }
                        case 1: {
                            $i$a$-let-BaseTerminalBRI$checkStatus$2$1 = $continuation.I$1;
                            $i$a$-let-BaseTerminalBRI$checkStatus$2 = $continuation.I$0;
                            device = (TerminalDevice)$continuation.L$6;
                            it = (String)$continuation.L$5;
                            isSimulation = (Boolean)$continuation.L$4;
                            paymentRequestId = (String)$continuation.L$3;
                            device = (TerminalDevice)$continuation.L$2;
                            payload = (Action)$continuation.L$1;
                            $this = (BaseTerminalBRI)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl51:
                            // 2 sources

                            result = (Result)v3;
                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)payload);
                            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)device);
                            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)paymentRequestId);
                            $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)isSimulation);
                            $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)it);
                            $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)device);
                            $continuation.L$7 = result;
                            $continuation.I$0 = $i$a$-let-BaseTerminalBRI$checkStatus$2;
                            $continuation.I$1 = $i$a$-let-BaseTerminalBRI$checkStatus$2$1;
                            $continuation.label = 2;
                            v4 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                            if (v4 == var14_8) {
                                return var14_8;
                            }
                            ** GOTO lbl80
                        }
                        case 2: {
                            $i$a$-let-BaseTerminalBRI$checkStatus$2$1 = $continuation.I$1;
                            $i$a$-let-BaseTerminalBRI$checkStatus$2 = $continuation.I$0;
                            result = (Result)$continuation.L$7;
                            device = (TerminalDevice)$continuation.L$6;
                            it = (String)$continuation.L$5;
                            isSimulation = (Boolean)$continuation.L$4;
                            paymentRequestId = (String)$continuation.L$3;
                            device = (TerminalDevice)$continuation.L$2;
                            payload = (Action)$continuation.L$1;
                            $this = (BaseTerminalBRI)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl80:
                            // 2 sources

                            v5 = (TerminalResult)result.getData();
                            XLogger.Companion.debug("[onRefresh] " + result.getData() + " " + (v5 != null ? v5.getOrderID() : null) + " " + result.getError());
                            return result;
                        }
                    }
                    v6 = null;
                    break block12;
                }
                v6 = ErrorCode.toResult$default((ErrorCode)ErrorCode.DATA_NOT_FOUND, null, null, (int)3, null);
                break block12;
            }
            v6 = null;
        }
        return v6;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object doAction(@NotNull ActionJob actionJob, @NotNull Action payload, @NotNull TerminalDevice device, @Nullable String orderId, @Nullable String paymentRequestId, boolean isSimulation, boolean isSynchronize, @NotNull Continuation<? super Result<TerminalResult>> $completion) {
        return BaseTerminalBRI.doAction$suspendImpl(this, actionJob, payload, device, orderId, paymentRequestId, isSimulation, isSynchronize, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object doAction$suspendImpl(BaseTerminalBRI $this, ActionJob actionJob, Action payload, TerminalDevice device, String orderId, String paymentRequestId, boolean isSimulation, boolean isSynchronize, Continuation<? super Result<TerminalResult>> $completion) {
        if (!($completion instanceof doAction.1)) ** GOTO lbl-1000
        var15_9 = $completion;
        if ((var15_9.label & -2147483648) != 0) {
            var15_9.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                boolean Z$0;
                boolean Z$1;
                boolean Z$2;
                /* synthetic */ Object result;
                final /* synthetic */ BaseTerminalBRI this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseTerminalBRI.doAction$suspendImpl(this.this$0, null, null, null, null, null, false, false, (Continuation<? super Result<TerminalResult>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_11 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)actionJob);
                $continuation.L$2 = payload;
                $continuation.L$3 = device;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)orderId);
                $continuation.L$5 = paymentRequestId;
                $continuation.Z$0 = isSimulation;
                $continuation.Z$1 = isSynchronize;
                $continuation.label = 1;
                v0 = super.doAction(actionJob, payload, device, orderId, paymentRequestId, isSimulation != false, isSynchronize != false, (Continuation)$continuation);
                if (v0 == var16_11) {
                    return var16_11;
                }
                ** GOTO lbl36
            }
            case 1: {
                isSynchronize = $continuation.Z$1;
                isSimulation = $continuation.Z$0;
                paymentRequestId = (String)$continuation.L$5;
                orderId = (String)$continuation.L$4;
                device = (TerminalDevice)$continuation.L$3;
                payload = (Action)$continuation.L$2;
                actionJob = (ActionJob)$continuation.L$1;
                $this = (BaseTerminalBRI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                result = (Result)v0;
                isPayment = $this.paymentActions.contains(action = String.valueOf(payload.getTerminalAction()));
                XLogger.Companion.debug("[isPayment] " + action + " : " + (isPayment != false));
                requestTransactionID = payload.getTransactionOrderID();
                v1 = (TerminalResult)result.getData();
                resultTransactionID = v1 != null ? v1.getOrderID() : null;
                XLogger.Companion.debug("[Order ID] " + requestTransactionID + " = " + resultTransactionID);
                if (!isPayment || Intrinsics.areEqual((Object)requestTransactionID, (Object)resultTransactionID)) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)actionJob);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)payload);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)device);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)orderId);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)paymentRequestId);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)result);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)action);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)requestTransactionID);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)resultTransactionID);
                $continuation.Z$0 = isSimulation;
                $continuation.Z$1 = isSynchronize;
                $continuation.Z$2 = isPayment;
                $continuation.label = 2;
                v2 = $this.checkStatus(payload, device, paymentRequestId, Boxing.boxBoolean((boolean)(isSimulation != false)), (Continuation<? super Result<TerminalResult>>)$continuation);
                if (v2 == var16_11) {
                    return var16_11;
                }
                ** GOTO lbl78
            }
            case 2: {
                isPayment = $continuation.Z$2;
                isSynchronize = $continuation.Z$1;
                isSimulation = $continuation.Z$0;
                resultTransactionID = (String)$continuation.L$9;
                requestTransactionID = (String)$continuation.L$8;
                action = (String)$continuation.L$7;
                result = (Result)$continuation.L$6;
                paymentRequestId = (String)$continuation.L$5;
                orderId = (String)$continuation.L$4;
                device = (TerminalDevice)$continuation.L$3;
                payload = (Action)$continuation.L$2;
                actionJob = (ActionJob)$continuation.L$1;
                $this = (BaseTerminalBRI)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl78:
                // 2 sources

                if ((v3 = (Result)v2) == null) {
                    v3 = ErrorCode.toResult$default((ErrorCode)ErrorCode.DATA_NOT_FOUND, null, null, (int)3, null);
                }
                return v3;
            }
        }
        return result;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    protected BriEDCWebSocketService getCommunicationService() {
        return this.communicationService;
    }

    @NotNull
    public TerminalResult transformJsonToResult(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ((BriTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)BriTerminalResult.Companion.serializer(), json)).toTerminalResult();
    }

    @NotNull
    public Map<String, JsonElement> prepareRequestPayload(@NotNull Action payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Object[] objectArray = new Pair[2];
        String string = IPAddresses_desktopKt.getDeviceIPAddress();
        objectArray[0] = string != null ? JsonKt.toJsonPrimitive((String)string, (String)"pos_address") : null;
        objectArray[1] = TuplesKt.to((Object)"time_stamp", (Object)JsonElementKt.JsonPrimitive((String)BRIActionKt.formatDateTime(TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)TimeZone.Companion.currentSystemDefault()))));
        Map baseData = MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        Map sendData = MapsKt.plus((Map)baseData, (Map)payload.getData());
        return sendData;
    }

    @Nullable
    public Result<TerminalResult> toResult(@NotNull TerminalDevice terminalDevice, @Nullable JsonElement json) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)terminalDevice, (String)"terminalDevice");
        JsonElement jsonElement = json;
        if (jsonElement != null) {
            Result result2;
            ErrorData error;
            JsonElement it = jsonElement;
            boolean bl = false;
            BriTerminalResult result3 = (BriTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)BriTerminalResult.Companion.serializer(), json);
            ErrorData errorData = error = ErrorMapperKt.toError(result3);
            if (errorData != null) {
                ErrorData it2 = errorData;
                boolean bl2 = false;
                result2 = (Result)new Result.Error((Object)result3, it2);
            } else {
                result2 = (Result)new Result.Success((Object)result3);
            }
            result = result2.map(BaseTerminalBRI::toResult$lambda$1);
        } else {
            result = null;
        }
        return result;
    }

    @Nullable
    public TerminalResult toTerminalResult(@Nullable TerminalDevice terminalDevice, @Nullable JsonElement json) {
        TerminalResult terminalResult;
        JsonElement jsonElement = json;
        if (jsonElement != null) {
            JsonElement it = jsonElement;
            boolean bl = false;
            terminalResult = ((BriTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)BriTerminalResult.Companion.serializer(), json)).toTerminalResult();
        } else {
            terminalResult = null;
        }
        return terminalResult;
    }

    @Nullable
    public GenericPaymentMethod toPaymentMethod(@NotNull String value) {
        GenericPaymentMethod genericPaymentMethod;
        Object v0;
        block7: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Iterable $this$firstOrNull$iv = (Iterable)ResponsePaymentMethod.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ResponsePaymentMethod paymentMethod = (ResponsePaymentMethod)((Object)element$iv);
                boolean bl = false;
                String it = paymentMethod.getValue();
                boolean bl2 = false;
                if (!StringsKt.contains((CharSequence)value, (CharSequence)it, (boolean)true)) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        ResponsePaymentMethod responsePaymentMethod = v0;
        if (responsePaymentMethod != null) {
            ResponsePaymentMethod it = responsePaymentMethod;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    genericPaymentMethod = GenericPaymentMethod.QR;
                    break;
                }
                case 2: {
                    genericPaymentMethod = GenericPaymentMethod.BRIZZI;
                    break;
                }
                default: {
                    genericPaymentMethod = GenericPaymentMethod.CARD;
                }
            }
        } else {
            genericPaymentMethod = null;
        }
        return genericPaymentMethod;
    }

    @NotNull
    public final List<String> getPaymentActions$id_bri() {
        return this.paymentActions;
    }

    @NotNull
    public final List<String> getVoidActions$id_bri() {
        return this.voidActions;
    }

    @NotNull
    public final List<String> getRefundActions$id_bri() {
        return this.refundActions;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Pair<String, JsonElement> toServicePayload(@NotNull JsonElement request, @NotNull JsonObject json, @NotNull Transactions transactions) {
        Pair pair;
        void $this$decodeFromJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)transactions, (String)"transactions");
        Json json2 = JsonKt.getXenJson();
        JsonElement json$iv = (JsonElement)json;
        boolean $i$f$decodeFromJsonElement = false;
        $this$decodeFromJsonElement$iv.getSerializersModule();
        BriTerminalResult response = (BriTerminalResult)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)BriTerminalResult.Companion.serializer(), json$iv);
        XLogger.Companion.debug("action: " + response.action + " status: " + response.status);
        if (response.action == BRITerminalAction.CHECK_TRX) {
            String string = transactions.getStatus().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!this.successStatuses.contains(string)) {
                return TuplesKt.to(null, null);
            }
        }
        if (transactions.getPaymentRequestId() != null) {
            return TuplesKt.to((Object)"CALLBACK", (Object)this.syncCallback(transactions, (JsonElement)json));
        }
        String string = transactions.getStatus().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!this.successStatuses.contains(string)) {
            return TuplesKt.to(null, null);
        }
        if (this.paymentActions.contains(transactions.getAction())) {
            pair = TuplesKt.to((Object)"PAYMENT", (Object)this.syncCallback(transactions, (JsonElement)json));
        } else if (Intrinsics.areEqual((Object)BRITerminalAction.CHECK_TRX.getValue(), (Object)transactions.getAction())) {
            pair = TuplesKt.to((Object)"PAYMENT", (Object)this.syncCallback(transactions, (JsonElement)json));
        } else if (this.refundActions.contains(transactions.getAction())) {
            pair = TuplesKt.to((Object)"VOID", (Object)this.syncCallback(transactions, (JsonElement)json));
        } else if (this.voidActions.contains(transactions.getAction())) {
            boolean bl;
            block15: {
                Object[] $this$decodeFromJsonElement$iv2;
                json$iv = JsonKt.getXenJson();
                JsonElement json$iv2 = (JsonElement)json;
                boolean $i$f$decodeFromJsonElement2 = false;
                $this$decodeFromJsonElement$iv2.getSerializersModule();
                BriTerminalResult result = (BriTerminalResult)$this$decodeFromJsonElement$iv2.decodeFromJsonElement((DeserializationStrategy)BriTerminalResult.Companion.serializer(), json$iv2);
                $this$decodeFromJsonElement$iv2 = new String[]{result.approval, result.referenceID};
                Iterable $this$all$iv = CollectionsKt.listOf((Object[])$this$decodeFromJsonElement$iv2);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it, (Object)"N/A")) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            pair = bl ? TuplesKt.to(null, null) : TuplesKt.to((Object)"VOID", (Object)this.syncCallback(transactions, (JsonElement)json));
        } else {
            pair = TuplesKt.to(null, null);
        }
        return pair;
    }

    private final JsonElement syncPaymentData(Transactions transactions, ResponsePaymentMethod method, BriTerminalResult response, double amount) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        boolean isQris = method == ResponsePaymentMethod.QRIS;
        String string7 = response.pan;
        if (string7 == null) {
            string7 = string6 = "";
        }
        if ((string5 = response.transactionID) == null) {
            string5 = "";
        }
        String string8 = string5;
        String string9 = this.toApiTransactionDate(response);
        String string10 = response.acqTid;
        if (string10 == null) {
            string10 = transactions.getTid();
        }
        String string11 = string10;
        boolean bl = Intrinsics.areEqual((Object)response.isCredit, (Object)"true");
        boolean bl2 = Intrinsics.areEqual((Object)response.isOffUs, (Object)"true");
        String string12 = response.message;
        if (string12 == null) {
            string12 = "";
        }
        String string13 = string12;
        String it = string4 = response.referenceID;
        boolean bl3 = false;
        String string14 = isQris ? string4 : null;
        if (string14 == null) {
            string14 = "";
        }
        String string15 = string14;
        String it2 = string3 = response.approval;
        boolean bl4 = false;
        String string16 = !isQris ? string3 : null;
        if (string16 == null) {
            string16 = "";
        }
        String string17 = string16;
        String it3 = string2 = response.batchNumber;
        boolean bl5 = false;
        String string18 = !isQris ? string2 : null;
        if (string18 == null) {
            string18 = "";
        }
        string4 = string18;
        it3 = string2 = response.cardName;
        boolean bl6 = false;
        string3 = !isQris ? string2 : null;
        String it4 = string = response.traceNumber;
        boolean bl7 = false;
        String string19 = !isQris ? string : null;
        if (string19 == null) {
            string19 = "";
        }
        string2 = string19;
        it4 = string = response.cardCategory;
        boolean bl8 = false;
        String string20 = !isQris ? string : null;
        String string21 = response.referenceNumber;
        if (string21 == null) {
            string21 = "";
        }
        string = string21;
        BRIPayload payload = new BRIPayload(string11, null, string9, string6, string3, string13, null, amount, string17, string4, string2, string15, null, null, amount, method, string20, bl, bl2, string8, string, 12354, null);
        return JsonKt.getXenJson().encodeToJsonElement((SerializationStrategy)BRIPayload.Companion.serializer(), (Object)payload);
    }

    private final JsonElement syncCallback(Transactions transactions, JsonElement response) {
        JsonElement normalizeResponse = response;
        if (!JsonElementKt.getJsonObject((JsonElement)response).containsKey((Object)"trx_id") || Intrinsics.areEqual((Object)JsonElementKt.getContentOrNull((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)JsonElementKt.getJsonObject((JsonElement)response)), (Object)"trx_id")))), (Object)"N/A")) {
            normalizeResponse = (JsonElement)this.updateJsonObjectValue(JsonElementKt.getJsonObject((JsonElement)normalizeResponse), "trx_id", (JsonElement)JsonElementKt.JsonPrimitive((String)transactions.getOrderId()));
        }
        return normalizeResponse;
    }

    @NotNull
    public final JsonObject updateJsonObjectValue(@NotNull JsonObject jsonObject, @NotNull String key, @NotNull JsonElement newValue) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$updateJsonObjectValue_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Map $this$forEach$iv = (Map)jsonObject;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            String k = (String)entry.getKey();
            JsonElement v = (JsonElement)entry.getValue();
            $this$updateJsonObjectValue_u24lambda_u240.put(k, v);
        }
        $this$updateJsonObjectValue_u24lambda_u240.put(key, newValue);
        return builder$iv.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String toApiTransactionDate(BriTerminalResult response) {
        String string = response.transactionDate;
        if (string == null) return "";
        String string2 = StringsKt.replace$default((String)string, (String)" ", (String)"T", (boolean)false, (int)4, null);
        if (string2 == null) return "";
        String it = string2;
        boolean bl = false;
        String string3 = it + BRIActionKt.toOffset$default(TimeZone.Companion.currentSystemDefault(), null, 1, null);
        if (string3 == null) return "";
        String string4 = string3;
        return string4;
    }

    @Nullable
    public TimeoutType getTimeoutType(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        String action2 = action.getPaymentMethod();
        XLogger.Companion.debug("[action] " + action2);
        return Intrinsics.areEqual((Object)action2, (Object)GenericPaymentMethod.QR.toString()) ? TimeoutType.QR : TimeoutType.CARD;
    }

    @NotNull
    protected BluetoothService getBluetooth() {
        return this.bluetooth;
    }

    @Nullable
    protected Action onPay(@NotNull Command command, @NotNull PayPayload data) {
        BRIAction.Payment payment;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = command.getOrderId();
        if (string != null) {
            Object object;
            String it = string;
            boolean bl = false;
            Object object2 = data.getPaymentMethods();
            if (object2 != null && (object2 = (String)CollectionsKt.firstOrNull((List)object2)) != null) {
                Object it2 = object2;
                boolean bl2 = false;
                v2 = StringsKt.startsWith$default((String)it2, (String)"ID_", (boolean)false, (int)2, null) ? it2 : "ID_" + (String)it2;
            } else {
                v2 = object = null;
            }
            if (Intrinsics.areEqual(object, (Object)ServicePaymentMethod.ID_INSERT_CARD.getValue())) {
                Number number = data.getRequestAmount();
                if (number == null) {
                    number = 0;
                }
                payment = new BRIAction.Sale<Number>(it, number, BRIPaymentMethod.INSERT_CARD);
            } else if (Intrinsics.areEqual(object, (Object)ServicePaymentMethod.ID_CONTACTLESS.getValue())) {
                Number number = data.getRequestAmount();
                if (number == null) {
                    number = 0;
                }
                payment = new BRIAction.Contactless<Number>(it, number);
            } else if (Intrinsics.areEqual((Object)object, (Object)ServicePaymentMethod.ID_BRIZZI.getValue())) {
                Number number = data.getRequestAmount();
                if (number == null) {
                    number = 0;
                }
                payment = new BRIAction.Sale<Number>(it, number, BRIPaymentMethod.BRIZZI);
            } else if (Intrinsics.areEqual((Object)object, (Object)ServicePaymentMethod.ID_QRIS.getValue())) {
                Number number = data.getRequestAmount();
                if (number == null) {
                    number = 0;
                }
                payment = new BRIAction.Sale<Number>(it, number, BRIPaymentMethod.QRIS);
            } else {
                Number number = data.getRequestAmount();
                if (number == null) {
                    number = 0;
                }
                payment = new BRIAction.Sale(it, number, null, 4, null);
            }
        } else {
            payment = null;
        }
        BRIAction.Payment action = payment;
        return action;
    }

    @Nullable
    protected Action onVoid(@NotNull Command command, @NotNull VoidPayload data) {
        String[] stringArray;
        Object object;
        Object saleMethod;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String traceNumber = data.getTransactionId();
        Object object2 = data.getPaymentMethod();
        if (object2 == null || (object2 = TerminalBRIKt.toSaleMethod(object2)) == null) {
            object2 = saleMethod = BRIPaymentMethod.NONE;
        }
        return traceNumber != null ? (Action)(saleMethod == BRIPaymentMethod.QRIS ? (BRIAction)new BRIAction.RefundQris(traceNumber, (BRIPaymentMethod)((Object)saleMethod)) : (BRIAction)new BRIAction.Void((object = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)traceNumber, (String[])(stringArray = new String[]{"|"}), (boolean)false, (int)0, (int)6, null))) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0, (BRIPaymentMethod)((Object)saleMethod))) : null;
    }

    @Nullable
    protected Action onSettlement(@NotNull Command command, @NotNull SettlementPayload data) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data.getPaymentMethod();
        if (object == null || (object = TerminalBRIKt.toSaleMethod(object)) == null) {
            object = BRIPaymentMethod.NONE;
        }
        Object method = object;
        return new BRIAction.Settlement((BRIPaymentMethod)((Object)method));
    }

    @Nullable
    public String terminalID(@Nullable JsonElement data) {
        String string;
        JsonElement jsonElement = data;
        if (jsonElement != null && (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) != null) {
            JsonElement it = jsonElement;
            boolean bl = false;
            JsonElement jsonElement2 = (JsonElement)it.get((Object)"acq_tid");
            string = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Object ping(@NotNull TerminalDevice device, @NotNull Continuation<? super Boolean> $completion) {
        return BaseTerminalBRI.ping$suspendImpl(this, device, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object ping$suspendImpl(BaseTerminalBRI $this, TerminalDevice device, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof ping.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BaseTerminalBRI this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseTerminalBRI.ping$suspendImpl(this.this$0, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)device);
                $continuation.label = 1;
                v0 = $this.getCommunicationService().connectWithMutex(device, ((Number)CollectionsKt.first(TerminalBRIKt.getBRI_PORTS())).intValue(), null, (Continuation)$continuation);
                ** if (v0 != var7_5) goto lbl20
lbl19:
                // 1 sources

                return var7_5;
lbl20:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                device = (TerminalDevice)$continuation.L$1;
                $this = (BaseTerminalBRI)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    result = (Result)v0;
                    v1 = result.getError();
                    return Boxing.boxBoolean((boolean)((v1 != null ? v1.code : null) == ErrorCode.DECLINED_BY_READER));
                }
                catch (RetryCancellationException e) {
                    return Boxing.boxBoolean((boolean)true);
                }
                catch (CancellationException e) {
                    return Boxing.boxBoolean((boolean)true);
                }
                catch (Exception e) {
                    return Boxing.boxBoolean((boolean)false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public List<TerminalAction> toActions(@Nullable CommandType commandType) {
        CommandType commandType2 = commandType;
        return switch (commandType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[commandType2.ordinal()]) {
            case 1 -> {
                BRITerminalAction[] var2_2 = new BRITerminalAction[]{BRITerminalAction.SALE, BRITerminalAction.CONTACTLESS, BRITerminalAction.CARD_VERIFICATION, BRITerminalAction.INSTALLMENT};
                yield CollectionsKt.listOf((Object[])var2_2);
            }
            case 2 -> {
                BRITerminalAction[] var2_3 = new BRITerminalAction[]{BRITerminalAction.VOID, BRITerminalAction.REFUND_QRIS};
                yield CollectionsKt.listOf((Object[])var2_3);
            }
            case 3 -> {
                BRITerminalAction[] var2_4 = new BRITerminalAction[]{BRITerminalAction.REPRINT_ANY, BRITerminalAction.REPRINT_LAST, BRITerminalAction.CHECK_STATUS};
                yield CollectionsKt.listOf((Object[])var2_4);
            }
            case 4 -> CollectionsKt.listOf((Object)((Object)BRITerminalAction.SETTLEMENT));
            case -1, 5, 6 -> CollectionsKt.emptyList();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public String createOrderID() {
        return ULID.Factory.nextULID$default((ULID.Factory)((ULID.Factory)ULID.Companion), (long)0L, (int)1, null).toString();
    }

    @NotNull
    protected Action onPrintReceipt(@NotNull Command command, @NotNull PrintReceiptPayload data) {
        Action action;
        Object method;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data.getPaymentMethod();
        if (object == null || (object = TerminalBRIKt.toSaleMethod(object)) == null) {
            object = BRIPaymentMethod.NONE;
        }
        if ((method = object) == BRIPaymentMethod.QRIS) {
            String string = data.getTransactionId();
            if (string == null) {
                string = "";
            }
            String string2 = string;
            action = new BRIAction.CheckStatus(null, string2, (BRIPaymentMethod)((Object)method), false, 9, null);
        } else if (data.getTransactionId() == null) {
            action = new BRIAction.ReprintLast((BRIPaymentMethod)((Object)method));
        } else {
            String[] stringArray;
            Object object2 = data.getTransactionId();
            int n = object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(stringArray = new String[]{"|"}), (boolean)false, (int)0, (int)6, null)) != null && (object2 = (String)CollectionsKt.firstOrNull((List)object2)) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
            action = new BRIAction.ReprintAny(n, (BRIPaymentMethod)((Object)method));
        }
        return action;
    }

    private static final boolean communicationService$lambda$0(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AppModule_desktopKt.getAppModule().retryRule(it);
    }

    private static final HttpClient communicationService$lambda$1() {
        return AppModule.wssClient$default((AppModule)AppModule_desktopKt.getAppModule(), null, (int)1, null);
    }

    private static final TerminalResult toResult$lambda$1(BriTerminalResult it) {
        BriTerminalResult briTerminalResult = it;
        return briTerminalResult != null ? briTerminalResult.toTerminalResult() : null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ResponsePaymentMethod.values().length];
            try {
                nArray[ResponsePaymentMethod.QRIS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponsePaymentMethod.BRIZZI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CommandType.values().length];
            try {
                nArray[CommandType.PAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandType.VOID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandType.PRINT_RECEIPT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandType.SETTLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandType.REFUND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandType.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

