/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.ntt.data;

import co.xendit.terminal.core.util.XLogger;
import co.xendit.terminal.ntt.TerminalNTT;
import co.xendit.terminal.ntt.data.NTTAction;
import co.xendit.terminal.ntt.data.NTTPaymentMethod;
import co.xendit.terminal.ntt.data.ServiceType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\u000bB!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lco/xendit/terminal/ntt/data/PaymentIntentParametersBuilder;", "", "amount", "", "<init>", "(D)V", "orderID", "", "(Ljava/lang/String;D)V", "tradeType", "Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "(DLco/xendit/terminal/ntt/data/NTTPaymentMethod;)V", "(Ljava/lang/String;DLco/xendit/terminal/ntt/data/NTTPaymentMethod;)V", "serviceType", "Lco/xendit/terminal/ntt/data/ServiceType;", "showQR", "scanQR", "build", "Lco/xendit/terminal/ntt/data/NTTAction$Payment;", "th-ntt"})
public final class PaymentIntentParametersBuilder {
    @NotNull
    private final String orderID;
    private final double amount;
    @NotNull
    private final NTTPaymentMethod tradeType;
    @Nullable
    private ServiceType serviceType;

    public PaymentIntentParametersBuilder(double amount) {
        this.orderID = TerminalNTT.INSTANCE.createOrderID();
        this.amount = amount;
        this.tradeType = NTTPaymentMethod.CARD;
    }

    public PaymentIntentParametersBuilder(@NotNull String orderID, double amount) {
        Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
        this.orderID = orderID;
        this.amount = amount;
        this.tradeType = NTTPaymentMethod.CARD;
    }

    public PaymentIntentParametersBuilder(double amount, @NotNull NTTPaymentMethod tradeType) {
        Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
        this.orderID = TerminalNTT.INSTANCE.createOrderID();
        this.amount = amount;
        this.tradeType = tradeType;
    }

    public PaymentIntentParametersBuilder(@NotNull String orderID, double amount, @NotNull NTTPaymentMethod tradeType) {
        Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
        Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
        this.orderID = orderID;
        this.amount = amount;
        this.tradeType = tradeType;
    }

    @NotNull
    public final PaymentIntentParametersBuilder showQR() {
        boolean it = this.tradeType.getCapabilities().getSupportsShowQr();
        boolean bl = false;
        if (it) {
            this.serviceType = ServiceType.SHOWQR;
        }
        return this;
    }

    @NotNull
    public final PaymentIntentParametersBuilder scanQR() {
        boolean it = this.tradeType.getCapabilities().getSupportsScan();
        boolean bl = false;
        if (it) {
            this.serviceType = ServiceType.SCAN;
        }
        return this;
    }

    @NotNull
    public final NTTAction.Payment build() {
        XLogger.Companion.info("Transaction ID: " + this.orderID);
        return new NTTAction.Sale(this.orderID, this.amount, this.tradeType, this.serviceType);
    }
}

