/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.ntt.data;

import co.xendit.terminal.core.data.Action;
import co.xendit.terminal.core.data.TerminalAction;
import co.xendit.terminal.core.util.JsonKt;
import co.xendit.terminal.ntt.data.NTTPaymentMethod;
import co.xendit.terminal.ntt.data.NTTTransactionType;
import co.xendit.terminal.ntt.data.ServiceType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000f2\u00020\u0001:\b\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016B\u001f\b\u0004\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001c\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001c\u0010\f\u001a\u00020\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u0082\u0001\u0006\u0017\u0018\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction;", "Lco/xendit/terminal/core/data/Action;", "data", "", "", "Lkotlinx/serialization/json/JsonElement;", "<init>", "(Ljava/util/Map;)V", "getTransactionAmount", "", "getTransactionOrderID", "getPaymentMethod", "getServicePaymentMethod", "getTerminalAction", "Lco/xendit/terminal/core/data/TerminalAction;", "Companion", "Payment", "Sale", "PreAuthorization", "SaleCompletion", "Installment", "CheckStatus", "Void", "Lco/xendit/terminal/ntt/data/NTTAction$CheckStatus;", "Lco/xendit/terminal/ntt/data/NTTAction$Installment;", "Lco/xendit/terminal/ntt/data/NTTAction$Payment;", "Lco/xendit/terminal/ntt/data/NTTAction$PreAuthorization;", "Lco/xendit/terminal/ntt/data/NTTAction$SaleCompletion;", "Lco/xendit/terminal/ntt/data/NTTAction$Void;", "th-ntt"})
@SourceDebugExtension(value={"SMAP\nNTTAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NTTAction.kt\nco/xendit/terminal/ntt/data/NTTAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,352:1\n1#2:353\n295#3,2:354\n*S KotlinDebug\n*F\n+ 1 NTTAction.kt\nco/xendit/terminal/ntt/data/NTTAction\n*L\n56#1:354,2\n*E\n"})
public abstract class NTTAction
extends Action {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String AMOUNT = "amount";
    @NotNull
    public static final String TRANSACTION_TYPE = "transaction_type";
    @NotNull
    public static final String POS_REF_NO = "pos_ref_no";
    @NotNull
    public static final String TRADE_TYPE = "trade_type";
    @NotNull
    public static final String INVOICE_NO = "invoice_no";
    @NotNull
    public static final String SERVICE_TYPE = "service_type";

    private NTTAction(Map<String, ? extends JsonElement> data) {
        super(data);
    }

    public /* synthetic */ NTTAction(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = MapsKt.emptyMap();
        }
        this(map, null);
    }

    public double getTransactionAmount(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = data.get(AMOUNT);
        return object != null && (object = object.toString()) != null && (object = StringsKt.toDoubleOrNull((String)object)) != null ? (Double)object : 0.0;
    }

    @Nullable
    public String getTransactionOrderID(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        JsonElement jsonElement = data.get(POS_REF_NO);
        return jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement) : null;
    }

    @NotNull
    public String getPaymentMethod(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        String it = this.getServicePaymentMethod(data);
        boolean bl = false;
        NTTPaymentMethod nTTPaymentMethod = NTTPaymentMethod.Companion.toEnum(it);
        return String.valueOf(nTTPaymentMethod != null ? nTTPaymentMethod.toPaymentMethod() : null);
    }

    @NotNull
    public String getServicePaymentMethod(@NotNull Map<String, ? extends JsonElement> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object object = data.get(TRADE_TYPE);
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) {
            object = NTTPaymentMethod.CARD.getValue();
        }
        return object;
    }

    @Nullable
    public TerminalAction getTerminalAction(@NotNull Map<String, ? extends JsonElement> data) {
        NTTTransactionType nTTTransactionType;
        String string;
        JsonPrimitive jsonPrimitive;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        JsonElement jsonElement = data.get(TRANSACTION_TYPE);
        if (jsonElement != null && (jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null && (string = JsonElementKt.getContentOrNull((JsonPrimitive)jsonPrimitive)) != null) {
            Object v0;
            block3: {
                String it = string;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = (Iterable)NTTTransactionType.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NTTTransactionType type = (NTTTransactionType)((Object)element$iv);
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)type.getValue(), (Object)it)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            nTTTransactionType = v0;
        } else {
            nTTTransactionType = null;
        }
        return nTTTransactionType;
    }

    public /* synthetic */ NTTAction(Map data, DefaultConstructorMarker $constructor_marker) {
        this(data);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$CheckStatus;", "Lco/xendit/terminal/ntt/data/NTTAction;", "orderID", "", "invoiceNo", "tradeType", "Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lco/xendit/terminal/ntt/data/NTTPaymentMethod;)V", "getOrderID", "()Ljava/lang/String;", "getInvoiceNo", "getTradeType", "()Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "th-ntt"})
    public static final class CheckStatus
    extends NTTAction {
        @NotNull
        private final String orderID;
        @Nullable
        private final String invoiceNo;
        @NotNull
        private final NTTPaymentMethod tradeType;

        public CheckStatus(@NotNull String orderID, @Nullable String invoiceNo, @NotNull NTTPaymentMethod tradeType) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
            CheckStatus checkStatus = this;
            Object[] objectArray = new Pair[4];
            objectArray[0] = TuplesKt.to((Object)NTTAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID));
            objectArray[1] = TuplesKt.to((Object)NTTAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)NTTTransactionType.QUERY.getValue()));
            Object[] objectArray2 = objectArray;
            int n = 2;
            String string = invoiceNo;
            if (string != null) {
                String string2 = string;
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                CheckStatus checkStatus2 = checkStatus;
                boolean bl = false;
                Pair pair2 = TuplesKt.to((Object)NTTAction.INVOICE_NO, (Object)JsonElementKt.JsonPrimitive((String)invoiceNo));
                checkStatus = checkStatus2;
                objectArray2 = objectArray3;
                n = n2;
                pair = pair2;
            } else {
                pair = null;
            }
            objectArray2[n] = pair;
            objectArray[3] = JsonKt.toJsonPrimitive((String)tradeType.getValue(), (String)NTTAction.TRADE_TYPE);
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.invoiceNo = invoiceNo;
            this.tradeType = tradeType;
        }

        public /* synthetic */ CheckStatus(String string, String string2, NTTPaymentMethod nTTPaymentMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                nTTPaymentMethod = NTTPaymentMethod.CARD;
            }
            this(string, string2, nTTPaymentMethod);
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        @Nullable
        public final String getInvoiceNo() {
            return this.invoiceNo;
        }

        @NotNull
        public final NTTPaymentMethod getTradeType() {
            return this.tradeType;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        @Nullable
        public final String component2() {
            return this.invoiceNo;
        }

        @NotNull
        public final NTTPaymentMethod component3() {
            return this.tradeType;
        }

        @NotNull
        public final CheckStatus copy(@NotNull String orderID, @Nullable String invoiceNo, @NotNull NTTPaymentMethod tradeType) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
            return new CheckStatus(orderID, invoiceNo, tradeType);
        }

        public static /* synthetic */ CheckStatus copy$default(CheckStatus checkStatus, String string, String string2, NTTPaymentMethod nTTPaymentMethod, int n, Object object) {
            if ((n & 1) != 0) {
                string = checkStatus.orderID;
            }
            if ((n & 2) != 0) {
                string2 = checkStatus.invoiceNo;
            }
            if ((n & 4) != 0) {
                nTTPaymentMethod = checkStatus.tradeType;
            }
            return checkStatus.copy(string, string2, nTTPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "CheckStatus(orderID=" + this.orderID + ", invoiceNo=" + this.invoiceNo + ", tradeType=" + this.tradeType + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + (this.invoiceNo == null ? 0 : this.invoiceNo.hashCode());
            result = result * 31 + this.tradeType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CheckStatus)) {
                return false;
            }
            CheckStatus checkStatus = (CheckStatus)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)checkStatus.orderID)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.invoiceNo, (Object)checkStatus.invoiceNo)) {
                return false;
            }
            return this.tradeType == checkStatus.tradeType;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$Companion;", "", "<init>", "()V", "AMOUNT", "", "TRANSACTION_TYPE", "POS_REF_NO", "TRADE_TYPE", "INVOICE_NO", "SERVICE_TYPE", "th-ntt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$Installment;", "Lco/xendit/terminal/ntt/data/NTTAction;", "orderID", "", "amount", "", "<init>", "(Ljava/lang/String;D)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()D", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "th-ntt"})
    public static final class Installment
    extends NTTAction {
        @NotNull
        private final String orderID;
        private final double amount;

        public Installment(@NotNull String orderID, double amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)NTTAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive((Number)amount)), TuplesKt.to((Object)NTTAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)NTTTransactionType.SALE.getValue())), TuplesKt.to((Object)NTTAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID)), JsonKt.toJsonPrimitive((String)NTTPaymentMethod.MULTIIPP.getValue(), (String)NTTAction.TRADE_TYPE)};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.amount = amount;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        public final double getAmount() {
            return this.amount;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        public final double component2() {
            return this.amount;
        }

        @NotNull
        public final Installment copy(@NotNull String orderID, double amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            return new Installment(orderID, amount);
        }

        public static /* synthetic */ Installment copy$default(Installment installment, String string, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = installment.orderID;
            }
            if ((n & 2) != 0) {
                d = installment.amount;
            }
            return installment.copy(string, d);
        }

        @NotNull
        public String toString() {
            return "Installment(orderID=" + this.orderID + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + Double.hashCode(this.amount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Installment)) {
                return false;
            }
            Installment installment = (Installment)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)installment.orderID)) {
                return false;
            }
            return Double.compare(this.amount, installment.amount) == 0;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B-\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000b\u0082\u0001\u0001\f\u00a8\u0006\r"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$Payment;", "Lco/xendit/terminal/ntt/data/NTTAction;", "orderID", "", "amount", "", "tradeType", "Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "serviceType", "Lco/xendit/terminal/ntt/data/ServiceType;", "<init>", "(Ljava/lang/String;DLco/xendit/terminal/ntt/data/NTTPaymentMethod;Lco/xendit/terminal/ntt/data/ServiceType;)V", "Lco/xendit/terminal/ntt/data/NTTAction$Sale;", "th-ntt"})
    public static abstract class Payment
    extends NTTAction {
        private Payment(String orderID, double amount, NTTPaymentMethod tradeType, ServiceType serviceType) {
            Object object;
            Object object2;
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)NTTAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive((Number)amount)), TuplesKt.to((Object)NTTAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)"SALE")), TuplesKt.to((Object)NTTAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID)), (object2 = tradeType) != null && (object2 = object2.getValue()) != null ? JsonKt.toJsonPrimitive((String)object2, (String)NTTAction.TRADE_TYPE) : null, (object = serviceType) != null && (object = object.name()) != null ? JsonKt.toJsonPrimitive((String)object, (String)NTTAction.SERVICE_TYPE) : null};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
        }

        public /* synthetic */ Payment(String orderID, double amount, NTTPaymentMethod tradeType, ServiceType serviceType, DefaultConstructorMarker $constructor_marker) {
            this(orderID, amount, tradeType, serviceType);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$PreAuthorization;", "Lco/xendit/terminal/ntt/data/NTTAction;", "orderID", "", "tradeType", "Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "amount", "", "<init>", "(Ljava/lang/String;Lco/xendit/terminal/ntt/data/NTTPaymentMethod;D)V", "getOrderID", "()Ljava/lang/String;", "getTradeType", "()Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "getAmount", "()D", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "th-ntt"})
    public static final class PreAuthorization
    extends NTTAction {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String orderID;
        @NotNull
        private final NTTPaymentMethod tradeType;
        private final double amount;

        public PreAuthorization(@NotNull String orderID, @NotNull NTTPaymentMethod tradeType, double amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)NTTAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive((Number)amount)), TuplesKt.to((Object)NTTAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)NTTTransactionType.PREAUTH.getValue())), TuplesKt.to((Object)NTTAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID)), JsonKt.toJsonPrimitive((String)tradeType.getValue(), (String)NTTAction.TRADE_TYPE)};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.tradeType = tradeType;
            this.amount = amount;
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        @NotNull
        public final NTTPaymentMethod getTradeType() {
            return this.tradeType;
        }

        public final double getAmount() {
            return this.amount;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        @NotNull
        public final NTTPaymentMethod component2() {
            return this.tradeType;
        }

        public final double component3() {
            return this.amount;
        }

        @NotNull
        public final PreAuthorization copy(@NotNull String orderID, @NotNull NTTPaymentMethod tradeType, double amount) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
            return new PreAuthorization(orderID, tradeType, amount);
        }

        public static /* synthetic */ PreAuthorization copy$default(PreAuthorization preAuthorization, String string, NTTPaymentMethod nTTPaymentMethod, double d, int n, Object object) {
            if ((n & 1) != 0) {
                string = preAuthorization.orderID;
            }
            if ((n & 2) != 0) {
                nTTPaymentMethod = preAuthorization.tradeType;
            }
            if ((n & 4) != 0) {
                d = preAuthorization.amount;
            }
            return preAuthorization.copy(string, nTTPaymentMethod, d);
        }

        @NotNull
        public String toString() {
            return "PreAuthorization(orderID=" + this.orderID + ", tradeType=" + this.tradeType + ", amount=" + this.amount + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + this.tradeType.hashCode();
            result = result * 31 + Double.hashCode(this.amount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreAuthorization)) {
                return false;
            }
            PreAuthorization preAuthorization = (PreAuthorization)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)preAuthorization.orderID)) {
                return false;
            }
            if (this.tradeType != preAuthorization.tradeType) {
                return false;
            }
            return Double.compare(this.amount, preAuthorization.amount) == 0;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$PreAuthorization$Companion;", "", "<init>", "()V", "fromPayment", "Lco/xendit/terminal/ntt/data/NTTAction$PreAuthorization;", "payment", "Lco/xendit/terminal/ntt/data/NTTAction$Payment;", "th-ntt"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PreAuthorization fromPayment(@NotNull Payment payment) {
                NTTPaymentMethod nTTPaymentMethod;
                double d;
                Intrinsics.checkNotNullParameter((Object)((Object)payment), (String)"payment");
                Object object = (JsonElement)payment.getData().get(NTTAction.POS_REF_NO);
                if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
                    object = "";
                }
                Object object2 = object;
                Object object3 = (JsonElement)payment.getData().get(NTTAction.AMOUNT);
                double d2 = d = object3 != null && (object3 = JsonElementKt.getJsonPrimitive((JsonElement)object3)) != null && (object3 = JsonElementKt.getDoubleOrNull((JsonPrimitive)object3)) != null ? (Double)object3 : 0.0;
                Object object4 = (JsonElement)payment.getData().get(NTTAction.TRADE_TYPE);
                if (object4 == null || (object4 = JsonElementKt.getJsonPrimitive((JsonElement)object4)) == null || (object4 = JsonElementKt.getContentOrNull((JsonPrimitive)object4)) == null) {
                    object4 = "";
                }
                if ((nTTPaymentMethod = NTTPaymentMethod.Companion.toEnum((String)object4)) == null) {
                    nTTPaymentMethod = NTTPaymentMethod.CARD;
                }
                NTTPaymentMethod nTTPaymentMethod2 = nTTPaymentMethod;
                return new PreAuthorization((String)object2, nTTPaymentMethod2, d);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J5\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$Sale;", "Lco/xendit/terminal/ntt/data/NTTAction$Payment;", "orderID", "", "amount", "", "tradeType", "Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "serviceType", "Lco/xendit/terminal/ntt/data/ServiceType;", "<init>", "(Ljava/lang/String;DLco/xendit/terminal/ntt/data/NTTPaymentMethod;Lco/xendit/terminal/ntt/data/ServiceType;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()D", "getTradeType", "()Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "getServiceType", "()Lco/xendit/terminal/ntt/data/ServiceType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "th-ntt"})
    public static final class Sale
    extends Payment {
        @NotNull
        private final String orderID;
        private final double amount;
        @Nullable
        private final NTTPaymentMethod tradeType;
        @Nullable
        private final ServiceType serviceType;

        public Sale(@NotNull String orderID, double amount, @Nullable NTTPaymentMethod tradeType, @Nullable ServiceType serviceType) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            super(orderID, amount, tradeType, serviceType, null);
            this.orderID = orderID;
            this.amount = amount;
            this.tradeType = tradeType;
            this.serviceType = serviceType;
        }

        public /* synthetic */ Sale(String string, double d, NTTPaymentMethod nTTPaymentMethod, ServiceType serviceType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                nTTPaymentMethod = null;
            }
            this(string, d, nTTPaymentMethod, serviceType);
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        public final double getAmount() {
            return this.amount;
        }

        @Nullable
        public final NTTPaymentMethod getTradeType() {
            return this.tradeType;
        }

        @Nullable
        public final ServiceType getServiceType() {
            return this.serviceType;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        public final double component2() {
            return this.amount;
        }

        @Nullable
        public final NTTPaymentMethod component3() {
            return this.tradeType;
        }

        @Nullable
        public final ServiceType component4() {
            return this.serviceType;
        }

        @NotNull
        public final Sale copy(@NotNull String orderID, double amount, @Nullable NTTPaymentMethod tradeType, @Nullable ServiceType serviceType) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            return new Sale(orderID, amount, tradeType, serviceType);
        }

        public static /* synthetic */ Sale copy$default(Sale sale, String string, double d, NTTPaymentMethod nTTPaymentMethod, ServiceType serviceType, int n, Object object) {
            if ((n & 1) != 0) {
                string = sale.orderID;
            }
            if ((n & 2) != 0) {
                d = sale.amount;
            }
            if ((n & 4) != 0) {
                nTTPaymentMethod = sale.tradeType;
            }
            if ((n & 8) != 0) {
                serviceType = sale.serviceType;
            }
            return sale.copy(string, d, nTTPaymentMethod, serviceType);
        }

        @NotNull
        public String toString() {
            return "Sale(orderID=" + this.orderID + ", amount=" + this.amount + ", tradeType=" + this.tradeType + ", serviceType=" + this.serviceType + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + Double.hashCode(this.amount);
            result = result * 31 + (this.tradeType == null ? 0 : this.tradeType.hashCode());
            result = result * 31 + (this.serviceType == null ? 0 : this.serviceType.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Sale)) {
                return false;
            }
            Sale sale = (Sale)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)sale.orderID)) {
                return false;
            }
            if (Double.compare(this.amount, sale.amount) != 0) {
                return false;
            }
            if (this.tradeType != sale.tradeType) {
                return false;
            }
            return this.serviceType == sale.serviceType;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$SaleCompletion;", "Lco/xendit/terminal/ntt/data/NTTAction;", "orderID", "", "amount", "", "invoiceNo", "tradeType", "Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "<init>", "(Ljava/lang/String;DLjava/lang/String;Lco/xendit/terminal/ntt/data/NTTPaymentMethod;)V", "getOrderID", "()Ljava/lang/String;", "getAmount", "()D", "getInvoiceNo", "getTradeType", "()Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "th-ntt"})
    public static final class SaleCompletion
    extends NTTAction {
        @NotNull
        private final String orderID;
        private final double amount;
        @NotNull
        private final String invoiceNo;
        @NotNull
        private final NTTPaymentMethod tradeType;

        public SaleCompletion(@NotNull String orderID, double amount, @NotNull String invoiceNo, @NotNull NTTPaymentMethod tradeType) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter((Object)invoiceNo, (String)"invoiceNo");
            Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)NTTAction.AMOUNT, (Object)JsonElementKt.JsonPrimitive((Number)amount)), TuplesKt.to((Object)NTTAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)NTTTransactionType.PRECOMP.getValue())), TuplesKt.to((Object)NTTAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID)), TuplesKt.to((Object)NTTAction.INVOICE_NO, (Object)JsonElementKt.JsonPrimitive((String)invoiceNo)), JsonKt.toJsonPrimitive((String)tradeType.getValue(), (String)NTTAction.TRADE_TYPE)};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.amount = amount;
            this.invoiceNo = invoiceNo;
            this.tradeType = tradeType;
        }

        public /* synthetic */ SaleCompletion(String string, double d, String string2, NTTPaymentMethod nTTPaymentMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                nTTPaymentMethod = NTTPaymentMethod.CARD;
            }
            this(string, d, string2, nTTPaymentMethod);
        }

        @NotNull
        public final String getOrderID() {
            return this.orderID;
        }

        public final double getAmount() {
            return this.amount;
        }

        @NotNull
        public final String getInvoiceNo() {
            return this.invoiceNo;
        }

        @NotNull
        public final NTTPaymentMethod getTradeType() {
            return this.tradeType;
        }

        @NotNull
        public final String component1() {
            return this.orderID;
        }

        public final double component2() {
            return this.amount;
        }

        @NotNull
        public final String component3() {
            return this.invoiceNo;
        }

        @NotNull
        public final NTTPaymentMethod component4() {
            return this.tradeType;
        }

        @NotNull
        public final SaleCompletion copy(@NotNull String orderID, double amount, @NotNull String invoiceNo, @NotNull NTTPaymentMethod tradeType) {
            Intrinsics.checkNotNullParameter((Object)orderID, (String)"orderID");
            Intrinsics.checkNotNullParameter((Object)invoiceNo, (String)"invoiceNo");
            Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
            return new SaleCompletion(orderID, amount, invoiceNo, tradeType);
        }

        public static /* synthetic */ SaleCompletion copy$default(SaleCompletion saleCompletion, String string, double d, String string2, NTTPaymentMethod nTTPaymentMethod, int n, Object object) {
            if ((n & 1) != 0) {
                string = saleCompletion.orderID;
            }
            if ((n & 2) != 0) {
                d = saleCompletion.amount;
            }
            if ((n & 4) != 0) {
                string2 = saleCompletion.invoiceNo;
            }
            if ((n & 8) != 0) {
                nTTPaymentMethod = saleCompletion.tradeType;
            }
            return saleCompletion.copy(string, d, string2, nTTPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "SaleCompletion(orderID=" + this.orderID + ", amount=" + this.amount + ", invoiceNo=" + this.invoiceNo + ", tradeType=" + this.tradeType + ")";
        }

        public int hashCode() {
            int result = this.orderID.hashCode();
            result = result * 31 + Double.hashCode(this.amount);
            result = result * 31 + this.invoiceNo.hashCode();
            result = result * 31 + this.tradeType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SaleCompletion)) {
                return false;
            }
            SaleCompletion saleCompletion = (SaleCompletion)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)saleCompletion.orderID)) {
                return false;
            }
            if (Double.compare(this.amount, saleCompletion.amount) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.invoiceNo, (Object)saleCompletion.invoiceNo)) {
                return false;
            }
            return this.tradeType == saleCompletion.tradeType;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lco/xendit/terminal/ntt/data/NTTAction$Void;", "Lco/xendit/terminal/ntt/data/NTTAction;", "orderID", "", "invoiceNo", "tradeType", "Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lco/xendit/terminal/ntt/data/NTTPaymentMethod;)V", "getOrderID", "()Ljava/lang/String;", "getInvoiceNo", "getTradeType", "()Lco/xendit/terminal/ntt/data/NTTPaymentMethod;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "th-ntt"})
    public static final class Void
    extends NTTAction {
        @Nullable
        private final String orderID;
        @NotNull
        private final String invoiceNo;
        @NotNull
        private final NTTPaymentMethod tradeType;

        public Void(@Nullable String orderID, @NotNull String invoiceNo, @NotNull NTTPaymentMethod tradeType) {
            Intrinsics.checkNotNullParameter((Object)invoiceNo, (String)"invoiceNo");
            Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)NTTAction.POS_REF_NO, (Object)JsonElementKt.JsonPrimitive((String)orderID)), TuplesKt.to((Object)NTTAction.TRANSACTION_TYPE, (Object)JsonElementKt.JsonPrimitive((String)NTTTransactionType.VOID.getValue())), TuplesKt.to((Object)NTTAction.INVOICE_NO, (Object)JsonElementKt.JsonPrimitive((String)invoiceNo)), TuplesKt.to((Object)NTTAction.TRADE_TYPE, (Object)JsonElementKt.JsonPrimitive((String)tradeType.getValue()))};
            super(MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), null);
            this.orderID = orderID;
            this.invoiceNo = invoiceNo;
            this.tradeType = tradeType;
        }

        @Nullable
        public final String getOrderID() {
            return this.orderID;
        }

        @NotNull
        public final String getInvoiceNo() {
            return this.invoiceNo;
        }

        @NotNull
        public final NTTPaymentMethod getTradeType() {
            return this.tradeType;
        }

        @Nullable
        public final String component1() {
            return this.orderID;
        }

        @NotNull
        public final String component2() {
            return this.invoiceNo;
        }

        @NotNull
        public final NTTPaymentMethod component3() {
            return this.tradeType;
        }

        @NotNull
        public final Void copy(@Nullable String orderID, @NotNull String invoiceNo, @NotNull NTTPaymentMethod tradeType) {
            Intrinsics.checkNotNullParameter((Object)invoiceNo, (String)"invoiceNo");
            Intrinsics.checkNotNullParameter((Object)((Object)tradeType), (String)"tradeType");
            return new Void(orderID, invoiceNo, tradeType);
        }

        public static /* synthetic */ Void copy$default(Void void_, String string, String string2, NTTPaymentMethod nTTPaymentMethod, int n, Object object) {
            if ((n & 1) != 0) {
                string = void_.orderID;
            }
            if ((n & 2) != 0) {
                string2 = void_.invoiceNo;
            }
            if ((n & 4) != 0) {
                nTTPaymentMethod = void_.tradeType;
            }
            return void_.copy(string, string2, nTTPaymentMethod);
        }

        @NotNull
        public String toString() {
            return "Void(orderID=" + this.orderID + ", invoiceNo=" + this.invoiceNo + ", tradeType=" + this.tradeType + ")";
        }

        public int hashCode() {
            int result = this.orderID == null ? 0 : this.orderID.hashCode();
            result = result * 31 + this.invoiceNo.hashCode();
            result = result * 31 + this.tradeType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Void)) {
                return false;
            }
            Void void_ = (Void)((Object)other);
            if (!Intrinsics.areEqual((Object)this.orderID, (Object)void_.orderID)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.invoiceNo, (Object)void_.invoiceNo)) {
                return false;
            }
            return this.tradeType == void_.tradeType;
        }
    }
}

