/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.ntt;

import co.xendit.terminal.core.TerminalOperation;
import co.xendit.terminal.core.data.Action;
import co.xendit.terminal.core.data.ErrorCode;
import co.xendit.terminal.core.data.GenericPaymentMethod;
import co.xendit.terminal.core.data.Result;
import co.xendit.terminal.core.data.TerminalAction;
import co.xendit.terminal.core.data.TerminalDevice;
import co.xendit.terminal.core.data.TerminalProvider;
import co.xendit.terminal.core.data.TerminalResult;
import co.xendit.terminal.core.data.Transactions;
import co.xendit.terminal.core.data.response.Command;
import co.xendit.terminal.core.data.response.CommandType;
import co.xendit.terminal.core.data.response.PayPayload;
import co.xendit.terminal.core.data.response.PrintReceiptPayload;
import co.xendit.terminal.core.data.response.SettlementPayload;
import co.xendit.terminal.core.data.response.VoidPayload;
import co.xendit.terminal.core.di.AppModule;
import co.xendit.terminal.core.di.AppModule_desktopKt;
import co.xendit.terminal.core.util.JsonKt;
import co.xendit.terminal.core.util.XLogger;
import co.xendit.terminal.ntt.BaseTerminalNTT;
import co.xendit.terminal.ntt.TerminalNTTKt;
import co.xendit.terminal.ntt.data.NTTAction;
import co.xendit.terminal.ntt.data.NTTPaymentMethod;
import co.xendit.terminal.ntt.data.NTTTerminalResult;
import co.xendit.terminal.ntt.data.NTTTransactionType;
import co.xendit.terminal.ntt.service.NTTWebSocketService;
import io.ktor.client.HttpClient;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalDateTimeKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.UnicodeKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J0\u0010$\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00160%2\u0006\u0010&\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0016H\u0002J\u001a\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0014J\u001a\u0010:\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020;H\u0014J\u001a\u0010<\u001a\u0004\u0018\u00010\u00072\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020=H\u0014J\u001a\u0010>\u001a\u0004\u0018\u00010\u00072\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020?H\u0014J\u0014\u0010@\u001a\u0004\u0018\u00010\u000b2\b\u00108\u001a\u0004\u0018\u00010\u0016H\u0016J\u0016\u0010A\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010BJ\u0018\u0010C\u001a\b\u0012\u0004\u0012\u00020D0!2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016J\b\u0010G\u001a\u00020\u000bH\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\u0004\u0018\u00010\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lco/xendit/terminal/ntt/BaseTerminalNTT;", "Lco/xendit/terminal/core/TerminalOperation;", "<init>", "()V", "onRefresh", "", "payload", "Lco/xendit/terminal/core/data/Action;", "device", "Lco/xendit/terminal/core/data/TerminalDevice;", "paymentRequestId", "", "isSimulation", "", "(Lco/xendit/terminal/core/data/Action;Lco/xendit/terminal/core/data/TerminalDevice;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "communicationService", "Lco/xendit/terminal/ntt/service/NTTWebSocketService;", "getCommunicationService", "()Lco/xendit/terminal/ntt/service/NTTWebSocketService;", "transformJsonToResult", "Lco/xendit/terminal/core/data/TerminalResult;", "json", "Lkotlinx/serialization/json/JsonElement;", "prepareRequestPayload", "", "toResult", "Lco/xendit/terminal/core/data/Result;", "terminalDevice", "toTerminalResult", "toPaymentMethod", "Lco/xendit/terminal/core/data/GenericPaymentMethod;", "value", "paymentActions", "", "voidActions", "refundActions", "toServicePayload", "Lkotlin/Pair;", "request", "Lkotlinx/serialization/json/JsonObject;", "transactions", "Lco/xendit/terminal/core/data/Transactions;", "syncPaymentData", "response", "Lco/xendit/terminal/ntt/data/NTTTerminalResult;", "syncVoidData", "syncCallback", "paymentRequestID", "bluetooth", "getBluetooth", "()Ljava/lang/Void;", "successStatuses", "onVoid", "Lco/xendit/terminal/ntt/data/NTTAction;", "command", "Lco/xendit/terminal/core/data/response/Command;", "data", "Lco/xendit/terminal/core/data/response/VoidPayload;", "onPay", "Lco/xendit/terminal/core/data/response/PayPayload;", "onPrintReceipt", "Lco/xendit/terminal/core/data/response/PrintReceiptPayload;", "onSettlement", "Lco/xendit/terminal/core/data/response/SettlementPayload;", "terminalID", "ping", "(Lco/xendit/terminal/core/data/TerminalDevice;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toActions", "Lco/xendit/terminal/core/data/TerminalAction;", "commandType", "Lco/xendit/terminal/core/data/response/CommandType;", "createOrderID", "th-ntt"})
@SourceDebugExtension(value={"SMAP\nTerminalNTT.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalNTT.kt\nco/xendit/terminal/ntt/BaseTerminalNTT\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n335#2:282\n1761#3,3:283\n1#4:286\n*S KotlinDebug\n*F\n+ 1 TerminalNTT.kt\nco/xendit/terminal/ntt/BaseTerminalNTT\n*L\n146#1:282\n150#1:283,3\n*E\n"})
public class BaseTerminalNTT
extends TerminalOperation {
    @NotNull
    private final NTTWebSocketService communicationService = new NTTWebSocketService((MutableStateFlow<Result<JsonElement>>)this.getResultFlow(), (Function1<? super Exception, Boolean>)((Function1)BaseTerminalNTT::communicationService$lambda$0), (Function0<HttpClient>)((Function0)BaseTerminalNTT::communicationService$lambda$1));
    @NotNull
    private final List<String> paymentActions = CollectionsKt.listOf((Object)"SALE");
    @NotNull
    private final List<String> voidActions = CollectionsKt.listOf((Object)"VOID");
    @NotNull
    private final List<String> refundActions = CollectionsKt.emptyList();
    @Nullable
    private final Void bluetooth;
    @NotNull
    private final List<String> successStatuses;

    public BaseTerminalNTT() {
        super(new TerminalProvider("NTT", "THB", TerminalNTTKt.getNTT_PORTS()), false);
        Object[] objectArray = new String[]{"SUCCESS", "REFUND", "PAID"};
        this.successStatuses = CollectionsKt.listOf((Object[])objectArray);
    }

    @Nullable
    public Object onRefresh(@NotNull Action payload, @Nullable TerminalDevice device, @Nullable String paymentRequestId, @Nullable Boolean isSimulation, @NotNull Continuation $completion) {
        return BaseTerminalNTT.onRefresh$suspendImpl(this, payload, device, paymentRequestId, isSimulation, $completion);
    }

    static /* synthetic */ Object onRefresh$suspendImpl(BaseTerminalNTT $this, Action payload, TerminalDevice device, String paymentRequestId, Boolean isSimulation, Continuation $completion) {
        return null;
    }

    @NotNull
    protected NTTWebSocketService getCommunicationService() {
        return this.communicationService;
    }

    @NotNull
    public TerminalResult transformJsonToResult(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ((NTTTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)NTTTerminalResult.Companion.serializer(), json)).toTerminalResult();
    }

    @NotNull
    public Map<String, JsonElement> prepareRequestPayload(@NotNull Action payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Map sendData = MapsKt.toMutableMap((Map)payload.getData());
        if (sendData.containsKey("amount")) {
            String[] stringArray = new String[]{"."};
            List newValue = StringsKt.split$default((CharSequence)String.valueOf(payload.getTransactionAmount()), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Object object = CollectionsKt.first((List)newValue);
            String string = StringsKt.padEnd((String)((String)CollectionsKt.last((List)newValue)), (int)2, (char)'0').substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            sendData.put("amount", JsonElementKt.JsonPrimitive((String)(object + "." + string)));
        }
        return sendData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Result<TerminalResult> toResult(@NotNull TerminalDevice terminalDevice, @Nullable JsonElement json) {
        ErrorCode errorCode;
        Intrinsics.checkNotNullParameter((Object)terminalDevice, (String)"terminalDevice");
        if (json == null) return null;
        JsonElement it = json;
        boolean bl = false;
        NTTTerminalResult result = (NTTTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)NTTTerminalResult.Companion.serializer(), json);
        ErrorCode errorCode2 = result.toErrorCode();
        if (errorCode2 == null || (errorCode2 = errorCode2.toResult(result.getResponseMsg(), (Object)result)) == null) {
            errorCode2 = (Result)new Result.Success((Object)result);
        }
        if ((errorCode = errorCode2) == null) return null;
        Result result2 = errorCode.map(BaseTerminalNTT::toResult$lambda$1);
        return result2;
    }

    @Nullable
    public TerminalResult toTerminalResult(@Nullable TerminalDevice terminalDevice, @Nullable JsonElement json) {
        TerminalResult terminalResult;
        JsonElement jsonElement = json;
        if (jsonElement != null) {
            JsonElement it = jsonElement;
            boolean bl = false;
            terminalResult = ((NTTTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)NTTTerminalResult.Companion.serializer(), json)).toTerminalResult();
        } else {
            terminalResult = null;
        }
        return terminalResult;
    }

    @Nullable
    public GenericPaymentMethod toPaymentMethod(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        NTTPaymentMethod nTTPaymentMethod = NTTPaymentMethod.Companion.fromValue(value);
        return nTTPaymentMethod != null ? nTTPaymentMethod.toPaymentMethod() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Pair<String, JsonElement> toServicePayload(@NotNull JsonElement request, @NotNull JsonObject json, @NotNull Transactions transactions) {
        boolean bl;
        NTTTerminalResult response;
        block5: {
            void $this$decodeFromJsonElement$iv;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)transactions, (String)"transactions");
            Json json2 = JsonKt.getXenJson();
            JsonElement json$iv = (JsonElement)json;
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            response = (NTTTerminalResult)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)NTTTerminalResult.Companion.serializer(), json$iv);
            if (transactions.getPaymentRequestId() != null) {
                String string = transactions.getPaymentRequestId();
                Intrinsics.checkNotNull((Object)string);
                return TuplesKt.to((Object)"CALLBACK", (Object)this.syncCallback(string, (JsonElement)json));
            }
            Iterable $this$any$iv = this.successStatuses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)transactions.getStatus())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (!bl) {
            return TuplesKt.to(null, null);
        }
        return this.paymentActions.contains(transactions.getAction()) ? TuplesKt.to((Object)"PAYMENT", (Object)this.syncPaymentData(response)) : (this.refundActions.contains(transactions.getAction()) ? TuplesKt.to((Object)"VOID", (Object)this.syncVoidData(response)) : (this.voidActions.contains(transactions.getAction()) ? TuplesKt.to((Object)"VOID", (Object)this.syncVoidData(response)) : TuplesKt.to(null, null)));
    }

    private final JsonElement syncPaymentData(NTTTerminalResult response) {
        return JsonKt.getXenJson().encodeToJsonElement((SerializationStrategy)NTTTerminalResult.Companion.serializer(), (Object)response);
    }

    private final JsonElement syncVoidData(NTTTerminalResult response) {
        return JsonKt.getXenJson().encodeToJsonElement((SerializationStrategy)NTTTerminalResult.Companion.serializer(), (Object)response);
    }

    private final JsonElement syncCallback(String paymentRequestID, JsonElement response) {
        Map map;
        Map $this$syncCallback_u24lambda_u240 = map = MapsKt.toMutableMap((Map)((Map)JsonElementKt.getJsonObject((JsonElement)response)));
        boolean bl = false;
        if (!StringsKt.startsWith$default((String)paymentRequestID, (String)"ComID_", (boolean)false, (int)2, null)) {
            $this$syncCallback_u24lambda_u240.put("payment_request_id", JsonElementKt.JsonPrimitive((String)paymentRequestID));
        }
        Map map2 = map;
        return (JsonElement)new JsonObject(map2);
    }

    @Nullable
    protected Void getBluetooth() {
        return this.bluetooth;
    }

    @Nullable
    protected NTTAction onVoid(@NotNull Command command, @NotNull VoidPayload data) {
        NTTAction nTTAction;
        NTTPaymentMethod tradeType;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data.getTransactionId();
        String traceNumber = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"|"}), (boolean)false, (int)0, (int)6, null)) != null ? (String)CollectionsKt.last((List)object) : null;
        String string = data.getPaymentMethod();
        if (string != null) {
            String type = string;
            boolean bl = false;
            v2 = NTTPaymentMethod.Companion.fromValue(type);
        } else {
            v2 = tradeType = null;
        }
        if (traceNumber != null) {
            NTTAction.Void void_;
            String orderId = command.getOrderId();
            boolean bl = false;
            NTTPaymentMethod nTTPaymentMethod = tradeType;
            if (nTTPaymentMethod != null) {
                NTTPaymentMethod it = nTTPaymentMethod;
                boolean bl2 = false;
                String string2 = traceNumber;
                NTTPaymentMethod nTTPaymentMethod2 = tradeType;
                void_ = new NTTAction.Void(orderId, string2, nTTPaymentMethod2);
            } else {
                void_ = null;
            }
            nTTAction = void_;
        } else {
            nTTAction = null;
        }
        return nTTAction;
    }

    @Nullable
    protected NTTAction onPay(@NotNull Command command, @NotNull PayPayload data) {
        NTTPaymentMethod nTTPaymentMethod;
        String string;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string2 = command.getOrderId();
        if (string2 == null && (string2 = command.getReferenceId()) == null) {
            string2 = this.createOrderID();
        }
        String string3 = StringsKt.padEnd((String)string2, (int)12, (char)' ');
        int n = 0;
        int n2 = 12;
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String orderId = ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
        boolean bl = false;
        XLogger.Companion.debug("Payment Methods: " + data.getPaymentMethods());
        List list = data.getPaymentMethods();
        if (list != null && (string = (String)CollectionsKt.firstOrNull((List)list)) != null) {
            String it = string;
            boolean bl2 = false;
            nTTPaymentMethod = NTTPaymentMethod.Companion.fromValue(it);
        } else {
            nTTPaymentMethod = null;
        }
        NTTPaymentMethod tradeType = nTTPaymentMethod;
        Double d = data.getRequestAmount();
        NTTAction.Sale action = new NTTAction.Sale(orderId, d != null ? d : 0.0, tradeType, null);
        return action;
    }

    @Nullable
    protected Action onPrintReceipt(@NotNull Command command, @NotNull PrintReceiptPayload data) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    @Nullable
    protected Action onSettlement(@NotNull Command command, @NotNull SettlementPayload data) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    @Nullable
    public String terminalID(@Nullable JsonElement data) {
        String string;
        JsonElement jsonElement = data;
        if (jsonElement != null && (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) != null) {
            JsonElement it = jsonElement;
            boolean bl = false;
            JsonElement jsonElement2 = (JsonElement)it.get((Object)"terminal_id");
            string = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Object ping(@NotNull TerminalDevice device, @NotNull Continuation<? super Boolean> $completion) {
        return BaseTerminalNTT.ping$suspendImpl(this, device, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object ping$suspendImpl(BaseTerminalNTT $this, TerminalDevice device, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof ping.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ BaseTerminalNTT this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseTerminalNTT.ping$suspendImpl(this.this$0, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)device);
                $continuation.label = 1;
                v0 = $this.getCommunicationService().connectWithMutex(device, ((Number)CollectionsKt.first(TerminalNTTKt.getNTT_PORTS())).intValue(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"transaction_type", (Object)JsonElementKt.JsonPrimitive((String)"TEST"))), (Continuation)$continuation);
                ** if (v0 != var6_5) goto lbl20
lbl19:
                // 1 sources

                return var6_5;
lbl20:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                device = (TerminalDevice)$continuation.L$1;
                $this = (BaseTerminalNTT)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    result = (Result)v0;
                    return Boxing.boxBoolean((boolean)(result instanceof Result.Success));
                }
                catch (Exception var3_7) {
                    return Boxing.boxBoolean((boolean)false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public List<TerminalAction> toActions(@Nullable CommandType commandType) {
        CommandType commandType2 = commandType;
        return switch (commandType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[commandType2.ordinal()]) {
            case 1 -> CollectionsKt.listOf((Object)((Object)NTTTransactionType.SALE));
            case 2 -> CollectionsKt.listOf((Object)((Object)NTTTransactionType.VOID));
            default -> CollectionsKt.emptyList();
        };
    }

    @NotNull
    public String createOrderID() {
        DateTimeFormat formatter = LocalDateTime.Companion.Format(BaseTerminalNTT::createOrderID$lambda$0);
        LocalDateTime dateTime = TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC()));
        return LocalDateTimeKt.format((LocalDateTime)dateTime, (DateTimeFormat)formatter);
    }

    private static final boolean communicationService$lambda$0(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AppModule_desktopKt.getAppModule().retryRule(it);
    }

    private static final HttpClient communicationService$lambda$1() {
        return AppModule.wssClient$default((AppModule)AppModule_desktopKt.getAppModule(), null, (int)1, null);
    }

    private static final TerminalResult toResult$lambda$1(NTTTerminalResult it) {
        NTTTerminalResult nTTTerminalResult = it;
        return nTTTerminalResult != null ? nTTTerminalResult.toTerminalResult() : null;
    }

    private static final Unit createOrderID$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)"yyMMddHHmmss");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandType.values().length];
            try {
                nArray[CommandType.PAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandType.VOID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

