/*
 * Decompiled with CFR 0.152.
 */
package co.xendit.terminal.cashup;

import co.xendit.terminal.cashup.TerminalCashupKt;
import co.xendit.terminal.cashup.data.CashupAction;
import co.xendit.terminal.cashup.data.CashupPaymentMethod;
import co.xendit.terminal.cashup.data.CashupTerminalAction;
import co.xendit.terminal.cashup.data.CashupTerminalResult;
import co.xendit.terminal.core.TerminalOperation;
import co.xendit.terminal.core.data.Action;
import co.xendit.terminal.core.data.ErrorCode;
import co.xendit.terminal.core.data.GenericPaymentMethod;
import co.xendit.terminal.core.data.Result;
import co.xendit.terminal.core.data.TerminalAction;
import co.xendit.terminal.core.data.TerminalDevice;
import co.xendit.terminal.core.data.TerminalProvider;
import co.xendit.terminal.core.data.TerminalResult;
import co.xendit.terminal.core.data.Transactions;
import co.xendit.terminal.core.data.UnsupportedAction;
import co.xendit.terminal.core.data.response.Command;
import co.xendit.terminal.core.data.response.CommandType;
import co.xendit.terminal.core.data.response.PayPayload;
import co.xendit.terminal.core.data.response.PrintReceiptPayload;
import co.xendit.terminal.core.data.response.SettlementPayload;
import co.xendit.terminal.core.data.response.VoidPayload;
import co.xendit.terminal.core.service.TerminalCommunicationService;
import co.xendit.terminal.core.service.UnsupportedCommunicationService;
import co.xendit.terminal.core.util.JsonKt;
import co.xendit.terminal.core.util.XLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ulid.ULID;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00190\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u000fH\u0016J0\u0010'\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00190(2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u001c\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u00104\u001a\u0004\u0018\u00010\u000b2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0014J\u001a\u00109\u001a\u0004\u0018\u00010:2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020;H\u0014J\u001a\u0010<\u001a\u0004\u0018\u00010\u000b2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020=H\u0014J\u001a\u0010>\u001a\u0004\u0018\u00010\u000b2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020?H\u0014J\b\u0010@\u001a\u00020\u000fH\u0016J\u0014\u0010A\u001a\u0004\u0018\u00010\u000f2\b\u00107\u001a\u0004\u0018\u00010\u0019H\u0016J\u0016\u0010B\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\b\u0012\u0004\u0012\u00020E0$2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\u0004\u0018\u00010\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lco/xendit/terminal/cashup/BaseTerminalCashup;", "Lco/xendit/terminal/core/TerminalOperation;", "<init>", "()V", "needVerify", "", "getNeedVerify", "()Z", "onRefresh", "", "payload", "Lco/xendit/terminal/core/data/Action;", "device", "Lco/xendit/terminal/core/data/TerminalDevice;", "paymentRequestId", "", "isSimulation", "(Lco/xendit/terminal/core/data/Action;Lco/xendit/terminal/core/data/TerminalDevice;Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "communicationService", "Lco/xendit/terminal/core/service/TerminalCommunicationService;", "getCommunicationService", "()Lco/xendit/terminal/core/service/TerminalCommunicationService;", "transformJsonToResult", "Lco/xendit/terminal/core/data/TerminalResult;", "json", "Lkotlinx/serialization/json/JsonElement;", "prepareRequestPayload", "", "toResult", "Lco/xendit/terminal/core/data/Result;", "terminalDevice", "toTerminalResult", "toPaymentMethod", "Lco/xendit/terminal/core/data/GenericPaymentMethod;", "value", "paymentActions", "", "voidActions", "refundActions", "toServicePayload", "Lkotlin/Pair;", "request", "Lkotlinx/serialization/json/JsonObject;", "transactions", "Lco/xendit/terminal/core/data/Transactions;", "syncCallback", "response", "paymentRequestID", "bluetooth", "getBluetooth", "()Ljava/lang/Void;", "successStatuses", "onVoid", "command", "Lco/xendit/terminal/core/data/response/Command;", "data", "Lco/xendit/terminal/core/data/response/VoidPayload;", "onPay", "Lco/xendit/terminal/cashup/data/CashupAction;", "Lco/xendit/terminal/core/data/response/PayPayload;", "onPrintReceipt", "Lco/xendit/terminal/core/data/response/PrintReceiptPayload;", "onSettlement", "Lco/xendit/terminal/core/data/response/SettlementPayload;", "createOrderID", "terminalID", "ping", "(Lco/xendit/terminal/core/data/TerminalDevice;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toActions", "Lco/xendit/terminal/core/data/TerminalAction;", "commandType", "Lco/xendit/terminal/core/data/response/CommandType;", "id-cashup"})
@SourceDebugExtension(value={"SMAP\nTerminalCashup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCashup.kt\nco/xendit/terminal/cashup/BaseTerminalCashup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,322:1\n295#2,2:323\n1761#2,3:326\n335#3:325\n*S KotlinDebug\n*F\n+ 1 TerminalCashup.kt\nco/xendit/terminal/cashup/BaseTerminalCashup\n*L\n151#1:323,2\n183#1:326,3\n178#1:325\n*E\n"})
public class BaseTerminalCashup
extends TerminalOperation {
    private final boolean needVerify;
    @NotNull
    private final TerminalCommunicationService communicationService = (TerminalCommunicationService)new UnsupportedCommunicationService();
    @NotNull
    private final List<String> paymentActions;
    @NotNull
    private final List<String> voidActions;
    @NotNull
    private final List<String> refundActions;
    @Nullable
    private final Void bluetooth;
    @NotNull
    private final List<String> successStatuses;

    public BaseTerminalCashup() {
        super(new TerminalProvider("CASHUP", "IDR", TerminalCashupKt.getCASH_UP_PORTS()), false);
        Object[] objectArray = new String[]{CashupTerminalAction.CARD.getValue(), CashupTerminalAction.QRIS.getValue()};
        this.paymentActions = CollectionsKt.listOf((Object[])objectArray);
        this.voidActions = CollectionsKt.listOf((Object)CashupTerminalAction.VOID.getValue());
        this.refundActions = CollectionsKt.emptyList();
        objectArray = new String[]{"SUCCESS", "REFUND", "PAID"};
        this.successStatuses = CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean getNeedVerify() {
        return this.needVerify;
    }

    @Nullable
    public Object onRefresh(@NotNull Action payload, @Nullable TerminalDevice device, @Nullable String paymentRequestId, @Nullable Boolean isSimulation, @NotNull Continuation $completion) {
        return BaseTerminalCashup.onRefresh$suspendImpl(this, payload, device, paymentRequestId, isSimulation, $completion);
    }

    static /* synthetic */ Object onRefresh$suspendImpl(BaseTerminalCashup $this, Action payload, TerminalDevice device, String paymentRequestId, Boolean isSimulation, Continuation $completion) {
        return null;
    }

    @NotNull
    protected TerminalCommunicationService getCommunicationService() {
        return this.communicationService;
    }

    @NotNull
    public TerminalResult transformJsonToResult(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ((CashupTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)CashupTerminalResult.Companion.serializer(), json)).toTerminalResult(this.getDevice());
    }

    @NotNull
    public Map<String, JsonElement> prepareRequestPayload(@NotNull Action payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return payload.getData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Result<TerminalResult> toResult(@NotNull TerminalDevice terminalDevice, @Nullable JsonElement json) {
        ErrorCode errorCode;
        Intrinsics.checkNotNullParameter((Object)terminalDevice, (String)"terminalDevice");
        if (json == null) return null;
        JsonElement it = json;
        boolean bl = false;
        CashupTerminalResult result = (CashupTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)CashupTerminalResult.Companion.serializer(), json);
        ErrorCode errorCode2 = result.toErrorCode();
        if (errorCode2 == null || (errorCode2 = errorCode2.toResult(result.getMessage(), (Object)result)) == null) {
            errorCode2 = (Result)new Result.Success((Object)result);
        }
        if ((errorCode = errorCode2) == null) return null;
        Result result2 = errorCode.map(arg_0 -> BaseTerminalCashup.toResult$lambda$1(terminalDevice, arg_0));
        return result2;
    }

    @Nullable
    public TerminalResult toTerminalResult(@Nullable TerminalDevice terminalDevice, @Nullable JsonElement json) {
        TerminalResult terminalResult;
        JsonElement jsonElement = json;
        if (jsonElement != null) {
            JsonElement it = jsonElement;
            boolean bl = false;
            terminalResult = ((CashupTerminalResult)JsonKt.getXenJson().decodeFromJsonElement((DeserializationStrategy)CashupTerminalResult.Companion.serializer(), json)).toTerminalResult(terminalDevice);
        } else {
            terminalResult = null;
        }
        return terminalResult;
    }

    @Nullable
    public GenericPaymentMethod toPaymentMethod(@NotNull String value) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Iterable $this$firstOrNull$iv = (Iterable)CashupTerminalAction.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CashupTerminalAction type = (CashupTerminalAction)((Object)element$iv);
                boolean bl = false;
                if (!StringsKt.contains((CharSequence)value, (CharSequence)type.getValue(), (boolean)true)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        CashupTerminalAction cashupTerminalAction = v0;
        return cashupTerminalAction != null ? cashupTerminalAction.toPaymentMethod() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Pair<String, JsonElement> toServicePayload(@NotNull JsonElement request, @NotNull JsonObject json, @NotNull Transactions transactions) {
        boolean bl;
        block5: {
            void $this$decodeFromJsonElement$iv;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)transactions, (String)"transactions");
            Json json2 = JsonKt.getXenJson();
            JsonElement json$iv = (JsonElement)json;
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            CashupTerminalResult response = (CashupTerminalResult)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)CashupTerminalResult.Companion.serializer(), json$iv);
            if (transactions.getPaymentRequestId() != null) {
                return TuplesKt.to((Object)"CALLBACK", (Object)this.syncCallback((JsonElement)json, transactions.getPaymentRequestId()));
            }
            Iterable $this$any$iv = this.successStatuses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)transactions.getStatus())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (!bl) {
            return TuplesKt.to(null, null);
        }
        return this.paymentActions.contains(transactions.getAction()) ? TuplesKt.to((Object)"PAYMENT", (Object)BaseTerminalCashup.syncCallback$default(this, (JsonElement)json, null, 2, null)) : (this.refundActions.contains(transactions.getAction()) ? TuplesKt.to((Object)"VOID", (Object)BaseTerminalCashup.syncCallback$default(this, (JsonElement)json, null, 2, null)) : (this.voidActions.contains(transactions.getAction()) ? TuplesKt.to((Object)"VOID", (Object)BaseTerminalCashup.syncCallback$default(this, (JsonElement)json, null, 2, null)) : TuplesKt.to(null, null)));
    }

    private final JsonElement syncCallback(JsonElement response, String paymentRequestID) {
        JsonElement jsonElement;
        Map map;
        Map $this$syncCallback_u24lambda_u240 = map = MapsKt.toMutableMap((Map)((Map)JsonElementKt.getJsonObject((JsonElement)response)));
        boolean bl = false;
        if (paymentRequestID != null) {
            $this$syncCallback_u24lambda_u240.put("payment_request_id", JsonElementKt.JsonPrimitive((String)paymentRequestID));
        }
        $this$syncCallback_u24lambda_u240.put("response_code", JsonElementKt.JsonPrimitive((jsonElement = (JsonElement)$this$syncCallback_u24lambda_u240.get("response_code")) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement) : null));
        Map map2 = map;
        return (JsonElement)new JsonObject(map2);
    }

    static /* synthetic */ JsonElement syncCallback$default(BaseTerminalCashup baseTerminalCashup, JsonElement jsonElement, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: syncCallback");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return baseTerminalCashup.syncCallback(jsonElement, string);
    }

    @Nullable
    protected Void getBluetooth() {
        return this.bluetooth;
    }

    @Nullable
    protected Action onVoid(@NotNull Command command, @NotNull VoidPayload data) {
        List strings;
        List list;
        CashupPaymentMethod cashupPaymentMethod;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data.getPaymentMethod();
        if (string != null) {
            String method = string;
            boolean bl = false;
            cashupPaymentMethod = CashupPaymentMethod.Companion.toEnum(method);
        } else {
            cashupPaymentMethod = null;
        }
        CashupPaymentMethod action = cashupPaymentMethod;
        XLogger.Companion.debug("[onVoid] paymentMethod: " + action);
        if (action == CashupPaymentMethod.QRIS) {
            return (Action)new UnsupportedAction();
        }
        String string2 = data.getTransactionId();
        if (string2 != null) {
            String[] stringArray = new String[]{"|"};
            list = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list = null;
        }
        List list2 = strings = list;
        String traceNumber = list2 != null ? (String)CollectionsKt.first(list2) : null;
        return traceNumber != null ? (Action)new CashupAction.Void(traceNumber) : null;
    }

    @Nullable
    protected CashupAction onPay(@NotNull Command command, @NotNull PayPayload data) {
        CashupPaymentMethod cashupPaymentMethod;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String orderId = command.getOrderId();
        boolean bl = false;
        XLogger.Companion.debug("Payment Methods: " + data.getPaymentMethods());
        Object object = data.getPaymentMethods();
        if (object != null && (object = (String)CollectionsKt.firstOrNull((List)object)) != null) {
            Object method = object;
            boolean bl2 = false;
            cashupPaymentMethod = CashupPaymentMethod.Companion.toEnum((String)method);
        } else {
            cashupPaymentMethod = null;
        }
        CashupPaymentMethod action = cashupPaymentMethod;
        Double d = data.getRequestAmount();
        int amount = d != null ? (int)d.doubleValue() : 0;
        XLogger.Companion.debug("Payment amount: " + amount);
        CashupPaymentMethod cashupPaymentMethod2 = action;
        CashupAction.Payment action2 = new CashupAction.Payment(orderId, amount, (cashupPaymentMethod2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cashupPaymentMethod2.ordinal()]) == 1 ? CashupTerminalAction.QRIS : CashupTerminalAction.CARD, command.getPaymentRequestId());
        XLogger.Companion.debug("Payment Action: " + action2.getData());
        return action2;
    }

    @Nullable
    protected Action onPrintReceipt(@NotNull Command command, @NotNull PrintReceiptPayload data) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    @Nullable
    protected Action onSettlement(@NotNull Command command, @NotNull SettlementPayload data) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    @NotNull
    public String createOrderID() {
        return ULID.Factory.nextULID$default((ULID.Factory)((ULID.Factory)ULID.Companion), (long)0L, (int)1, null).toString();
    }

    @Nullable
    public String terminalID(@Nullable JsonElement data) {
        String string;
        JsonElement jsonElement = data;
        if (jsonElement != null && (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) != null) {
            JsonElement it = jsonElement;
            boolean bl = false;
            JsonElement jsonElement2 = (JsonElement)it.get((Object)"terminal_id");
            string = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? JsonElementKt.getContentOrNull((JsonPrimitive)jsonElement2) : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public Object ping(@NotNull TerminalDevice device, @NotNull Continuation<? super Boolean> $completion) {
        return BaseTerminalCashup.ping$suspendImpl(this, device, $completion);
    }

    static /* synthetic */ Object ping$suspendImpl(BaseTerminalCashup $this, TerminalDevice device, Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)false);
    }

    @NotNull
    public List<TerminalAction> toActions(@Nullable CommandType commandType) {
        CommandType commandType2 = commandType;
        return switch (commandType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[commandType2.ordinal()]) {
            case 1 -> CollectionsKt.listOf((Object)((Object)CashupTerminalAction.CARD));
            case 2 -> CollectionsKt.listOf((Object)((Object)CashupTerminalAction.VOID));
            default -> CollectionsKt.emptyList();
        };
    }

    private static final TerminalResult toResult$lambda$1(TerminalDevice $terminalDevice, CashupTerminalResult it) {
        CashupTerminalResult cashupTerminalResult = it;
        return cashupTerminalResult != null ? cashupTerminalResult.toTerminalResult($terminalDevice) : null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CashupPaymentMethod.values().length];
            try {
                nArray[CashupPaymentMethod.QRIS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CommandType.values().length];
            try {
                nArray[CommandType.PAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommandType.VOID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

