#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSError.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSSet.h>
#import <Foundation/NSString.h>
#import <Foundation/NSValue.h>

@class TerminalGatewayAction, TerminalGatewayActionCompanion, TerminalGatewayActionJob, TerminalGatewayAppInformation, TerminalGatewayAppModule, TerminalGatewayBRIAction, TerminalGatewayBRIActionCardVerification<T>, TerminalGatewayBRIActionCardVerificationCompanion, TerminalGatewayBRIActionCheckStatus, TerminalGatewayBRIActionCompanion, TerminalGatewayBRIActionContactless<T>, TerminalGatewayBRIActionInstallment<T>, TerminalGatewayBRIActionPayment<T>, TerminalGatewayBRIActionRefundQris, TerminalGatewayBRIActionReprintAny, TerminalGatewayBRIActionReprintLast, TerminalGatewayBRIActionSale<T>, TerminalGatewayBRIActionSaleCompletion<T>, TerminalGatewayBRIActionSettlement, TerminalGatewayBRIActionVoid, TerminalGatewayBRIPayload, TerminalGatewayBRIPayloadCompanion, TerminalGatewayBRITerminalAction, TerminalGatewayBRITerminalActionCompanion, TerminalGatewayBaseDatabaseHandler, TerminalGatewayBaseFakeResponseGenerator, TerminalGatewayBaseSecurity, TerminalGatewayBaseTerminal, TerminalGatewayBaseTerminalBRI, TerminalGatewayBaseTerminalDevice, TerminalGatewayBaseTerminalGateway, TerminalGatewayBaseTerminalNTT, TerminalGatewayBaseTerminalOperation, TerminalGatewayBluetoothData<T>, TerminalGatewayBriEDCWebSocketService, TerminalGatewayBriStatus, TerminalGatewayBriStatusCompanion, TerminalGatewayBriTerminalResult, TerminalGatewayBriTerminalResultCompanion, TerminalGatewayCheckVersionRequest, TerminalGatewayCheckVersionRequestCompanion, TerminalGatewayCommand, TerminalGatewayCommandCompanion, TerminalGatewayCommandConstants, TerminalGatewayCommandType, TerminalGatewayCommandTypeCompanion, TerminalGatewayConnectionState, TerminalGatewayConnectionType, TerminalGatewayDatabaseCompanion, TerminalGatewayDatabaseHandler, TerminalGatewayDriverFactory, TerminalGatewayError, TerminalGatewayErrorCode, TerminalGatewayErrorCodeCompanion, TerminalGatewayErrorCompanion, TerminalGatewayErrorData, TerminalGatewayErrorDataCompanion, TerminalGatewayFakeResponseGenerator, TerminalGatewayFakeResponseGenerator_, TerminalGatewayInternalNetworkService, TerminalGatewayInternalNetworkServiceCompanion, TerminalGatewayKermitLogger, TerminalGatewayKermitLoggerCompanion, TerminalGatewayKermit_coreBaseLogger, TerminalGatewayKermit_coreLogWriter, TerminalGatewayKermit_coreSeverity, TerminalGatewayKermit_ioRollingFileLogWriter, TerminalGatewayKermit_ioRollingFileLogWriterConfig, TerminalGatewayKotlinAbstractCoroutineContextElement, TerminalGatewayKotlinAbstractCoroutineContextKey<B, E>, TerminalGatewayKotlinArray<T>, TerminalGatewayKotlinByteArray, TerminalGatewayKotlinByteIterator, TerminalGatewayKotlinCancellationException, TerminalGatewayKotlinEnum<E>, TerminalGatewayKotlinEnumCompanion, TerminalGatewayKotlinException, TerminalGatewayKotlinIllegalStateException, TerminalGatewayKotlinInstant, TerminalGatewayKotlinInstantCompanion, TerminalGatewayKotlinKTypeProjection, TerminalGatewayKotlinKTypeProjectionCompanion, TerminalGatewayKotlinKVariance, TerminalGatewayKotlinNothing, TerminalGatewayKotlinPair<__covariant A, __covariant B>, TerminalGatewayKotlinRuntimeException, TerminalGatewayKotlinThrowable, TerminalGatewayKotlinUnit, TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcher, TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcherKey, TerminalGatewayKotlinx_datetimeDayOfWeek, TerminalGatewayKotlinx_datetimeDayOfWeekNames, TerminalGatewayKotlinx_datetimeDayOfWeekNamesCompanion, TerminalGatewayKotlinx_datetimeFixedOffsetTimeZone, TerminalGatewayKotlinx_datetimeFixedOffsetTimeZoneCompanion, TerminalGatewayKotlinx_datetimeLocalDate, TerminalGatewayKotlinx_datetimeLocalDateCompanion, TerminalGatewayKotlinx_datetimeLocalDateProgression, TerminalGatewayKotlinx_datetimeLocalDateProgressionCompanion, TerminalGatewayKotlinx_datetimeLocalDateRange, TerminalGatewayKotlinx_datetimeLocalDateRangeCompanion, TerminalGatewayKotlinx_datetimeLocalDateTime, TerminalGatewayKotlinx_datetimeLocalDateTimeCompanion, TerminalGatewayKotlinx_datetimeLocalTime, TerminalGatewayKotlinx_datetimeLocalTimeCompanion, TerminalGatewayKotlinx_datetimeMonth, TerminalGatewayKotlinx_datetimeMonthNames, TerminalGatewayKotlinx_datetimeMonthNamesCompanion, TerminalGatewayKotlinx_datetimeOverloadMarker, TerminalGatewayKotlinx_datetimePadding, TerminalGatewayKotlinx_datetimeTimeZone, TerminalGatewayKotlinx_datetimeTimeZoneCompanion, TerminalGatewayKotlinx_datetimeUtcOffset, TerminalGatewayKotlinx_datetimeUtcOffsetCompanion, TerminalGatewayKotlinx_io_coreBuffer, TerminalGatewayKotlinx_io_coreFileMetadata, TerminalGatewayKotlinx_io_corePath, TerminalGatewayKotlinx_serialization_coreSerialKind, TerminalGatewayKotlinx_serialization_coreSerializersModule, TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode, TerminalGatewayKotlinx_serialization_jsonJson, TerminalGatewayKotlinx_serialization_jsonJsonConfiguration, TerminalGatewayKotlinx_serialization_jsonJsonDefault, TerminalGatewayKotlinx_serialization_jsonJsonElement, TerminalGatewayKotlinx_serialization_jsonJsonElementCompanion, TerminalGatewayKotlinx_serialization_jsonJsonPrimitive, TerminalGatewayKotlinx_serialization_jsonJsonPrimitiveCompanion, TerminalGatewayKtor_client_coreHttpClient, TerminalGatewayKtor_client_coreHttpClientCall, TerminalGatewayKtor_client_coreHttpClientCallCompanion, TerminalGatewayKtor_client_coreHttpClientConfig<T>, TerminalGatewayKtor_client_coreHttpClientEngineConfig, TerminalGatewayKtor_client_coreHttpReceivePipeline, TerminalGatewayKtor_client_coreHttpReceivePipelinePhases, TerminalGatewayKtor_client_coreHttpRequestBuilder, TerminalGatewayKtor_client_coreHttpRequestBuilderCompanion, TerminalGatewayKtor_client_coreHttpRequestData, TerminalGatewayKtor_client_coreHttpRequestPipeline, TerminalGatewayKtor_client_coreHttpRequestPipelinePhases, TerminalGatewayKtor_client_coreHttpResponse, TerminalGatewayKtor_client_coreHttpResponseContainer, TerminalGatewayKtor_client_coreHttpResponseData, TerminalGatewayKtor_client_coreHttpResponsePipeline, TerminalGatewayKtor_client_coreHttpResponsePipelinePhases, TerminalGatewayKtor_client_coreHttpSendPipeline, TerminalGatewayKtor_client_coreHttpSendPipelinePhases, TerminalGatewayKtor_client_coreProxyConfig, TerminalGatewayKtor_client_coreWebSocketsConfig, TerminalGatewayKtor_eventsEventDefinition<T>, TerminalGatewayKtor_eventsEvents, TerminalGatewayKtor_httpContentType, TerminalGatewayKtor_httpContentTypeCompanion, TerminalGatewayKtor_httpHeaderValueParam, TerminalGatewayKtor_httpHeaderValueWithParameters, TerminalGatewayKtor_httpHeaderValueWithParametersCompanion, TerminalGatewayKtor_httpHeadersBuilder, TerminalGatewayKtor_httpHttpMethod, TerminalGatewayKtor_httpHttpMethodCompanion, TerminalGatewayKtor_httpHttpProtocolVersion, TerminalGatewayKtor_httpHttpProtocolVersionCompanion, TerminalGatewayKtor_httpHttpStatusCode, TerminalGatewayKtor_httpHttpStatusCodeCompanion, TerminalGatewayKtor_httpOutgoingContent, TerminalGatewayKtor_httpURLBuilder, TerminalGatewayKtor_httpURLBuilderCompanion, TerminalGatewayKtor_httpURLProtocol, TerminalGatewayKtor_httpURLProtocolCompanion, TerminalGatewayKtor_httpUrl, TerminalGatewayKtor_httpUrlCompanion, TerminalGatewayKtor_ioByteChannel, TerminalGatewayKtor_ioCharset, TerminalGatewayKtor_ioCharsetCompanion, TerminalGatewayKtor_ioCharsetDecoder, TerminalGatewayKtor_ioCharsetEncoder, TerminalGatewayKtor_ioReaderJob, TerminalGatewayKtor_ioWriterJob, TerminalGatewayKtor_networkSocketAddress, TerminalGatewayKtor_utilsAttributeKey<T>, TerminalGatewayKtor_utilsGMTDate, TerminalGatewayKtor_utilsGMTDateCompanion, TerminalGatewayKtor_utilsMonth, TerminalGatewayKtor_utilsMonthCompanion, TerminalGatewayKtor_utilsPipeline<TSubject, TContext>, TerminalGatewayKtor_utilsPipelinePhase, TerminalGatewayKtor_utilsStringValuesBuilderImpl, TerminalGatewayKtor_utilsTypeInfo, TerminalGatewayKtor_utilsWeekDay, TerminalGatewayKtor_utilsWeekDayCompanion, TerminalGatewayKtor_websocketsFrame, TerminalGatewayKtor_websocketsFrameCompanion, TerminalGatewayKtor_websocketsFrameType, TerminalGatewayKtor_websocketsFrameTypeCompanion, TerminalGatewayKtor_websocketsWebSocketExtensionHeader, TerminalGatewayKtor_websocketsWebSocketExtensionsConfig, TerminalGatewayLatestVersion, TerminalGatewayLatestVersionCompanion, TerminalGatewayLocalStorage, TerminalGatewayLogLevel, TerminalGatewayLogsRequest, TerminalGatewayLogsRequestCompanion, TerminalGatewayNTTAction, TerminalGatewayNTTActionCheckStatus, TerminalGatewayNTTActionCompanion, TerminalGatewayNTTActionInstallment, TerminalGatewayNTTActionPayment, TerminalGatewayNTTActionPreAuthorization, TerminalGatewayNTTActionPreAuthorizationCompanion, TerminalGatewayNTTActionSale, TerminalGatewayNTTActionSaleCompletion, TerminalGatewayNTTActionVoid, TerminalGatewayNTTPaymentIntentParametersBuilder, TerminalGatewayNTTTerminalAction, TerminalGatewayNTTTerminalResult, TerminalGatewayNTTTerminalResultCompanion, TerminalGatewayNTTTransactionType, TerminalGatewayNTTTransactionTypeCompanion, TerminalGatewayNTTWebSocketService, TerminalGatewayNetInterface, TerminalGatewayPayPayload, TerminalGatewayPayPayloadCompanion, TerminalGatewayPaymentMethod, TerminalGatewayPaymentMethodCompanion, TerminalGatewayPaymentMethod_, TerminalGatewayPaymentMethod_Companion, TerminalGatewayPrintReceiptPayload, TerminalGatewayPrintReceiptPayloadCompanion, TerminalGatewayRawTransactionsRequest, TerminalGatewayRawTransactionsRequestCompanion, TerminalGatewayRefundPayload, TerminalGatewayRefundPayloadCompanion, TerminalGatewayRefundRequestCompanion, TerminalGatewayResult<T>, TerminalGatewayRuntimeAfterVersion, TerminalGatewayRuntimeBaseTransacterImpl, TerminalGatewayRuntimeExecutableQuery<__covariant RowType>, TerminalGatewayRuntimeQuery<__covariant RowType>, TerminalGatewayRuntimeTransacterImpl, TerminalGatewayRuntimeTransacterTransaction, TerminalGatewaySaleMethod, TerminalGatewaySaleMethodCompanion, TerminalGatewayService, TerminalGatewayServiceCapabilities, TerminalGatewayServicePaymentMethod, TerminalGatewayServicePaymentMethodCompanion, TerminalGatewayServiceQueries, TerminalGatewayServiceType, TerminalGatewaySettlementPayload, TerminalGatewaySettlementPayloadCompanion, TerminalGatewaySimulationRequest, TerminalGatewaySimulationRequestCompanion, TerminalGatewaySimulationResponse, TerminalGatewaySimulationResponseCompanion, TerminalGatewayStatus, TerminalGatewayStatusCompanion, TerminalGatewayTerminal, TerminalGatewayTerminalApp, TerminalGatewayTerminalBRI, TerminalGatewayTerminalCore<T>, TerminalGatewayTerminalDevice, TerminalGatewayTerminalDevice_, TerminalGatewayTerminalDevice_Companion, TerminalGatewayTerminalDevice__, TerminalGatewayTerminalGateway, TerminalGatewayTerminalMode, TerminalGatewayTerminalNTT, TerminalGatewayTerminalOperation, TerminalGatewayTerminalProvider, TerminalGatewayTerminalQueries, TerminalGatewayTerminalResult, TerminalGatewayTerminalResultCompanion, TerminalGatewayTimeoutType, TerminalGatewayTimeoutTypeCompanion, TerminalGatewayTradeType, TerminalGatewayTradeTypeCompanion, TerminalGatewayTransactionFakeCode, TerminalGatewayTransactionFakeCode_, TerminalGatewayTransactionQueries, TerminalGatewayTransactionResponse, TerminalGatewayTransactionResponseCompanion, TerminalGatewayTransactionType, TerminalGatewayTransactionTypeCompanion, TerminalGatewayTransactions, TerminalGatewayTransactionsRequest<T>, TerminalGatewayTransactionsRequestCompanion, TerminalGatewayTransactionsRequestPayload, TerminalGatewayTransactionsRequestPayloadCompanion, TerminalGatewayVerifyRequest, TerminalGatewayVerifyRequestCompanion, TerminalGatewayVersionStatus, TerminalGatewayVoidPayload, TerminalGatewayVoidPayloadCompanion, TerminalGatewayVoidRequest, TerminalGatewayVoidRequestCompanion, TerminalGatewayWebSocketService, TerminalGatewayXLoggerCompanion;

@protocol TerminalGatewayBluetoothService, TerminalGatewayCommandPayload, TerminalGatewayDatabase, TerminalGatewayKermit_coreLoggerConfig, TerminalGatewayKermit_coreMessageStringFormatter, TerminalGatewayKermit_coreMutableLoggerConfig, TerminalGatewayKotlinAnnotation, TerminalGatewayKotlinAppendable, TerminalGatewayKotlinAutoCloseable, TerminalGatewayKotlinClock, TerminalGatewayKotlinClosedRange, TerminalGatewayKotlinCollection, TerminalGatewayKotlinComparable, TerminalGatewayKotlinContinuation, TerminalGatewayKotlinContinuationInterceptor, TerminalGatewayKotlinCoroutineContext, TerminalGatewayKotlinCoroutineContextElement, TerminalGatewayKotlinCoroutineContextKey, TerminalGatewayKotlinFunction, TerminalGatewayKotlinIterable, TerminalGatewayKotlinIterator, TerminalGatewayKotlinKAnnotatedElement, TerminalGatewayKotlinKClass, TerminalGatewayKotlinKClassifier, TerminalGatewayKotlinKDeclarationContainer, TerminalGatewayKotlinKType, TerminalGatewayKotlinMapEntry, TerminalGatewayKotlinOpenEndRange, TerminalGatewayKotlinSequence, TerminalGatewayKotlinSuspendFunction0, TerminalGatewayKotlinSuspendFunction1, TerminalGatewayKotlinSuspendFunction2, TerminalGatewayKotlinx_coroutines_coreChildHandle, TerminalGatewayKotlinx_coroutines_coreChildJob, TerminalGatewayKotlinx_coroutines_coreCoroutineScope, TerminalGatewayKotlinx_coroutines_coreDisposableHandle, TerminalGatewayKotlinx_coroutines_coreFlow, TerminalGatewayKotlinx_coroutines_coreFlowCollector, TerminalGatewayKotlinx_coroutines_coreJob, TerminalGatewayKotlinx_coroutines_coreMutableSharedFlow, TerminalGatewayKotlinx_coroutines_coreMutableStateFlow, TerminalGatewayKotlinx_coroutines_coreMutex, TerminalGatewayKotlinx_coroutines_coreParentJob, TerminalGatewayKotlinx_coroutines_coreRunnable, TerminalGatewayKotlinx_coroutines_coreSelectClause, TerminalGatewayKotlinx_coroutines_coreSelectClause0, TerminalGatewayKotlinx_coroutines_coreSelectClause2, TerminalGatewayKotlinx_coroutines_coreSelectInstance, TerminalGatewayKotlinx_coroutines_coreSharedFlow, TerminalGatewayKotlinx_coroutines_coreStateFlow, TerminalGatewayKotlinx_datetimeDateTimeFormat, TerminalGatewayKotlinx_datetimeDateTimeFormatBuilder, TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithDate, TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithDateTime, TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithTime, TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset, TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithYearMonth, TerminalGatewayKotlinx_io_coreFileSystem, TerminalGatewayKotlinx_io_coreRawSink, TerminalGatewayKotlinx_io_coreRawSource, TerminalGatewayKotlinx_io_coreSink, TerminalGatewayKotlinx_io_coreSource, TerminalGatewayKotlinx_serialization_coreCompositeDecoder, TerminalGatewayKotlinx_serialization_coreCompositeEncoder, TerminalGatewayKotlinx_serialization_coreDecoder, TerminalGatewayKotlinx_serialization_coreDeserializationStrategy, TerminalGatewayKotlinx_serialization_coreEncoder, TerminalGatewayKotlinx_serialization_coreKSerializer, TerminalGatewayKotlinx_serialization_coreSerialDescriptor, TerminalGatewayKotlinx_serialization_coreSerialFormat, TerminalGatewayKotlinx_serialization_coreSerializationStrategy, TerminalGatewayKotlinx_serialization_coreSerializersModuleCollector, TerminalGatewayKotlinx_serialization_coreStringFormat, TerminalGatewayKotlinx_serialization_jsonJsonNamingStrategy, TerminalGatewayKtor_client_coreHttpClientEngine, TerminalGatewayKtor_client_coreHttpClientEngineCapability, TerminalGatewayKtor_client_coreHttpClientPlugin, TerminalGatewayKtor_client_coreHttpRequest, TerminalGatewayKtor_httpHeaders, TerminalGatewayKtor_httpHttpMessage, TerminalGatewayKtor_httpHttpMessageBuilder, TerminalGatewayKtor_httpParameters, TerminalGatewayKtor_httpParametersBuilder, TerminalGatewayKtor_ioBufferedByteWriteChannel, TerminalGatewayKtor_ioByteReadChannel, TerminalGatewayKtor_ioByteWriteChannel, TerminalGatewayKtor_ioChannelJob, TerminalGatewayKtor_ioCloseable, TerminalGatewayKtor_ioJvmSerializable, TerminalGatewayKtor_networkABoundSocket, TerminalGatewayKtor_networkAConnectedSocket, TerminalGatewayKtor_networkAReadable, TerminalGatewayKtor_networkASocket, TerminalGatewayKtor_networkAWritable, TerminalGatewayKtor_networkReadWriteSocket, TerminalGatewayKtor_networkSocket, TerminalGatewayKtor_serializationWebsocketContentConverter, TerminalGatewayKtor_utilsAttributes, TerminalGatewayKtor_utilsStringValues, TerminalGatewayKtor_utilsStringValuesBuilder, TerminalGatewayKtor_websocketsWebSocketExtension, TerminalGatewayKtor_websocketsWebSocketExtensionFactory, TerminalGatewayLoggingLogLevelController, TerminalGatewayLoggingLogger, TerminalGatewayLoggingLoggerApi, TerminalGatewayPlatform, TerminalGatewayResultListener, TerminalGatewayRuntimeCloseable, TerminalGatewayRuntimeQueryListener, TerminalGatewayRuntimeQueryResult, TerminalGatewayRuntimeSqlCursor, TerminalGatewayRuntimeSqlDriver, TerminalGatewayRuntimeSqlPreparedStatement, TerminalGatewayRuntimeSqlSchema, TerminalGatewayRuntimeTransacter, TerminalGatewayRuntimeTransacterBase, TerminalGatewayRuntimeTransactionCallbacks, TerminalGatewayRuntimeTransactionWithReturn, TerminalGatewayRuntimeTransactionWithoutReturn, TerminalGatewayTerminalAction;

NS_ASSUME_NONNULL_BEGIN
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunknown-warning-option"
#pragma clang diagnostic ignored "-Wincompatible-property-type"
#pragma clang diagnostic ignored "-Wnullability"

#pragma push_macro("_Nullable_result")
#if !__has_feature(nullability_nullable_result)
#undef _Nullable_result
#define _Nullable_result _Nullable
#endif

__attribute__((swift_name("KotlinBase")))
@interface TerminalGatewayBase : NSObject
- (instancetype)init __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (void)initialize __attribute__((objc_requires_super));
@end

@interface TerminalGatewayBase (TerminalGatewayBaseCopying) <NSCopying>
@end

__attribute__((swift_name("KotlinMutableSet")))
@interface TerminalGatewayMutableSet<ObjectType> : NSMutableSet<ObjectType>
@end

__attribute__((swift_name("KotlinMutableDictionary")))
@interface TerminalGatewayMutableDictionary<KeyType, ObjectType> : NSMutableDictionary<KeyType, ObjectType>
@end

@interface NSError (NSErrorTerminalGatewayKotlinException)
@property (readonly) id _Nullable kotlinException;
@end

__attribute__((swift_name("KotlinNumber")))
@interface TerminalGatewayNumber : NSNumber
- (instancetype)initWithChar:(char)value __attribute__((unavailable));
- (instancetype)initWithUnsignedChar:(unsigned char)value __attribute__((unavailable));
- (instancetype)initWithShort:(short)value __attribute__((unavailable));
- (instancetype)initWithUnsignedShort:(unsigned short)value __attribute__((unavailable));
- (instancetype)initWithInt:(int)value __attribute__((unavailable));
- (instancetype)initWithUnsignedInt:(unsigned int)value __attribute__((unavailable));
- (instancetype)initWithLong:(long)value __attribute__((unavailable));
- (instancetype)initWithUnsignedLong:(unsigned long)value __attribute__((unavailable));
- (instancetype)initWithLongLong:(long long)value __attribute__((unavailable));
- (instancetype)initWithUnsignedLongLong:(unsigned long long)value __attribute__((unavailable));
- (instancetype)initWithFloat:(float)value __attribute__((unavailable));
- (instancetype)initWithDouble:(double)value __attribute__((unavailable));
- (instancetype)initWithBool:(BOOL)value __attribute__((unavailable));
- (instancetype)initWithInteger:(NSInteger)value __attribute__((unavailable));
- (instancetype)initWithUnsignedInteger:(NSUInteger)value __attribute__((unavailable));
+ (instancetype)numberWithChar:(char)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedChar:(unsigned char)value __attribute__((unavailable));
+ (instancetype)numberWithShort:(short)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedShort:(unsigned short)value __attribute__((unavailable));
+ (instancetype)numberWithInt:(int)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedInt:(unsigned int)value __attribute__((unavailable));
+ (instancetype)numberWithLong:(long)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedLong:(unsigned long)value __attribute__((unavailable));
+ (instancetype)numberWithLongLong:(long long)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedLongLong:(unsigned long long)value __attribute__((unavailable));
+ (instancetype)numberWithFloat:(float)value __attribute__((unavailable));
+ (instancetype)numberWithDouble:(double)value __attribute__((unavailable));
+ (instancetype)numberWithBool:(BOOL)value __attribute__((unavailable));
+ (instancetype)numberWithInteger:(NSInteger)value __attribute__((unavailable));
+ (instancetype)numberWithUnsignedInteger:(NSUInteger)value __attribute__((unavailable));
@end

__attribute__((swift_name("KotlinByte")))
@interface TerminalGatewayByte : TerminalGatewayNumber
- (instancetype)initWithChar:(char)value;
+ (instancetype)numberWithChar:(char)value;
@end

__attribute__((swift_name("KotlinUByte")))
@interface TerminalGatewayUByte : TerminalGatewayNumber
- (instancetype)initWithUnsignedChar:(unsigned char)value;
+ (instancetype)numberWithUnsignedChar:(unsigned char)value;
@end

__attribute__((swift_name("KotlinShort")))
@interface TerminalGatewayShort : TerminalGatewayNumber
- (instancetype)initWithShort:(short)value;
+ (instancetype)numberWithShort:(short)value;
@end

__attribute__((swift_name("KotlinUShort")))
@interface TerminalGatewayUShort : TerminalGatewayNumber
- (instancetype)initWithUnsignedShort:(unsigned short)value;
+ (instancetype)numberWithUnsignedShort:(unsigned short)value;
@end

__attribute__((swift_name("KotlinInt")))
@interface TerminalGatewayInt : TerminalGatewayNumber
- (instancetype)initWithInt:(int)value;
+ (instancetype)numberWithInt:(int)value;
@end

__attribute__((swift_name("KotlinUInt")))
@interface TerminalGatewayUInt : TerminalGatewayNumber
- (instancetype)initWithUnsignedInt:(unsigned int)value;
+ (instancetype)numberWithUnsignedInt:(unsigned int)value;
@end

__attribute__((swift_name("KotlinLong")))
@interface TerminalGatewayLong : TerminalGatewayNumber
- (instancetype)initWithLongLong:(long long)value;
+ (instancetype)numberWithLongLong:(long long)value;
@end

__attribute__((swift_name("KotlinULong")))
@interface TerminalGatewayULong : TerminalGatewayNumber
- (instancetype)initWithUnsignedLongLong:(unsigned long long)value;
+ (instancetype)numberWithUnsignedLongLong:(unsigned long long)value;
@end

__attribute__((swift_name("KotlinFloat")))
@interface TerminalGatewayFloat : TerminalGatewayNumber
- (instancetype)initWithFloat:(float)value;
+ (instancetype)numberWithFloat:(float)value;
@end

__attribute__((swift_name("KotlinDouble")))
@interface TerminalGatewayDouble : TerminalGatewayNumber
- (instancetype)initWithDouble:(double)value;
+ (instancetype)numberWithDouble:(double)value;
@end

__attribute__((swift_name("KotlinBoolean")))
@interface TerminalGatewayBoolean : TerminalGatewayNumber
- (instancetype)initWithBool:(BOOL)value;
+ (instancetype)numberWithBool:(BOOL)value;
@end

__attribute__((swift_name("BaseTerminalOperation")))
@interface TerminalGatewayBaseTerminalOperation : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandsTids:(NSArray<NSString *> *)tids completionHandler:(void (^)(TerminalGatewayResult<NSArray<TerminalGatewayCommand *> *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commands(tids:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TerminalGatewayActionJob *)actionJob payload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observePayloadScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable))onResult __attribute__((swift_name("observePayload(scope:onResult:)")));
@end

__attribute__((swift_name("TerminalOperation")))
@interface TerminalGatewayTerminalOperation : TerminalGatewayBaseTerminalOperation
- (instancetype)initWithTerminalProvider:(TerminalGatewayTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));

/**
 * Cancel an intent
 */
- (void)cancelDevice:(TerminalGatewayBaseTerminalDevice *)device key:(TerminalGatewayAction *)key __attribute__((swift_name("cancel(device:key:)")));

/**
 * Cancel all the intents
 */
- (void)cancelAllDevice:(TerminalGatewayBaseTerminalDevice *)device __attribute__((swift_name("cancelAll(device:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)cancelSessionPayload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice * _Nullable)device isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("cancelSession(payload:device:isSimulation:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkStatusPayload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkStatus(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectDevice:(TerminalGatewayBaseTerminalDevice * _Nullable)device __attribute__((swift_name("disconnect(device:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TerminalGatewayActionJob *)actionJob payload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeAction:(TerminalGatewayAction * _Nullable)action command:(TerminalGatewayCommand *)command device:(TerminalGatewayBaseTerminalDevice *)device isSimulation:(BOOL)isSimulation completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(action:command:device:isSimulation:completionHandler:)")));
- (TerminalGatewayTimeoutType * _Nullable)getTimeoutTypeAction:(TerminalGatewayAction *)action __attribute__((swift_name("getTimeoutType(action:)")));
- (BOOL)isLockedDevice:(TerminalGatewayBaseTerminalDevice *)device __attribute__((swift_name("isLocked(device:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeResultOnResult:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> *))onResult __attribute__((swift_name("observeResult(onResult:)")));

/**
 * Observes the Terminal connection state on [Dispatchers.IO] and
 * delivers updates via the [onResult] callback.
 *
 * This is a convenience function that launches the observation in a default [CoroutineScope]
 * on the [Dispatchers.IO] dispatcher.
 *
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine. Cancelling this job will stop the observation.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeTerminalConnectionOnResult:(void (^)(TerminalGatewayConnectionState *))onResult __attribute__((swift_name("observeTerminalConnection(onResult:)")));

/**
 * Observes the Terminal connection state within a given [scope] and
 * delivers updates via the [onResult] callback.
 *
 * This function collects the [ConnectionState] emitted by [connectionState] and
 * invokes the [onResult] callback with the latest state. The observation will continue
 * as long as the provided [scope] is active.
 *
 * @param scope The [CoroutineScope] in which the observation coroutine will be launched.
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine. Cancelling this job will stop the observation.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeTerminalConnectionScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(TerminalGatewayConnectionState *))onResult __attribute__((swift_name("observeTerminalConnection(scope:onResult:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onPayCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onPrintReceiptCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onSettlementCommand:(TerminalGatewayCommand *)command data:(TerminalGatewaySettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onVoidCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(TerminalGatewayBaseTerminalDevice *)device completionHandler:(void (^)(TerminalGatewayBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));
- (NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(TerminalGatewayAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));
- (TerminalGatewayKotlinUnit * _Nullable)releaseDevice:(TerminalGatewayBaseTerminalDevice * _Nullable)device __attribute__((swift_name("release(device:)")));
- (void)releaseTerminalID:(NSString *)terminalID __attribute__((swift_name("release(terminalID:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayActionJob *)runActionIt:(TerminalGatewayAction *)it device:(TerminalGatewayBaseTerminalDevice * _Nullable)device isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("runAction(it:device:isSimulation:callback:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayActionJob *)runActionIt:(TerminalGatewayAction *)it device:(TerminalGatewayBaseTerminalDevice * _Nullable)device isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation onCancel:(id<TerminalGatewayKotlinSuspendFunction0>)onCancel callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("runAction(it:device:isSimulation:onCancel:callback:)")));
- (void)setConnectionTypeConnectionType:(TerminalGatewayConnectionType *)connectionType __attribute__((swift_name("setConnectionType(connectionType:)")));
- (NSString * _Nullable)terminalIDData:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)testDeviceConnectionTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation device:(TerminalGatewayBaseTerminalDevice *)device completionHandler:(void (^)(TerminalGatewayBaseTerminalDevice * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("testDeviceConnection(terminalOperation:device:completionHandler:)")));
- (TerminalGatewayAction * _Nullable)toActionPayloadCommand:(TerminalGatewayCommand *)command data:(id<TerminalGatewayCommandPayload> _Nullable)data __attribute__((swift_name("toActionPayload(command:data:)")));
- (NSArray<id<TerminalGatewayTerminalAction>> *)toActionsCommandType:(TerminalGatewayCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (int64_t)toMillis:(NSString *)receiver __attribute__((swift_name("toMillis(_:)")));
- (TerminalGatewayPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable)toResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(json:)")));
- (TerminalGatewayKotlinPair<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)json transactions:(TerminalGatewayTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (TerminalGatewayTerminalResult * _Nullable)toTerminalResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(json:)")));
- (NSArray<TerminalGatewayTerminalResult *> * _Nullable)transactionRecordsActions:(NSArray<id<TerminalGatewayTerminalAction>> *)actions statuses:(NSArray<TerminalGatewayStatus *> *)statuses from:(NSString * _Nullable)from to:(NSString * _Nullable)to __attribute__((swift_name("transactionRecords(actions:statuses:from:to:)")));
- (NSArray<TerminalGatewayTerminalResult *> * _Nullable)transactionRecordsActions:(NSArray<NSString *> *)actions statuses:(NSArray<TerminalGatewayStatus *> *)statuses fromTimestamp:(TerminalGatewayLong * _Nullable)fromTimestamp toTimestamp:(TerminalGatewayLong * _Nullable)toTimestamp __attribute__((swift_name("transactionRecords(actions:statuses:fromTimestamp:toTimestamp:)")));
- (TerminalGatewayTerminalResult *)transformJsonToResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));
- (void)useWifi __attribute__((swift_name("useWifi()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TerminalGatewayBluetoothService> _Nullable bluetooth __attribute__((swift_name("bluetooth")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreFlow> connectionState __attribute__((swift_name("connectionState")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property TerminalGatewayBaseTerminalDevice * _Nullable device __attribute__((swift_name("device")));
@property (readonly) TerminalGatewayBaseFakeResponseGenerator *fakeGenerator __attribute__((swift_name("fakeGenerator")));
@property BOOL isSimulation __attribute__((swift_name("isSimulation")));

/**
 * Get the result flow
 * @return the result flow
 */
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreStateFlow> result __attribute__((swift_name("result")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreMutableStateFlow> resultFlow __attribute__((swift_name("resultFlow")));
@property (readonly) TerminalGatewayConnectionType *sdkConnectionType __attribute__((swift_name("sdkConnectionType")));
@property (readonly) TerminalGatewayTerminalProvider *terminalProvider __attribute__((swift_name("terminalProvider")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TerminalGatewayWebSocketService * _Nullable wifi __attribute__((swift_name("wifi")));
@end


/**
 * Implementation of [TerminalOperation] for BRI (Bank Rakyat Indonesia) terminals.
 * This class handles communication with BRI EDCs via WebSocket or Bluetooth, maps
 * generic terminal actions to BRI-specific protocols, and manages transaction lifecycles
 * including payments, settlements, voids, and refunds.
 */
__attribute__((swift_name("BaseTerminalBRI")))
@interface TerminalGatewayBaseTerminalBRI : TerminalGatewayTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(TerminalGatewayTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Cancels or voids a payment based on the provided [TerminalResult].
 *
 * @param result The result of the payment to cancel.
 * @param isSimulation Flag for simulation.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)cancelPaymentIntentResult:(TerminalGatewayTerminalResult *)result isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("cancelPaymentIntent(result:isSimulation:listener:)")));

/**
 * Cancels or voids a payment based on the provided [TerminalResult] using a callback.
 *
 * @param result The result of the payment to cancel.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)cancelPaymentIntentResult:(TerminalGatewayTerminalResult *)result isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("cancelPaymentIntent(result:isSimulation:callback:)")));

/**
 * Cancels or voids a transaction using specific method and trace number.
 *
 * @param method The sale method (e.g., QRIS, CARD).
 * @param traceNumber The trace number or reference ID of the transaction.
 * @param isSimulation Flag for simulation.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)cancelPaymentIntentMethod:(TerminalGatewaySaleMethod *)method traceNumber:(NSString *)traceNumber isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("cancelPaymentIntent(method:traceNumber:isSimulation:listener:)")));

/**
 * Cancels or voids a transaction using specific method and trace number with a callback.
 * Handles QRIS refunds and standard Voids differently.
 *
 * @param method The sale method.
 * @param traceNumber The trace number or reference ID.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)cancelPaymentIntentMethod:(TerminalGatewaySaleMethod *)method traceNumber:(NSString *)traceNumber isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("cancelPaymentIntent(method:traceNumber:isSimulation:callback:)")));

/**
 * Checks the status of a generic transaction by Order ID.
 *
 * @param orderID The order identifier.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)checkStatusOrderID:(NSString *)orderID isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("checkStatus(orderID:isSimulation:callback:)")));

/**
 * Checks the status of a specific transaction on the terminal device.
 * This is typically used to verify if a previous operation (like a sale or verification)
 * was successful when the initial response was ambiguous or lost.
 *
 * @param payload The action payload.
 * @param device The target terminal device.
 * @param paymentRequestId The ID of the payment request.
 * @param isSimulation Flag to indicate if this is a simulation.
 * @return A [Result] containing the [TerminalResult], or [ErrorCode.NO_DATA_FOUND] if no Order ID exists.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkStatusPayload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkStatus(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * Checks the status of a QRIS transaction.
 *
 * @param referenceNumber The reference number of the QRIS transaction.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)checkStatusQrisReferenceNumber:(NSString *)referenceNumber isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("checkStatusQris(referenceNumber:isSimulation:callback:)")));

/**
 * Completes a sale operation with explicit parameters.
 *
 * @param transactionId The transaction identifier.
 * @param amount The transaction amount.
 * @param terminalReference The terminal reference/approval code.
 * @param device The target device.
 * @param isSimulation Flag for simulation.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)collectPaymentMethodTransactionId:(NSString *)transactionId amount:(int32_t)amount terminalReference:(NSString *)terminalReference device:(TerminalGatewayBaseTerminalDevice * _Nullable)device isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("collectPaymentMethod(transactionId:amount:terminalReference:device:isSimulation:listener:)")));

/**
 * Executes a terminal action. If the action is a payment, it verifies the consistency
 * of the Order ID between the request and the result. If they mismatch, it attempts
 * to fetch the correct status from the device.
 *
 * @param actionJob The job context for the action.
 * @param payload The action payload.
 * @param device The target terminal device.
 * @param orderId The order identifier.
 * @param paymentRequestId The payment request identifier.
 * @param isSimulation Flag for simulation mode.
 * @param isSynchronize Flag for synchronous execution.
 * @return The result of the terminal operation.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TerminalGatewayActionJob *)actionJob payload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Initiates an installment payment transaction.
 *
 * @param installment The installment payment details.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)doInstallmentInstallment:(TerminalGatewayBRIActionInstallment<TerminalGatewayInt *> *)installment listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("doInstallment(installment:listener:)")));

/**
 * Initiates an installment payment transaction using a callback.
 * Updates [latestPayment] on success.
 *
 * @param installment The installment payment details.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)doInstallmentInstallment:(TerminalGatewayBRIActionInstallment<TerminalGatewayInt *> *)installment isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("doInstallment(installment:isSimulation:callback:)")));

/**
 * Initiates a refund operation, specifically for QRIS transactions.
 *
 * @param referenceID The reference ID of the transaction to refund.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)doRefundReferenceID:(NSString *)referenceID listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("doRefund(referenceID:listener:)")));

/**
 * Initiates a refund operation for a specific method.
 *
 * @param referenceID The reference ID of the transaction.
 * @param method The sale method.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)doRefundReferenceID:(NSString *)referenceID method:(TerminalGatewaySaleMethod *)method listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("doRefund(referenceID:method:listener:)")));

/**
 * Initiates a refund operation for QRIS transactions using a callback.
 *
 * @param referenceID The reference ID of the transaction.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)doRefundReferenceID:(NSString *)referenceID isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("doRefund(referenceID:isSimulation:callback:)")));

/**
 * Initiates a refund operation for a specific method using a callback.
 *
 * @param referenceID The reference ID of the transaction.
 * @param method The sale method.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)doRefundReferenceID:(NSString *)referenceID method:(TerminalGatewaySaleMethod *)method isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("doRefund(referenceID:method:isSimulation:callback:)")));
- (TerminalGatewayTimeoutType * _Nullable)getTimeoutTypeAction:(TerminalGatewayAction *)action __attribute__((swift_name("getTimeoutType(action:)")));

/**
 * Maps a generic [Command.PAY] command to a specific BRI payment action.
 * Handles various payment methods like Insert Card, Contactless, BRIZZI, and QRIS.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onPayCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * Maps a generic [Command.PRINT_RECEIPT] command to a BRI Reprint or CheckStatus action.
 * For QRIS, it uses CheckStatus to fetch and print the latest status.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction *)onPrintReceiptCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the status of a transaction. If a valid Order ID is associated with the payload,
 * it triggers a status check on the device.
 *
 * @param payload The action payload containing transaction details.
 * @param device The target terminal device.
 * @param paymentRequestId The ID of the payment request.
 * @param isSimulation Flag to indicate if this is a simulation.
 * @return A [Result] containing the [TerminalResult] of the status check.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * Maps a generic [Command.SETTLE] command to a BRI Settlement action.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onSettlementCommand:(TerminalGatewayCommand *)command data:(TerminalGatewaySettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Maps a generic [Command.VOID] command to a BRI Void or Refund action.
 * Uses [RefundQris] for QRIS methods and standard [Void] for others.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onVoidCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Initiates a payment transaction using a callback.
 * Stores the result in [latestPayment] if successful.
 *
 * @param payment The payment configuration object.
 * @param device The target device (optional).
 * @param isSimulation Flag for simulation (optional).
 * @param callback The callback function for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)paymentIntentPayment:(TerminalGatewayBRIActionPayment<TerminalGatewayInt *> *)payment device:(TerminalGatewayTerminalDevice * _Nullable)device isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("paymentIntent(payment:device:isSimulation:callback:)")));

/**
 * Pings the terminal device via WebSocket to check for reachability.
 * Returns true if connection is successful or if specific error codes (like DECLINED_BY_READER) indicate presence.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(TerminalGatewayBaseTerminalDevice *)device completionHandler:(void (^)(TerminalGatewayBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));
- (NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(TerminalGatewayAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));

/**
 * Prints the receipt for the last transaction of a specific sale method.
 *
 * @param method The sale method.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)printReceiptIntentMethod:(TerminalGatewaySaleMethod *)method listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("printReceiptIntent(method:listener:)")));

/**
 * Prints the receipt for the last transaction of a specific sale method using a callback.
 *
 * @param method The sale method.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)printReceiptIntentMethod:(TerminalGatewaySaleMethod *)method isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("printReceiptIntent(method:isSimulation:callback:)")));

/**
 * Prints a receipt for a specific trace number or the last transaction if trace number is null.
 *
 * @param method The sale method.
 * @param traceNumber The optional trace number.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)printReceiptIntentMethod:(TerminalGatewaySaleMethod *)method traceNumber:(NSString * _Nullable)traceNumber listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("printReceiptIntent(method:traceNumber:listener:)")));

/**
 * Initiates a receipt print job for a given terminal result.
 *
 * @param result The terminal result containing transaction details.
 * @param isSimulation Flag for simulation.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)printReceiptIntentResult:(TerminalGatewayTerminalResult *)result isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("printReceiptIntent(result:isSimulation:listener:)")));

/**
 * Initiates a receipt print job for a given terminal result using a callback.
 *
 * @param result The terminal result.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)printReceiptIntentResult:(TerminalGatewayTerminalResult *)result isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("printReceiptIntent(result:isSimulation:callback:)")));

/**
 * Prints a receipt for a specific trace number or the last transaction.
 * Handles QRIS status checks as an alternative to simple reprinting if required.
 *
 * @param method The sale method.
 * @param traceNumber The optional trace number.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)printReceiptIntentMethod:(TerminalGatewaySaleMethod *)method traceNumber:(NSString * _Nullable)traceNumber isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("printReceiptIntent(method:traceNumber:isSimulation:callback:)")));
- (void)setTerminalDeviceDevice:(TerminalGatewayBaseTerminalDevice *)device __attribute__((swift_name("setTerminalDevice(device:)")));

/**
 * Performs a settlement operation and prints the settlement receipt.
 *
 * @param method The sale method to settle.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)settlementIntentMethod:(TerminalGatewaySaleMethod *)method listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("settlementIntent(method:listener:)")));

/**
 * Performs a settlement operation and prints the settlement receipt using a callback.
 *
 * @param method The sale method to settle.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)settlementIntentMethod:(TerminalGatewaySaleMethod *)method isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("settlementIntent(method:isSimulation:callback:)")));
- (NSString * _Nullable)terminalIDData:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));
- (NSArray<id<TerminalGatewayTerminalAction>> *)toActionsCommandType:(TerminalGatewayCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (TerminalGatewayPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable)toResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(json:)")));

/**
 * Converts the raw JSON response from the terminal into a format suitable for backend synchronization.
 * It handles different transaction types (payment, void, callback) and filters based on status.
 *
 * @param request The original request JSON.
 * @param json The response JSON from the terminal.
 * @param transactions The transaction context.
 * @return A pair of the transaction type name and the synchronized JSON payload.
 */
- (TerminalGatewayKotlinPair<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)json transactions:(TerminalGatewayTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (TerminalGatewayTerminalResult * _Nullable)toTerminalResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(json:)")));
- (TerminalGatewayTerminalResult *)transformJsonToResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));
- (int32_t)transformValueJson:(NSString * _Nullable)json __attribute__((swift_name("transformValue(json:)")));
- (int32_t)transformValueJson_:(TerminalGatewayKotlinx_serialization_jsonJsonPrimitive * _Nullable)json __attribute__((swift_name("transformValue(json_:)")));
- (NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)updateJsonObjectValueJsonObject:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)jsonObject key:(NSString *)key newValue:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)newValue __attribute__((swift_name("updateJsonObjectValue(jsonObject:key:newValue:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TerminalGatewayBluetoothService> bluetooth __attribute__((swift_name("bluetooth")));
@property (readonly) TerminalGatewayBaseFakeResponseGenerator *fakeGenerator __attribute__((swift_name("fakeGenerator")));
@property (readonly) TerminalGatewayTerminalResult * _Nullable latestPayment __attribute__((swift_name("latestPayment")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TerminalGatewayBriEDCWebSocketService *wifi __attribute__((swift_name("wifi")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalBRI")))
@interface TerminalGatewayTerminalBRI : TerminalGatewayBaseTerminalBRI
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalBRI __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTerminalBRI *shared __attribute__((swift_name("shared")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((swift_name("Action")))
@interface TerminalGatewayAction : TerminalGatewayBase
- (instancetype)initWithData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayActionCompanion *companion __attribute__((swift_name("companion")));
- (NSString * _Nullable)getPaymentMethod __attribute__((swift_name("getPaymentMethod()")));
- (NSString * _Nullable)getPaymentMethodData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethod __attribute__((swift_name("getServicePaymentMethod()")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (id<TerminalGatewayTerminalAction> _Nullable)getTerminalAction __attribute__((swift_name("getTerminalAction()")));
- (id<TerminalGatewayTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmount __attribute__((swift_name("getTransactionAmount()")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderID __attribute__((swift_name("getTransactionOrderID()")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
- (BOOL)isNeedVerified __attribute__((swift_name("isNeedVerified()")));
@property (readonly) NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *data __attribute__((swift_name("data")));
@end


/**
 * Sealed class representing all supported actions for the BRI (Bank Rakyat Indonesia) terminal protocol.
 * Maps high-level terminal actions to the specific JSON payload keys (e.g., "action", "method", "amount")
 * required by the BRI EDC WebSocket API.
 */
__attribute__((swift_name("BRIAction")))
@interface TerminalGatewayBRIAction : TerminalGatewayAction
- (instancetype)initWithData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayBRIActionCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)getPaymentMethodData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (TerminalGatewayBRITerminalAction * _Nullable)getTerminalActionData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end


/**
 * Represents a Card Verification request.
 * Used to verify card validity without capturing funds immediately.
 *
 * @param orderID The transaction ID.
 * @param amount The amount (usually 0 or nominal).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionCardVerification")))
@interface TerminalGatewayBRIActionCardVerification<T> : TerminalGatewayBRIAction
- (instancetype)initWithOrderID:(NSString *)orderID amount:(T)amount __attribute__((swift_name("init(orderID:amount:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayBRIActionCardVerificationCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayBRIActionCardVerification<T> *)doCopyOrderID:(NSString *)orderID amount:(T)amount __attribute__((swift_name("doCopy(orderID:amount:)")));

/**
 * Represents a Card Verification request.
 * Used to verify card validity without capturing funds immediately.
 *
 * @param orderID The transaction ID.
 * @param amount The amount (usually 0 or nominal).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Card Verification request.
 * Used to verify card validity without capturing funds immediately.
 *
 * @param orderID The transaction ID.
 * @param amount The amount (usually 0 or nominal).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Card Verification request.
 * Used to verify card validity without capturing funds immediately.
 *
 * @param orderID The transaction ID.
 * @param amount The amount (usually 0 or nominal).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) T amount __attribute__((swift_name("amount")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionCardVerificationCompanion")))
@interface TerminalGatewayBRIActionCardVerificationCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayBRIActionCardVerificationCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayBRIActionCardVerification<id> *)fromPaymentPayment:(TerminalGatewayBRIActionPayment<id> *)payment transform:(id (^)(TerminalGatewayKotlinx_serialization_jsonJsonPrimitive * _Nullable))transform __attribute__((swift_name("fromPayment(payment:transform:)")));
@end


/**
 * Represents a Status Check request.
 * Can check status by Order ID (trx_id) or Reference Number (for QRIS).
 *
 * @param orderID The order identifier.
 * @param referenceNumber The reference number (specific to QRIS checks).
 * @param method The sale method context.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIAction.CheckStatus")))
@interface TerminalGatewayBRIActionCheckStatus : TerminalGatewayBRIAction
- (instancetype)initWithOrderID:(NSString * _Nullable)orderID referenceNumber:(NSString * _Nullable)referenceNumber method:(TerminalGatewaySaleMethod * _Nullable)method verification:(BOOL)verification __attribute__((swift_name("init(orderID:referenceNumber:method:verification:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionCheckStatus *)doCopyOrderID:(NSString * _Nullable)orderID referenceNumber:(NSString * _Nullable)referenceNumber method:(TerminalGatewaySaleMethod * _Nullable)method verification:(BOOL)verification __attribute__((swift_name("doCopy(orderID:referenceNumber:method:verification:)")));

/**
 * Represents a Status Check request.
 * Can check status by Order ID (trx_id) or Reference Number (for QRIS).
 *
 * @param orderID The order identifier.
 * @param referenceNumber The reference number (specific to QRIS checks).
 * @param method The sale method context.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Status Check request.
 * Can check status by Order ID (trx_id) or Reference Number (for QRIS).
 *
 * @param orderID The order identifier.
 * @param referenceNumber The reference number (specific to QRIS checks).
 * @param method The sale method context.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isNeedVerified __attribute__((swift_name("isNeedVerified()")));

/**
 * Represents a Status Check request.
 * Can check status by Order ID (trx_id) or Reference Number (for QRIS).
 *
 * @param orderID The order identifier.
 * @param referenceNumber The reference number (specific to QRIS checks).
 * @param method The sale method context.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewaySaleMethod * _Nullable method __attribute__((swift_name("method")));
@property (readonly) NSString * _Nullable orderID __attribute__((swift_name("orderID")));
@property (readonly) NSString * _Nullable referenceNumber __attribute__((swift_name("referenceNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIAction.Companion")))
@interface TerminalGatewayBRIActionCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayBRIActionCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *ACTION __attribute__((swift_name("ACTION")));
@property (readonly) NSString *AMOUNT __attribute__((swift_name("AMOUNT")));
@property (readonly) NSString *APPROVAL __attribute__((swift_name("APPROVAL")));
@property (readonly) NSString *METHOD __attribute__((swift_name("METHOD")));
@property (readonly) NSString *PERIOD __attribute__((swift_name("PERIOD")));
@property (readonly) NSString *PLAN __attribute__((swift_name("PLAN")));
@property (readonly) NSString *POS_ADDRESS __attribute__((swift_name("POS_ADDRESS")));
@property (readonly) NSString *REFERENCE_ID __attribute__((swift_name("REFERENCE_ID")));
@property (readonly) NSString *REFERENCE_NUMBER __attribute__((swift_name("REFERENCE_NUMBER")));
@property (readonly) NSString *TRACE_NUMBER __attribute__((swift_name("TRACE_NUMBER")));
@property (readonly) NSString *TRX_ID __attribute__((swift_name("TRX_ID")));
@end


/**
 * Base class for payment-related actions.
 *
 * @param action The specific terminal action (e.g., SALE, CONTACTLESS).
 * @param orderID The unique identifier for the order (trx_id).
 * @param amount The transaction amount.
 * @param method The sale method (e.g., PURCHASE, QRIS).
 */
__attribute__((swift_name("BRIActionPayment")))
@interface TerminalGatewayBRIActionPayment<T> : TerminalGatewayBRIAction
- (instancetype)initWithAction:(TerminalGatewayBRITerminalAction *)action orderID:(NSString *)orderID amount:(T)amount method:(TerminalGatewaySaleMethod * _Nullable)method __attribute__((swift_name("init(action:orderID:amount:method:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * Represents a Contactless Sale transaction (Tap Card).
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionContactless")))
@interface TerminalGatewayBRIActionContactless<T> : TerminalGatewayBRIActionPayment<T>
- (instancetype)initWithOrderID:(NSString *)orderID amount:(T)amount __attribute__((swift_name("init(orderID:amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithAction:(TerminalGatewayBRITerminalAction *)action orderID:(NSString *)orderID amount:(id)amount method:(TerminalGatewaySaleMethod * _Nullable)method __attribute__((swift_name("init(action:orderID:amount:method:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (TerminalGatewayBRIActionContactless<T> *)doCopyOrderID:(NSString *)orderID amount:(T)amount __attribute__((swift_name("doCopy(orderID:amount:)")));

/**
 * Represents a Contactless Sale transaction (Tap Card).
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Contactless Sale transaction (Tap Card).
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Contactless Sale transaction (Tap Card).
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) T amount __attribute__((swift_name("amount")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@end


/**
 * Represents an Installment Payment Plan transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The total transaction amount.
 * @param plan The installment plan code.
 * @param period The installment period (tenor).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionInstallment")))
@interface TerminalGatewayBRIActionInstallment<T> : TerminalGatewayBRIAction
- (instancetype)initWithOrderID:(NSString *)orderID amount:(T)amount plan:(NSString *)plan period:(NSString *)period __attribute__((swift_name("init(orderID:amount:plan:period:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionInstallment<T> *)doCopyOrderID:(NSString *)orderID amount:(T)amount plan:(NSString *)plan period:(NSString *)period __attribute__((swift_name("doCopy(orderID:amount:plan:period:)")));

/**
 * Represents an Installment Payment Plan transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The total transaction amount.
 * @param plan The installment plan code.
 * @param period The installment period (tenor).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents an Installment Payment Plan transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The total transaction amount.
 * @param plan The installment plan code.
 * @param period The installment period (tenor).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents an Installment Payment Plan transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The total transaction amount.
 * @param plan The installment plan code.
 * @param period The installment period (tenor).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) T amount __attribute__((swift_name("amount")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@property (readonly) NSString *period __attribute__((swift_name("period")));
@property (readonly) NSString *plan __attribute__((swift_name("plan")));
@end


/**
 * Represents a Refund request specifically for QRIS transactions.
 *
 * @param referenceID The reference ID of the transaction to refund.
 * @param method The sale method (defaults to QRIS).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIAction.RefundQris")))
@interface TerminalGatewayBRIActionRefundQris : TerminalGatewayBRIAction
- (instancetype)initWithReferenceID:(NSString *)referenceID method:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("init(referenceID:method:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionRefundQris *)doCopyReferenceID:(NSString *)referenceID method:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("doCopy(referenceID:method:)")));

/**
 * Represents a Refund request specifically for QRIS transactions.
 *
 * @param referenceID The reference ID of the transaction to refund.
 * @param method The sale method (defaults to QRIS).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Refund request specifically for QRIS transactions.
 *
 * @param referenceID The reference ID of the transaction to refund.
 * @param method The sale method (defaults to QRIS).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Refund request specifically for QRIS transactions.
 *
 * @param referenceID The reference ID of the transaction to refund.
 * @param method The sale method (defaults to QRIS).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewaySaleMethod *method __attribute__((swift_name("method")));
@property (readonly) NSString *referenceID __attribute__((swift_name("referenceID")));
@end


/**
 * Represents a request to reprint a specific transaction receipt.
 *
 * @param traceNumber The trace number of the transaction.
 * @param method The sale method (e.g., PURCHASE, BRIZZI).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIAction.ReprintAny")))
@interface TerminalGatewayBRIActionReprintAny : TerminalGatewayBRIAction
- (instancetype)initWithTraceNumber:(int32_t)traceNumber method:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("init(traceNumber:method:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionReprintAny *)doCopyTraceNumber:(int32_t)traceNumber method:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("doCopy(traceNumber:method:)")));

/**
 * Represents a request to reprint a specific transaction receipt.
 *
 * @param traceNumber The trace number of the transaction.
 * @param method The sale method (e.g., PURCHASE, BRIZZI).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a request to reprint a specific transaction receipt.
 *
 * @param traceNumber The trace number of the transaction.
 * @param method The sale method (e.g., PURCHASE, BRIZZI).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a request to reprint a specific transaction receipt.
 *
 * @param traceNumber The trace number of the transaction.
 * @param method The sale method (e.g., PURCHASE, BRIZZI).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewaySaleMethod *method __attribute__((swift_name("method")));
@property (readonly) int32_t traceNumber __attribute__((swift_name("traceNumber")));
@end


/**
 * Represents a request to reprint the last transaction receipt.
 *
 * @param method The sale method (e.g., PURCHASE, BRIZZI).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIAction.ReprintLast")))
@interface TerminalGatewayBRIActionReprintLast : TerminalGatewayBRIAction
- (instancetype)initWithMethod:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("init(method:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionReprintLast *)doCopyMethod:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("doCopy(method:)")));

/**
 * Represents a request to reprint the last transaction receipt.
 *
 * @param method The sale method (e.g., PURCHASE, BRIZZI).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a request to reprint the last transaction receipt.
 *
 * @param method The sale method (e.g., PURCHASE, BRIZZI).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a request to reprint the last transaction receipt.
 *
 * @param method The sale method (e.g., PURCHASE, BRIZZI).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewaySaleMethod *method __attribute__((swift_name("method")));
@end


/**
 * Represents a standard Sale transaction (Insert/Swipe Card).
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param method The sale method (defaults to PURCHASE).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionSale")))
@interface TerminalGatewayBRIActionSale<T> : TerminalGatewayBRIActionPayment<T>
- (instancetype)initWithOrderID:(NSString *)orderID amount:(T)amount method:(TerminalGatewaySaleMethod * _Nullable)method __attribute__((swift_name("init(orderID:amount:method:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithAction:(TerminalGatewayBRITerminalAction *)action orderID:(NSString *)orderID amount:(id)amount method:(TerminalGatewaySaleMethod * _Nullable)method __attribute__((swift_name("init(action:orderID:amount:method:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (TerminalGatewayBRIActionSale<T> *)doCopyOrderID:(NSString *)orderID amount:(T)amount method:(TerminalGatewaySaleMethod * _Nullable)method __attribute__((swift_name("doCopy(orderID:amount:method:)")));

/**
 * Represents a standard Sale transaction (Insert/Swipe Card).
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param method The sale method (defaults to PURCHASE).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a standard Sale transaction (Insert/Swipe Card).
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param method The sale method (defaults to PURCHASE).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a standard Sale transaction (Insert/Swipe Card).
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param method The sale method (defaults to PURCHASE).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) T amount __attribute__((swift_name("amount")));
@property (readonly) TerminalGatewaySaleMethod * _Nullable method __attribute__((swift_name("method")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@end


/**
 * Represents a Sale Completion request.
 * Used to finalize a transaction using an approval code.
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param approval The approval code from the original authorization.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionSaleCompletion")))
@interface TerminalGatewayBRIActionSaleCompletion<T> : TerminalGatewayBRIAction
- (instancetype)initWithOrderID:(NSString *)orderID amount:(T)amount approval:(NSString *)approval __attribute__((swift_name("init(orderID:amount:approval:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionSaleCompletion<T> *)doCopyOrderID:(NSString *)orderID amount:(T)amount approval:(NSString *)approval __attribute__((swift_name("doCopy(orderID:amount:approval:)")));

/**
 * Represents a Sale Completion request.
 * Used to finalize a transaction using an approval code.
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param approval The approval code from the original authorization.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Sale Completion request.
 * Used to finalize a transaction using an approval code.
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param approval The approval code from the original authorization.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Sale Completion request.
 * Used to finalize a transaction using an approval code.
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param approval The approval code from the original authorization.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) T amount __attribute__((swift_name("amount")));
@property (readonly) NSString *approval __attribute__((swift_name("approval")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@end


/**
 * Represents a Settlement request.
 *
 * @param method Optional sale method to settle specific batches (e.g., just QRIS or just Cards).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIAction.Settlement")))
@interface TerminalGatewayBRIActionSettlement : TerminalGatewayBRIAction
- (instancetype)initWithMethod:(TerminalGatewaySaleMethod * _Nullable)method __attribute__((swift_name("init(method:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionSettlement *)doCopyMethod:(TerminalGatewaySaleMethod * _Nullable)method __attribute__((swift_name("doCopy(method:)")));

/**
 * Represents a Settlement request.
 *
 * @param method Optional sale method to settle specific batches (e.g., just QRIS or just Cards).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Settlement request.
 *
 * @param method Optional sale method to settle specific batches (e.g., just QRIS or just Cards).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Settlement request.
 *
 * @param method Optional sale method to settle specific batches (e.g., just QRIS or just Cards).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewaySaleMethod * _Nullable method __attribute__((swift_name("method")));
@end


/**
 * Represents a Void transaction request.
 *
 * @param traceNumber The trace number of the transaction to void.
 * @param method The sale method.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIAction.Void")))
@interface TerminalGatewayBRIActionVoid : TerminalGatewayBRIAction
- (instancetype)initWithTraceNumber:(int32_t)traceNumber method:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("init(traceNumber:method:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionVoid *)doCopyTraceNumber:(int32_t)traceNumber method:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("doCopy(traceNumber:method:)")));

/**
 * Represents a Void transaction request.
 *
 * @param traceNumber The trace number of the transaction to void.
 * @param method The sale method.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Void transaction request.
 *
 * @param traceNumber The trace number of the transaction to void.
 * @param method The sale method.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Void transaction request.
 *
 * @param traceNumber The trace number of the transaction to void.
 * @param method The sale method.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewaySaleMethod *method __attribute__((swift_name("method")));
@property (readonly) int32_t traceNumber __attribute__((swift_name("traceNumber")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((swift_name("TransactionsRequestPayload")))
@interface TerminalGatewayTransactionsRequestPayload : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayTransactionsRequestPayloadCompanion *companion __attribute__((swift_name("companion")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPayload")))
@interface TerminalGatewayBRIPayload : TerminalGatewayTransactionsRequestPayload
- (instancetype)initWithSerialNumber:(NSString *)serialNumber merchantName:(NSString * _Nullable)merchantName transactionDate:(NSString *)transactionDate cardNumber:(NSString *)cardNumber cardPrinciple:(NSString * _Nullable)cardPrinciple remark:(NSString *)remark settlementAmount:(TerminalGatewayDouble * _Nullable)settlementAmount transactionAmount:(double)transactionAmount approvalCode:(NSString *)approvalCode batchNo:(NSString *)batchNo traceNo:(NSString *)traceNo refId:(NSString *)refId mdr:(TerminalGatewayDouble * _Nullable)mdr mdrAmount:(TerminalGatewayDouble * _Nullable)mdrAmount netAmount:(double)netAmount paymentMethod:(TerminalGatewayPaymentMethod_ *)paymentMethod issuingBank:(NSString * _Nullable)issuingBank isCredit:(BOOL)isCredit isOffUs:(BOOL)isOffUs transactionId:(NSString *)transactionId referenceNumber:(NSString *)referenceNumber __attribute__((swift_name("init(serialNumber:merchantName:transactionDate:cardNumber:cardPrinciple:remark:settlementAmount:transactionAmount:approvalCode:batchNo:traceNo:refId:mdr:mdrAmount:netAmount:paymentMethod:issuingBank:isCredit:isOffUs:transactionId:referenceNumber:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayBRIPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayBRIPayload *)doCopySerialNumber:(NSString *)serialNumber merchantName:(NSString * _Nullable)merchantName transactionDate:(NSString *)transactionDate cardNumber:(NSString *)cardNumber cardPrinciple:(NSString * _Nullable)cardPrinciple remark:(NSString *)remark settlementAmount:(TerminalGatewayDouble * _Nullable)settlementAmount transactionAmount:(double)transactionAmount approvalCode:(NSString *)approvalCode batchNo:(NSString *)batchNo traceNo:(NSString *)traceNo refId:(NSString *)refId mdr:(TerminalGatewayDouble * _Nullable)mdr mdrAmount:(TerminalGatewayDouble * _Nullable)mdrAmount netAmount:(double)netAmount paymentMethod:(TerminalGatewayPaymentMethod_ *)paymentMethod issuingBank:(NSString * _Nullable)issuingBank isCredit:(BOOL)isCredit isOffUs:(BOOL)isOffUs transactionId:(NSString *)transactionId referenceNumber:(NSString *)referenceNumber __attribute__((swift_name("doCopy(serialNumber:merchantName:transactionDate:cardNumber:cardPrinciple:remark:settlementAmount:transactionAmount:approvalCode:batchNo:traceNo:refId:mdr:mdrAmount:netAmount:paymentMethod:issuingBank:isCredit:isOffUs:transactionId:referenceNumber:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="approval_code")
*/
@property (readonly) NSString *approvalCode __attribute__((swift_name("approvalCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_no")
*/
@property (readonly) NSString *batchNo __attribute__((swift_name("batchNo")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_number")
*/
@property (readonly) NSString *cardNumber __attribute__((swift_name("cardNumber")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_principle")
*/
@property (readonly) NSString * _Nullable cardPrinciple __attribute__((swift_name("cardPrinciple")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="is_credit")
*/
@property (readonly) BOOL isCredit __attribute__((swift_name("isCredit")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="is_off_us")
*/
@property (readonly) BOOL isOffUs __attribute__((swift_name("isOffUs")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="issuing_bank")
*/
@property (readonly) NSString * _Nullable issuingBank __attribute__((swift_name("issuingBank")));
@property (readonly) TerminalGatewayDouble * _Nullable mdr __attribute__((swift_name("mdr")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="mdr_amount")
*/
@property (readonly) TerminalGatewayDouble * _Nullable mdrAmount __attribute__((swift_name("mdrAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_name")
*/
@property (readonly) NSString * _Nullable merchantName __attribute__((swift_name("merchantName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="net_amount")
*/
@property (readonly) double netAmount __attribute__((swift_name("netAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) TerminalGatewayPaymentMethod_ *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ref_id")
*/
@property (readonly) NSString *refId __attribute__((swift_name("refId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reference_number")
*/
@property (readonly) NSString *referenceNumber __attribute__((swift_name("referenceNumber")));
@property (readonly) NSString *remark __attribute__((swift_name("remark")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="serial_number")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="settlement_amount")
*/
@property (readonly) TerminalGatewayDouble * _Nullable settlementAmount __attribute__((swift_name("settlementAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="trace_no")
*/
@property (readonly) NSString *traceNo __attribute__((swift_name("traceNo")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_amount")
*/
@property (readonly) double transactionAmount __attribute__((swift_name("transactionAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString *transactionDate __attribute__((swift_name("transactionDate")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_id")
*/
@property (readonly) NSString *transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPayload.Companion")))
@interface TerminalGatewayBRIPayloadCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayBRIPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("KotlinComparable")))
@protocol TerminalGatewayKotlinComparable
@required
- (int32_t)compareToOther:(id _Nullable)other __attribute__((swift_name("compareTo(other:)")));
@end

__attribute__((swift_name("KotlinEnum")))
@interface TerminalGatewayKotlinEnum<E> : TerminalGatewayBase <TerminalGatewayKotlinComparable>
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinEnumCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(E)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) int32_t ordinal __attribute__((swift_name("ordinal")));
@end

__attribute__((swift_name("TerminalAction")))
@protocol TerminalGatewayTerminalAction
@required
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/BRITerminalAction.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRITerminalAction")))
@interface TerminalGatewayBRITerminalAction : TerminalGatewayKotlinEnum<TerminalGatewayBRITerminalAction *> <TerminalGatewayTerminalAction>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayBRITerminalActionCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayBRITerminalAction *contactless __attribute__((swift_name("contactless")));
@property (class, readonly) TerminalGatewayBRITerminalAction *sale __attribute__((swift_name("sale")));
@property (class, readonly) TerminalGatewayBRITerminalAction *settlement __attribute__((swift_name("settlement")));
@property (class, readonly) TerminalGatewayBRITerminalAction *void_ __attribute__((swift_name("void_")));
@property (class, readonly) TerminalGatewayBRITerminalAction *reprintAny __attribute__((swift_name("reprintAny")));
@property (class, readonly) TerminalGatewayBRITerminalAction *reprintLast __attribute__((swift_name("reprintLast")));
@property (class, readonly) TerminalGatewayBRITerminalAction *cardVerification __attribute__((swift_name("cardVerification")));
@property (class, readonly) TerminalGatewayBRITerminalAction *saleCompletion __attribute__((swift_name("saleCompletion")));
@property (class, readonly) TerminalGatewayBRITerminalAction *installment __attribute__((swift_name("installment")));
@property (class, readonly) TerminalGatewayBRITerminalAction *checkStatus __attribute__((swift_name("checkStatus")));
@property (class, readonly) TerminalGatewayBRITerminalAction *checkTrx __attribute__((swift_name("checkTrx")));
@property (class, readonly) TerminalGatewayBRITerminalAction *refundQris __attribute__((swift_name("refundQris")));
@property (class, readonly) TerminalGatewayBRITerminalAction *unknown __attribute__((swift_name("unknown")));
+ (TerminalGatewayKotlinArray<TerminalGatewayBRITerminalAction *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayBRITerminalAction *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerializationStrategy")))
@protocol TerminalGatewayKotlinx_serialization_coreSerializationStrategy
@required
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(id _Nullable)value __attribute__((swift_name("serialize(encoder:value:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreDeserializationStrategy")))
@protocol TerminalGatewayKotlinx_serialization_coreDeserializationStrategy
@required
- (id _Nullable)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreKSerializer")))
@protocol TerminalGatewayKotlinx_serialization_coreKSerializer <TerminalGatewayKotlinx_serialization_coreSerializationStrategy, TerminalGatewayKotlinx_serialization_coreDeserializationStrategy>
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRITerminalAction.Companion")))
@interface TerminalGatewayBRITerminalActionCompanion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayBRITerminalActionCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayBRITerminalAction *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewayBRITerminalAction *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TerminalGatewayBRITerminalAction *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/BriStatus.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriStatus")))
@interface TerminalGatewayBriStatus : TerminalGatewayKotlinEnum<TerminalGatewayBriStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayBriStatusCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayBriStatus *success __attribute__((swift_name("success")));
@property (class, readonly) TerminalGatewayBriStatus *failed __attribute__((swift_name("failed")));
@property (class, readonly) TerminalGatewayBriStatus *paid __attribute__((swift_name("paid")));
@property (class, readonly) TerminalGatewayBriStatus *unpaid __attribute__((swift_name("unpaid")));
@property (class, readonly) TerminalGatewayBriStatus *refund __attribute__((swift_name("refund")));
@property (class, readonly) TerminalGatewayBriStatus *notFound __attribute__((swift_name("notFound")));
@property (class, readonly) TerminalGatewayBriStatus *unknown __attribute__((swift_name("unknown")));
+ (TerminalGatewayKotlinArray<TerminalGatewayBriStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayBriStatus *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriStatus.Companion")))
@interface TerminalGatewayBriStatusCompanion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayBriStatusCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayBriStatus *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewayBriStatus *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TerminalGatewayBriStatus *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@property (readonly) NSArray<TerminalGatewayBriStatus *> *successStatusList __attribute__((swift_name("successStatusList")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriTerminalResult")))
@interface TerminalGatewayBriTerminalResult : TerminalGatewayBase
- (instancetype)initWithAcqMid:(NSString * _Nullable)acqMid acqTid:(NSString * _Nullable)acqTid action:(TerminalGatewayBRITerminalAction * _Nullable)action amount:(NSString * _Nullable)amount approval:(NSString * _Nullable)approval batchNumber:(NSString * _Nullable)batchNumber cardCategory:(NSString * _Nullable)cardCategory cardName:(NSString * _Nullable)cardName cardType:(NSString * _Nullable)cardType edcAddress:(NSString * _Nullable)edcAddress isCredit:(NSString * _Nullable)isCredit isOffUs:(NSString * _Nullable)isOffUs method:(TerminalGatewaySaleMethod * _Nullable)method message:(NSString * _Nullable)message pan:(NSString * _Nullable)pan referenceID:(NSString * _Nullable)referenceID period:(NSString * _Nullable)period plan:(NSString * _Nullable)plan posAddress:(NSString * _Nullable)posAddress responseCode:(NSString * _Nullable)responseCode referenceNumber:(NSString * _Nullable)referenceNumber status:(TerminalGatewayBriStatus * _Nullable)status traceNumber:(NSString * _Nullable)traceNumber transactionDate:(NSString * _Nullable)transactionDate transactionID:(NSString * _Nullable)transactionID __attribute__((swift_name("init(acqMid:acqTid:action:amount:approval:batchNumber:cardCategory:cardName:cardType:edcAddress:isCredit:isOffUs:method:message:pan:referenceID:period:plan:posAddress:responseCode:referenceNumber:status:traceNumber:transactionDate:transactionID:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayBriTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayBriTerminalResult *)doCopyAcqMid:(NSString * _Nullable)acqMid acqTid:(NSString * _Nullable)acqTid action:(TerminalGatewayBRITerminalAction * _Nullable)action amount:(NSString * _Nullable)amount approval:(NSString * _Nullable)approval batchNumber:(NSString * _Nullable)batchNumber cardCategory:(NSString * _Nullable)cardCategory cardName:(NSString * _Nullable)cardName cardType:(NSString * _Nullable)cardType edcAddress:(NSString * _Nullable)edcAddress isCredit:(NSString * _Nullable)isCredit isOffUs:(NSString * _Nullable)isOffUs method:(TerminalGatewaySaleMethod * _Nullable)method message:(NSString * _Nullable)message pan:(NSString * _Nullable)pan referenceID:(NSString * _Nullable)referenceID period:(NSString * _Nullable)period plan:(NSString * _Nullable)plan posAddress:(NSString * _Nullable)posAddress responseCode:(NSString * _Nullable)responseCode referenceNumber:(NSString * _Nullable)referenceNumber status:(TerminalGatewayBriStatus * _Nullable)status traceNumber:(NSString * _Nullable)traceNumber transactionDate:(NSString * _Nullable)transactionDate transactionID:(NSString * _Nullable)transactionID __attribute__((swift_name("doCopy(acqMid:acqTid:action:amount:approval:batchNumber:cardCategory:cardName:cardType:edcAddress:isCredit:isOffUs:method:message:pan:referenceID:period:plan:posAddress:responseCode:referenceNumber:status:traceNumber:transactionDate:transactionID:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
- (TerminalGatewayTerminalResult *)toTerminalResult __attribute__((swift_name("toTerminalResult()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="acq_mid")
*/
@property NSString * _Nullable acqMid __attribute__((swift_name("acqMid")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="acq_tid")
*/
@property NSString * _Nullable acqTid __attribute__((swift_name("acqTid")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="action")
*/
@property TerminalGatewayBRITerminalAction * _Nullable action __attribute__((swift_name("action")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property NSString * _Nullable amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="approval")
*/
@property NSString * _Nullable approval __attribute__((swift_name("approval")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_number")
*/
@property NSString * _Nullable batchNumber __attribute__((swift_name("batchNumber")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_category")
*/
@property NSString * _Nullable cardCategory __attribute__((swift_name("cardCategory")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_name")
*/
@property NSString * _Nullable cardName __attribute__((swift_name("cardName")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_type")
*/
@property NSString * _Nullable cardType __attribute__((swift_name("cardType")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="edc_address")
*/
@property NSString * _Nullable edcAddress __attribute__((swift_name("edcAddress")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="is_credit")
*/
@property NSString * _Nullable isCredit __attribute__((swift_name("isCredit")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="is_off_us")
*/
@property NSString * _Nullable isOffUs __attribute__((swift_name("isOffUs")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="msg")
*/
@property NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="method")
*/
@property TerminalGatewaySaleMethod * _Nullable method __attribute__((swift_name("method")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="pan")
*/
@property NSString * _Nullable pan __attribute__((swift_name("pan")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="periode")
*/
@property NSString * _Nullable period __attribute__((swift_name("period")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="plan")
*/
@property NSString * _Nullable plan __attribute__((swift_name("plan")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="pos_address")
*/
@property NSString * _Nullable posAddress __attribute__((swift_name("posAddress")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reff_id")
*/
@property NSString * _Nullable referenceID __attribute__((swift_name("referenceID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reference_number")
*/
@property NSString * _Nullable referenceNumber __attribute__((swift_name("referenceNumber")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="rc")
*/
@property NSString * _Nullable responseCode __attribute__((swift_name("responseCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property TerminalGatewayBriStatus * _Nullable status __attribute__((swift_name("status")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="trace_number")
*/
@property NSString * _Nullable traceNumber __attribute__((swift_name("traceNumber")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property NSString * _Nullable transactionDate __attribute__((swift_name("transactionDate")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="trx_id")
*/
@property NSString * _Nullable transactionID __attribute__((swift_name("transactionID")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriTerminalResult.Companion")))
@interface TerminalGatewayBriTerminalResultCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayBriTerminalResultCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Builder class for creating [Installment] intent parameters.
 * Accessible from Swift/ObjC code.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIInstallmentIntentParametersBuilder")))
@interface TerminalGatewayBRIInstallmentIntentParametersBuilder<T> : TerminalGatewayBase
- (instancetype)initWithPlan:(NSString *)plan period:(NSString *)period amount:(T)amount __attribute__((swift_name("init(plan:period:amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithOrderID:(NSString *)orderID plan:(NSString *)plan period:(NSString *)period amount:(T)amount __attribute__((swift_name("init(orderID:plan:period:amount:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionInstallment<T> *)build __attribute__((swift_name("build()")));
@end


/**
 * Builder class for creating [Payment] intent parameters.
 * Accessible from Swift/ObjC code.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIPaymentIntentParametersBuilder")))
@interface TerminalGatewayBRIPaymentIntentParametersBuilder<T> : TerminalGatewayBase
- (instancetype)initWithAmount:(T)amount __attribute__((swift_name("init(amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithAmount:(T)amount method:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("init(amount:method:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithOrderID:(NSString *)orderID amount:(T)amount __attribute__((swift_name("init(orderID:amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithOrderID:(NSString *)orderID amount:(T)amount method:(TerminalGatewaySaleMethod *)method __attribute__((swift_name("init(orderID:amount:method:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBRIActionPayment<T> *)build __attribute__((swift_name("build()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/PaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PaymentMethod_")))
@interface TerminalGatewayPaymentMethod_ : TerminalGatewayKotlinEnum<TerminalGatewayPaymentMethod_ *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayPaymentMethod_Companion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayPaymentMethod_ *insertcard __attribute__((swift_name("insertcard")));
@property (class, readonly) TerminalGatewayPaymentMethod_ *contactless __attribute__((swift_name("contactless")));
@property (class, readonly) TerminalGatewayPaymentMethod_ *qris __attribute__((swift_name("qris")));
@property (class, readonly) TerminalGatewayPaymentMethod_ *brizzi __attribute__((swift_name("brizzi")));
@property (class, readonly) TerminalGatewayPaymentMethod_ *na __attribute__((swift_name("na")));
+ (TerminalGatewayKotlinArray<TerminalGatewayPaymentMethod_ *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayPaymentMethod_ *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PaymentMethod_.Companion")))
@interface TerminalGatewayPaymentMethod_Companion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayPaymentMethod_Companion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayPaymentMethod_ *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (TerminalGatewayPaymentMethod_ *)fromRequestJson:(NSDictionary<NSString *, id> *)json __attribute__((swift_name("fromRequest(json:)")));
- (TerminalGatewayPaymentMethod_ *)fromRequestJson:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)json response:(TerminalGatewayBriTerminalResult *)response __attribute__((swift_name("fromRequest(json:response:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewayPaymentMethod_ *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RefundRequest")))
@interface TerminalGatewayRefundRequest : TerminalGatewayTransactionsRequestPayload
- (instancetype)initWithSerialNumber:(NSString *)serialNumber transactionDate:(NSString *)transactionDate amount:(double)amount reason:(NSString *)reason paymentMethod:(TerminalGatewayPaymentMethod_ *)paymentMethod refundId:(NSString *)refundId refId:(NSString * _Nullable)refId approvalCode:(NSString * _Nullable)approvalCode batchNo:(NSString * _Nullable)batchNo __attribute__((swift_name("init(serialNumber:transactionDate:amount:reason:paymentMethod:refundId:refId:approvalCode:batchNo:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayRefundRequestCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) double amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="approval_code")
*/
@property (readonly) NSString * _Nullable approvalCode __attribute__((swift_name("approvalCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_no")
*/
@property (readonly) NSString * _Nullable batchNo __attribute__((swift_name("batchNo")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) TerminalGatewayPaymentMethod_ *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reason")
*/
@property (readonly) NSString *reason __attribute__((swift_name("reason")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ref_id")
*/
@property (readonly) NSString * _Nullable refId __attribute__((swift_name("refId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="refund_id")
*/
@property (readonly) NSString *refundId __attribute__((swift_name("refundId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="serial_number")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString *transactionDate __attribute__((swift_name("transactionDate")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RefundRequest.Companion")))
@interface TerminalGatewayRefundRequestCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayRefundRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Enumeration of supported sale methods in the BRI terminal protocol.
 * Maps keys like "purchase", "qris", "brizzi" to internal types.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/SaleMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SaleMethod")))
@interface TerminalGatewaySaleMethod : TerminalGatewayKotlinEnum<TerminalGatewaySaleMethod *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enumeration of supported sale methods in the BRI terminal protocol.
 * Maps keys like "purchase", "qris", "brizzi" to internal types.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewaySaleMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewaySaleMethod *qris __attribute__((swift_name("qris")));
@property (class, readonly) TerminalGatewaySaleMethod *brizzi __attribute__((swift_name("brizzi")));
@property (class, readonly) TerminalGatewaySaleMethod *purchase __attribute__((swift_name("purchase")));
@property (class, readonly) TerminalGatewaySaleMethod *purchaseContactless __attribute__((swift_name("purchaseContactless")));
@property (class, readonly) TerminalGatewaySaleMethod *cardVerification __attribute__((swift_name("cardVerification")));
@property (class, readonly) TerminalGatewaySaleMethod *na __attribute__((swift_name("na")));
@property (class, readonly) TerminalGatewaySaleMethod *none __attribute__((swift_name("none")));
+ (TerminalGatewayKotlinArray<TerminalGatewaySaleMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewaySaleMethod *> *entries __attribute__((swift_name("entries")));
- (TerminalGatewayPaymentMethod * _Nullable)toPaymentMethod __attribute__((swift_name("toPaymentMethod()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SaleMethod.Companion")))
@interface TerminalGatewaySaleMethodCompanion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewaySaleMethodCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewaySaleMethod *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (TerminalGatewaySaleMethod *)fromPaymentMethodMethodName:(NSString * _Nullable)methodName __attribute__((swift_name("fromPaymentMethod(methodName:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewaySaleMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TerminalGatewaySaleMethod *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/bri/data/ServicePaymentMethod.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServicePaymentMethod")))
@interface TerminalGatewayServicePaymentMethod : TerminalGatewayKotlinEnum<TerminalGatewayServicePaymentMethod *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayServicePaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayServicePaymentMethod *idInsertCard __attribute__((swift_name("idInsertCard")));
@property (class, readonly) TerminalGatewayServicePaymentMethod *idContactless __attribute__((swift_name("idContactless")));
@property (class, readonly) TerminalGatewayServicePaymentMethod *idBrizzi __attribute__((swift_name("idBrizzi")));
@property (class, readonly) TerminalGatewayServicePaymentMethod *idQris __attribute__((swift_name("idQris")));
@property (class, readonly) TerminalGatewayServicePaymentMethod *unknown __attribute__((swift_name("unknown")));
+ (TerminalGatewayKotlinArray<TerminalGatewayServicePaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayServicePaymentMethod *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServicePaymentMethod.Companion")))
@interface TerminalGatewayServicePaymentMethodCompanion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayServicePaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayServicePaymentMethod *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewayServicePaymentMethod *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TerminalGatewayServicePaymentMethod *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((swift_name("BaseTerminalDevice")))
@interface TerminalGatewayBaseTerminalDevice : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (BOOL)isProviderAppAvailableProvider:(TerminalGatewayTerminalOperation *)provider __attribute__((swift_name("isProviderAppAvailable(provider:)")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreStateFlow> error __attribute__((swift_name("error")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreMutableStateFlow> errorFlow __attribute__((swift_name("errorFlow")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) NSString *ipAddress __attribute__((swift_name("ipAddress")));
@property int32_t priority __attribute__((swift_name("priority")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreStateFlow> state __attribute__((swift_name("state")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreMutableStateFlow> stateFlow __attribute__((swift_name("stateFlow")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalDevice")))
@interface TerminalGatewayTerminalDevice : TerminalGatewayBaseTerminalDevice
- (instancetype)initWithId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("init(id:ipAddress:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (TerminalGatewayTerminalDevice *)doCopyId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("doCopy(id:ipAddress:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) NSString *ipAddress __attribute__((swift_name("ipAddress")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VoidRequest")))
@interface TerminalGatewayVoidRequest : TerminalGatewayTransactionsRequestPayload
- (instancetype)initWithPaymentRequestId:(NSString * _Nullable)paymentRequestId serialNumber:(NSString *)serialNumber transactionDate:(NSString *)transactionDate paymentMethod:(TerminalGatewayPaymentMethod_ *)paymentMethod approvalCode:(NSString * _Nullable)approvalCode batchNo:(NSString * _Nullable)batchNo refId:(NSString * _Nullable)refId __attribute__((swift_name("init(paymentRequestId:serialNumber:transactionDate:paymentMethod:approvalCode:batchNo:refId:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayVoidRequestCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayVoidRequest *)doCopyPaymentRequestId:(NSString * _Nullable)paymentRequestId serialNumber:(NSString *)serialNumber transactionDate:(NSString *)transactionDate paymentMethod:(TerminalGatewayPaymentMethod_ *)paymentMethod approvalCode:(NSString * _Nullable)approvalCode batchNo:(NSString * _Nullable)batchNo refId:(NSString * _Nullable)refId __attribute__((swift_name("doCopy(paymentRequestId:serialNumber:transactionDate:paymentMethod:approvalCode:batchNo:refId:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="approval_code")
*/
@property (readonly) NSString * _Nullable approvalCode __attribute__((swift_name("approvalCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="batch_no")
*/
@property (readonly) NSString * _Nullable batchNo __attribute__((swift_name("batchNo")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) TerminalGatewayPaymentMethod_ *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_request_id")
*/
@property (readonly) NSString * _Nullable paymentRequestId __attribute__((swift_name("paymentRequestId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ref_id")
*/
@property (readonly) NSString * _Nullable refId __attribute__((swift_name("refId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="serial_number")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString *transactionDate __attribute__((swift_name("transactionDate")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VoidRequest.Companion")))
@interface TerminalGatewayVoidRequestCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayVoidRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("BaseFakeResponseGenerator")))
@interface TerminalGatewayBaseFakeResponseGenerator : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FakeResponseGenerator")))
@interface TerminalGatewayFakeResponseGenerator : TerminalGatewayBaseFakeResponseGenerator
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)fakeResponseGenerator __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayFakeResponseGenerator *shared __attribute__((swift_name("shared")));
- (NSString *)formatDateTimeDateTime:(TerminalGatewayKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
- (NSString *)formatToSimpleDateTimeDateTime:(TerminalGatewayKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatToSimpleDateTime(dateTime:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateRawTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayBriTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generateRaw(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionFakeCode")))
@interface TerminalGatewayTransactionFakeCode : TerminalGatewayKotlinEnum<TerminalGatewayTransactionFakeCode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayTransactionFakeCode *terminalBusy __attribute__((swift_name("terminalBusy")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *declinedByReader __attribute__((swift_name("declinedByReader")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *paymentUnpaid __attribute__((swift_name("paymentUnpaid")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *duplicated __attribute__((swift_name("duplicated")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *cancelled __attribute__((swift_name("cancelled")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *timeout __attribute__((swift_name("timeout")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *noDataFound __attribute__((swift_name("noDataFound")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *voidFailed __attribute__((swift_name("voidFailed")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *refunded __attribute__((swift_name("refunded")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *needDoSettlement __attribute__((swift_name("needDoSettlement")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *noSettlement __attribute__((swift_name("noSettlement")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *chipCardDetected __attribute__((swift_name("chipCardDetected")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *transactionFailed __attribute__((swift_name("transactionFailed")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *tidNotMatch __attribute__((swift_name("tidNotMatch")));
@property (class, readonly) TerminalGatewayTransactionFakeCode *wrongPin __attribute__((swift_name("wrongPin")));
+ (TerminalGatewayKotlinArray<TerminalGatewayTransactionFakeCode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayTransactionFakeCode *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSArray<TerminalGatewayBRITerminalAction *> * _Nullable actions __attribute__((swift_name("actions")));
@property (readonly) id _Nullable amount __attribute__((swift_name("amount")));
@property (readonly) NSString * _Nullable code __attribute__((swift_name("code")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@property (readonly) NSArray<TerminalGatewaySaleMethod *> * _Nullable methods __attribute__((swift_name("methods")));
@property (readonly) id _Nullable traceNumber __attribute__((swift_name("traceNumber")));
@end

__attribute__((swift_name("WebSocketService")))
@interface TerminalGatewayWebSocketService : TerminalGatewayBase
- (instancetype)initWithBuilder:(TerminalGatewayKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)clearMutexTerminalID:(NSString *)terminalID payload:(id _Nullable)payload __attribute__((swift_name("clearMutex(terminalID:payload:)")));
- (void)closeDevice:(TerminalGatewayBaseTerminalDevice *)device __attribute__((swift_name("close(device:)")));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TerminalGatewayBaseTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)connectWithMutexDevice:(TerminalGatewayBaseTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connectWithMutex(device:port:payload:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updatePriorityDevice:(TerminalGatewayBaseTerminalDevice *)device priority:(int32_t)priority __attribute__((swift_name("updatePriority(device:priority:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)updateStateDevice:(TerminalGatewayBaseTerminalDevice *)device state:(TerminalGatewayConnectionState *)state __attribute__((swift_name("updateState(device:state:)")));
@property (readonly) TerminalGatewayMutableDictionary<NSString *, id<TerminalGatewayKotlinx_coroutines_coreMutex>> *mutex __attribute__((swift_name("mutex")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriEDCWebSocketService")))
@interface TerminalGatewayBriEDCWebSocketService : TerminalGatewayWebSocketService
- (instancetype)initWithResultFlow:(id<TerminalGatewayKotlinx_coroutines_coreMutableStateFlow>)resultFlow shouldRetry:(TerminalGatewayBoolean *(^)(TerminalGatewayKotlinException *))shouldRetry builder:(TerminalGatewayKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:shouldRetry:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(TerminalGatewayKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * Connect to the EDC
 * @param device the Terminal Device data
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TerminalGatewayBaseTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
- (TerminalGatewayKtor_client_coreHttpClient *)createClientDevice:(TerminalGatewayBaseTerminalDevice *)device __attribute__((swift_name("createClient(device:)")));
@property (readonly) TerminalGatewayKtor_client_coreHttpClient *(^builder)(void) __attribute__((swift_name("builder")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppInformation")))
@interface TerminalGatewayAppInformation : TerminalGatewayBase
- (instancetype)initWithAppId:(NSString *)appId appName:(NSString *)appName version:(NSString *)version __attribute__((swift_name("init(appId:appName:version:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayAppInformation *)doCopyAppId:(NSString *)appId appName:(NSString *)appName version:(NSString *)version __attribute__((swift_name("doCopy(appId:appName:version:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *appId __attribute__((swift_name("appId")));
@property (readonly) NSString *appName __attribute__((swift_name("appName")));
@property (readonly) NSString *version __attribute__((swift_name("version")));
@end

__attribute__((swift_name("TerminalCore")))
@interface TerminalGatewayTerminalCore<T> : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)addOperationTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("addOperation(terminalOperation:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)checkVersionWithCompletionHandler:(void (^)(TerminalGatewayLatestVersion * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("checkVersion(completionHandler:)")));

/**
 * Get the connection state
 * @return the connection state
 */
- (id<TerminalGatewayKotlinx_coroutines_coreFlow>)connectionStateTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("connectionState(terminalOperation:)")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("disconnect(terminalOperation:)")));

/**
 * Send the payload to the EDC
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)doActionActionJob:(TerminalGatewayActionJob *)actionJob terminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation payload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:terminalOperation:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeConnectionTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation onResult:(void (^)(TerminalGatewayConnectionState *))onResult __attribute__((swift_name("observeConnection(terminalOperation:onResult:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeConnectionScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope>)scope terminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation onResult:(void (^)(TerminalGatewayConnectionState *))onResult __attribute__((swift_name("observeConnection(scope:terminalOperation:onResult:)")));

/**
 * Observe the result
 * @param scope the coroutine scope
 * @param onResult the callback function
 * @return the job
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observePayloadScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable))onResult __attribute__((swift_name("observePayload(scope:onResult:)")));

/**
 * Set device IP address
 */
- (void)setDeviceIpAddressDeviceIpAddress:(NSString *)deviceIpAddress __attribute__((swift_name("setDeviceIpAddress(deviceIpAddress:)")));

/**
 * Set the log level
 */
- (void)setLogLevelLevel:(TerminalGatewayLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));

/**
 * to enable test environment
 */
- (void)setTerminalModeMode:(TerminalGatewayTerminalMode *)mode __attribute__((swift_name("setTerminalMode(mode:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (T)transformValueJson:(NSString * _Nullable)json __attribute__((swift_name("transformValue(json:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (T)transformValueJson_:(TerminalGatewayKotlinx_serialization_jsonJsonPrimitive * _Nullable)json __attribute__((swift_name("transformValue(json_:)")));

/**
 * Use the WIFI connection
 */
- (void)useWifiTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("useWifi(terminalOperation:)")));

/**
 * Get the WIFI state
 * @return the WIFI state
 */
- (id<TerminalGatewayKotlinx_coroutines_coreFlow>)wifiStateTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("wifiState(terminalOperation:)")));
@property TerminalGatewayDatabaseHandler *database __attribute__((swift_name("database")));
@property TerminalGatewayTerminalMode *mode __attribute__((swift_name("mode")));
@property (readonly) TerminalGatewayInternalNetworkService *networkService __attribute__((swift_name("networkService")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppTerminal")))
@interface TerminalGatewayAppTerminal : TerminalGatewayTerminalCore<TerminalGatewayLong *>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (id<TerminalGatewayKotlinx_coroutines_coreFlow>)connectionStateTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("connectionState(terminalOperation:)")));

/**
 * Disconnect from the EDC
 */
- (void)disconnectTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("disconnect(terminalOperation:)")));

/**
 * Send the payload to the EDC
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)doActionActionJob:(TerminalGatewayActionJob *)actionJob terminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation payload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:terminalOperation:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));
- (void)initializeDriver:(TerminalGatewayDriverFactory *)driver clientKey:(NSString *)clientKey appInfo:(TerminalGatewayAppInformation *)appInfo mode:(TerminalGatewayTerminalMode *)mode __attribute__((swift_name("initialize(driver:clientKey:appInfo:mode:)")));

/**
 * Set device IP address
 */
- (void)setDeviceIpAddressDeviceIpAddress:(NSString *)deviceIpAddress __attribute__((swift_name("setDeviceIpAddress(deviceIpAddress:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayLong *)transformValueJson:(NSString * _Nullable)json __attribute__((swift_name("transformValue(json:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayLong *)transformValueJson_:(TerminalGatewayKotlinx_serialization_jsonJsonPrimitive * _Nullable)json __attribute__((swift_name("transformValue(json_:)")));

/**
 * Use the WIFI connection
 */
- (void)useWifiTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("useWifi(terminalOperation:)")));
- (id<TerminalGatewayKotlinx_coroutines_coreFlow>)wifiStateTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation __attribute__((swift_name("wifiState(terminalOperation:)")));
@end

__attribute__((swift_name("BaseTerminal")))
@interface TerminalGatewayBaseTerminal : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)healthCheckWithCompletionHandler:(void (^)(TerminalGatewayBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("healthCheck(completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)initialize __attribute__((swift_name("initialize()")));

/**
 * Sets the global logging verbosity level for the XenTerminal SDK.
 *
 * Log messages with a level lower than the set [level] will typically be suppressed.
 * For instance, if [LogLevel.INFO] is set, [LogLevel.DEBUG] and [LogLevel.VERBOSE] messages
 * will not be displayed.
 *
 * @param level The desired [LogLevel] to set for the SDK's logging output.
 * Use [LogLevel.OFF] to disable all logging, or [LogLevel.VERBOSE]
 * for the most detailed output.
 */
- (void)setLogLevelLevel:(TerminalGatewayLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)versionCheckWithCompletionHandler:(void (^)(TerminalGatewayLatestVersion * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("versionCheck(completionHandler:)")));
@property (readonly) NSString *clientKey __attribute__((swift_name("clientKey")));
@property void (^ _Nullable onInitialize)(void) __attribute__((swift_name("onInitialize")));
@end

__attribute__((swift_name("RuntimeTransacterBase")))
@protocol TerminalGatewayRuntimeTransacterBase
@required
@end


/**
 * A transaction-aware [SqlDriver] wrapper which can begin a [Transaction] on the current connection.
 */
__attribute__((swift_name("RuntimeTransacter")))
@protocol TerminalGatewayRuntimeTransacter <TerminalGatewayRuntimeTransacterBase>
@required

/**
 * Starts a [Transaction] and runs [body] in that transaction.
 *
 * @throws IllegalStateException if [noEnclosing] is true and there is already an active
 *   [Transaction] on this thread.
 */
- (void)transactionNoEnclosing:(BOOL)noEnclosing body:(void (^)(id<TerminalGatewayRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(noEnclosing:body:)")));

/**
 * Starts a [Transaction] and runs [bodyWithReturn] in that transaction.
 *
 * @throws IllegalStateException if [noEnclosing] is true and there is already an active
 *   [Transaction] on this thread.
 */
- (id _Nullable)transactionWithResultNoEnclosing:(BOOL)noEnclosing bodyWithReturn:(id _Nullable (^)(id<TerminalGatewayRuntimeTransactionWithReturn>))bodyWithReturn __attribute__((swift_name("transactionWithResult(noEnclosing:bodyWithReturn:)")));
@end

__attribute__((swift_name("Database")))
@protocol TerminalGatewayDatabase <TerminalGatewayRuntimeTransacter>
@required
@property (readonly) TerminalGatewayServiceQueries *serviceQueries __attribute__((swift_name("serviceQueries")));
@property (readonly) TerminalGatewayTerminalQueries *terminalQueries __attribute__((swift_name("terminalQueries")));
@property (readonly) TerminalGatewayTransactionQueries *transactionQueries __attribute__((swift_name("transactionQueries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseCompanion")))
@interface TerminalGatewayDatabaseCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayDatabaseCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayDatabase>)invokeDriver:(id<TerminalGatewayRuntimeSqlDriver>)driver __attribute__((swift_name("invoke(driver:)")));
@property (readonly) id<TerminalGatewayRuntimeSqlSchema> Schema __attribute__((swift_name("Schema")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NetInterface")))
@interface TerminalGatewayNetInterface : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)netInterface __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayNetInterface *shared __attribute__((swift_name("shared")));
- (NSSet<NSString *> *)getAddresses __attribute__((swift_name("getAddresses()")));
- (NSString *)getLocalAddress __attribute__((swift_name("getLocalAddress()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalApp")))
@interface TerminalGatewayTerminalApp : TerminalGatewayBaseTerminal
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalApp __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTerminalApp *shared __attribute__((swift_name("shared")));
- (void)initializeClientKey:(NSString *)clientKey mode:(TerminalGatewayTerminalMode *)mode __attribute__((swift_name("initialize(clientKey:mode:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TimeoutType")))
@interface TerminalGatewayTimeoutType : TerminalGatewayKotlinEnum<TerminalGatewayTimeoutType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayTimeoutTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayTimeoutType *card __attribute__((swift_name("card")));
@property (class, readonly) TerminalGatewayTimeoutType *qr __attribute__((swift_name("qr")));
+ (TerminalGatewayKotlinArray<TerminalGatewayTimeoutType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayTimeoutType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TimeoutType.Companion")))
@interface TerminalGatewayTimeoutTypeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTimeoutTypeCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("WifiScannerService")))
@interface TerminalGatewayWifiScannerService : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)scan __attribute__((swift_name("scan()")));
@end

__attribute__((swift_name("ResultListener")))
@protocol TerminalGatewayResultListener
@required
- (void)invokeData:(TerminalGatewayTerminalResult * _Nullable)data error:(TerminalGatewayErrorData * _Nullable)error __attribute__((swift_name("invoke(data:error:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Action.Companion")))
@interface TerminalGatewayActionCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayActionCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BluetoothData")))
@interface TerminalGatewayBluetoothData<T> : TerminalGatewayBase
- (instancetype)initWithName:(NSString *)name address:(NSString *)address uuids:(TerminalGatewayKotlinArray<NSString *> * _Nullable)uuids alias:(NSString * _Nullable)alias connected:(BOOL)connected data:(T _Nullable)data __attribute__((swift_name("init(name:address:uuids:alias:connected:data:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayBluetoothData<T> *)doCopyName:(NSString *)name address:(NSString *)address uuids:(TerminalGatewayKotlinArray<NSString *> * _Nullable)uuids alias:(NSString * _Nullable)alias connected:(BOOL)connected data:(T _Nullable)data __attribute__((swift_name("doCopy(name:address:uuids:alias:connected:data:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *address __attribute__((swift_name("address")));
@property (readonly) NSString * _Nullable alias __attribute__((swift_name("alias")));
@property (readonly) BOOL connected __attribute__((swift_name("connected")));
@property (readonly) T _Nullable data __attribute__((swift_name("data")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) TerminalGatewayKotlinArray<NSString *> * _Nullable uuids __attribute__((swift_name("uuids")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ConnectionState")))
@interface TerminalGatewayConnectionState : TerminalGatewayKotlinEnum<TerminalGatewayConnectionState *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayConnectionState *connected __attribute__((swift_name("connected")));
@property (class, readonly) TerminalGatewayConnectionState *disconnected __attribute__((swift_name("disconnected")));
@property (class, readonly) TerminalGatewayConnectionState *unknown __attribute__((swift_name("unknown")));
@property (class, readonly) TerminalGatewayConnectionState *connecting __attribute__((swift_name("connecting")));
@property (class, readonly) TerminalGatewayConnectionState *connectingFailed __attribute__((swift_name("connectingFailed")));
@property (class, readonly) TerminalGatewayConnectionState *unsupported __attribute__((swift_name("unsupported")));
@property (class, readonly) TerminalGatewayConnectionState *unreachable __attribute__((swift_name("unreachable")));
+ (TerminalGatewayKotlinArray<TerminalGatewayConnectionState *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayConnectionState *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ConnectionType")))
@interface TerminalGatewayConnectionType : TerminalGatewayKotlinEnum<TerminalGatewayConnectionType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayConnectionType *usb __attribute__((swift_name("usb")));
@property (class, readonly) TerminalGatewayConnectionType *bluetooth __attribute__((swift_name("bluetooth")));
@property (class, readonly) TerminalGatewayConnectionType *wifi __attribute__((swift_name("wifi")));
+ (TerminalGatewayKotlinArray<TerminalGatewayConnectionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayConnectionType *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/ErrorCode.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorCode")))
@interface TerminalGatewayErrorCode : TerminalGatewayKotlinEnum<TerminalGatewayErrorCode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayErrorCodeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayErrorCode *invalidCredential __attribute__((swift_name("invalidCredential")));
@property (class, readonly) TerminalGatewayErrorCode *invalidRequest __attribute__((swift_name("invalidRequest")));
@property (class, readonly) TerminalGatewayErrorCode *internalServerError __attribute__((swift_name("internalServerError")));
@property (class, readonly) TerminalGatewayErrorCode *unknownError __attribute__((swift_name("unknownError")));
@property (class, readonly) TerminalGatewayErrorCode *keyInvalid __attribute__((swift_name("keyInvalid")));
@property (class, readonly) TerminalGatewayErrorCode *sendFailed __attribute__((swift_name("sendFailed")));
@property (class, readonly) TerminalGatewayErrorCode *notConnected __attribute__((swift_name("notConnected")));
@property (class, readonly) TerminalGatewayErrorCode *failedToConnect __attribute__((swift_name("failedToConnect")));
@property (class, readonly) TerminalGatewayErrorCode *unsupported __attribute__((swift_name("unsupported")));
@property (class, readonly) TerminalGatewayErrorCode *terminalBusy __attribute__((swift_name("terminalBusy")));
@property (class, readonly) TerminalGatewayErrorCode *encryptionFailed __attribute__((swift_name("encryptionFailed")));
@property (class, readonly) TerminalGatewayErrorCode *declinedByReader __attribute__((swift_name("declinedByReader")));
@property (class, readonly) TerminalGatewayErrorCode *paymentUnpaid __attribute__((swift_name("paymentUnpaid")));
@property (class, readonly) TerminalGatewayErrorCode *duplicated __attribute__((swift_name("duplicated")));
@property (class, readonly) TerminalGatewayErrorCode *cancelled __attribute__((swift_name("cancelled")));
@property (class, readonly) TerminalGatewayErrorCode *timeout __attribute__((swift_name("timeout")));
@property (class, readonly) TerminalGatewayErrorCode *noDataFound __attribute__((swift_name("noDataFound")));
@property (class, readonly) TerminalGatewayErrorCode *voidFailed __attribute__((swift_name("voidFailed")));
@property (class, readonly) TerminalGatewayErrorCode *refunded __attribute__((swift_name("refunded")));
@property (class, readonly) TerminalGatewayErrorCode *needDoSettlement __attribute__((swift_name("needDoSettlement")));
@property (class, readonly) TerminalGatewayErrorCode *chipCardDetected __attribute__((swift_name("chipCardDetected")));
@property (class, readonly) TerminalGatewayErrorCode *transactionFailed __attribute__((swift_name("transactionFailed")));
@property (class, readonly) TerminalGatewayErrorCode *tidNotSet __attribute__((swift_name("tidNotSet")));
@property (class, readonly) TerminalGatewayErrorCode *tidNotMatch __attribute__((swift_name("tidNotMatch")));
@property (class, readonly) TerminalGatewayErrorCode *authenticationFailed __attribute__((swift_name("authenticationFailed")));
@property (class, readonly) TerminalGatewayErrorCode *wrongPin __attribute__((swift_name("wrongPin")));
@property (class, readonly) TerminalGatewayErrorCode *dataNotFound __attribute__((swift_name("dataNotFound")));
@property (class, readonly) TerminalGatewayErrorCode *tidNotFound __attribute__((swift_name("tidNotFound")));
@property (class, readonly) TerminalGatewayErrorCode *cardExpired __attribute__((swift_name("cardExpired")));
@property (class, readonly) TerminalGatewayErrorCode *insufficientFunds __attribute__((swift_name("insufficientFunds")));
@property (class, readonly) TerminalGatewayErrorCode *declinedByIssuer __attribute__((swift_name("declinedByIssuer")));
@property (class, readonly) TerminalGatewayErrorCode *invalidCard __attribute__((swift_name("invalidCard")));
@property (class, readonly) TerminalGatewayErrorCode *stolenCard __attribute__((swift_name("stolenCard")));
@property (class, readonly) TerminalGatewayErrorCode *pinTriesExceeded __attribute__((swift_name("pinTriesExceeded")));
@property (class, readonly) TerminalGatewayErrorCode *badBatchNumber __attribute__((swift_name("badBatchNumber")));
@property (class, readonly) TerminalGatewayErrorCode *originalTransactionNotFound __attribute__((swift_name("originalTransactionNotFound")));
@property (class, readonly) TerminalGatewayErrorCode *issuerInoperative __attribute__((swift_name("issuerInoperative")));
@property (class, readonly) TerminalGatewayErrorCode *unableToRoute __attribute__((swift_name("unableToRoute")));
@property (class, readonly) TerminalGatewayErrorCode *actionCannotBeCompleted __attribute__((swift_name("actionCannotBeCompleted")));
@property (class, readonly) TerminalGatewayErrorCode *serviceUnavailable __attribute__((swift_name("serviceUnavailable")));
@property (class, readonly) TerminalGatewayErrorCode *illegalParameter __attribute__((swift_name("illegalParameter")));
@property (class, readonly) TerminalGatewayErrorCode *reconcileError __attribute__((swift_name("reconcileError")));
+ (TerminalGatewayKotlinArray<TerminalGatewayErrorCode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayErrorCode *> *entries __attribute__((swift_name("entries")));
- (TerminalGatewayErrorData *)toErrorMessage:(NSString * _Nullable)message __attribute__((swift_name("toError(message:)")));
- (TerminalGatewayResult<id> *)toResultMessage:(NSString * _Nullable)message data:(id _Nullable)data __attribute__((swift_name("toResult(message:data:)")));
@property (readonly) int32_t code __attribute__((swift_name("code")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorCode.Companion")))
@interface TerminalGatewayErrorCodeCompanion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayErrorCodeCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayErrorCode *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewayErrorCode *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorData")))
@interface TerminalGatewayErrorData : TerminalGatewayBase
- (instancetype)initWithCode:(TerminalGatewayErrorCode *)code message:(NSString * _Nullable)message __attribute__((swift_name("init(code:message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayErrorDataCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayErrorData *)doCopyCode:(TerminalGatewayErrorCode *)code message:(NSString * _Nullable)message __attribute__((swift_name("doCopy(code:message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
- (TerminalGatewayResult<id> *)transform __attribute__((swift_name("transform()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) TerminalGatewayErrorCode *code __attribute__((swift_name("code")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorData.Companion")))
@interface TerminalGatewayErrorDataCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayErrorDataCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PaymentMethod")))
@interface TerminalGatewayPaymentMethod : TerminalGatewayKotlinEnum<TerminalGatewayPaymentMethod *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayPaymentMethodCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayPaymentMethod *card __attribute__((swift_name("card")));
@property (class, readonly) TerminalGatewayPaymentMethod *qr __attribute__((swift_name("qr")));
@property (class, readonly) TerminalGatewayPaymentMethod *brizzi __attribute__((swift_name("brizzi")));
+ (TerminalGatewayKotlinArray<TerminalGatewayPaymentMethod *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayPaymentMethod *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PaymentMethod.Companion")))
@interface TerminalGatewayPaymentMethodCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayPaymentMethodCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((swift_name("Result")))
@interface TerminalGatewayResult<T> : TerminalGatewayBase
- (TerminalGatewayResult<id> *)mapBlock:(id _Nullable (^)(T _Nullable))block __attribute__((swift_name("map(block:)")));
@property (readonly) T _Nullable data __attribute__((swift_name("data")));
@property (readonly) TerminalGatewayErrorData * _Nullable error __attribute__((swift_name("error")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultError")))
@interface TerminalGatewayResultError<T> : TerminalGatewayResult<T>
- (instancetype)initWithData:(T _Nullable)data error:(TerminalGatewayErrorData * _Nullable)error __attribute__((swift_name("init(data:error:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultIdle")))
@interface TerminalGatewayResultIdle<T> : TerminalGatewayResult<T>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultSuccess")))
@interface TerminalGatewayResultSuccess<T> : TerminalGatewayResult<T>
- (instancetype)initWithData:(T _Nullable)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Service")))
@interface TerminalGatewayService : TerminalGatewayBase
- (instancetype)initWithTransaction_id:(NSString *)transaction_id service_payload:(NSString * _Nullable)service_payload service_type:(NSString * _Nullable)service_type sync_flag:(TerminalGatewayLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("init(transaction_id:service_payload:service_type:sync_flag:sync_at:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayService *)doCopyTransaction_id:(NSString *)transaction_id service_payload:(NSString * _Nullable)service_payload service_type:(NSString * _Nullable)service_type sync_flag:(TerminalGatewayLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("doCopy(transaction_id:service_payload:service_type:sync_flag:sync_at:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable service_payload __attribute__((swift_name("service_payload")));
@property (readonly) NSString * _Nullable service_type __attribute__((swift_name("service_type")));
@property (readonly) NSString * _Nullable sync_at __attribute__((swift_name("sync_at")));
@property (readonly) TerminalGatewayLong * _Nullable sync_flag __attribute__((swift_name("sync_flag")));
@property (readonly) NSString *transaction_id __attribute__((swift_name("transaction_id")));
@end

__attribute__((swift_name("RuntimeBaseTransacterImpl")))
@interface TerminalGatewayRuntimeBaseTransacterImpl : TerminalGatewayBase
- (instancetype)initWithDriver:(id<TerminalGatewayRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));

/**
 * For internal use, creates a string in the format (?, ?, ?) where there are [count] question marks.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (NSString *)createArgumentsCount:(int32_t)count __attribute__((swift_name("createArguments(count:)")));

/**
 * For internal use, notifies the listeners provided by [listenerProvider] that their underlying result set has
 * changed.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)notifyQueriesIdentifier:(int32_t)identifier tableProvider:(void (^)(TerminalGatewayKotlinUnit *(^)(NSString *)))tableProvider __attribute__((swift_name("notifyQueries(identifier:tableProvider:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (id _Nullable)postTransactionCleanupTransaction:(TerminalGatewayRuntimeTransacterTransaction *)transaction enclosing:(TerminalGatewayRuntimeTransacterTransaction * _Nullable)enclosing thrownException:(TerminalGatewayKotlinThrowable * _Nullable)thrownException returnValue:(id _Nullable)returnValue __attribute__((swift_name("postTransactionCleanup(transaction:enclosing:thrownException:returnValue:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) id<TerminalGatewayRuntimeSqlDriver> driver __attribute__((swift_name("driver")));
@end


/**
 * A transaction-aware [SqlDriver] wrapper which can begin a [Transaction] on the current connection.
 */
__attribute__((swift_name("RuntimeTransacterImpl")))
@interface TerminalGatewayRuntimeTransacterImpl : TerminalGatewayRuntimeBaseTransacterImpl <TerminalGatewayRuntimeTransacter>
- (instancetype)initWithDriver:(id<TerminalGatewayRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)transactionNoEnclosing:(BOOL)noEnclosing body:(void (^)(id<TerminalGatewayRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(noEnclosing:body:)")));
- (id _Nullable)transactionWithResultNoEnclosing:(BOOL)noEnclosing bodyWithReturn:(id _Nullable (^)(id<TerminalGatewayRuntimeTransactionWithReturn>))bodyWithReturn __attribute__((swift_name("transactionWithResult(noEnclosing:bodyWithReturn:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceQueries")))
@interface TerminalGatewayServiceQueries : TerminalGatewayRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<TerminalGatewayRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)deleteSync __attribute__((swift_name("deleteSync()")));
- (void)insertService:(TerminalGatewayService *)Service __attribute__((swift_name("insert(Service:)")));
- (void)replaceService:(TerminalGatewayService *)Service __attribute__((swift_name("replace(Service:)")));
- (TerminalGatewayRuntimeQuery<TerminalGatewayService *> *)selectByIdTransaction_id:(NSString *)transaction_id __attribute__((swift_name("selectById(transaction_id:)")));
- (TerminalGatewayRuntimeQuery<id> *)selectByIdTransaction_id:(NSString *)transaction_id mapper:(id (^)(NSString *, NSString * _Nullable, NSString * _Nullable, TerminalGatewayLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectById(transaction_id:mapper:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/Status.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Status")))
@interface TerminalGatewayStatus : TerminalGatewayKotlinEnum<TerminalGatewayStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayStatusCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayStatus *success __attribute__((swift_name("success")));
@property (class, readonly) TerminalGatewayStatus *failed __attribute__((swift_name("failed")));
@property (class, readonly) TerminalGatewayStatus *unknown __attribute__((swift_name("unknown")));
+ (TerminalGatewayKotlinArray<TerminalGatewayStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayStatus *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Status.Companion")))
@interface TerminalGatewayStatusCompanion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayStatusCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayStatus *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewayStatus *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TerminalGatewayStatus *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Terminal")))
@interface TerminalGatewayTerminal : TerminalGatewayBase
- (instancetype)initWithTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("init(tid:actualTid:ipAddress:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayTerminal *)doCopyTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("doCopy(tid:actualTid:ipAddress:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *actualTid __attribute__((swift_name("actualTid")));
@property (readonly) NSString * _Nullable ipAddress __attribute__((swift_name("ipAddress")));
@property (readonly) NSString *tid __attribute__((swift_name("tid")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalProvider")))
@interface TerminalGatewayTerminalProvider : TerminalGatewayBase
- (instancetype)initWithName:(NSString *)name currency:(NSString *)currency ports:(NSArray<TerminalGatewayInt *> *)ports __attribute__((swift_name("init(name:currency:ports:)"))) __attribute__((objc_designated_initializer));
@property (readonly) NSString *currency __attribute__((swift_name("currency")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalQueries")))
@interface TerminalGatewayTerminalQueries : TerminalGatewayRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<TerminalGatewayRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayRuntimeQuery<TerminalGatewayTerminal *> *)getAllTid:(NSString *)tid __attribute__((swift_name("getAll(tid:)")));
- (TerminalGatewayRuntimeQuery<id> *)getAllTid:(NSString *)tid mapper:(id (^)(NSString *, NSString *, NSString * _Nullable))mapper __attribute__((swift_name("getAll(tid:mapper:)")));
- (TerminalGatewayRuntimeQuery<TerminalGatewayTerminal *> *)getAllByIpAddressIpAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("getAllByIpAddress(ipAddress:)")));
- (TerminalGatewayRuntimeQuery<id> *)getAllByIpAddressIpAddress:(NSString * _Nullable)ipAddress mapper:(id (^)(NSString *, NSString *, NSString * _Nullable))mapper __attribute__((swift_name("getAllByIpAddress(ipAddress:mapper:)")));
- (void)insertTid:(NSString *)tid actualTid:(NSString *)actualTid ipAddress:(NSString * _Nullable)ipAddress __attribute__((swift_name("insert(tid:actualTid:ipAddress:)")));
- (void)removeTid:(NSString *)tid __attribute__((swift_name("remove(tid:)")));
- (void)removeAll __attribute__((swift_name("removeAll()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalResult")))
@interface TerminalGatewayTerminalResult : TerminalGatewayBase
- (instancetype)initWithOrderID:(NSString * _Nullable)orderID terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(TerminalGatewayDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(TerminalGatewayStatus * _Nullable)status __attribute__((swift_name("init(orderID:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayTerminalResult *)doCopyOrderID:(NSString * _Nullable)orderID terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(TerminalGatewayDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(TerminalGatewayStatus * _Nullable)status __attribute__((swift_name("doCopy(orderID:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) TerminalGatewayDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString * _Nullable currency __attribute__((swift_name("currency")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderID __attribute__((swift_name("orderID")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property (readonly) TerminalGatewayStatus * _Nullable status __attribute__((swift_name("status")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_reference")
*/
@property (readonly) NSString * _Nullable terminalReference __attribute__((swift_name("terminalReference")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString * _Nullable transactionDate __attribute__((swift_name("transactionDate")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalResult.Companion")))
@interface TerminalGatewayTerminalResultCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTerminalResultCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionQueries")))
@interface TerminalGatewayTransactionQueries : TerminalGatewayRuntimeTransacterImpl
- (instancetype)initWithDriver:(id<TerminalGatewayRuntimeSqlDriver>)driver __attribute__((swift_name("init(driver:)"))) __attribute__((objc_designated_initializer));
- (void)deleteSync __attribute__((swift_name("deleteSync()")));
- (void)deleteSyncWithTimeTimestamp:(TerminalGatewayLong * _Nullable)timestamp __attribute__((swift_name("deleteSyncWithTime(timestamp:)")));
- (void)insertTransactions:(TerminalGatewayTransactions *)Transactions __attribute__((swift_name("insert(Transactions:)")));
- (void)replaceTransactions:(TerminalGatewayTransactions *)Transactions __attribute__((swift_name("replace(Transactions:)")));
- (TerminalGatewayRuntimeQuery<TerminalGatewayTransactions *> *)selectAll __attribute__((swift_name("selectAll()")));
- (TerminalGatewayRuntimeQuery<id> *)selectAllMapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, TerminalGatewayLong * _Nullable, TerminalGatewayLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAll(mapper:)")));
- (TerminalGatewayRuntimeQuery<TerminalGatewayTransactions *> *)selectAllWithStatusAndActionStatuses:(id)statuses actions:(id)actions __attribute__((swift_name("selectAllWithStatusAndAction(statuses:actions:)")));
- (TerminalGatewayRuntimeQuery<id> *)selectAllWithStatusAndActionStatuses:(id)statuses actions:(id)actions mapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, TerminalGatewayLong * _Nullable, TerminalGatewayLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAllWithStatusAndAction(statuses:actions:mapper:)")));
- (TerminalGatewayRuntimeQuery<TerminalGatewayTransactions *> *)selectAllWithStatusAndActionAndRangeStatuses:(id)statuses actions:(id)actions from:(TerminalGatewayLong * _Nullable)from end:(TerminalGatewayLong * _Nullable)end __attribute__((swift_name("selectAllWithStatusAndActionAndRange(statuses:actions:from:end:)")));
- (TerminalGatewayRuntimeQuery<id> *)selectAllWithStatusAndActionAndRangeStatuses:(id)statuses actions:(id)actions from:(TerminalGatewayLong * _Nullable)from end:(TerminalGatewayLong * _Nullable)end mapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, TerminalGatewayLong * _Nullable, TerminalGatewayLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectAllWithStatusAndActionAndRange(statuses:actions:from:end:mapper:)")));
- (TerminalGatewayRuntimeQuery<TerminalGatewayTransactions *> *)selectUnsync __attribute__((swift_name("selectUnsync()")));
- (TerminalGatewayRuntimeQuery<id> *)selectUnsyncMapper:(id (^)(NSString *, NSString *, NSString * _Nullable, NSString * _Nullable, NSString * _Nullable, NSString *, NSString *, NSString *, NSString *, NSString *, TerminalGatewayLong * _Nullable, TerminalGatewayLong * _Nullable, NSString * _Nullable))mapper __attribute__((swift_name("selectUnsync(mapper:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Transactions")))
@interface TerminalGatewayTransactions : TerminalGatewayBase
- (instancetype)initWithId:(NSString *)id transactionId:(NSString *)transactionId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId provider:(NSString * _Nullable)provider action:(NSString *)action request_payload:(NSString *)request_payload response_payload:(NSString *)response_payload tid:(NSString *)tid status:(NSString *)status timestamp:(TerminalGatewayLong * _Nullable)timestamp sync_flag:(TerminalGatewayLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("init(id:transactionId:orderId:paymentRequestId:provider:action:request_payload:response_payload:tid:status:timestamp:sync_flag:sync_at:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayTransactions *)doCopyId:(NSString *)id transactionId:(NSString *)transactionId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId provider:(NSString * _Nullable)provider action:(NSString *)action request_payload:(NSString *)request_payload response_payload:(NSString *)response_payload tid:(NSString *)tid status:(NSString *)status timestamp:(TerminalGatewayLong * _Nullable)timestamp sync_flag:(TerminalGatewayLong * _Nullable)sync_flag sync_at:(NSString * _Nullable)sync_at __attribute__((swift_name("doCopy(id:transactionId:orderId:paymentRequestId:provider:action:request_payload:response_payload:tid:status:timestamp:sync_flag:sync_at:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *action __attribute__((swift_name("action")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));
@property (readonly) NSString * _Nullable paymentRequestId __attribute__((swift_name("paymentRequestId")));
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));
@property (readonly) NSString *request_payload __attribute__((swift_name("request_payload")));
@property (readonly) NSString *response_payload __attribute__((swift_name("response_payload")));
@property (readonly) NSString *status __attribute__((swift_name("status")));
@property (readonly) NSString * _Nullable sync_at __attribute__((swift_name("sync_at")));
@property (readonly) TerminalGatewayLong * _Nullable sync_flag __attribute__((swift_name("sync_flag")));
@property (readonly) NSString *tid __attribute__((swift_name("tid")));
@property (readonly) TerminalGatewayLong * _Nullable timestamp __attribute__((swift_name("timestamp")));
@property (readonly) NSString *transactionId __attribute__((swift_name("transactionId")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CheckVersionRequest")))
@interface TerminalGatewayCheckVersionRequest : TerminalGatewayBase
- (instancetype)initWithCurrentVersion:(NSString *)currentVersion platform:(NSString *)platform __attribute__((swift_name("init(currentVersion:platform:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayCheckVersionRequestCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayCheckVersionRequest *)doCopyCurrentVersion:(NSString *)currentVersion platform:(NSString *)platform __attribute__((swift_name("doCopy(currentVersion:platform:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="current_version")
*/
@property (readonly) NSString *currentVersion __attribute__((swift_name("currentVersion")));
@property (readonly) NSString *platform __attribute__((swift_name("platform")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CheckVersionRequest.Companion")))
@interface TerminalGatewayCheckVersionRequestCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayCheckVersionRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogsRequest")))
@interface TerminalGatewayLogsRequest : TerminalGatewayTransactionsRequestPayload
- (instancetype)initWithSerialNumber:(NSString *)serialNumber payload:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("init(serialNumber:payload:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayLogsRequestCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayLogsRequest *)doCopySerialNumber:(NSString *)serialNumber payload:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("doCopy(serialNumber:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payload")
*/
@property (readonly) TerminalGatewayKotlinx_serialization_jsonJsonElement *payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogsRequest.Companion")))
@interface TerminalGatewayLogsRequestCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayLogsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RawTransactionsRequest")))
@interface TerminalGatewayRawTransactionsRequest : TerminalGatewayBase
- (instancetype)initWithTerminalId:(NSString *)terminalId payload:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("init(terminalId:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayRawTransactionsRequestCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayRawTransactionsRequest *)doCopyTerminalId:(NSString *)terminalId payload:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)payload __attribute__((swift_name("doCopy(terminalId:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewayKotlinx_serialization_jsonJsonElement *payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RawTransactionsRequest.Companion")))
@interface TerminalGatewayRawTransactionsRequestCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayRawTransactionsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationRequest")))
@interface TerminalGatewaySimulationRequest : TerminalGatewayBase
- (instancetype)initWithOrderId:(NSString * _Nullable)orderId terminalId:(NSString *)terminalId paymentMethod:(NSString *)paymentMethod amount:(double)amount currency:(NSString *)currency __attribute__((swift_name("init(orderId:terminalId:paymentMethod:amount:currency:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewaySimulationRequestCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewaySimulationRequest *)doCopyOrderId:(NSString * _Nullable)orderId terminalId:(NSString *)terminalId paymentMethod:(NSString *)paymentMethod amount:(double)amount currency:(NSString *)currency __attribute__((swift_name("doCopy(orderId:terminalId:paymentMethod:amount:currency:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The total transaction amount.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) double amount __attribute__((swift_name("amount")));

/**
 * The currency for the transaction.
 * Supported values: IDR, VND, THB.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString *currency __attribute__((swift_name("currency")));

/**
 * Order ID. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * Payment method based on the provider.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * The unique identifier for the terminal.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationRequest.Companion")))
@interface TerminalGatewaySimulationRequestCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewaySimulationRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequest")))
@interface TerminalGatewayTransactionsRequest<T> : TerminalGatewayBase
- (instancetype)initWithTerminalId:(NSString *)terminalId payload:(T)payload __attribute__((swift_name("init(terminalId:payload:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayTransactionsRequestCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayTransactionsRequest<T> *)doCopyTerminalId:(NSString *)terminalId payload:(T)payload __attribute__((swift_name("doCopy(terminalId:payload:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) T payload __attribute__((swift_name("payload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString *terminalId __attribute__((swift_name("terminalId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequestCompanion")))
@interface TerminalGatewayTransactionsRequestCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTransactionsRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeSerial0:(id<TerminalGatewayKotlinx_serialization_coreKSerializer>)typeSerial0 __attribute__((swift_name("serializer(typeSerial0:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionsRequestPayload.Companion")))
@interface TerminalGatewayTransactionsRequestPayloadCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTransactionsRequestPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VerifyRequest")))
@interface TerminalGatewayVerifyRequest : TerminalGatewayTransactionsRequestPayload
- (instancetype)initWithSerialNumber:(NSString *)serialNumber paymentMethod:(NSString *)paymentMethod amount:(double)amount __attribute__((swift_name("init(serialNumber:paymentMethod:amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayVerifyRequestCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayVerifyRequest *)doCopySerialNumber:(NSString *)serialNumber paymentMethod:(NSString *)paymentMethod amount:(double)amount __attribute__((swift_name("doCopy(serialNumber:paymentMethod:amount:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) double amount __attribute__((swift_name("amount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString *paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="serial_number")
*/
@property (readonly) NSString *serialNumber __attribute__((swift_name("serialNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VerifyRequest.Companion")))
@interface TerminalGatewayVerifyRequestCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayVerifyRequestCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Command")))
@interface TerminalGatewayCommand : TerminalGatewayBase
- (instancetype)initWithTerminalId:(NSString * _Nullable)terminalId referenceId:(NSString * _Nullable)referenceId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId commandId:(NSString * _Nullable)commandId type:(TerminalGatewayCommandType *)type provider:(NSString * _Nullable)provider created:(NSString * _Nullable)created rawPayload:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)rawPayload data:(id<TerminalGatewayCommandPayload>)data __attribute__((swift_name("init(terminalId:referenceId:orderId:paymentRequestId:commandId:type:provider:created:rawPayload:data:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayCommandCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayCommand *)doCopyTerminalId:(NSString * _Nullable)terminalId referenceId:(NSString * _Nullable)referenceId orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId commandId:(NSString * _Nullable)commandId type:(TerminalGatewayCommandType *)type provider:(NSString * _Nullable)provider created:(NSString * _Nullable)created rawPayload:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)rawPayload data:(id<TerminalGatewayCommandPayload>)data __attribute__((swift_name("doCopy(terminalId:referenceId:orderId:paymentRequestId:commandId:type:provider:created:rawPayload:data:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="command_id")
*/
@property (readonly) NSString * _Nullable commandId __attribute__((swift_name("commandId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="created")
*/
@property (readonly) NSString * _Nullable created __attribute__((swift_name("created")));
@property id<TerminalGatewayCommandPayload> data __attribute__((swift_name("data")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_request_id")
*/
@property (readonly) NSString * _Nullable paymentRequestId __attribute__((swift_name("paymentRequestId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="provider")
*/
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payload")
*/
@property (readonly) TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable rawPayload __attribute__((swift_name("rawPayload")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reference_id")
*/
@property (readonly) NSString * _Nullable referenceId __attribute__((swift_name("referenceId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="type")
*/
@property (readonly) TerminalGatewayCommandType *type __attribute__((swift_name("type")));
@property (readonly) NSString * _Nullable uniqueID __attribute__((swift_name("uniqueID")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Command.Companion")))
@interface TerminalGatewayCommandCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayCommandCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandConstants")))
@interface TerminalGatewayCommandConstants : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)commandConstants __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayCommandConstants *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *COMMAND_ID_PREFIX __attribute__((swift_name("COMMAND_ID_PREFIX")));
@end

__attribute__((swift_name("CommandPayload")))
@protocol TerminalGatewayCommandPayload
@required

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TerminalGatewayInt * _Nullable attempts __attribute__((swift_name("attempts")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/core/data/response/CommandType.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandType")))
@interface TerminalGatewayCommandType : TerminalGatewayKotlinEnum<TerminalGatewayCommandType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayCommandTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayCommandType *pay __attribute__((swift_name("pay")));
@property (class, readonly) TerminalGatewayCommandType *refund __attribute__((swift_name("refund")));
@property (class, readonly) TerminalGatewayCommandType *void_ __attribute__((swift_name("void_")));
@property (class, readonly) TerminalGatewayCommandType *settle __attribute__((swift_name("settle")));
@property (class, readonly) TerminalGatewayCommandType *printReceipt __attribute__((swift_name("printReceipt")));
@property (class, readonly) TerminalGatewayCommandType *unknown __attribute__((swift_name("unknown")));
+ (TerminalGatewayKotlinArray<TerminalGatewayCommandType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayCommandType *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString * _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CommandType.Companion")))
@interface TerminalGatewayCommandTypeCompanion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayCommandTypeCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayCommandType *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewayCommandType *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TerminalGatewayCommandType *)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Error")))
@interface TerminalGatewayError : TerminalGatewayBase
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayErrorCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayError *)doCopyMessage:(NSString *)message __attribute__((swift_name("doCopy(message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString *message __attribute__((swift_name("message")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Error.Companion")))
@interface TerminalGatewayErrorCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayErrorCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LatestVersion")))
@interface TerminalGatewayLatestVersion : TerminalGatewayBase
- (instancetype)initWithStatus:(TerminalGatewayVersionStatus *)status latestVersion:(NSString * _Nullable)latestVersion downloadUrl:(NSString * _Nullable)downloadUrl releaseNotes:(NSString * _Nullable)releaseNotes __attribute__((swift_name("init(status:latestVersion:downloadUrl:releaseNotes:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayLatestVersionCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayLatestVersion *)doCopyStatus:(TerminalGatewayVersionStatus *)status latestVersion:(NSString * _Nullable)latestVersion downloadUrl:(NSString * _Nullable)downloadUrl releaseNotes:(NSString * _Nullable)releaseNotes __attribute__((swift_name("doCopy(status:latestVersion:downloadUrl:releaseNotes:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="download_url")
*/
@property (readonly) NSString * _Nullable downloadUrl __attribute__((swift_name("downloadUrl")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="latest_version")
*/
@property (readonly) NSString * _Nullable latestVersion __attribute__((swift_name("latestVersion")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="release_notes")
*/
@property (readonly) NSString * _Nullable releaseNotes __attribute__((swift_name("releaseNotes")));
@property (readonly) TerminalGatewayVersionStatus *status __attribute__((swift_name("status")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LatestVersion.Companion")))
@interface TerminalGatewayLatestVersionCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayLatestVersionCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PayPayload")))
@interface TerminalGatewayPayPayload : TerminalGatewayBase <TerminalGatewayCommandPayload>
- (instancetype)initWithRequestAmount:(TerminalGatewayDouble * _Nullable)requestAmount paymentMethods:(NSArray<NSString *> * _Nullable)paymentMethods attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("init(requestAmount:paymentMethods:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayPayPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayPayPayload *)doCopyRequestAmount:(TerminalGatewayDouble * _Nullable)requestAmount paymentMethods:(NSArray<NSString *> * _Nullable)paymentMethods attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("doCopy(requestAmount:paymentMethods:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TerminalGatewayInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_methods")
*/
@property (readonly) NSArray<NSString *> * _Nullable paymentMethods __attribute__((swift_name("paymentMethods")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="request_amount")
*/
@property (readonly) TerminalGatewayDouble * _Nullable requestAmount __attribute__((swift_name("requestAmount")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PayPayload.Companion")))
@interface TerminalGatewayPayPayloadCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayPayPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PrintReceiptPayload")))
@interface TerminalGatewayPrintReceiptPayload : TerminalGatewayBase <TerminalGatewayCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayPrintReceiptPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayPrintReceiptPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TerminalGatewayInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("PrintReceiptPayload.Companion")))
@interface TerminalGatewayPrintReceiptPayloadCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayPrintReceiptPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RefundPayload")))
@interface TerminalGatewayRefundPayload : TerminalGatewayBase <TerminalGatewayCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod requestAmount:(TerminalGatewayDouble * _Nullable)requestAmount reason:(NSString * _Nullable)reason attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:requestAmount:reason:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayRefundPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayRefundPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod requestAmount:(TerminalGatewayDouble * _Nullable)requestAmount reason:(NSString * _Nullable)reason attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:requestAmount:reason:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TerminalGatewayInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="reason")
*/
@property (readonly) NSString * _Nullable reason __attribute__((swift_name("reason")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="request_amount")
*/
@property (readonly) TerminalGatewayDouble * _Nullable requestAmount __attribute__((swift_name("requestAmount")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_id")
*/
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RefundPayload.Companion")))
@interface TerminalGatewayRefundPayloadCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayRefundPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SettlementPayload")))
@interface TerminalGatewaySettlementPayload : TerminalGatewayBase <TerminalGatewayCommandPayload>
- (instancetype)initWithPaymentMethod:(NSString * _Nullable)paymentMethod attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("init(paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewaySettlementPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewaySettlementPayload *)doCopyPaymentMethod:(NSString * _Nullable)paymentMethod attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("doCopy(paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TerminalGatewayInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SettlementPayload.Companion")))
@interface TerminalGatewaySettlementPayloadCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewaySettlementPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationResponse")))
@interface TerminalGatewaySimulationResponse : TerminalGatewayBase
- (instancetype)initWithProvider:(NSString * _Nullable)provider orderId:(NSString * _Nullable)orderId terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(TerminalGatewayDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(NSString * _Nullable)status errorCode:(TerminalGatewayErrorCode * _Nullable)errorCode message:(NSString * _Nullable)message __attribute__((swift_name("init(provider:orderId:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:errorCode:message:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewaySimulationResponseCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewaySimulationResponse *)doCopyProvider:(NSString * _Nullable)provider orderId:(NSString * _Nullable)orderId terminalId:(NSString * _Nullable)terminalId terminalReference:(NSString * _Nullable)terminalReference paymentMethod:(NSString * _Nullable)paymentMethod amount:(TerminalGatewayDouble * _Nullable)amount currency:(NSString * _Nullable)currency transactionDate:(NSString * _Nullable)transactionDate status:(NSString * _Nullable)status errorCode:(TerminalGatewayErrorCode * _Nullable)errorCode message:(NSString * _Nullable)message __attribute__((swift_name("doCopy(provider:orderId:terminalId:terminalReference:paymentMethod:amount:currency:transactionDate:status:errorCode:message:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TerminalGatewayResult<TerminalGatewayTerminalResult *> *)toResultOperation:(TerminalGatewayTerminalOperation *)operation __attribute__((swift_name("toResult(operation:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The total amount of the transaction.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="amount")
*/
@property (readonly) TerminalGatewayDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * The currency code for the transaction amount.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="currency")
*/
@property (readonly) NSString * _Nullable currency __attribute__((swift_name("currency")));

/**
 * An error code if the transaction did not succeed. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) TerminalGatewayErrorCode * _Nullable errorCode __attribute__((swift_name("errorCode")));

/**
 * A descriptive message about the transaction's result. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * The unique Order ID for the transaction.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="order_id")
*/
@property (readonly) NSString * _Nullable orderId __attribute__((swift_name("orderId")));

/**
 * The payment method used, specific to the provider.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));

/**
 * Provider name.
 * Examples: "BRI", "GHL", "ATOM"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="provider")
*/
@property (readonly) NSString * _Nullable provider __attribute__((swift_name("provider")));

/**
 * The final status of the transaction.
 * Example: "SUCCESS"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="status")
*/
@property (readonly) NSString * _Nullable status __attribute__((swift_name("status")));

/**
 * The identifier for the terminal.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * A reference string from the terminal. This field is optional.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_reference")
*/
@property (readonly) NSString * _Nullable terminalReference __attribute__((swift_name("terminalReference")));

/**
 * The date and time of the transaction, preferably in ISO 8601 format.
 * Example: "2025-07-31T05:37:38Z"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_date")
*/
@property (readonly) NSString * _Nullable transactionDate __attribute__((swift_name("transactionDate")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("SimulationResponse.Companion")))
@interface TerminalGatewaySimulationResponseCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewaySimulationResponseCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionResponse")))
@interface TerminalGatewayTransactionResponse : TerminalGatewayBase
- (instancetype)initWithCode:(NSString * _Nullable)code errorCode:(NSString * _Nullable)errorCode errors:(NSArray<TerminalGatewayError *> * _Nullable)errors message:(NSString * _Nullable)message msg:(NSString * _Nullable)msg __attribute__((swift_name("init(code:errorCode:errors:message:msg:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayTransactionResponseCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayTransactionResponse *)doCopyCode:(NSString * _Nullable)code errorCode:(NSString * _Nullable)errorCode errors:(NSArray<TerminalGatewayError *> * _Nullable)errors message:(NSString * _Nullable)message msg:(NSString * _Nullable)msg __attribute__((swift_name("doCopy(code:errorCode:errors:message:msg:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable apiCode __attribute__((swift_name("apiCode")));
@property (readonly) NSString * _Nullable apiMessage __attribute__((swift_name("apiMessage")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="code")
*/
@property (readonly) NSString * _Nullable code __attribute__((swift_name("code")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="error_code")
*/
@property (readonly) NSString * _Nullable errorCode __attribute__((swift_name("errorCode")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="errors")
*/
@property (readonly) NSArray<TerminalGatewayError *> * _Nullable errors __attribute__((swift_name("errors")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="message")
*/
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="msg")
*/
@property (readonly) NSString * _Nullable msg __attribute__((swift_name("msg")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionResponse.Companion")))
@interface TerminalGatewayTransactionResponseCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTransactionResponseCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VersionStatus")))
@interface TerminalGatewayVersionStatus : TerminalGatewayKotlinEnum<TerminalGatewayVersionStatus *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayVersionStatus *upToDate __attribute__((swift_name("upToDate")));
@property (class, readonly) TerminalGatewayVersionStatus *updateAvailable __attribute__((swift_name("updateAvailable")));
@property (class, readonly) TerminalGatewayVersionStatus *forceUpdate __attribute__((swift_name("forceUpdate")));
+ (TerminalGatewayKotlinArray<TerminalGatewayVersionStatus *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayVersionStatus *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VoidPayload")))
@interface TerminalGatewayVoidPayload : TerminalGatewayBase <TerminalGatewayCommandPayload>
- (instancetype)initWithTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("init(transactionId:paymentMethod:attempts:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayVoidPayloadCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayVoidPayload *)doCopyTransactionId:(NSString * _Nullable)transactionId paymentMethod:(NSString * _Nullable)paymentMethod attempts:(TerminalGatewayInt * _Nullable)attempts __attribute__((swift_name("doCopy(transactionId:paymentMethod:attempts:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="attempts")
*/
@property (readonly) TerminalGatewayInt * _Nullable attempts __attribute__((swift_name("attempts")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_method")
*/
@property (readonly) NSString * _Nullable paymentMethod __attribute__((swift_name("paymentMethod")));
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("VoidPayload.Companion")))
@interface TerminalGatewayVoidPayloadCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayVoidPayloadCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("AppModule")))
@interface TerminalGatewayAppModule : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (TerminalGatewayKtor_client_coreHttpClient *)apiClientBlock:(void (^)(TerminalGatewayKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("apiClient(block:)")));
- (TerminalGatewayKtor_client_coreHttpClient *)clientBlock:(void (^)(TerminalGatewayKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("client(block:)")));
- (BOOL)retryRuleException:(TerminalGatewayKotlinException *)exception __attribute__((swift_name("retryRule(exception:)")));
- (TerminalGatewayKtor_client_coreHttpClient *)secureClientBlock:(void (^)(TerminalGatewayKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("secureClient(block:)")));
- (void)websocketSettingsConfig:(TerminalGatewayKtor_client_coreWebSocketsConfig *)config __attribute__((swift_name("websocketSettings(config:)")));
- (TerminalGatewayKtor_client_coreHttpClient *)wssClientBlock:(void (^)(TerminalGatewayKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("wssClient(block:)")));
@property (readonly) BOOL isDesktop __attribute__((swift_name("isDesktop")));
@property (readonly) int64_t timeoutInSecond __attribute__((swift_name("timeoutInSecond")));
@end

__attribute__((swift_name("BaseSecurity")))
@interface TerminalGatewayBaseSecurity : TerminalGatewayBase
- (instancetype)initWithApiKey:(NSString *)apiKey __attribute__((swift_name("init(apiKey:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayResult<NSString *> *)decryptStrToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(strToEncrypt:)")));
- (TerminalGatewayResult<NSString *> *)decryptKey:(TerminalGatewayKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(key:strToEncrypt:)")));
- (TerminalGatewayResult<NSString *> *)encryptStrToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(strToEncrypt:)")));
- (TerminalGatewayResult<NSString *> *)encryptKey:(TerminalGatewayKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(key:strToEncrypt:)")));
@end

__attribute__((swift_name("BluetoothService")))
@protocol TerminalGatewayBluetoothService
@required
- (void)close __attribute__((swift_name("close()")));
- (void)connect __attribute__((swift_name("connect()")));
- (NSArray<TerminalGatewayBluetoothData<id> *> *)scan __attribute__((swift_name("scan()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)sendData:(TerminalGatewayKotlinByteArray *)data completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("send(data:completionHandler:)")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreFlow> isConnected __attribute__((swift_name("isConnected")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreFlow> state __attribute__((swift_name("state")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IOSAppModule")))
@interface TerminalGatewayIOSAppModule : TerminalGatewayAppModule
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (TerminalGatewayKtor_client_coreHttpClient *)clientBlock:(void (^)(TerminalGatewayKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("client(block:)")));
- (BOOL)retryRuleException:(TerminalGatewayKotlinException *)exception __attribute__((swift_name("retryRule(exception:)")));
- (TerminalGatewayKtor_client_coreHttpClient *)secureClientBlock:(void (^)(TerminalGatewayKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("secureClient(block:)")));
- (void)websocketSettingsConfig:(TerminalGatewayKtor_client_coreWebSocketsConfig *)config __attribute__((swift_name("websocketSettings(config:)")));
@end

__attribute__((swift_name("Platform")))
@protocol TerminalGatewayPlatform
@required
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IOSPlatform")))
@interface TerminalGatewayIOSPlatform : TerminalGatewayBase <TerminalGatewayPlatform>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Security")))
@interface TerminalGatewaySecurity : TerminalGatewayBaseSecurity
- (instancetype)initWithApiKey:(NSString *)apiKey __attribute__((swift_name("init(apiKey:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayResult<NSString *> *)decryptKey:(TerminalGatewayKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("decrypt(key:strToEncrypt:)")));
- (TerminalGatewayResult<NSString *> *)encryptKey:(TerminalGatewayKotlinByteArray *)key strToEncrypt:(NSString *)strToEncrypt __attribute__((swift_name("encrypt(key:strToEncrypt:)")));
@end

__attribute__((swift_name("KotlinThrowable")))
@interface TerminalGatewayKotlinThrowable : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));

/**
 * @note annotations
 *   kotlin.experimental.ExperimentalNativeApi
*/
- (TerminalGatewayKotlinArray<NSString *> *)getStackTrace __attribute__((swift_name("getStackTrace()")));
- (void)printStackTrace __attribute__((swift_name("printStackTrace()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewayKotlinThrowable * _Nullable cause __attribute__((swift_name("cause")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
- (NSError *)asError __attribute__((swift_name("asError()")));
@end

__attribute__((swift_name("KotlinException")))
@interface TerminalGatewayKotlinException : TerminalGatewayKotlinThrowable
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinRuntimeException")))
@interface TerminalGatewayKotlinRuntimeException : TerminalGatewayKotlinException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinIllegalStateException")))
@interface TerminalGatewayKotlinIllegalStateException : TerminalGatewayKotlinRuntimeException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.4")
*/
__attribute__((swift_name("KotlinCancellationException")))
@interface TerminalGatewayKotlinCancellationException : TerminalGatewayKotlinIllegalStateException
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * A custom [CancellationException] used to signal a "force cancel" operation.
 *
 * This exception can be thrown to explicitly stop or cancel an ongoing coroutine
 * or operation, indicating that the cancellation was initiated deliberately and
 * not due to a general system-level cancellation. It inherits from [CancellationException]
 * so that it's typically ignored by generic exception handlers (as [CancellationException]s
 * are often used for flow control rather than error conditions) but can be specifically
 * caught if a particular "force cancel" scenario needs to be handled.
 *
 * @param message An optional message providing more detail about the force cancellation.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ForceCancelException")))
@interface TerminalGatewayForceCancelException : TerminalGatewayKotlinCancellationException
- (instancetype)initWithMessage:(NSString *)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (instancetype)initWithCause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end


/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RetryCancellationException")))
@interface TerminalGatewayRetryCancellationException : TerminalGatewayKotlinCancellationException

/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A specialized [CancellationException] used to signal that an ongoing operation
 * should be cancelled specifically for the purpose of **retrying or refreshing a connection**.
 *
 * This exception helps to differentiate between a general cancellation and one
 * that is part of a deliberate connection management strategy. By extending
 * [CancellationException], it benefits from the standard coroutine cancellation
 * mechanisms (where catching `CancellationException` is often used for flow control
 * rather than error handling), but its distinct name allows for specific handling
 * when a connection refresh is intended.
 *
 * It defaults to a message "Refresh Connection" to clearly indicate its purpose.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithMessage:(NSString * _Nullable)message __attribute__((swift_name("init(message:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithCause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithMessage:(NSString * _Nullable)message cause:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("init(message:cause:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@end

__attribute__((swift_name("ProviderAppLauncher")))
@protocol TerminalGatewayProviderAppLauncher
@required
- (BOOL)isProviderAppAvailablePackageName:(NSString *)packageName __attribute__((swift_name("isProviderAppAvailable(packageName:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)launchAppDevice:(TerminalGatewayBaseTerminalDevice *)device packageName:(NSString *)packageName completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("launchApp(device:packageName:completionHandler:)")));
@end

__attribute__((swift_name("TerminalAppLauncherWrapper")))
@protocol TerminalGatewayTerminalAppLauncherWrapper
@required
- (BOOL)isProviderAppAvailable __attribute__((swift_name("isProviderAppAvailable()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)launchAppDevice:(TerminalGatewayBaseTerminalDevice *)device completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("launchApp(device:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InternalNetworkService")))
@interface TerminalGatewayInternalNetworkService : TerminalGatewayBase
- (instancetype)initWithApiUrl:(NSString *)apiUrl __attribute__((swift_name("init(apiUrl:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayInternalNetworkServiceCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandCallbackTerminalId:(NSString *)terminalId request:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(TerminalGatewayTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commandCallback(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)commandsTerminalIds:(NSArray<NSString *> *)terminalIds completionHandler:(void (^)(TerminalGatewayResult<NSArray<TerminalGatewayCommand *> *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("commands(terminalIds:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)healthWithCompletionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinUnit *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("health(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)logsRequest:(TerminalGatewayLogsRequest *)request completionHandler:(void (^)(TerminalGatewayTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("logs(request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)refundTerminalId:(NSString *)terminalId request:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(TerminalGatewayTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("refund(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)simulationTerminalId:(NSString *)terminalId orderID:(NSString * _Nullable)orderID amount:(double)amount paymentMethod:(NSString *)paymentMethod currency:(NSString *)currency completionHandler:(void (^)(TerminalGatewaySimulationResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("simulation(terminalId:orderID:amount:paymentMethod:currency:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)transactionsTerminalId:(NSString *)terminalId request:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(TerminalGatewayTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("transactions(terminalId:request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)verifyRequest:(TerminalGatewayVerifyRequest *)request completionHandler:(void (^)(TerminalGatewayTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("verify(request:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)voidTerminalId:(NSString *)terminalId request:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)request completionHandler:(void (^)(TerminalGatewayTransactionResponse * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("void(terminalId:request:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("InternalNetworkService.Companion")))
@interface TerminalGatewayInternalNetworkServiceCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayInternalNetworkServiceCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionType")))
@interface TerminalGatewayTransactionType : TerminalGatewayKotlinEnum<TerminalGatewayTransactionType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayTransactionTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayTransactionType *callback __attribute__((swift_name("callback")));
@property (class, readonly) TerminalGatewayTransactionType *payment __attribute__((swift_name("payment")));
@property (class, readonly) TerminalGatewayTransactionType *void_ __attribute__((swift_name("void_")));
+ (TerminalGatewayKotlinArray<TerminalGatewayTransactionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayTransactionType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionType.Companion")))
@interface TerminalGatewayTransactionTypeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTransactionTypeCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end

__attribute__((swift_name("BaseDatabaseHandler")))
@interface TerminalGatewayBaseDatabaseHandler : TerminalGatewayBase
- (instancetype)initWithDatabase:(id<TerminalGatewayDatabase> _Nullable)database security:(TerminalGatewayBaseSecurity *)security __attribute__((swift_name("init(database:security:)"))) __attribute__((objc_designated_initializer));
- (BOOL)isTidMatchTid:(NSString *)tid __attribute__((swift_name("isTidMatch(tid:)")));
@property (readonly) TerminalGatewayBaseSecurity *security __attribute__((swift_name("security")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseHandler")))
@interface TerminalGatewayDatabaseHandler : TerminalGatewayBaseDatabaseHandler
- (instancetype)initWithNetworkService:(TerminalGatewayInternalNetworkService *)networkService database:(id<TerminalGatewayDatabase> _Nullable)database security:(TerminalGatewayBaseSecurity *)security __attribute__((swift_name("init(networkService:database:security:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithDatabase:(id<TerminalGatewayDatabase> _Nullable)database security:(TerminalGatewayBaseSecurity *)security __attribute__((swift_name("init(database:security:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (TerminalGatewayService * _Nullable)createServiceDataTerminalOperation:(TerminalGatewayTerminalOperation *)terminalOperation transactions:(TerminalGatewayTransactions *)transactions request:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)request response:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)response __attribute__((swift_name("createServiceData(terminalOperation:transactions:request:response:)")));
@property (readonly) id<TerminalGatewayKotlinx_datetimeDateTimeFormat> dateTimeFormat __attribute__((swift_name("dateTimeFormat")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DriverFactory")))
@interface TerminalGatewayDriverFactory : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (id<TerminalGatewayRuntimeSqlDriver> _Nullable)createDriver __attribute__((swift_name("createDriver()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LocalStorage")))
@interface TerminalGatewayLocalStorage : TerminalGatewayBase
- (instancetype)initWithTerminals:(TerminalGatewayMutableDictionary<NSString *, TerminalGatewayTerminal *> *)terminals transactions:(TerminalGatewayMutableDictionary<NSString *, TerminalGatewayTransactions *> *)transactions services:(TerminalGatewayMutableDictionary<NSString *, TerminalGatewayService *> *)services __attribute__((swift_name("init(terminals:transactions:services:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayLocalStorage *)doCopyTerminals:(TerminalGatewayMutableDictionary<NSString *, TerminalGatewayTerminal *> *)terminals transactions:(TerminalGatewayMutableDictionary<NSString *, TerminalGatewayTransactions *> *)transactions services:(TerminalGatewayMutableDictionary<NSString *, TerminalGatewayService *> *)services __attribute__((swift_name("doCopy(terminals:transactions:services:)")));
- (void)deleteSyncedTransactions __attribute__((swift_name("deleteSyncedTransactions()")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (id)getUnsyncTransactions __attribute__((swift_name("getUnsyncTransactions()")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property TerminalGatewayMutableDictionary<NSString *, TerminalGatewayService *> *services __attribute__((swift_name("services")));
@property (readonly) TerminalGatewayMutableDictionary<NSString *, TerminalGatewayTerminal *> *terminals __attribute__((swift_name("terminals")));
@property TerminalGatewayMutableDictionary<NSString *, TerminalGatewayTransactions *> *transactions __attribute__((swift_name("transactions")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ActionJob")))
@interface TerminalGatewayActionJob : TerminalGatewayBase
- (instancetype)initWithOnCancel:(id<TerminalGatewayKotlinSuspendFunction0>)onCancel onCompleted:(id<TerminalGatewayKotlinSuspendFunction0>)onCompleted onRefresh:(id<TerminalGatewayKotlinSuspendFunction0>)onRefresh cancelable:(BOOL)cancelable block:(id<TerminalGatewayKotlinSuspendFunction1>)block __attribute__((swift_name("init(onCancel:onCompleted:onRefresh:cancelable:block:)"))) __attribute__((objc_designated_initializer));

/**
 * Cancel running SDK job, to allow perform/proceed new action
 */
- (void)cancel __attribute__((swift_name("cancel()")));
- (TerminalGatewayActionJob *)doCopyOnCancel:(id<TerminalGatewayKotlinSuspendFunction0>)onCancel onCompleted:(id<TerminalGatewayKotlinSuspendFunction0>)onCompleted onRefresh:(id<TerminalGatewayKotlinSuspendFunction0>)onRefresh cancelable:(BOOL)cancelable block:(id<TerminalGatewayKotlinSuspendFunction1>)block __attribute__((swift_name("doCopy(onCancel:onCompleted:onRefresh:cancelable:block:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isActive __attribute__((swift_name("isActive()")));
- (void)refresh __attribute__((swift_name("refresh()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<TerminalGatewayKotlinSuspendFunction1> block __attribute__((swift_name("block")));
@property (readonly) id<TerminalGatewayKotlinSuspendFunction0> onCancel __attribute__((swift_name("onCancel")));
@property (readonly) id<TerminalGatewayKotlinSuspendFunction0> onCompleted __attribute__((swift_name("onCompleted")));
@property (readonly) id<TerminalGatewayKotlinSuspendFunction0> onRefresh __attribute__((swift_name("onRefresh")));
@end

__attribute__((swift_name("Kermit_coreLogWriter")))
@interface TerminalGatewayKermit_coreLogWriter : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (BOOL)isLoggableTag:(NSString *)tag severity:(TerminalGatewayKermit_coreSeverity *)severity __attribute__((swift_name("isLoggable(tag:severity:)")));
- (void)logSeverity:(TerminalGatewayKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@end

__attribute__((swift_name("Kermit_ioRollingFileLogWriter")))
@interface TerminalGatewayKermit_ioRollingFileLogWriter : TerminalGatewayKermit_coreLogWriter
- (instancetype)initWithConfig:(TerminalGatewayKermit_ioRollingFileLogWriterConfig *)config messageStringFormatter:(id<TerminalGatewayKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<TerminalGatewayKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(TerminalGatewayKermit_ioRollingFileLogWriterConfig *)config clock:(id<TerminalGatewayKotlinClock>)clock messageStringFormatter:(id<TerminalGatewayKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<TerminalGatewayKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:clock:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (void)logSeverity:(TerminalGatewayKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("CustomRollingFileLogWriter")))
@interface TerminalGatewayCustomRollingFileLogWriter : TerminalGatewayKermit_ioRollingFileLogWriter
- (instancetype)initWithConfig:(TerminalGatewayKermit_ioRollingFileLogWriterConfig *)config onLog:(void (^)(TerminalGatewayKermit_coreSeverity *, NSString *, NSString *, TerminalGatewayKotlinThrowable * _Nullable))onLog __attribute__((swift_name("init(config:onLog:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(TerminalGatewayKermit_ioRollingFileLogWriterConfig *)config messageStringFormatter:(id<TerminalGatewayKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<TerminalGatewayKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithConfig:(TerminalGatewayKermit_ioRollingFileLogWriterConfig *)config clock:(id<TerminalGatewayKotlinClock>)clock messageStringFormatter:(id<TerminalGatewayKermit_coreMessageStringFormatter>)messageStringFormatter fileSystem:(id<TerminalGatewayKotlinx_io_coreFileSystem>)fileSystem __attribute__((swift_name("init(config:clock:messageStringFormatter:fileSystem:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)logSeverity:(TerminalGatewayKermit_coreSeverity *)severity message:(NSString *)message tag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable __attribute__((swift_name("log(severity:message:tag:throwable:)")));
@property (readonly) void (^onLog)(TerminalGatewayKermit_coreSeverity *, NSString *, NSString *, TerminalGatewayKotlinThrowable * _Nullable) __attribute__((swift_name("onLog")));
@end

__attribute__((swift_name("LoggingLoggerApi")))
@protocol TerminalGatewayLoggingLoggerApi
@required
- (void)debugTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("debug(tag:msg:)")));
- (void)errorTag:(NSString *)tag msg:(NSString *)msg t:(TerminalGatewayKotlinThrowable * _Nullable)t __attribute__((swift_name("error(tag:msg:t:)")));
- (void)infoTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("info(tag:msg:)")));
- (void)verboseTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("verbose(tag:msg:)")));
- (void)warnTag:(NSString *)tag msg:(NSString *)msg t:(TerminalGatewayKotlinThrowable * _Nullable)t __attribute__((swift_name("warn(tag:msg:t:)")));
@end

__attribute__((swift_name("LoggingLogLevelController")))
@protocol TerminalGatewayLoggingLogLevelController
@required
- (BOOL)isLoggingDebug __attribute__((swift_name("isLoggingDebug()")));
- (BOOL)isLoggingError __attribute__((swift_name("isLoggingError()")));
- (BOOL)isLoggingInfo __attribute__((swift_name("isLoggingInfo()")));
- (BOOL)isLoggingVerbose __attribute__((swift_name("isLoggingVerbose()")));
- (BOOL)isLoggingWarning __attribute__((swift_name("isLoggingWarning()")));
@end

__attribute__((swift_name("LoggingLogger")))
@protocol TerminalGatewayLoggingLogger <TerminalGatewayLoggingLoggerApi, TerminalGatewayLoggingLogLevelController>
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DesktopLogger")))
@interface TerminalGatewayDesktopLogger : TerminalGatewayBase <TerminalGatewayLoggingLogger>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)debugTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("debug(tag:msg:)")));
- (void)errorTag:(NSString *)tag msg:(NSString *)msg t:(TerminalGatewayKotlinThrowable * _Nullable)t __attribute__((swift_name("error(tag:msg:t:)")));
- (void)infoTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("info(tag:msg:)")));
- (BOOL)isLoggingDebug __attribute__((swift_name("isLoggingDebug()")));
- (BOOL)isLoggingError __attribute__((swift_name("isLoggingError()")));
- (BOOL)isLoggingInfo __attribute__((swift_name("isLoggingInfo()")));
- (BOOL)isLoggingVerbose __attribute__((swift_name("isLoggingVerbose()")));
- (BOOL)isLoggingWarning __attribute__((swift_name("isLoggingWarning()")));
- (void)verboseTag:(NSString *)tag msg:(NSString *)msg __attribute__((swift_name("verbose(tag:msg:)")));
- (void)warnTag:(NSString *)tag msg:(NSString *)msg t:(TerminalGatewayKotlinThrowable * _Nullable)t __attribute__((swift_name("warn(tag:msg:t:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("LogLevel")))
@interface TerminalGatewayLogLevel : TerminalGatewayKotlinEnum<TerminalGatewayLogLevel *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayLogLevel *off __attribute__((swift_name("off")));
@property (class, readonly) TerminalGatewayLogLevel *info __attribute__((swift_name("info")));
@property (class, readonly) TerminalGatewayLogLevel *debug __attribute__((swift_name("debug")));
@property (class, readonly) TerminalGatewayLogLevel *verbose __attribute__((swift_name("verbose")));
+ (TerminalGatewayKotlinArray<TerminalGatewayLogLevel *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayLogLevel *> *entries __attribute__((swift_name("entries")));

/**
 * The internal integer representation of the log level, used for comparison and filtering.
 * A higher integer value generally indicates a more verbose log level.
 */
- (TerminalGatewayKermit_coreSeverity *)toLevel __attribute__((swift_name("toLevel()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalMode")))
@interface TerminalGatewayTerminalMode : TerminalGatewayKotlinEnum<TerminalGatewayTerminalMode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayTerminalMode *live __attribute__((swift_name("live")));
@property (class, readonly) TerminalGatewayTerminalMode *integration __attribute__((swift_name("integration")));
+ (TerminalGatewayKotlinArray<TerminalGatewayTerminalMode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayTerminalMode *> *entries __attribute__((swift_name("entries")));
@property (readonly) BOOL mock __attribute__((swift_name("mock")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("XLogger")))
@interface TerminalGatewayXLogger : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) TerminalGatewayXLoggerCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("XLogger.Companion")))
@interface TerminalGatewayXLoggerCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayXLoggerCompanion *shared __attribute__((swift_name("shared")));
- (void)debugMessage:(NSString *)message __attribute__((swift_name("debug(message:)")));
- (void)errorE:(TerminalGatewayKotlinException *)e __attribute__((swift_name("error(e:)")));
- (void)errorMessage:(NSString *)message __attribute__((swift_name("error(message:)")));
- (void)errorMessage:(NSString *)message e:(TerminalGatewayKotlinException *)e __attribute__((swift_name("error(message:e:)")));
- (void)infoBlock:(NSString *(^)(void))block __attribute__((swift_name("info(block:)")));
- (void)infoMessage:(NSString *)message __attribute__((swift_name("info(message:)")));
- (void)logToFilePath:(TerminalGatewayKotlinx_io_corePath *)path onLog:(void (^)(TerminalGatewayKermit_coreSeverity *, NSString *, NSString *, TerminalGatewayKotlinThrowable * _Nullable))onLog __attribute__((swift_name("logToFile(path:onLog:)")));
- (void)setLogLevelLevel:(TerminalGatewayLogLevel *)level __attribute__((swift_name("setLogLevel(level:)")));
@property (readonly) NSString *LOG_FILE_NAME __attribute__((swift_name("LOG_FILE_NAME")));
@property TerminalGatewayKermit_ioRollingFileLogWriter * _Nullable fileWriter __attribute__((swift_name("fileWriter")));
@property TerminalGatewayKermitLogger *log __attribute__((swift_name("log")));
@end


/**
 * The core abstract class responsible for managing terminal devices, polling for commands,
 * and orchestrating operations between the backend and physical terminal hardware.
 *
 * This gateway handles:
 * - Device registration and connection monitoring.
 * - Polling commands from the server.
 * - Executing commands on specific providers (e.g., Verifone, Ingenico).
 * - Error handling, retries, and timeout management.
 */
__attribute__((swift_name("BaseTerminalGateway")))
@interface TerminalGatewayBaseTerminalGateway : TerminalGatewayBaseTerminalOperation

/**
 * The core abstract class responsible for managing terminal devices, polling for commands,
 * and orchestrating operations between the backend and physical terminal hardware.
 *
 * This gateway handles:
 * - Device registration and connection monitoring.
 * - Polling commands from the server.
 * - Executing commands on specific providers (e.g., Verifone, Ingenico).
 * - Error handling, retries, and timeout management.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * The core abstract class responsible for managing terminal devices, polling for commands,
 * and orchestrating operations between the backend and physical terminal hardware.
 *
 * This gateway handles:
 * - Device registration and connection monitoring.
 * - Polling commands from the server.
 * - Executing commands on specific providers (e.g., Verifone, Ingenico).
 * - Error handling, retries, and timeout management.
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Adds a terminal provider (e.g., for a specific hardware brand like Verifone or Ingenico)
 * to the map of supported operations.
 *
 * @param provider The [TerminalOperation] implementation for the provider.
 */
- (void)addProviderProvider:(TerminalGatewayTerminalOperation *)provider __attribute__((swift_name("addProvider(provider:)")));

/**
 * Returns a [Flow] that emits connection state changes (e.g., CONNECTED, DISCONNECTED) for a specific device.
 *
 * @param device The terminal device to observe.
 * @return A [Flow] emitting the [ConnectionState] of the device.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreFlow>)connectionStateDevice:(TerminalGatewayTerminalDevice_ *)device __attribute__((swift_name("connectionState(device:)")));

/**
 * Handles a generic terminal action.
 *
 * Note: This implementation is currently unsupported in the gateway level and
 * will always return an [ErrorCode.UNSUPPORTED] result.
 *
 * @param actionJob The job context associated with the action.
 * @param payload The specific action details/payload.
 * @param device The target terminal device.
 * @param orderId Optional order identifier.
 * @param paymentRequestId Optional payment request identifier.
 * @param isSimulation Flag indicating if the action should run in simulation mode.
 * @param isSynchronize Flag for synchronous execution.
 * @return A [Result] containing [TerminalResult], currently always unsupported.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)doActionActionJob:(TerminalGatewayActionJob *)actionJob payload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice *)device orderId:(NSString * _Nullable)orderId paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(BOOL)isSimulation isSynchronize:(BOOL)isSynchronize completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("doAction(actionJob:payload:device:orderId:paymentRequestId:isSimulation:isSynchronize:completionHandler:)")));

/**
 * Returns a [StateFlow] that emits error updates for a specific terminal device.
 *
 * @param terminalDevice The device whose error state is to be observed.
 * @return A [StateFlow] emitting the latest [ErrorData] or null.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreStateFlow>)errorStateTerminalDevice:(TerminalGatewayTerminalDevice_ *)terminalDevice __attribute__((swift_name("errorState(terminalDevice:)")));

/**
 * Extension function for [Command] that orchestrates its execution on a physical device.
 *
 * Workflow:
 * 1. Finds the device and the appropriate provider for the command.
 * 2. Cleans up previous sessions/connections using [release].
 * 3. Prepares the action payload and cancels any existing sessions on the device.
 * 4. For `PayPayload`, optionally checks transaction status before execution to prevent double charges.
 * 5. Executes the command with a timeout ([withTimeout]) based on the action type.
 * 6. Updates the device state and priority based on the result.
 *
 * @param isSimulation If true, the command is executed in simulation mode.
 * @param completer A callback to report errors encountered during execution.
 * @return A [Result] containing the [TerminalResult] or an error (e.g., TIMEOUT, FAILED_TO_CONNECT).
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)execute:(TerminalGatewayCommand *)receiver isSimulation:(BOOL)isSimulation completer:(void (^)(TerminalGatewayErrorData * _Nullable))completer completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(_:isSimulation:completer:completionHandler:)")));

/**
 * Helper function to retrieve the simple class name of the data payload within a command.
 * Used for deduplicating commands in the flow.
 */
- (NSString * _Nullable)getClassNameCommand:(TerminalGatewayCommand * _Nullable)command __attribute__((swift_name("getClassName(command:)")));

/**
 * Retrieves a registered terminal provider by its name.
 *
 * @param provider The name of the provider.
 * @return The corresponding [TerminalOperation] or null if not found.
 */
- (TerminalGatewayTerminalOperation * _Nullable)getProviderProvider:(NSString *)provider __attribute__((swift_name("getProvider(provider:)")));

/**
 * Checks if the underlying provider application (e.g., the banking app on the terminal)
 * is available and installed.
 *
 * @return True if the provider app is available, false otherwise.
 */
- (BOOL)isProviderAppAvailable __attribute__((swift_name("isProviderAppAvailable()")));

/**
 * Observes the connection state of a specific device, using the default IO Dispatcher.
 *
 * @param device The device to observe.
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeConnectionDevice:(TerminalGatewayTerminalDevice_ *)device onResult:(void (^)(TerminalGatewayConnectionState *))onResult __attribute__((swift_name("observeConnection(device:onResult:)")));

/**
 * Observes the connection state of a specific device within a given CoroutineScope.
 *
 * @param scope The [CoroutineScope] in which the observation coroutine will be launched.
 * @param device The device to observe.
 * @param onResult A callback function that will be invoked with the latest [ConnectionState].
 * @return A [Job] representing the launched coroutine.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeConnectionScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope>)scope device:(TerminalGatewayTerminalDevice_ *)device onResult:(void (^)(TerminalGatewayConnectionState *))onResult __attribute__((swift_name("observeConnection(scope:device:onResult:)")));

/**
 * Observes the combined error state from all devices and the gateway, using the default IO Dispatcher.
 *
 * @param onResult The callback function invoked with the device (nullable) and the error data (nullable).
 * @return The [Job] managing the observation coroutine.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeErrorOnResult:(void (^)(TerminalGatewayTerminalDevice_ * _Nullable, TerminalGatewayErrorData * _Nullable))onResult __attribute__((swift_name("observeError(onResult:)")));

/**
 * Observes the combined error state from all devices and the gateway within a specified CoroutineScope.
 *
 * @param scope The [CoroutineScope] in which to launch the observer.
 * @param onResult The callback function invoked with the device (nullable) and the error data (nullable).
 * @return The [Job] managing the observation coroutine.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeErrorScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(TerminalGatewayTerminalDevice_ * _Nullable, TerminalGatewayErrorData * _Nullable))onResult __attribute__((swift_name("observeError(scope:onResult:)")));

/**
 * Observes the active state of the gateway service, using the default IO Dispatcher.
 *
 * @param onResult The callback function invoked with the latest service state (true for active, false for inactive).
 * @return The [Job] managing the observation coroutine.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeServiceOnResult:(void (^)(TerminalGatewayBoolean *))onResult __attribute__((swift_name("observeService(onResult:)")));

/**
 * Observes the active state of the gateway service within a specified CoroutineScope.
 *
 * @param scope The [CoroutineScope] in which to launch the observer.
 * @param onResult The callback function invoked with the latest service state (true for active, false for inactive).
 * @return The [Job] managing the observation coroutine.
 */
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)observeServiceScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope>)scope onResult:(void (^)(TerminalGatewayBoolean *))onResult __attribute__((swift_name("observeService(scope:onResult:)")));

/**
 * Registers a list of terminal devices with the gateway.
 * This is a convenience method that delegates to the main registration logic with a default scope.
 *
 * @param devices The list of [TerminalDevice] objects to register.
 * @param restart If true, the service will be restarted to apply the changes immediately.
 */
- (void)registerDevicesDevices:(NSArray<TerminalGatewayTerminalDevice_ *> *)devices restart:(BOOL)restart __attribute__((swift_name("registerDevices(devices:restart:)")));

/**
 * Registers a list of terminal devices with the gateway, updates the internal device list,
 * configures error reporting flows, and optionally restarts the polling service.
 *
 * @param scope An optional [CoroutineScope] to run the service in.
 * @param devices The list of [TerminalDevice] objects to register.
 * @param restart If true, the service will be stopped and started again to use the new device list.
 */
- (void)registerDevicesScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope> _Nullable)scope devices:(NSArray<TerminalGatewayTerminalDevice_ *> *)devices restart:(BOOL)restart __attribute__((swift_name("registerDevices(scope:devices:restart:)")));

/**
 * Restarts one or all managed jobs.
 *
 * @param terminalID The unique identifier of the job to restart.
 * - If `null` (Hard Restart): Calls [releaseAll], clears run states, and restarts the entire service loop via [start].
 * - If provided (Soft Restart): Cancels the specific terminal's job. The main [suspendStart] loop will automatically
 * detect the missing job and recreate it in the next iteration.
 */
- (void)restartTerminalID:(NSString * _Nullable)terminalID __attribute__((swift_name("restart(terminalID:)")));

/**
 * Configures whether the gateway service should start automatically after devices are registered.
 *
 * @param autoStart If true, the service starts automatically; otherwise, it requires a manual [start] call.
 */
- (void)setAutoStartServiceAutoStart:(BOOL)autoStart __attribute__((swift_name("setAutoStartService(autoStart:)")));

/**
 * Sets the maximum number of retry attempts for a single operation before it is considered failed.
 *
 * @param attempt The number of attempts (must be 1 or greater).
 */
- (void)setNumberOfAttemptPerOperationAttempt:(int32_t)attempt __attribute__((swift_name("setNumberOfAttemptPerOperation(attempt:)")));

/**
 * Sets the global maximum allowed time in minutes for any operation to complete before timing out.
 * This updates the timeout settings for all [TimeoutType]s.
 *
 * @param minutes The timeout duration in minutes (must be 1 or greater).
 */
- (void)setOperationTimeoutMinutes:(int32_t)minutes __attribute__((swift_name("setOperationTimeout(minutes:)")));

/**
 * Sets the maximum allowed time in minutes for a specific [TimeoutType] operation.
 *
 * @param type The type of operation (e.g., CARD, QR).
 * @param minutes The timeout duration in minutes (must be 1 or greater).
 */
- (void)setOperationTimeoutType:(TerminalGatewayTimeoutType *)type minutes:(int32_t)minutes __attribute__((swift_name("setOperationTimeout(type:minutes:)")));

/**
 * Starts the main gateway service, which polls for and executes commands for registered devices.
 * If the service is already running, this call is ignored.
 *
 * @param scope An optional [CoroutineScope] to run the service in. Defaults to a new scope on the IO dispatcher.
 * @param onComplete A callback invoked when the service is fully stopped via a [ForceCancelException].
 * @param completer A callback to signal the immediate result of the start attempt (e.g., an initial error).
 */
- (void)startScope:(id<TerminalGatewayKotlinx_coroutines_coreCoroutineScope> _Nullable)scope onComplete:(void (^)(void))onComplete completer:(void (^)(TerminalGatewayErrorData * _Nullable))completer __attribute__((swift_name("start(scope:onComplete:completer:)")));

/**
 * Stops ongoing background jobs.
 *
 * @param terminalID The optional ID of the specific terminal job to stop.
 * - If [terminalID] is provided, only the job for that terminal is cancelled (via [ForceCancelException]).
 * - If [terminalID] is null, **all** jobs and the main service loop are stopped, and resources are released.
 *
 * This method is idempotent.
 */
- (void)stopTerminalID:(NSString * _Nullable)terminalID __attribute__((swift_name("stop(terminalID:)")));

/**
 * Pings all registered devices via their respective providers to check for reachability.
 *
 * - If a device is unreachable, its state is set to [ConnectionState.UNREACHABLE] and
 * its priority is lowered (set to [Int.MAX_VALUE]).
 * - If reachable, priority is reset to 0.
 *
 * @return The list of devices with their connection states updated.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)testDevicesConnectionWithCompletionHandler:(void (^)(NSArray<TerminalGatewayTerminalDevice_ *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("testDevicesConnection(completionHandler:)")));
@property (readonly) NSArray<TerminalGatewayTerminalDevice_ *> *devices __attribute__((swift_name("devices")));

/**
 * A [Flow] that combines and emits errors from all registered devices as well as gateway-level errors.
 * Each emission is a [Pair] containing:
 * - `first`: The [TerminalDevice] that produced the error, or `null` if it is a general gateway error.
 * - `second`: The [ErrorData] object detailing the error.
 */
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreFlow> errorsState __attribute__((swift_name("errorsState")));
@property (readonly) TerminalGatewayMutableDictionary<NSString *, TerminalGatewayBoolean *> *isRuns __attribute__((swift_name("isRuns")));

/**
 * A [StateFlow] that indicates whether the main gateway service (command polling loop) is currently active.
 */
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreStateFlow> isServiceActive __attribute__((swift_name("isServiceActive")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalGateway")))
@interface TerminalGatewayTerminalGateway : TerminalGatewayBaseTerminalGateway
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));

/**
 * The core abstract class responsible for managing terminal devices, polling for commands,
 * and orchestrating operations between the backend and physical terminal hardware.
 *
 * This gateway handles:
 * - Device registration and connection monitoring.
 * - Polling commands from the server.
 * - Executing commands on specific providers (e.g., Verifone, Ingenico).
 * - Error handling, retries, and timeout management.
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalGateway __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTerminalGateway *shared __attribute__((swift_name("shared")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalDevice_")))
@interface TerminalGatewayTerminalDevice_ : TerminalGatewayBaseTerminalDevice
- (instancetype)initWithId:(NSString *)id ipAddress:(NSString *)ipAddress active:(BOOL)active __attribute__((swift_name("init(id:ipAddress:active:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayTerminalDevice_Companion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayTerminalDevice_ *)doCopyId:(NSString *)id ipAddress:(NSString *)ipAddress active:(BOOL)active __attribute__((swift_name("doCopy(id:ipAddress:active:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property BOOL active __attribute__((swift_name("active")));
@property NSString *id __attribute__((swift_name("id")));
@property NSString *ipAddress __attribute__((swift_name("ipAddress")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalDevice_.Companion")))
@interface TerminalGatewayTerminalDevice_Companion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTerminalDevice_Companion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Implementation of [TerminalOperation] for NTT (Network Technical Trust) terminals.
 *
 * This class handles communication with NTT devices via WebSocket, maps generic terminal
 * actions to NTT-specific protocols (Sale, Void, PreAuth, etc.), and manages transaction
 * lifecycles. It also handles payload formatting (e.g., amount strings) and backend synchronization.
 */
__attribute__((swift_name("BaseTerminalNTT")))
@interface TerminalGatewayBaseTerminalNTT : TerminalGatewayTerminalOperation
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithTerminalProvider:(TerminalGatewayTerminalProvider *)terminalProvider cancelable:(BOOL)cancelable __attribute__((swift_name("init(terminalProvider:cancelable:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));

/**
 * Cancels (Voids) a payment intent based on a previous [TerminalResult].
 *
 * @param result The result of the payment to be cancelled.
 * @param isSimulation Flag for simulation.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)cancelPaymentIntentResult:(TerminalGatewayTerminalResult *)result isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("cancelPaymentIntent(result:isSimulation:listener:)")));

/**
 * Cancels (Voids) a payment intent based on a previous [TerminalResult] using a callback.
 *
 * @param result The result of the payment.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)cancelPaymentIntentResult:(TerminalGatewayTerminalResult *)result isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("cancelPaymentIntent(result:isSimulation:callback:)")));

/**
 * Cancels (Voids) a payment intent using specific transaction details.
 *
 * @param orderID The order identifier.
 * @param terminalReference The invoice/terminal reference.
 * @param tradeType The trade type (e.g., Credit, QR).
 * @param isSimulation Flag for simulation.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)cancelPaymentIntentOrderID:(NSString *)orderID terminalReference:(NSString *)terminalReference tradeType:(TerminalGatewayTradeType *)tradeType isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("cancelPaymentIntent(orderID:terminalReference:tradeType:isSimulation:listener:)")));

/**
 * Cancels (Voids) a payment intent using specific transaction details with a callback.
 *
 * @param orderID The order identifier.
 * @param terminalReference The invoice/terminal reference.
 * @param tradeType The trade type.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)cancelPaymentIntentOrderID:(NSString *)orderID terminalReference:(NSString *)terminalReference tradeType:(TerminalGatewayTradeType *)tradeType isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("cancelPaymentIntent(orderID:terminalReference:tradeType:isSimulation:callback:)")));

/**
 * Checks the status of a specific transaction using its details.
 *
 * @param orderID The order identifier.
 * @param terminalReference The invoice/terminal reference.
 * @param tradeType The trade type.
 * @param isSimulation Flag for simulation.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)checkStatusOrderID:(NSString *)orderID terminalReference:(NSString *)terminalReference tradeType:(TerminalGatewayTradeType *)tradeType isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("checkStatus(orderID:terminalReference:tradeType:isSimulation:listener:)")));

/**
 * Checks the status of a specific transaction using its details with a callback.
 *
 * @param orderID The order identifier.
 * @param terminalReference The invoice/terminal reference.
 * @param tradeType The trade type.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)checkStatusOrderID:(NSString *)orderID terminalReference:(NSString * _Nullable)terminalReference tradeType:(TerminalGatewayTradeType *)tradeType isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("checkStatus(orderID:terminalReference:tradeType:isSimulation:callback:)")));

/**
 * Initiates an installment payment plan.
 *
 * @param installment The installment details.
 * @param listener The listener for results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)doInstallmentInstallment:(TerminalGatewayNTTActionInstallment *)installment listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("doInstallment(installment:listener:)")));

/**
 * Initiates an installment payment plan using a callback.
 * Updates [latestPayment] on success.
 *
 * @param installment The installment details.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)doInstallmentInstallment:(TerminalGatewayNTTActionInstallment *)installment isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("doInstallment(installment:isSimulation:callback:)")));

/**
 * Maps a generic [Command.PAY] command to an NTT [NTTAction.Sale] action.
 * Generates a trimmed order ID if necessary and determines the trade type.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayNTTAction * _Nullable)onPayCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayPayPayload *)data __attribute__((swift_name("onPay(command:data:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onPrintReceiptCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayPrintReceiptPayload *)data __attribute__((swift_name("onPrintReceipt(command:data:)")));

/**
 * Refreshes the status of a transaction.
 * Currently, this is not implemented for NTT terminals and returns null.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)onRefreshPayload:(TerminalGatewayAction *)payload device:(TerminalGatewayBaseTerminalDevice * _Nullable)device paymentRequestId:(NSString * _Nullable)paymentRequestId isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation completionHandler:(void (^)(TerminalGatewayKotlinNothing * _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("onRefresh(payload:device:paymentRequestId:isSimulation:completionHandler:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayAction * _Nullable)onSettlementCommand:(TerminalGatewayCommand *)command data:(TerminalGatewaySettlementPayload *)data __attribute__((swift_name("onSettlement(command:data:)")));

/**
 * Maps a generic [Command.VOID] command to an NTT [Void] action.
 * Extracts the invoice number from the trace ID.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (TerminalGatewayNTTAction * _Nullable)onVoidCommand:(TerminalGatewayCommand *)command data:(TerminalGatewayVoidPayload *)data __attribute__((swift_name("onVoid(command:data:)")));

/**
 * Initiates a payment transaction using a listener.
 *
 * @param payment The payment configuration.
 * @param device The target device.
 * @param isSimulation Flag for simulation.
 * @param listener The listener for transaction results.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)paymentIntentPayment:(TerminalGatewayNTTActionPayment *)payment device:(TerminalGatewayTerminalDevice__ * _Nullable)device isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation listener:(id<TerminalGatewayResultListener>)listener __attribute__((swift_name("paymentIntent(payment:device:isSimulation:listener:)")));

/**
 * Initiates a payment transaction using a callback.
 * Stores the result in [latestPayment] if successful.
 *
 * @param payment The payment configuration.
 * @param device The target device.
 * @param isSimulation Flag for simulation.
 * @param callback The callback function.
 * @return The job associated with the action.
 */
- (TerminalGatewayActionJob *)paymentIntentPayment:(TerminalGatewayNTTActionPayment *)payment device:(TerminalGatewayTerminalDevice__ * _Nullable)device isSimulation:(TerminalGatewayBoolean * _Nullable)isSimulation callback:(void (^)(TerminalGatewayTerminalResult * _Nullable, TerminalGatewayErrorData * _Nullable))callback __attribute__((swift_name("paymentIntent(payment:device:isSimulation:callback:)")));

/**
 * Pings the terminal device via WebSocket by sending a test transaction type message.
 * Returns true if the connection is successful.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)pingDevice:(TerminalGatewayBaseTerminalDevice *)device completionHandler:(void (^)(TerminalGatewayBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("ping(device:completionHandler:)")));

/**
 * Prepares the request payload for the NTT terminal.
 *
 * Specifically handles the [NTTAction.AMOUNT] field by ensuring it is formatted
 * as a string with two decimal places (e.g., "100.00"), which is required by the NTT protocol.
 */
- (NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)prepareRequestPayloadPayload:(TerminalGatewayAction *)payload __attribute__((swift_name("prepareRequestPayload(payload:)")));
- (void)setTerminalDeviceDevice:(TerminalGatewayBaseTerminalDevice *)device __attribute__((swift_name("setTerminalDevice(device:)")));
- (NSString * _Nullable)terminalIDData:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)data __attribute__((swift_name("terminalID(data:)")));
- (NSArray<id<TerminalGatewayTerminalAction>> *)toActionsCommandType:(TerminalGatewayCommandType * _Nullable)commandType __attribute__((swift_name("toActions(commandType:)")));
- (TerminalGatewayPaymentMethod * _Nullable)toPaymentMethodValue:(NSString *)value __attribute__((swift_name("toPaymentMethod(value:)")));
- (TerminalGatewayResult<TerminalGatewayTerminalResult *> * _Nullable)toResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toResult(json:)")));

/**
 * Converts the raw JSON response from the terminal into a format suitable for backend synchronization.
 * Maps valid success statuses to appropriate transaction types (PAYMENT, VOID, CALLBACK).
 *
 * @param request The original request.
 * @param json The response JSON.
 * @param transactions The transaction context.
 * @return A pair of transaction type name and synchronized payload, or null if sync is not required.
 */
- (TerminalGatewayKotlinPair<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)toServicePayloadRequest:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)request json:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)json transactions:(TerminalGatewayTransactions *)transactions __attribute__((swift_name("toServicePayload(request:json:transactions:)")));
- (TerminalGatewayTerminalResult * _Nullable)toTerminalResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement * _Nullable)json __attribute__((swift_name("toTerminalResult(json:)")));
- (TerminalGatewayTerminalResult *)transformJsonToResultJson:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)json __attribute__((swift_name("transformJsonToResult(json:)")));
- (int32_t)transformValueJson:(NSString * _Nullable)json __attribute__((swift_name("transformValue(json:)")));
- (int32_t)transformValueJson_:(TerminalGatewayKotlinx_serialization_jsonJsonPrimitive * _Nullable)json __attribute__((swift_name("transformValue(json_:)")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TerminalGatewayKotlinNothing * _Nullable bluetooth __attribute__((swift_name("bluetooth")));
@property (readonly) TerminalGatewayBaseFakeResponseGenerator *fakeGenerator __attribute__((swift_name("fakeGenerator")));
@property (readonly) TerminalGatewayTerminalResult * _Nullable latestPayment __attribute__((swift_name("latestPayment")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TerminalGatewayNTTWebSocketService *wifi __attribute__((swift_name("wifi")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalNTT")))
@interface TerminalGatewayTerminalNTT : TerminalGatewayBaseTerminalNTT
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)terminalNTT __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTerminalNTT *shared __attribute__((swift_name("shared")));
@end


/**
 * Builder class for creating [Installment] intent parameters.
 * Accessible from Swift/ObjC code.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTInstallmentIntentParametersBuilder")))
@interface TerminalGatewayNTTInstallmentIntentParametersBuilder : TerminalGatewayBase
- (instancetype)initWithAmount:(double)amount __attribute__((swift_name("init(amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithOrderID:(NSString *)orderID amount:(double)amount __attribute__((swift_name("init(orderID:amount:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayNTTActionInstallment *)build __attribute__((swift_name("build()")));
@end


/**
 * Sealed class representing all supported actions for the NTT (Network Technical Trust) terminal protocol.
 * Maps high-level terminal actions to the specific JSON payload keys (e.g., "transaction_type", "trade_type")
 * required by the NTT WebSocket API.
 */
__attribute__((swift_name("NTTAction")))
@interface TerminalGatewayNTTAction : TerminalGatewayAction
- (instancetype)initWithData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("init(data:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithSeen0:(int32_t)seen0 data:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable)data serializationConstructorMarker:(id _Nullable)serializationConstructorMarker __attribute__((swift_name("init(seen0:data:serializationConstructorMarker:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayNTTActionCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)getPaymentMethodData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getPaymentMethod(data:)")));
- (NSString *)getServicePaymentMethodData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getServicePaymentMethod(data:)")));
- (id<TerminalGatewayTerminalAction> _Nullable)getTerminalActionData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTerminalAction(data:)")));
- (double)getTransactionAmountData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionAmount(data:)")));
- (NSString * _Nullable)getTransactionOrderIDData:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)data __attribute__((swift_name("getTransactionOrderID(data:)")));
@end


/**
 * Represents a Status Check (Query) request.
 * Used to verify the status of a previous transaction.
 *
 * @param orderID The order identifier.
 * @param invoiceNo The optional invoice number.
 * @param tradeType The trade type (defaults to CARD).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.CheckStatus")))
@interface TerminalGatewayNTTActionCheckStatus : TerminalGatewayNTTAction
- (instancetype)initWithOrderID:(NSString *)orderID invoiceNo:(NSString * _Nullable)invoiceNo tradeType:(TerminalGatewayTradeType *)tradeType __attribute__((swift_name("init(orderID:invoiceNo:tradeType:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayNTTActionCheckStatus *)doCopyOrderID:(NSString *)orderID invoiceNo:(NSString * _Nullable)invoiceNo tradeType:(TerminalGatewayTradeType *)tradeType __attribute__((swift_name("doCopy(orderID:invoiceNo:tradeType:)")));

/**
 * Represents a Status Check (Query) request.
 * Used to verify the status of a previous transaction.
 *
 * @param orderID The order identifier.
 * @param invoiceNo The optional invoice number.
 * @param tradeType The trade type (defaults to CARD).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Status Check (Query) request.
 * Used to verify the status of a previous transaction.
 *
 * @param orderID The order identifier.
 * @param invoiceNo The optional invoice number.
 * @param tradeType The trade type (defaults to CARD).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Status Check (Query) request.
 * Used to verify the status of a previous transaction.
 *
 * @param orderID The order identifier.
 * @param invoiceNo The optional invoice number.
 * @param tradeType The trade type (defaults to CARD).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString * _Nullable invoiceNo __attribute__((swift_name("invoiceNo")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@property (readonly) TerminalGatewayTradeType *tradeType __attribute__((swift_name("tradeType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.Companion")))
@interface TerminalGatewayNTTActionCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayNTTActionCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) NSString *AMOUNT __attribute__((swift_name("AMOUNT")));
@property (readonly) NSString *INVOICE_NO __attribute__((swift_name("INVOICE_NO")));
@property (readonly) NSString *POS_REF_NO __attribute__((swift_name("POS_REF_NO")));
@property (readonly) NSString *SERVICE_TYPE __attribute__((swift_name("SERVICE_TYPE")));
@property (readonly) NSString *TRADE_TYPE __attribute__((swift_name("TRADE_TYPE")));
@property (readonly) NSString *TRANSACTION_TYPE __attribute__((swift_name("TRANSACTION_TYPE")));
@end


/**
 * Represents an Installment Payment Plan (IPP) transaction.
 * Sets the trade type to [TradeType.MULTIIPP].
 *
 * @param orderID The transaction ID.
 * @param amount The total transaction amount.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.Installment")))
@interface TerminalGatewayNTTActionInstallment : TerminalGatewayNTTAction
- (instancetype)initWithOrderID:(NSString *)orderID amount:(double)amount __attribute__((swift_name("init(orderID:amount:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayNTTActionInstallment *)doCopyOrderID:(NSString *)orderID amount:(double)amount __attribute__((swift_name("doCopy(orderID:amount:)")));

/**
 * Represents an Installment Payment Plan (IPP) transaction.
 * Sets the trade type to [TradeType.MULTIIPP].
 *
 * @param orderID The transaction ID.
 * @param amount The total transaction amount.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents an Installment Payment Plan (IPP) transaction.
 * Sets the trade type to [TradeType.MULTIIPP].
 *
 * @param orderID The transaction ID.
 * @param amount The total transaction amount.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents an Installment Payment Plan (IPP) transaction.
 * Sets the trade type to [TradeType.MULTIIPP].
 *
 * @param orderID The transaction ID.
 * @param amount The total transaction amount.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) double amount __attribute__((swift_name("amount")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@end


/**
 * Base class for payment-related actions in the NTT protocol.
 *
 * @param orderID The unique identifier for the order (pos_ref_no).
 * @param amount The transaction amount.
 * @param tradeType The type of trade (e.g., CARD, QR).
 * @param serviceType Optional service type (e.g., SCAN, SHOWQR).
 */
__attribute__((swift_name("NTTAction.Payment")))
@interface TerminalGatewayNTTActionPayment : TerminalGatewayNTTAction
- (instancetype)initWithOrderID:(NSString *)orderID amount:(double)amount tradeType:(TerminalGatewayTradeType * _Nullable)tradeType serviceType:(TerminalGatewayServiceType * _Nullable)serviceType __attribute__((swift_name("init(orderID:amount:tradeType:serviceType:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * Represents a Pre-Authorization request (Card Verification).
 * Used to reserve funds on a card without immediate capture.
 *
 * @param orderID The transaction ID.
 * @param tradeType The trade type.
 * @param amount The amount to pre-authorize.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.PreAuthorization")))
@interface TerminalGatewayNTTActionPreAuthorization : TerminalGatewayNTTAction
- (instancetype)initWithOrderID:(NSString *)orderID tradeType:(TerminalGatewayTradeType *)tradeType amount:(double)amount __attribute__((swift_name("init(orderID:tradeType:amount:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayNTTActionPreAuthorizationCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayNTTActionPreAuthorization *)doCopyOrderID:(NSString *)orderID tradeType:(TerminalGatewayTradeType *)tradeType amount:(double)amount __attribute__((swift_name("doCopy(orderID:tradeType:amount:)")));

/**
 * Represents a Pre-Authorization request (Card Verification).
 * Used to reserve funds on a card without immediate capture.
 *
 * @param orderID The transaction ID.
 * @param tradeType The trade type.
 * @param amount The amount to pre-authorize.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Pre-Authorization request (Card Verification).
 * Used to reserve funds on a card without immediate capture.
 *
 * @param orderID The transaction ID.
 * @param tradeType The trade type.
 * @param amount The amount to pre-authorize.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Pre-Authorization request (Card Verification).
 * Used to reserve funds on a card without immediate capture.
 *
 * @param orderID The transaction ID.
 * @param tradeType The trade type.
 * @param amount The amount to pre-authorize.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) double amount __attribute__((swift_name("amount")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@property (readonly) TerminalGatewayTradeType *tradeType __attribute__((swift_name("tradeType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.PreAuthorizationCompanion")))
@interface TerminalGatewayNTTActionPreAuthorizationCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayNTTActionPreAuthorizationCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayNTTActionPreAuthorization *)fromPaymentPayment:(TerminalGatewayNTTActionPayment *)payment __attribute__((swift_name("fromPayment(payment:)")));
@end


/**
 * Represents a standard Sale transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param tradeType The trade type (defaults to null, which usually implies CARD).
 * @param serviceType Optional service type for specific flows like QR scanning.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.Sale")))
@interface TerminalGatewayNTTActionSale : TerminalGatewayNTTActionPayment
- (instancetype)initWithOrderID:(NSString *)orderID amount:(double)amount tradeType:(TerminalGatewayTradeType * _Nullable)tradeType serviceType:(TerminalGatewayServiceType * _Nullable)serviceType __attribute__((swift_name("init(orderID:amount:tradeType:serviceType:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayNTTActionSale *)doCopyOrderID:(NSString *)orderID amount:(double)amount tradeType:(TerminalGatewayTradeType * _Nullable)tradeType serviceType:(TerminalGatewayServiceType * _Nullable)serviceType __attribute__((swift_name("doCopy(orderID:amount:tradeType:serviceType:)")));

/**
 * Represents a standard Sale transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param tradeType The trade type (defaults to null, which usually implies CARD).
 * @param serviceType Optional service type for specific flows like QR scanning.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a standard Sale transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param tradeType The trade type (defaults to null, which usually implies CARD).
 * @param serviceType Optional service type for specific flows like QR scanning.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a standard Sale transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The transaction amount.
 * @param tradeType The trade type (defaults to null, which usually implies CARD).
 * @param serviceType Optional service type for specific flows like QR scanning.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) double amount __attribute__((swift_name("amount")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@property (readonly) TerminalGatewayServiceType * _Nullable serviceType __attribute__((swift_name("serviceType")));
@property (readonly) TerminalGatewayTradeType * _Nullable tradeType __attribute__((swift_name("tradeType")));
@end


/**
 * Represents a Sale Completion request (Pre-Auth Completion).
 * Used to capture a previously pre-authorized transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The final amount to capture.
 * @param invoiceNo The invoice number from the original pre-auth transaction.
 * @param tradeType The trade type (defaults to CARD).
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.SaleCompletion")))
@interface TerminalGatewayNTTActionSaleCompletion : TerminalGatewayNTTAction
- (instancetype)initWithOrderID:(NSString *)orderID amount:(double)amount invoiceNo:(NSString *)invoiceNo tradeType:(TerminalGatewayTradeType *)tradeType __attribute__((swift_name("init(orderID:amount:invoiceNo:tradeType:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayNTTActionSaleCompletion *)doCopyOrderID:(NSString *)orderID amount:(double)amount invoiceNo:(NSString *)invoiceNo tradeType:(TerminalGatewayTradeType *)tradeType __attribute__((swift_name("doCopy(orderID:amount:invoiceNo:tradeType:)")));

/**
 * Represents a Sale Completion request (Pre-Auth Completion).
 * Used to capture a previously pre-authorized transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The final amount to capture.
 * @param invoiceNo The invoice number from the original pre-auth transaction.
 * @param tradeType The trade type (defaults to CARD).
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Sale Completion request (Pre-Auth Completion).
 * Used to capture a previously pre-authorized transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The final amount to capture.
 * @param invoiceNo The invoice number from the original pre-auth transaction.
 * @param tradeType The trade type (defaults to CARD).
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Sale Completion request (Pre-Auth Completion).
 * Used to capture a previously pre-authorized transaction.
 *
 * @param orderID The transaction ID.
 * @param amount The final amount to capture.
 * @param invoiceNo The invoice number from the original pre-auth transaction.
 * @param tradeType The trade type (defaults to CARD).
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) double amount __attribute__((swift_name("amount")));
@property (readonly) NSString *invoiceNo __attribute__((swift_name("invoiceNo")));
@property (readonly) NSString *orderID __attribute__((swift_name("orderID")));
@property (readonly) TerminalGatewayTradeType *tradeType __attribute__((swift_name("tradeType")));
@end


/**
 * Represents a Void transaction.
 * Can be used to cancel a sale or a completed pre-auth.
 *
 * @param orderID The optional order identifier.
 * @param invoiceNo The invoice number of the transaction to void.
 * @param tradeType The trade type.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTAction.Void")))
@interface TerminalGatewayNTTActionVoid : TerminalGatewayNTTAction
- (instancetype)initWithOrderID:(NSString * _Nullable)orderID invoiceNo:(NSString *)invoiceNo tradeType:(TerminalGatewayTradeType *)tradeType __attribute__((swift_name("init(orderID:invoiceNo:tradeType:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayNTTActionVoid *)doCopyOrderID:(NSString * _Nullable)orderID invoiceNo:(NSString *)invoiceNo tradeType:(TerminalGatewayTradeType *)tradeType __attribute__((swift_name("doCopy(orderID:invoiceNo:tradeType:)")));

/**
 * Represents a Void transaction.
 * Can be used to cancel a sale or a completed pre-auth.
 *
 * @param orderID The optional order identifier.
 * @param invoiceNo The invoice number of the transaction to void.
 * @param tradeType The trade type.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a Void transaction.
 * Can be used to cancel a sale or a completed pre-auth.
 *
 * @param orderID The optional order identifier.
 * @param invoiceNo The invoice number of the transaction to void.
 * @param tradeType The trade type.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a Void transaction.
 * Can be used to cancel a sale or a completed pre-auth.
 *
 * @param orderID The optional order identifier.
 * @param invoiceNo The invoice number of the transaction to void.
 * @param tradeType The trade type.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *invoiceNo __attribute__((swift_name("invoiceNo")));
@property (readonly) NSString * _Nullable orderID __attribute__((swift_name("orderID")));
@property (readonly) TerminalGatewayTradeType *tradeType __attribute__((swift_name("tradeType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalAction")))
@interface TerminalGatewayNTTTerminalAction : TerminalGatewayKotlinEnum<TerminalGatewayNTTTerminalAction *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayNTTTerminalAction *sale __attribute__((swift_name("sale")));
@property (class, readonly) TerminalGatewayNTTTerminalAction *void_ __attribute__((swift_name("void_")));
+ (TerminalGatewayKotlinArray<TerminalGatewayNTTTerminalAction *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayNTTTerminalAction *> *entries __attribute__((swift_name("entries")));
@end


/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalResult")))
@interface TerminalGatewayNTTTerminalResult : TerminalGatewayBase
- (instancetype)initWithPosRefNo:(NSString * _Nullable)posRefNo transactionType:(TerminalGatewayNTTTransactionType * _Nullable)transactionType tradeType:(TerminalGatewayTradeType * _Nullable)tradeType amount:(TerminalGatewayDouble * _Nullable)amount responseCode:(NSString * _Nullable)responseCode responseMsg:(NSString * _Nullable)responseMsg terminalId:(NSString * _Nullable)terminalId merchantId:(NSString * _Nullable)merchantId transactionId:(NSString * _Nullable)transactionId invoiceNo:(NSString * _Nullable)invoiceNo cardNo:(NSString * _Nullable)cardNo cardType:(NSString * _Nullable)cardType cardApprovalCode:(NSString * _Nullable)cardApprovalCode ippTerm:(NSString * _Nullable)ippTerm monthlyDue:(TerminalGatewayDouble * _Nullable)monthlyDue totalDue:(TerminalGatewayDouble * _Nullable)totalDue paymentDate:(NSString * _Nullable)paymentDate __attribute__((swift_name("init(posRefNo:transactionType:tradeType:amount:responseCode:responseMsg:terminalId:merchantId:transactionId:invoiceNo:cardNo:cardType:cardApprovalCode:ippTerm:monthlyDue:totalDue:paymentDate:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayNTTTerminalResultCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayNTTTerminalResult *)doCopyPosRefNo:(NSString * _Nullable)posRefNo transactionType:(TerminalGatewayNTTTransactionType * _Nullable)transactionType tradeType:(TerminalGatewayTradeType * _Nullable)tradeType amount:(TerminalGatewayDouble * _Nullable)amount responseCode:(NSString * _Nullable)responseCode responseMsg:(NSString * _Nullable)responseMsg terminalId:(NSString * _Nullable)terminalId merchantId:(NSString * _Nullable)merchantId transactionId:(NSString * _Nullable)transactionId invoiceNo:(NSString * _Nullable)invoiceNo cardNo:(NSString * _Nullable)cardNo cardType:(NSString * _Nullable)cardType cardApprovalCode:(NSString * _Nullable)cardApprovalCode ippTerm:(NSString * _Nullable)ippTerm monthlyDue:(TerminalGatewayDouble * _Nullable)monthlyDue totalDue:(TerminalGatewayDouble * _Nullable)totalDue paymentDate:(NSString * _Nullable)paymentDate __attribute__((swift_name("doCopy(posRefNo:transactionType:tradeType:amount:responseCode:responseMsg:terminalId:merchantId:transactionId:invoiceNo:cardNo:cardType:cardApprovalCode:ippTerm:monthlyDue:totalDue:paymentDate:)")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TerminalGatewayErrorCode * _Nullable)toErrorCode __attribute__((swift_name("toErrorCode()")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (NSString *)description __attribute__((swift_name("description()")));
- (TerminalGatewayTerminalResult *)toTerminalResult __attribute__((swift_name("toTerminalResult()")));

/**
 * Total sale amount.
 * Minimum: 1. Example: 1299.99
 */
@property (readonly) TerminalGatewayDouble * _Nullable amount __attribute__((swift_name("amount")));

/**
 * Card approval code. Optional field.
 * Max length: 6 characters. Example: "ABC123"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_approval_code")
*/
@property (readonly) NSString * _Nullable cardApprovalCode __attribute__((swift_name("cardApprovalCode")));

/**
 * Payer's card number. Optional field.
 * Max length: 19 characters. Example: "411111******1111"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_no")
*/
@property (readonly) NSString * _Nullable cardNo __attribute__((swift_name("cardNo")));

/**
 * Type of card. Optional field.
 * Max length: 10 characters. Example: "VISA"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="card_type")
*/
@property (readonly) NSString * _Nullable cardType __attribute__((swift_name("cardType")));

/**
 * Invoice Number.
 * Max length: 20 characters. Example: "INV20250606-001"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="invoice_no")
*/
@property (readonly) NSString * _Nullable invoiceNo __attribute__((swift_name("invoiceNo")));

/**
 * Installment Payment Plan (IPP) term. Optional field.
 * Max length: 2 characters. Example: "06"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="ipp_term")
*/
@property (readonly) NSString * _Nullable ippTerm __attribute__((swift_name("ippTerm")));

/**
 * Merchant Identifier. Optional field.
 * Max length: 15 characters. Example: "MCH123456789012"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="merchant_id")
*/
@property (readonly) NSString * _Nullable merchantId __attribute__((swift_name("merchantId")));

/**
 * Monthly due amount for IPP. Optional field.
 * Example: 216.67
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="monthly_due")
*/
@property (readonly) TerminalGatewayDouble * _Nullable monthlyDue __attribute__((swift_name("monthlyDue")));

/**
 * @note annotations
 *   kotlinx.serialization.SerialName(value="payment_date")
*/
@property (readonly) NSString * _Nullable paymentDate __attribute__((swift_name("paymentDate")));

/**
 * Point of Sale Reference Number.
 * Max length: 12 characters. Example: "123456789012"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="pos_ref_no")
*/
@property (readonly) NSString * _Nullable posRefNo __attribute__((swift_name("posRefNo")));

/**
 * Response code from the host.
 * Max length: 2 characters. Example: "00"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="response_code")
*/
@property (readonly) NSString * _Nullable responseCode __attribute__((swift_name("responseCode")));

/**
 * Response message.
 * Max length: 32 characters. Example: "Approved"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="response_msg")
*/
@property (readonly) NSString * _Nullable responseMsg __attribute__((swift_name("responseMsg")));

/**
 * Terminal Identifier.
 * Max length: 8 characters. Example: "TERM1234"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="terminal_id")
*/
@property (readonly) NSString * _Nullable terminalId __attribute__((swift_name("terminalId")));

/**
 * Total due amount. Optional field.
 * Example: 1300.02
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="total_due")
*/
@property (readonly) TerminalGatewayDouble * _Nullable totalDue __attribute__((swift_name("totalDue")));

/**
 * Type of payment or trade.
 * Restricted to predefined values in TradeTypeEnum.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="trade_type")
*/
@property (readonly) TerminalGatewayTradeType * _Nullable tradeType __attribute__((swift_name("tradeType")));

/**
 * Host Transaction Number.
 * Max length: 32 characters. Example: "TXN202506060001"
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_id")
*/
@property (readonly) NSString * _Nullable transactionId __attribute__((swift_name("transactionId")));

/**
 * Type of the transaction.
 * Restricted to predefined values in TransactionTypeEnum.
 *
 * @note annotations
 *   kotlinx.serialization.SerialName(value="transaction_type")
*/
@property (readonly) TerminalGatewayNTTTransactionType * _Nullable transactionType __attribute__((swift_name("transactionType")));
@end


/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTerminalResult.Companion")))
@interface TerminalGatewayNTTTerminalResultCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayNTTTerminalResultCompanion *shared __attribute__((swift_name("shared")));

/**
 * Represents a transaction response from the SmartEDC system.
 * This data class encapsulates various details about a completed transaction.
 * It uses Kotlinx Serialization for easy serialization and deserialization,
 * with @SerialName annotations to map camelCase field names to original snake_case names.
 */
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Enum representing the type of transaction.
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTransactionType")))
@interface TerminalGatewayNTTTransactionType : TerminalGatewayKotlinEnum<TerminalGatewayNTTTransactionType *> <TerminalGatewayTerminalAction>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enum representing the type of transaction.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayNTTTransactionTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayNTTTransactionType *sale __attribute__((swift_name("sale")));
@property (class, readonly) TerminalGatewayNTTTransactionType *preauth __attribute__((swift_name("preauth")));
@property (class, readonly) TerminalGatewayNTTTransactionType *void_ __attribute__((swift_name("void_")));
@property (class, readonly) TerminalGatewayNTTTransactionType *query __attribute__((swift_name("query")));
@property (class, readonly) TerminalGatewayNTTTransactionType *precomp __attribute__((swift_name("precomp")));
+ (TerminalGatewayKotlinArray<TerminalGatewayNTTTransactionType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayNTTTransactionType *> *entries __attribute__((swift_name("entries")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Enum representing the type of transaction.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTTransactionType.Companion")))
@interface TerminalGatewayNTTTransactionTypeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Enum representing the type of transaction.
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayNTTTransactionTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Enum representing the type of transaction.
 */
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * Enum representing the type of transaction.
 */
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
@end


/**
 * Builder class for creating [Payment] intent parameters.
 * Accessible from Swift/ObjC code.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTPaymentIntentParametersBuilder")))
@interface TerminalGatewayNTTPaymentIntentParametersBuilder : TerminalGatewayBase
- (instancetype)initWithAmount:(double)amount __attribute__((swift_name("init(amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithAmount:(double)amount tradeType:(TerminalGatewayTradeType *)tradeType __attribute__((swift_name("init(amount:tradeType:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithOrderID:(NSString *)orderID amount:(double)amount __attribute__((swift_name("init(orderID:amount:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithOrderID:(NSString *)orderID amount:(double)amount tradeType:(TerminalGatewayTradeType *)tradeType __attribute__((swift_name("init(orderID:amount:tradeType:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayNTTActionPayment *)build __attribute__((swift_name("build()")));

/**
 * Configures the payment intent for a "Scan QR" flow (Merchant scans Customer QR).
 * Checks if the trade type supports this capability.
 */
- (TerminalGatewayNTTPaymentIntentParametersBuilder *)scanQR __attribute__((swift_name("scanQR()")));

/**
 * Configures the payment intent for a "Show QR" flow (Customer scans Merchant QR).
 * Checks if the trade type supports this capability.
 */
- (TerminalGatewayNTTPaymentIntentParametersBuilder *)showQR __attribute__((swift_name("showQR()")));
@end


/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceCapabilities")))
@interface TerminalGatewayServiceCapabilities : TerminalGatewayBase
- (instancetype)initWithSupportsScan:(BOOL)supportsScan supportsShowQr:(BOOL)supportsShowQr __attribute__((swift_name("init(supportsScan:supportsShowQr:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayServiceCapabilities *)doCopySupportsScan:(BOOL)supportsScan supportsShowQr:(BOOL)supportsShowQr __attribute__((swift_name("doCopy(supportsScan:supportsShowQr:)")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Defines the service capabilities for a given TradeType.
 * @property supportsScan True if the TradeType supports SCAN payments.
 * @property supportsShowQr True if the TradeType supports SHOW_QR payments.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL supportsScan __attribute__((swift_name("supportsScan")));
@property (readonly) BOOL supportsShowQr __attribute__((swift_name("supportsShowQr")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ServiceType")))
@interface TerminalGatewayServiceType : TerminalGatewayKotlinEnum<TerminalGatewayServiceType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayServiceType *scan __attribute__((swift_name("scan")));
@property (class, readonly) TerminalGatewayServiceType *showqr __attribute__((swift_name("showqr")));
+ (TerminalGatewayKotlinArray<TerminalGatewayServiceType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayServiceType *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalDevice__")))
@interface TerminalGatewayTerminalDevice__ : TerminalGatewayBaseTerminalDevice
- (instancetype)initWithId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("init(id:ipAddress:)"))) __attribute__((objc_designated_initializer));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
- (TerminalGatewayTerminalDevice__ *)doCopyId:(NSString *)id ipAddress:(NSString *)ipAddress __attribute__((swift_name("doCopy(id:ipAddress:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) NSString *ipAddress __attribute__((swift_name("ipAddress")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=co/xendit/terminal/ntt/data/TradeType.Companion))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TradeType")))
@interface TerminalGatewayTradeType : TerminalGatewayKotlinEnum<TerminalGatewayTradeType *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayTradeTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayTradeType *card __attribute__((swift_name("card")));
@property (class, readonly) TerminalGatewayTradeType *multiipp __attribute__((swift_name("multiipp")));
@property (class, readonly) TerminalGatewayTradeType *alipayPlus __attribute__((swift_name("alipayPlus")));
@property (class, readonly) TerminalGatewayTradeType *wechatpaycil __attribute__((swift_name("wechatpaycil")));
@property (class, readonly) TerminalGatewayTradeType *wechatpayocgt __attribute__((swift_name("wechatpayocgt")));
@property (class, readonly) TerminalGatewayTradeType *truemoney __attribute__((swift_name("truemoney")));
@property (class, readonly) TerminalGatewayTradeType *linepay __attribute__((swift_name("linepay")));
@property (class, readonly) TerminalGatewayTradeType *shopee __attribute__((swift_name("shopee")));
@property (class, readonly) TerminalGatewayTradeType *bblQrcs __attribute__((swift_name("bblQrcs")));
@property (class, readonly) TerminalGatewayTradeType *thaiqrcode __attribute__((swift_name("thaiqrcode")));
@property (class, readonly) TerminalGatewayTradeType *atome __attribute__((swift_name("atome")));
@property (class, readonly) TerminalGatewayTradeType *sabuymoney __attribute__((swift_name("sabuymoney")));
@property (class, readonly) TerminalGatewayTradeType *maxme __attribute__((swift_name("maxme")));
+ (TerminalGatewayKotlinArray<TerminalGatewayTradeType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayTradeType *> *entries __attribute__((swift_name("entries")));
- (TerminalGatewayPaymentMethod *)toPaymentMethod __attribute__((swift_name("toPaymentMethod()")));
@property (readonly) NSArray<NSString *> * _Nullable alternativeValue __attribute__((swift_name("alternativeValue")));
@property (readonly) TerminalGatewayServiceCapabilities *capabilities __attribute__((swift_name("capabilities")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TradeType.Companion")))
@interface TerminalGatewayTradeTypeCompanion : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreKSerializer>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayTradeTypeCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayTradeType *)deserializeDecoder:(id<TerminalGatewayKotlinx_serialization_coreDecoder>)decoder __attribute__((swift_name("deserialize(decoder:)")));
- (TerminalGatewayTradeType *)fromTerminalResultResult:(TerminalGatewayTerminalResult *)result __attribute__((swift_name("fromTerminalResult(result:)")));
- (TerminalGatewayTradeType * _Nullable)fromValueValue:(NSString *)value __attribute__((swift_name("fromValue(value:)")));
- (void)serializeEncoder:(id<TerminalGatewayKotlinx_serialization_coreEncoder>)encoder value:(TerminalGatewayTradeType *)value __attribute__((swift_name("serialize(encoder:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializerTypeParamsSerializers:(TerminalGatewayKotlinArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeParamsSerializers __attribute__((swift_name("serializer(typeParamsSerializers:)")));
- (TerminalGatewayTradeType * _Nullable)toEnumValue:(NSString *)value __attribute__((swift_name("toEnum(value:)")));
@property (readonly) id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor> descriptor __attribute__((swift_name("descriptor")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("FakeResponseGenerator_")))
@interface TerminalGatewayFakeResponseGenerator_ : TerminalGatewayBaseFakeResponseGenerator
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)new __attribute__((unavailable));
+ (instancetype)fakeResponseGenerator __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayFakeResponseGenerator_ *shared __attribute__((swift_name("shared")));
- (NSString *)formatDateTimeDateTime:(TerminalGatewayKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
- (NSString *)formatToSimpleDateTimeDateTime:(TerminalGatewayKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatToSimpleDateTime(dateTime:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generate(tid:ipaddress:payload:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)generateRawTid:(NSString *)tid ipaddress:(NSString * _Nullable)ipaddress payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayNTTTerminalResult *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("generateRaw(tid:ipaddress:payload:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TransactionFakeCode_")))
@interface TerminalGatewayTransactionFakeCode_ : TerminalGatewayKotlinEnum<TerminalGatewayTransactionFakeCode_ *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *terminalBusy __attribute__((swift_name("terminalBusy")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *declinedByReader __attribute__((swift_name("declinedByReader")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *duplicated __attribute__((swift_name("duplicated")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *cancelled __attribute__((swift_name("cancelled")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *timeout __attribute__((swift_name("timeout")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *noDataFound __attribute__((swift_name("noDataFound")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *voidFailed __attribute__((swift_name("voidFailed")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *needDoSettlement __attribute__((swift_name("needDoSettlement")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *transactionFailed __attribute__((swift_name("transactionFailed")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *tidNotMatch __attribute__((swift_name("tidNotMatch")));
@property (class, readonly) TerminalGatewayTransactionFakeCode_ *wrongPin __attribute__((swift_name("wrongPin")));
+ (TerminalGatewayKotlinArray<TerminalGatewayTransactionFakeCode_ *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayTransactionFakeCode_ *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSArray<TerminalGatewayNTTTransactionType *> * _Nullable actions __attribute__((swift_name("actions")));
@property (readonly) id _Nullable amount __attribute__((swift_name("amount")));
@property (readonly) NSString * _Nullable code __attribute__((swift_name("code")));
@property (readonly) NSString * _Nullable message __attribute__((swift_name("message")));
@property (readonly) NSArray<TerminalGatewayTradeType *> * _Nullable methods __attribute__((swift_name("methods")));
@property (readonly) id _Nullable traceNumber __attribute__((swift_name("traceNumber")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTWebSocketService")))
@interface TerminalGatewayNTTWebSocketService : TerminalGatewayWebSocketService
- (instancetype)initWithResultFlow:(id<TerminalGatewayKotlinx_coroutines_coreMutableStateFlow>)resultFlow shouldRetry:(TerminalGatewayBoolean *(^)(TerminalGatewayKotlinException *))shouldRetry builder:(TerminalGatewayKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(resultFlow:shouldRetry:builder:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithBuilder:(TerminalGatewayKtor_client_coreHttpClient *(^)(void))builder __attribute__((swift_name("init(builder:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (void)closeTerminalID:(NSString *)terminalID __attribute__((swift_name("close(terminalID:)")));

/**
 * Connect to the EDC
 * @param address the IP address
 * @param port the port
 * @param payload the payload
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)connectDevice:(TerminalGatewayBaseTerminalDevice *)device port:(int32_t)port payload:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable)payload completionHandler:(void (^)(TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("connect(device:port:payload:completionHandler:)")));
@property id<TerminalGatewayKtor_ioByteWriteChannel> _Nullable output __attribute__((swift_name("output")));
@property TerminalGatewayMutableDictionary<NSString *, id<TerminalGatewayKtor_networkSocket>> *sockets __attribute__((swift_name("sockets")));
@end

@interface TerminalGatewayBriTerminalResult (Extensions)
- (BOOL)isSuccess __attribute__((swift_name("isSuccess()")));
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
@end

@interface TerminalGatewayResult (Extensions)
- (TerminalGatewayErrorData * _Nullable)toError __attribute__((swift_name("toError()")));
@end

@interface TerminalGatewayTerminalResult (Extensions)
- (NSString * _Nullable)approval __attribute__((swift_name("approval()")));
- (NSString * _Nullable)invoiceNo __attribute__((swift_name("invoiceNo()")));
- (BOOL)isSuccess __attribute__((swift_name("isSuccess()")));
- (BOOL)isSuccess_ __attribute__((swift_name("isSuccess_()")));
- (NSString * _Nullable)referenceID __attribute__((swift_name("referenceID()")));
- (NSString * _Nullable)referenceNumber __attribute__((swift_name("referenceNumber()")));
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
- (NSString *)toRaw_ __attribute__((swift_name("toRaw_()")));
- (TerminalGatewayTradeType * _Nullable)tradeType __attribute__((swift_name("tradeType()")));
@end

@interface TerminalGatewayNTTTerminalResult (Extensions)
- (NSString *)toRaw __attribute__((swift_name("toRaw()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalDateTimeSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateTime")))
@interface TerminalGatewayKotlinx_datetimeLocalDateTime : TerminalGatewayBase <TerminalGatewayKotlinComparable>
- (instancetype)initWithDate:(TerminalGatewayKotlinx_datetimeLocalDate *)date time:(TerminalGatewayKotlinx_datetimeLocalTime *)time __attribute__((swift_name("init(date:time:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(int32_t)month day:(int32_t)day hour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(year:month:day:hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(TerminalGatewayKotlinx_datetimeMonth *)month day:(int32_t)day hour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond_:(int32_t)nanosecond __attribute__((swift_name("init(year:month:day:hour:minute:second:nanosecond_:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeLocalDateTimeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TerminalGatewayKotlinx_datetimeLocalDateTime *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewayKotlinx_datetimeLocalDate *date __attribute__((swift_name("date")));
@property (readonly) int32_t day __attribute__((swift_name("day")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth"))) __attribute__((deprecated("Use the 'day' property instead")));
@property (readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) int32_t hour __attribute__((swift_name("hour")));
@property (readonly) int32_t minute __attribute__((swift_name("minute")));
@property (readonly) TerminalGatewayKotlinx_datetimeMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t monthNumber __attribute__((swift_name("monthNumber"))) __attribute__((deprecated("Use the 'month' property instead")));
@property (readonly) int32_t nanosecond __attribute__((swift_name("nanosecond")));
@property (readonly) int32_t second __attribute__((swift_name("second")));
@property (readonly) TerminalGatewayKotlinx_datetimeLocalTime *time __attribute__((swift_name("time")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end

@interface TerminalGatewayKotlinx_datetimeLocalDateTime (Extensions)
- (NSString *)formatTransactionDateTime __attribute__((swift_name("formatTransactionDateTime()")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/TimeZoneSerializer))
*/
__attribute__((swift_name("Kotlinx_datetimeTimeZone")))
@interface TerminalGatewayKotlinx_datetimeTimeZone : TerminalGatewayBase
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeTimeZoneCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TerminalGatewayKotlinInstant *)toInstant:(TerminalGatewayKotlinx_datetimeLocalDateTime *)receiver youShallNotPass:(TerminalGatewayKotlinx_datetimeOverloadMarker *)youShallNotPass __attribute__((swift_name("toInstant(_:youShallNotPass:)")));
- (TerminalGatewayKotlinx_datetimeLocalDateTime *)toLocalDateTime:(TerminalGatewayKotlinInstant *)receiver __attribute__((swift_name("toLocalDateTime(_:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@end

@interface TerminalGatewayKotlinx_datetimeTimeZone (Extensions)

/**
 * Converts a TimeZone to a GMT string like "GMT+08:00".
 * @param instant The specific moment in time to get the offset for.
 * Defaults to the current system time.
 */
- (NSString *)toGmtStringInstant:(TerminalGatewayKotlinInstant *)instant __attribute__((swift_name("toGmtString(instant:)")));

/**
 * Converts a TimeZone to a GMT string like "GMT+08:00".
 * @param instant The specific moment in time to get the offset for.
 * Defaults to the current system time.
 */
- (NSString *)toOffsetInstant:(TerminalGatewayKotlinInstant *)instant __attribute__((swift_name("toOffset(instant:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("AppModule_iosKt")))
@interface TerminalGatewayAppModule_iosKt : TerminalGatewayBase
+ (TerminalGatewayAppModule *)getAppModule __attribute__((swift_name("getAppModule()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BRIActionKt")))
@interface TerminalGatewayBRIActionKt : TerminalGatewayBase

/**
 * Formats a [LocalDateTime] into the string format required by BRI ("yyyy-MM-dd HH:mm:ss").
 */
+ (NSString *)formatDateTimeDateTime:(TerminalGatewayKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));

/**
 * Formats a [LocalDateTime] into a full ISO-like string with timezone ("yyyy-MM-dd'T'HH:mm:sszzz").
 */
+ (NSString *)formatDateTimeWithTimeZoneDateTime:(TerminalGatewayKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTimeWithTimeZone(dateTime:)")));

/**
 * Parses a date string into a [LocalDateTime], defaulting to GMT+0700 if no timezone is provided.
 */
+ (TerminalGatewayKotlinx_datetimeLocalDateTime * _Nullable)parseDateTimeDateTime:(NSString *)dateTime timeZone:(TerminalGatewayKotlinx_datetimeTimeZone *)timeZone __attribute__((swift_name("parseDateTime(dateTime:timeZone:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BaseDatabaseKt")))
@interface TerminalGatewayBaseDatabaseKt : TerminalGatewayBase
+ (BOOL)contains:(NSArray<id<TerminalGatewayTerminalAction>> *)receiver value:(NSString * _Nullable)value __attribute__((swift_name("contains(_:value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Bluetooth_iosKt")))
@interface TerminalGatewayBluetooth_iosKt : TerminalGatewayBase
+ (id<TerminalGatewayBluetoothService>)getBriBluetoothServiceResult:(id<TerminalGatewayKotlinx_coroutines_coreMutableStateFlow>)result __attribute__((swift_name("getBriBluetoothService(result:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("BriTerminalResultKt")))
@interface TerminalGatewayBriTerminalResultKt : TerminalGatewayBase
+ (TerminalGatewayResult<TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)parseBriResponse:(NSString *)receiver __attribute__((swift_name("parseBriResponse(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DatabaseKt")))
@interface TerminalGatewayDatabaseKt : TerminalGatewayBase
+ (TerminalGatewayDatabaseHandler *)createDatabaseDriverFactory:(TerminalGatewayDriverFactory *)driverFactory oldSecurity:(TerminalGatewayBaseSecurity *)oldSecurity security:(TerminalGatewayBaseSecurity *)security networkService:(TerminalGatewayInternalNetworkService *)networkService __attribute__((swift_name("createDatabase(driverFactory:oldSecurity:security:networkService:)")));
@property (class, readonly) NSString *DB_NAME __attribute__((swift_name("DB_NAME")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ErrorMapperKt")))
@interface TerminalGatewayErrorMapperKt : TerminalGatewayBase
+ (TerminalGatewayErrorData * _Nullable)toErrorResponse:(TerminalGatewayBriTerminalResult *)response __attribute__((swift_name("toError(response:)")));
+ (TerminalGatewayErrorCode *)toSaleErrorMapperAction:(TerminalGatewayBRITerminalAction * _Nullable)action code:(NSString *)code info:(NSString *)info message:(NSString * _Nullable)message __attribute__((swift_name("toSaleErrorMapper(action:code:info:message:)")));
@property (class, readonly) NSString *TC_TRANSACTION_CANCELLED __attribute__((swift_name("TC_TRANSACTION_CANCELLED")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("IPAddresses_iosKt")))
@interface TerminalGatewayIPAddresses_iosKt : TerminalGatewayBase
+ (NSString * _Nullable)getDeviceIPAddress __attribute__((swift_name("getDeviceIPAddress()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("NTTActionKt")))
@interface TerminalGatewayNTTActionKt : TerminalGatewayBase

/**
 * Generates a unique Order ID based on the current UTC timestamp ("yyMMddHHmmss").
 */
+ (NSString *)createOrderID __attribute__((swift_name("createOrderID()")));

/**
 * Formats a [LocalDateTime] into the string format required by NTT ("yyyy-MM-dd HH:mm:ss").
 */
+ (NSString *)formatDateTimeDateTime:(TerminalGatewayKotlinx_datetimeLocalDateTime *)dateTime __attribute__((swift_name("formatDateTime(dateTime:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Platform_iosKt")))
@interface TerminalGatewayPlatform_iosKt : TerminalGatewayBase
+ (id<TerminalGatewayPlatform>)getPlatform __attribute__((swift_name("getPlatform()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt")))
@interface TerminalGatewayResultKt : TerminalGatewayBase
+ (NSString *)approval:(NSString *)receiver __attribute__((swift_name("approval(_:)")));
+ (NSString *)getLast:(NSString *)receiver __attribute__((swift_name("getLast(_:)")));
+ (NSString *)referenceID:(NSString *)receiver __attribute__((swift_name("referenceID(_:)")));
+ (NSString *)referenceNumber:(NSString *)receiver __attribute__((swift_name("referenceNumber(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt_")))
@interface TerminalGatewayResultKt_ : TerminalGatewayBase
+ (TerminalGatewayInt * _Nullable)getHttpResponseCodeCode:(TerminalGatewayErrorCode *)code __attribute__((swift_name("getHttpResponseCode(code:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("ResultKt__")))
@interface TerminalGatewayResultKt__ : TerminalGatewayBase
+ (NSString *)invoiceNo:(NSString *)receiver __attribute__((swift_name("invoiceNo(_:)")));
+ (NSString *)tradeType:(NSString *)receiver __attribute__((swift_name("tradeType(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Security_iosKt")))
@interface TerminalGatewaySecurity_iosKt : TerminalGatewayBase
+ (TerminalGatewayBaseSecurity *)getSecurityApiKey:(NSString *)apiKey __attribute__((swift_name("getSecurity(apiKey:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalBRIKt")))
@interface TerminalGatewayTerminalBRIKt : TerminalGatewayBase
+ (TerminalGatewaySaleMethod *)toSaleMethod:(NSString *)receiver __attribute__((swift_name("toSaleMethod(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("TerminalOperationKt")))
@interface TerminalGatewayTerminalOperationKt : TerminalGatewayBase
@property (class, readonly) id<TerminalGatewayKotlinx_datetimeDateTimeFormat> dateTimeFormat __attribute__((swift_name("dateTimeFormat")));
@property (class, readonly) NSString *formatPattern __attribute__((swift_name("formatPattern")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("DartKt")))
@interface TerminalGatewayDartKt : TerminalGatewayBase

/**
 * Manually converts a VERY SIMPLE JsonObject to an XML string.
 *
 * This function is HIGHLY SPECIFIC to a flat JsonObject structure
 * where keys map directly to XML element names and primitive values
 * map directly to XML element text content.
 *
 * It will **NOT** handle:
 * - Nested JsonObjects or JsonArrays.
 * - Complex XML structures (attributes, namespaces, comments, etc.).
 * - Proper XML entity escaping for special characters (<, >, &, ", ') in values.
 * If your JSON values contain these, the generated XML will be invalid.
 * - Indentation or pretty-printing.
 *
 * Use an actual XML serialization library for robust and correct XML generation.
 *
 * @param jsonObject The flat JsonObject to convert.
 * @param rootTagName The name of the root XML element (e.g., "data", "root").
 * @return A simple XML string.
 */
+ (NSString *)convertJsonObjectToXmlManuallyJsonObject:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)jsonObject rootTagName:(NSString *)rootTagName __attribute__((swift_name("convertJsonObjectToXmlManually(jsonObject:rootTagName:)")));

/**
 * Manually converts a VERY SIMPLE XML string to a JsonObject without an XML parsing library.
 *
 * This function is HIGHLY SPECIFIC to the input XML format:
 * <root_tag>
 * <key1>value1</key1>
 * <key2>value2</key2>
 * ...
 * <keyN>valueN</keyN>
 * </root_tag>
 *
 * It will **NOT** work for:
 * - Nested elements (e.g., <parent><child>...</child></parent>)
 * - Attributes (e.g., <key1 id="abc">value1</key1>)
 * - XML declarations, comments, CDATA, entities, etc.
 * - Mixed content (text directly inside the root tag alongside child tags)
 * - Self-closing tags (<key/>)
 * - Any deviation from the strict <key>value</key> pattern for children.
 * - Poorly formatted XML (e.g., missing closing tags, incorrect nesting).
 *
 * Use an actual XML parsing library (like xmlutil.dom2) for anything more complex.
 */
+ (NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)convertSimpleXmlToSimpleJsonManuallyXmlString:(NSString *)xmlString stringValue:(NSDictionary<NSString *, id> *)stringValue __attribute__((swift_name("convertSimpleXmlToSimpleJsonManually(xmlString:stringValue:)")));
+ (NSString *)escapeXmlSpecialChars:(NSString *)receiver __attribute__((swift_name("escapeXmlSpecialChars(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("JsonKt")))
@interface TerminalGatewayJsonKt : TerminalGatewayBase
+ (NSString *)prettyJsonValue:(id _Nullable)value __attribute__((swift_name("prettyJson(value:)")));
+ (TerminalGatewayKotlinPair<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonPrimitive *> *)toJsonPrimitive:(NSString * _Nullable)receiver key:(NSString *)key __attribute__((swift_name("toJsonPrimitive(_:key:)")));
+ (NSDictionary<NSString *, id> *)toMapNotNull:(NSArray<TerminalGatewayKotlinPair<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *> *)receiver __attribute__((swift_name("toMapNotNull(_:)")));
@property (class, readonly) TerminalGatewayKotlinx_serialization_jsonJson *PrettyJson __attribute__((swift_name("PrettyJson")));
@property (class, readonly) TerminalGatewayKotlinx_serialization_jsonJson *XenJson __attribute__((swift_name("XenJson")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("MockKt")))
@interface TerminalGatewayMockKt : TerminalGatewayBase
+ (TerminalGatewayKotlinx_serialization_jsonJsonElement *)mockRefund:(NSDictionary<NSString *, TerminalGatewayKotlinx_serialization_jsonJsonElement *> *)receiver success:(BOOL)success __attribute__((swift_name("mockRefund(_:success:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinCoroutineContext")))
@protocol TerminalGatewayKotlinCoroutineContext
@required
- (id _Nullable)foldInitial:(id _Nullable)initial operation:(id _Nullable (^)(id _Nullable, id<TerminalGatewayKotlinCoroutineContextElement>))operation __attribute__((swift_name("fold(initial:operation:)")));
- (id<TerminalGatewayKotlinCoroutineContextElement> _Nullable)getKey:(id<TerminalGatewayKotlinCoroutineContextKey>)key __attribute__((swift_name("get(key:)")));
- (id<TerminalGatewayKotlinCoroutineContext>)minusKeyKey:(id<TerminalGatewayKotlinCoroutineContextKey>)key __attribute__((swift_name("minusKey(key:)")));
- (id<TerminalGatewayKotlinCoroutineContext>)plusContext:(id<TerminalGatewayKotlinCoroutineContext>)context __attribute__((swift_name("plus(context:)")));
@end

__attribute__((swift_name("KotlinCoroutineContextElement")))
@protocol TerminalGatewayKotlinCoroutineContextElement <TerminalGatewayKotlinCoroutineContext>
@required
@property (readonly) id<TerminalGatewayKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreJob")))
@protocol TerminalGatewayKotlinx_coroutines_coreJob <TerminalGatewayKotlinCoroutineContextElement>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (id<TerminalGatewayKotlinx_coroutines_coreChildHandle>)attachChildChild:(id<TerminalGatewayKotlinx_coroutines_coreChildJob>)child __attribute__((swift_name("attachChild(child:)")));
- (void)cancelCause:(TerminalGatewayKotlinCancellationException * _Nullable)cause __attribute__((swift_name("cancel(cause:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (TerminalGatewayKotlinCancellationException *)getCancellationException __attribute__((swift_name("getCancellationException()")));
- (id<TerminalGatewayKotlinx_coroutines_coreDisposableHandle>)invokeOnCompletionHandler:(void (^)(TerminalGatewayKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnCompletion(handler:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (id<TerminalGatewayKotlinx_coroutines_coreDisposableHandle>)invokeOnCompletionOnCancelling:(BOOL)onCancelling invokeImmediately:(BOOL)invokeImmediately handler:(void (^)(TerminalGatewayKotlinThrowable * _Nullable))handler __attribute__((swift_name("invokeOnCompletion(onCancelling:invokeImmediately:handler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)joinWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("join(completionHandler:)")));
- (id<TerminalGatewayKotlinx_coroutines_coreJob>)plusOther:(id<TerminalGatewayKotlinx_coroutines_coreJob>)other __attribute__((swift_name("plus(other:)"))) __attribute__((unavailable("Operator '+' on two Job objects is meaningless. Job is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The job to the right of `+` just replaces the job the left of `+`.")));
- (BOOL)start __attribute__((swift_name("start()")));
@property (readonly) id<TerminalGatewayKotlinSequence> children __attribute__((swift_name("children")));
@property (readonly) BOOL isActive __attribute__((swift_name("isActive")));
@property (readonly) BOOL isCancelled __attribute__((swift_name("isCancelled")));
@property (readonly) BOOL isCompleted __attribute__((swift_name("isCompleted")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreSelectClause0> onJoin __attribute__((swift_name("onJoin")));

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreJob> _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineScope")))
@protocol TerminalGatewayKotlinx_coroutines_coreCoroutineScope
@required
@property (readonly) id<TerminalGatewayKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/serialization/json/JsonElementSerializer))
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonElement")))
@interface TerminalGatewayKotlinx_serialization_jsonJsonElement : TerminalGatewayBase
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_serialization_jsonJsonElementCompanion *companion __attribute__((swift_name("companion")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinUnit")))
@interface TerminalGatewayKotlinUnit : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)unit __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinUnit *shared __attribute__((swift_name("shared")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("KotlinFunction")))
@protocol TerminalGatewayKotlinFunction
@required
@end

__attribute__((swift_name("KotlinSuspendFunction0")))
@protocol TerminalGatewayKotlinSuspendFunction0 <TerminalGatewayKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeWithCompletionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinPair")))
@interface TerminalGatewayKotlinPair<__covariant A, __covariant B> : TerminalGatewayBase
- (instancetype)initWithFirst:(A _Nullable)first second:(B _Nullable)second __attribute__((swift_name("init(first:second:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayKotlinPair<A, B> *)doCopyFirst:(A _Nullable)first second:(B _Nullable)second __attribute__((swift_name("doCopy(first:second:)")));
- (BOOL)equalsOther:(id _Nullable)other __attribute__((swift_name("equals(other:)")));
- (int32_t)hashCode __attribute__((swift_name("hashCode()")));
- (NSString *)toString __attribute__((swift_name("toString()")));
@property (readonly) A _Nullable first __attribute__((swift_name("first")));
@property (readonly) B _Nullable second __attribute__((swift_name("second")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreFlow")))
@protocol TerminalGatewayKotlinx_coroutines_coreFlow
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)collectCollector:(id<TerminalGatewayKotlinx_coroutines_coreFlowCollector>)collector completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("collect(collector:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSharedFlow")))
@protocol TerminalGatewayKotlinx_coroutines_coreSharedFlow <TerminalGatewayKotlinx_coroutines_coreFlow>
@required
@property (readonly) NSArray<id> *replayCache __attribute__((swift_name("replayCache")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreStateFlow")))
@protocol TerminalGatewayKotlinx_coroutines_coreStateFlow <TerminalGatewayKotlinx_coroutines_coreSharedFlow>
@required
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreFlowCollector")))
@protocol TerminalGatewayKotlinx_coroutines_coreFlowCollector
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)emitValue:(id _Nullable)value completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("emit(value:completionHandler:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutableSharedFlow")))
@protocol TerminalGatewayKotlinx_coroutines_coreMutableSharedFlow <TerminalGatewayKotlinx_coroutines_coreSharedFlow, TerminalGatewayKotlinx_coroutines_coreFlowCollector>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.ExperimentalCoroutinesApi
*/
- (void)resetReplayCache __attribute__((swift_name("resetReplayCache()")));
- (BOOL)tryEmitValue:(id _Nullable)value __attribute__((swift_name("tryEmit(value:)")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreStateFlow> subscriptionCount __attribute__((swift_name("subscriptionCount")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutableStateFlow")))
@protocol TerminalGatewayKotlinx_coroutines_coreMutableStateFlow <TerminalGatewayKotlinx_coroutines_coreStateFlow, TerminalGatewayKotlinx_coroutines_coreMutableSharedFlow>
@required
- (void)setValue:(id _Nullable)value __attribute__((swift_name("setValue(_:)")));
- (BOOL)compareAndSetExpect:(id _Nullable)expect update:(id _Nullable)update __attribute__((swift_name("compareAndSet(expect:update:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/serialization/json/JsonPrimitiveSerializer))
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonPrimitive")))
@interface TerminalGatewayKotlinx_serialization_jsonJsonPrimitive : TerminalGatewayKotlinx_serialization_jsonJsonElement
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_serialization_jsonJsonPrimitiveCompanion *companion __attribute__((swift_name("companion")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *content __attribute__((swift_name("content")));
@property (readonly) BOOL isString __attribute__((swift_name("isString")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinEnumCompanion")))
@interface TerminalGatewayKotlinEnumCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinEnumCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinArray")))
@interface TerminalGatewayKotlinArray<T> : TerminalGatewayBase
+ (instancetype)arrayWithSize:(int32_t)size init:(T _Nullable (^)(TerminalGatewayInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (T _Nullable)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (id<TerminalGatewayKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(T _Nullable)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreEncoder")))
@protocol TerminalGatewayKotlinx_serialization_coreEncoder
@required
- (id<TerminalGatewayKotlinx_serialization_coreCompositeEncoder>)beginCollectionDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor collectionSize:(int32_t)collectionSize __attribute__((swift_name("beginCollection(descriptor:collectionSize:)")));
- (id<TerminalGatewayKotlinx_serialization_coreCompositeEncoder>)beginStructureDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("beginStructure(descriptor:)")));
- (void)encodeBooleanValue:(BOOL)value __attribute__((swift_name("encodeBoolean(value:)")));
- (void)encodeByteValue:(int8_t)value __attribute__((swift_name("encodeByte(value:)")));
- (void)encodeCharValue:(unichar)value __attribute__((swift_name("encodeChar(value:)")));
- (void)encodeDoubleValue:(double)value __attribute__((swift_name("encodeDouble(value:)")));
- (void)encodeEnumEnumDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)enumDescriptor index:(int32_t)index __attribute__((swift_name("encodeEnum(enumDescriptor:index:)")));
- (void)encodeFloatValue:(float)value __attribute__((swift_name("encodeFloat(value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreEncoder>)encodeInlineDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("encodeInline(descriptor:)")));
- (void)encodeIntValue:(int32_t)value __attribute__((swift_name("encodeInt(value:)")));
- (void)encodeLongValue:(int64_t)value __attribute__((swift_name("encodeLong(value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNotNullMark __attribute__((swift_name("encodeNotNullMark()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNull __attribute__((swift_name("encodeNull()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNullableSerializableValueSerializer:(id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeNullableSerializableValue(serializer:value:)")));
- (void)encodeSerializableValueSerializer:(id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeSerializableValue(serializer:value:)")));
- (void)encodeShortValue:(int16_t)value __attribute__((swift_name("encodeShort(value:)")));
- (void)encodeStringValue:(NSString *)value __attribute__((swift_name("encodeString(value:)")));
@property (readonly) TerminalGatewayKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialDescriptor")))
@protocol TerminalGatewayKotlinx_serialization_coreSerialDescriptor
@required
- (NSArray<id<TerminalGatewayKotlinAnnotation>> *)getElementAnnotationsIndex:(int32_t)index __attribute__((swift_name("getElementAnnotations(index:)")));
- (id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)getElementDescriptorIndex:(int32_t)index __attribute__((swift_name("getElementDescriptor(index:)")));
- (int32_t)getElementIndexName:(NSString *)name __attribute__((swift_name("getElementIndex(name:)")));
- (NSString *)getElementNameIndex:(int32_t)index __attribute__((swift_name("getElementName(index:)")));
- (BOOL)isElementOptionalIndex:(int32_t)index __attribute__((swift_name("isElementOptional(index:)")));
@property (readonly) NSArray<id<TerminalGatewayKotlinAnnotation>> *annotations __attribute__((swift_name("annotations")));
@property (readonly) int32_t elementsCount __attribute__((swift_name("elementsCount")));
@property (readonly) BOOL isInline __attribute__((swift_name("isInline")));
@property (readonly) BOOL isNullable __attribute__((swift_name("isNullable")));
@property (readonly) TerminalGatewayKotlinx_serialization_coreSerialKind *kind __attribute__((swift_name("kind")));
@property (readonly) NSString *serialName __attribute__((swift_name("serialName")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreDecoder")))
@protocol TerminalGatewayKotlinx_serialization_coreDecoder
@required
- (id<TerminalGatewayKotlinx_serialization_coreCompositeDecoder>)beginStructureDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("beginStructure(descriptor:)")));
- (BOOL)decodeBoolean __attribute__((swift_name("decodeBoolean()")));
- (int8_t)decodeByte __attribute__((swift_name("decodeByte()")));
- (unichar)decodeChar __attribute__((swift_name("decodeChar()")));
- (double)decodeDouble __attribute__((swift_name("decodeDouble()")));
- (int32_t)decodeEnumEnumDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)enumDescriptor __attribute__((swift_name("decodeEnum(enumDescriptor:)")));
- (float)decodeFloat __attribute__((swift_name("decodeFloat()")));
- (id<TerminalGatewayKotlinx_serialization_coreDecoder>)decodeInlineDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeInline(descriptor:)")));
- (int32_t)decodeInt __attribute__((swift_name("decodeInt()")));
- (int64_t)decodeLong __attribute__((swift_name("decodeLong()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)decodeNotNullMark __attribute__((swift_name("decodeNotNullMark()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (TerminalGatewayKotlinNothing * _Nullable)decodeNull __attribute__((swift_name("decodeNull()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id _Nullable)decodeNullableSerializableValueDeserializer:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy>)deserializer __attribute__((swift_name("decodeNullableSerializableValue(deserializer:)")));
- (id _Nullable)decodeSerializableValueDeserializer:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy>)deserializer __attribute__((swift_name("decodeSerializableValue(deserializer:)")));
- (int16_t)decodeShort __attribute__((swift_name("decodeShort()")));
- (NSString *)decodeString __attribute__((swift_name("decodeString()")));
@property (readonly) TerminalGatewayKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.0")
*/
__attribute__((swift_name("KotlinAutoCloseable")))
@protocol TerminalGatewayKotlinAutoCloseable
@required
- (void)close __attribute__((swift_name("close()")));
@end

__attribute__((swift_name("Ktor_ioCloseable")))
@protocol TerminalGatewayKtor_ioCloseable <TerminalGatewayKotlinAutoCloseable>
@required
@end


/**
 * A multiplatform asynchronous HTTP client that allows you to make requests, handle responses,
 * and extend its functionality with plugins such as authentication, JSON serialization, and more.
 *
 * # Creating client
 * To create a new client, you can call:
 * ```kotlin
 * val client = HttpClient()
 * ```
 * You can create as many clients as you need.
 *
 * If you no longer need the client, please consider closing it to release resources:
 * ```
 * client.close()
 * ```
 *
 * To learn more on how to create and configure an [HttpClient] see the tutorial page:
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * # Making API Requests
 * For every HTTP method (GET, POST, PUT, etc.), there is a corresponding function:
 * ```kotlin
 * val response: HttpResponse = client.get("https://ktor.io/")
 * val body = response.bodyAsText()
 * ```
 * See [Making HTTP requests](https://ktor.io/docs/client-requests.html) for more details.
 *
 * # Query Parameters
 * Add query parameters to your request using the `parameter` function:
 * ```kotlin
 * val response = client.get("https://google.com/search") {
 *     url {
 *         parameter("q", "REST API with Ktor")
 *     }
 * }
 * ```
 * For more information, refer to [Passing request parameters](https://ktor.io/docs/client-requests.html#parameters).
 *
 * # Adding Headers
 * Include headers in your request using the `headers` builder or the `header` function:
 * ```kotlin
 * val response = client.get("https://httpbin.org/bearer") {
 *     headers {
 *         append("Authorization", "Bearer your_token_here")
 *         append("Accept", "application/json")
 *     }
 * }
 * ```
 * Learn more at [Adding headers to a request](https://ktor.io/docs/client-requests.html#headers).
 *
 * # JSON Serialization
 * Add dependencies:
 * - io.ktor:ktor-client-content-negotiation:3.+
 * - io.ktor:ktor-serialization-kotlinx-json:3.+
 * Add Gradle plugin:
 * ```
 * plugins {
 *     kotlin("plugin.serialization")
 * }
 * ```
 *
 * Send and receive JSON data by installing the `ContentNegotiation` plugin with `kotlinx.serialization`:
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         json()
 *     }
 * }
 *
 * @Serializable
 * data class MyRequestType(val someData: String)
 *
 * @Serializable
 * data class MyResponseType(val someResponseData: String)
 *
 * val response: MyResponseType = client.post("https://api.example.com/data") {
 *     contentType(ContentType.Application.Json)
 *     setBody(MyRequestType(someData = "value"))
 * }.body()
 * ```
 * See [Serializing JSON data](https://ktor.io/docs/client-serialization.html) for maven configuration and other details.
 *
 * # Submitting Forms
 * Submit form data using `FormDataContent` or the `submitForm` function:
 * ```kotlin
 * // Using FormDataContent
 * val response = client.post("https://example.com/submit") {
 *     setBody(FormDataContent(Parameters.build {
 *         append("username", "user")
 *         append("password", "pass")
 *     }))
 * }
 *
 * // Or using submitForm
 * val response = client.submitForm(
 *     url = "https://example.com/submit",
 *     formParameters = Parameters.build {
 *         append("username", "user")
 *         append("password", "pass")
 *     }
 * )
 * ```
 * More information is available at [Submitting form parameters](https://ktor.io/docs/client-requests.html#form_parameters).
 *
 * # Handling Authentication
 * Add dependency: io.ktor:ktor-client-auth:3.+
 *
 * Use the `Auth` plugin to handle various authentication schemes like Basic or Bearer token authentication:
 * ```kotlin
 * val client = HttpClient {
 *     install(Auth) {
 *         bearer {
 *             loadTokens {
 *                 BearerTokens(accessToken = "your_access_token", refreshToken = "your_refresh_token")
 *             }
 *         }
 *     }
 * }
 *
 * val response = client.get("https://api.example.com/protected")
 * ```
 * Refer to [Client authentication](https://ktor.io/docs/client-auth.html) for more details.
 *
 * # Setting Timeouts and Retries
 * Configure timeouts and implement retry logic for your requests:
 * ```kotlin
 * val client = HttpClient {
 *     install(HttpTimeout) {
 *         requestTimeoutMillis = 10000
 *         connectTimeoutMillis = 5000
 *         socketTimeoutMillis = 15000
 *     }
 * }
 * ```
 *
 * For the request timeout:
 * ```kotlin
 * client.get("") {
 *     timeout {
 *         requestTimeoutMillis = 1000
 *     }
 * }
 * ```
 * See [Timeout](https://ktor.io/docs/client-timeout.html) for more information.
 *
 * # Handling Cookies
 *
 * Manage cookies automatically by installing the `HttpCookies` plugin:
 * ```kotlin
 * val client = HttpClient {
 *     install(HttpCookies) {
 *         storage = AcceptAllCookiesStorage()
 *     }
 * }
 *
 * // Accessing cookies
 * val cookies: List<Cookie> = client.cookies("https://example.com")
 * ```
 * Learn more at [Cookies](https://ktor.io/docs/client-cookies.html).
 *
 * # Uploading Files
 * Upload files using multipart/form-data requests:
 * ```kotlin
 * client.submitFormWithBinaryData(
 *      url = "https://example.com/upload",
 *      formData = formData {
 *          append("description", "File upload example")
 *          append("file", {
 *              File("path/to/file.txt").readChannel()
 *          })
 *      }
 *  )
 *
 * See [Uploading data](https://ktor.io/docs/client-requests.html#upload_file) for details.
 *
 * # Using WebSockets
 *
 * Communicate over WebSockets using the `webSocket` function:
 * ```kotlin
 * client.webSocket("wss://echo.websocket.org") {
 *     send(Frame.Text("Hello, WebSocket!"))
 *     val frame = incoming.receive()
 *     if (frame is Frame.Text) {
 *         println("Received: ${frame.readText()}")
 *     }
 * }
 * ```
 * Learn more at [Client WebSockets](https://ktor.io/docs/client-websockets.html).
 *
 * # Error Handling
 * Handle exceptions and HTTP error responses gracefully:
 * val client = HttpClient {
 *     HttpResponseValidator {
 *         validateResponse { response ->
 *             val statusCode = response.status.value
 *             when (statusCode) {
 *                 in 300..399 -> error("Redirects are not allowed")
 *             }
 *         }
 *     }
 * }
 * See [Error handling](https://ktor.io/docs/client-response-validation.html) for more information.
 *
 * # Configuring SSL/TLS
 *
 * Customize SSL/TLS settings for secure connections is engine-specific. Please refer to the following page for
 * the details: [Client SSL/TLS](https://ktor.io/docs/client-ssl.html).
 *
 * # Using Proxies
 * Route requests through an HTTP or SOCKS proxy:
 * ```kotlin
 * val client = HttpClient() {
 *     engine {
 *         proxy = ProxyBuilder.http("http://proxy.example.com:8080")
 *         // For a SOCKS proxy:
 *         // proxy = ProxyBuilder.socks(host = "proxy.example.com", port = 1080)
 *     }
 * }
 * ```
 * See [Using a proxy](https://ktor.io/docs/client-proxy.html) for details.
 *
 * # Streaming Data
 *
 * Stream large data efficiently without loading it entirely into memory.
 *
 * Stream request:
 * ```kotlin
 * val response = client.post("https://example.com/upload") {
 *      setBody(object: OutgoingContent.WriteChannelContent() {
 *          override suspend fun writeTo(channel: ByteWriteChannel) {
 *              repeat(1000) {
 *                  channel.writeString("Hello!")
 *              }
 *          }
 *      })
 * }
 * ```
 *
 * Stream response:
 * ```kotlin
 * client.prepareGet("https://example.com/largefile.zip").execute { response ->
 *     val channel: ByteReadChannel = response.bodyAsChannel()
 *
 *     while (!channel.exhausted()) {
 *         val chunk = channel.readBuffer()
 *         // ...
 *     }
 * }
 * ```
 * Learn more at [Streaming data](https://ktor.io/docs/client-responses.html#streaming).
 *
 * # Using SSE
 * Server-Sent Events (SSE) is a technology that allows a server to continuously push events to a client over an HTTP
 * connection. It's particularly useful in cases where the server needs to send event-based updates without requiring
 * the client to repeatedly poll the server.
 *
 * Install the plugin:
 * ```kotlin
 * val client = HttpClient(CIO) {
 *     install(SSE)
 * }
 * ```
 *
 * ```
 * client.sse(host = "0.0.0.0", port = 8080, path = "/events") {
 *     while (true) {
 *         for (event in incoming) {
 *             println("Event from server:")
 *             println(event)
 *         }
 *     }
 * }
 * ```
 *
 * Visit [Using SSE](https://ktor.io/docs/client-server-sent-events.html#install_plugin) to learn more.
 *
 * # Customizing a client with plugins
 * To extend out-of-the-box functionality, you can install plugins for a Ktor client:
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         json()
 *     }
 * }
 * ```
 *
 * There are many plugins available out of the box, and you can write your own. See
 * [Create custom client plugins](https://ktor.io/docs/client-custom-plugins.html) to learn more.
 *
 * # Service Loader and Default Engine
 * On JVM, calling `HttpClient()` without specifying an engine uses a service loader mechanism to
 * determine the appropriate default engine. This can introduce a performance overhead, especially on
 * slower devices, such as Android.
 *
 * **Performance Note**: If you are targeting platforms where initialization speed is critical,
 * consider explicitly specifying an engine to avoid the service loader lookup.
 *
 * Example with manual engine specification:
 * ```
 * val client = HttpClient(Apache) // Explicitly uses Apache engine, bypassing service loader
 * ```
 *
 * By directly setting the engine (e.g., `Apache`, `OkHttp`), you can optimize startup performance
 * by preventing the default service loader mechanism.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClient")))
@interface TerminalGatewayKtor_client_coreHttpClient : TerminalGatewayBase <TerminalGatewayKotlinx_coroutines_coreCoroutineScope, TerminalGatewayKtor_ioCloseable>
- (instancetype)initWithEngine:(id<TerminalGatewayKtor_client_coreHttpClientEngine>)engine userConfig:(TerminalGatewayKtor_client_coreHttpClientConfig<TerminalGatewayKtor_client_coreHttpClientEngineConfig *> *)userConfig __attribute__((swift_name("init(engine:userConfig:)"))) __attribute__((objc_designated_initializer));

/**
 * Initiates the shutdown process for the `HttpClient`. This is a non-blocking call, which
 * means it returns immediately and begins the client closure in the background.
 *
 * ## Usage
 * ```
 * val client = HttpClient()
 * client.close()
 * client.coroutineContext.job.join() // Waits for complete termination if necessary
 * ```
 *
 * ## Important Notes
 * - **Non-blocking**: `close()` only starts the closing process and does not wait for it to complete.
 * - **Coroutine Context**: To wait for all client resources to be freed, use `client.coroutineContext.job.join()`
 *   or `client.coroutineContext.cancel()` to terminate ongoing tasks.
 * - **Manual Engine Management**: If a custom `engine` was manually created, it must be closed explicitly
 *   after calling `client.close()` to release all resources.
 *
 * Example with custom engine management:
 * ```
 * val engine = HttpClientEngine() // Custom engine instance
 * val client = HttpClient(engine)
 *
 * client.close()
 * engine.close() // Ensure manually created engine is also closed
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.close)
 */
- (void)close __attribute__((swift_name("close()")));

/**
 * Returns a new [HttpClient] by copying this client's configuration
 * and additionally configured by the [block] parameter.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.config)
 */
- (TerminalGatewayKtor_client_coreHttpClient *)configBlock:(void (^)(TerminalGatewayKtor_client_coreHttpClientConfig<id> *))block __attribute__((swift_name("config(block:)")));

/**
 * Checks if the specified [capability] is supported by this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.isSupported)
 */
- (BOOL)isSupportedCapability:(id<TerminalGatewayKtor_client_coreHttpClientEngineCapability>)capability __attribute__((swift_name("isSupported(capability:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * Typed attributes used as a lightweight container for this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.attributes)
 */
@property (readonly) id<TerminalGatewayKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) id<TerminalGatewayKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));
@property (readonly) id<TerminalGatewayKtor_client_coreHttpClientEngine> engine __attribute__((swift_name("engine")));

/**
 * Provides access to the client's engine configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.engineConfig)
 */
@property (readonly) TerminalGatewayKtor_client_coreHttpClientEngineConfig *engineConfig __attribute__((swift_name("engineConfig")));

/**
 * Provides access to the events of the client's lifecycle.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.monitor)
 */
@property (readonly) TerminalGatewayKtor_eventsEvents *monitor __attribute__((swift_name("monitor")));

/**
 * A pipeline used for receiving a request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.receivePipeline)
 */
@property (readonly) TerminalGatewayKtor_client_coreHttpReceivePipeline *receivePipeline __attribute__((swift_name("receivePipeline")));

/**
 * A pipeline used for processing all requests sent by this client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.requestPipeline)
 */
@property (readonly) TerminalGatewayKtor_client_coreHttpRequestPipeline *requestPipeline __attribute__((swift_name("requestPipeline")));

/**
 * A pipeline used for processing all responses sent by the server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.responsePipeline)
 */
@property (readonly) TerminalGatewayKtor_client_coreHttpResponsePipeline *responsePipeline __attribute__((swift_name("responsePipeline")));

/**
 * A pipeline used for sending a request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClient.sendPipeline)
 */
@property (readonly) TerminalGatewayKtor_client_coreHttpSendPipeline *sendPipeline __attribute__((swift_name("sendPipeline")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreMutex")))
@protocol TerminalGatewayKotlinx_coroutines_coreMutex
@required
- (BOOL)holdsLockOwner:(id)owner __attribute__((swift_name("holdsLock(owner:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)lockOwner:(id _Nullable)owner completionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("lock(owner:completionHandler:)")));
- (BOOL)tryLockOwner:(id _Nullable)owner __attribute__((swift_name("tryLock(owner:)")));
- (void)unlockOwner:(id _Nullable)owner __attribute__((swift_name("unlock(owner:)")));
@property (readonly) BOOL isLocked __attribute__((swift_name("isLocked")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreSelectClause2> onLock __attribute__((swift_name("onLock"))) __attribute__((deprecated("Mutex.onLock deprecated without replacement. For additional details please refer to #2794")));
@end

__attribute__((swift_name("RuntimeTransactionCallbacks")))
@protocol TerminalGatewayRuntimeTransactionCallbacks
@required
- (void)afterCommitFunction:(void (^)(void))function __attribute__((swift_name("afterCommit(function:)")));
- (void)afterRollbackFunction:(void (^)(void))function __attribute__((swift_name("afterRollback(function:)")));
@end

__attribute__((swift_name("RuntimeTransactionWithoutReturn")))
@protocol TerminalGatewayRuntimeTransactionWithoutReturn <TerminalGatewayRuntimeTransactionCallbacks>
@required

/**
 * Rolls back this transaction.
 */
- (void)rollback __attribute__((swift_name("rollback()")));

/**
 * Begin an inner transaction.
 */
- (void)transactionBody:(void (^)(id<TerminalGatewayRuntimeTransactionWithoutReturn>))body __attribute__((swift_name("transaction(body:)")));
@end

__attribute__((swift_name("RuntimeTransactionWithReturn")))
@protocol TerminalGatewayRuntimeTransactionWithReturn <TerminalGatewayRuntimeTransactionCallbacks>
@required

/**
 * Rolls back this transaction.
 */
- (void)rollbackReturnValue:(id _Nullable)returnValue __attribute__((swift_name("rollback(returnValue:)")));

/**
 * Begin an inner transaction.
 */
- (id _Nullable)transactionBody_:(id _Nullable (^)(id<TerminalGatewayRuntimeTransactionWithReturn>))body __attribute__((swift_name("transaction(body_:)")));
@end

__attribute__((swift_name("RuntimeCloseable")))
@protocol TerminalGatewayRuntimeCloseable
@required
- (void)close __attribute__((swift_name("close()")));
@end


/**
 * Maintains connections to an underlying SQL database and provides APIs for managing transactions
 * and executing SQL statements.
 */
__attribute__((swift_name("RuntimeSqlDriver")))
@protocol TerminalGatewayRuntimeSqlDriver <TerminalGatewayRuntimeCloseable>
@required
- (void)addListenerQueryKeys:(TerminalGatewayKotlinArray<NSString *> *)queryKeys listener:(id<TerminalGatewayRuntimeQueryListener>)listener __attribute__((swift_name("addListener(queryKeys:listener:)")));

/**
 * The currently open [Transacter.Transaction] on the database.
 *
 * It's up to the implementor how this method behaves for different connection/threading patterns.
 */
- (TerminalGatewayRuntimeTransacterTransaction * _Nullable)currentTransaction __attribute__((swift_name("currentTransaction()")));

/**
 * Execute a SQL statement.
 *
 * @param [identifier] An opaque, unique value that can be used to implement any driver-side
 *   caching of prepared statements. If [identifier] is null, a fresh statement is required.
 * @param [sql] The SQL string to be executed.
 * @param [parameters] The number of bindable parameters [sql] contains.
 * @param [binders] A lambda which is called before execution to bind any parameters to the SQL
 *   statement.
 *
 * @return The number of rows updated for an INSERT/DELETE/UPDATE, or 0 for other SQL statements.
 *
 * NOTE it is up to the specific driver to correctly return the row changes. Notably the SQLJS
 * driver does not do this and you should query changes() manually.
 */
- (id<TerminalGatewayRuntimeQueryResult>)executeIdentifier:(TerminalGatewayInt * _Nullable)identifier sql:(NSString *)sql parameters:(int32_t)parameters binders:(void (^ _Nullable)(id<TerminalGatewayRuntimeSqlPreparedStatement>))binders __attribute__((swift_name("execute(identifier:sql:parameters:binders:)")));

/**
 * Execute a SQL statement and evaluate its result set using the given block.
 *
 * @param [identifier] An opaque, unique value that can be used to implement any driver-side
 *   caching of prepared statements. If [identifier] is null, a fresh statement is required.
 * @param [sql] The SQL string to be executed.
 * @param [mapper] A lambda which is called with the cursor when the statement is executed
 *   successfully. The generic result of the lambda is returned to the caller, as soon as the
 *   mutual exclusion on the database connection ends. The cursor **must not escape** the block
 *   scope.
 * @param [parameters] The number of bindable parameters [sql] contains.
 * @param [binders] A lambda which is called before execution to bind any parameters to the SQL
 *   statement.
 */
- (id<TerminalGatewayRuntimeQueryResult>)executeQueryIdentifier:(TerminalGatewayInt * _Nullable)identifier sql:(NSString *)sql mapper:(id<TerminalGatewayRuntimeQueryResult> (^)(id<TerminalGatewayRuntimeSqlCursor>))mapper parameters:(int32_t)parameters binders:(void (^ _Nullable)(id<TerminalGatewayRuntimeSqlPreparedStatement>))binders __attribute__((swift_name("executeQuery(identifier:sql:mapper:parameters:binders:)")));

/**
 * Start a new [Transacter.Transaction] on the database.
 *
 * It's up to the implementor how this method behaves for different connection/threading patterns.
 */
- (id<TerminalGatewayRuntimeQueryResult>)doNewTransaction __attribute__((swift_name("doNewTransaction()")));
- (void)notifyListenersQueryKeys:(TerminalGatewayKotlinArray<NSString *> *)queryKeys __attribute__((swift_name("notifyListeners(queryKeys:)")));
- (void)removeListenerQueryKeys:(TerminalGatewayKotlinArray<NSString *> *)queryKeys listener:(id<TerminalGatewayRuntimeQueryListener>)listener __attribute__((swift_name("removeListener(queryKeys:listener:)")));
@end


/**
 * API for creating and migrating a SQL database. The implementation of this interface is generated
 * by SQLDelight.
 *
 * @param T Says whether the generated code for this database is asynchronous or synchronous. Most
 *          implementations of [app.cash.sqldelight.SqlDriver] will require one or the other, which
 *          is enforced by requesting the correlated type of Schema ([QueryResult.Value] for
 *          a synchronous runtime, [QueryResult.AsyncValue] for asynchronous). In a multiplatform
 *          environment where you have some drivers that use an asynchronous runtime, and some that
 *          require synchronous, you can generate an asynchronous runtime and then pass a
 *          synchronous schema to synchronous drivers with [SqlSchema.synchronous()]
 */
__attribute__((swift_name("RuntimeSqlSchema")))
@protocol TerminalGatewayRuntimeSqlSchema
@required

/**
 * Use [driver] to create the schema from scratch. Assumes no existing database state.
 */
- (id<TerminalGatewayRuntimeQueryResult>)createDriver:(id<TerminalGatewayRuntimeSqlDriver>)driver __attribute__((swift_name("create(driver:)")));

/**
 * Use [driver] to migrate from schema [oldVersion] to [newVersion].
 * Each of the [callbacks] are executed during the migration whenever the upgrade to the version specified by
 * [AfterVersion.afterVersion] has been completed.
 */
- (id<TerminalGatewayRuntimeQueryResult>)migrateDriver:(id<TerminalGatewayRuntimeSqlDriver>)driver oldVersion:(int64_t)oldVersion newVersion:(int64_t)newVersion callbacks:(TerminalGatewayKotlinArray<TerminalGatewayRuntimeAfterVersion *> *)callbacks __attribute__((swift_name("migrate(driver:oldVersion:newVersion:callbacks:)")));

/**
 * The version of this schema.
 */
@property (readonly) int64_t version __attribute__((swift_name("version")));
@end


/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
__attribute__((swift_name("RuntimeTransacterTransaction")))
@interface TerminalGatewayRuntimeTransacterTransaction : TerminalGatewayBase <TerminalGatewayRuntimeTransactionCallbacks>

/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A SQL transaction. Can be created through the driver via [SqlDriver.newTransaction] or
 * through an implementation of [Transacter] by calling [Transacter.transaction].
 *
 * A transaction is expected never to escape the thread it is created on, or more specifically,
 * never to escape the lambda scope of [Transacter.transaction] and [Transacter.transactionWithResult].
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Queues [function] to be run after this transaction successfully commits.
 */
- (void)afterCommitFunction:(void (^)(void))function __attribute__((swift_name("afterCommit(function:)")));

/**
 * Queues [function] to be run after this transaction rolls back.
 */
- (void)afterRollbackFunction:(void (^)(void))function __attribute__((swift_name("afterRollback(function:)")));

/**
 * Signal to the underlying SQL driver that this transaction should be finished.
 *
 * @param successful Whether the transaction completed successfully or not.
 *
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (id<TerminalGatewayRuntimeQueryResult>)endTransactionSuccessful:(BOOL)successful __attribute__((swift_name("endTransaction(successful:)")));

/**
 * The parent transaction, if there is any.
 *
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TerminalGatewayRuntimeTransacterTransaction * _Nullable enclosingTransaction __attribute__((swift_name("enclosingTransaction")));
@end

__attribute__((swift_name("RuntimeExecutableQuery")))
@interface TerminalGatewayRuntimeExecutableQuery<__covariant RowType> : TerminalGatewayBase
- (instancetype)initWithMapper:(RowType (^)(id<TerminalGatewayRuntimeSqlCursor>))mapper __attribute__((swift_name("init(mapper:)"))) __attribute__((objc_designated_initializer));

/**
 * Execute the underlying statement. The resulting cursor is passed to the given block.
 *
 * The cursor is closed automatically after the block returns.
 */
- (id<TerminalGatewayRuntimeQueryResult>)executeMapper:(id<TerminalGatewayRuntimeQueryResult> (^)(id<TerminalGatewayRuntimeSqlCursor>))mapper __attribute__((swift_name("execute(mapper:)")));

/**
 * @return The result set of the underlying SQL statement as a list of [RowType].
 */
- (NSArray<RowType> *)executeAsList __attribute__((swift_name("executeAsList()")));

/**
 * @return The only row of the result set for the underlying SQL statement as a non null
 *   [RowType].
 *
 * @throws NullPointerException if when executed this query has no rows in its result set.
 * @throws IllegalStateException if when executed this query has multiple rows in its result set.
 */
- (RowType)executeAsOne __attribute__((swift_name("executeAsOne()")));

/**
 * @return The first row of the result set for the underlying SQL statement as a non null
 *   [RowType] or null if the result set has no rows.
 *
 * @throws IllegalStateException if when executed this query has multiple rows in its result set.
 */
- (RowType _Nullable)executeAsOneOrNull __attribute__((swift_name("executeAsOneOrNull()")));
@property (readonly) RowType (^mapper)(id<TerminalGatewayRuntimeSqlCursor>) __attribute__((swift_name("mapper")));
@end


/**
 * A listenable, typed query generated by SQLDelight.
 *
 * @param RowType the type that this query can map its result set to.
 *
 * @property mapper The mapper this [Query] was created with, which can convert a row in the SQL
 *   cursor returned by [execute] to [RowType].
 */
__attribute__((swift_name("RuntimeQuery")))
@interface TerminalGatewayRuntimeQuery<__covariant RowType> : TerminalGatewayRuntimeExecutableQuery<RowType>
- (instancetype)initWithMapper:(RowType (^)(id<TerminalGatewayRuntimeSqlCursor>))mapper __attribute__((swift_name("init(mapper:)"))) __attribute__((objc_designated_initializer));

/**
 * Register a listener to be notified of future changes in the result set.
 */
- (void)addListenerListener:(id<TerminalGatewayRuntimeQueryListener>)listener __attribute__((swift_name("addListener(listener:)")));

/**
 * Remove a listener to no longer be notified of future changes in the result set.
 */
- (void)removeListenerListener:(id<TerminalGatewayRuntimeQueryListener>)listener __attribute__((swift_name("removeListener(listener:)")));
@end


/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClientConfig")))
@interface TerminalGatewayKtor_client_coreHttpClientConfig<T> : TerminalGatewayBase

/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * A mutable [HttpClient] configuration used to adjust settings, install plugins and interceptors.
 *
 * This configuration can be provided as a lambda in the [HttpClient] constructor or the [HttpClient.config] builder:
 * ```kotlin
 * val client = HttpClient { // HttpClientConfig<Engine>()
 *     // Configure engine settings
 *     engine { // HttpClientEngineConfig
 *         threadsCount = 4
 *         pipelining = true
 *     }
 *
 *     // Install and configure plugins
 *     install(ContentNegotiation) {
 *         json()
 *     }
 *
 *     // Configure default request parameters
 *     defaultRequest {
 *         url("https://api.example.com")
 *         header("X-Custom-Header", "value")
 *     }
 *
 *     // Configure client-wide settings
 *     expectSuccess = true
 *     followRedirects = true
 * }
 * ```
 * ## Configuring [HttpClientEngine]
 *
 * If the engine is specified explicitly, engine-specific properties will be available in the `engine` block:
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>.() -> Unit
 *     engine { // CIOEngineConfig.() -> Unit
 *         // engine specific properties
 *     }
 * }
 * ```
 *
 * Learn more about the client's configuration from
 * [Creating and configuring a client](https://ktor.io/docs/create-client.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Clones this [HttpClientConfig] by duplicating all the [plugins] and [customInterceptors].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.clone)
 */
- (TerminalGatewayKtor_client_coreHttpClientConfig<T> *)clone __attribute__((swift_name("clone()")));

/**
 * A builder for configuring engine-specific settings in [HttpClientEngineConfig],
 * such as dispatcher, thread count, proxy, and more.
 *
 * ```kotlin
 * val client = HttpClient(CIO) { // HttpClientConfig<CIOEngineConfig>
 *     engine { // CIOEngineConfig.() -> Unit
 *         proxy = ProxyBuilder.http("proxy.example.com", 8080)
 *     }
 * ```
 *
 * You can learn more from [Engines](https://ktor.io/docs/http-client-engines.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.engine)
 */
- (void)engineBlock:(void (^)(T))block __attribute__((swift_name("engine(block:)")));

/**
 * Applies all the installed [plugins] and [customInterceptors] from this configuration
 * into the specified [client].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installClient:(TerminalGatewayKtor_client_coreHttpClient *)client __attribute__((swift_name("install(client:)")));

/**
 * Installs the specified [plugin] and optionally configures it using the [configure] block.
 *
 * ```kotlin
 * val client = HttpClient {
 *     install(ContentNegotiation) {
 *         // configuration block
 *         json()
 *     }
 * }
 * ```
 *
 * If the plugin is already installed, the configuration block will be applied to the existing configuration class.
 *
 * Learn more from [Plugins](https://ktor.io/docs/http-client-plugins.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installPlugin:(id<TerminalGatewayKtor_client_coreHttpClientPlugin>)plugin configure:(void (^)(id))configure __attribute__((swift_name("install(plugin:configure:)")));

/**
 * Installs an interceptor defined by [block].
 * The [key] parameter is used as a unique name, that also prevents installing duplicated interceptors.
 *
 * If the [key] is already used, the new interceptor will replace the old one.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.install)
 */
- (void)installKey:(NSString *)key block:(void (^)(TerminalGatewayKtor_client_coreHttpClient *))block __attribute__((swift_name("install(key:block:)")));

/**
 * Installs the plugin from the [other] client's configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.plusAssign)
 */
- (void)plusAssignOther:(TerminalGatewayKtor_client_coreHttpClientConfig<T> *)other __attribute__((swift_name("plusAssign(other:)")));

/**
 * Development mode is no longer required all functionality is enabled by default. The property is safe to remove.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.developmentMode)
 */
@property BOOL developmentMode __attribute__((swift_name("developmentMode"))) __attribute__((deprecated("Development mode is no longer required. The property will be removed in the future.")));

/**
 * Terminates [HttpClient.receivePipeline] if the status code is not successful (>=300).
 * Learn more from [Response validation](https://ktor.io/docs/response-validation.html).
 *
 * For more details, see the [HttpCallValidator] documentation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.expectSuccess)
 */
@property BOOL expectSuccess __attribute__((swift_name("expectSuccess")));

/**
 * Specifies whether the client redirects to URLs provided in the `Location` header.
 * You can disable redirections by setting this property to `false`.
 *
 * For an advanced redirection configuration, use the [HttpRedirect] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.followRedirects)
 */
@property BOOL followRedirects __attribute__((swift_name("followRedirects")));

/**
 * Enables body transformations for many common types like [String], [ByteArray], [ByteReadChannel], etc.
 * These transformations are applied to the request and response bodies.
 *
 * The transformers will be used when the response body is received with a type:
 * ```kotlin
 * val client = HttpClient()
 * val bytes = client.get("https://ktor.io")
 *                   .body<ByteArray>()
 * ```
 *
 * This flag is enabled by default.
 * You might want to disable it if you want to write your own transformers or handle body manually.
 *
 * For more details, see the [defaultTransformers] documentation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.HttpClientConfig.useDefaultTransformers)
 */
@property BOOL useDefaultTransformers __attribute__((swift_name("useDefaultTransformers")));
@end


/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreWebSockets.Config")))
@interface TerminalGatewayKtor_client_coreWebSocketsConfig : TerminalGatewayBase

/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * [WebSockets] configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Configure WebSocket extensions.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.extensions)
 */
- (void)extensionsBlock:(void (^)(TerminalGatewayKtor_websocketsWebSocketExtensionsConfig *))block __attribute__((swift_name("extensions(block:)")));

/**
 * A converter for serialization/deserialization
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.contentConverter)
 */
@property id<TerminalGatewayKtor_serializationWebsocketContentConverter> _Nullable contentConverter __attribute__((swift_name("contentConverter")));

/**
 * Sets maximum frame size in bytes.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.maxFrameSize)
 */
@property int64_t maxFrameSize __attribute__((swift_name("maxFrameSize")));

/**
 * Sets interval of sending ping frames.
 *
 * Use [PINGER_DISABLED] to disable ping.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.websocket.WebSockets.Config.pingIntervalMillis)
 */
@property int64_t pingIntervalMillis __attribute__((swift_name("pingIntervalMillis")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinByteArray")))
@interface TerminalGatewayKotlinByteArray : TerminalGatewayBase
+ (instancetype)arrayWithSize:(int32_t)size __attribute__((swift_name("init(size:)")));
+ (instancetype)arrayWithSize:(int32_t)size init:(TerminalGatewayByte *(^)(TerminalGatewayInt *))init __attribute__((swift_name("init(size:init:)")));
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (int8_t)getIndex:(int32_t)index __attribute__((swift_name("get(index:)")));
- (TerminalGatewayKotlinByteIterator *)iterator __attribute__((swift_name("iterator()")));
- (void)setIndex:(int32_t)index value:(int8_t)value __attribute__((swift_name("set(index:value:)")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormat")))
@protocol TerminalGatewayKotlinx_datetimeDateTimeFormat
@required
- (NSString *)formatValue:(id _Nullable)value __attribute__((swift_name("format(value:)")));
- (id<TerminalGatewayKotlinAppendable>)formatToAppendable:(id<TerminalGatewayKotlinAppendable>)appendable value:(id _Nullable)value __attribute__((swift_name("formatTo(appendable:value:)")));
- (id _Nullable)parseInput:(id)input __attribute__((swift_name("parse(input:)")));
- (id _Nullable)parseOrNullInput:(id)input __attribute__((swift_name("parseOrNull(input:)")));
@end

__attribute__((swift_name("KotlinSuspendFunction1")))
@protocol TerminalGatewayKotlinSuspendFunction1 <TerminalGatewayKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kermit_coreSeverity")))
@interface TerminalGatewayKermit_coreSeverity : TerminalGatewayKotlinEnum<TerminalGatewayKermit_coreSeverity *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayKermit_coreSeverity *verbose __attribute__((swift_name("verbose")));
@property (class, readonly) TerminalGatewayKermit_coreSeverity *debug __attribute__((swift_name("debug")));
@property (class, readonly) TerminalGatewayKermit_coreSeverity *info __attribute__((swift_name("info")));
@property (class, readonly) TerminalGatewayKermit_coreSeverity *warn __attribute__((swift_name("warn")));
@property (class, readonly) TerminalGatewayKermit_coreSeverity *error __attribute__((swift_name("error")));
@property (class, readonly) TerminalGatewayKermit_coreSeverity *assert __attribute__((swift_name("assert")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKermit_coreSeverity *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKermit_coreSeverity *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kermit_ioRollingFileLogWriterConfig")))
@interface TerminalGatewayKermit_ioRollingFileLogWriterConfig : TerminalGatewayBase
- (instancetype)initWithLogFileName:(NSString *)logFileName logFilePath:(TerminalGatewayKotlinx_io_corePath *)logFilePath rollOnSize:(int64_t)rollOnSize maxLogFiles:(int32_t)maxLogFiles logTag:(BOOL)logTag prependTimestamp:(BOOL)prependTimestamp __attribute__((swift_name("init(logFileName:logFilePath:rollOnSize:maxLogFiles:logTag:prependTimestamp:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayKermit_ioRollingFileLogWriterConfig *)doCopyLogFileName:(NSString *)logFileName logFilePath:(TerminalGatewayKotlinx_io_corePath *)logFilePath rollOnSize:(int64_t)rollOnSize maxLogFiles:(int32_t)maxLogFiles logTag:(BOOL)logTag prependTimestamp:(BOOL)prependTimestamp __attribute__((swift_name("doCopy(logFileName:logFilePath:rollOnSize:maxLogFiles:logTag:prependTimestamp:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *logFileName __attribute__((swift_name("logFileName")));
@property (readonly) TerminalGatewayKotlinx_io_corePath *logFilePath __attribute__((swift_name("logFilePath")));
@property (readonly) BOOL logTag __attribute__((swift_name("logTag")));
@property (readonly) int32_t maxLogFiles __attribute__((swift_name("maxLogFiles")));
@property (readonly) BOOL prependTimestamp __attribute__((swift_name("prependTimestamp")));
@property (readonly) int64_t rollOnSize __attribute__((swift_name("rollOnSize")));
@end

__attribute__((swift_name("Kermit_coreMessageStringFormatter")))
@protocol TerminalGatewayKermit_coreMessageStringFormatter
@required
- (NSString *)formatMessageSeverity:(TerminalGatewayKermit_coreSeverity * _Nullable)severity tag:(id _Nullable)tag message:(id)message __attribute__((swift_name("formatMessage(severity:tag:message:)")));
- (NSString *)formatSeveritySeverity:(TerminalGatewayKermit_coreSeverity *)severity __attribute__((swift_name("formatSeverity(severity:)")));
- (NSString *)formatTagTag:(id)tag __attribute__((swift_name("formatTag(tag:)")));
@end

__attribute__((swift_name("Kotlinx_io_coreFileSystem")))
@protocol TerminalGatewayKotlinx_io_coreFileSystem
@required
- (void)atomicMoveSource:(TerminalGatewayKotlinx_io_corePath *)source destination:(TerminalGatewayKotlinx_io_corePath *)destination __attribute__((swift_name("atomicMove(source:destination:)")));
- (void)createDirectoriesPath:(TerminalGatewayKotlinx_io_corePath *)path mustCreate:(BOOL)mustCreate __attribute__((swift_name("createDirectories(path:mustCreate:)")));
- (void)deletePath:(TerminalGatewayKotlinx_io_corePath *)path mustExist:(BOOL)mustExist __attribute__((swift_name("delete(path:mustExist:)")));
- (BOOL)existsPath:(TerminalGatewayKotlinx_io_corePath *)path __attribute__((swift_name("exists(path:)")));
- (id)listDirectory:(TerminalGatewayKotlinx_io_corePath *)directory __attribute__((swift_name("list(directory:)")));
- (TerminalGatewayKotlinx_io_coreFileMetadata * _Nullable)metadataOrNullPath:(TerminalGatewayKotlinx_io_corePath *)path __attribute__((swift_name("metadataOrNull(path:)")));
- (TerminalGatewayKotlinx_io_corePath *)resolvePath:(TerminalGatewayKotlinx_io_corePath *)path __attribute__((swift_name("resolve(path:)")));
- (id<TerminalGatewayKotlinx_io_coreRawSink>)sinkPath:(TerminalGatewayKotlinx_io_corePath *)path append:(BOOL)append __attribute__((swift_name("sink(path:append:)")));
- (id<TerminalGatewayKotlinx_io_coreRawSource>)sourcePath:(TerminalGatewayKotlinx_io_corePath *)path __attribute__((swift_name("source(path:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.1")
 *   kotlin.time.ExperimentalTime
*/
__attribute__((swift_name("KotlinClock")))
@protocol TerminalGatewayKotlinClock
@required
- (TerminalGatewayKotlinInstant *)now __attribute__((swift_name("now()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_corePath")))
@interface TerminalGatewayKotlinx_io_corePath : TerminalGatewayBase
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL isAbsolute __attribute__((swift_name("isAbsolute")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) TerminalGatewayKotlinx_io_corePath * _Nullable parent __attribute__((swift_name("parent")));
@end

__attribute__((swift_name("Kermit_coreBaseLogger")))
@interface TerminalGatewayKermit_coreBaseLogger : TerminalGatewayBase
- (instancetype)initWithConfig:(id<TerminalGatewayKermit_coreLoggerConfig>)config __attribute__((swift_name("init(config:)"))) __attribute__((objc_designated_initializer));
- (void)logSeverity:(TerminalGatewayKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *)message __attribute__((swift_name("log(severity:tag:throwable:message:)")));
- (void)logBlockSeverity:(TerminalGatewayKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("logBlock(severity:tag:throwable:message:)")));
- (void)processLogSeverity:(TerminalGatewayKermit_coreSeverity *)severity tag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *)message __attribute__((swift_name("processLog(severity:tag:throwable:message:)")));
@property (readonly) id<TerminalGatewayKermit_coreLoggerConfig> config __attribute__((swift_name("config")));
@property (readonly) id<TerminalGatewayKermit_coreMutableLoggerConfig> mutableConfig __attribute__((swift_name("mutableConfig")));
@end

__attribute__((swift_name("KermitLogger")))
@interface TerminalGatewayKermitLogger : TerminalGatewayKermit_coreBaseLogger
- (instancetype)initWithConfig:(id<TerminalGatewayKermit_coreLoggerConfig>)config tag:(NSString *)tag __attribute__((swift_name("init(config:tag:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithConfig:(id<TerminalGatewayKermit_coreLoggerConfig>)config __attribute__((swift_name("init(config:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKermitLoggerCompanion *companion __attribute__((swift_name("companion")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)aMessageString:(NSString *)messageString throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("a(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)aThrowable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("a(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)dMessageString:(NSString *)messageString throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("d(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)dThrowable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("d(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)eMessageString:(NSString *)messageString throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("e(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)eThrowable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("e(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)iMessageString:(NSString *)messageString throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("i(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)iThrowable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("i(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)vMessageString:(NSString *)messageString throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("v(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)vThrowable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("v(throwable:tag:message:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)wMessageString:(NSString *)messageString throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag __attribute__((swift_name("w(messageString:throwable:tag:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (void)wThrowable:(TerminalGatewayKotlinThrowable * _Nullable)throwable tag:(NSString *)tag message:(NSString *(^)(void))message __attribute__((swift_name("w(throwable:tag:message:)")));
- (TerminalGatewayKermitLogger *)withTagTag:(NSString *)tag __attribute__((swift_name("withTag(tag:)")));
@property (readonly) NSString *tag __attribute__((swift_name("tag")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinNothing")))
@interface TerminalGatewayKotlinNothing : TerminalGatewayBase
@end


/**
 * Channel for asynchronous writing of sequences of bytes.
 * This is a **single-writer channel**.
 *
 * Operations on this channel cannot be invoked concurrently, unless explicitly specified otherwise
 * in the description. Exceptions are [close] and [flush].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteWriteChannel)
 */
__attribute__((swift_name("Ktor_ioByteWriteChannel")))
@protocol TerminalGatewayKtor_ioByteWriteChannel
@required
- (void)cancelCause_:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flush(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
@property (readonly) BOOL autoFlush __attribute__((swift_name("autoFlush")));
@property (readonly) TerminalGatewayKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForWrite __attribute__((swift_name("isClosedForWrite")));
@property (readonly) id<TerminalGatewayKotlinx_io_coreSink> writeBuffer __attribute__((swift_name("writeBuffer")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreDisposableHandle")))
@protocol TerminalGatewayKotlinx_coroutines_coreDisposableHandle
@required
- (void)dispose __attribute__((swift_name("dispose()")));
@end


/**
 * Base type for all async sockets
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ASocket)
 */
__attribute__((swift_name("Ktor_networkASocket")))
@protocol TerminalGatewayKtor_networkASocket <TerminalGatewayKtor_ioCloseable, TerminalGatewayKotlinx_coroutines_coreDisposableHandle>
@required

/**
 * Represents a socket lifetime, completes at socket closure
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ASocket.socketContext)
 */
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreJob> socketContext __attribute__((swift_name("socketContext")));
@end


/**
 * Represent a readable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AReadable)
 */
__attribute__((swift_name("Ktor_networkAReadable")))
@protocol TerminalGatewayKtor_networkAReadable
@required

/**
 * Attach [channel] for reading so incoming bytes appears in the attached channel.
 * Only one channel could be attached
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AReadable.attachForReading)
 *
 * @return a job that does supply data
 */
- (TerminalGatewayKtor_ioWriterJob *)attachForReadingChannel:(TerminalGatewayKtor_ioByteChannel *)channel __attribute__((swift_name("attachForReading(channel:)")));
@end


/**
 * Represents a writable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AWritable)
 */
__attribute__((swift_name("Ktor_networkAWritable")))
@protocol TerminalGatewayKtor_networkAWritable
@required

/**
 * Attach [channel] for writing so bytes written to the attached channel will be transmitted
 * Only one channel could be attached
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AWritable.attachForWriting)
 *
 * @return a job that does transmit data from the channel
 */
- (TerminalGatewayKtor_ioReaderJob *)attachForWritingChannel:(TerminalGatewayKtor_ioByteChannel *)channel __attribute__((swift_name("attachForWriting(channel:)")));
@end


/**
 * Represents both readable and writable socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ReadWriteSocket)
 */
__attribute__((swift_name("Ktor_networkReadWriteSocket")))
@protocol TerminalGatewayKtor_networkReadWriteSocket <TerminalGatewayKtor_networkASocket, TerminalGatewayKtor_networkAReadable, TerminalGatewayKtor_networkAWritable>
@required
@end


/**
 * Represents a bound socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ABoundSocket)
 */
__attribute__((swift_name("Ktor_networkABoundSocket")))
@protocol TerminalGatewayKtor_networkABoundSocket
@required

/**
 * Local socket address. Could throw an exception if no address bound yet.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.ABoundSocket.localAddress)
 */
@property (readonly) TerminalGatewayKtor_networkSocketAddress *localAddress __attribute__((swift_name("localAddress")));
@end


/**
 * Represent a connected socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AConnectedSocket)
 */
__attribute__((swift_name("Ktor_networkAConnectedSocket")))
@protocol TerminalGatewayKtor_networkAConnectedSocket
@required

/**
 * Remote socket address. Could throw an exception if the peer is not yet connected or already disconnected.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.AConnectedSocket.remoteAddress)
 */
@property (readonly) TerminalGatewayKtor_networkSocketAddress *remoteAddress __attribute__((swift_name("remoteAddress")));
@end


/**
 * Represents a connected socket
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.network.sockets.Socket)
 */
__attribute__((swift_name("Ktor_networkSocket")))
@protocol TerminalGatewayKtor_networkSocket <TerminalGatewayKtor_networkReadWriteSocket, TerminalGatewayKtor_networkABoundSocket, TerminalGatewayKtor_networkAConnectedSocket, TerminalGatewayKotlinx_coroutines_coreCoroutineScope>
@required
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalDateSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDate")))
@interface TerminalGatewayKotlinx_datetimeLocalDate : TerminalGatewayBase <TerminalGatewayKotlinComparable>
- (instancetype)initWithYear:(int32_t)year month:(int32_t)month day:(int32_t)day __attribute__((swift_name("init(year:month:day:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithYear:(int32_t)year month:(TerminalGatewayKotlinx_datetimeMonth *)month day_:(int32_t)day __attribute__((swift_name("init(year:month:day_:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeLocalDateCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TerminalGatewayKotlinx_datetimeLocalDate *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TerminalGatewayKotlinx_datetimeLocalDateRange *)rangeToThat:(TerminalGatewayKotlinx_datetimeLocalDate *)that __attribute__((swift_name("rangeTo(that:)")));
- (TerminalGatewayKotlinx_datetimeLocalDateRange *)rangeUntilThat:(TerminalGatewayKotlinx_datetimeLocalDate *)that __attribute__((swift_name("rangeUntil(that:)")));
- (int64_t)toEpochDays __attribute__((swift_name("toEpochDays()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t day __attribute__((swift_name("day")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth"))) __attribute__((deprecated("Use the 'day' property instead")));
@property (readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) TerminalGatewayKotlinx_datetimeMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t monthNumber __attribute__((swift_name("monthNumber"))) __attribute__((deprecated("Use the 'month' property instead")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/LocalTimeSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalTime")))
@interface TerminalGatewayKotlinx_datetimeLocalTime : TerminalGatewayBase <TerminalGatewayKotlinComparable>
- (instancetype)initWithHour:(int32_t)hour minute:(int32_t)minute second:(int32_t)second nanosecond:(int32_t)nanosecond __attribute__((swift_name("init(hour:minute:second:nanosecond:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeLocalTimeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TerminalGatewayKotlinx_datetimeLocalTime *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (int32_t)toMillisecondOfDay __attribute__((swift_name("toMillisecondOfDay()")));
- (int64_t)toNanosecondOfDay __attribute__((swift_name("toNanosecondOfDay()")));
- (int32_t)toSecondOfDay __attribute__((swift_name("toSecondOfDay()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t hour __attribute__((swift_name("hour")));
@property (readonly) int32_t minute __attribute__((swift_name("minute")));
@property (readonly) int32_t nanosecond __attribute__((swift_name("nanosecond")));
@property (readonly) int32_t second __attribute__((swift_name("second")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonth")))
@interface TerminalGatewayKotlinx_datetimeMonth : TerminalGatewayKotlinEnum<TerminalGatewayKotlinx_datetimeMonth *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *january __attribute__((swift_name("january")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *february __attribute__((swift_name("february")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *march __attribute__((swift_name("march")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *april __attribute__((swift_name("april")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *may __attribute__((swift_name("may")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *june __attribute__((swift_name("june")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *july __attribute__((swift_name("july")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *august __attribute__((swift_name("august")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *september __attribute__((swift_name("september")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *october __attribute__((swift_name("october")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *november __attribute__((swift_name("november")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeMonth *december __attribute__((swift_name("december")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKotlinx_datetimeMonth *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKotlinx_datetimeMonth *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateTime.Companion")))
@interface TerminalGatewayKotlinx_datetimeLocalDateTimeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeLocalDateTimeCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)FormatBuilder:(void (^)(id<TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithDateTime>))builder __attribute__((swift_name("Format(builder:)")));
- (TerminalGatewayKotlinx_datetimeLocalDateTime *)parseInput:(id)input format:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeek")))
@interface TerminalGatewayKotlinx_datetimeDayOfWeek : TerminalGatewayKotlinEnum<TerminalGatewayKotlinx_datetimeDayOfWeek *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *monday __attribute__((swift_name("monday")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *tuesday __attribute__((swift_name("tuesday")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *wednesday __attribute__((swift_name("wednesday")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *thursday __attribute__((swift_name("thursday")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *friday __attribute__((swift_name("friday")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *saturday __attribute__((swift_name("saturday")));
@property (class, readonly) TerminalGatewayKotlinx_datetimeDayOfWeek *sunday __attribute__((swift_name("sunday")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKotlinx_datetimeDayOfWeek *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKotlinx_datetimeDayOfWeek *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeTimeZone.Companion")))
@interface TerminalGatewayKotlinx_datetimeTimeZoneCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeTimeZoneCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayKotlinx_datetimeTimeZone *)currentSystemDefault __attribute__((swift_name("currentSystemDefault()")));
- (TerminalGatewayKotlinx_datetimeTimeZone *)ofZoneId:(NSString *)zoneId __attribute__((swift_name("of(zoneId:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) TerminalGatewayKotlinx_datetimeFixedOffsetTimeZone *UTC __attribute__((swift_name("UTC")));
@property (readonly) NSSet<NSString *> *availableZoneIds __attribute__((swift_name("availableZoneIds")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.1")
 *   kotlin.time.ExperimentalTime
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinInstant")))
@interface TerminalGatewayKotlinInstant : TerminalGatewayBase <TerminalGatewayKotlinComparable>
@property (class, readonly, getter=companion) TerminalGatewayKotlinInstantCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TerminalGatewayKotlinInstant *)other __attribute__((swift_name("compareTo(other:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TerminalGatewayKotlinInstant *)minusDuration:(int64_t)duration __attribute__((swift_name("minus(duration:)")));
- (int64_t)minusOther:(TerminalGatewayKotlinInstant *)other __attribute__((swift_name("minus(other:)")));
- (TerminalGatewayKotlinInstant *)plusDuration:(int64_t)duration __attribute__((swift_name("plus(duration:)")));
- (int64_t)toEpochMilliseconds __attribute__((swift_name("toEpochMilliseconds()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int64_t epochSeconds __attribute__((swift_name("epochSeconds")));
@property (readonly) int32_t nanosecondsOfSecond __attribute__((swift_name("nanosecondsOfSecond")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeOverloadMarker")))
@interface TerminalGatewayKotlinx_datetimeOverloadMarker : TerminalGatewayBase
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialFormat")))
@protocol TerminalGatewayKotlinx_serialization_coreSerialFormat
@required
@property (readonly) TerminalGatewayKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreStringFormat")))
@protocol TerminalGatewayKotlinx_serialization_coreStringFormat <TerminalGatewayKotlinx_serialization_coreSerialFormat>
@required
- (id _Nullable)decodeFromStringDeserializer:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy>)deserializer string:(NSString *)string __attribute__((swift_name("decodeFromString(deserializer:string:)")));
- (NSString *)encodeToStringSerializer:(id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToString(serializer:value:)")));
@end

__attribute__((swift_name("Kotlinx_serialization_jsonJson")))
@interface TerminalGatewayKotlinx_serialization_jsonJson : TerminalGatewayBase <TerminalGatewayKotlinx_serialization_coreStringFormat>
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_serialization_jsonJsonDefault *companion __attribute__((swift_name("companion")));
- (id _Nullable)decodeFromJsonElementDeserializer:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy>)deserializer element:(TerminalGatewayKotlinx_serialization_jsonJsonElement *)element __attribute__((swift_name("decodeFromJsonElement(deserializer:element:)")));
- (id _Nullable)decodeFromStringString:(NSString *)string __attribute__((swift_name("decodeFromString(string:)")));
- (id _Nullable)decodeFromStringDeserializer:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy>)deserializer string:(NSString *)string __attribute__((swift_name("decodeFromString(deserializer:string:)")));
- (TerminalGatewayKotlinx_serialization_jsonJsonElement *)encodeToJsonElementSerializer:(id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToJsonElement(serializer:value:)")));
- (NSString *)encodeToStringValue:(id _Nullable)value __attribute__((swift_name("encodeToString(value:)")));
- (NSString *)encodeToStringSerializer:(id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeToString(serializer:value:)")));
- (TerminalGatewayKotlinx_serialization_jsonJsonElement *)parseToJsonElementString:(NSString *)string __attribute__((swift_name("parseToJsonElement(string:)")));
@property (readonly) TerminalGatewayKotlinx_serialization_jsonJsonConfiguration *configuration __attribute__((swift_name("configuration")));
@property (readonly) TerminalGatewayKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreChildHandle")))
@protocol TerminalGatewayKotlinx_coroutines_coreChildHandle <TerminalGatewayKotlinx_coroutines_coreDisposableHandle>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (BOOL)childCancelledCause:(TerminalGatewayKotlinThrowable *)cause __attribute__((swift_name("childCancelled(cause:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreJob> _Nullable parent __attribute__((swift_name("parent")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreChildJob")))
@protocol TerminalGatewayKotlinx_coroutines_coreChildJob <TerminalGatewayKotlinx_coroutines_coreJob>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (void)parentCancelledParentJob:(id<TerminalGatewayKotlinx_coroutines_coreParentJob>)parentJob __attribute__((swift_name("parentCancelled(parentJob:)")));
@end

__attribute__((swift_name("KotlinSequence")))
@protocol TerminalGatewayKotlinSequence
@required
- (id<TerminalGatewayKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause")))
@protocol TerminalGatewayKotlinx_coroutines_coreSelectClause
@required
@property (readonly) id clauseObject __attribute__((swift_name("clauseObject")));
@property (readonly) TerminalGatewayKotlinUnit *(^(^ _Nullable onCancellationConstructor)(id<TerminalGatewayKotlinx_coroutines_coreSelectInstance>, id _Nullable, id _Nullable))(TerminalGatewayKotlinThrowable *, id _Nullable, id<TerminalGatewayKotlinCoroutineContext>) __attribute__((swift_name("onCancellationConstructor")));
@property (readonly) id _Nullable (^processResFunc)(id, id _Nullable, id _Nullable) __attribute__((swift_name("processResFunc")));
@property (readonly) void (^regFunc)(id, id<TerminalGatewayKotlinx_coroutines_coreSelectInstance>, id _Nullable) __attribute__((swift_name("regFunc")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause0")))
@protocol TerminalGatewayKotlinx_coroutines_coreSelectClause0 <TerminalGatewayKotlinx_coroutines_coreSelectClause>
@required
@end

__attribute__((swift_name("KotlinCoroutineContextKey")))
@protocol TerminalGatewayKotlinCoroutineContextKey
@required
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonElement.Companion")))
@interface TerminalGatewayKotlinx_serialization_jsonJsonElementCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_serialization_jsonJsonElementCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonPrimitive.Companion")))
@interface TerminalGatewayKotlinx_serialization_jsonJsonPrimitiveCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_serialization_jsonJsonPrimitiveCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("KotlinIterator")))
@protocol TerminalGatewayKotlinIterator
@required
- (BOOL)hasNext __attribute__((swift_name("hasNext()")));
- (id _Nullable)next __attribute__((swift_name("next()")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreCompositeEncoder")))
@protocol TerminalGatewayKotlinx_serialization_coreCompositeEncoder
@required
- (void)encodeBooleanElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(BOOL)value __attribute__((swift_name("encodeBooleanElement(descriptor:index:value:)")));
- (void)encodeByteElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int8_t)value __attribute__((swift_name("encodeByteElement(descriptor:index:value:)")));
- (void)encodeCharElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(unichar)value __attribute__((swift_name("encodeCharElement(descriptor:index:value:)")));
- (void)encodeDoubleElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(double)value __attribute__((swift_name("encodeDoubleElement(descriptor:index:value:)")));
- (void)encodeFloatElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(float)value __attribute__((swift_name("encodeFloatElement(descriptor:index:value:)")));
- (id<TerminalGatewayKotlinx_serialization_coreEncoder>)encodeInlineElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("encodeInlineElement(descriptor:index:)")));
- (void)encodeIntElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int32_t)value __attribute__((swift_name("encodeIntElement(descriptor:index:value:)")));
- (void)encodeLongElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int64_t)value __attribute__((swift_name("encodeLongElement(descriptor:index:value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)encodeNullableSerializableElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index serializer:(id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeNullableSerializableElement(descriptor:index:serializer:value:)")));
- (void)encodeSerializableElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index serializer:(id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy>)serializer value:(id _Nullable)value __attribute__((swift_name("encodeSerializableElement(descriptor:index:serializer:value:)")));
- (void)encodeShortElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(int16_t)value __attribute__((swift_name("encodeShortElement(descriptor:index:value:)")));
- (void)encodeStringElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index value:(NSString *)value __attribute__((swift_name("encodeStringElement(descriptor:index:value:)")));
- (void)endStructureDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("endStructure(descriptor:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)shouldEncodeElementDefaultDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("shouldEncodeElementDefault(descriptor:index:)")));
@property (readonly) TerminalGatewayKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerializersModule")))
@interface TerminalGatewayKotlinx_serialization_coreSerializersModule : TerminalGatewayBase

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (void)dumpToCollector:(id<TerminalGatewayKotlinx_serialization_coreSerializersModuleCollector>)collector __attribute__((swift_name("dumpTo(collector:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer> _Nullable)getContextualKClass:(id<TerminalGatewayKotlinKClass>)kClass typeArgumentsSerializers:(NSArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *)typeArgumentsSerializers __attribute__((swift_name("getContextual(kClass:typeArgumentsSerializers:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy> _Nullable)getPolymorphicBaseClass:(id<TerminalGatewayKotlinKClass>)baseClass value:(id)value __attribute__((swift_name("getPolymorphic(baseClass:value:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy> _Nullable)getPolymorphicBaseClass:(id<TerminalGatewayKotlinKClass>)baseClass serializedClassName:(NSString * _Nullable)serializedClassName __attribute__((swift_name("getPolymorphic(baseClass:serializedClassName:)")));
@end

__attribute__((swift_name("KotlinAnnotation")))
@protocol TerminalGatewayKotlinAnnotation
@required
@end

__attribute__((swift_name("Kotlinx_serialization_coreSerialKind")))
@interface TerminalGatewayKotlinx_serialization_coreSerialKind : TerminalGatewayBase
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end

__attribute__((swift_name("Kotlinx_serialization_coreCompositeDecoder")))
@protocol TerminalGatewayKotlinx_serialization_coreCompositeDecoder
@required
- (BOOL)decodeBooleanElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeBooleanElement(descriptor:index:)")));
- (int8_t)decodeByteElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeByteElement(descriptor:index:)")));
- (unichar)decodeCharElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeCharElement(descriptor:index:)")));
- (int32_t)decodeCollectionSizeDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeCollectionSize(descriptor:)")));
- (double)decodeDoubleElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeDoubleElement(descriptor:index:)")));
- (int32_t)decodeElementIndexDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("decodeElementIndex(descriptor:)")));
- (float)decodeFloatElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeFloatElement(descriptor:index:)")));
- (id<TerminalGatewayKotlinx_serialization_coreDecoder>)decodeInlineElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeInlineElement(descriptor:index:)")));
- (int32_t)decodeIntElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeIntElement(descriptor:index:)")));
- (int64_t)decodeLongElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeLongElement(descriptor:index:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (id _Nullable)decodeNullableSerializableElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index deserializer:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy>)deserializer previousValue:(id _Nullable)previousValue __attribute__((swift_name("decodeNullableSerializableElement(descriptor:index:deserializer:previousValue:)")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
- (BOOL)decodeSequentially __attribute__((swift_name("decodeSequentially()")));
- (id _Nullable)decodeSerializableElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index deserializer:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy>)deserializer previousValue:(id _Nullable)previousValue __attribute__((swift_name("decodeSerializableElement(descriptor:index:deserializer:previousValue:)")));
- (int16_t)decodeShortElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeShortElement(descriptor:index:)")));
- (NSString *)decodeStringElementDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor index:(int32_t)index __attribute__((swift_name("decodeStringElement(descriptor:index:)")));
- (void)endStructureDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor __attribute__((swift_name("endStructure(descriptor:)")));
@property (readonly) TerminalGatewayKotlinx_serialization_coreSerializersModule *serializersModule __attribute__((swift_name("serializersModule")));
@end


/**
 * Serves as the base interface for an [HttpClient]'s engine.
 *
 * An `HttpClientEngine` represents the underlying network implementation that
 * performs HTTP requests and handles responses.
 * Developers can implement this interface to create custom engines for use with [HttpClient].
 *
 * This interface provides a set of properties and methods that define the
 * contract for configuring, executing, and managing HTTP requests within the engine.
 *
 * For a base implementation that handles common engine functionality, see [HttpClientEngineBase].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngine")))
@protocol TerminalGatewayKtor_client_coreHttpClientEngine <TerminalGatewayKotlinx_coroutines_coreCoroutineScope, TerminalGatewayKtor_ioCloseable>
@required

/**
 * Executes an HTTP request and produces an HTTP response.
 *
 * This function takes [HttpRequestData], which contains all details of the HTTP request,
 * and returns [HttpResponseData] with the server's response, including headers, status code, and body.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.execute)
 *
 * @param data The [HttpRequestData] representing the request to be executed.
 * @return An [HttpResponseData] object containing the server's response.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeData:(TerminalGatewayKtor_client_coreHttpRequestData *)data completionHandler:(void (^)(TerminalGatewayKtor_client_coreHttpResponseData * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(data:completionHandler:)")));

/**
 * Installs the engine into an [HttpClient].
 *
 * This method is called when the engine is being set up within an `HttpClient`.
 * Use it to register interceptors, validate configuration, or prepare the engine
 * for use with the client.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.install)
 *
 * @param client The [HttpClient] instance to which the engine is being installed.
 */
- (void)installClient:(TerminalGatewayKtor_client_coreHttpClient *)client __attribute__((swift_name("install(client:)")));

/**
 * Provides access to the engine's configuration via [HttpClientEngineConfig].
 *
 * The [config] object stores user-defined parameters or settings that control
 * how the engine operates. When creating a custom engine, this property
 * should return the specific configuration implementation.
 *
 * Example:
 * ```kotlin
 * override val config: HttpClientEngineConfig = CustomEngineConfig()
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.config)
 */
@property (readonly) TerminalGatewayKtor_client_coreHttpClientEngineConfig *config __attribute__((swift_name("config")));

/**
 * Specifies the [CoroutineDispatcher] for I/O operations in the engine.
 *
 * This dispatcher is used for all network-related operations, such as
 * sending requests and receiving responses.
 * By default, it should be optimized for I/O tasks.
 *
 * Example:
 * ```kotlin
 * override val dispatcher: CoroutineDispatcher = Dispatchers.IO
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.dispatcher)
 */
@property (readonly) TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcher *dispatcher __attribute__((swift_name("dispatcher")));

/**
 * Specifies the set of capabilities supported by this HTTP client engine.
 *
 * Capabilities provide a mechanism for plugins and other components to
 * determine whether the engine supports specific features such as timeouts,
 * WebSocket communication, HTTP/2, HTTP/3, or other advanced networking
 * capabilities. This allows seamless integration of features based on the
 * engine's functionality.
 *
 * Each capability is represented as an instance of [HttpClientEngineCapability],
 * which can carry additional metadata or configurations for the capability.
 *
 * Example:
 * ```kotlin
 * override val supportedCapabilities: Set<HttpClientEngineCapability<*>> = setOf(
 *     WebSocketCapability,
 *     Http2Capability,
 *     TimeoutCapability
 * )
 * ```
 *
 * **Usage in Plugins**:
 * Plugins can check if the engine supports a specific capability before
 * applying behavior:
 * ```kotlin
 * if (engine.supportedCapabilities.contains(WebSocketCapability)) {
 *     // Configure WebSocket-specific settings
 * }
 * ```
 *
 * When implementing a custom engine, ensure this property accurately reflects
 * the engine's abilities to avoid unexpected plugin behavior or runtime errors.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngine.supportedCapabilities)
 */
@property (readonly) NSSet<id<TerminalGatewayKtor_client_coreHttpClientEngineCapability>> *supportedCapabilities __attribute__((swift_name("supportedCapabilities")));
@end


/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngineConfig")))
@interface TerminalGatewayKtor_client_coreHttpClientEngineConfig : TerminalGatewayBase

/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Base configuration for [HttpClientEngine].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Allow specifying the coroutine dispatcher to use for IO operations.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.dispatcher)
 */
@property TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcher * _Nullable dispatcher __attribute__((swift_name("dispatcher")));

/**
 * Enables HTTP pipelining advice.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.pipelining)
 */
@property BOOL pipelining __attribute__((swift_name("pipelining")));

/**
 * Specifies a proxy address to use.
 * Uses a system proxy by default.
 *
 * You can learn more from [Proxy](https://ktor.io/docs/proxy.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.proxy)
 */
@property TerminalGatewayKtor_client_coreProxyConfig * _Nullable proxy __attribute__((swift_name("proxy")));

/**
 * Specifies network threads count advice.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineConfig.threadsCount)
 */
@property int32_t threadsCount __attribute__((swift_name("threadsCount"))) __attribute__((unavailable("The [threadsCount] property is deprecated. Consider setting [dispatcher] instead.")));
@end


/**
 * Represents a capability that an [HttpClientEngine] can support, with [T] representing the type
 * of configuration or metadata associated with the capability.
 *
 * Capabilities are used to declare optional features or behaviors that an engine may support,
 * such as WebSocket communication, HTTP/2, or custom timeouts. They enable plugins and request
 * builders to configure engine-specific functionality by associating a capability with a
 * specific configuration.
 *
 * Capabilities can be set on a per-request basis using the `HttpRequestBuilder.setCapability` method,
 * allowing users to configure engine-specific behavior for individual requests.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.HttpClientEngineCapability)
 *
 * @param T The type of the configuration or metadata associated with this capability.
 *
 * Example:
 * Suppose you have a custom capability for WebSocket support that requires a specific configuration:
 * ```kotlin
 * object WebSocketCapability : HttpClientEngineCapability<WebSocketConfig>
 *
 * data class WebSocketConfig(val maxFrameSize: Int, val pingIntervalMillis: Long)
 * ```
 *
 * Setting a capability in a request:
 * ```kotlin
 * client.request {
 *     setCapability(WebSocketCapability, WebSocketConfig(
 *         maxFrameSize = 65536,
 *         pingIntervalMillis = 30000
 *     ))
 * }
 * ```
 *
 * Engine Example:
 * A custom engine implementation can declare support for specific capabilities in its `supportedCapabilities` property:
 * ```kotlin
 * override val supportedCapabilities: Set<HttpClientEngineCapability<*>> = setOf(WebSocketCapability)
 * ```
 *
 * Plugin Integration Example:
 * Plugins use capabilities to interact with engine-specific features. For example:
 * ```kotlin
 * if (engine.supportedCapabilities.contains(WebSocketCapability)) {
 *     // Configure WebSocket behavior if supported by the engine
 * }
 * ```
 *
 * When creating a custom capability:
 * - Define a singleton object implementing `HttpClientEngineCapability`.
 * - Use the type parameter [T] to provide the associated configuration type or metadata.
 * - Ensure that engines supporting the capability handle the associated configuration properly.
 */
__attribute__((swift_name("Ktor_client_coreHttpClientEngineCapability")))
@protocol TerminalGatewayKtor_client_coreHttpClientEngineCapability
@required
@end


/**
 * Map of attributes accessible by [AttributeKey] in a typed manner
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes)
 */
__attribute__((swift_name("Ktor_utilsAttributes")))
@protocol TerminalGatewayKtor_utilsAttributes
@required

/**
 * Gets a value of the attribute for the specified [key], or calls supplied [block] to compute its value
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.computeIfAbsent)
 */
- (id)computeIfAbsentKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key block:(id (^)(void))block __attribute__((swift_name("computeIfAbsent(key:block:)")));

/**
 * Checks if an attribute with the specified [key] exists
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.contains)
 */
- (BOOL)containsKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("contains(key:)")));

/**
 * Gets a value of the attribute for the specified [key], or throws an exception if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.get)
 */
- (id)getKey_:(TerminalGatewayKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("get(key_:)")));

/**
 * Gets a value of the attribute for the specified [key], or return `null` if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.getOrNull)
 */
- (id _Nullable)getOrNullKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("getOrNull(key:)")));

/**
 * Creates or changes an attribute with the specified [key] using [value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.put)
 */
- (void)putKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key value:(id)value __attribute__((swift_name("put(key:value:)")));

/**
 * Removes an attribute with the specified [key]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.remove)
 */
- (void)removeKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("remove(key:)")));

/**
 * Creates or changes an attribute with the specified [key] using [value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.set)
 */
- (void)setKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key value:(id)value __attribute__((swift_name("set(key:value:)")));

/**
 * Removes an attribute with the specified [key] and returns its current value, throws an exception if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.take)
 */
- (id)takeKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("take(key:)")));

/**
 * Removes an attribute with the specified [key] and returns its current value, returns `null` if an attribute doesn't exist
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.takeOrNull)
 */
- (id _Nullable)takeOrNullKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("takeOrNull(key:)")));

/**
 * Returns [List] of all [AttributeKey] instances in this map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.Attributes.allKeys)
 */
@property (readonly) NSArray<TerminalGatewayKtor_utilsAttributeKey<id> *> *allKeys __attribute__((swift_name("allKeys")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_eventsEvents")))
@interface TerminalGatewayKtor_eventsEvents : TerminalGatewayBase
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Raises the event specified by [definition] with the [value] and calls all handlers.
 *
 * Handlers are called in order of subscriptions.
 * If some handler throws an exception, all remaining handlers will still run. The exception will eventually be re-thrown.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.raise)
 */
- (void)raiseDefinition:(TerminalGatewayKtor_eventsEventDefinition<id> *)definition value:(id _Nullable)value __attribute__((swift_name("raise(definition:value:)")));

/**
 * Subscribe [handler] to an event specified by [definition]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.subscribe)
 */
- (id<TerminalGatewayKotlinx_coroutines_coreDisposableHandle>)subscribeDefinition:(TerminalGatewayKtor_eventsEventDefinition<id> *)definition handler:(void (^)(id _Nullable))handler __attribute__((swift_name("subscribe(definition:handler:)")));

/**
 * Unsubscribe [handler] from an event specified by [definition]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.Events.unsubscribe)
 */
- (void)unsubscribeDefinition:(TerminalGatewayKtor_eventsEventDefinition<id> *)definition handler:(void (^)(id _Nullable))handler __attribute__((swift_name("unsubscribe(definition:handler:)")));
@end


/**
 * Represents an execution pipeline for asynchronous extensible computations
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline)
 */
__attribute__((swift_name("Ktor_utilsPipeline")))
@interface TerminalGatewayKtor_utilsPipeline<TSubject, TContext> : TerminalGatewayBase
- (instancetype)initWithPhases:(TerminalGatewayKotlinArray<TerminalGatewayKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhase:(TerminalGatewayKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TerminalGatewayKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer));

/**
 * Adds [phase] to the end of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.addPhase)
 */
- (void)addPhasePhase:(TerminalGatewayKtor_utilsPipelinePhase *)phase __attribute__((swift_name("addPhase(phase:)")));

/**
 * Invoked after an interceptor has been installed
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.afterIntercepted)
 */
- (void)afterIntercepted __attribute__((swift_name("afterIntercepted()")));

/**
 * Executes this pipeline in the given [context] and with the given [subject]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.execute)
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)executeContext:(TContext)context subject:(TSubject)subject completionHandler:(void (^)(TSubject _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("execute(context:subject:completionHandler:)")));

/**
 * Inserts [phase] after the [reference] phase. If there are other phases inserted after [reference], then [phase]
 * will be inserted after them.
 * Example:
 * ```
 * val pipeline = Pipeline<String, String>(a)
 * pipeline.insertPhaseAfter(a, b)
 * pipeline.insertPhaseAfter(a, c)
 * assertEquals(listOf(a, b, c), pipeline.items)
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.insertPhaseAfter)
 */
- (void)insertPhaseAfterReference:(TerminalGatewayKtor_utilsPipelinePhase *)reference phase:(TerminalGatewayKtor_utilsPipelinePhase *)phase __attribute__((swift_name("insertPhaseAfter(reference:phase:)")));

/**
 * Inserts [phase] before the [reference] phase.
 * Example:
 * ```
 * val pipeline = Pipeline<String, String>(c)
 * pipeline.insertPhaseBefore(c, a)
 * pipeline.insertPhaseBefore(c, b)
 * assertEquals(listOf(a, b, c), pipeline.items)
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.insertPhaseBefore)
 */
- (void)insertPhaseBeforeReference:(TerminalGatewayKtor_utilsPipelinePhase *)reference phase:(TerminalGatewayKtor_utilsPipelinePhase *)phase __attribute__((swift_name("insertPhaseBefore(reference:phase:)")));

/**
 * Adds [block] to the [phase] of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.intercept)
 */
- (void)interceptPhase:(TerminalGatewayKtor_utilsPipelinePhase *)phase block:(id<TerminalGatewayKotlinSuspendFunction2>)block __attribute__((swift_name("intercept(phase:block:)")));
- (NSArray<id<TerminalGatewayKotlinSuspendFunction2>> *)interceptorsForPhasePhase:(TerminalGatewayKtor_utilsPipelinePhase *)phase __attribute__((swift_name("interceptorsForPhase(phase:)")));

/**
 * Merges another pipeline into this pipeline, maintaining relative phases order
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.merge)
 */
- (void)mergeFrom:(TerminalGatewayKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("merge(from:)")));
- (void)mergePhasesFrom:(TerminalGatewayKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("mergePhases(from:)")));

/**
 * Reset current pipeline from other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.resetFrom)
 */
- (void)resetFromFrom:(TerminalGatewayKtor_utilsPipeline<TSubject, TContext> *)from __attribute__((swift_name("resetFrom(from:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * Provides common place to store pipeline attributes
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.attributes)
 */
@property (readonly) id<TerminalGatewayKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * Indicated if debug mode is enabled. In debug mode users will get more details in the stacktrace.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.developmentMode)
 */
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));

/**
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.isEmpty)
 *
 * @return `true` if there are no interceptors installed regardless number of phases
 */
@property (readonly) BOOL isEmpty __attribute__((swift_name("isEmpty")));

/**
 * Phases of this pipeline
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.Pipeline.items)
 */
@property (readonly) NSArray<TerminalGatewayKtor_utilsPipelinePhase *> *items __attribute__((swift_name("items")));
@end


/**
 * [HttpClient] Pipeline used for receiving [HttpResponse] without any processing.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpReceivePipeline")))
@interface TerminalGatewayKtor_client_coreHttpReceivePipeline : TerminalGatewayKtor_utilsPipeline<TerminalGatewayKtor_client_coreHttpResponse *, TerminalGatewayKotlinUnit *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(TerminalGatewayKotlinArray<TerminalGatewayKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(TerminalGatewayKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TerminalGatewayKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKtor_client_coreHttpReceivePipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * An [HttpClient]'s pipeline used for executing [HttpRequest].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestPipeline")))
@interface TerminalGatewayKtor_client_coreHttpRequestPipeline : TerminalGatewayKtor_utilsPipeline<id, TerminalGatewayKtor_client_coreHttpRequestBuilder *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(TerminalGatewayKotlinArray<TerminalGatewayKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(TerminalGatewayKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TerminalGatewayKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKtor_client_coreHttpRequestPipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * [HttpClient] Pipeline used for executing [HttpResponse].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponsePipeline")))
@interface TerminalGatewayKtor_client_coreHttpResponsePipeline : TerminalGatewayKtor_utilsPipeline<TerminalGatewayKtor_client_coreHttpResponseContainer *, TerminalGatewayKtor_client_coreHttpClientCall *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(TerminalGatewayKotlinArray<TerminalGatewayKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(TerminalGatewayKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TerminalGatewayKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKtor_client_coreHttpResponsePipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end


/**
 * An [HttpClient]'s pipeline used for sending [HttpRequest] to a remote server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpSendPipeline")))
@interface TerminalGatewayKtor_client_coreHttpSendPipeline : TerminalGatewayKtor_utilsPipeline<id, TerminalGatewayKtor_client_coreHttpRequestBuilder *>
- (instancetype)initWithDevelopmentMode:(BOOL)developmentMode __attribute__((swift_name("init(developmentMode:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithPhases:(TerminalGatewayKotlinArray<TerminalGatewayKtor_utilsPipelinePhase *> *)phases __attribute__((swift_name("init(phases:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (instancetype)initWithPhase:(TerminalGatewayKtor_utilsPipelinePhase *)phase interceptors:(NSArray<id<TerminalGatewayKotlinSuspendFunction2>> *)interceptors __attribute__((swift_name("init(phase:interceptors:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKtor_client_coreHttpSendPipelinePhases *companion __attribute__((swift_name("companion")));
@property (readonly) BOOL developmentMode __attribute__((swift_name("developmentMode")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreSelectClause2")))
@protocol TerminalGatewayKotlinx_coroutines_coreSelectClause2 <TerminalGatewayKotlinx_coroutines_coreSelectClause>
@required
@end


/**
 * An interface for listening to changes in the result set of a query.
 */
__attribute__((swift_name("RuntimeQueryListener")))
@protocol TerminalGatewayRuntimeQueryListener
@required

/**
 * Called whenever the query this listener was attached to is dirtied.
 *
 * Calls are made synchronously on the thread where the updated occurred, after the update applied successfully.
 */
- (void)queryResultsChanged __attribute__((swift_name("queryResultsChanged()")));
@end


/**
 * The returned [value] is the result of a database query or other database operation.
 *
 * This interface enables drivers to be based on non-blocking APIs where the result can be obtained using the suspending
 * [await] method. See [AsyncValue].
 */
__attribute__((swift_name("RuntimeQueryResult")))
@protocol TerminalGatewayRuntimeQueryResult
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitWithCompletionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("await(completionHandler:)")));
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Represents a SQL statement that has been prepared by a driver to be executed.
 *
 * This type is not thread safe unless otherwise specified by the driver emitting these.
 *
 * Prepared statements should not be cached by client code. Drivers can implement caching by using
 * the integer identifier passed to [SqlDriver.execute] or [SqlDriver.executeQuery].
 * Client code can pass the same identifier to that method to request that the prepared statement
 * is cached.
 */
__attribute__((swift_name("RuntimeSqlPreparedStatement")))
@protocol TerminalGatewayRuntimeSqlPreparedStatement
@required

/**
 * Bind [boolean] to the underlying statement at [index].
 */
- (void)bindBooleanIndex:(int32_t)index boolean:(TerminalGatewayBoolean * _Nullable)boolean __attribute__((swift_name("bindBoolean(index:boolean:)")));

/**
 * Bind [bytes] to the underlying statement at [index].
 */
- (void)bindBytesIndex:(int32_t)index bytes:(TerminalGatewayKotlinByteArray * _Nullable)bytes __attribute__((swift_name("bindBytes(index:bytes:)")));

/**
 * Bind [double] to the underlying statement at [index].
 */
- (void)bindDoubleIndex:(int32_t)index double:(TerminalGatewayDouble * _Nullable)double_ __attribute__((swift_name("bindDouble(index:double:)")));

/**
 * Bind [long] to the underlying statement at [index].
 */
- (void)bindLongIndex:(int32_t)index long:(TerminalGatewayLong * _Nullable)long_ __attribute__((swift_name("bindLong(index:long:)")));

/**
 * Bind [string] to the underlying statement at [index].
 */
- (void)bindStringIndex:(int32_t)index string:(NSString * _Nullable)string __attribute__((swift_name("bindString(index:string:)")));
@end


/**
 * Represents a SQL result set which can be iterated through with [next]. Initially the cursor will
 * not point to any row, and calling [next] once will iterate to the first row.
 */
__attribute__((swift_name("RuntimeSqlCursor")))
@protocol TerminalGatewayRuntimeSqlCursor
@required

/**
 * @return The boolean or null value of column [index] for the current row of the result set.
 */
- (TerminalGatewayBoolean * _Nullable)getBooleanIndex:(int32_t)index __attribute__((swift_name("getBoolean(index:)")));

/**
 * @return The bytes or null value of column [index] for the current row of the result set.
 */
- (TerminalGatewayKotlinByteArray * _Nullable)getBytesIndex:(int32_t)index __attribute__((swift_name("getBytes(index:)")));

/**
 * @return The double or null value of column [index] for the current row of the result set.
 */
- (TerminalGatewayDouble * _Nullable)getDoubleIndex:(int32_t)index __attribute__((swift_name("getDouble(index:)")));

/**
 * @return The int or null value of column [index] for the current row of the result set.
 */
- (TerminalGatewayLong * _Nullable)getLongIndex:(int32_t)index __attribute__((swift_name("getLong(index:)")));

/**
 * @return The string or null value of column [index] for the current row of the result set.
 */
- (NSString * _Nullable)getStringIndex:(int32_t)index __attribute__((swift_name("getString(index:)")));

/**
 * Move to the next row in the result set.
 *
 * @return true if the cursor successfully moved to a new row, false if there was no row to
 *   iterate to.
 */
- (id<TerminalGatewayRuntimeQueryResult>)next __attribute__((swift_name("next()")));
@end


/**
 * Represents a block of code [block] that should be executed during a migration after the migration
 * has finished migrating to [afterVersion].
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("RuntimeAfterVersion")))
@interface TerminalGatewayRuntimeAfterVersion : TerminalGatewayBase
- (instancetype)initWithAfterVersion:(int64_t)afterVersion block:(void (^)(id<TerminalGatewayRuntimeSqlDriver>))block __attribute__((swift_name("init(afterVersion:block:)"))) __attribute__((objc_designated_initializer));
@property (readonly) int64_t afterVersion __attribute__((swift_name("afterVersion")));
@property (readonly) void (^block)(id<TerminalGatewayRuntimeSqlDriver>) __attribute__((swift_name("block")));
@end


/**
 * Base interface representing a [HttpClient] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin)
 */
__attribute__((swift_name("Ktor_client_coreHttpClientPlugin")))
@protocol TerminalGatewayKtor_client_coreHttpClientPlugin
@required

/**
 * Installs the [plugin] class for a [HttpClient] defined at [scope].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.install)
 */
- (void)installPlugin:(id)plugin scope:(TerminalGatewayKtor_client_coreHttpClient *)scope __attribute__((swift_name("install(plugin:scope:)")));

/**
 * Builds a [TPlugin] by calling the [block] with a [TConfig] config instance as receiver.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.prepare)
 */
- (id)prepareBlock:(void (^)(id))block __attribute__((swift_name("prepare(block:)")));

/**
 * The [AttributeKey] for this plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.plugins.HttpClientPlugin.key)
 */
@property (readonly) TerminalGatewayKtor_utilsAttributeKey<id> *key __attribute__((swift_name("key")));
@end


/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionsConfig")))
@interface TerminalGatewayKtor_websocketsWebSocketExtensionsConfig : TerminalGatewayBase

/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Extensions configuration for the WebSocket client and server plugins.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));

/**
 * Instantiates all installed extensions.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig.build)
 */
- (NSArray<id<TerminalGatewayKtor_websocketsWebSocketExtension>> *)build __attribute__((swift_name("build()")));

/**
 * Installs the provided [extension] using [config]. Every extension is processed in order of installation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionsConfig.install)
 */
- (void)installExtension:(id<TerminalGatewayKtor_websocketsWebSocketExtensionFactory>)extension config:(void (^)(id))config __attribute__((swift_name("install(extension:config:)")));
@end


/**
 * A custom content converter that could be used in the [WebSockets] plugin
 * Could provide bi-directional conversion implementation.
 * One of the most typical examples of the content converter is a JSON converter that provides
 * both serialization and deserialization
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter)
 */
__attribute__((swift_name("Ktor_serializationWebsocketContentConverter")))
@protocol TerminalGatewayKtor_serializationWebsocketContentConverter
@required

/**
 * Deserializes [content] to the value of type [typeInfo]
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.deserialize)
 *
 * @return a converted value (deserialized) or throws `WebsocketConverterNotFoundException` if the context's
 * subject is not suitable for this converter
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)deserializeCharset:(TerminalGatewayKtor_ioCharset *)charset typeInfo:(TerminalGatewayKtor_utilsTypeInfo *)typeInfo content:(TerminalGatewayKtor_websocketsFrame *)content completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("deserialize(charset:typeInfo:content:completionHandler:)")));

/**
 * Checks if the content converter can deserialize a [frame]
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.isApplicable)
 *
 * @param frame a WebSocket frame
 *
 * @return true if the content converter can deserialize a [frame] type or false if a type of [frame]
 * is not supported by the converter
 */
- (BOOL)isApplicableFrame:(TerminalGatewayKtor_websocketsFrame *)frame __attribute__((swift_name("isApplicable(frame:)")));

/**
 * Serializes a [value] to a WebSocket [Frame].
 * This function could throw `WebsocketConverterNotFoundException` if the value is not suitable for conversion
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.serialization.WebsocketContentConverter.serialize)
 *
 * @param charset response charset
 * @param typeInfo response body typeInfo
 * @param value to be converted
 *
 * @return a converted [Frame] value, or null if [value] isn't suitable for this converter
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)serializeCharset:(TerminalGatewayKtor_ioCharset *)charset typeInfo:(TerminalGatewayKtor_utilsTypeInfo *)typeInfo value:(id _Nullable)value completionHandler:(void (^)(TerminalGatewayKtor_websocketsFrame * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("serialize(charset:typeInfo:value:completionHandler:)")));
@end

__attribute__((swift_name("KotlinByteIterator")))
@interface TerminalGatewayKotlinByteIterator : TerminalGatewayBase <TerminalGatewayKotlinIterator>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (TerminalGatewayByte *)next __attribute__((swift_name("next()")));
- (int8_t)nextByte __attribute__((swift_name("nextByte()")));
@end

__attribute__((swift_name("KotlinAppendable")))
@protocol TerminalGatewayKotlinAppendable
@required
- (id<TerminalGatewayKotlinAppendable>)appendValue:(unichar)value __attribute__((swift_name("append(value:)")));
- (id<TerminalGatewayKotlinAppendable>)appendValue_:(id _Nullable)value __attribute__((swift_name("append(value_:)")));
- (id<TerminalGatewayKotlinAppendable>)appendValue:(id _Nullable)value startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("append(value:startIndex:endIndex:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_coreFileMetadata")))
@interface TerminalGatewayKotlinx_io_coreFileMetadata : TerminalGatewayBase
- (instancetype)initWithIsRegularFile:(BOOL)isRegularFile isDirectory:(BOOL)isDirectory size:(int64_t)size __attribute__((swift_name("init(isRegularFile:isDirectory:size:)"))) __attribute__((objc_designated_initializer));
@property (readonly) BOOL isDirectory __attribute__((swift_name("isDirectory")));
@property (readonly) BOOL isRegularFile __attribute__((swift_name("isRegularFile")));
@property (readonly) int64_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_io_coreRawSink")))
@protocol TerminalGatewayKotlinx_io_coreRawSink <TerminalGatewayKotlinAutoCloseable>
@required
- (void)flush __attribute__((swift_name("flush()")));
- (void)writeSource:(TerminalGatewayKotlinx_io_coreBuffer *)source byteCount:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount:)")));
@end

__attribute__((swift_name("Kotlinx_io_coreRawSource")))
@protocol TerminalGatewayKotlinx_io_coreRawSource <TerminalGatewayKotlinAutoCloseable>
@required
- (int64_t)readAtMostToSink:(TerminalGatewayKotlinx_io_coreBuffer *)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readAtMostTo(sink:byteCount:)")));
@end

__attribute__((swift_name("Kermit_coreLoggerConfig")))
@protocol TerminalGatewayKermit_coreLoggerConfig
@required
@property (readonly) NSArray<TerminalGatewayKermit_coreLogWriter *> *logWriterList __attribute__((swift_name("logWriterList")));
@property (readonly) TerminalGatewayKermit_coreSeverity *minSeverity __attribute__((swift_name("minSeverity")));
@end

__attribute__((swift_name("Kermit_coreMutableLoggerConfig")))
@protocol TerminalGatewayKermit_coreMutableLoggerConfig <TerminalGatewayKermit_coreLoggerConfig>
@required
- (void)setLogWriterList:(NSArray<TerminalGatewayKermit_coreLogWriter *> *)value __attribute__((swift_name("setLogWriterList(_:)")));
- (void)setMinSeverity:(TerminalGatewayKermit_coreSeverity *)value __attribute__((swift_name("setMinSeverity(_:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KermitLogger.Companion")))
@interface TerminalGatewayKermitLoggerCompanion : TerminalGatewayKermitLogger
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithConfig:(id<TerminalGatewayKermit_coreLoggerConfig>)config tag:(NSString *)tag __attribute__((swift_name("init(config:tag:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKermitLoggerCompanion *shared __attribute__((swift_name("shared")));
- (void)aTag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("a(tag:throwable:message:)")));
- (void)addLogWriterLogWriter:(TerminalGatewayKotlinArray<TerminalGatewayKermit_coreLogWriter *> *)logWriter __attribute__((swift_name("addLogWriter(logWriter:)")));
- (void)dTag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("d(tag:throwable:message:)")));
- (void)eTag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("e(tag:throwable:message:)")));
- (void)iTag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("i(tag:throwable:message:)")));
- (void)setLogWritersLogWriter:(TerminalGatewayKotlinArray<TerminalGatewayKermit_coreLogWriter *> *)logWriter __attribute__((swift_name("setLogWriters(logWriter:)")));
- (void)setLogWritersLogWriters:(NSArray<TerminalGatewayKermit_coreLogWriter *> *)logWriters __attribute__((swift_name("setLogWriters(logWriters:)")));
- (void)setMinSeveritySeverity:(TerminalGatewayKermit_coreSeverity *)severity __attribute__((swift_name("setMinSeverity(severity:)")));
- (void)setTagTag:(NSString *)tag __attribute__((swift_name("setTag(tag:)")));
- (void)vTag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("v(tag:throwable:message:)")));
- (void)wTag:(NSString *)tag throwable:(TerminalGatewayKotlinThrowable * _Nullable)throwable message:(NSString *(^)(void))message __attribute__((swift_name("w(tag:throwable:message:)")));
@property (readonly) NSString *tag __attribute__((swift_name("tag")));
@end

__attribute__((swift_name("Kotlinx_io_coreSink")))
@protocol TerminalGatewayKotlinx_io_coreSink <TerminalGatewayKotlinx_io_coreRawSink>
@required
- (void)emit __attribute__((swift_name("emit()")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
- (void)hintEmit __attribute__((swift_name("hintEmit()")));
- (int64_t)transferFromSource:(id<TerminalGatewayKotlinx_io_coreRawSource>)source __attribute__((swift_name("transferFrom(source:)")));
- (void)writeSource:(id<TerminalGatewayKotlinx_io_coreRawSource>)source byteCount_:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount_:)")));
- (void)writeSource:(TerminalGatewayKotlinByteArray *)source startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("write(source:startIndex:endIndex:)")));
- (void)writeByteByte:(int8_t)byte __attribute__((swift_name("writeByte(byte:)")));
- (void)writeIntInt:(int32_t)int_ __attribute__((swift_name("writeInt(int:)")));
- (void)writeLongLong:(int64_t)long_ __attribute__((swift_name("writeLong(long:)")));
- (void)writeShortShort:(int16_t)short_ __attribute__((swift_name("writeShort(short:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) TerminalGatewayKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@end

__attribute__((swift_name("Ktor_ioChannelJob")))
@protocol TerminalGatewayKtor_ioChannelJob
@required
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioWriterJob")))
@interface TerminalGatewayKtor_ioWriterJob : TerminalGatewayBase <TerminalGatewayKtor_ioChannelJob>
@property (readonly) id<TerminalGatewayKtor_ioByteReadChannel> channel __attribute__((swift_name("channel")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end


/**
 * Channel for asynchronous reading of sequences of bytes.
 * This is a **single-reader channel**.
 *
 * Operations on this channel cannot be invoked concurrently.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteReadChannel)
 */
__attribute__((swift_name("Ktor_ioByteReadChannel")))
@protocol TerminalGatewayKtor_ioByteReadChannel
@required

/**
 * Suspend the channel until it has [min] bytes or gets closed. Throws exception if the channel was closed with an
 * error. If there are bytes available in the channel, this function returns immediately.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteReadChannel.awaitContent)
 *
 * @return return `false` eof is reached, otherwise `true`.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitContentMin:(int32_t)min completionHandler:(void (^)(TerminalGatewayBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("awaitContent(min:completionHandler:)")));
- (void)cancelCause_:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));
@property (readonly) TerminalGatewayKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForRead __attribute__((swift_name("isClosedForRead")));
@property (readonly) id<TerminalGatewayKotlinx_io_coreSource> readBuffer __attribute__((swift_name("readBuffer")));
@end

__attribute__((swift_name("Ktor_ioBufferedByteWriteChannel")))
@protocol TerminalGatewayKtor_ioBufferedByteWriteChannel <TerminalGatewayKtor_ioByteWriteChannel>
@required

/**
 * Flush all pending bytes from [writeBuffer] to the internal read buffer without suspension and initiate channel close.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.BufferedByteWriteChannel.close)
 */
- (void)close __attribute__((swift_name("close()")));

/**
 * Flush all pending bytes from [writeBuffer] to the internal read buffer without suspension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.BufferedByteWriteChannel.flushWriteBuffer)
 */
- (void)flushWriteBuffer __attribute__((swift_name("flushWriteBuffer()")));
@end


/**
 * Sequential (non-concurrent) byte channel implementation
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ByteChannel)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioByteChannel")))
@interface TerminalGatewayKtor_ioByteChannel : TerminalGatewayBase <TerminalGatewayKtor_ioByteReadChannel, TerminalGatewayKtor_ioBufferedByteWriteChannel>
- (instancetype)initWithAutoFlush:(BOOL)autoFlush __attribute__((swift_name("init(autoFlush:)"))) __attribute__((objc_designated_initializer));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)awaitContentMin:(int32_t)min completionHandler:(void (^)(TerminalGatewayBoolean * _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("awaitContent(min:completionHandler:)")));
- (void)cancelCause_:(TerminalGatewayKotlinThrowable * _Nullable)cause __attribute__((swift_name("cancel(cause_:)")));
- (void)close __attribute__((swift_name("close()")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flush(completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
- (void)flushWriteBuffer __attribute__((swift_name("flushWriteBuffer()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL autoFlush __attribute__((swift_name("autoFlush")));
@property (readonly) TerminalGatewayKotlinThrowable * _Nullable closedCause __attribute__((swift_name("closedCause")));
@property (readonly) BOOL isClosedForRead __attribute__((swift_name("isClosedForRead")));
@property (readonly) BOOL isClosedForWrite __attribute__((swift_name("isClosedForWrite")));
@property (readonly) id<TerminalGatewayKotlinx_io_coreSource> readBuffer __attribute__((swift_name("readBuffer")));
@property (readonly) id<TerminalGatewayKotlinx_io_coreSink> writeBuffer __attribute__((swift_name("writeBuffer")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioReaderJob")))
@interface TerminalGatewayKtor_ioReaderJob : TerminalGatewayBase <TerminalGatewayKtor_ioChannelJob>

/**
 * To avoid the risk of concurrent write operations, we cancel the nested job before
 * performing `flushAndClose` on the [ByteWriteChannel].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.utils.io.ReaderJob.flushAndClose)
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)flushAndCloseWithCompletionHandler:(void (^)(NSError * _Nullable))completionHandler __attribute__((swift_name("flushAndClose(completionHandler:)")));
@property (readonly) id<TerminalGatewayKtor_ioByteWriteChannel> channel __attribute__((swift_name("channel")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreJob> job __attribute__((swift_name("job")));
@end

__attribute__((swift_name("Ktor_networkSocketAddress")))
@interface TerminalGatewayKtor_networkSocketAddress : TerminalGatewayBase
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDate.Companion")))
@interface TerminalGatewayKotlinx_datetimeLocalDateCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeLocalDateCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)FormatBlock:(void (^)(id<TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithDate>))block __attribute__((swift_name("Format(block:)")));
- (TerminalGatewayKotlinx_datetimeLocalDate *)fromEpochDaysEpochDays:(int32_t)epochDays __attribute__((swift_name("fromEpochDays(epochDays:)")));
- (TerminalGatewayKotlinx_datetimeLocalDate *)fromEpochDaysEpochDays_:(int64_t)epochDays __attribute__((swift_name("fromEpochDays(epochDays_:)")));
- (TerminalGatewayKotlinx_datetimeLocalDate *)parseInput:(id)input format:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("KotlinIterable")))
@protocol TerminalGatewayKotlinIterable
@required
- (id<TerminalGatewayKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
@end

__attribute__((swift_name("KotlinCollection")))
@protocol TerminalGatewayKotlinCollection <TerminalGatewayKotlinIterable>
@required
- (BOOL)containsElement:(id _Nullable)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsAllElements:(id)elements __attribute__((swift_name("containsAll(elements:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("Kotlinx_datetimeLocalDateProgression")))
@interface TerminalGatewayKotlinx_datetimeLocalDateProgression : TerminalGatewayBase <TerminalGatewayKotlinCollection>
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeLocalDateProgressionCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsElement:(TerminalGatewayKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsAllElements:(id)elements __attribute__((swift_name("containsAll(elements:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (id<TerminalGatewayKotlinIterator>)iterator __attribute__((swift_name("iterator()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewayKotlinx_datetimeLocalDate *first __attribute__((swift_name("first")));
@property (readonly) TerminalGatewayKotlinx_datetimeLocalDate *last __attribute__((swift_name("last")));
@property (readonly) int32_t size __attribute__((swift_name("size")));
@end

__attribute__((swift_name("KotlinClosedRange")))
@protocol TerminalGatewayKotlinClosedRange
@required
- (BOOL)containsValue:(id)value __attribute__((swift_name("contains(value:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) id endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly, getter=start_) id start __attribute__((swift_name("start")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.9")
*/
__attribute__((swift_name("KotlinOpenEndRange")))
@protocol TerminalGatewayKotlinOpenEndRange
@required
- (BOOL)containsValue_:(id)value __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
@property (readonly) id endExclusive __attribute__((swift_name("endExclusive")));
@property (readonly, getter=start_) id start __attribute__((swift_name("start")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateRange")))
@interface TerminalGatewayKotlinx_datetimeLocalDateRange : TerminalGatewayKotlinx_datetimeLocalDateProgression <TerminalGatewayKotlinClosedRange, TerminalGatewayKotlinOpenEndRange>
- (instancetype)initWithStart:(TerminalGatewayKotlinx_datetimeLocalDate *)start endInclusive:(TerminalGatewayKotlinx_datetimeLocalDate *)endInclusive __attribute__((swift_name("init(start:endInclusive:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeLocalDateRangeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)containsElement:(TerminalGatewayKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(element:)")));
- (BOOL)containsValue:(TerminalGatewayKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(value:)")));
- (BOOL)containsValue_:(TerminalGatewayKotlinx_datetimeLocalDate *)element __attribute__((swift_name("contains(value_:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewayKotlinx_datetimeLocalDate *endExclusive __attribute__((swift_name("endExclusive"))) __attribute__((deprecated("This throws an exception if the exclusive end if not inside the platform-specific boundaries for LocalDate. The 'endInclusive' property does not throw and should be preferred.")));
@property (readonly) TerminalGatewayKotlinx_datetimeLocalDate *endInclusive __attribute__((swift_name("endInclusive")));
@property (readonly, getter=start_) TerminalGatewayKotlinx_datetimeLocalDate *start __attribute__((swift_name("start")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalTime.Companion")))
@interface TerminalGatewayKotlinx_datetimeLocalTimeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeLocalTimeCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)FormatBuilder:(void (^)(id<TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithTime>))builder __attribute__((swift_name("Format(builder:)")));
- (TerminalGatewayKotlinx_datetimeLocalTime *)fromMillisecondOfDayMillisecondOfDay:(int32_t)millisecondOfDay __attribute__((swift_name("fromMillisecondOfDay(millisecondOfDay:)")));
- (TerminalGatewayKotlinx_datetimeLocalTime *)fromNanosecondOfDayNanosecondOfDay:(int64_t)nanosecondOfDay __attribute__((swift_name("fromNanosecondOfDay(nanosecondOfDay:)")));
- (TerminalGatewayKotlinx_datetimeLocalTime *)fromSecondOfDaySecondOfDay:(int32_t)secondOfDay __attribute__((swift_name("fromSecondOfDay(secondOfDay:)")));
- (TerminalGatewayKotlinx_datetimeLocalTime *)parseInput:(id)input format:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilder")))
@protocol TerminalGatewayKotlinx_datetimeDateTimeFormatBuilder
@required
- (void)charsValue:(NSString *)value __attribute__((swift_name("chars(value:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithYearMonth")))
@protocol TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithYearMonth <TerminalGatewayKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)monthNameNames:(TerminalGatewayKotlinx_datetimeMonthNames *)names __attribute__((swift_name("monthName(names:)")));
- (void)monthNumberPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("monthNumber(padding:)")));
- (void)yearPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("year(padding:)")));
- (void)yearMonthFormat:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("yearMonth(format:)")));
- (void)yearTwoDigitsBaseYear:(int32_t)baseYear __attribute__((swift_name("yearTwoDigits(baseYear:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithDate")))
@protocol TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithDate <TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithYearMonth>
@required
- (void)dateFormat:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("date(format:)")));
- (void)dayPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("day(padding:)")));
- (void)dayOfMonthPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("dayOfMonth(padding:)"))) __attribute__((deprecated("Use 'day' instead")));
- (void)dayOfWeekNames:(TerminalGatewayKotlinx_datetimeDayOfWeekNames *)names __attribute__((swift_name("dayOfWeek(names:)")));
- (void)dayOfYearPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("dayOfYear(padding:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithTime")))
@protocol TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithTime <TerminalGatewayKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)amPmHourPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("amPmHour(padding:)")));
- (void)amPmMarkerAm:(NSString *)am pm:(NSString *)pm __attribute__((swift_name("amPmMarker(am:pm:)")));
- (void)hourPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("hour(padding:)")));
- (void)minutePadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("minute(padding:)")));
- (void)secondPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("second(padding:)")));
- (void)secondFractionFixedLength:(int32_t)fixedLength __attribute__((swift_name("secondFraction(fixedLength:)")));
- (void)secondFractionMinLength:(int32_t)minLength maxLength:(int32_t)maxLength __attribute__((swift_name("secondFraction(minLength:maxLength:)")));
- (void)timeFormat:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("time(format:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithDateTime")))
@protocol TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithDateTime <TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithDate, TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithTime>
@required
- (void)dateTimeFormat:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("dateTime(format:)")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/FixedOffsetTimeZoneSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeFixedOffsetTimeZone")))
@interface TerminalGatewayKotlinx_datetimeFixedOffsetTimeZone : TerminalGatewayKotlinx_datetimeTimeZone
- (instancetype)initWithOffset:(TerminalGatewayKotlinx_datetimeUtcOffset *)offset __attribute__((swift_name("init(offset:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeFixedOffsetTimeZoneCompanion *companion __attribute__((swift_name("companion")));
@property (readonly) NSString *id __attribute__((swift_name("id")));
@property (readonly) TerminalGatewayKotlinx_datetimeUtcOffset *offset __attribute__((swift_name("offset")));
@property (readonly) int32_t totalSeconds __attribute__((swift_name("totalSeconds"))) __attribute__((deprecated("Use offset.totalSeconds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinInstant.Companion")))
@interface TerminalGatewayKotlinInstantCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinInstantCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayKotlinInstant *)fromEpochMillisecondsEpochMilliseconds:(int64_t)epochMilliseconds __attribute__((swift_name("fromEpochMilliseconds(epochMilliseconds:)")));
- (TerminalGatewayKotlinInstant *)fromEpochSecondsEpochSeconds:(int64_t)epochSeconds nanosecondAdjustment:(int32_t)nanosecondAdjustment __attribute__((swift_name("fromEpochSeconds(epochSeconds:nanosecondAdjustment:)")));
- (TerminalGatewayKotlinInstant *)fromEpochSecondsEpochSeconds:(int64_t)epochSeconds nanosecondAdjustment_:(int64_t)nanosecondAdjustment __attribute__((swift_name("fromEpochSeconds(epochSeconds:nanosecondAdjustment_:)")));
- (TerminalGatewayKotlinInstant *)now __attribute__((swift_name("now()"))) __attribute__((unavailable("Use Clock.System.now() instead")));
- (TerminalGatewayKotlinInstant *)parseInput:(id)input __attribute__((swift_name("parse(input:)")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="2.2")
*/
- (TerminalGatewayKotlinInstant * _Nullable)parseOrNullInput:(id)input __attribute__((swift_name("parseOrNull(input:)")));
@property (readonly) TerminalGatewayKotlinInstant *DISTANT_FUTURE __attribute__((swift_name("DISTANT_FUTURE")));
@property (readonly) TerminalGatewayKotlinInstant *DISTANT_PAST __attribute__((swift_name("DISTANT_PAST")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJson.Default")))
@interface TerminalGatewayKotlinx_serialization_jsonJsonDefault : TerminalGatewayKotlinx_serialization_jsonJson
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)default_ __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_serialization_jsonJsonDefault *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonJsonConfiguration")))
@interface TerminalGatewayKotlinx_serialization_jsonJsonConfiguration : TerminalGatewayBase
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL allowComments __attribute__((swift_name("allowComments")));
@property (readonly) BOOL allowSpecialFloatingPointValues __attribute__((swift_name("allowSpecialFloatingPointValues")));
@property (readonly) BOOL allowStructuredMapKeys __attribute__((swift_name("allowStructuredMapKeys")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL allowTrailingComma __attribute__((swift_name("allowTrailingComma")));
@property (readonly) NSString *classDiscriminator __attribute__((swift_name("classDiscriminator")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode *classDiscriminatorMode __attribute__((swift_name("classDiscriminatorMode")));
@property (readonly) BOOL coerceInputValues __attribute__((swift_name("coerceInputValues")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) BOOL decodeEnumsCaseInsensitive __attribute__((swift_name("decodeEnumsCaseInsensitive")));
@property (readonly) BOOL encodeDefaults __attribute__((swift_name("encodeDefaults")));
@property (readonly) BOOL explicitNulls __attribute__((swift_name("explicitNulls")));
@property (readonly) BOOL ignoreUnknownKeys __attribute__((swift_name("ignoreUnknownKeys")));
@property (readonly) BOOL isLenient __attribute__((swift_name("isLenient")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) id<TerminalGatewayKotlinx_serialization_jsonJsonNamingStrategy> _Nullable namingStrategy __attribute__((swift_name("namingStrategy")));
@property (readonly) BOOL prettyPrint __attribute__((swift_name("prettyPrint")));

/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
@property (readonly) NSString *prettyPrintIndent __attribute__((swift_name("prettyPrintIndent")));
@property (readonly) BOOL useAlternativeNames __attribute__((swift_name("useAlternativeNames")));
@property (readonly) BOOL useArrayPolymorphism __attribute__((swift_name("useArrayPolymorphism")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreParentJob")))
@protocol TerminalGatewayKotlinx_coroutines_coreParentJob <TerminalGatewayKotlinx_coroutines_coreJob>
@required

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (TerminalGatewayKotlinCancellationException *)getChildJobCancellationCause __attribute__((swift_name("getChildJobCancellationCause()")));
@end


/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
__attribute__((swift_name("Kotlinx_coroutines_coreSelectInstance")))
@protocol TerminalGatewayKotlinx_coroutines_coreSelectInstance
@required
- (void)disposeOnCompletionDisposableHandle:(id<TerminalGatewayKotlinx_coroutines_coreDisposableHandle>)disposableHandle __attribute__((swift_name("disposeOnCompletion(disposableHandle:)")));
- (void)selectInRegistrationPhaseInternalResult:(id _Nullable)internalResult __attribute__((swift_name("selectInRegistrationPhase(internalResult:)")));
- (BOOL)trySelectClauseObject:(id)clauseObject result:(id _Nullable)result __attribute__((swift_name("trySelect(clauseObject:result:)")));
@property (readonly) id<TerminalGatewayKotlinCoroutineContext> context __attribute__((swift_name("context")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
__attribute__((swift_name("Kotlinx_serialization_coreSerializersModuleCollector")))
@protocol TerminalGatewayKotlinx_serialization_coreSerializersModuleCollector
@required
- (void)contextualKClass:(id<TerminalGatewayKotlinKClass>)kClass provider:(id<TerminalGatewayKotlinx_serialization_coreKSerializer> (^)(NSArray<id<TerminalGatewayKotlinx_serialization_coreKSerializer>> *))provider __attribute__((swift_name("contextual(kClass:provider:)")));
- (void)contextualKClass:(id<TerminalGatewayKotlinKClass>)kClass serializer:(id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("contextual(kClass:serializer:)")));
- (void)polymorphicBaseClass:(id<TerminalGatewayKotlinKClass>)baseClass actualClass:(id<TerminalGatewayKotlinKClass>)actualClass actualSerializer:(id<TerminalGatewayKotlinx_serialization_coreKSerializer>)actualSerializer __attribute__((swift_name("polymorphic(baseClass:actualClass:actualSerializer:)")));
- (void)polymorphicDefaultBaseClass:(id<TerminalGatewayKotlinKClass>)baseClass defaultDeserializerProvider:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy> _Nullable (^)(NSString * _Nullable))defaultDeserializerProvider __attribute__((swift_name("polymorphicDefault(baseClass:defaultDeserializerProvider:)"))) __attribute__((deprecated("Deprecated in favor of function with more precise name: polymorphicDefaultDeserializer")));
- (void)polymorphicDefaultDeserializerBaseClass:(id<TerminalGatewayKotlinKClass>)baseClass defaultDeserializerProvider:(id<TerminalGatewayKotlinx_serialization_coreDeserializationStrategy> _Nullable (^)(NSString * _Nullable))defaultDeserializerProvider __attribute__((swift_name("polymorphicDefaultDeserializer(baseClass:defaultDeserializerProvider:)")));
- (void)polymorphicDefaultSerializerBaseClass:(id<TerminalGatewayKotlinKClass>)baseClass defaultSerializerProvider:(id<TerminalGatewayKotlinx_serialization_coreSerializationStrategy> _Nullable (^)(id))defaultSerializerProvider __attribute__((swift_name("polymorphicDefaultSerializer(baseClass:defaultSerializerProvider:)")));
@end

__attribute__((swift_name("KotlinKDeclarationContainer")))
@protocol TerminalGatewayKotlinKDeclarationContainer
@required
@end

__attribute__((swift_name("KotlinKAnnotatedElement")))
@protocol TerminalGatewayKotlinKAnnotatedElement
@required
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((swift_name("KotlinKClassifier")))
@protocol TerminalGatewayKotlinKClassifier
@required
@end

__attribute__((swift_name("KotlinKClass")))
@protocol TerminalGatewayKotlinKClass <TerminalGatewayKotlinKDeclarationContainer, TerminalGatewayKotlinKAnnotatedElement, TerminalGatewayKotlinKClassifier>
@required

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
- (BOOL)isInstanceValue:(id _Nullable)value __attribute__((swift_name("isInstance(value:)")));
@property (readonly) NSString * _Nullable qualifiedName __attribute__((swift_name("qualifiedName")));
@property (readonly) NSString * _Nullable simpleName __attribute__((swift_name("simpleName")));
@end


/**
 * Actual data of the [HttpRequest], including [url], [method], [headers], [body] and [executionContext].
 * Built by [HttpRequestBuilder].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestData)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestData")))
@interface TerminalGatewayKtor_client_coreHttpRequestData : TerminalGatewayBase
- (instancetype)initWithUrl:(TerminalGatewayKtor_httpUrl *)url method:(TerminalGatewayKtor_httpHttpMethod *)method headers:(id<TerminalGatewayKtor_httpHeaders>)headers body:(TerminalGatewayKtor_httpOutgoingContent *)body executionContext:(id<TerminalGatewayKotlinx_coroutines_coreJob>)executionContext attributes:(id<TerminalGatewayKtor_utilsAttributes>)attributes __attribute__((swift_name("init(url:method:headers:body:executionContext:attributes:)"))) __attribute__((objc_designated_initializer));

/**
 * Retrieve extension by its key.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestData.getCapabilityOrNull)
 */
- (id _Nullable)getCapabilityOrNullKey:(id<TerminalGatewayKtor_client_coreHttpClientEngineCapability>)key __attribute__((swift_name("getCapabilityOrNull(key:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<TerminalGatewayKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) TerminalGatewayKtor_httpOutgoingContent *body __attribute__((swift_name("body")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreJob> executionContext __attribute__((swift_name("executionContext")));
@property (readonly) id<TerminalGatewayKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) TerminalGatewayKtor_httpHttpMethod *method __attribute__((swift_name("method")));
@property (readonly) TerminalGatewayKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * Data prepared for [HttpResponse].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpResponseData)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponseData")))
@interface TerminalGatewayKtor_client_coreHttpResponseData : TerminalGatewayBase
- (instancetype)initWithStatusCode:(TerminalGatewayKtor_httpHttpStatusCode *)statusCode requestTime:(TerminalGatewayKtor_utilsGMTDate *)requestTime headers:(id<TerminalGatewayKtor_httpHeaders>)headers version:(TerminalGatewayKtor_httpHttpProtocolVersion *)version body:(id)body callContext:(id<TerminalGatewayKotlinCoroutineContext>)callContext __attribute__((swift_name("init(statusCode:requestTime:headers:version:body:callContext:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id body __attribute__((swift_name("body")));
@property (readonly) id<TerminalGatewayKotlinCoroutineContext> callContext __attribute__((swift_name("callContext")));
@property (readonly) id<TerminalGatewayKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@property (readonly) TerminalGatewayKtor_utilsGMTDate *requestTime __attribute__((swift_name("requestTime")));
@property (readonly) TerminalGatewayKtor_utilsGMTDate *responseTime __attribute__((swift_name("responseTime")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *statusCode __attribute__((swift_name("statusCode")));
@property (readonly) TerminalGatewayKtor_httpHttpProtocolVersion *version __attribute__((swift_name("version")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinAbstractCoroutineContextElement")))
@interface TerminalGatewayKotlinAbstractCoroutineContextElement : TerminalGatewayBase <TerminalGatewayKotlinCoroutineContextElement>
- (instancetype)initWithKey:(id<TerminalGatewayKotlinCoroutineContextKey>)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer));
@property (readonly) id<TerminalGatewayKotlinCoroutineContextKey> key __attribute__((swift_name("key")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinContinuationInterceptor")))
@protocol TerminalGatewayKotlinContinuationInterceptor <TerminalGatewayKotlinCoroutineContextElement>
@required
- (id<TerminalGatewayKotlinContinuation>)interceptContinuationContinuation:(id<TerminalGatewayKotlinContinuation>)continuation __attribute__((swift_name("interceptContinuation(continuation:)")));
- (void)releaseInterceptedContinuationContinuation:(id<TerminalGatewayKotlinContinuation>)continuation __attribute__((swift_name("releaseInterceptedContinuation(continuation:)")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineDispatcher")))
@interface TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcher : TerminalGatewayKotlinAbstractCoroutineContextElement <TerminalGatewayKotlinContinuationInterceptor>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (instancetype)initWithKey:(id<TerminalGatewayKotlinCoroutineContextKey>)key __attribute__((swift_name("init(key:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcherKey *companion __attribute__((swift_name("companion")));
- (void)dispatchContext:(id<TerminalGatewayKotlinCoroutineContext>)context block:(id<TerminalGatewayKotlinx_coroutines_coreRunnable>)block __attribute__((swift_name("dispatch(context:block:)")));

/**
 * @note annotations
 *   kotlinx.coroutines.InternalCoroutinesApi
*/
- (void)dispatchYieldContext:(id<TerminalGatewayKotlinCoroutineContext>)context block:(id<TerminalGatewayKotlinx_coroutines_coreRunnable>)block __attribute__((swift_name("dispatchYield(context:block:)")));
- (id<TerminalGatewayKotlinContinuation>)interceptContinuationContinuation:(id<TerminalGatewayKotlinContinuation>)continuation __attribute__((swift_name("interceptContinuation(continuation:)")));
- (BOOL)isDispatchNeededContext:(id<TerminalGatewayKotlinCoroutineContext>)context __attribute__((swift_name("isDispatchNeeded(context:)")));
- (TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcher *)limitedParallelismParallelism:(int32_t)parallelism name:(NSString * _Nullable)name __attribute__((swift_name("limitedParallelism(parallelism:name:)")));
- (TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcher *)plusOther_:(TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcher *)other __attribute__((swift_name("plus(other_:)"))) __attribute__((unavailable("Operator '+' on two CoroutineDispatcher objects is meaningless. CoroutineDispatcher is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The dispatcher to the right of `+` just replaces the dispatcher to the left.")));
- (void)releaseInterceptedContinuationContinuation:(id<TerminalGatewayKotlinContinuation>)continuation __attribute__((swift_name("releaseInterceptedContinuation(continuation:)")));
- (NSString *)description __attribute__((swift_name("description()")));
@end


/**
 * Proxy configuration.
 *
 * See [ProxyBuilder] to create proxy.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.engine.ProxyConfig)
 *
 * @param url: proxy url address.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreProxyConfig")))
@interface TerminalGatewayKtor_client_coreProxyConfig : TerminalGatewayBase
- (instancetype)initWithUrl:(TerminalGatewayKtor_httpUrl *)url __attribute__((swift_name("init(url:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewayKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsAttributeKey")))
@interface TerminalGatewayKtor_utilsAttributeKey<T> : TerminalGatewayBase

/**
 * @note annotations
 *   kotlin.jvm.JvmOverloads
*/
- (instancetype)initWithName:(NSString *)name type:(TerminalGatewayKtor_utilsTypeInfo *)type __attribute__((swift_name("init(name:type:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayKtor_utilsAttributeKey<T> *)doCopyName:(NSString *)name type:(TerminalGatewayKtor_utilsTypeInfo *)type __attribute__((swift_name("doCopy(name:type:)")));

/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Specifies a key for an attribute in [Attributes]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.AttributeKey)
 *
 * @param T is a type of the value stored in the attribute
 * @property name is a name of the attribute for diagnostic purposes. Can't be blank
 * @property type the recorded kotlin type of T
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end


/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
__attribute__((swift_name("Ktor_eventsEventDefinition")))
@interface TerminalGatewayKtor_eventsEventDefinition<T> : TerminalGatewayBase

/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Definition of an event.
 * Event is used as a key so both [hashCode] and [equals] need to be implemented properly.
 * Inheriting of this class is an experimental feature.
 * Instantiate directly if inheritance not necessary.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.events.EventDefinition)
 *
 * @param T specifies what is a type of value passed to the event
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@end


/**
 * Represents a phase in a pipeline
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.pipeline.PipelinePhase)
 *
 * @param name a name for this phase
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsPipelinePhase")))
@interface TerminalGatewayKtor_utilsPipelinePhase : TerminalGatewayBase
- (instancetype)initWithName:(NSString *)name __attribute__((swift_name("init(name:)"))) __attribute__((objc_designated_initializer));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((swift_name("KotlinSuspendFunction2")))
@protocol TerminalGatewayKotlinSuspendFunction2 <TerminalGatewayKotlinFunction>
@required

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)invokeP1:(id _Nullable)p1 p2:(id _Nullable)p2 completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("invoke(p1:p2:completionHandler:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpReceivePipeline.Phases")))
@interface TerminalGatewayKtor_client_coreHttpReceivePipelinePhases : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_client_coreHttpReceivePipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * Latest response pipeline phase
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.After)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *After __attribute__((swift_name("After")));

/**
 * The earliest phase that happens before any other
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.Before)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Use this phase to store request shared state
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpReceivePipeline.Phases.State)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@end


/**
 * A message either from the client or the server,
 * that has [headers] associated.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessage)
 */
__attribute__((swift_name("Ktor_httpHttpMessage")))
@protocol TerminalGatewayKtor_httpHttpMessage
@required

/**
 * Message [Headers]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessage.headers)
 */
@property (readonly) id<TerminalGatewayKtor_httpHeaders> headers __attribute__((swift_name("headers")));
@end


/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
__attribute__((swift_name("Ktor_client_coreHttpResponse")))
@interface TerminalGatewayKtor_client_coreHttpResponse : TerminalGatewayBase <TerminalGatewayKtor_httpHttpMessage, TerminalGatewayKotlinx_coroutines_coreCoroutineScope>

/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * An [HttpClient]'s response, a second part of [HttpClientCall].
 *
 * Learn more from [Receiving responses](https://ktor.io/docs/response.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * The associated [HttpClientCall] containing both
 * the underlying [HttpClientCall.request] and [HttpClientCall.response].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.call)
 */
@property (readonly) TerminalGatewayKtor_client_coreHttpClientCall *call __attribute__((swift_name("call")));

/**
 * Provides a raw [ByteReadChannel] to the response content as it is read from the network.
 * This content can be still compressed or encoded.
 *
 * This content doesn't go through any interceptors from [HttpResponsePipeline].
 *
 * If you need to read the content as decoded bytes, use the [bodyAsChannel] method instead.
 *
 * This property produces a new channel every time it's accessed.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.rawContent)
 */
@property (readonly) id<TerminalGatewayKtor_ioByteReadChannel> rawContent __attribute__((swift_name("rawContent")));

/**
 * [GMTDate] of the request start.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.requestTime)
 */
@property (readonly) TerminalGatewayKtor_utilsGMTDate *requestTime __attribute__((swift_name("requestTime")));

/**
 * [GMTDate] of the response start.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.responseTime)
 */
@property (readonly) TerminalGatewayKtor_utilsGMTDate *responseTime __attribute__((swift_name("responseTime")));

/**
 * The [HttpStatusCode] returned by the server. It includes both,
 * the [HttpStatusCode.description] and the [HttpStatusCode.value] (code).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.status)
 */
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *status __attribute__((swift_name("status")));

/**
 * HTTP version. Usually [HttpProtocolVersion.HTTP_1_1] or [HttpProtocolVersion.HTTP_2_0].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponse.version)
 */
@property (readonly) TerminalGatewayKtor_httpHttpProtocolVersion *version_ __attribute__((swift_name("version_")));
@end


/**
 * All interceptors accept payload as [subject] and try to convert it to [OutgoingContent].
 * Last phase should proceed with [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestPipeline.Phases")))
@interface TerminalGatewayKtor_client_coreHttpRequestPipelinePhases : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));

/**
 * All interceptors accept payload as [subject] and try to convert it to [OutgoingContent].
 * Last phase should proceed with [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_client_coreHttpRequestPipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * The earliest phase that happens before any other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Before)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Encode a request body to [OutgoingContent].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Render)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Render __attribute__((swift_name("Render")));

/**
 * A phase for the [HttpSend] plugin.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Send)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Send __attribute__((swift_name("Send")));

/**
 * Use this phase to modify a request with a shared state.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.State)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));

/**
 * Transform a request body to supported render format.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestPipeline.Phases.Transform)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Transform __attribute__((swift_name("Transform")));
@end


/**
 * A builder message either for the client or the server,
 * that has a [headers] builder associated.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessageBuilder)
 */
__attribute__((swift_name("Ktor_httpHttpMessageBuilder")))
@protocol TerminalGatewayKtor_httpHttpMessageBuilder
@required

/**
 * MessageBuilder [HeadersBuilder]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMessageBuilder.headers)
 */
@property (readonly) TerminalGatewayKtor_httpHeadersBuilder *headers __attribute__((swift_name("headers")));
@end


/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestBuilder")))
@interface TerminalGatewayKtor_client_coreHttpRequestBuilder : TerminalGatewayBase <TerminalGatewayKtor_httpHttpMessageBuilder>

/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));

/**
 * Contains parameters used to make an HTTP request.
 *
 * Learn more from [Making requests](https://ktor.io/docs/request.html).
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder)
 */
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
@property (class, readonly, getter=companion) TerminalGatewayKtor_client_coreHttpRequestBuilderCompanion *companion __attribute__((swift_name("companion")));

/**
 * Creates immutable [HttpRequestData].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.build)
 */
- (TerminalGatewayKtor_client_coreHttpRequestData *)build __attribute__((swift_name("build()")));

/**
 * Retrieves capability by the key.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.getCapabilityOrNull)
 */
- (id _Nullable)getCapabilityOrNullKey:(id<TerminalGatewayKtor_client_coreHttpClientEngineCapability>)key __attribute__((swift_name("getCapabilityOrNull(key:)")));

/**
 * Sets request-specific attributes specified by [block].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.setAttributes)
 */
- (void)setAttributesBlock:(void (^)(id<TerminalGatewayKtor_utilsAttributes>))block __attribute__((swift_name("setAttributes(block:)")));

/**
 * Sets capability configuration.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.setCapability)
 */
- (void)setCapabilityKey:(id<TerminalGatewayKtor_client_coreHttpClientEngineCapability>)key capability:(id)capability __attribute__((swift_name("setCapability(key:capability:)")));

/**
 * Mutates [this] by copying all the data but execution context from another [builder] using it as the base.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.takeFrom)
 */
- (TerminalGatewayKtor_client_coreHttpRequestBuilder *)takeFromBuilder:(TerminalGatewayKtor_client_coreHttpRequestBuilder *)builder __attribute__((swift_name("takeFrom(builder:)")));

/**
 * Mutates [this] copying all the data from another [builder] using it as the base.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.takeFromWithExecutionContext)
 */
- (TerminalGatewayKtor_client_coreHttpRequestBuilder *)takeFromWithExecutionContextBuilder:(TerminalGatewayKtor_client_coreHttpRequestBuilder *)builder __attribute__((swift_name("takeFromWithExecutionContext(builder:)")));

/**
 * Executes a [block] that configures the [URLBuilder] associated to this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.url)
 */
- (void)urlBlock:(void (^)(TerminalGatewayKtor_httpURLBuilder *, TerminalGatewayKtor_httpURLBuilder *))block __attribute__((swift_name("url(block:)")));

/**
 * Provides access to attributes specific for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.attributes)
 */
@property (readonly) id<TerminalGatewayKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * The [body] for this request. Initially [EmptyContent].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.body)
 */
@property id body __attribute__((swift_name("body")));

/**
 * The [KType] of [body] for this request. Null for default types that don't need serialization.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.bodyType)
 */
@property TerminalGatewayKtor_utilsTypeInfo * _Nullable bodyType __attribute__((swift_name("bodyType")));

/**
 * A deferred used to control the execution of this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.executionContext)
 */
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreJob> executionContext __attribute__((swift_name("executionContext")));

/**
 * [HeadersBuilder] to configure the headers for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.headers)
 */
@property (readonly) TerminalGatewayKtor_httpHeadersBuilder *headers __attribute__((swift_name("headers")));

/**
 * [HttpMethod] used by this request. [HttpMethod.Get] by default.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.method)
 */
@property TerminalGatewayKtor_httpHttpMethod *method __attribute__((swift_name("method")));

/**
 * [URLBuilder] to configure the URL for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequestBuilder.url)
 */
@property (readonly) TerminalGatewayKtor_httpURLBuilder *url __attribute__((swift_name("url")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponsePipeline.Phases")))
@interface TerminalGatewayKtor_client_coreHttpResponsePipelinePhases : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_client_coreHttpResponsePipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * Latest response pipeline phase
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.After)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *After __attribute__((swift_name("After")));

/**
 * Decode response body
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Parse)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Parse __attribute__((swift_name("Parse")));

/**
 * The earliest phase that happens before any other
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Receive)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Receive __attribute__((swift_name("Receive")));

/**
 * Use this phase to store request shared state
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.State)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));

/**
 * Transform response body to expected format
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponsePipeline.Phases.Transform)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Transform __attribute__((swift_name("Transform")));
@end


/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpResponseContainer")))
@interface TerminalGatewayKtor_client_coreHttpResponseContainer : TerminalGatewayBase
- (instancetype)initWithExpectedType:(TerminalGatewayKtor_utilsTypeInfo *)expectedType response:(id)response __attribute__((swift_name("init(expectedType:response:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayKtor_client_coreHttpResponseContainer *)doCopyExpectedType:(TerminalGatewayKtor_utilsTypeInfo *)expectedType response:(id)response __attribute__((swift_name("doCopy(expectedType:response:)")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Class representing a typed [response] with an attached [expectedType].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.statement.HttpResponseContainer)
 *
 * @param expectedType: information about expected type.
 * @param response: current response state.
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewayKtor_utilsTypeInfo *expectedType __attribute__((swift_name("expectedType")));
@property (readonly) id response __attribute__((swift_name("response")));
@end


/**
 * A pair of a [request] and [response] for a specific [HttpClient].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall)
 *
 * @property client the client that executed the call.
 */
__attribute__((swift_name("Ktor_client_coreHttpClientCall")))
@interface TerminalGatewayKtor_client_coreHttpClientCall : TerminalGatewayBase <TerminalGatewayKotlinx_coroutines_coreCoroutineScope>
- (instancetype)initWithClient:(TerminalGatewayKtor_client_coreHttpClient *)client __attribute__((swift_name("init(client:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithClient:(TerminalGatewayKtor_client_coreHttpClient *)client requestData:(TerminalGatewayKtor_client_coreHttpRequestData *)requestData responseData:(TerminalGatewayKtor_client_coreHttpResponseData *)responseData __attribute__((swift_name("init(client:requestData:responseData:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_client_coreHttpClientCallCompanion *companion __attribute__((swift_name("companion")));

/**
 * Tries to receive the payload of the [response] as a specific expected type provided in [info].
 * Returns [response] if [info] corresponds to [HttpResponse].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.body)
 *
 * @throws NoTransformationFoundException If no transformation is found for the type [info].
 * @throws DoubleReceiveException If already called [body].
 * @throws NullPointerException If content is `null`.
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)bodyInfo:(TerminalGatewayKtor_utilsTypeInfo *)info completionHandler:(void (^)(id _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("body(info:completionHandler:)")));

/**
 * Tries to receive the payload of the [response] as a specific expected type provided in [info].
 * Returns [response] if [info] corresponds to [HttpResponse].
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.bodyNullable)
 *
 * @throws NoTransformationFoundException If no transformation is found for the type [info].
 * @throws DoubleReceiveException If already called [body].
 *
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
*/
- (void)bodyNullableInfo:(TerminalGatewayKtor_utilsTypeInfo *)info completionHandler:(void (^)(id _Nullable_result, NSError * _Nullable))completionHandler __attribute__((swift_name("bodyNullable(info:completionHandler:)")));

/**
 * @note This method converts instances of CancellationException to errors.
 * Other uncaught Kotlin exceptions are fatal.
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)getResponseContentWithCompletionHandler:(void (^)(id<TerminalGatewayKtor_ioByteReadChannel> _Nullable, NSError * _Nullable))completionHandler __attribute__((swift_name("getResponseContent(completionHandler:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) BOOL allowDoubleReceive __attribute__((swift_name("allowDoubleReceive")));

/**
 * Typed [Attributes] associated to this call serving as a lightweight container.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.attributes)
 */
@property (readonly) id<TerminalGatewayKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));
@property (readonly) TerminalGatewayKtor_client_coreHttpClient *client __attribute__((swift_name("client")));
@property (readonly) id<TerminalGatewayKotlinCoroutineContext> coroutineContext __attribute__((swift_name("coroutineContext")));

/**
 * The [request] sent by the client.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.request)
 */
@property id<TerminalGatewayKtor_client_coreHttpRequest> request __attribute__((swift_name("request")));

/**
 * The [response] sent by the server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.call.HttpClientCall.response)
 */
@property TerminalGatewayKtor_client_coreHttpResponse *response __attribute__((swift_name("response")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpSendPipeline.Phases")))
@interface TerminalGatewayKtor_client_coreHttpSendPipelinePhases : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)phases __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_client_coreHttpSendPipelinePhases *shared __attribute__((swift_name("shared")));

/**
 * The earliest phase that happens before any other.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Before)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Before __attribute__((swift_name("Before")));

/**
 * Send a request to a remote server.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Engine)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Engine __attribute__((swift_name("Engine")));

/**
 * Use this phase for logging and other actions that don't modify a request or shared data.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Monitoring)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Monitoring __attribute__((swift_name("Monitoring")));

/**
 * Receive a pipeline execution phase.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.Receive)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *Receive __attribute__((swift_name("Receive")));

/**
 * Use this phase to modify request with a shared state.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpSendPipeline.Phases.State)
 */
@property (readonly) TerminalGatewayKtor_utilsPipelinePhase *State __attribute__((swift_name("State")));
@end


/**
 * A WebSocket extension instance.
 * This instance is created for each WebSocket request, for every installed extension by [WebSocketExtensionFactory].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension)
 */
__attribute__((swift_name("Ktor_websocketsWebSocketExtension")))
@protocol TerminalGatewayKtor_websocketsWebSocketExtension
@required

/**
 * This method is called only for the client, when it receives the WebSocket upgrade response.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.clientNegotiation)
 *
 * @param negotiatedProtocols contains list of negotiated extensions from the server (can be empty).
 *
 * It's up to extension to decide if it should be used or not.
 * @return `true` if the extension should be used by the client.
 */
- (BOOL)clientNegotiationNegotiatedProtocols:(NSArray<TerminalGatewayKtor_websocketsWebSocketExtensionHeader *> *)negotiatedProtocols __attribute__((swift_name("clientNegotiation(negotiatedProtocols:)")));

/**
 * This method is called on each incoming frame before handling it in WebSocket session.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.processIncomingFrame)
 */
- (TerminalGatewayKtor_websocketsFrame *)processIncomingFrameFrame:(TerminalGatewayKtor_websocketsFrame *)frame __attribute__((swift_name("processIncomingFrame(frame:)")));

/**
 * This method is called on each outgoing frame and handle it before sending.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.processOutgoingFrame)
 */
- (TerminalGatewayKtor_websocketsFrame *)processOutgoingFrameFrame:(TerminalGatewayKtor_websocketsFrame *)frame __attribute__((swift_name("processOutgoingFrame(frame:)")));

/**
 * This method is called only for the server, when it receives WebSocket session.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.serverNegotiation)
 *
 * @param requestedProtocols contains list of requested extensions from the client (can be empty).
 *
 * @return list of protocols (with parameters), which server prefers to use for the current client request.
 */
- (NSArray<TerminalGatewayKtor_websocketsWebSocketExtensionHeader *> *)serverNegotiationRequestedProtocols:(NSArray<TerminalGatewayKtor_websocketsWebSocketExtensionHeader *> *)requestedProtocols __attribute__((swift_name("serverNegotiation(requestedProtocols:)")));

/**
 * Reference to the [WebSocketExtensionFactory], which produced this extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.factory)
 */
@property (readonly) id<TerminalGatewayKtor_websocketsWebSocketExtensionFactory> factory __attribute__((swift_name("factory")));

/**
 * List of WebSocket extension protocols which will be sent by client in headers.
 * They are required to inform server that client wants to negotiate the current extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtension.protocols)
 */
@property (readonly) NSArray<TerminalGatewayKtor_websocketsWebSocketExtensionHeader *> *protocols __attribute__((swift_name("protocols")));
@end


/**
 * A factory that defines a WebSocket extension. The factory is used in pair with the
 * [WebSocketExtensionsConfig.install] method to install the WebSocket extension in client or server.
 *
 * Usually this interface is implemented in `companion object` of the origin [WebSocketExtension].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory)
 */
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionFactory")))
@protocol TerminalGatewayKtor_websocketsWebSocketExtensionFactory
@required

/**
 * Creates an extension instance using [config] block. The extension instance is created for each WebSocket request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.install)
 */
- (id<TerminalGatewayKtor_websocketsWebSocketExtension>)installConfig:(void (^)(id))config __attribute__((swift_name("install(config:)")));

/**
 * A key used to locate an extension.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.key)
 */
@property (readonly) TerminalGatewayKtor_utilsAttributeKey<id<TerminalGatewayKtor_websocketsWebSocketExtension>> *key __attribute__((swift_name("key")));

/**
 * The first extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with the enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv1)
 */
@property (readonly) BOOL rsv1 __attribute__((swift_name("rsv1")));

/**
 * A second extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with the enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv2)
 */
@property (readonly) BOOL rsv2 __attribute__((swift_name("rsv2")));

/**
 * A third extension bit used by the current extension.
 *
 * This flag is used to detect extension conflicts: only one plugin with enabled flag is allowed.
 * To set the flag value, consult with specification of the extension you're using.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionFactory.rsv3)
 */
@property (readonly) BOOL rsv3 __attribute__((swift_name("rsv3")));
@end

__attribute__((swift_name("Ktor_ioCharset")))
@interface TerminalGatewayKtor_ioCharset : TerminalGatewayBase
- (instancetype)initWith_name:(NSString *)_name __attribute__((swift_name("init(_name:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_ioCharsetCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (TerminalGatewayKtor_ioCharsetDecoder *)doNewDecoder __attribute__((swift_name("doNewDecoder()")));
- (TerminalGatewayKtor_ioCharsetEncoder *)doNewEncoder __attribute__((swift_name("doNewEncoder()")));
- (NSString *)description __attribute__((swift_name("description()")));
@end


/**
 * Ktor type information.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.reflect.TypeInfo)
 *
 * @property type Source KClass<*>
 * @property kotlinType Kotlin reified type with all generic type parameters.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsTypeInfo")))
@interface TerminalGatewayKtor_utilsTypeInfo : TerminalGatewayBase
- (instancetype)initWithType:(id<TerminalGatewayKotlinKClass>)type kotlinType:(id<TerminalGatewayKotlinKType> _Nullable)kotlinType __attribute__((swift_name("init(type:kotlinType:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithType:(id<TerminalGatewayKotlinKClass>)type reifiedType:(id<TerminalGatewayKotlinKType>)reifiedType kotlinType:(id<TerminalGatewayKotlinKType> _Nullable)kotlinType __attribute__((swift_name("init(type:reifiedType:kotlinType:)"))) __attribute__((objc_designated_initializer)) __attribute__((deprecated("Use constructor without reifiedType parameter.")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<TerminalGatewayKotlinKType> _Nullable kotlinType __attribute__((swift_name("kotlinType")));
@property (readonly) id<TerminalGatewayKotlinKClass> type __attribute__((swift_name("type")));
@end


/**
 * A frame received or ready to be sent. It is not reusable and not thread-safe
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame)
 *
 * @property fin is it final fragment, should be always `true` for control frames and if no fragmentation is used
 * @property frameType enum value
 * @property data - a frame content or fragment content
 * @property disposableHandle could be invoked when the frame is processed
 */
__attribute__((swift_name("Ktor_websocketsFrame")))
@interface TerminalGatewayKtor_websocketsFrame : TerminalGatewayBase
@property (class, readonly, getter=companion) TerminalGatewayKtor_websocketsFrameCompanion *companion __attribute__((swift_name("companion")));

/**
 * Creates a frame copy.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame.copy)
 */
- (TerminalGatewayKtor_websocketsFrame *)doCopy __attribute__((swift_name("doCopy()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) TerminalGatewayKotlinByteArray *data __attribute__((swift_name("data")));
@property (readonly) id<TerminalGatewayKotlinx_coroutines_coreDisposableHandle> disposableHandle __attribute__((swift_name("disposableHandle")));
@property (readonly) BOOL fin __attribute__((swift_name("fin")));
@property (readonly) TerminalGatewayKtor_websocketsFrameType *frameType __attribute__((swift_name("frameType")));
@property (readonly) BOOL rsv1 __attribute__((swift_name("rsv1")));
@property (readonly) BOOL rsv2 __attribute__((swift_name("rsv2")));
@property (readonly) BOOL rsv3 __attribute__((swift_name("rsv3")));
@end

__attribute__((swift_name("Kotlinx_io_coreSource")))
@protocol TerminalGatewayKotlinx_io_coreSource <TerminalGatewayKotlinx_io_coreRawSource>
@required
- (BOOL)exhausted __attribute__((swift_name("exhausted()")));
- (id<TerminalGatewayKotlinx_io_coreSource>)peek __attribute__((swift_name("peek()")));
- (int32_t)readAtMostToSink:(TerminalGatewayKotlinByteArray *)sink startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("readAtMostTo(sink:startIndex:endIndex:)")));
- (int8_t)readByte __attribute__((swift_name("readByte()")));
- (int32_t)readInt __attribute__((swift_name("readInt()")));
- (int64_t)readLong __attribute__((swift_name("readLong()")));
- (int16_t)readShort __attribute__((swift_name("readShort()")));
- (void)readToSink:(id<TerminalGatewayKotlinx_io_coreRawSink>)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readTo(sink:byteCount:)")));
- (BOOL)requestByteCount:(int64_t)byteCount __attribute__((swift_name("request(byteCount:)")));
- (void)requireByteCount:(int64_t)byteCount __attribute__((swift_name("require(byteCount:)")));
- (void)skipByteCount:(int64_t)byteCount __attribute__((swift_name("skip(byteCount:)")));
- (int64_t)transferToSink:(id<TerminalGatewayKotlinx_io_coreRawSink>)sink __attribute__((swift_name("transferTo(sink:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) TerminalGatewayKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_io_coreBuffer")))
@interface TerminalGatewayKotlinx_io_coreBuffer : TerminalGatewayBase <TerminalGatewayKotlinx_io_coreSource, TerminalGatewayKotlinx_io_coreSink>
- (instancetype)init __attribute__((swift_name("init()"))) __attribute__((objc_designated_initializer));
+ (instancetype)new __attribute__((availability(swift, unavailable, message="use object initializers instead")));
- (void)clear __attribute__((swift_name("clear()")));
- (void)close __attribute__((swift_name("close()")));
- (TerminalGatewayKotlinx_io_coreBuffer *)doCopy __attribute__((swift_name("doCopy()")));
- (void)doCopyToOut:(TerminalGatewayKotlinx_io_coreBuffer *)out startIndex:(int64_t)startIndex endIndex:(int64_t)endIndex __attribute__((swift_name("doCopyTo(out:startIndex:endIndex:)")));
- (void)emit __attribute__((swift_name("emit()")));
- (BOOL)exhausted __attribute__((swift_name("exhausted()")));
- (void)flush __attribute__((swift_name("flush()")));
- (int8_t)getPosition:(int64_t)position __attribute__((swift_name("get(position:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
- (void)hintEmit __attribute__((swift_name("hintEmit()")));
- (id<TerminalGatewayKotlinx_io_coreSource>)peek __attribute__((swift_name("peek()")));
- (int64_t)readAtMostToSink:(TerminalGatewayKotlinx_io_coreBuffer *)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readAtMostTo(sink:byteCount:)")));
- (int32_t)readAtMostToSink:(TerminalGatewayKotlinByteArray *)sink startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("readAtMostTo(sink:startIndex:endIndex:)")));
- (int8_t)readByte __attribute__((swift_name("readByte()")));
- (int32_t)readInt __attribute__((swift_name("readInt()")));
- (int64_t)readLong __attribute__((swift_name("readLong()")));
- (int16_t)readShort __attribute__((swift_name("readShort()")));
- (void)readToSink:(id<TerminalGatewayKotlinx_io_coreRawSink>)sink byteCount:(int64_t)byteCount __attribute__((swift_name("readTo(sink:byteCount:)")));
- (BOOL)requestByteCount:(int64_t)byteCount __attribute__((swift_name("request(byteCount:)")));
- (void)requireByteCount:(int64_t)byteCount __attribute__((swift_name("require(byteCount:)")));
- (void)skipByteCount:(int64_t)byteCount __attribute__((swift_name("skip(byteCount:)")));
- (NSString *)description __attribute__((swift_name("description()")));
- (int64_t)transferFromSource:(id<TerminalGatewayKotlinx_io_coreRawSource>)source __attribute__((swift_name("transferFrom(source:)")));
- (int64_t)transferToSink:(id<TerminalGatewayKotlinx_io_coreRawSink>)sink __attribute__((swift_name("transferTo(sink:)")));
- (void)writeSource:(TerminalGatewayKotlinx_io_coreBuffer *)source byteCount:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount:)")));
- (void)writeSource:(id<TerminalGatewayKotlinx_io_coreRawSource>)source byteCount_:(int64_t)byteCount __attribute__((swift_name("write(source:byteCount_:)")));
- (void)writeSource:(TerminalGatewayKotlinByteArray *)source startIndex:(int32_t)startIndex endIndex:(int32_t)endIndex __attribute__((swift_name("write(source:startIndex:endIndex:)")));
- (void)writeByteByte:(int8_t)byte __attribute__((swift_name("writeByte(byte:)")));
- (void)writeIntInt:(int32_t)int_ __attribute__((swift_name("writeInt(int:)")));
- (void)writeLongLong:(int64_t)long_ __attribute__((swift_name("writeLong(long:)")));
- (void)writeShortShort:(int16_t)short_ __attribute__((swift_name("writeShort(short:)")));

/**
 * @note annotations
 *   kotlinx.io.InternalIoApi
*/
@property (readonly) TerminalGatewayKotlinx_io_coreBuffer *buffer __attribute__((swift_name("buffer")));
@property (readonly) int64_t size __attribute__((swift_name("size")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateProgression.Companion")))
@interface TerminalGatewayKotlinx_datetimeLocalDateProgressionCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeLocalDateProgressionCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeLocalDateRange.Companion")))
@interface TerminalGatewayKotlinx_datetimeLocalDateRangeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeLocalDateRangeCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) TerminalGatewayKotlinx_datetimeLocalDateRange *EMPTY __attribute__((swift_name("EMPTY")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimePadding")))
@interface TerminalGatewayKotlinx_datetimePadding : TerminalGatewayKotlinEnum<TerminalGatewayKotlinx_datetimePadding *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayKotlinx_datetimePadding *none __attribute__((swift_name("none")));
@property (class, readonly) TerminalGatewayKotlinx_datetimePadding *zero __attribute__((swift_name("zero")));
@property (class, readonly) TerminalGatewayKotlinx_datetimePadding *space __attribute__((swift_name("space")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKotlinx_datetimePadding *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKotlinx_datetimePadding *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeekNames")))
@interface TerminalGatewayKotlinx_datetimeDayOfWeekNames : TerminalGatewayBase
- (instancetype)initWithNames:(NSArray<NSString *> *)names __attribute__((swift_name("init(names:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithMonday:(NSString *)monday tuesday:(NSString *)tuesday wednesday:(NSString *)wednesday thursday:(NSString *)thursday friday:(NSString *)friday saturday:(NSString *)saturday sunday:(NSString *)sunday __attribute__((swift_name("init(monday:tuesday:wednesday:thursday:friday:saturday:sunday:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeDayOfWeekNamesCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *names __attribute__((swift_name("names")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonthNames")))
@interface TerminalGatewayKotlinx_datetimeMonthNames : TerminalGatewayBase
- (instancetype)initWithNames:(NSArray<NSString *> *)names __attribute__((swift_name("init(names:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithJanuary:(NSString *)january february:(NSString *)february march:(NSString *)march april:(NSString *)april may:(NSString *)may june:(NSString *)june july:(NSString *)july august:(NSString *)august september:(NSString *)september october:(NSString *)october november:(NSString *)november december:(NSString *)december __attribute__((swift_name("init(january:february:march:april:may:june:july:august:september:october:november:december:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeMonthNamesCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSArray<NSString *> *names __attribute__((swift_name("names")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=kotlinx/datetime/serializers/UtcOffsetSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeUtcOffset")))
@interface TerminalGatewayKotlinx_datetimeUtcOffset : TerminalGatewayBase
@property (class, readonly, getter=companion) TerminalGatewayKotlinx_datetimeUtcOffsetCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t totalSeconds __attribute__((swift_name("totalSeconds")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeFixedOffsetTimeZone.Companion")))
@interface TerminalGatewayKotlinx_datetimeFixedOffsetTimeZoneCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeFixedOffsetTimeZoneCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_serialization_jsonClassDiscriminatorMode")))
@interface TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode : TerminalGatewayKotlinEnum<TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode *none __attribute__((swift_name("none")));
@property (class, readonly) TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode *allJsonObjects __attribute__((swift_name("allJsonObjects")));
@property (class, readonly) TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode *polymorphic __attribute__((swift_name("polymorphic")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKotlinx_serialization_jsonClassDiscriminatorMode *> *entries __attribute__((swift_name("entries")));
@end


/**
 * @note annotations
 *   kotlinx.serialization.ExperimentalSerializationApi
*/
__attribute__((swift_name("Kotlinx_serialization_jsonJsonNamingStrategy")))
@protocol TerminalGatewayKotlinx_serialization_jsonJsonNamingStrategy
@required
- (NSString *)serialNameForJsonDescriptor:(id<TerminalGatewayKotlinx_serialization_coreSerialDescriptor>)descriptor elementIndex:(int32_t)elementIndex serialName:(NSString *)serialName __attribute__((swift_name("serialNameForJson(descriptor:elementIndex:serialName:)")));
@end

__attribute__((swift_name("Ktor_ioJvmSerializable")))
@protocol TerminalGatewayKtor_ioJvmSerializable
@required
@end


/**
 * Represents an immutable URL
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url)
 *
 * @property protocol
 * @property host name without port (domain)
 * @property port the specified port or protocol default port
 * @property specifiedPort port number that was specified to override protocol's default
 * @property encodedPath encoded path without query string
 * @property parameters URL query parameters
 * @property fragment URL fragment (anchor name)
 * @property user username part of URL
 * @property password password part of URL
 * @property trailingQuery keep trailing question character even if there are no query parameters
 *
 * @note annotations
 *   kotlinx.serialization.Serializable(with=NormalClass(value=io/ktor/http/UrlSerializer))
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpUrl")))
@interface TerminalGatewayKtor_httpUrl : TerminalGatewayBase <TerminalGatewayKtor_ioJvmSerializable>
@property (class, readonly, getter=companion) TerminalGatewayKtor_httpUrlCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *encodedFragment __attribute__((swift_name("encodedFragment")));
@property (readonly) NSString * _Nullable encodedPassword __attribute__((swift_name("encodedPassword")));
@property (readonly) NSString *encodedPath __attribute__((swift_name("encodedPath")));
@property (readonly) NSString *encodedPathAndQuery __attribute__((swift_name("encodedPathAndQuery")));
@property (readonly) NSString *encodedQuery __attribute__((swift_name("encodedQuery")));
@property (readonly) NSString * _Nullable encodedUser __attribute__((swift_name("encodedUser")));
@property (readonly) NSString *fragment __attribute__((swift_name("fragment")));
@property (readonly) NSString *host __attribute__((swift_name("host")));
@property (readonly) id<TerminalGatewayKtor_httpParameters> parameters __attribute__((swift_name("parameters")));
@property (readonly) NSString * _Nullable password __attribute__((swift_name("password")));

/**
 * A list containing the segments of the URL path.
 *
 * This property was designed to distinguish between absolute and relative paths,
 * so it will have an empty segment at the beginning for URLs with a hostname
 * and an empty segment at the end for URLs with a trailing slash.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.pathSegments == listOf("", "docs", "")
 *
 * val absolute = Url("/docs/")
 * absolute.pathSegments == listOf("", "docs", "")
 *
 * val relative = Url("docs")
 * relative.pathSegments == listOf("docs")
 * ```
 *
 * This behaviour may not be ideal if you're working only with full URLs.
 * If you don't require the specific handling of empty segments, consider using the [segments] property instead:
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 *
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * To address this issue, the current [pathSegments] property will be renamed to [rawSegments].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.pathSegments)
 */
@property (readonly) NSArray<NSString *> *pathSegments __attribute__((swift_name("pathSegments"))) __attribute__((deprecated("\n        `pathSegments` is deprecated.\n\n        This property will contain an empty path segment at the beginning for URLs with a hostname,\n        and an empty path segment at the end for the URLs with a trailing slash. If you need to keep this behaviour please\n        use [rawSegments]. If you only need to access the meaningful parts of the path, consider using [segments] instead.\n             \n        Please decide if you need [rawSegments] or [segments] explicitly.\n        ")));
@property (readonly) int32_t port __attribute__((swift_name("port")));
@property (readonly) TerminalGatewayKtor_httpURLProtocol *protocol __attribute__((swift_name("protocol")));
@property (readonly) TerminalGatewayKtor_httpURLProtocol * _Nullable protocolOrNull __attribute__((swift_name("protocolOrNull")));

/**
 * A list containing the segments of the URL path.
 *
 * This property is designed to distinguish between absolute and relative paths,
 * so it will have an empty segment at the beginning for URLs with a hostname
 * and an empty segment at the end for URLs with a trailing slash.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.rawSegments == listOf("", "docs", "")
 *
 * val absolute = Url("/docs/")
 * absolute.rawSegments == listOf("", "docs", "")
 *
 * val relative = Url("docs")
 * relative.rawSegments == listOf("docs")
 * ```
 *
 * This behaviour may not be ideal if you're working only with full URLs.
 * If you don't require the specific handling of empty segments, consider using the [segments] property instead:
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 *
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.rawSegments)
 */
@property (readonly) NSArray<NSString *> *rawSegments __attribute__((swift_name("rawSegments")));

/**
 * A list of path segments derived from the URL, excluding any leading
 * and trailing empty segments.
 *
 * ```kotlin
 * val fullUrl = Url("http://ktor.io/docs/")
 * fullUrl.segments == listOf("docs")
 *
 * val absolute = Url("/docs/")
 * absolute.segments == listOf("docs")
 * val relative = Url("docs")
 * relative.segments == listOf("docs")
 * ```
 *
 * If you need to check for trailing slash and relative/absolute paths, please check the [rawSegments] property.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Url.segments)
 **/
@property (readonly) NSArray<NSString *> *segments __attribute__((swift_name("segments")));
@property (readonly) int32_t specifiedPort __attribute__((swift_name("specifiedPort")));
@property (readonly) BOOL trailingQuery __attribute__((swift_name("trailingQuery")));
@property (readonly) NSString * _Nullable user __attribute__((swift_name("user")));
@end


/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpMethod")))
@interface TerminalGatewayKtor_httpHttpMethod : TerminalGatewayBase
- (instancetype)initWithValue:(NSString *)value __attribute__((swift_name("init(value:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_httpHttpMethodCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayKtor_httpHttpMethod *)doCopyValue:(NSString *)value __attribute__((swift_name("doCopy(value:)")));

/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents an HTTP method (verb)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod)
 *
 * @property value contains method name
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Provides data structure for associating a [String] with a [List] of Strings
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues)
 */
__attribute__((swift_name("Ktor_utilsStringValues")))
@protocol TerminalGatewayKtor_utilsStringValues
@required

/**
 * Checks if the given [name] exists in the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.contains)
 */
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));

/**
 * Checks if the given [name] and [value] pair exists in the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.contains)
 */
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));

/**
 * Gets all entries from the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.entries)
 */
- (NSSet<id<TerminalGatewayKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));

/**
 * Iterates over all entries in this map and calls [body] for each pair
 *
 * Can be optimized in implementations
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.forEach)
 */
- (void)forEachBody:(void (^)(NSString *, NSArray<NSString *> *))body __attribute__((swift_name("forEach(body:)")));

/**
 * Gets first value from the list of values associated with a [name], or null if the name is not present
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.get)
 */
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));

/**
 * Gets all values associated with the [name], or null if the name is not present
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.getAll)
 */
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));

/**
 * Checks if this map is empty
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.isEmpty)
 */
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));

/**
 * Gets all names from the map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.names)
 */
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));

/**
 * Specifies if map has case-sensitive or case-insensitive names
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.StringValues.caseInsensitiveName)
 */
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));
@end


/**
 * Represents HTTP headers as a map from case-insensitive names to collection of [String] values
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Headers)
 */
__attribute__((swift_name("Ktor_httpHeaders")))
@protocol TerminalGatewayKtor_httpHeaders <TerminalGatewayKtor_utilsStringValues>
@required
@end


/**
 * Information about the content to be sent to the peer, recognized by a client or server engine
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent)
 */
__attribute__((swift_name("Ktor_httpOutgoingContent")))
@interface TerminalGatewayKtor_httpOutgoingContent : TerminalGatewayBase

/**
 * Gets an extension property for this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.getProperty)
 */
- (id _Nullable)getPropertyKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key __attribute__((swift_name("getProperty(key:)")));

/**
 * Sets an extension property for this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.setProperty)
 */
- (void)setPropertyKey:(TerminalGatewayKtor_utilsAttributeKey<id> *)key value:(id _Nullable)value __attribute__((swift_name("setProperty(key:value:)")));

/**
 * Trailers to set when sending this content, will be ignored if request is not in HTTP2 mode
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.trailers)
 */
- (id<TerminalGatewayKtor_httpHeaders> _Nullable)trailers __attribute__((swift_name("trailers()")));

/**
 * Specifies content length in bytes for this resource.
 *
 * If null, the resources will be sent as `Transfer-Encoding: chunked`
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.contentLength)
 */
@property (readonly) TerminalGatewayLong * _Nullable contentLength __attribute__((swift_name("contentLength")));

/**
 * Specifies [ContentType] for this resource.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.contentType)
 */
@property (readonly) TerminalGatewayKtor_httpContentType * _Nullable contentType __attribute__((swift_name("contentType")));

/**
 * Headers to set when sending this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.headers)
 */
@property (readonly) id<TerminalGatewayKtor_httpHeaders> headers __attribute__((swift_name("headers")));

/**
 * Status code to set when sending this content
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.content.OutgoingContent.status)
 */
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode * _Nullable status __attribute__((swift_name("status")));
@end


/**
 * Represents an HTTP status code and description.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode)
 *
 * @param value is a numeric code.
 * @param description is free form description of a status.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpStatusCode")))
@interface TerminalGatewayKtor_httpHttpStatusCode : TerminalGatewayBase <TerminalGatewayKotlinComparable>
- (instancetype)initWithValue:(int32_t)value description:(NSString *)description __attribute__((swift_name("init(value:description:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_httpHttpStatusCodeCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TerminalGatewayKtor_httpHttpStatusCode *)other __attribute__((swift_name("compareTo(other:)")));
- (TerminalGatewayKtor_httpHttpStatusCode *)doCopyValue:(int32_t)value description:(NSString *)description __attribute__((swift_name("doCopy(value:description:)")));

/**
 * Returns a copy of `this` code with a description changed to [value].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.description)
 */
- (TerminalGatewayKtor_httpHttpStatusCode *)descriptionValue:(NSString *)value __attribute__((swift_name("description(value:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *description_ __attribute__((swift_name("description_")));
@property (readonly) int32_t value __attribute__((swift_name("value")));
@end


/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 *
 * @note annotations
 *   kotlinx.serialization.Serializable
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsGMTDate")))
@interface TerminalGatewayKtor_utilsGMTDate : TerminalGatewayBase <TerminalGatewayKotlinComparable>
- (instancetype)initWithSeconds:(int32_t)seconds minutes:(int32_t)minutes hours:(int32_t)hours dayOfWeek:(TerminalGatewayKtor_utilsWeekDay *)dayOfWeek dayOfMonth:(int32_t)dayOfMonth dayOfYear:(int32_t)dayOfYear month:(TerminalGatewayKtor_utilsMonth *)month year:(int32_t)year timestamp:(int64_t)timestamp __attribute__((swift_name("init(seconds:minutes:hours:dayOfWeek:dayOfMonth:dayOfYear:month:year:timestamp:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_utilsGMTDateCompanion *companion __attribute__((swift_name("companion")));
- (int32_t)compareToOther:(TerminalGatewayKtor_utilsGMTDate *)other __attribute__((swift_name("compareTo(other:)")));
- (TerminalGatewayKtor_utilsGMTDate *)doCopy __attribute__((swift_name("doCopy()")));
- (TerminalGatewayKtor_utilsGMTDate *)doCopySeconds:(int32_t)seconds minutes:(int32_t)minutes hours:(int32_t)hours dayOfWeek:(TerminalGatewayKtor_utilsWeekDay *)dayOfWeek dayOfMonth:(int32_t)dayOfMonth dayOfYear:(int32_t)dayOfYear month:(TerminalGatewayKtor_utilsMonth *)month year:(int32_t)year timestamp:(int64_t)timestamp __attribute__((swift_name("doCopy(seconds:minutes:hours:dayOfWeek:dayOfMonth:dayOfYear:month:year:timestamp:)")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Date in GMT timezone
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate)
 *
 * @property seconds: seconds from 0 to 60(last is for leap second)
 * @property minutes: minutes from 0 to 59
 * @property hours: hours from 0 to 23
 * @property dayOfWeek an instance of the corresponding day of week
 * @property dayOfMonth: day of month from 1 to 31
 * @property dayOfYear: day of year from 1 to 366
 * @property month an instance of the corresponding month
 * @property year: year in common era(CE: https://en.wikipedia.org/wiki/Common_Era)
 *
 * @property timestamp is a number of epoch milliseconds
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t dayOfMonth __attribute__((swift_name("dayOfMonth")));
@property (readonly) TerminalGatewayKtor_utilsWeekDay *dayOfWeek __attribute__((swift_name("dayOfWeek")));
@property (readonly) int32_t dayOfYear __attribute__((swift_name("dayOfYear")));
@property (readonly) int32_t hours __attribute__((swift_name("hours")));
@property (readonly) int32_t minutes __attribute__((swift_name("minutes")));
@property (readonly) TerminalGatewayKtor_utilsMonth *month __attribute__((swift_name("month")));
@property (readonly) int32_t seconds __attribute__((swift_name("seconds")));
@property (readonly) int64_t timestamp __attribute__((swift_name("timestamp")));
@property (readonly) int32_t year __attribute__((swift_name("year")));
@end


/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpProtocolVersion")))
@interface TerminalGatewayKtor_httpHttpProtocolVersion : TerminalGatewayBase
- (instancetype)initWithName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("init(name:major:minor:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_httpHttpProtocolVersionCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayKtor_httpHttpProtocolVersion *)doCopyName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("doCopy(name:major:minor:)")));

/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents an HTTP protocol version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion)
 *
 * @property name specifies name of the protocol, e.g. "HTTP".
 * @property major specifies protocol major version.
 * @property minor specifies protocol minor version.
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t major __attribute__((swift_name("major")));
@property (readonly) int32_t minor __attribute__((swift_name("minor")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
*/
__attribute__((swift_name("KotlinContinuation")))
@protocol TerminalGatewayKotlinContinuation
@required
- (void)resumeWithResult:(id _Nullable)result __attribute__((swift_name("resumeWith(result:)")));
@property (readonly) id<TerminalGatewayKotlinCoroutineContext> context __attribute__((swift_name("context")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.3")
 *   kotlin.ExperimentalStdlibApi
*/
__attribute__((swift_name("KotlinAbstractCoroutineContextKey")))
@interface TerminalGatewayKotlinAbstractCoroutineContextKey<B, E> : TerminalGatewayBase <TerminalGatewayKotlinCoroutineContextKey>
- (instancetype)initWithBaseKey:(id<TerminalGatewayKotlinCoroutineContextKey>)baseKey safeCast:(E _Nullable (^)(id<TerminalGatewayKotlinCoroutineContextElement>))safeCast __attribute__((swift_name("init(baseKey:safeCast:)"))) __attribute__((objc_designated_initializer));
@end


/**
 * @note annotations
 *   kotlin.ExperimentalStdlibApi
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_coroutines_coreCoroutineDispatcher.Key")))
@interface TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcherKey : TerminalGatewayKotlinAbstractCoroutineContextKey<id<TerminalGatewayKotlinContinuationInterceptor>, TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcher *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithBaseKey:(id<TerminalGatewayKotlinCoroutineContextKey>)baseKey safeCast:(id<TerminalGatewayKotlinCoroutineContextElement> _Nullable (^)(id<TerminalGatewayKotlinCoroutineContextElement>))safeCast __attribute__((swift_name("init(baseKey:safeCast:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
+ (instancetype)key __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_coroutines_coreCoroutineDispatcherKey *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Kotlinx_coroutines_coreRunnable")))
@protocol TerminalGatewayKotlinx_coroutines_coreRunnable
@required
- (void)run __attribute__((swift_name("run()")));
@end

__attribute__((swift_name("Ktor_utilsStringValuesBuilder")))
@protocol TerminalGatewayKtor_utilsStringValuesBuilder
@required
- (void)appendName:(NSString *)name value:(NSString *)value __attribute__((swift_name("append(name:value:)")));
- (void)appendAllStringValues:(id<TerminalGatewayKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendAll(stringValues:)")));
- (void)appendAllName:(NSString *)name values:(id)values __attribute__((swift_name("appendAll(name:values:)")));
- (void)appendMissingStringValues:(id<TerminalGatewayKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendMissing(stringValues:)")));
- (void)appendMissingName:(NSString *)name values:(id)values __attribute__((swift_name("appendMissing(name:values:)")));
- (id<TerminalGatewayKtor_utilsStringValues>)build __attribute__((swift_name("build()")));
- (void)clear __attribute__((swift_name("clear()")));
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<TerminalGatewayKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
- (void)removeName:(NSString *)name __attribute__((swift_name("remove(name:)")));
- (BOOL)removeName:(NSString *)name value:(NSString *)value __attribute__((swift_name("remove(name:value:)")));
- (void)removeKeysWithNoEntries __attribute__((swift_name("removeKeysWithNoEntries()")));
- (void)setName:(NSString *)name value:(NSString *)value __attribute__((swift_name("set(name:value:)")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));
@end

__attribute__((swift_name("Ktor_utilsStringValuesBuilderImpl")))
@interface TerminalGatewayKtor_utilsStringValuesBuilderImpl : TerminalGatewayBase <TerminalGatewayKtor_utilsStringValuesBuilder>
- (instancetype)initWithCaseInsensitiveName:(BOOL)caseInsensitiveName size:(int32_t)size __attribute__((swift_name("init(caseInsensitiveName:size:)"))) __attribute__((objc_designated_initializer));
- (void)appendName:(NSString *)name value:(NSString *)value __attribute__((swift_name("append(name:value:)")));
- (void)appendAllStringValues:(id<TerminalGatewayKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendAll(stringValues:)")));
- (void)appendAllName:(NSString *)name values:(id)values __attribute__((swift_name("appendAll(name:values:)")));
- (void)appendMissingStringValues:(id<TerminalGatewayKtor_utilsStringValues>)stringValues __attribute__((swift_name("appendMissing(stringValues:)")));
- (void)appendMissingName:(NSString *)name values:(id)values __attribute__((swift_name("appendMissing(name:values:)")));
- (id<TerminalGatewayKtor_utilsStringValues>)build __attribute__((swift_name("build()")));
- (void)clear __attribute__((swift_name("clear()")));
- (BOOL)containsName:(NSString *)name __attribute__((swift_name("contains(name:)")));
- (BOOL)containsName:(NSString *)name value:(NSString *)value __attribute__((swift_name("contains(name:value:)")));
- (NSSet<id<TerminalGatewayKotlinMapEntry>> *)entries __attribute__((swift_name("entries()")));
- (NSString * _Nullable)getName:(NSString *)name __attribute__((swift_name("get(name:)")));
- (NSArray<NSString *> * _Nullable)getAllName:(NSString *)name __attribute__((swift_name("getAll(name:)")));
- (BOOL)isEmpty_ __attribute__((swift_name("isEmpty()")));
- (NSSet<NSString *> *)names __attribute__((swift_name("names()")));
- (void)removeName:(NSString *)name __attribute__((swift_name("remove(name:)")));
- (BOOL)removeName:(NSString *)name value:(NSString *)value __attribute__((swift_name("remove(name:value:)")));
- (void)removeKeysWithNoEntries __attribute__((swift_name("removeKeysWithNoEntries()")));
- (void)setName:(NSString *)name value:(NSString *)value __attribute__((swift_name("set(name:value:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateNameName:(NSString *)name __attribute__((swift_name("validateName(name:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateValueValue:(NSString *)value __attribute__((swift_name("validateValue(value:)")));
@property (readonly) BOOL caseInsensitiveName __attribute__((swift_name("caseInsensitiveName")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) TerminalGatewayMutableDictionary<NSString *, NSMutableArray<NSString *> *> *values __attribute__((swift_name("values")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeadersBuilder")))
@interface TerminalGatewayKtor_httpHeadersBuilder : TerminalGatewayKtor_utilsStringValuesBuilderImpl
- (instancetype)initWithSize:(int32_t)size __attribute__((swift_name("init(size:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithCaseInsensitiveName:(BOOL)caseInsensitiveName size:(int32_t)size __attribute__((swift_name("init(caseInsensitiveName:size:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
- (id<TerminalGatewayKtor_httpHeaders>)build __attribute__((swift_name("build()")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateNameName:(NSString *)name __attribute__((swift_name("validateName(name:)")));

/**
 * @note This method has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
- (void)validateValueValue:(NSString *)value __attribute__((swift_name("validateValue(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpRequestBuilder.Companion")))
@interface TerminalGatewayKtor_client_coreHttpRequestBuilderCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_client_coreHttpRequestBuilderCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * A URL builder with all mutable components
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder)
 *
 * @property protocol URL protocol (scheme)
 * @property host name without port (domain)
 * @property port port number
 * @property user username part (optional)
 * @property password password part (optional)
 * @property pathSegments URL path without query
 * @property parameters URL query parameters
 * @property fragment URL fragment (anchor name)
 * @property trailingQuery keep a trailing question character even if there are no query parameters
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLBuilder")))
@interface TerminalGatewayKtor_httpURLBuilder : TerminalGatewayBase
- (instancetype)initWithProtocol:(TerminalGatewayKtor_httpURLProtocol * _Nullable)protocol host:(NSString *)host port:(int32_t)port user:(NSString * _Nullable)user password:(NSString * _Nullable)password pathSegments:(NSArray<NSString *> *)pathSegments parameters:(id<TerminalGatewayKtor_httpParameters>)parameters fragment:(NSString *)fragment trailingQuery:(BOOL)trailingQuery __attribute__((swift_name("init(protocol:host:port:user:password:pathSegments:parameters:fragment:trailingQuery:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_httpURLBuilderCompanion *companion __attribute__((swift_name("companion")));

/**
 * Build a [Url] instance (everything is copied to a new instance)
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder.build)
 */
- (TerminalGatewayKtor_httpUrl *)build __attribute__((swift_name("build()")));

/**
 * Build a URL string
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLBuilder.buildString)
 */
- (NSString *)buildString __attribute__((swift_name("buildString()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property NSString *encodedFragment __attribute__((swift_name("encodedFragment")));
@property id<TerminalGatewayKtor_httpParametersBuilder> encodedParameters __attribute__((swift_name("encodedParameters")));
@property NSString * _Nullable encodedPassword __attribute__((swift_name("encodedPassword")));
@property NSArray<NSString *> *encodedPathSegments __attribute__((swift_name("encodedPathSegments")));
@property NSString * _Nullable encodedUser __attribute__((swift_name("encodedUser")));
@property NSString *fragment __attribute__((swift_name("fragment")));
@property NSString *host __attribute__((swift_name("host")));
@property (readonly) id<TerminalGatewayKtor_httpParametersBuilder> parameters __attribute__((swift_name("parameters")));
@property NSString * _Nullable password __attribute__((swift_name("password")));
@property NSArray<NSString *> *pathSegments __attribute__((swift_name("pathSegments")));
@property int32_t port __attribute__((swift_name("port")));
@property TerminalGatewayKtor_httpURLProtocol *protocol __attribute__((swift_name("protocol")));
@property TerminalGatewayKtor_httpURLProtocol * _Nullable protocolOrNull __attribute__((swift_name("protocolOrNull")));
@property BOOL trailingQuery __attribute__((swift_name("trailingQuery")));
@property NSString * _Nullable user __attribute__((swift_name("user")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_client_coreHttpClientCall.Companion")))
@interface TerminalGatewayKtor_client_coreHttpClientCallCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_client_coreHttpClientCallCompanion *shared __attribute__((swift_name("shared")));
@end


/**
 * A request for [HttpClient], first part of [HttpClientCall].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest)
 */
__attribute__((swift_name("Ktor_client_coreHttpRequest")))
@protocol TerminalGatewayKtor_client_coreHttpRequest <TerminalGatewayKtor_httpHttpMessage, TerminalGatewayKotlinx_coroutines_coreCoroutineScope>
@required

/**
 * Typed [Attributes] associated to this call serving as a lightweight container.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.attributes)
 */
@property (readonly) id<TerminalGatewayKtor_utilsAttributes> attributes __attribute__((swift_name("attributes")));

/**
 * The associated [HttpClientCall] containing both
 * the underlying [HttpClientCall.request] and [HttpClientCall.response].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.call)
 */
@property (readonly) TerminalGatewayKtor_client_coreHttpClientCall *call __attribute__((swift_name("call")));

/**
 * An [OutgoingContent] representing the request body
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.content)
 */
@property (readonly) TerminalGatewayKtor_httpOutgoingContent *content __attribute__((swift_name("content")));

/**
 * The [HttpMethod] or HTTP VERB used for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.method)
 */
@property (readonly) TerminalGatewayKtor_httpHttpMethod *method __attribute__((swift_name("method")));

/**
 * The [Url] representing the endpoint and the uri for this request.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.client.request.HttpRequest.url)
 */
@property (readonly) TerminalGatewayKtor_httpUrl *url __attribute__((swift_name("url")));
@end


/**
 * A parsed `Sec-WebSocket-Accept` header item representation.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionHeader)
 *
 * @param name is extension name.
 * @param parameters is list of extension parameters.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsWebSocketExtensionHeader")))
@interface TerminalGatewayKtor_websocketsWebSocketExtensionHeader : TerminalGatewayBase
- (instancetype)initWithName:(NSString *)name parameters:(NSArray<NSString *> *)parameters __attribute__((swift_name("init(name:parameters:)"))) __attribute__((objc_designated_initializer));

/**
 * Parses parameters keys and values.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.WebSocketExtensionHeader.parseParameters)
 */
- (id<TerminalGatewayKotlinSequence>)parseParameters __attribute__((swift_name("parseParameters()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) NSArray<NSString *> *parameters __attribute__((swift_name("parameters")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_ioCharset.Companion")))
@interface TerminalGatewayKtor_ioCharsetCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_ioCharsetCompanion *shared __attribute__((swift_name("shared")));
- (TerminalGatewayKtor_ioCharset *)forNameName:(NSString *)name __attribute__((swift_name("forName(name:)")));
- (BOOL)isSupportedCharset:(NSString *)charset __attribute__((swift_name("isSupported(charset:)")));
@end

__attribute__((swift_name("Ktor_ioCharsetDecoder")))
@interface TerminalGatewayKtor_ioCharsetDecoder : TerminalGatewayBase
- (instancetype)initWith_charset:(TerminalGatewayKtor_ioCharset *)_charset __attribute__((swift_name("init(_charset:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("Ktor_ioCharsetEncoder")))
@interface TerminalGatewayKtor_ioCharsetEncoder : TerminalGatewayBase
- (instancetype)initWith_charset:(TerminalGatewayKtor_ioCharset *)_charset __attribute__((swift_name("init(_charset:)"))) __attribute__((objc_designated_initializer));
@end

__attribute__((swift_name("KotlinKType")))
@protocol TerminalGatewayKotlinKType
@required

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
@property (readonly) NSArray<TerminalGatewayKotlinKTypeProjection *> *arguments __attribute__((swift_name("arguments")));

/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
@property (readonly) id<TerminalGatewayKotlinKClassifier> _Nullable classifier __attribute__((swift_name("classifier")));
@property (readonly) BOOL isMarkedNullable __attribute__((swift_name("isMarkedNullable")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrame.Companion")))
@interface TerminalGatewayKtor_websocketsFrameCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_websocketsFrameCompanion *shared __attribute__((swift_name("shared")));

/**
 * Create a particular [Frame] instance by frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.Frame.Companion.byType)
 */
- (TerminalGatewayKtor_websocketsFrame *)byTypeFin:(BOOL)fin frameType:(TerminalGatewayKtor_websocketsFrameType *)frameType data:(TerminalGatewayKotlinByteArray *)data rsv1:(BOOL)rsv1 rsv2:(BOOL)rsv2 rsv3:(BOOL)rsv3 __attribute__((swift_name("byType(fin:frameType:data:rsv1:rsv2:rsv3:)")));
@end


/**
 * A WebSocket frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType)
 *
 * @property controlFrame if this is control frame type
 * @property opcode - frame type id that is used to transport it
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrameType")))
@interface TerminalGatewayKtor_websocketsFrameType : TerminalGatewayKotlinEnum<TerminalGatewayKtor_websocketsFrameType *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * A WebSocket frame type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType)
 *
 * @property controlFrame if this is control frame type
 * @property opcode - frame type id that is used to transport it
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKtor_websocketsFrameTypeCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayKtor_websocketsFrameType *text __attribute__((swift_name("text")));
@property (class, readonly) TerminalGatewayKtor_websocketsFrameType *binary __attribute__((swift_name("binary")));
@property (class, readonly) TerminalGatewayKtor_websocketsFrameType *close __attribute__((swift_name("close")));
@property (class, readonly) TerminalGatewayKtor_websocketsFrameType *ping __attribute__((swift_name("ping")));
@property (class, readonly) TerminalGatewayKtor_websocketsFrameType *pong __attribute__((swift_name("pong")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKtor_websocketsFrameType *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKtor_websocketsFrameType *> *entries __attribute__((swift_name("entries")));
@property (readonly) BOOL controlFrame __attribute__((swift_name("controlFrame")));
@property (readonly) int32_t opcode __attribute__((swift_name("opcode")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeDayOfWeekNames.Companion")))
@interface TerminalGatewayKotlinx_datetimeDayOfWeekNamesCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeDayOfWeekNamesCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) TerminalGatewayKotlinx_datetimeDayOfWeekNames *ENGLISH_ABBREVIATED __attribute__((swift_name("ENGLISH_ABBREVIATED")));
@property (readonly) TerminalGatewayKotlinx_datetimeDayOfWeekNames *ENGLISH_FULL __attribute__((swift_name("ENGLISH_FULL")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeMonthNames.Companion")))
@interface TerminalGatewayKotlinx_datetimeMonthNamesCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeMonthNamesCompanion *shared __attribute__((swift_name("shared")));
@property (readonly) TerminalGatewayKotlinx_datetimeMonthNames *ENGLISH_ABBREVIATED __attribute__((swift_name("ENGLISH_ABBREVIATED")));
@property (readonly) TerminalGatewayKotlinx_datetimeMonthNames *ENGLISH_FULL __attribute__((swift_name("ENGLISH_FULL")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Kotlinx_datetimeUtcOffset.Companion")))
@interface TerminalGatewayKotlinx_datetimeUtcOffsetCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinx_datetimeUtcOffsetCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)FormatBlock:(void (^)(id<TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset>))block __attribute__((swift_name("Format(block:)")));
- (TerminalGatewayKotlinx_datetimeUtcOffset *)parseInput:(id)input format:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("parse(input:format:)")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@property (readonly) TerminalGatewayKotlinx_datetimeUtcOffset *ZERO __attribute__((swift_name("ZERO")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpUrl.Companion")))
@interface TerminalGatewayKtor_httpUrlCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_httpUrlCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));
@end


/**
 * Represents HTTP parameters as a map from case-insensitive names to collection of [String] values
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.Parameters)
 */
__attribute__((swift_name("Ktor_httpParameters")))
@protocol TerminalGatewayKtor_httpParameters <TerminalGatewayKtor_utilsStringValues>
@required
@end


/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLProtocol")))
@interface TerminalGatewayKtor_httpURLProtocol : TerminalGatewayBase <TerminalGatewayKtor_ioJvmSerializable>
- (instancetype)initWithName:(NSString *)name defaultPort:(int32_t)defaultPort __attribute__((swift_name("init(name:defaultPort:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_httpURLProtocolCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayKtor_httpURLProtocol *)doCopyName:(NSString *)name defaultPort:(int32_t)defaultPort __attribute__((swift_name("doCopy(name:defaultPort:)")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents URL protocol
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol)
 *
 * @property name of protocol (schema)
 * @property defaultPort default port for protocol or `-1` if not known
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) int32_t defaultPort __attribute__((swift_name("defaultPort")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpMethod.Companion")))
@interface TerminalGatewayKtor_httpHttpMethodCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_httpHttpMethodCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parse HTTP method by [method] string
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod.Companion.parse)
 */
- (TerminalGatewayKtor_httpHttpMethod *)parseMethod:(NSString *)method __attribute__((swift_name("parse(method:)")));

/**
 * A list of default HTTP methods
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpMethod.Companion.DefaultMethods)
 */
@property (readonly) NSArray<TerminalGatewayKtor_httpHttpMethod *> *DefaultMethods __attribute__((swift_name("DefaultMethods")));
@property (readonly) TerminalGatewayKtor_httpHttpMethod *Delete __attribute__((swift_name("Delete")));
@property (readonly) TerminalGatewayKtor_httpHttpMethod *Get __attribute__((swift_name("Get")));
@property (readonly) TerminalGatewayKtor_httpHttpMethod *Head __attribute__((swift_name("Head")));
@property (readonly) TerminalGatewayKtor_httpHttpMethod *Options __attribute__((swift_name("Options")));
@property (readonly) TerminalGatewayKtor_httpHttpMethod *Patch __attribute__((swift_name("Patch")));
@property (readonly) TerminalGatewayKtor_httpHttpMethod *Post __attribute__((swift_name("Post")));
@property (readonly) TerminalGatewayKtor_httpHttpMethod *Put __attribute__((swift_name("Put")));
@end

__attribute__((swift_name("KotlinMapEntry")))
@protocol TerminalGatewayKotlinMapEntry
@required
@property (readonly) id _Nullable key __attribute__((swift_name("key")));
@property (readonly) id _Nullable value __attribute__((swift_name("value")));
@end


/**
 * Represents a header value that consist of [content] followed by [parameters].
 * Useful for headers such as `Content-Type`, `Content-Disposition` and so on.
 *
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters)
 *
 * @property content header's content without parameters
 * @property parameters
 */
__attribute__((swift_name("Ktor_httpHeaderValueWithParameters")))
@interface TerminalGatewayKtor_httpHeaderValueWithParameters : TerminalGatewayBase
- (instancetype)initWithContent:(NSString *)content parameters:(NSArray<TerminalGatewayKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(content:parameters:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKtor_httpHeaderValueWithParametersCompanion *companion __attribute__((swift_name("companion")));

/**
 * The first value for the parameter with [name] comparing case-insensitively or `null` if no such parameters found
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters.parameter)
 */
- (NSString * _Nullable)parameterName:(NSString *)name __attribute__((swift_name("parameter(name:)")));
- (NSString *)description __attribute__((swift_name("description()")));

/**
 * @note This property has protected visibility in Kotlin source and is intended only for use by subclasses.
*/
@property (readonly) NSString *content __attribute__((swift_name("content")));
@property (readonly) NSArray<TerminalGatewayKtor_httpHeaderValueParam *> *parameters __attribute__((swift_name("parameters")));
@end


/**
 * Represents a value for a `Content-Type` header.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType)
 *
 * @property contentType represents a type part of the media type.
 * @property contentSubtype represents a subtype part of the media type.
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpContentType")))
@interface TerminalGatewayKtor_httpContentType : TerminalGatewayKtor_httpHeaderValueWithParameters
- (instancetype)initWithContentType:(NSString *)contentType contentSubtype:(NSString *)contentSubtype parameters:(NSArray<TerminalGatewayKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(contentType:contentSubtype:parameters:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithContent:(NSString *)content parameters:(NSArray<TerminalGatewayKtor_httpHeaderValueParam *> *)parameters __attribute__((swift_name("init(content:parameters:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKtor_httpContentTypeCompanion *companion __attribute__((swift_name("companion")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Checks if `this` type matches a [pattern] type taking into account placeholder symbols `*` and parameters.
 * The `this` type must be a more specific type than the [pattern] type. In other words:
 *
 * ```kotlin
 * ContentType("a", "b").match(ContentType("a", "b").withParameter("foo", "bar")) === false
 * ContentType("a", "b").withParameter("foo", "bar").match(ContentType("a", "b")) === true
 * ContentType("a", "*").match(ContentType("a", "b")) === false
 * ContentType("a", "b").match(ContentType("a", "*")) === true
 * ```
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.match)
 */
- (BOOL)matchPattern:(TerminalGatewayKtor_httpContentType *)pattern __attribute__((swift_name("match(pattern:)")));

/**
 * Checks if `this` type matches a [pattern] type taking into account placeholder symbols `*` and parameters.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.match)
 */
- (BOOL)matchPattern_:(NSString *)pattern __attribute__((swift_name("match(pattern_:)")));

/**
 * Creates a copy of `this` type with the added parameter with the [name] and [value].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.withParameter)
 */
- (TerminalGatewayKtor_httpContentType *)withParameterName:(NSString *)name value:(NSString *)value __attribute__((swift_name("withParameter(name:value:)")));

/**
 * Creates a copy of `this` type without any parameters
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.withoutParameters)
 */
- (TerminalGatewayKtor_httpContentType *)withoutParameters __attribute__((swift_name("withoutParameters()")));
@property (readonly) NSString *contentSubtype __attribute__((swift_name("contentSubtype")));
@property (readonly) NSString *contentType __attribute__((swift_name("contentType")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpStatusCode.Companion")))
@interface TerminalGatewayKtor_httpHttpStatusCodeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_httpHttpStatusCodeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Creates an instance of [HttpStatusCode] with the given numeric value.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.Companion.fromValue)
 */
- (TerminalGatewayKtor_httpHttpStatusCode *)fromValueValue:(int32_t)value __attribute__((swift_name("fromValue(value:)")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Accepted __attribute__((swift_name("Accepted")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *BadGateway __attribute__((swift_name("BadGateway")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *BadRequest __attribute__((swift_name("BadRequest")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Conflict __attribute__((swift_name("Conflict")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Continue __attribute__((swift_name("Continue")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Created __attribute__((swift_name("Created")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *ExpectationFailed __attribute__((swift_name("ExpectationFailed")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *FailedDependency __attribute__((swift_name("FailedDependency")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Forbidden __attribute__((swift_name("Forbidden")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Found __attribute__((swift_name("Found")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *GatewayTimeout __attribute__((swift_name("GatewayTimeout")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Gone __attribute__((swift_name("Gone")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *InsufficientStorage __attribute__((swift_name("InsufficientStorage")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *InternalServerError __attribute__((swift_name("InternalServerError")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *LengthRequired __attribute__((swift_name("LengthRequired")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Locked __attribute__((swift_name("Locked")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *MethodNotAllowed __attribute__((swift_name("MethodNotAllowed")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *MovedPermanently __attribute__((swift_name("MovedPermanently")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *MultiStatus __attribute__((swift_name("MultiStatus")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *MultipleChoices __attribute__((swift_name("MultipleChoices")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *NoContent __attribute__((swift_name("NoContent")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *NonAuthoritativeInformation __attribute__((swift_name("NonAuthoritativeInformation")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *NotAcceptable __attribute__((swift_name("NotAcceptable")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *NotFound __attribute__((swift_name("NotFound")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *NotImplemented __attribute__((swift_name("NotImplemented")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *NotModified __attribute__((swift_name("NotModified")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *OK __attribute__((swift_name("OK")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *PartialContent __attribute__((swift_name("PartialContent")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *PayloadTooLarge __attribute__((swift_name("PayloadTooLarge")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *PaymentRequired __attribute__((swift_name("PaymentRequired")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *PermanentRedirect __attribute__((swift_name("PermanentRedirect")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *PreconditionFailed __attribute__((swift_name("PreconditionFailed")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Processing __attribute__((swift_name("Processing")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *ProxyAuthenticationRequired __attribute__((swift_name("ProxyAuthenticationRequired")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *RequestHeaderFieldTooLarge __attribute__((swift_name("RequestHeaderFieldTooLarge")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *RequestTimeout __attribute__((swift_name("RequestTimeout")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *RequestURITooLong __attribute__((swift_name("RequestURITooLong")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *RequestedRangeNotSatisfiable __attribute__((swift_name("RequestedRangeNotSatisfiable")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *ResetContent __attribute__((swift_name("ResetContent")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *SeeOther __attribute__((swift_name("SeeOther")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *ServiceUnavailable __attribute__((swift_name("ServiceUnavailable")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *SwitchProxy __attribute__((swift_name("SwitchProxy")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *SwitchingProtocols __attribute__((swift_name("SwitchingProtocols")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *TemporaryRedirect __attribute__((swift_name("TemporaryRedirect")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *TooEarly __attribute__((swift_name("TooEarly")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *TooManyRequests __attribute__((swift_name("TooManyRequests")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *Unauthorized __attribute__((swift_name("Unauthorized")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *UnprocessableEntity __attribute__((swift_name("UnprocessableEntity")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *UnsupportedMediaType __attribute__((swift_name("UnsupportedMediaType")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *UpgradeRequired __attribute__((swift_name("UpgradeRequired")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *UseProxy __attribute__((swift_name("UseProxy")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *VariantAlsoNegotiates __attribute__((swift_name("VariantAlsoNegotiates")));
@property (readonly) TerminalGatewayKtor_httpHttpStatusCode *VersionNotSupported __attribute__((swift_name("VersionNotSupported")));

/**
 * All known status codes
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpStatusCode.Companion.allStatusCodes)
 */
@property (readonly) NSArray<TerminalGatewayKtor_httpHttpStatusCode *> *allStatusCodes __attribute__((swift_name("allStatusCodes")));
@end


/**
 * Day of week
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsWeekDay")))
@interface TerminalGatewayKtor_utilsWeekDay : TerminalGatewayKotlinEnum<TerminalGatewayKtor_utilsWeekDay *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Day of week
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKtor_utilsWeekDayCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayKtor_utilsWeekDay *monday __attribute__((swift_name("monday")));
@property (class, readonly) TerminalGatewayKtor_utilsWeekDay *tuesday __attribute__((swift_name("tuesday")));
@property (class, readonly) TerminalGatewayKtor_utilsWeekDay *wednesday __attribute__((swift_name("wednesday")));
@property (class, readonly) TerminalGatewayKtor_utilsWeekDay *thursday __attribute__((swift_name("thursday")));
@property (class, readonly) TerminalGatewayKtor_utilsWeekDay *friday __attribute__((swift_name("friday")));
@property (class, readonly) TerminalGatewayKtor_utilsWeekDay *saturday __attribute__((swift_name("saturday")));
@property (class, readonly) TerminalGatewayKtor_utilsWeekDay *sunday __attribute__((swift_name("sunday")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKtor_utilsWeekDay *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKtor_utilsWeekDay *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end


/**
 * Month
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month)
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsMonth")))
@interface TerminalGatewayKtor_utilsMonth : TerminalGatewayKotlinEnum<TerminalGatewayKtor_utilsMonth *>
+ (instancetype)alloc __attribute__((unavailable));

/**
 * Month
 * [value] is 3 letter shortcut
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month)
 */
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly, getter=companion) TerminalGatewayKtor_utilsMonthCompanion *companion __attribute__((swift_name("companion")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *january __attribute__((swift_name("january")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *february __attribute__((swift_name("february")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *march __attribute__((swift_name("march")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *april __attribute__((swift_name("april")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *may __attribute__((swift_name("may")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *june __attribute__((swift_name("june")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *july __attribute__((swift_name("july")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *august __attribute__((swift_name("august")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *september __attribute__((swift_name("september")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *october __attribute__((swift_name("october")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *november __attribute__((swift_name("november")));
@property (class, readonly) TerminalGatewayKtor_utilsMonth *december __attribute__((swift_name("december")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKtor_utilsMonth *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKtor_utilsMonth *> *entries __attribute__((swift_name("entries")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsGMTDate.Companion")))
@interface TerminalGatewayKtor_utilsGMTDateCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_utilsGMTDateCompanion *shared __attribute__((swift_name("shared")));
- (id<TerminalGatewayKotlinx_serialization_coreKSerializer>)serializer __attribute__((swift_name("serializer()")));

/**
 * An instance of [GMTDate] corresponding to the epoch beginning
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.GMTDate.Companion.START)
 */
@property (readonly) TerminalGatewayKtor_utilsGMTDate *START __attribute__((swift_name("START")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHttpProtocolVersion.Companion")))
@interface TerminalGatewayKtor_httpHttpProtocolVersionCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_httpHttpProtocolVersionCompanion *shared __attribute__((swift_name("shared")));

/**
 * Creates an instance of [HttpProtocolVersion] from the given parameters.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.fromValue)
 */
- (TerminalGatewayKtor_httpHttpProtocolVersion *)fromValueName:(NSString *)name major:(int32_t)major minor:(int32_t)minor __attribute__((swift_name("fromValue(name:major:minor:)")));

/**
 * Create an instance of [HttpProtocolVersion] from http string representation.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.parse)
 */
- (TerminalGatewayKtor_httpHttpProtocolVersion *)parseValue:(id)value __attribute__((swift_name("parse(value:)")));

/**
 * HTTP/1.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_1_0)
 */
@property (readonly) TerminalGatewayKtor_httpHttpProtocolVersion *HTTP_1_0 __attribute__((swift_name("HTTP_1_0")));

/**
 * HTTP/1.1 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_1_1)
 */
@property (readonly) TerminalGatewayKtor_httpHttpProtocolVersion *HTTP_1_1 __attribute__((swift_name("HTTP_1_1")));

/**
 * HTTP/2.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_2_0)
 */
@property (readonly) TerminalGatewayKtor_httpHttpProtocolVersion *HTTP_2_0 __attribute__((swift_name("HTTP_2_0")));

/**
 * HTTP/3.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.HTTP_3_0)
 */
@property (readonly) TerminalGatewayKtor_httpHttpProtocolVersion *HTTP_3_0 __attribute__((swift_name("HTTP_3_0")));

/**
 * QUIC/1.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.QUIC)
 */
@property (readonly) TerminalGatewayKtor_httpHttpProtocolVersion *QUIC __attribute__((swift_name("QUIC")));

/**
 * SPDY/3.0 version.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HttpProtocolVersion.Companion.SPDY_3)
 */
@property (readonly) TerminalGatewayKtor_httpHttpProtocolVersion *SPDY_3 __attribute__((swift_name("SPDY_3")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLBuilder.Companion")))
@interface TerminalGatewayKtor_httpURLBuilderCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_httpURLBuilderCompanion *shared __attribute__((swift_name("shared")));
@end

__attribute__((swift_name("Ktor_httpParametersBuilder")))
@protocol TerminalGatewayKtor_httpParametersBuilder <TerminalGatewayKtor_utilsStringValuesBuilder>
@required
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKTypeProjection")))
@interface TerminalGatewayKotlinKTypeProjection : TerminalGatewayBase
- (instancetype)initWithVariance:(TerminalGatewayKotlinKVariance * _Nullable)variance type:(id<TerminalGatewayKotlinKType> _Nullable)type __attribute__((swift_name("init(variance:type:)"))) __attribute__((objc_designated_initializer));
@property (class, readonly, getter=companion) TerminalGatewayKotlinKTypeProjectionCompanion *companion __attribute__((swift_name("companion")));
- (TerminalGatewayKotlinKTypeProjection *)doCopyVariance:(TerminalGatewayKotlinKVariance * _Nullable)variance type:(id<TerminalGatewayKotlinKType> _Nullable)type __attribute__((swift_name("doCopy(variance:type:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) id<TerminalGatewayKotlinKType> _Nullable type __attribute__((swift_name("type")));
@property (readonly) TerminalGatewayKotlinKVariance * _Nullable variance __attribute__((swift_name("variance")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_websocketsFrameType.Companion")))
@interface TerminalGatewayKtor_websocketsFrameTypeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_websocketsFrameTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Finds [FrameType] instance by numeric [opcode].
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.websocket.FrameType.Companion.get)
 *
 * @return a [FrameType] instance or `null` of the [opcode] value is not valid
 */
- (TerminalGatewayKtor_websocketsFrameType * _Nullable)getOpcode:(int32_t)opcode __attribute__((swift_name("get(opcode:)")));
@end

__attribute__((swift_name("Kotlinx_datetimeDateTimeFormatBuilderWithUtcOffset")))
@protocol TerminalGatewayKotlinx_datetimeDateTimeFormatBuilderWithUtcOffset <TerminalGatewayKotlinx_datetimeDateTimeFormatBuilder>
@required
- (void)offsetFormat:(id<TerminalGatewayKotlinx_datetimeDateTimeFormat>)format __attribute__((swift_name("offset(format:)")));
- (void)offsetHoursPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetHours(padding:)")));
- (void)offsetMinutesOfHourPadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetMinutesOfHour(padding:)")));
- (void)offsetSecondsOfMinutePadding:(TerminalGatewayKotlinx_datetimePadding *)padding __attribute__((swift_name("offsetSecondsOfMinute(padding:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpURLProtocol.Companion")))
@interface TerminalGatewayKtor_httpURLProtocolCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_httpURLProtocolCompanion *shared __attribute__((swift_name("shared")));

/**
 * Create an instance by [name] or use already existing instance
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.createOrDefault)
 */
- (TerminalGatewayKtor_httpURLProtocol *)createOrDefaultName:(NSString *)name __attribute__((swift_name("createOrDefault(name:)")));

/**
 * HTTP with port 80
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.HTTP)
 */
@property (readonly) TerminalGatewayKtor_httpURLProtocol *HTTP __attribute__((swift_name("HTTP")));

/**
 * secure HTTPS with port 443
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.HTTPS)
 */
@property (readonly) TerminalGatewayKtor_httpURLProtocol *HTTPS __attribute__((swift_name("HTTPS")));

/**
 * Socks proxy url protocol.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.SOCKS)
 */
@property (readonly) TerminalGatewayKtor_httpURLProtocol *SOCKS __attribute__((swift_name("SOCKS")));

/**
 * Web socket over HTTP on port 80
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.WS)
 */
@property (readonly) TerminalGatewayKtor_httpURLProtocol *WS __attribute__((swift_name("WS")));

/**
 * Web socket over secure HTTPS on port 443
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.WSS)
 */
@property (readonly) TerminalGatewayKtor_httpURLProtocol *WSS __attribute__((swift_name("WSS")));

/**
 * Protocols by names map
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.URLProtocol.Companion.byName)
 */
@property (readonly) NSDictionary<NSString *, TerminalGatewayKtor_httpURLProtocol *> *byName __attribute__((swift_name("byName")));
@end


/**
 * Represents a single value parameter
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueParam)
 *
 * @property name of parameter
 * @property value of parameter
 * @property escapeValue specifies if the value should be escaped
 */
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeaderValueParam")))
@interface TerminalGatewayKtor_httpHeaderValueParam : TerminalGatewayBase
- (instancetype)initWithName:(NSString *)name value:(NSString *)value __attribute__((swift_name("init(name:value:)"))) __attribute__((objc_designated_initializer));
- (instancetype)initWithName:(NSString *)name value:(NSString *)value escapeValue:(BOOL)escapeValue __attribute__((swift_name("init(name:value:escapeValue:)"))) __attribute__((objc_designated_initializer));
- (TerminalGatewayKtor_httpHeaderValueParam *)doCopyName:(NSString *)name value:(NSString *)value escapeValue:(BOOL)escapeValue __attribute__((swift_name("doCopy(name:value:escapeValue:)")));
- (BOOL)isEqual:(id _Nullable)other __attribute__((swift_name("isEqual(_:)")));
- (NSUInteger)hash __attribute__((swift_name("hash()")));

/**
 * Represents a single value parameter
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueParam)
 *
 * @property name of parameter
 * @property value of parameter
 * @property escapeValue specifies if the value should be escaped
 */
- (NSString *)description __attribute__((swift_name("description()")));
@property (readonly) BOOL escapeValue __attribute__((swift_name("escapeValue")));
@property (readonly) NSString *name __attribute__((swift_name("name")));
@property (readonly) NSString *value __attribute__((swift_name("value")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpHeaderValueWithParameters.Companion")))
@interface TerminalGatewayKtor_httpHeaderValueWithParametersCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_httpHeaderValueWithParametersCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parse header with parameter and pass it to [init] function to instantiate particular type
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.HeaderValueWithParameters.Companion.parse)
 */
- (id _Nullable)parseValue:(NSString *)value init:(id _Nullable (^)(NSString *, NSArray<TerminalGatewayKtor_httpHeaderValueParam *> *))init __attribute__((swift_name("parse(value:init:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_httpContentType.Companion")))
@interface TerminalGatewayKtor_httpContentTypeCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_httpContentTypeCompanion *shared __attribute__((swift_name("shared")));

/**
 * Parses a string representing a `Content-Type` header into a [ContentType] instance.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.Companion.parse)
 */
- (TerminalGatewayKtor_httpContentType *)parseValue:(NSString *)value __attribute__((swift_name("parse(value:)")));

/**
 * Represents a pattern `* / *` to match any content type.
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.http.ContentType.Companion.Any)
 */
@property (readonly) TerminalGatewayKtor_httpContentType *Any __attribute__((swift_name("Any")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsWeekDay.Companion")))
@interface TerminalGatewayKtor_utilsWeekDayCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_utilsWeekDayCompanion *shared __attribute__((swift_name("shared")));

/**
 * Lookup an instance by [ordinal]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay.Companion.from)
 */
- (TerminalGatewayKtor_utilsWeekDay *)fromOrdinal:(int32_t)ordinal __attribute__((swift_name("from(ordinal:)")));

/**
 * Lookup an instance by short week day name [WeekDay.value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.WeekDay.Companion.from)
 */
- (TerminalGatewayKtor_utilsWeekDay *)fromValue:(NSString *)value __attribute__((swift_name("from(value:)")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("Ktor_utilsMonth.Companion")))
@interface TerminalGatewayKtor_utilsMonthCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKtor_utilsMonthCompanion *shared __attribute__((swift_name("shared")));

/**
 * Lookup an instance by [ordinal]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month.Companion.from)
 */
- (TerminalGatewayKtor_utilsMonth *)fromOrdinal:(int32_t)ordinal __attribute__((swift_name("from(ordinal:)")));

/**
 * Lookup an instance by short month name [Month.value]
 *
 * [Report a problem](https://ktor.io/feedback/?fqname=io.ktor.util.date.Month.Companion.from)
 */
- (TerminalGatewayKtor_utilsMonth *)fromValue:(NSString *)value __attribute__((swift_name("from(value:)")));
@end


/**
 * @note annotations
 *   kotlin.SinceKotlin(version="1.1")
*/
__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKVariance")))
@interface TerminalGatewayKotlinKVariance : TerminalGatewayKotlinEnum<TerminalGatewayKotlinKVariance *>
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
- (instancetype)initWithName:(NSString *)name ordinal:(int32_t)ordinal __attribute__((swift_name("init(name:ordinal:)"))) __attribute__((objc_designated_initializer)) __attribute__((unavailable));
@property (class, readonly) TerminalGatewayKotlinKVariance *invariant __attribute__((swift_name("invariant")));
@property (class, readonly) TerminalGatewayKotlinKVariance *in __attribute__((swift_name("in")));
@property (class, readonly) TerminalGatewayKotlinKVariance *out __attribute__((swift_name("out")));
+ (TerminalGatewayKotlinArray<TerminalGatewayKotlinKVariance *> *)values __attribute__((swift_name("values()")));
@property (class, readonly) NSArray<TerminalGatewayKotlinKVariance *> *entries __attribute__((swift_name("entries")));
@end

__attribute__((objc_subclassing_restricted))
__attribute__((swift_name("KotlinKTypeProjection.Companion")))
@interface TerminalGatewayKotlinKTypeProjectionCompanion : TerminalGatewayBase
+ (instancetype)alloc __attribute__((unavailable));
+ (instancetype)allocWithZone:(struct _NSZone *)zone __attribute__((unavailable));
+ (instancetype)companion __attribute__((swift_name("init()")));
@property (class, readonly, getter=shared) TerminalGatewayKotlinKTypeProjectionCompanion *shared __attribute__((swift_name("shared")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (TerminalGatewayKotlinKTypeProjection *)contravariantType:(id<TerminalGatewayKotlinKType>)type __attribute__((swift_name("contravariant(type:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (TerminalGatewayKotlinKTypeProjection *)covariantType:(id<TerminalGatewayKotlinKType>)type __attribute__((swift_name("covariant(type:)")));

/**
 * @note annotations
 *   kotlin.jvm.JvmStatic
*/
- (TerminalGatewayKotlinKTypeProjection *)invariantType:(id<TerminalGatewayKotlinKType>)type __attribute__((swift_name("invariant(type:)")));
@property (readonly) TerminalGatewayKotlinKTypeProjection *STAR __attribute__((swift_name("STAR")));
@end

#pragma pop_macro("_Nullable_result")
#pragma clang diagnostic pop
NS_ASSUME_NONNULL_END
